#	Copyright (c) 1990 UNIX System Laboratories, Inc.
#	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF
#	UNIX System Laboratories, Inc.
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)login:login.mk	1.6.11.3"

ROOT =

BUS = AT386

#	Where MAINS are to be installed.
INSDIR = $(ROOT)/usr/bin

INC = $(ROOT)/usr/include
INCSYS = $(ROOT)/usr/include

INS = install

LIMITED = -DLIMITED
CONS = -DCONSOLE='"/dev/console"' -DSECURITY $(LIMITED)
CFLAGS = $(CONS) -O -I$(INC) -I$(INCSYS) -D$(BUS)

#	Common Libraries not found in /lib or /usr/lib.
COMLIB = 

#	Common Libraries and -l<lib> flags.
LDFLAGS = -s  $(COMLIB) -lcmd -lgen -lcrypt_i

STRIP = strip

#top#
# Generated by makefile 1.43    Mon Jan 14 09:39:34 EST 1985

MAKEFILE = login.mk

MAINS = login license

OBJECTS =  login.o rcmd.o license.o

SOURCES =  login.c licence.c

ALL:		$(MAINS)

login:		login.o	rcmd.o
	$(CC) $(CFLAGS)  -o login  login.o rcmd.o $(LDFLAGS) $(PERFLIBS)

license:	license.o
	$(CC) $(CFLAGS) -o license license.o $(LDFLAGS)

login.o:	 $(INCSYS)/sys/types.h $(INC)/unistd.h \
		 $(INC)/utmpx.h $(INC)/lastlog.h \
		 $(INC)/signal.h $(INCSYS)/sys/signal.h \
		 $(INC)/pwd.h $(INC)/stdio.h \
		 $(INCSYS)/sys/stat.h $(INC)/dirent.h $(INCSYS)/sys/dirent.h \
		 $(INCSYS)/sys/utsname.h $(INCSYS)/sys/param.h \
		 $(INC)/errno.h $(INCSYS)/sys/errno.h \
		 $(INC)/utime.h \
		 $(INC)/deflt.h \
		 $(INC)/fcntl.h 

rcmd.o:
	$(CC) -DSYSV -O -I$(INC) -I$(INCSYS) -c rcmd.c

login.o:	 $(INCSYS)/sys/types.h $(INC)/unistd.h \
	$(INC)/signal.h $(INC)/stdio.h $(INC)/dirent.h $(INCSYS)/sys/dirent.h \
	$(INCSYS)/sys/errno.h $(INCSYS)/sys/param.h \
	$(INCSYS)/sys/signal.h $(INCSYS)/sys/stat.h \
	$(INCSYS)/sys/types.h $(INCSYS)/sys/utsname.h \
	$(INC)/utmpx.h $(INC)/lastlog.h $(INC)/utime.h 


clean:
	rm -f $(OBJECTS)
	
clobber:	
	rm -f $(OBJECTS) $(MAINS)

newmakefile:
	makefile -m -f $(MAKEFILE) -s INC $(INC)
#bottom#

save:
	cd $(INSDIR); set -x; for m in $(MAINS); do  cp $$m OLD$$m; done

restore:
	cd $(INSDIR); set -x; for m in $(MAINS); do; cp OLD$$m $$m; done

install:	$(MAINS) $(INSDIR)
	$(INS) -f $(INSDIR) -m 04555 -u root -g bin login
	$(INS) -f $(INSDIR) -m 555 -u bin -g bin license
	-mkdir ./tmp
	-ln login.dfl ./tmp/login
	$(INS) -f $(ROOT)/etc/default -m 0444 -u root -g sys ./tmp/login
	rm -rf ./tmp
 

strip:
	$(STRIP) $(MAINS)

remove:
	cd $(INSDIR);  rm -f $(MAINS)

$(INSDIR):
	mkdir $(INSDIR);  chmod 755 $(INSDIR);  chown bin $(INSDIR)

partslist:
	@echo $(MAKEFILE) $(LOCALINCS) $(SOURCES)  |  tr ' ' '\012'  |  sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
		sed -e 's;^;$(INSDIR)/;' -e 's;//*;/;g'

productdir:
	@echo $(INSDIR)

srcaudit:	# will not report missing nor present object or product files.
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS)
