/*	Copyright (c) 1990 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/


#ident	"@(#)xt:xtstats.c	2.4.3.1"

/*
**	Routine to print 'xt' driver statistics
*/

#include	"stdio.h"
#include	"errno.h"
#ifdef SVR32
#include	"sys/patch.h"
#endif /* SVR32 */
#include	"sys/types.h"
#include	"sys/tty.h"
#include	"sys/jioctl.h"
#include 	"sys/stream.h"
#include	"sys/nxtproto.h"
#include	"sys/nxt.h"	/* defines XTRACES and XTSTATS to be 1 	     */

#define Fprintf (void)fprintf	/* convenient define to avoid repetition     */

#if	XTSTATS == 1
Stats_t		Stats[S_NSTATS];

char *		Descs[S_NSTATS]	=
{
	 "packets transmitted"
	,"packets received"
	,"CRC errors"
	,"bad ack"
	,"bad nak"
	,"packets out of sequence"
	,"retransmissions generated by naks"
	,"duplicate packets received"
	,"naks received"
	,"naks transmitted"
	,"acks received"
	,"acks transmitted"
	,"packets with bad headers"
	,"packets with bad size"
	,"acks not received"
	,"bad control packets"
	,"bad control data packets"
	,"system free list empty"
	,"received packets with command size/data size mismatch"
	,"received packets with channel out of range"
	,"received packets with unrecognised command"
	,"channel 0 receive buffer unavailable for command"
	,"receive packets terminated by timeout"
	,"retransmissions generated by timeouts"
	,"wakeups for wflushes"
	,"wakeups for writes"
};

extern long		time();
extern char 		*ctime();

#define	SYSERROR	(-1)
#endif



int
xtstats(outfp)
register FILE *outfp;	/* file pointer of the output file	     */
{
#if	XTSTATS == 1
	register long	statval;/* the value of the statistics being disp'ed */
	register int	i;	/* index into Stats array		     */
	register int	count = 0; /* indicates if any statistics was logged */ 


	/* It is assumed that an XTIOCSTATS ioctl with parameter Stats
	 * has been done by the calling routine before xtstats() is called.
	 *
	 * Each index of the Stats buffer indicates a particular type of
	 * statistics and its contents indicate the value logged for that.
	 */

	for ( i = 0; i < S_NSTATS; i++ )
		if ( statval = Stats[i] ) {
			/* If there is any statistics, display a header      */
			if ( count++ == 0 ) { 
				long	t;  /* current time  		     */

				(void)time(&t);
				(void)fprintf(outfp, "\n%15.15s XT Statistics:-\n", ctime(&t)+4);
			}
			/* display the description of the type of statistics */
			/* being displayed along with its value		     */

			(void)fprintf(outfp, "%11ld %s\n", statval, Descs[i]);
		}
	if ( count ) /* If there was any stats info, flush it out	     */
		(void)fflush(outfp);
	return(0);
#endif
}
