#include <unistd.h>
#include "proc.h"

void sub1(PID *pid);
void sub2(PID *pid);

#define WSSIZ 200
#define SUBPRI 3

PID mpid, s1pid, s2pid;
char s1ws[WSSIZ], s2ws[WSSIZ];
char hex2seg[]={0x7e,0x30,0x6d,0x79,0x33,0x53,0x5f,0x70,0x7f,0x73,0x77,
	0x1f,0x4e,0x3d,0x4f,0x47};

int main (void) {
	procInitialize(&mpid, 4);
	proc_maxage = 10;
	timerInit();
	procCreateProcess(&s1pid, sub1, SUBPRI, &s1ws[0], WSSIZ, 0);
	procCreateProcess(&s2pid, sub2, SUBPRI, &s2ws[0], WSSIZ, 0);
	*(int *)0xff66=0x0040; /* timer irq enable */
	for(;;) {
		procReschedule();
	}
}

int segdata(int bin) {
  return hex2seg[bin&0x0f];
}

void sub1(PID *pid)
{
	int i=0;
	for(;;){
		*(int *)0xff6a =segdata(i);
		*(int *)0xff6c =segdata(i>>4);
		timerWait(127);
		i++;
	}
}

void sub2(PID *pid)
{
	int i=0;
	for(;;){
		*(int *)0xff68 =i;
		timerWait(163);
		i++;
	}
}
