/******************** MODULE INFO  ****************************/
/*
**  File name   :  queue2.c
*/
/*  AUTHOR      :  Jan Erik Nilsen (jen@nilsenelektronikk.no) */
/*  VERSION     :  3.0                                        */
/*  DATE        :  Tue Jul 27 08:56:44 1999                   */
/*
*   Compiler    :  ANSI C
*   Project     :  proc  Real-Time Kernel
*   Functions   :  Extention for queue.c - queue functions.
*                  Non-blocking i/o functions.
*   Constants   :  see queue.h
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*/
#include "proc.h"
#include "queue.h"


extern int proc_runcnt;



/*===========  queueIfPut  ================================
*
*   Purpose:      If the queue is not full then
*                 put a pointer into the queue.
*                 If the queue was empty, return 2.
*                 If the queue was not full, return 1.
*                 If the queue was full, return 0.
*
*                 The interrupt is not enabled nor disabled during
*                 the execution. The user is suggested to disable
*                 the interrupt before use.
*
*                 The function is intended for interrupt-driven
*                 receive handles.
*
*   Input:        ptr to queue
*                 ptr to x
*   Output:       none
*   Return:       Full: 0, Not full: 1 Empty: 2.
*
*/
int queueIfPut(QUEUE *qp, char *x)
{
  int i;

  if (qp->left.value > 0) {
    qp->left.value--;
    if ((i = (qp->ii + 1)) >= qp->size) i = 0;
    qp->fifo[i] = x;
    qp->ii = i;
    return(procSemSignalCareful(&(qp->used)) + 1);
  }
  return(0);
}



/*===========  queueIfGet  ===============================
*
*   Purpose:      If the queue is not empty then output a
*                 pointer from the queue to the user.
*                 If the queue was empty, return 0.
*                 If the queue was not full, return 1.
*                 If the queue was full, return 2.
*
*                 The interrupt is not enabled nor disabled during
*                 the execution. The user is suggested to disable
*                 the interrupt before use.
*
*                 The function is intended for interrupt-driven
*                 transmit handles.
*
*   Input:        ptr to queue
*                 ptr to pointer x
*   Output:       pointer from the queue
*   Return:       Empty: 0, Not full: 1 Full: 2.
*
*/
int queueIfGet(QUEUE *qp, char **xp)
{
  int i;

  if (qp->used.value > 0) {
    qp->used.value--;
    if ((i = (qp->oi + 1)) >= qp->size) i = 0;
    *xp = qp->fifo[i];
    qp->oi = i;
    return(procSemSignalCareful(&(qp->left)) + 1);
  }
  return(0);
}
