/******************** HEADER INFO  ****************************
*
*   File name   :  timer.h
*/
/*  DATE        :  Tue Jul 27 08:56:44 1999                   */
/*  AUTHOR      :  Jan Erik Nilsen (jen@nilsenelektronikk.no) */
/*  VERSION     :  3.0                                        */
/*
*   Compiler    :  ANSI C
*
*   Contents    :  Prototypes and defines for
*                  timer functions
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*/

#ifndef TIMER_H
#define TIMER_H
#include "chan.h"

struct timer_type {          /* Event timer type */
  struct timer_type *next;   /* ptr to next      */
  struct chan_type  *chan;   /* ptr to CHANnel   */
  int               timer;   /* timer value      */
  int               x;       /* signal value     */
};

typedef struct timer_type    TIMER;


void timerInit(void);
void timerStart(TIMER *tp, int time, int x);
int  timerStop(TIMER *tp);
void timerWait(int n);
int  timerCheckList(void);
#endif
