/******************* FILE - HEADING **************************
*
*   File name	:  packetf.c
*/
/*  DATE        :  Tue Jul 27 08:56:44 1999                   */
/*  AUTHOR      :  Jan Erik Nilsen (jen@nilsenelektronikk.no) */
/*  VERSION     :  3.0                                        */
/*
*   Compiler    :  ANSI C
*   Project     :  proc  Real-Time Kernel
*   Contents	:  packet FIFO list functions
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*/
#define  NULL (void *)0
#include "proc.h"
#include "packet.h"



/*===========  packetTo  ================================
*
*   Purpose:      A packet, allocated from the pool,
*                 is put into the end of a linked list
*                 using an end ptr.
*
*   Input:        ptr to PACKET_DPTRS
*                 packet ptr
*   Output:       none
*   Return:       none (never fails)
*
*/
void packetTo(PACKET_DPTRS *dpp, PACKET *pp)
{
#ifdef REINT
  int sr;
#endif
  disable_interrupt();
  pp->next = NULL;
  if (dpp->front == NULL) dpp->front = pp;
  else  dpp->back->next = pp;
  dpp->back = pp;
  enable_interrupt();
}




/*===========  packetFrom  ================================
*
*   Purpose:      A packet, allocated from the pool,
*                 is removed from the front a linked list.
*                 If the list was empty, NULL is returned.
*
*   Input:        ptr to PACKET_DPTRS
*   Output:       none
*   Return:       ptr to packet. NULL if empty list.
*
*/
PACKET *packetFrom(PACKET_DPTRS *dpp)
{
  PACKET *pp;
#ifdef REINT
  int    sr;
#endif

  disable_interrupt();
  pp = dpp->front;
  if (pp != NULL) dpp->front = pp->next;
  enable_interrupt();
  return(pp);
}
