/******************** HEADER INFO  ****************************
*
*   File name   :  packet.h
*/
/*  DATE        :  Thu May 18 23:41:58 2000                   */
/*  AUTHOR      :  Jan Erik Nilsen (jen@nilsenelektronikk.no) */
/*  VERSION     :  3.0                                        */
/*
*   Compiler    :  ANSI C
*
*   Contents    :  Definitions and Prototypes for
*                  packet.c
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*    Jan Erik Nilsen May 18. 2000:
*      ALIGN introduced. Some re-writing. See packet.c
*/


#ifndef PACKET_DEFINED
#define PACKET_DEFINED 1

#include "queue.h"

typedef struct packetpool {
  int       packetsize;       /* size (bytes) of a packet */
  int       packetnum;        /* number of packets        */
  int       packetmsgsize;    /* net size of a packet     */
  int       packetusedmax;    /* statistics: max pk used  */
  struct packet *packetstart; /* ptr to the 1th packet    */
  SEMAPHORE packetleft;       /* pool empty semaphore     */
} PACKETPOOL;


typedef struct packet {
  struct packet     *next;    /* ptr to next              */
  struct packetpool *ppool;   /* ptr to home pool         */
  int               kind;     /* packet kind              */
  int               length;   /* data length              */
  char              data[2];  /* data buffer              */
} PACKET;


typedef struct packet_head {
  struct packet     *next;    /* ptr to next              */
  struct packetpool *ppool;   /* ptr to home pool         */
  int               kind;     /* packet kind              */
  int               length;   /* data length              */
} PACKET_HEAD;   /* Equal PACKET, but data[2]             */



struct packet_dptrs {
  struct packet  *front;       /* front ptr      */
  struct packet  *back;        /* end ptr        */
};

typedef struct packet_dptrs PACKET_DPTRS;


PACKETPOOL *packetInitPool(char *ppool, int ppsize, int msgsize);
PACKET *packetAlloc(PACKETPOOL *h);
void packetFree(PACKET *pp);
int packetInPool(PACKET *pp);
int packetsUsed(PACKETPOOL *h);
int packetsLeft(PACKETPOOL *h);
int packetsUsedMax(PACKETPOOL *h);
void packetPut(QUEUE *qp, PACKET *pp);
PACKET *packetGet(QUEUE *qp);
int packetIfPut(QUEUE *qp, PACKET *pp);
int packetIfGet(QUEUE *qp, PACKET **ppp);
void packetTo(PACKET_DPTRS *dpp, PACKET *pp);
PACKET *packetFrom(PACKET_DPTRS *dpp);
#endif
