/
/ loader for algol68s run-time routines
/
/ this program loads a file containing a core image of the rte for
/ algol68s and executes it.
/
/ 1) if the variable "where" in this program has the value -1, then
/    the rte is found in file /etc/a68rte and is read from there
/    using regular unix i/o.
/ 2) if "where" has a zero or positive value, then the rte is to be
/    found in contiguous blocks starting with block "where" on the
/    device specified by the raw i/o name given by variable "which".  in
/    this case, the segment overlaying can be performed significantly
/    faster.
/
/ as distributed, variable "where" has a value of -1, so to simply
/ get the thing to run, just copy the compiler core image file to
/ /etc/a68rte
/
/ since the rte occupies less than 48k bytes of memory, the object file
/ is loaded permanently into memory and hence we are not too concerned as to
/ whether it is stored contiguously or not.
/
/ as the unix user cannot alter the core image file containing the rte, the
/ ability is given him to provide his own i/o support in this loader
/ routine.  when the rte is called, r5 must point to a list containing:
/	+0	2	addr of channel handler routine
/			(not yet supported)
/	+2	2	addr of open routine
/	+4	2	addr of seek routine
/	+6	2	addr of read routine
/	+8	2	addr of write routine
/	+10	2	addr of close routine
/ the channel handler routine is called for all channels except tichan,
/ tochan, and lpchan whiwh use the standard unix input and output files.
/ the channel handler is called exactly as the standard alggol68 channel
/ handlers except that the local field s.local contains a number identifying
/ which channel is being called.
/ the channel handler must return through rts pc .
/ the other routines are called via jsr r5 but are passed exactly the same
/ arguments as the unix system calls of the same name and must return the
/ same values (including setting the carry bit on error).
/
/ the entry point to the rte can be found in the word at +16 (base 8) in
/ the first block of the rte core image file.  the size of the core image
/ is contained in the word at +22 (base 8).
/
/ written  by  howard j. ferch,
/   dept. of computer science,
/   university of manitoba,
/   october, 1977.
/
/ no guarantees are made as to the correct operation of this program, or
/ the associated rte core image.
/
/ This program has been modified in order to run
/ under UNIX V7.
/ Main change is difference between the various seeks.
/ Also the raw interface to the run time system has been
/ commented out -- very serious algol users (do they exist)
/ should consider reinstating it.
/ To run under V7 the variables V7 and V6 should be set
/ to 1 and 0 resp., for V6 operation use your imagination.
/
/  ben salama, october 1980.
/
/	Modded to work with S5 sys open (extra param), ANW, June 1984
/

.V7 = 1
.V6 = 0
.if .V7
indir	= 0.
exit	= 1.
fork	= 2.
read	= 3.
write	= 4.
open	= 5.
close	= 6.
wait	= 7.
creat	= 8.
link	= 9.
unlink	= 10.
exec	= 11.
chdir	= 12.
time	= 13.
mknod	= 14.
chmod	= 15.
chown	= 16.
break	= 17.
stat	= 18.
lseek	= 19.
getpid	= 20.
mount	= 21.
umount	= 22.
setuid	= 23.
getuid	= 24.
stime	= 25.
ptrace	= 26.
alarm	= 27.
fstat	= 28.
pause	= 29.
utime	= 30.
smdate	= 30.
stty	= 31.
gtty	= 32.
access	= 33.
nice	= 34.
sleep	= 35.
sync	= 36.
kill	= 37.
csw	= 38.
setpgrp = 39.
dup	= 41.
pipe	= 42.
times	= 43.
profil	= 44.
setgid	= 46.
getgid	= 47.
signal	= 48.
acct	= 51.
phys	= 52.
lock	= 53.
ioctl	= 54.
reboot	= 55.
mpx	= 56.
setinf	= 59.
umask	= 60.
getinf	= 60.
.endif
nop	= 240

enter:	jmp	reale		/ leave room for block 0
.=.+508.
reale:	mov	sp,r4		/ save stack pointer
	mov	$p2end,r1
	sub	$p2,r1		/ len of res. part of this prog.
	add	$1200.,r1	/ plus stack space (recur str take much room)
	sub	r1,sp
	clr	*sp		/ allocate room in stack for p2
	mov	sp,p2wh		/ addr of rel part
	mov	r4,sp		/ restore stack
	tst	where		/ raw or regular load?
	bpl	raw		/ do raw open
	sys	open; aci; 0	/ open rte core image
	nop			/ room for extra param in S5
	bcc	comr
2:	mov	$2,r0
	sys	write; uop; 24. / cant open rte
	sys	exit
comr:	mov	r0,rtefd	/ save file desc for overlay loads
	sys	read; 0
a512:	512.			/ read initial block
	bcc	1f
3:	mov	$2,r0
	sys	write; urd; 24. / error reading rte
	sys	exit
1:	cmp	r0,a512		/ read whole block?
	bne	3b
	mov	22,csize	/ size of rte
	inc	csize
	bic	$1,csize
	sys	break		/ allocate core for rte
csize:	0
	bcc	1f
	mov	$2,r0
	sys	write; umem;20. / cant get memory
	sys	exit
/
/ memory allocated: relocate resident part
/
1:	mov	p2wh,r0		/ addr second part
	inc	r0
	bic	$1,r0		/ round comp size to words
	mov	where,wh2	/ save where for part 2
	mov	r0,r3
	mov	r0,*$20		/ for reading core dumps
	mov	$p2end-p2,r1	/ size of res part
	asr	r1		/ in words
	mov	$p2,r2		/ addr of section two
1:	mov	(r2)+,(r0)+	/ relocate part two
	sob	r1,1b		/ (slow way)
/
/ fix up absolute addresses in part 2
/
	mov	r3,r0		/ addr of res part
	sub	$p2,r0		/ relocation amount
	mov	$rltabl,r1	/ addr of reloc table
4:	mov	(r1)+,r2	/ addr (old) of value to reloc
	beq	1f		/ end of list
	add	r0,r2		/ new addr of abs value
	add	r0,*r2
	br	4b
/
/ go to real part and read rest of rte
/
1:
	jmp	*r3		/ go to part 2
/
/ raw i/o code (part 1)
/ taken out by ben salama october 1980
raw:
/	sys	open; which; 0	/ open raw rte
	nop			/ extra param in S5
	bcs	2b
/	mov	r0,rtefd
/	mov	where,iseek
/	sys	seek
/iseek:	0; 3			/ seek to beg. of comp.
/	bcs	3b
/	jmp	comr
/
/ constants for part 1:
/
where:	-1
which:	</dev/rrk0\0>
aci:	</etc/a68rte\0>
uop:	<unable to open rte file\n>
urd:	<unable to read rte file\n>
umem:	<insufficient memory\n>
	.even
p2wh:	0
rltabl:
	arl1
	arl2
	arl3
	arl4
	arl5
	arl6
	arl7
	arl8
	0
/
/ part 2: resident part
/
p2:
	jbr	load		/ go load rte
/
/ system call handler
/
/ open handler
/
popen:	mov	(r5)+,o1	/ get filename pntr
	mov	(r5)+,o2	/ open type
	sys	open
o1:	0
o2:	0
	nop			/ for S5 open
	rts	r5
/
/ seek handler
/ v6 version
/
.if .V6
pseek:	mov	(r5)+,s1	/ seek offset
	mov	(r5)+,s2	/ type
	cmp	r0,$-1		/ overlay load?
	bne	psk2		/ no-go do
	mov	rtefd,r0	/ yes-get fd
	inc	xxcnt
	tst	wh2		/ raw i/o?
	bmi	psk2		/ no-just do
	add	wh2,s1		/ yup-add rte offset
psk2:	sys	seek
s1:	0
s2:	0
	rts	r5
.endif

/
/ seek handler
/ v7 version
/ ben salama qmc.
.if .V7
pseek:
	mov	r0,savr0	/ save r0 and r1
	mov	r1,savr1	/
	mov	(r5)+,r1	/ v6 seek offset
	mov	(r5)+,whence	/ type
	clr	r0
	cmp	whence,$3	/ is type 3,4,5 i.e *512?
	blt	1f
	sub	$3,whence	/ make up v7 parameters
	mov	r1,r0
	clr	r1
	mul	$512.,r0	/ make long offset
1:	mov	r0,offset1	/ high word
	mov	r1,offset2	/ low word
	mov	savr0,r0	/ restore original r0 (fd)
	cmp	r0,$-1		/ overlay load?
	bne	psk2		/ no-go do
	mov	rtefd,r0	/ yes-get fd
	inc	xxcnt
psk2:	sys	lseek
offset1:	0
offset2:	0
whence:	0
	mov	savr1,r1
	mov	savr0,r0
	rts	r5
savr0:	0
savr1:	0
.endif

/
/ read handler
/
pread:	mov	(r5)+,ra1
	mov	(r5)+,ra2
	cmp	r0,$-1		/ overlay load?
	bne	prd2		/ no-go do
	mov	rtefd,r0	/ yup-get ovly fd
	inc	xycnt
prd2:	sys	read
ra1:	0
ra2:	0
	rts	r5
/
/ write handler
/
pwrite: mov	(r5)+,w1
	mov	(r5)+,w2
	sys	write
w1:	0
w2:	0
	rts	r5
/
/ close handler
/
pclose: tst	r0		/ overlay?
	bne	pcl2
	mov	rtefd,r0	/ yup-load overlay fd
pcl2:	sys	close
	rts	r5
/
/ channel handlers
/
pchan:
	rts	pc		/ not implemented
/
/ load and branch to rte:
/
load:
	tst	wh2		/ raw i/o?
	bpl	rawrd		/ yup-do seek first
coml:	mov	rtefd,r0
	mov	*$22,rsize	/ size of rte
	sub	$512.,rsize	/ minus first block
	inc	rsize
	bic	$1,rsize	/ must be even for raw i/o
	sys	read; 512.
rsize:	0
	bcc	1f
rerr:	mov	$2,r0
	sys	write		/ write read error msg.
arl1:	ugh; 24.
	sys	exit
1:	cmp	r0,rsize	/ read correct amt?
	bne	rerr
	br	1f
/
/ raw code removed for v7
/
rawrd:
/	mov	wh2,rseek
/	inc	rseek		/ seek to rest of rte
/	mov	rtefd,r0
/	sys	seek
/rseek:	0; 3
/	bcs	rerr		/ seek failed
/	br	coml
	br	rerr
ugh:	<unable to read rte file\n>
	.even
/
/ branch to rte
/
1:	mov	arl2,r5		/ point to unix tv
	mov	*$16,r3
	jmp	*r3		/ jump to compiler
arl2:	arl3
arl3:	pchan
arl4:	popen
arl5:	pseek
arl6:	pread
arl7:	pwrite
arl8:	pclose
rtefd:	0
wh2:	0
xxcnt:	0
xycnt:	0
p2end:	0
