.;
.; Copyright (c) 2012, 2014 Oleg Safiullin <form@pdp-11.org.ru>
.;
.; Permission to use, copy, modify, and distribute this software for any
.; purpose with or without fee is hereby granted, provided that the above
.; copyright notice and this permission notice appear in all copies.
.;
.; THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.; WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.; MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.; ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.; WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.; ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.; OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.;
	.ENABLE SUBSTITUTION

	;
	; IOSCAN V4.0 generation program.
	;

	.IF <SYSTEM> <> 1 .GOTO 10
	.SETS SYSTEM "RSX-11M"
	.SETS RSXSTB "LB:'<SYSUIC>'RSX11M.STB"
	.SETS RSXMC "LB:[11,10]RSXMC"
	.SETS EXEMC "LB:[1,1]EXEMC"
	.SETF RSXVEC
	.GOTO BLDRS
.10:
	.IF <SYSTEM> <> 6 .GOTO 20
	.SETS SYSTEM "RSX-11M-PLUS or Micro/RSX"
	.SETS RSXSTB "LB:'<LIBUIC>'RSXVEC.STB"
	.SETS RSXMC "LB:[11,10]RSXMC"
	.SETS EXEMC "LB:[1,1]EXEMC"
	.SETT RSXVEC
	.GOTO BLDRS

.20:
	.IF <SYSTEM> <> 11 .GOTO 30
	.SETS SYSTEM "P/OS"
	.SETS RSXSTB "LB:[1,5]POS.STB"
	.SETS RSXMC "LB:[1,5]RSXMC"
	.SETS EXEMC "LB:[1,5]EXEMC"
	.SETF RSXVEC
	.GOTO BLDRS

.30:
	.IF <SYSTEM> <> 7 .IF <SYSTEM> <> 10 .GOTO NOSUP
	.SETS SYSTEM "RT-11"
	.GOTO BLDRT

.NOSUP:
	; Running on unsupported operating system
	;
	.EXIT <ERROR>

.BLDRT:
	; Running on RT-11 system.
	;
	; Building programs:
	;	IOSCAN.BIN - standalone IOSCAN
	;	IOSCAN.LDA - standalone IOSCAN (absolute loader format)
	;	IOSCAN.REL - standalone IOSCAN (PRUN format for MC0511)
	;	IOSCAN.SAV - IOSCAN for RT-11
	;
	.SETS FILES "SY:MACRO.SAV SY:LINK.SAV SY:SPLIT.SAV"
	.GOSUB FILTST

	MAC IOSCAN
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	MAC IOSPP
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	MAC IOSRT
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	MAC IOSST
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	LIN/FOR/EXE:IOSCAN IOSPP,IOSCAN
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	LIN/EXE:IOSCAN IOSRT,IOSCAN
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	LIN/LDA/EXE:IOSCAN IOSST,IOSCAN
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	LIN/EXE:IOSCAN.TMP IOSST,IOSCAN
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	SPLIT IOSCAN.TMP/B:1 ,IOSCAN.BIN
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	DEL/NOQ IOS(CAN,PP,RT,ST).OBJ,IOSCAN.TMP
	.EXIT <EXSTAT>

.BLDRS:
	.IFT RSXVEC .SETS TSK "any 'SYSTEM' system"
	.IFF RSXVEC .SETS TSK "this 'SYSTEM' system only"

	; Running on 'SYSTEM' system.
	;
	; Building programs:
	;	IOSCAN.TSK - IOSCAN for 'TSK'
	;
	.SETS CLI "MCR"
	.IFDF <CLI> .SETS CLI <CLI>
	.SETF DCL
	.IF CLI = "MCR" .GOTO COMPL
	.SETT DCL
	.IF CLI = "DCL" .GOTO COMPL
	; Unsupported CLI - 'CLI' -- use MCR or DCL to build IOSCAN
	;
	.EXIT <ERROR>

.COMPL:
	.SETS FILES "'RSXSTB' 'RSXMC'.MAC 'EXEMC'.MLB"
	.GOSUB FILTST

	.SETS DIR <UIC>
	.IFDF <DIRECT> .SETS DIR <DIRECT>

	.OPEN IOSCANPRE.MAC
	.IFT RSXVEC .DATA IO$VEC	= 0	;Executive vector support
	.IFF RSXVEC .DATA ;IO$VEC	= 0	;No executive vector support
	.CLOSE

	.OPEN IOSCANASM.CMD
	.DATA IOSCAN=IOSCAN
	.DATA IOSRSX='EXEMC'/ML,'RSXMC'/PA:1,SY:'DIR'IOSCANPRE,IOSRSX
	.CLOSE

	.OPEN IOSCANBLD.CMD
	.DATA IOSCAN/PR:5=IOSRSX,IOSCAN
	.DATA 'RSXSTB'/SS
	.DATA /
	.DATA ASG=TI:1
	.DATA UNITS=1
	.DATA //
	.CLOSE

	.GOSUB TSKTST

	MAC @IOSCANASM
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	.IFT DCL LIN @IOSCANBLD
	.IFF DCL TKB @IOSCANBLD
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
	.IFT DCL DEL/NOWAR IOSCANPRE.MAC;*,IOSCANASM.CMD;*,IOSCANBLD.CMD;*
	.IFT DCL DEL/NOWAR IOSCAN.OBJ;*,IOSRSX.OBJ;*
	.IFT DCL PUR/NOWAR IOSCAN.TSK
	.IFF DCL PIP IOSCANPRE.MAC;*,IOSCANASM.CMD;*,IOSCANBLD.CMD;*/DE/NM
	.IFF DCL PIP IOSCAN.OBJ;*,IOSRSX.OBJ;*/DE/NM
	.IFF DCL PIP IOSCAN.TSK/PU
	.EXIT <EXSTAT>

.FILTST:
	.SETF MISS
.100:
	.PARSE FILES " " FILE FILES
	.TESTFILE 'FILE'
	.IF <FILERR> = 1 .GOTO 110
	.SETT MISS
	; File not found - 'FILE'
.110:
	.IF FILES <> "" .GOTO 100
	.IFT MISS ;
	.IFF MISS .RETURN
	.EXIT <ERROR>

.TSKTST:
	.IFINS ...PIP .GOTO 200
	INS $PIP
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
.200:
	.IF <SYSTEM> <> 11 .IFINS ...MAC .GOTO 210
	.IF <SYSTEM> <> 11 INS $MAC
	.IF <SYSTEM> = 11 .IFINS ...PMA .GOTO 210
	.IF <SYSTEM> = 11 INS $PMA
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
.210:
	.IF <SYSTEM> <> 11 .IFINS ...TKB .GOTO 220
	.IF <SYSTEM> <> 11 INS $TKB
	.IF <SYSTEM> = 11 .IFINS ...PAB .GOTO 220
	.IF <SYSTEM> = 11 INS $PAB
	.IF <EXSTAT> <> <SUCCES> .EXIT <EXSTAT>
.220:
	.RETURN
