/* $PDP11: ethtimed.h,v 1.1.1.1 2014/06/08 00:09:21 form Exp $ */

/*
 * Copyright (c) 2014 Oleg Safiullin <form@pdp-11.org.ru>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __ETHTIMED_H__
#define __ETHTIMED_H__

#define ETHTIM_VERSION_MAJOR	3
#define ETHTIM_VERSION_MINOR	0

#define ETHTIM_ADDR_LEN		6
#define ETHTIM_IDENT_LEN	256
#define ETHTIM_SNAPLEN		sizeof(struct ethtim)
#define ETHTIM_SEND_COUNT	4

#define ETHTIM_TYPE		0x757e
#define ETHTIM_CODE_REQUEST	0x5971
#define ETHTIM_CODE_ANSWER	0x8308

struct ethtim {
	u_int8_t	et_dst[ETHTIM_ADDR_LEN];
	u_int8_t	et_src[ETHTIM_ADDR_LEN];
	u_int16_t	et_type;
	u_int16_t	et_code;
	u_int16_t	et_hz;
	u_int16_t	et_rt_date;
	u_int16_t	et_rt_time[2];
	u_int16_t	et_rsx_year;
	u_int16_t	et_rsx_month;
	u_int16_t	et_rsx_day;
	u_int16_t	et_rsx_hour;
	u_int16_t	et_rsx_minute;
	u_int16_t	et_rsx_second;
	u_int16_t	et_rsx_ticks;
	u_int16_t	et_rsx_tkps;
	char		et_ident[ETHTIM_IDENT_LEN];
};

#endif	/* __ETHTIMED_H__ */
