/* $PDP11: dnbridge.h,v 1.8 2013/06/29 18:07:26 form Exp $ */

/*
 * Copyright (c) 2009, 2013 Oleg Safiullin <form@pdp-11.org.ru>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __DNBRIDGE_H__
#define __DNBRIDGE_H__

#include <event.h>


#define DNBRIDGE_VERSION_MAJOR		2
#define DNBRIDGE_VERSION_MINOR		3

#define DNBRIDGE_CONF_FILE		"/etc/dnbridge.conf"

#define BRIDGE_EXPIRE_TIME		120
#define BRIDGE_ERROR_STRLEN		256
#define BRIDGE_PORTNAME_STRLEN		64
#define BRIDGE_NODE_ADDRLEN		6
#define BRIDGE_MIN_PKTLEN		18
#define BRIDGE_MAX_PKTLEN		1518
#define BRIDGE_MIN_NODES		0
#define BRIDGE_DEF_NODES		20000
#define BRIDGE_MAX_NODES		64449

#define BRIDGE_PKT_MOPDL		0x6001
#define BRIDGE_PKT_MOPRC		0x6002
#define BRIDGE_PKT_DECNET		0x6003
#define BRIDGE_PKT_LAT			0x6004
#define BRIDGE_PKT_LOOPBACK		0x9000

#define DEF_BIND_HOST			"0.0.0.0"
#define DEF_BIND_PORT			"4711"
#define DEF_UDP_PORT			DEF_BIND_PORT


struct packet_header {
	u_int8_t			ph_dst[BRIDGE_NODE_ADDRLEN];
	u_int8_t			ph_src[BRIDGE_NODE_ADDRLEN];
	u_int16_t			ph_type;
};

struct bridge_host {
	struct bridge_port		*bh_bport;
	struct in_addr			bh_addr;
	in_port_t			bh_port;
	SPLAY_ENTRY(bridge_host)	bh_entry;
};

SPLAY_HEAD(bridge_hosts_tree, bridge_host);

struct bridge_node {
	struct bridge_port		*bn_port;
	u_int8_t			bn_addr[BRIDGE_NODE_ADDRLEN];
	time_t				bn_time;
	LIST_ENTRY(bridge_node)		bn_list;
	SPLAY_ENTRY(bridge_node)	bn_entry;
};

SPLAY_HEAD(bridge_nodes_tree, bridge_node);
LIST_HEAD(bridge_nodes_list, bridge_node);

struct bridge_port {
	char				bp_name[BRIDGE_PORTNAME_STRLEN];
	struct event			bp_event;
	struct bridge_nodes_list	bp_nodes;
	void				*bp_desc;
	time_t				bp_time;
	int				bp_type;
	int				bp_fd;
#define BPT_UDP				1
#define BPT_PCAP			2
#define BPT_TAP				3
#define BPT_VDE				4
	u_int32_t			bp_flags;
#define BPF_DECNET			0x00000001
#define BPF_LAT				0x00000002
#define BPF_MOP				0x00000004
#define BPF_DESTROY			0x00004000
#define BPF_PASSIVE			0x00008000
	RB_ENTRY(bridge_port)		bp_entry;
};

RB_HEAD(bridge_ports_tree, bridge_port);


extern struct bridge_nodes_tree bridge_nodes;
extern struct bridge_ports_tree bridge_ports;
extern struct bridge_hosts_tree bridge_hosts;


__BEGIN_DECLS
const char *bridge_error(void);
int bridge_init(int, int, size_t, const char *, const char *);
struct bridge_port *bridge_add_tap(const char *, u_int32_t);
struct bridge_port *bridge_add_pcap(const char *, u_int32_t);
struct bridge_port *bridge_add_udp(const char *, const char *, u_int32_t);
#ifdef VDE
struct bridge_port *bridge_add_vde(char *, u_int32_t);
#endif
void bridge_del(struct bridge_port *);
void bridge_main(void);
__END_DECLS

#endif	/* __DNBRIDGE_H__ */
