; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    1
;                            Table of Contents

; 1	DEFINE.MCD
; 2	REVISION 3.27
; 9		Revision History
; 49		Introductory Remarks
; 62		Microassembler Word Field Definitions
; 113			Microinstruction Opcodes
; 118				Operate Class
; 186				Literal Class
; 203				Address Class
; 215				Internal Input/Output Class
; 223				External Input/Output Class
; 233				Jump Class
; 246			Operand Length
; 257			Control Fields
; 259				Operate Type
; 279				Literal Type
; 284				Address Type
; 356				Internal Input/Output Type
; 426				External Input/Output Type
; 437				Jump Type
; 448			Register Selection
; 522			Diagnostics
; 540		PLA Field Definitions
; 542			PLA Input Fields
; 584			Override Fields
; 590		Validity Expressions
; 668		Macro Definitions
; 670			Instruction Mnemonics
; 672				Operate Class
; 674					Arithmetic Group
; 796					Logical Group
; 899					Shift Group
; 943					Multiply/Divide Group
; 967					Decimal Group
; 984					Prefetch Group
; 988				Literal Class
; 1040				Address Class
; 1063				Internal Input/Output Class
; 1077				External Input/Output Class
; 1095				Jump Class
; 1109			Control Field Mnemonics
; 1111				Operate Type
; 1117				Address Type
; 1137				External Input/Output Type
; 1144				Diagnostic Type
; 1153			PLA Mnemonics
; 1155				PLA Input Mnemonics
; 1177				PLA Override Mnemonics
; 1195	
; 1196	
; 1197	
; 1198	
; 1199	
; 1200	
; 1201	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    2
;                            Table of Contents


; 1209	BASE.MCD
; 1210	REVISION 3.39
; 1217		Revision History
; 1285		Introductory Remarks
; 1292		Power Up
; 1478		Power Up Test
; 1750		ID1 Q-Logic Next Addresses
; 1872			Prefetch Pipeline Resynchronization Sequences
; 1955			SOPs, DOPs, and Q-Logic Organization
; 2110				DOP Source Mode Decode
; 2142					Source Mode 1
; 2188					Source Mode 2
; 2255					Source Mode 3
; 2343					Source Mode 4
; 2431					Source Mode 5
; 2539					Source Mode 6
; 2594					Source Mode 7
; 2676				SOP and DOP Destination Mode Decode
; 2714					Destination Mode 1
; 2886					Destination Mode 2
; 3098					Destination Mode 3
; 3294					Destination Mode 4
; 3501					Destination Mode 5
; 3715					Destination Mode 6
; 3904					Destination Mode 7
; 4141				SOP and DOP Execution
; 4166					SOP Execution
; 4419					DOP Execution
; 4587				MTPS
; 4641				MFPI and MFPD
; 4690				MTPI and MTPD
; 4772				TSTSET and WRTLCK
; 4841				CSM
; 4972				EIS - Extended Instruction Set
; 4974					MUL - Multiply
; 5069					DIV - Divide
; 5232					ASH - Arithmetic Shift
; 5391					ASHC - Arithmetic Shift Combined
; 5600			JOP Decode
; 5638				JOP Mode 0
; 5681				JOP Mode 1
; 5767				JOP Mode 2
; 5865				JOP Mode 3
; 5994				JOP Mode 4
; 6091				JOP Mode 5
; 6197				JOP Mode 6
; 6335				JOP Mode 7
; 6442			Miscellaneous Instruction Decode
; 6459				Branches
; 6510				RTI and RTT
; 6569				RTS
; 6619				BPT, IOT, EMT, and TRAP
; 6657				CCC, SCC, and NOP
; 6694				MARK
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    3
;                            Table of Contents


; 6728				RESET
; 6816				HALT
; 6875				MFPT
; 6900				SPL
; 6963				CIS Breakout
; 6991				Illegal Instructions
; 7016				WAIT
; 7047			Interrupt Service Decode
; 7219		Abort Service Decode
; 7240			Base Code Abort
; 7331			Micro Trap
; 7440			Multiple and ODT Abort, Power Up Breakout
; 7565			General Purpose Abort Return
; 7587	ODT.MCD
; 7588	REVISION 2.07
; 7594		Revision History
; 7621		Introductory Remarks
; 7622			ODT States
; 7746			Register Assignments
; 7779			Notes
; 7807		Initialization
; 7842		Command Input and Breakout
; 7879			Default PLA Term
; 7906			R, $, and S
; 7934			0-7 Octal Digits
; 7972			P, G
; 8013			Slash
; 8113			Carriage Return
; 8177			Line Feed
; 8283			Control-Shift-S
; 8334		Subroutines
; 8336			Input Routine
; 8395			Output Routine
; 8455			Carriage Return and Line Feed
; 8484			Print Routine
; 8556	FP11.MCD
; 8557	REVISION 3.37
; 8563		Revision History
; 8637		Introductory Remarks
; 8645		Floating Point Addressing
; 9045			SRC Addressing
; 9137			FSRC Addressing
; 9322			DST/FDST Addressing
; 9527			Post-addressing
; 9529				Warm DST/FDST
; 9573				Hot Support
; 9735			No Addressing
; 9805		Warm Floating Point Execution
; 9807			SRC Instructions
; 9809				LDFPS
; 9838				LDEXP
; 9878				LDCif
; 9955			DST Instructions
; 9957				STST
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    4
;                            Table of Contents


; 9981				STFPS
; 10008				STEXP
; 10057				STCfi
; 10220			FSRC Instructions
; 10227				TSTf
; 10280				LDf
; 10335				LDCfd
; 10407				Arithmetics
; 10460					CMPf
; 10620					ADDf, SUBf
; 11079					MULf
; 11355					MODf
; 11652					DIVf
; 11855					Arithmetic Routines
; 11861						Normalization
; 12024						Rounding
; 12104						Store/update FCCs
; 12155						Under/overflow
; 12283			FDST Instructions
; 12285				STf
; 12335				STCfd
; 12462				CLRf
; 12516			FRMW Instructions
; 12518				ABSf, NEGf
; 12632		Common Routines
; 12634			uInstruction/NAF overrides
; 12636				Normalization PLAs
; 12719				Exponent Extractors
; 12773				Mantissa Extractors
; 12812				FN and FZ Overrides
; 12833				FD Override
; 12849			Miscellaneous
; 12851				Store FCC/AC/Exit
; 12885				Exact Zero
; 12934				FIUV Check
; 12977				Interrupt Check
; 13010				Abort Processing
; 13033				Register Restore
; 13101				Trap Handler
; 13158	PLADEF.MCD
; 13159	REVISION 3.07
; 13165		Revision History
; 13188		Introductory Remarks
; 13195		PLA Address Assignments
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    5
; DEFINE.MCD [242,1110]      DEFINE.MCD

				;1		.TOC	"DEFINE.MCD"
				;2		.TOC	"REVISION 3.27"
				;3	
				;4	
;5	.NOBIN
;6	
;7	
;8	
;9		.TOC	"	Revision History"
;10	
;11	;
;12	;	Revision History
;13	;	----------------
;14	;
;15	; Rev	  Date		Explaination
;16	; ---	  ----		------------
;17	;	Release
;18	; 3.27	07/14/82	KEH; Redefined FEATMP as warm AC5.3 freeing
;19	;			     old FEC code for MMUTMP2.  Moved chip testing
;20	;			     jump off chip into this code.
;21	;	Release
;22	; 2.26	01/26/82	KEH; Modified revision code to represent chip pass.
;23	; 2.25	12/17/81	KEH; Switched FEC and NPDR, and FEA and FPS
;24	;			 	INPR OUTR codes.
;25	; 2.24	12/01/81	KEH; Added new MMU scratchpad mnemonics.
;26	; 2.23	11/20/81	KEH; Changed GP address definitions for 2nd pass code.
;27	;	Release
;28	; 1.22	04/14/81	KEH; Changed RSYNC to specify A-PORT/PS for branches.
;29	; 1.21	03/21/81	KEH; Added two PLA macros which take mnemonics
;30	;				for NA field.
;31	; 1.20	03/17/81	KEH; Switched OUTS MSTK and FPS control bits.
;32	; 1.19	03/04/81	KEH; Updated GP code definitions.
;33	; 1.18	02/05/81	KEH; Changed LOAD_ to LD_, CLOCK_ to CLK_.
;34	; 1.17	01/16/81	KEH; Added alternate PS select codes.
;35	;				Changed mnemonics to CLK_FPS and LD_FPS.
;36	; 1.16	01/06/81	KEH; Added NAF field value IRDF = 460.
;37	; 1.15	12/15/80	KEH; Added SIR (Shadow IR).
;38	; 1.12	10/30/80	KEH; Eliminated validity check on ADD.L [Rb.H, Ra], etc.
;39	; 1.11	10/13/80	KEH; Changed breakpoint definitions for TUMS model.
;40	; 1.10	09/22/80	KEH; Changed SOPs to take two arguements for consistency.
;41	;			     Changed field names for JETI consistency.
;42	; 1.09	08/20/80	KEH; PLA features added.  Miscellaneous corrections.
;43	; 1.08	07/21/80	KEH; Initial Release.  No PLA features.
;44	; 1.00	06/06/80	KEH; Preliminary.
;45	;
;46	;
;47	
;48	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    6
; DEFINE.MCD [242,1110]      Introductory Remarks

;49		.PAGE	"	Introductory Remarks"
;50	
;51	;
;52	;	This file supplies field definitions, field values, macro
;53	;	definitions, and expression names to MICRO2.  This procedure,
;54	;	combined with MICRO2's standard facilities, defines a custom
;55	;	microassembler for the J-11 chip set.  This includes the
;56	;	microinstruction mnemonics, microassembler syntax, and
;57	;	microassembler error checking facilities.
;58	;
;59	
;60	
;61	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    7
; DEFINE.MCD [242,1110]      Microassembler Word Field Definitions

;62		.PAGE	"	Microassembler Word Field Definitions"
;63	
;64	;
;65	;	The J-11 microword is 32-bits wide.  The microassembler
;66	;	microword as defined here is 48-bits wide however.  The extra
;67	;	bits provide for PLA input declarations and special features in
;68	;	the TUMS and engineering tester simulators.
;69	;
;70	;
;71	;
;72	;
;73	;	 4 4 4 4 4 4 4 4 3 3 3 3 3 3 3 3 3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;74	;	 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;75	;	+-----------------------------------------------------------------------------------------------+
;76	;	|			| D |					        | D |			|
;77	;	|			| I |					        | I |			|
;78	;	|	    0		| A |	   M I C R O I N S T R U C T I O N      | A |       N A F  	|
;79	;	|			| G |					        | G |			|
;80	;	|			| . |					        | . |			|
;81	;	+-----------------------------------------------------------------------------------------------+
;82	;
;83	
;84	
;85	
;86		.WIDTH/48			; The microassembler word width is 48
;87						;  (decimal)
;88	
;89		.RTOL				; The numbering system is right to left
;90	
;91		.OCTAL				; The default program radix is octal
;92	
;93	;
;94	; Note:
;95	; All integers are interpreted as octal unless explicitly represented
;96	;  in decimal (e.g. 9. ) or binary (e.g. ^01 ) or if used in a field
;97	;  definition (decimal is always assumed).
;98	;
;99	
;100	
;101		MICROINSTRUCTION/=<33:12>, .DEFAULT=17777777
;102	
;103		NAF/=<9:0>, .NEXTADDRESS
;104	
;105			ID1	= 0477, .VALIDITY=<V6>	; Instruction Decode 1
;106			ID2	= 0474			; Instruction Decode 2
;107			ID3	= 0471			; Instruction Decode 3
;108			IRDF	= 0460			; Instruction Read Demand Prefetch
;109			RFS	= 0777			; Return From Subroutine
;110	
;111	.NOCREF
;112	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    8
; DEFINE.MCD [242,1110]      Microinstruction Opcodes

;113		.TOC	"		Microinstruction Opcodes"
;114	
;115	
;116		OPC/=<33:27>, .DEFAULT=177
;117	
;118		.TOC	"			Operate Class"
;119	
;120	;	Arithmetic group
;121	
;122			ADD	= 144, .VALIDITY=<V12>	; Add
;123			ADDC	= 160, .VALIDITY=<V12>	; Add with carry
;124			INC	= 136, .VALIDITY=<V12>	; Increment
;125			ADC	= 164, .VALIDITY=<V12>	; Add carry
;126			SUB	= 141, .VALIDITY=<V12>	; Subtract
;127			SUBC	= 165, .VALIDITY=<V12>	; Subtract with carry
;128			DEC	= 145, .VALIDITY=<V12>	; Decrement
;129			SBC	= 161, .VALIDITY=<V12>	; Subtract carry
;130			AOBC	= 172, .VALIDITY=<V12>	; Add on branch condition
;131			SOBC	= 140, .VALIDITY=<V12>	; Subtract on branch condition
;132			NEG	= 133, .VALIDITY=<V12>	; Negate
;133			NEGC	= 137, .VALIDITY=<V12>	; Negate with carry
;134			CNEG	= 103, .VALIDITY=<V12>	; Conditional negate (if C = 1)
;135			ACNEG	= 113, .VALIDITY=<V12>	; Conditional negate (if AC = 1)
;136			NNEG	= 107, .VALIDITY=<V12>	; Conditional negate (if N = 1)
;137			ANNEG	= 117, .VALIDITY=<V12>	; Conditional negate (if AN = 1)
;138			CMP	= 143, .VALIDITY=<V2>	; Compare
;139	
;140	;	Logical group
;141	
;142			MOV	= 156, .VALIDITY=<V11>	; Move
;143			MOVPM	= 112, .VALIDITY=<V11>	; Move using previous mode
;144			MOVS	= 102, .VALIDITY=<V11>	; Move sign extended
;145			CLR	= 104, .VALIDITY=<V11>	; Clear
;146			COM	= 147, .VALIDITY=<V11>	; Complement
;147			SXT	= 106, .VALIDITY=<V11>	; Sign extend
;148			AND	= 151, .VALIDITY=<V11>	; And
;149			BIC	= 155, .VALIDITY=<V11>	; Bit clear
;150			BIS	= 157, .VALIDITY=<V11>	; Bit set
;151			XOR	= 154, .VALIDITY=<V11>	; Exclusive-or
;152			BIT	= 150			; Bit test
;153			TST	= 166			; Test
;154			MTST	= 167			; Multiply test
;155			SWAB	= 146, .VALIDITY=<V11>	; Swap bytes
;156			NOP	= 177, .VALIDITY=<V7>	; No operation
;157	
;158	;	Shift group
;159	
;160			ASR	= 134, .VALIDITY=<V12>	; Arithmetic shift right
;161			ROR	= 124, .VALIDITY=<V12>	; Rotate right
;162			LSR	= 120, .VALIDITY=<V12>	; Logical shift right
;163			LSRQ	= 130, .VALIDITY=<V12>	; Logical shift right quadword
;164			ASL	= 123, .VALIDITY=<V12>	; Arithmetic shift left
;165			ROL	= 121, .VALIDITY=<V12>	; Rotate left
;166			ASLQ	= 131, .VALIDITY=<V12>	; Arithmetic shift left
;167	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page    9
; DEFINE.MCD [242,1110]      Operate Class

;168	;	Multiply/divide group
;169	
;170			UMULS	= 110, .VALIDITY=<V12>	; Unsigned multiply step
;171			SMULS	= 114, .VALIDITY=<V12>	; Signed multiply step
;172			DIVS	= 105, .VALIDITY=<V12>	; Divide step
;173			XLDIVS	= 111, .VALIDITY=<V12>	; Extended low divide step
;174			XHDIVS	= 115, .VALIDITY=<V12>	; Extended high divide step
;175	
;176	;	Decimal group
;177	
;178			DADP	= 174, .VALIDITY=<V12>	; Decimal post-adjust
;179			PDAD	= 170, .VALIDITY=<V12>	; Decimal pre-adjust
;180	
;181	;	Prefetch group
;182	
;183			RSYNC	= 162			; Resynchronize
;184	
;185	
;186		.TOC	"			Literal Class"
;187	
;188			LLD	= 056			; Load literal
;189			LLSW	= 046			; Load literal swapped
;190			LLCM	= 047			; Load literal complement
;191			LCNTR	= 052			; Load counter
;192			LMSTK	= 053			; Load stack
;193			LCMP	= 043, .VALIDITY=<V1>	; Compare literal
;194			LADD	= 044			; Add literal
;195			LSUB	= 041			; Subtract literal
;196			LBIS	= 057			; Bit set literal
;197			LAND	= 051			; And literal
;198			LBIC	= 055			; Bit clear literal
;199			LBIT	= 050, .VALIDITY=<V1>	; Bit test literal
;200			LXOR	= 054			; Exclusive-or literal
;201	
;202	
;203		.TOC	"			Address Class"
;204	
;205			AR	= 073, .VALIDITY=<V1>	; Address read
;206			ARI	= 070, .VALIDITY=<V1>	; Address read and increment
;207			ARD	= 071, .VALIDITY=<V1>	; Address read and decrement
;208			AW	= 077, .VALIDITY=<V1>	; Address write
;209			AWI	= 074, .VALIDITY=<V1>	; Address write and increment
;210			AWD	= 075, .VALIDITY=<V1>	; Address write and decrement
;211			ARG	= 063			; Address read general purpose
;212			AWG	= 067			; Address write general purpose
;213	
;214	
;215		.TOC	"			Internal Input/Output Class"
;216	
;217			INPR	= 021			; Read data from MMU register
;218			OUTR	= 025			; Write data to MMU register
;219			OUTS	= 027, .VALIDITY=<V1>	; Write control chip status
;220			OUTC	= 026, .VALIDITY=<V1>	; Write control chip control
;221	
;222	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   10
; DEFINE.MCD [242,1110]      External Input/Output Class

;223		.TOC	"			External Input/Output Class"
;224	
;225			RD	= 032			; Read data
;226			RMW	= 033			; Read-modify-write data
;227			RDG	= 036			; Read general purpose
;228			RDINTR	= 037			; Read interrupt vector
;229			RDI	= 030, .VALIDITY=<V6>	; Read instruction stream
;230			RDF	= 031			; Read demand prefetch
;231	
;232	
;233		.TOC	"			Jump Class"
;234	
;235			JMP	= 000			; Jump unconditionally
;236			JAN	= 017			; Jump if AN flag = 1
;237			JAZ	= 011			; Jump if AZ flag = 1
;238			JAC	= 013			; Jump if AC flag = 1
;239			JAV	= 015			; Jump if AV flag = 1
;240			JN	= 007			; Jump if PS N flag = 1
;241			JZ	= 001			; Jump if PS Z flag = 1
;242			JC	= 003			; Jump if PS C flag = 1
;243			JV	= 005			; Jump if PS V flag = 1
;244			JKM	= 016			; Jump if kernel mode
;245	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   11
; DEFINE.MCD [242,1110]      Operand Length

;246		.TOC	"		Operand Length"
;247	
;248		LN/=<26:25>, .DEFAULT = 3
;249	
;250			WORD	= 0			; Word operand
;251			LONG	= 1, .VALIDITY=<V4>	; Longword operand
;252			WRD1	= 2			; Word operand
;253			BYTE	= 3			; Byte operand
;254	
;255	
;256	
;257		.TOC	"		Control Fields"
;258	
;259		.TOC	"			Operate Type"
;260	
;261		CC/=<22>, .DEFAULT = 1			; Condition code control
;262	
;263			UPDATE	= 0			; Set from ALU flags
;264			SAME	= 1			; Leave unchanged
;265	
;266	
;267		DC/=<23>, .DEFAULT = 1			; Counter control
;268	
;269			DECR	= 0
;270			NO	= 1
;271	
;272	
;273		PF/=<24>, .DEFAULT = 1			; Prefetch control
;274	
;275			YES	= 0
;276			NO	= 1
;277	
;278	
;279		.TOC	"			Literal Type"
;280	
;281		LIT/=<24:17>, .DEFAULT = 377		; No other control fields
;282	
;283	
;284		.TOC	"			Address Type"
;285	
;286		SPACE/=<18:17>, .DEFAULT = 3		; I/D space select
;287	
;288			I	= 0			; I space unconditionally
;289			MFPI	= 1			; I space unless PS<15:12> = 1111
;290			D	= 2			; D space unconditionally
;291			NORMAL	= 3			; D space unless Ra is PC
;292	
;293	
;294		ABORTS/=<19>, .DEFAULT = 1		; Abort suppression
;295	
;296			DISABLE	= 0			; Disable aborts
;297			YES	= 1			; Map as usual
;298	
;299	
;300		TRAP/=<20>, .DEFAULT = 1		; Odd address trap enable
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   12
; DEFINE.MCD [242,1110]      Address Type

;301	
;302			YES	= 0			; Enable trap
;303			NO	= 1			; No effect
;304	
;305	
;306		OVF/=<21>, .DEFAULT = 1			; Stack overflow logic enable
;307	
;308			YES	= 0			; Enable
;309			NO	= 1			; Disable
;310	
;311	
;312		MODE/=<23:22>, .DEFAULT = 3		; Mode selection
;313	
;314			KERNEL	= 0
;315			PREVIOUS= 1
;316			CONSOLE	= 2
;317			CURRENT	= 3
;318	
;319	
;320		MMR1/=<24>, .DEFAULT = 1		; Update MMR1 enable
;321	
;322			UPDATE	= 0
;323			NO	= 1
;324	
;325	.CREF
;326	
;327		GPA/=<24:17>, .DEFAULT = 377		; ARG and AWG general purpose address field
;328	
;329	; Read class
;330			OPTIONS		= 000		; Power up and HALT options.
;331			FPA_RD		= 001		; Read FPA's FCC/integer.
;332			OPTIONS_CLR	= 002		; Board options/clear FPA's FPS.
;333			FPA_ACK		= 003		; Read FPA's FEC/acknowledge.
;334	; Write class
;335			FPA_ON		= 001		; Enable FPA.
;336			FPA_OFF		= 002		; Disable FPA.
;337			FPA_WR		= 003		; Write FPA data.
;338			LED1_ON		= 220		; Light LED1.
;339			LED2_ON		= 224		; Light LED2.
;340			LED3_ON		= 230		; Light LED3.
;341			LED4_ON		= 234		; Light LED4.
;342			LED4_OFF	= 034		; Clear LED4.
;343			BINIT_ON	= 014		; Assert BINIT L.
;344			BINIT_OFF	= 214		; Deassert BINIT L.
;345			BEVNT_ACK	= 100		; BEVNT acknowledge.
;346			PWRF_ACK	= 140		; Power fail acknowledge.
;347			NMI_ACK		= 040		; NMI acknowledge.
;348	; RDINTR class
;349			IRL7	= 010			; Interrupt Reguest level 7.
;350			IRL6	= 004			; Interrupt Reguest level 6.
;351			IRL5	= 002			; Interrupt Reguest level 5.
;352			IRL4	= 001			; Interrupt Reguest level 4.
;353			
;354	
;355	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   13
; DEFINE.MCD [242,1110]      Internal Input/Output Type

;356		.TOC	"			Internal Input/Output Type"
;357	
;358		RMMU/=<24:17>, .DEFAULT = 377		; For INPR and OUTR
;359	
;360			CPAR	= 147			; Console PAR
;361			CPU	= 157			; CPU error register
;362	
;363			FEA	= 057			; Floating exception address.  Old FPS.
;364			FPS	= 056			; Floating point status.  Old FEA.
;365							; FPS code must be even !
;366			FEC	= 046			; Floating exception code.  Old NPDR.
;367			FEATMP	= 155			; Hot FEA support register.
;368							; Same as warm AC5.3.
;369			MMUTMP2	= 156			; Scratchpad.  Old FEC.
;370			MMUTMP	= 047			; Scratchpad.  Old CPDR.
;371	
;372							; Indirect FP accumulator codes
;373			AC20.0= 341			; n = IR<2:0> , AC[n]<15:0>
;374			AC20.1= 241			; n = IR<2:0> , AC[n]<31:16>
;375			AC20.2= 351			; n = IR<2:0> , AC[n]<47:32>
;376			AC20.3= 251			; n = IR<2:0> , AC[n]<63:48>
;377			AC76.0= 342			; n = IR<7:6> , AC[n]<15:0>
;378			AC76.1= 242			; n = IR<7:6> , AC[n]<31:16>
;379			AC76.2= 352			; n = IR<7:6> , AC[n]<47:32>
;380			AC76.3= 252			; n = IR<7:6> , AC[n]<63:48>
;381			AC76+1.0= 344			; n = IR<7:6> OR 1, AC[n]<15:0>
;382			AC76+1.1= 244			; n = IR<7:6> OR 1, AC[n]<31:16>
;383			AC76+1.2= 354			; n = IR<7:6> OR 1, AC[n]<47:32>
;384			AC76+1.3= 254			; n = IR<7:6> OR 1, AC[n]<63:48>
;385	
;386			MMR0	= 200
;387			MMR1	= 201
;388			MMR3	= 202
;389			PIRQ	= 203
;390			CCR	= 204
;391			HIT_MISS= 205
;392			SR	= 206
;393			SIR	= 207
;394	
;395	
;396		OUTS_CONTROL/=<24:17>, .DEFAULT = 377
;397	
;398			INTERRUPTS	= 376		; Load interrupt service
;399			ABORTS		= 375		; Load abort service
;400			LD_FPS		= 373		; Load FP FFs and MDAL<11:0> into PIR.
;401			MSTK		= 367		; Load control chip stack
;402			LD_PIR		= 357		; Load PIR from MDAL
;403			LD_CNTR		= 337		; Load control chip counter
;404			PSW		= 277		; Load control chip PS
;405			CLK_FPS		= 177		; Clock FP FFs from MDAL<7:5>.
;406	
;407			LD_PIR_CNTR	= 317		; Load PIR and CNTR from MDAL.
;408	
;409	
;410		OUTC_CONTROL/=<24:17>, .DEFAULT = 377
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   14
; DEFINE.MCD [242,1110]      Internal Input/Output Type

;411	
;412			SET_SSFF	= 375
;413			CLR_SSFF	= 374
;414			SET_CPFF	= 373
;415			CLR_CPFF	= 372
;416			CPY_T-BIT	= 357
;417			CLR_SOVFF	= 337
;418			CLR_ITFF	= 277
;419			CLR_PTYFF	= 177
;420			CLR_ALL		= 030		; PTYFF, SOVFF, ITFF, SSFF, CPFF
;421			CLR_SVC_FFS	= 034		; PTYFF, SOVFF, ITFF, SSFF
;422			CPY_TBIT-CLR_SSFF = 354		; Copy PS<4> and Clear SSFF.
;423			INI_ALL		= 031		; Clear PTYFF, SOVFF, and ITFF,
;424							;  set SSFF and CPFF
;425	
;426		.TOC	"			External Input/Output Type"
;427	
;428	.NOCREF
;429	
;430		RD_CONTROL/=<24:17>, .DEFAULT = 377
;431	
;432			RTI-RTT	= 357			; PS protection
;433			VECTOR	= 337			; PS protection
;434			LOCKED	= 177			; Read locked
;435	
;436	
;437		.TOC	"			Jump Type"
;438	
;439		CJAR/=<26:17>, .DEFAULT = 1777		; Also used for LMSTK
;440	
;441		CSEL/=<16:12>, .DEFAULT = 37
;442	
;443			BASE	= 0
;444			CIS1	= 3
;445			CIS2	= 2
;446			WCS	= 1
;447	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   15
; DEFINE.MCD [242,1110]      Register Selection

;448		.TOC	"		Register Selection"
;449	
;450		A-PORT/=<16:12>, .DEFAULT = 37
;451	
;452			PS	= 0
;453			PS1	= 1			; Alternate
;454			PS2	= 2			; Alternate
;455			RSRC+1	= 3			; R(n), n = IR<8:6> OR 1
;456			RE+	= 4			; Alternate code for RE<31:0>
;457			RF+	= 5			; Alternate code for RF<31:0>
;458			RDST	= 6			; R(n), n = IR<2:0>
;459			RSRC	= 7			; R(n), n = IR<8:6>
;460			R8.H	= 10, .VALIDITY=<v4>	; R8<31:16>
;461			R9.H	= 11, .VALIDITY=<v4>	; R9<31:16>
;462			RA.H	= 12, .VALIDITY=<v4>	; RA<31:16>
;463			RB.H	= 13, .VALIDITY=<v4>	; RB<31:16>
;464			RC.H	= 14, .VALIDITY=<v4>	; RC<31:16>
;465			RD.H	= 15, .VALIDITY=<v4>	; RD<31:16>
;466			RE.H	= 16, .VALIDITY=<v4>	; RE<31:16>
;467			RF.H	= 17, .VALIDITY=<v4>	; RF<31:16>
;468			R0	= 20
;469			R1	= 21
;470			R2	= 22
;471			R3	= 23
;472			R4	= 24
;473			R5	= 25
;474			SP	= 26
;475			PC	= 27
;476			R8	= 30			; R8<31:0>
;477			R9	= 31			; R9<31:0>
;478			RA	= 32			; RA<31:0>
;479			RB	= 33			; RB<31:0>
;480			RC	= 34			; RC<31:0>
;481			RD	= 35			; RD<31:0>
;482			RE	= 36			; RE<31:0>
;483			RF	= 37			; RF<31:0>
;484	
;485	
;486		B-PORT/=<21:17>, .DEFAULT = 37
;487	
;488			PS	= 0
;489			IRFE	= 1			; IR field extractor
;490			MMR2	= 2
;491			RSRC+1	= 3			; R(n), n = IR<8:6> OR 1
;492			RE+	= 4			; Alternate code for RE<31:0>
;493			RF+	= 5			; Alternate code for RF<31:0>
;494			RDST	= 6			; R(n), n = IR<2:0>
;495			RSRC	= 7			; R(n), n = IR<8:6>
;496			R8.H	= 10, .VALIDITY=<v4>	; R8<31:16>
;497			R9.H	= 11, .VALIDITY=<v4>	; R9<31:16>
;498			RA.H	= 12, .VALIDITY=<v4>	; RA<31:16>
;499			RB.H	= 13, .VALIDITY=<v4>	; RB<31:16>
;500			RC.H	= 14, .VALIDITY=<v4>	; RC<31:16>
;501			RD.H	= 15, .VALIDITY=<v4>	; RD<31:16>
;502			RE.H	= 16, .VALIDITY=<v4>	; RE<31:16>
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   16
; DEFINE.MCD [242,1110]      Register Selection

;503			RF.H	= 17, .VALIDITY=<v4>	; RF<31:16>
;504			R0	= 20
;505			R1	= 21
;506			R2	= 22
;507			R3	= 23
;508			R4	= 24
;509			R5	= 25
;510			SP	= 26
;511			PC	= 27
;512			R8	= 30			; R8<31:0>
;513			R9	= 31			; R9<31:0>
;514			RA	= 32			; RA<31:0>
;515			RB	= 33			; RB<31:0>
;516			RC	= 34			; RC<31:0>
;517			RD	= 35			; RD<31:0>
;518			RE	= 36			; RE<31:0>
;519			RF	= 37			; RF<31:0>
;520	
;521	
;522		.TOC	"		Diagnostics"
;523	
;524		BR0/=<10>, .DEFAULT = 0
;525	
;526			ON	= 1
;527	
;528		BR1/=<11>, .DEFAULT = 0
;529	
;530			ON	= 1
;531	
;532		BR2/=<34>, .DEFAULT = 0
;533	
;534			ON	= 1
;535	
;536		BR3/=<35>, .DEFAULT = 0
;537	
;538			ON	= 1
;539	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   17
; DEFINE.MCD [242,1110]      PLA Field Definitions

;540		.TOC	"	PLA Field Definitions"
;541	
;542		.TOC	"		PLA Input Fields"
;543	
;544	;	
;545	;	The PLA input conditions are specified in four separate fields of
;546	;	the microassembler word as shown graphically below:
;547	;
;548	;
;549	;
;550	;	 4 4 4 4 4 4 4 4 3 3 3 3 3 3 3 3 3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;551	;	 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;552	;	+-----------------------------------------------------------------------------------------------+
;553	;	|	      |					|	      |	        			|
;554	;	|     N A     |		     P I R		|     N A     |	             P I R		|
;555	;	|  D O N ' T  |		   D O N ' T		|	      |	        			|
;556	;	|   C A R E   |		    C A R E 		|   O N E S   |	            O N E S		|
;557	;	|	      |					|	      |	        			|
;558	;	+-----------------------------------------------------------------------------------------------+
;559	;
;560	;
;561	;	The PIR and NA ONES fields specify which PIR and NA inputs must be ones.
;562	;	The PIR and NA DON'T CARE fields specify which bits are don't cares.
;563	;
;564	;	The PLA0 and PLA1 banks are represented as being in the fictitious
;565	;	addressing ranges 2000-2777, and 3000-3777 respectively. In these
;566	;	ranges, an even numbered address specifies the PLA AND term (input
;567	;	conditions) as defined above, and an odd numbered address specifies
;568	;	the PLA OR term (microinstruction) as defined for ROM code.  The PLA
;569	;	AND term must be immediately followed by it's associated OR term.
;570	;
;571	
;572	
;573		PIR1/=<16:00>, .DEFAULT = 377777
;574	
;575		NAF0/=<23:17>, .DEFAULT = 177, .VALIDITY = <V25>
;576							; Different VALIDITY expressions
;577		NAF1/=<23:17>, .VALIDITY = <V26>	;  check for consistent address specifier.
;578	
;579		PIRX/=<40:24>, .DEFAULT = 1777
;580	
;581		NAFX/=<47:41>
;582	
;583	
;584		.TOC	"		Override Fields"
;585	
;586		PLAOPC/=<33:27>, .DEFAULT = 177, .VALIDITY = <V27>
;587	
;588			RDOVR	= 173			; For WRITE --> READ override.
;589	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   18
; DEFINE.MCD [242,1110]      Validity Expressions

;590		.TOC	"	Validity Expressions"
;591	
;592	
;593		; Not valid if A-PORT code selects high word.
;594	
;595		.SET/V1	 = <.NOT[<.LEQ[10, <A-PORT/>, 17]>]>
;596	
;597	
;598		; Not valid if B-PORT code selects high word.
;599	
;600	;	.SET/V2	 = <.NOT[<.LEQ[10, <B-PORT/>, 17]>]>
;601		.SET/V2	= 1
;602	
;603	
;604		; Not valid if LONGWORD is specified.
;605	
;606	;	.SET/V3  = <.NEQ[<LN/>, <LN/LONG>]>
;607	
;608	
;609		; Not valid if NAF is ID1.
;610	
;611		.SET/V4  = <.NEQ[<NAF/>, 477]>
;612	
;613	
;614		; Not valid if A-PORT contains PC.
;615	
;616		.SET/V6  = <.NEQ[<A-PORT/>, <A-PORT/PC>]>
;617	
;618	
;619		; Not valid if MICROINSTRUCTION is all ones AND PLA OR term.
;620	
;621		.SET/V7	= <.NOT[<.AND[<.EQL[<MICROINSTRUCTION/>, 17777777]>, V27]>]>
;622	
;623	
;624		; Not valid if LONGWORD or NAF is ID1.
;625	
;626	;	.SET/V10 = <.AND[V3, V4]>
;627	
;628	
;629		; Not valid if PREFETCH and A-PORT contains PC.
;630	
;631		.SET/V11 = <.OR[<.NEQ[<PF/>, <PF/YES>]>, V6]>
;632	
;633	
;634		; Not valid if B-PORT selects high word or PREFETCH and PC.
;635	
;636		.SET/V12 = <.AND[V2, V11]>
;637	
;638	
;639		; Valid if address is even.
;640	
;641		.SET/V20 = <.NOT[<.MOD[., 2]>]>
;642	
;643	
;644		; Valid if PLA0 addressing range.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   19
; DEFINE.MCD [242,1110]      Validity Expressions

;645	
;646		.SET/V21 = <.LEQ[2000, ., 2777]>
;647	
;648	
;649		; Valid if PLA1 addressing range.
;650	
;651		.SET/V22 = <.LEQ[3000, ., 3777]>
;652	
;653	
;654		; Valid if PLA bank 0.
;655	
;656		.SET/V25 = <.AND[V20, V21]>
;657	
;658	
;659		; Valid if PLA bank 1.
;660	
;661		.SET/V26 = <.AND[V20, V22]>
;662	
;663	
;664		; Valid for PLAs only.
;665	
;666		.SET/V27 = <.OR[V21, V22]>
;667	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   20
; DEFINE.MCD [242,1110]      Macro Definitions

;668		.TOC	"	Macro Definitions"
;669	
;670		.TOC	"		Instruction Mnemonics"
;671	
;672		.TOC	"			Operate Class"
;673	
;674		.TOC	"				Arithmetic Group"
;675	
;676	.CREF
;677		ADD.B	  [ , ]		"OPC/ADD,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;678		ADD.W	  [ , ]		"OPC/ADD,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;679		ADD.L	  [ , ]		"OPC/ADD,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;680		ADD.B*	  [ , ]		"OPC/ADD,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;681		ADD.W*	  [ , ]		"OPC/ADD,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;682		ADD.L*	  [ , ]		"OPC/ADD,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;683	
;684		ADDC.B	  [ , ]		"OPC/ADDC,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;685		ADDC.W	  [ , ]		"OPC/ADDC,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;686		ADDC.L	  [ , ]		"OPC/ADDC,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;687		ADDC.B*	  [ , ]		"OPC/ADDC,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;688		ADDC.W*	  [ , ]		"OPC/ADDC,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;689		ADDC.L*	  [ , ]		"OPC/ADDC,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;690	
;691		INC.B	  [ , ]		"OPC/INC,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;692		INC.W	  [ , ]		"OPC/INC,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;693		INC.L	  [ , ]		"OPC/INC,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;694		INC.B*	  [ , ]		"OPC/INC,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;695		INC.W*	  [ , ]		"OPC/INC,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;696		INC.L*	  [ , ]		"OPC/INC,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;697	
;698		ADC.B	  [ , ]		"OPC/ADC,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;699		ADC.W	  [ , ]		"OPC/ADC,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;700		ADC.L	  [ , ]		"OPC/ADC,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;701		ADC.B*	  [ , ]		"OPC/ADC,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;702		ADC.W*	  [ , ]		"OPC/ADC,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;703		ADC.L*	  [ , ]		"OPC/ADC,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;704	
;705		SUB.B	  [ , ]		"OPC/SUB,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;706		SUB.W	  [ , ]		"OPC/SUB,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;707		SUB.L	  [ , ]		"OPC/SUB,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;708		SUB.B*	  [ , ]		"OPC/SUB,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;709		SUB.W*	  [ , ]		"OPC/SUB,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;710		SUB.L*	  [ , ]		"OPC/SUB,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;711	
;712		SUBC.B	  [ , ]		"OPC/SUBC,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;713		SUBC.W	  [ , ]		"OPC/SUBC,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;714		SUBC.L	  [ , ]		"OPC/SUBC,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;715		SUBC.B*	  [ , ]		"OPC/SUBC,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;716		SUBC.W*	  [ , ]		"OPC/SUBC,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;717		SUBC.L*	  [ , ]		"OPC/SUBC,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;718	
;719		DEC.B	  [ , ]		"OPC/DEC,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;720		DEC.W	  [ , ]		"OPC/DEC,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;721		DEC.L	  [ , ]		"OPC/DEC,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;722		DEC.B*	  [ , ]		"OPC/DEC,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   21
; DEFINE.MCD [242,1110]      Arithmetic Group

;723		DEC.W*	  [ , ]		"OPC/DEC,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;724		DEC.L*	  [ , ]		"OPC/DEC,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;725	
;726		SBC.B	  [ , ]		"OPC/SBC,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;727		SBC.W	  [ , ]		"OPC/SBC,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;728		SBC.L	  [ , ]		"OPC/SBC,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;729		SBC.B*	  [ , ]		"OPC/SBC,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;730		SBC.W*	  [ , ]		"OPC/SBC,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;731		SBC.L*	  [ , ]		"OPC/SBC,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;732	
;733		AOBC.B	  [ , ]		"OPC/AOBC,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;734		AOBC.W	  [ , ]		"OPC/AOBC,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;735		AOBC.L	  [ , ]		"OPC/AOBC,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;736		AOBC.B*	  [ , ]		"OPC/AOBC,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;737		AOBC.W*	  [ , ]		"OPC/AOBC,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;738		AOBC.L*	  [ , ]		"OPC/AOBC,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;739	
;740		SOBC.B	  [ , ]		"OPC/SOBC,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;741		SOBC.W	  [ , ]		"OPC/SOBC,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;742		SOBC.L	  [ , ]		"OPC/SOBC,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;743		SOBC.B*	  [ , ]		"OPC/SOBC,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;744		SOBC.W*	  [ , ]		"OPC/SOBC,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;745		SOBC.L*	  [ , ]		"OPC/SOBC,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;746	
;747		NEG.B	  [ , ]		"OPC/NEG,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;748		NEG.W	  [ , ]		"OPC/NEG,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;749		NEG.L	  [ , ]		"OPC/NEG,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;750		NEG.B*	  [ , ]		"OPC/NEG,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;751		NEG.W*	  [ , ]		"OPC/NEG,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;752		NEG.L*	  [ , ]		"OPC/NEG,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;753	
;754		NEGC.B	  [ , ]		"OPC/NEGC,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;755		NEGC.W	  [ , ]		"OPC/NEGC,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;756		NEGC.L	  [ , ]		"OPC/NEGC,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;757		NEGC.B*	  [ , ]		"OPC/NEGC,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;758		NEGC.W*	  [ , ]		"OPC/NEGC,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;759		NEGC.L*	  [ , ]		"OPC/NEGC,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;760	
;761		CNEG.B	  [ , ]		"OPC/CNEG,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;762		CNEG.W	  [ , ]		"OPC/CNEG,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;763		CNEG.L	  [ , ]		"OPC/CNEG,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;764		CNEG.B*	  [ , ]		"OPC/CNEG,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;765		CNEG.W*	  [ , ]		"OPC/CNEG,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;766		CNEG.L*	  [ , ]		"OPC/CNEG,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;767	
;768		ACNEG.B	  [ , ]		"OPC/ACNEG,  LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;769		ACNEG.W	  [ , ]		"OPC/ACNEG,  LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;770		ACNEG.L	  [ , ]		"OPC/ACNEG,  LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;771		ACNEG.B*  [ , ]		"OPC/ACNEG,  LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;772		ACNEG.W*  [ , ]		"OPC/ACNEG,  LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;773		ACNEG.L*  [ , ]		"OPC/ACNEG,  LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;774	
;775		NNEG.B	  [ , ]		"OPC/NNEG,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;776		NNEG.W	  [ , ]		"OPC/NNEG,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;777		NNEG.L	  [ , ]		"OPC/NNEG,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   22
; DEFINE.MCD [242,1110]      Arithmetic Group

;778		NNEG.B*	  [ , ]		"OPC/NNEG,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;779		NNEG.W*	  [ , ]		"OPC/NNEG,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;780		NNEG.L*	  [ , ]		"OPC/NNEG,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;781	
;782		ANNEG.B	  [ , ]		"OPC/ANNEG,  LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;783		ANNEG.W	  [ , ]		"OPC/ANNEG,  LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;784		ANNEG.L	  [ , ]		"OPC/ANNEG,  LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;785		ANNEG.B*  [ , ]		"OPC/ANNEG,  LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;786		ANNEG.W*  [ , ]		"OPC/ANNEG,  LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;787		ANNEG.L*  [ , ]		"OPC/ANNEG,  LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;788	
;789		CMP.B	  [ , ]		"OPC/CMP,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;790		CMP.W	  [ , ]		"OPC/CMP,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;791		CMP.L	  [ , ]		"OPC/CMP,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;792		CMP.B*	  [ , ]		"OPC/CMP,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;793		CMP.W*	  [ , ]		"OPC/CMP,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;794		CMP.L*	  [ , ]		"OPC/CMP,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;795	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   23
; DEFINE.MCD [242,1110]      Logical Group

;796		.TOC	"				Logical Group"
;797	
;798		MOV.B	  [ , ]		"OPC/MOV,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;799		MOV.W	  [ , ]		"OPC/MOV,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;800		MOV.L	  [ , ]		"OPC/MOV,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;801		MOV.B*	  [ , ]		"OPC/MOV,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;802		MOV.W*	  [ , ]		"OPC/MOV,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;803		MOV.L*	  [ , ]		"OPC/MOV,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;804	
;805		MOVPM.B	  [ , ]		"OPC/MOVPM,  LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;806		MOVPM.W	  [ , ]		"OPC/MOVPM,  LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;807		MOVPM.L	  [ , ]		"OPC/MOVPM,  LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;808		MOVPM.B*  [ , ]		"OPC/MOVPM,  LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;809		MOVPM.W*  [ , ]		"OPC/MOVPM,  LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;810		MOVPM.L*  [ , ]		"OPC/MOVPM,  LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;811	
;812		MOVS.B	  [ , ]		"OPC/MOVS,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;813		MOVS.W	  [ , ]		"OPC/MOVS,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;814		MOVS.L	  [ , ]		"OPC/MOVS,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;815		MOVS.B*	  [ , ]		"OPC/MOVS,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;816		MOVS.W*	  [ , ]		"OPC/MOVS,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;817		MOVS.L*	  [ , ]		"OPC/MOVS,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;818	
;819		CLR.B	  [ , ]		"OPC/CLR,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;820		CLR.W	  [ , ]		"OPC/CLR,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;821		CLR.L	  [ , ]		"OPC/CLR,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;822		CLR.B*	  [ , ]		"OPC/CLR,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;823		CLR.W*	  [ , ]		"OPC/CLR,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;824		CLR.L*	  [ , ]		"OPC/CLR,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;825	
;826		COM.B	  [ , ]		"OPC/COM,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;827		COM.W	  [ , ]		"OPC/COM,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;828		COM.L	  [ , ]		"OPC/COM,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;829		COM.B*	  [ , ]		"OPC/COM,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;830		COM.W*	  [ , ]		"OPC/COM,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;831		COM.L*	  [ , ]		"OPC/COM,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;832	
;833		SXT.B	  [ , ]		"OPC/SXT,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;834		SXT.W	  [ , ]		"OPC/SXT,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;835		SXT.L	  [ , ]		"OPC/SXT,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;836		SXT.B*	  [ , ]		"OPC/SXT,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;837		SXT.W*	  [ , ]		"OPC/SXT,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;838		SXT.L*	  [ , ]		"OPC/SXT,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;839	
;840		AND.B	  [ , ]		"OPC/AND,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;841		AND.W	  [ , ]		"OPC/AND,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;842		AND.L	  [ , ]		"OPC/AND,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;843		AND.B*	  [ , ]		"OPC/AND,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;844		AND.W*	  [ , ]		"OPC/AND,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;845		AND.L*	  [ , ]		"OPC/AND,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;846	
;847		BIC.B	  [ , ]		"OPC/BIC,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;848		BIC.W	  [ , ]		"OPC/BIC,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;849		BIC.L	  [ , ]		"OPC/BIC,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;850		BIC.B*	  [ , ]		"OPC/BIC,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   24
; DEFINE.MCD [242,1110]      Logical Group

;851		BIC.W*	  [ , ]		"OPC/BIC,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;852		BIC.L*	  [ , ]		"OPC/BIC,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;853	
;854		BIS.B	  [ , ]		"OPC/BIS,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;855		BIS.W	  [ , ]		"OPC/BIS,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;856		BIS.L	  [ , ]		"OPC/BIS,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;857		BIS.B*	  [ , ]		"OPC/BIS,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;858		BIS.W*	  [ , ]		"OPC/BIS,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;859		BIS.L*	  [ , ]		"OPC/BIS,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;860	
;861		XOR.B	  [ , ]		"OPC/XOR,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;862		XOR.W	  [ , ]		"OPC/XOR,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;863		XOR.L	  [ , ]		"OPC/XOR,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;864		XOR.B*	  [ , ]		"OPC/XOR,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;865		XOR.W*	  [ , ]		"OPC/XOR,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;866		XOR.L*	  [ , ]		"OPC/XOR,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;867	
;868		BIT.B	  [ , ]		"OPC/BIT,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;869		BIT.W	  [ , ]		"OPC/BIT,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;870		BIT.L	  [ , ]		"OPC/BIT,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;871		BIT.B*	  [ , ]		"OPC/BIT,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;872		BIT.W*	  [ , ]		"OPC/BIT,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;873		BIT.L*	  [ , ]		"OPC/BIT,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;874	
;875		TST.B	  [ , ]		"OPC/TST,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;876		TST.W	  [ , ]		"OPC/TST,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;877		TST.L	  [ , ]		"OPC/TST,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;878		TST.B*	  [ , ]		"OPC/TST,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;879		TST.W*	  [ , ]		"OPC/TST,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;880		TST.L*	  [ , ]		"OPC/TST,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;881	
;882		MTST	  [ , ]		"OPC/MTST,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;883		MTST*	  [ , ]		"OPC/MTST,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;884	
;885		SWAB.B	  [ , ]		"OPC/SWAB,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;886		SWAB.W	  [ , ]		"OPC/SWAB,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;887		SWAB.L	  [ , ]		"OPC/SWAB,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;888		SWAB.B*	  [ , ]		"OPC/SWAB,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;889		SWAB.W*	  [ , ]		"OPC/SWAB,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;890		SWAB.L*	  [ , ]		"OPC/SWAB,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;891	
;892		NOP.B	  [ , ]		"OPC/NOP,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;893		NOP.W	  [ , ]		"OPC/NOP,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;894		NOP.L	  [ , ]		"OPC/NOP,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;895		NOP.B*	  [ , ]		"OPC/NOP,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;896		NOP.W*	  [ , ]		"OPC/NOP,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;897		NOP.L*	  [ , ]		"OPC/NOP,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;898	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   25
; DEFINE.MCD [242,1110]      Shift Group

;899		.TOC	"				Shift Group"
;900	
;901		ASR.B	  [ , ]		"OPC/ASR,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;902		ASR.W	  [ , ]		"OPC/ASR,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;903		ASR.L	  [ , ]		"OPC/ASR,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;904		ASR.B*	  [ , ]		"OPC/ASR,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;905		ASR.W*	  [ , ]		"OPC/ASR,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;906		ASR.L*	  [ , ]		"OPC/ASR,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;907	
;908		ROR.B	  [ , ]		"OPC/ROR,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;909		ROR.W	  [ , ]		"OPC/ROR,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;910		ROR.L	  [ , ]		"OPC/ROR,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;911		ROR.B*	  [ , ]		"OPC/ROR,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;912		ROR.W*	  [ , ]		"OPC/ROR,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;913		ROR.L*	  [ , ]		"OPC/ROR,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;914	
;915		LSR.B	  [ , ]		"OPC/LSR,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;916		LSR.W	  [ , ]		"OPC/LSR,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;917		LSR.L	  [ , ]		"OPC/LSR,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;918		LSR.B*	  [ , ]		"OPC/LSR,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;919		LSR.W*	  [ , ]		"OPC/LSR,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;920		LSR.L*	  [ , ]		"OPC/LSR,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;921	
;922		LSR.Q	  [ , ]		"OPC/LSRQ,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;923		LSR.Q*	  [ , ]		"OPC/LSRQ,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;924	
;925		ASL.B	  [ , ]		"OPC/ASL,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;926		ASL.W	  [ , ]		"OPC/ASL,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;927		ASL.L	  [ , ]		"OPC/ASL,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;928		ASL.B*	  [ , ]		"OPC/ASL,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;929		ASL.W*	  [ , ]		"OPC/ASL,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;930		ASL.L*	  [ , ]		"OPC/ASL,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;931	
;932		ASL.Q	  [ , ]		"OPC/ASLQ,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;933		ASL.Q*	  [ , ]		"OPC/ASLQ,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;934	
;935		ROL.B	  [ , ]		"OPC/ROL,    LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@2"
;936		ROL.W	  [ , ]		"OPC/ROL,    LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;937		ROL.L	  [ , ]		"OPC/ROL,    LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;938		ROL.B*	  [ , ]		"OPC/ROL,    LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;939		ROL.W*	  [ , ]		"OPC/ROL,    LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;940		ROL.L*	  [ , ]		"OPC/ROL,    LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;941	
;942	
;943		.TOC	"				Multiply/Divide Group"
;944	
;945		UMULS.W	  [ , ]		"OPC/UMULS,  LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;946		UMULS.L	  [ , ]		"OPC/UMULS,  LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;947		UMULS.W*  [ , ]		"OPC/UMULS,  LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;948		UMULS.L*  [ , ]		"OPC/UMULS,  LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;949	
;950		SMULS.W	  [ , ]		"OPC/SMULS,  LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;951		SMULS.L	  [ , ]		"OPC/SMULS,  LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;952		SMULS.W*  [ , ]		"OPC/SMULS,  LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;953		SMULS.L*  [ , ]		"OPC/SMULS,  LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   26
; DEFINE.MCD [242,1110]      Multiply/Divide Group

;954	
;955		DIVS.W	  [ , ]		"OPC/DIVS,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@2"
;956		DIVS.L	  [ , ]		"OPC/DIVS,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;957		DIVS.W*	  [ , ]		"OPC/DIVS,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;958		DIVS.L*	  [ , ]		"OPC/DIVS,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;959	
;960		XLDIVS    [ , ]		"OPC/XLDIVS, LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;961		XLDIVS*   [ , ]		"OPC/XLDIVS, LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;962	
;963		XHDIVS    [ , ]		"OPC/XHDIVS, LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@2"
;964		XHDIVS*   [ , ]		"OPC/XHDIVS, LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@2"
;965	
;966	
;967		.TOC	"				Decimal Group"
;968	
;969		DADP.B	  [ ]		"OPC/DADP,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@1"
;970		DADP.W	  [ ]		"OPC/DADP,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@1"
;971		DADP.L	  [ ]		"OPC/DADP,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@1"
;972		DADP.B*	  [ ]		"OPC/DADP,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@1"
;973		DADP.W*	  [ ]		"OPC/DADP,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@1"
;974		DADP.L*	  [ ]		"OPC/DADP,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@1"
;975	
;976		PDAD.B	  [ ]		"OPC/PDAD,   LN/BYTE, CC/SAME,   B-PORT/@1, A-PORT/@1"
;977		PDAD.W	  [ ]		"OPC/PDAD,   LN/WORD, CC/SAME,   B-PORT/@1, A-PORT/@1"
;978		PDAD.L	  [ ]		"OPC/PDAD,   LN/LONG, CC/SAME,   B-PORT/@1, A-PORT/@1"
;979		PDAD.B*	  [ ]		"OPC/PDAD,   LN/BYTE, CC/UPDATE, B-PORT/@1, A-PORT/@1"
;980		PDAD.W*	  [ ]		"OPC/PDAD,   LN/WORD, CC/UPDATE, B-PORT/@1, A-PORT/@1"
;981		PDAD.L*	  [ ]		"OPC/PDAD,   LN/LONG, CC/UPDATE, B-PORT/@1, A-PORT/@1"
;982	
;983	
;984		.TOC	"				Prefetch Group"
;985	
;986		RSYNC			"OPC/RSYNC,   LN/WORD, CC/SAME, A-PORT/PS"
;987	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   27
; DEFINE.MCD [242,1110]      Literal Class

;988		.TOC	"			Literal Class"
;989	
;990		LLD.B	  [ , ]		"OPC/LLD,   LN/BYTE, LIT/@1, A-PORT/@2"
;991		LLD.W	  [ , ]		"OPC/LLD,   LN/WORD, LIT/@1, A-PORT/@2"
;992		LLD.L	  [ , ]		"OPC/LLD,   LN/LONG, LIT/@1, A-PORT/@2"
;993	
;994		LLSW.B	  [ , ]		"OPC/LLSW,  LN/BYTE, LIT/@1, A-PORT/@2"
;995		LLSW.W	  [ , ]		"OPC/LLSW,  LN/WORD, LIT/@1, A-PORT/@2"
;996		LLSW.L	  [ , ]		"OPC/LLSW,  LN/LONG, LIT/@1, A-PORT/@2"
;997	
;998		LLCM.B	  [ , ]		"OPC/LLCM,  LN/BYTE, LIT/@1, A-PORT/@2"
;999		LLCM.W	  [ , ]		"OPC/LLCM,  LN/WORD, LIT/@1, A-PORT/@2"
;1000		LLCM.L	  [ , ]		"OPC/LLCM,  LN/LONG, LIT/@1, A-PORT/@2"
;1001	
;1002		LCNTR.B	  [ , ]		"OPC/LCNTR, LN/BYTE, LIT/@1, A-PORT/@2"
;1003		LCNTR.W	  [ , ]		"OPC/LCNTR, LN/WORD, LIT/@1, A-PORT/@2"
;1004		LCNTR.L	  [ , ]		"OPC/LCNTR, LN/LONG, LIT/@1, A-PORT/@2"
;1005	
;1006		LMSTK	  [ , ]		"OPC/LMSTK, CJAR/<NAF/@1>, A-PORT/@2"
;1007	
;1008		LCMP.B	  [ , ]		"OPC/LCMP,  LN/BYTE, LIT/@1, A-PORT/@2"
;1009		LCMP.W	  [ , ]		"OPC/LCMP,  LN/WORD, LIT/@1, A-PORT/@2"
;1010		LCMP.L	  [ , ]		"OPC/LCMP,  LN/LONG, LIT/@1, A-PORT/@2"
;1011	
;1012		LADD.B	  [ , ]		"OPC/LADD,  LN/BYTE, LIT/@1, A-PORT/@2"
;1013		LADD.W	  [ , ]		"OPC/LADD,  LN/WORD, LIT/@1, A-PORT/@2"
;1014		LADD.L	  [ , ]		"OPC/LADD,  LN/LONG, LIT/@1, A-PORT/@2"
;1015	
;1016		LSUB.B	  [ , ]		"OPC/LSUB,  LN/BYTE, LIT/@1, A-PORT/@2"
;1017		LSUB.W	  [ , ]		"OPC/LSUB,  LN/WORD, LIT/@1, A-PORT/@2"
;1018		LSUB.L	  [ , ]		"OPC/LSUB,  LN/LONG, LIT/@1, A-PORT/@2"
;1019	
;1020		LBIS.B	  [ , ]		"OPC/LBIS,  LN/BYTE, LIT/@1, A-PORT/@2"
;1021		LBIS.W	  [ , ]		"OPC/LBIS,  LN/WORD, LIT/@1, A-PORT/@2"
;1022		LBIS.L	  [ , ]		"OPC/LBIS,  LN/LONG, LIT/@1, A-PORT/@2"
;1023	
;1024		LAND.B	  [ , ]		"OPC/LAND,  LN/BYTE, LIT/@1, A-PORT/@2"
;1025		LAND.W	  [ , ]		"OPC/LAND,  LN/WORD, LIT/@1, A-PORT/@2"
;1026		LAND.L	  [ , ]		"OPC/LAND,  LN/LONG, LIT/@1, A-PORT/@2"
;1027	
;1028		LBIC.B	  [ , ]		"OPC/LBIC,  LN/BYTE, LIT/@1, A-PORT/@2"
;1029		LBIC.W	  [ , ]		"OPC/LBIC,  LN/WORD, LIT/@1, A-PORT/@2"
;1030		LBIC.L	  [ , ]		"OPC/LBIC,  LN/LONG, LIT/@1, A-PORT/@2"
;1031	
;1032		LBIT.B	  [ , ]		"OPC/LBIT,  LN/BYTE, LIT/@1, A-PORT/@2"
;1033		LBIT.W	  [ , ]		"OPC/LBIT,  LN/WORD, LIT/@1, A-PORT/@2"
;1034		LBIT.L	  [ , ]		"OPC/LBIT,  LN/LONG, LIT/@1, A-PORT/@2"
;1035	
;1036		LXOR.B	  [ , ]		"OPC/LXOR,  LN/BYTE, LIT/@1, A-PORT/@2"
;1037		LXOR.W	  [ , ]		"OPC/LXOR,  LN/WORD, LIT/@1, A-PORT/@2"
;1038		LXOR.L	  [ , ]		"OPC/LXOR,  LN/LONG, LIT/@1, A-PORT/@2"
;1039	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   28
; DEFINE.MCD [242,1110]      Address Class

;1040		.TOC	"			Address Class"
;1041	
;1042		AR	  [ ]		"OPC/AR,  LN/WORD, A-PORT/@1"
;1043	
;1044		ARI.B	  [ ]		"OPC/ARI, LN/WRD1, A-PORT/@1"
;1045		ARI.W	  [ ]		"OPC/ARI, LN/WORD, A-PORT/@1"
;1046	
;1047		ARD.B	  [ ]		"OPC/ARD, LN/WRD1, A-PORT/@1"
;1048		ARD.W	  [ ]		"OPC/ARD, LN/WORD, A-PORT/@1"
;1049	
;1050		AW	  [ ]		"OPC/AW,  LN/WORD, A-PORT/@1"
;1051	
;1052		AWI.B	  [ ]		"OPC/AWI, LN/WRD1, A-PORT/@1"
;1053		AWI.W	  [ ]		"OPC/AWI, LN/WORD, A-PORT/@1"
;1054	
;1055		AWD.B	  [ ]		"OPC/AWD, LN/WRD1, A-PORT/@1"
;1056		AWD.W	  [ ]		"OPC/AWD, LN/WORD, A-PORT/@1"
;1057	
;1058		ARG.W	  [ ]		"OPC/ARG, LN/WORD, GPA/@1"
;1059	
;1060		AWG.W	  [ ]		"OPC/AWG, LN/WORD, GPA/@1"
;1061	
;1062	
;1063		.TOC	"			Internal Input/Output Class"
;1064	
;1065		INPR.W	  [ , ]		"OPC/INPR, LN/WORD, RMMU/@1, A-PORT/@2"
;1066		INPR.L	  [ , ]		"OPC/INPR, LN/LONG, RMMU/@1, A-PORT/@2"
;1067	
;1068		OUTR.W	  [ , ]		"OPC/OUTR, LN/WORD, RMMU/@1, A-PORT/@2"
;1069		OUTR.L	  [ , ]		"OPC/OUTR, LN/LONG, RMMU/@1, A-PORT/@2"
;1070	
;1071		OUTS	  [ ]		"OPC/OUTS, LN/WORD, OUTS_CONTROL/@1"
;1072		OUTS	  [ , ]		"OPC/OUTS, LN/WORD, OUTS_CONTROL/@1, A-PORT/@2"
;1073	
;1074		OUTC	  [ ]		"OPC/OUTC, LN/WORD, OUTC_CONTROL/@1"
;1075	
;1076	
;1077		.TOC	"			External Input/Output Class"
;1078	
;1079		RD.B	  [ ]		"OPC/RD,     LN/BYTE, A-PORT/@1"
;1080		RD.W	  [ ]		"OPC/RD,     LN/WORD, A-PORT/@1"
;1081	
;1082		RMW.B	  [ ]		"OPC/RMW,    LN/BYTE, A-PORT/@1"
;1083		RMW.W	  [ ]		"OPC/RMW,    LN/WORD, A-PORT/@1"
;1084	
;1085		RDG.B	  [ ]		"OPC/RDG,    LN/BYTE, A-PORT/@1"
;1086		RDG.W	  [ ]		"OPC/RDG,    LN/WORD, A-PORT/@1"
;1087	
;1088		RDINTR	  [ ]		"OPC/RDINTR, LN/WORD, A-PORT/@1"
;1089	
;1090		RDI	  [ ]		"OPC/RDI,    LN/WORD, A-PORT/@1"
;1091	
;1092		RDF			"OPC/RDF,    LN/WORD"
;1093	
;1094	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   29
; DEFINE.MCD [242,1110]      Jump Class

;1095		.TOC	"			Jump Class"
;1096	
;1097		JAN	  [ ]		"OPC/JAN, CJAR/<NAF/@1>"
;1098		JAZ	  [ ]		"OPC/JAZ, CJAR/<NAF/@1>"
;1099		JAC	  [ ]		"OPC/JAC, CJAR/<NAF/@1>"
;1100		JAV	  [ ]		"OPC/JAV, CJAR/<NAF/@1>"
;1101		JN	  [ ]		"OPC/JN,  CJAR/<NAF/@1>"
;1102		JZ	  [ ]		"OPC/JZ,  CJAR/<NAF/@1>"
;1103		JC	  [ ]		"OPC/JC,  CJAR/<NAF/@1>"
;1104		JV	  [ ]		"OPC/JV,  CJAR/<NAF/@1>"
;1105		JKM	  [ ]		"OPC/JKM, CJAR/<NAF/@1>"
;1106	
;1107		JMP	  [ , ]		"OPC/JMP, CJAR/<NAF/@1>, CSEL/@2"
;1108	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   30
; DEFINE.MCD [242,1110]      Control Field Mnemonics

;1109		.TOC	"		Control Field Mnemonics"
;1110	
;1111		.TOC	"			Operate Type"
;1112	
;1113		PREFETCH		"PF/YES"
;1114		DECR CNTR		"DC/DECR"
;1115	
;1116	
;1117		.TOC	"			Address Type"
;1118	
;1119		I SPACE			"SPACE/I"
;1120		D SPACE			"SPACE/D"
;1121		MFPI SPACE		"SPACE/MFPI"
;1122	
;1123		NO ABORTS		"ABORTS/DISABLE"
;1124		16-BIT MAP		"ABORTS/DISABLE"
;1125	
;1126		ODD TRAP		"TRAP/YES"
;1127	
;1128		SOVFF			"OVF/YES"
;1129	
;1130		KERNEL MODE		"MODE/KERNEL"
;1131		PREVIOUS MODE		"MODE/PREVIOUS"
;1132		CONSOLE MODE		"MODE/CONSOLE"
;1133	
;1134		LD MMR1			"MMR1/UPDATE"
;1135	
;1136	
;1137		.TOC	"			External Input/Output Type"
;1138	
;1139		RTI-RTT PS PROTECT	"RD_CONTROL/RTI-RTT"
;1140		VECTOR PS PROTECT	"RD_CONTROL/VECTOR"
;1141		READ LOCKED		"RD_CONTROL/LOCKED"
;1142	
;1143	
;1144		.TOC	"			Diagnostic Type"
;1145	
;1146	.NOCREF
;1147	
;1148		BK25			"BR0/ON"
;1149		BK125			"BR1/ON"
;1150		BK225			"BR2/ON"
;1151		BK325			"BR3/ON"
;1152	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   31
; DEFINE.MCD [242,1110]      PLA Mnemonics

;1153		.TOC	"		PLA Mnemonics"
;1154	
;1155		.TOC	"			PLA Input Mnemonics"
;1156	
;1157		PLA0	[ , ]		"NAF0/<.GETONES[@1]>,
;1158					 NAFX/<.GETXS[@1]>,
;1159					 PIR1/<.GETONES[@2]>,
;1160					 PIRX/<.GETXS[@2]>"
;1161	
;1162		PLA1	[ , ]		"NAF1/<.GETONES[@1]>,
;1163					 NAFX/<.GETXS[@1]>,
;1164					 PIR1/<.GETONES[@2]>,
;1165					 PIRX/<.GETXS[@2]>"
;1166	
;1167		NPLA0	[ , ]		"NAF0/<.AND[<NAF/@1>,177]>,
;1168					 NAFX/0,
;1169					 PIR1/<.GETONES[@2]>,
;1170					 PIRX/<.GETXS[@2]>"
;1171	
;1172		NPLA1	[ , ]		"NAF1/<.AND[<NAF/@1>,177]>,
;1173					 NAFX/0,
;1174					 PIR1/<.GETONES[@2]>,
;1175					 PIRX/<.GETXS[@2]>"
;1176	
;1177		.TOC	"			PLA Override Mnemonics"
;1178	
;1179		BYTE --> WORD		"LN/WORD"
;1180	
;1181		WRITE --> READ		"PLAOPC/RDOVR"
;1182	
;1183		RE_RE --> RDST_RDST	"MICROINSTRUCTION/17776347"
;1184	
;1185	
;1186	
;1187	
;1188		.REGION/0,377/1000,3777
;1189	
;1190	
;1191	1252:					; This ROM based jump for chip testing.
;1192		JMP	[1777, 37],		; Mask code inserted in jump field
;1193				NAF/1777	;  and NAF.
;1194	
;1195		.TOC	""			; Start code listing on new page.
;1196		.TOC	""
;1197		.TOC	""
;1198		.TOC	""
;1199		.TOC	""
;1200		.TOC	""
;1201		.TOC	""
;1202	
;1203	
;1204	
				;1205	.BIN
				;1206	.CREF
				;1207	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   32
; BASE  .MCD [242,1110]                                                                                                       

				;1208	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   33
; BASE  .MCD [242,1110]      BASE.MCD

				;1209		.TOC	"BASE.MCD"
				;1210		.TOC	"REVISION 3.39"
				;1211	
				;1212	
;1213	.NOBIN
;1214	
;1215	
;1216	
;1217		.TOC	"	Revision History"
;1218	
;1219	;
;1220	;	Revision History
;1221	;	----------------
;1222	;
;1223	; Rev.	  Date		Explaination
;1224	; ----	  ----		------------
;1225	;
;1226	; 3.39	01/20/83	Hard coded certain addresses such as yellow zone
;1227	;			and resync to make certain they do not change.
;1228	;	Release		01/04/83	(Mini-pass for RTI-RTT fix)
;1229	; 3.38	01/04/83	KEH; Add FEC masking (LAND.W) during FPE service
;1230	; 3.37	01/03/83	VO;  Changed RTI-RTT code to perform PS protection
;1231	;			     directly in microcode due to Data-chip problems
;1232	;	Release
;1233	; 3.36	07/14/82	KEH; Move chip testing jump off chip to DEFINE.MCD.
;1234	;	Release
;1235	; 2.35	01/27/82	KEH; Changed use of RF to RD in P-U-T due to confict
;1236	;			     with power up option 3.
;1237	; 2.34	01/26/82	KEH; Integrated Power Up Test into this code.
;1238	; 2.33	01/26/82	KEH; Modified revision code to represent chip pass.
;1239	; 2.32	01/15/82	KEH; Switched sense of CPFF for warm FP.
;1240	; 2.31	01/02/82	KEH; Moved P.OPTION to bank 0 by changing option 0
;1241	;			     and P-U-T entry point.
;1242	; 2.30	12/15/81	KEH; Added LED 4 write for ODT exit (at PWR-UP-ODT).
;1243	; 2.29	11/25/81	KEH; Integrated NPLA for pass two code.  No code change.
;1244	; 2.28	11/20/81	KEH; Saved two words.  RESET5 shared with ODT and SI
;1245	;			     initialization during power up.  RESET5 is used to
;1246	;			     set NAs of miscellaneous aborts.  Also updated all
;1247	;			     GP mnemonics and functions.
;1248	; 2.27	11/18/81	KEH; Used LMSTK to load constant in CSM; saved a word.
;1249	; 2.26	10/01/81	KEH; Changed RESET-NOP register for FP11 (RA => RF).
;1250	; 2.25	08/10/81	KEH; Changed FPE acknowledge for FP11.
;1251	;	Release
;1252	; 1.24	06/23/81	KEH; Added Power Up Test, MEVENT-L, and JMP off chip.
;1253	; 1.23	05/11/81	KEH; Changed power up option 3 as to new specification.
;1254	; 1.22	04/04/81	KEH; Fixed bug with RSYNC, ID1 by altering DEFINE.MCD;
;1255	;			     must specify 16-bit register on MPRDC-L.
;1256	;			     Eliminated unnecessary constraints by changing
;1257	;			     RE -> RDST NAF overrides.  Renamed an FP11 symbol.
;1258	; 1.21	03/18/81	KEH; Fixed bug with not updating CC's for MFPx and MTPx.
;1259	; 1.20	03/08/81	KEH; Added TSTSET and WRTLCK, multiprocessor hooks.
;1260	; 1.19	03/05/81	KEH; Added corrections suggested at code review.
;1261	;			     Changes to Power Up - added abort to ODT mechanism,
;1262	;			     changed options 2 and 3 around, and added abort
;1263	;			     on CCR as well as MSER initialization.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   34
; BASE  .MCD [242,1110]      Revision History

;1264	;			     Added that RESET clears PIRQ.
;1265	;			     Added that CSM fetches new PC from I Space.
;1266	; 1.18	03/02/81	KEH; Changed Base Code Abort and Multiple Abort to
;1267	;			     reflect change in Abort Service information.
;1268	;			     Also removed CPU Error register<15>.
;1269	; 1.17	02/15/81	KEH; Added CC twittle at DIV0 for 11/70 compatibility (no cost).
;1270	; 1.16	02/10/81	KEH; Removed LD MMR1 when powering up through vector 24.
;1271	; 1.15	02/09/81	KEH; Added restoration of original operands when DIV overflows.
;1272	; 1.14	01/30/81	KEH; Major modifications to ASH, ASHC, and SPL.  Reduced overhead
;1273	;			     in ASH and ASHC.  Reduced ROM count in exchange for PLA.
;1274	; 1.13	01/16/81	KEH; Fixed oversite in Rev 1.12 and added PLA for MFPS Mode 0.
;1275	; 1.12	01/15/81	KEH; Reorganized JOPs and added JSR Mode 37 optimization.
;1276	; 1.11	01/15/81	KEH; Fixed bug in Source Modes 4 and 5.
;1277	; 1.10	01/11/81	KEH; Cleaned up WAIT, Interrupt Service, Base Abort, and M-TRAP.
;1278	; 1.09	01/06/81	KEH; Started changes for Q-Logic IRDF fix.
;1279	; 1.08	01/05/81	KEH; Made power-up sequence a subroutine for ODT.
;1280	; 1.05	12/04/80	KEH; Changed M-TRAP and Multiple Abort routines for sunset loop prevention.
;1281	; 1.00	11/13/80	KEH; Edited and assembled.
;1282	; 0.76	08/04/80	KEH; Preliminary.
;1283	;
;1284	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   35
; BASE  .MCD [242,1110]      Introductory Remarks

;1285		.PAGE	"	Introductory Remarks"
;1286	
;1287	;
;1288	;	This microcode implements the PDP-11 Base Instruction Set.
;1289	;	This includes power-up and all interrupt and abort processing.
;1290	;
;1291	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   36
; BASE  .MCD [242,1110]      Power Up

;1292		.TOC	"	Power Up"
;1293	
;1294	;
;1295	; Entry Conditions:
;1296	;
;1297	;	NA = 000; NA was zeroed by MINIT-L.
;1298	;
;1299	;	Entered on Power Up.
;1300	;
;1301	; Exit Conditions:
;1302	;
;1303	;	Dependent on Power Up options.
;1304	;
;1305	;	Option		Result
;1306	;	------		------
;1307	;	  0	Vector through location 24.
;1308	;	  1	Enter ODT.
;1309	;	  2	Power up to 173000.
;1310	;	  3	Power up to user boot address.
;1311	;
;1312	; Method:
;1313	;
;1314	;	The BINIT-L line is asserted through use of a GP code and MMR0 and MMR3
;1315	;	are cleared.  The CPU Error Register and Floating Point Status registers
;1316	;	are cleared.  A GP code then reads in POKH and the Power Up options and
;1317	;	waits for POKH to be asserted.  The CPFF is also set (if specified) at
;1318	;	this time.  The external Memory System Error (if it exists), the Cache
;1319	;	Control, and the Programmed Interrupt Request Registers are then also
;1320	;	cleared using explicit addresses.  The Power Up Test is executed and
;1321	;	finally, the Power Up options are decoded and each one is serviced
;1322	;	accordingly.
;1323	;
;1324	; Assumptions:
;1325	;
;1326	;	It is assumed that a set of jumpers on the CPU board which can be
;1327	;	read with the GP code "OPTIONS" is configured as follows:
;1328	;
;1329	;	  15  14  13  12  11  10  9   8   7   6   5   4   3   2   1   0
;1330	;	+---------------------------------------------------------------+
;1331	;	|			    |   |               |H O|       |   |
;1332	;	|	    USER	    |F H|		|A P| POWER | P |
;1333	;	|	  SUPPLIED	    |P E|    MODULE	|L T|  UP   | O |
;1334	;	|	    BOOT	    |A R|      ID	|T I| OPTION| K |
;1335	;	|	  ADDRESS	    |  E|		|  O|       | H |
;1336	;	|			    |   |               |  N|       |   |
;1337	;	+---------------------------------------------------------------+
;1338	;
;1339	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   37
; BASE  .MCD [242,1110]      Power Up

				;1340	.BIN
				;1341	
				;1342	; See Multiple Abort routine for actual context.
				;1343	
				;1344	;0:
				;1345	;MULTIPLE-ABORT:
				;1346	;	OUTS	[ABORTS]		; PIR<12,7,4:0> <-- HLTFF, SSFF, ABFF<4:0>.
				;1347	;
				;1348	;	NOP.W	[RF, RF],		; Allow time for PLA translation.
				;1349	;			NAF/407		; Invoke PLA decode.
				;1350	;
				;1351	;H-POKH-F:	; POKH is not asserted.
				;1352	;POWER-UP:	; ABFF<0> = 0.  Power up.
				;1353	;=10********0
				;1354	;PLA0	[^0 00X 111, ^X XXX XXX XXX XXX XX0]
				;1355	;	LMSTK	[P-U-T1, RA],		; Set up return to do Power Up Test.
				;1356	;			NAF/PWR-UP-ODT	; Go to "Power Up" sequence.
				;1357	;=
				;1358	PWR-UP-ODT:				; Entry for console "G" initialization.
U 0007, 0000,0670,1637,0013	;1359		AWG.W	[LED4_OFF]		; Signal exit from ODT.
				;1360	
				;1361						; See constraint on PWR-UP1.
U 0013, 0000,0530,0172,0014	;1362		LMSTK	[PWR-UP1, RA]		; Load return from bus init routine.
				;1363	
				;1364		OUTC	[INI_ALL],		; Clear PTYFF, ITFF and SOVFF, set CPFF and SSFF.
U 0014, 0000,0260,1477,0032	;1365				NAF/RESET-SUB	; Go reset the bus.
				;1366	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   38
; BASE  .MCD [242,1110]      Power Up

				;1367	; Reset the bus and turn off Memory Management.
				;1368	
				;1369	RESET-SUB:
U 0032, 0000,0670,0637,1500	;1370		AWG.W	[BINIT_ON]		; Assert BINIT L next cycle.
				;1371	
				;1372	1500:					; For TUMS use only.
				;1373		LCNTR.W	[105, RA],		; Load CNTR for 10 us wait (69.).
U 1500, 0000,0520,4272,0017	;1374				NAF/RESET1	; Start wait loop.  Skip next instruction.
				;1375	=0					; Constrain NAF for CNTR loop.
				;1376		AWG.W	[BINIT_OFF],		; Deassert BINIT L next cycle.
U 0016, 0000,0671,0637,1501	;1377				NAF/RESET2	; Go turn off BINIT L.  Skip next instruction.
				;1378	RESET1:
				;1379		CLR.W	[RA, RA],		; Clear EU register for OUTR.
				;1380			DECR CNTR,		; Loop here for a while.
U 0017, 0000,1041,3532,0017	;1381				NAF/RESET1	; Go back one when done.
				;1382	=
				;1383	1501:					; For TUMS use only.
				;1384	RESET2:
				;1385		LCNTR.W	[310, RB],		; Load CNTR for 90 us wait (200.).
U 1501, 0000,0521,4433,0055	;1386				NAF/RESET3	; Skip past next instruction.
				;1387	
				;1388	=0					; Constrain NAF for CNTR loop.
				;1389		LLCM.W	[005, RE],		; RE <-- 177772, PIRQ.
U 0054, 0000,0470,0276,0070	;1390				NAF/RESET4	; Skip over loop.
				;1391	RESET3:
U 0055, 0000,0251,0032,0041	;1392		OUTR.W	[MMR0, RA]		; Clear MMR0.
				;1393	=
U 0041, 0000,0251,0132,0043	;1394		OUTR.W	[MMR3, RA]		; Clear MMR3.
				;1395	
				;1396		MOV.W	[PC, PC],		; Clear PPCV since MMU gets turned off.
				;1397			DECR CNTR,		; Decrement the loop counter.
U 0043, 0000,1561,3367,0055	;1398				NAF/RESET3	; Loop on three microinstructions.
				;1399	RESET4:
				;1400		AW	[RE],			; Stuff PIRQ address into OL.  MMU is off.
U 0070, 0000,0771,7776,0024	;1401				NAF/RESET5	; Write a zero to PIRQ.
				;1402	
				;1403	;=0*0****0				; Abort to ROM[0] for ODT I/O routines.
				;1404	;RESET5:				; Return from print loop in ODT.
				;1405	;	CLR.W	[RA, RA],		; For RESET-SUB, clear PIRQ in all chips.
				;1406	;			NAF/240		; For RESET-SUB, abort to ROM[MSTK AND 240].
				;1407	;					; For SI power up, abort to ROM[240].
				;1408	;					; For ODT, save code; return.
				;1409	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   39
; BASE  .MCD [242,1110]      Power Up

				;1410						; Guarantee LMSTK.W for LED 4 write.
				;1411	=00*0*****				; Abort to ROM[0] and go to ODT-ABORT
				;1412	PWR-UP1:				;  just in case PIRQ aborts (it won't).
U 0003, 0000,0250,2732,0076	;1413		OUTR.W	[FPS, RA]		; Clear the Floating Point Status.
				;1414	=
U 0076, 0000,0270,7772,0102	;1415		OUTS	[CLK_FPS, RA]		; Clear Control chip copy of FPS.
				;1416	
				;1417	
				;1418	; Read in power up options and decode POKH, then FPA status.
				;1419	
				;1420	PWR-UP2:
U 0102, 0000,0630,0137,0111	;1421		ARG.W	[OPTIONS_CLR]		; Read in POKH and options from SI.
				;1422						; Clear FPA's FPS for ODT "G".
				;1423	
U 0111, 0000,0361,7777,0114	;1424		RDG.W	[RF]			; Read them into RF.
				;1425	
U 0114, 0000,0271,6777,0116	;1426		OUTS	[LD_PIR, RF]		; Now stuff it into PIR.
				;1427	
				;1428		OUTR.W	[CPU, RA],		; Clear the CPU error register.
U 0116, 0000,0250,6772,0415	;1429				NAF/P.POKH	; Decode options and POKH.
				;1430	
				;1431	=10********0	; Turns on if POKH is NOT asserted.
U 2000, 0037,7776,0640,0000	;1432	NPLA0	[P.POKH, ^X XXX XXX XXX XXX XX0]
				;1433		NOP.W	[RF, RF],		; Wait for POKH before going on.
U 2001, 0000,1771,7777,0102	;1434				NAF/PWR-UP2	; Loop back and re-read POKH.
				;1435	=
				;1436	=10********0	; Turns on if POKH is asserted and FPA NOT present.
U 2002, 0037,7376,0640,0001	;1437	NPLA0	[P.POKH, ^X XXX XXX 0XX XXX XX1]
				;1438		OUTC	[SET_CPFF],		; Set the NOT CPFF in Control chips.
U 2003, 0000,0261,7577,0123	;1439				NAF/PWR-UP3
				;1440	=
				;1441	=10********0	; Turns on if POKH is asserted and FPA present.
U 2004, 0037,7376,0640,0401	;1442	NPLA0	[P.POKH, ^X XXX XXX 1XX XXX XX1]
U 2005, 0000,0261,7537,0123	;1443		OUTC	[CLR_CPFF]		; Clear the NOT CPFF in Control chips.
				;1444	=
				;1445	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   40
; BASE  .MCD [242,1110]      Power Up

				;1446	; Now initialize the SI registers.  Since the CCR and MSER may not always
				;1447	; be implemented, an abort must not alter this sequence.  RESET5 is used to
				;1448	; guarantee abort control.
				;1449	
				;1450	PWR-UP3:
U 0123, 0000,0530,7076,0125	;1451		LMSTK	[PWR-UP4, RE]		; Return to PWR-UP4 if abort on CCR.
				;1452	
U 0125, 0000,0470,1476,0132	;1453		LLCM.W	[031, RE]		; RE <-- 177746, Cache Control Register address.
				;1454	
U 0132, 0000,0751,7776,0155	;1455		AWD.W	[RE]			; Stuff CCR address into OL.  MMU is off.
				;1456	
				;1457		LLSW.W	[001, RB],		; Flush the Cache, all zeros in other bits.
U 0155, 0000,0460,0073,0024	;1458				NAF/RESET5	; Let abort occur un-noticed.
				;1459	PWR-UP4:
U 0161, 0000,0771,7776,0171	;1460		AW	[RE]			; RE = 177744, Memory System Error Register.
				;1461	
				;1462		CLR.W	[PS, PS],		; Clear the MSER.  Clear PS for ODT "G"
U 0171, 0000,1041,6000,0024	;1463				NAF/RESET5	;  or Power Up Option 1.
				;1464	
				;1465	;=0*0****0				; Abort to ROM[0] for ODT I/O routines.
				;1466	;RESET5:				; Return from print loop in ODT.
				;1467	;	CLR.W	[RA, RA],		; For RESET-SUB, clear PIRQ in all chips.
				;1468	;			NAF/240		; For RESET-SUB, abort to ROM[MSTK AND 240].
				;1469	;					; For SI power up, abort to ROM[240].
				;1470	;					; For ODT, save code; return.
				;1471	
				;1472	; Pop PSW-LOAD from MSTK for ODT "G".
				;1473	
				;1474	; Pop P-U-T1 from MSTK on power up.
				;1475	
;1476	.NOBIN
;1477	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   41
; BASE  .MCD [242,1110]      Power Up Test

;1478		.TOC	"	Power Up Test"
;1479	
;1480	;
;1481	; The purpose of the J-11 power up test is to aid in diagnosing systems
;1482	; which will not load macro diagnostics or respond to micro ODT.  The problem
;1483	; for the field service technician is in determining if the problem
;1484	; is with the CPU, system bus, serial line, or console terminal.  Therefore, the
;1485	; goal of the power up test is to aid in isolating the fault to one of
;1486	; these four causes.
;1487	;
;1488	; The method of communicating the information from the test to the field
;1489	; service tech will be via a set of LEDs on the CPU module.  The meaning
;1490	; of the LEDs will be:
;1491	;
;1492	;		1) J-11 chip set and interface logic are functioning.
;1493	;			(Note that functioning does not mean 100% functional)
;1494	;		2) Processor is able to address memory via system bus.
;1495	;		3) Serial line responds to read cycle (i.e. does not time out).
;1496	;		4) Processor is in ODT.
;1497	;
;1498	; From these four LEDs the most probable failing unit would be:
;1499	;
;1500	;	    LED
;1501	;	1    2    3    4		     Probable Cause of Problem
;1502	;      ---  ---  ---  ---		------------------------------
;1503	;      off  off  off   X		CPU module, power supply
;1504	;      off  off  on    X		CPU module (unusual combination)
;1505	;      off  on   off   X		CPU module (unusual combination)
;1506	;      off  on   on    X		CPU module (unusual combination)
;1507	;      on   off  off   X		Hung bus
;1508	;      on   off  on    X		Bus problem
;1509	;      on   on   off   X		SLU module
;1510	;      on   on   on    X		SLU module, terminal or cable problem
;1511	;
;1512	; The normal status during program execution is LEDs 1, 2, and 3 on and
;1513	; LED 4 off.  During ODT all four LEDs are on.
;1514	;
;1515	; Once the ODT communication link has been established it will be possible
;1516	; to gain more information to aid in further diagnosis using standard
;1517	; techniques (remote diagnosis, techmate, etc.).
;1518	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   42
; BASE  .MCD [242,1110]      Power Up Test

;1519	;
;1520	; The overall test flow is:
;1521	;
;1522	;   Assert BINIT for 10 uS with GP write *
;1523	;   Deassert BINIT with GP write *
;1524	;   Wait 90 uS
;1525	;   Clear MMR0 (implicit)
;1526	;   Clear MMR3 (implicit)
;1527	;   Clear PIRQ (explicit) *
;1528	;   Clear FPS
;1529	;   Read POKH and FPA present bit with GP read *
;1530	;   Clear CPU Error Register (implicit)
;1531	;   Set CCR<8> (flush bit) (explicit) *
;1532	;   Clear MSER (explicit) *
;1533	;   Write to CPU Error Register (implicit)
;1534	;   Read CPU Error Register (explicit) *
;1535	;   Clear CPU Error Register
;1536	;   Compare data written to data read
;1537	;   If equal then
;1538	;      Turn on LED 1 with GP write *
;1539	;   Read memory location 00000000 **
;1540	;   If no abort then
;1541	;      Begin
;1542	;         Read memory location 17777700 *
;1543	;         If abort then
;1544	;            Turn on LED 2 with GP write *
;1545	;      End
;1546	;   Read RCSR (memory location 17777560) *
;1547	;   If no abort then
;1548	;      Turn on LED 3 with GP write *
;1549	;   Read Power Up Options and Resume Power Up
;1550	;      (Vector through 24, Address 173000, ODT, or user supplied boot address)
;1551	;
;1552	;     *  J-11 chipset will stretch for I/O and System Interface must assert
;1553	;        MCONT-L to continue.
;1554	;
;1555	;     ** J-11 chipset will stretch for I/O if MMISS-L is asserted and System
;1556	;        Interface must assert MCONT-L to continue.
;1557	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   43
; BASE  .MCD [242,1110]      Power Up Test

;1558	;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;1559	;
;1560	;		Test for part of the MMU and J-11 interface logic
;1561	;
;1562	; This test will write a known value to the CPU Error Register using an
;1563	; OUTR and read it back using an address relocation cycle in order to give
;1564	; more confidence that the J-11 chip set and interface are partially
;1565	; functional before testing the system bus.  Since the CPU Error Register
;1566	; is internal to the J-11 chip set it can be addressed without using the
;1567	; system bus.
;1568	;
;1569	; Successful completion of this test lights LED 1 on the CPU module.
;1570	;
;1571	;-----------------------------------------------------------------------------
;1572	
				;1573	.BIN
				;1574	
				;1575	P-U-T1:
U 0173, 0000,0470,0476,0222	;1576		LLCM.W	[011, RE]		; RE <= CPU Error Register address.
				;1577	
U 0222, 0000,0250,6776,0237	;1578		OUTR.W	[CPU, RE]		; CPU Error Register <= its address.
				;1579	
				;1580		AR	[RE],			; Initiate read from CPU Error Register
U 0237, 0000,0731,7576,0257	;1581			 16-BIT MAP		;  using no relocation mode.
				;1582	
U 0257, 0000,0321,7775,0261	;1583		RD.W	[RD]			; Read its contents into RD.
				;1584	
U 0261, 0000,1411,7735,0031	;1585		SUB.W	[RE, RD]		; Compare read data with expected data.
				;1586	
				;1587	=0*0*****				; If read aborts, override to ROM[0]
				;1588						;  and eventually enter at ODT-ABORT.
U 0031, 0000,0111,5177,0301	;1589		JAZ [P-U-T2]			; Does the data match ?
				;1590	=
				;1591		OUTR.W	[CPU, RA],		; Re-initialize the CPU Error Register.
U 0301, 0000,0250,6772,0331	;1592				NAF/P-U-T3	; If no match, skip lighting LED1;
				;1593						;  otherwise, take JAZ to light LED 1.
				;1594	P-U-T2:
U 0323, 0000,0671,1037,0331	;1595		AWG.W	[LED1_ON]		; GP code to light LED 1 next cycle.
				;1596	
				;1597						; Finish write to LED 1 if successful.
				;1598	P-U-T3:					; Either way, continue P-U-T.
U 0331, 0000,0470,3776,0337	;1599		LLCM.W	[077, RE]		; RE <= Address 177700 for next test.
				;1600	
;1601	.NOBIN
;1602	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   44
; BASE  .MCD [242,1110]      Power Up Test

;1603	;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;1604	;
;1605	;		Test to see if the bus works
;1606	;
;1607	; The test will assume the following:
;1608	;	1) ROM[240] (accessed after abort override) will do a return from
;1609	;		micro-subroutine.
;1610	;	2) Memory location 00000000 will not abort.
;1611	;	3) Memory location 17777700 (address of R0 in older PDP-11s) will abort.
;1612	;
;1613	; The test will read location 0 (no abort should occur) and location
;1614	; 17777700 (should cause NXM abort).  The test is run after the cache has been
;1615	; flushed to insure that the reads are not cached (i.e. the read cycle passes
;1616	; through to the system bus) and that no cache parity errors occur.  Also,
;1617	; main memory parity or ECC must be disabled during this test.
;1618	;
;1619	; Successful completion of this test lights LED 2 on the CPU module.
;1620	; If this test is not successful, the Power Up Test is continued without
;1621	; lighting LED 2.  This is to allow for systems which do not conform to
;1622	; assumptions 2 and 3 above to power up normally.
;1623	;
;1624	;-----------------------------------------------------------------------------
;1625	
				;1626	.BIN
				;1627	
				;1628	; Read memory location 00000000.  Failure will be
				;1629	; detected by a bus time out (abort override to ROM[240]).
				;1630	
				;1631	;					; Finish write to LED 1 if successful.
				;1632	;P-U-T3:				; Either way, continue P-U-T.
				;1633	;	LLCM.W	[077, RE]		; RE <= Address 177700 for next test.
				;1634	
U 0337, 0000,0534,4075,0371	;1635		LMSTK	[P-U-T4, RD]		; MSTK <= Continuation address if
				;1636						;  MEM[0] aborts.
				;1637		AR	[RA],			; Initiate read of MEM[0]
U 0371, 0000,0731,7572,0373	;1638			 16-BIT MAP		;  using no relocation mode.
				;1639	
U 0373, 0000,0321,7775,1021	;1640		RD.W	[RD]			; Test for no bus NXM abort.
				;1641						; If this aborts, test SLU without
				;1642						;  lighting LED 2.
				;1643	; Read memory location 17777700.
				;1644	; Failure will be detected by no bus time out.
				;1645	
U 1021, 0000,0534,2735,0241	;1646		LMSTK	[P-U-T5, RD]		; MSTK <= Continuation address if
				;1647						;  address 17777700 aborts.
				;1648	
				;1649	=1*1*****				; If last read aborts, override to
				;1650						;  ROM[240] and pop MSTK to P-U-T4.
				;1651		AR	[RE],			; Generate physical address 17777700
U 0241, 0000,0731,7576,1030	;1652			 16-BIT MAP		;  using no relocation mode.
				;1653	=
				;1654		RD.W	[RE],			; Test for bus NXM abort.
U 1030, 0000,0321,7776,1101	;1655				NAF/P-U-T4	; On abort (successful), go to ROM[240]
				;1656						;  and pop MSTK to P-U-T5.
				;1657	P-U-T5:
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   45
; BASE  .MCD [242,1110]      Power Up Test

U 1056, 0000,0671,1237,1101	;1658		AWG.W	[LED2_ON]		; GP code to light LED 2 next cycle.
				;1659	
				;1660						; Finish write to LED 2 if successful.
				;1661	P-U-T4:					; Either way, continue P-U-T.
U 1101, 0000,0471,0776,0242	;1662		LLCM.W	[217, RE]		; RE <= RCSR address for next test.
				;1663	
;1664	.NOBIN
;1665	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   46
; BASE  .MCD [242,1110]      Power Up Test

;1666	;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;1667	;
;1668	;           Read RCSR (Serial line reciever control/status register)
;1669	;
;1670	; This test will read location 17777560 (RCSR).  If no time out abort occurs
;1671	; then LED 3 will be turned on and power up will continue.  Otherwise,
;1672	; power up will continue without turning on LED 3.
;1673	;
;1674	;-----------------------------------------------------------------------------
;1675	
				;1676	.BIN
				;1677	
				;1678	;					; Finish write to LED 2 if successful.
				;1679	;P-U-T4:				; Either way, continue P-U-T.
				;1680	;	LLCM.W	[217, RE]		; RE <= RCSR address for next test.
				;1681	
				;1682	=1*1*****				; Force ROM[240] abort for last test.
U 0242, 0000,0531,2175,1126	;1683		LMSTK	[PWR-UP5, RD]		; MSTK <= Continuation address if
				;1684	=					;  RCSR aborts.
				;1685	
				;1686		AR	[RE],			; Initiate read from RCSR
U 1126, 0000,0731,7576,1127	;1687			 16-BIT MAP		;  using no relocation mode.
				;1688	
U 1127, 0000,0321,7776,1130	;1689		RD.W	[RE]			; Test for RCSR responce.
				;1690	
				;1691						; This cycle NOPed on abort.
				;1692		AWG.W	[LED3_ON],		; GP code to light LED 3 next cycle.
U 1130, 0000,0671,1437,0243	;1693				NAF/PWR-UP5	; Finish write and decode options.
				;1694						; PWR-UP5 must abort to ROM[240].
				;1695	
				;1696	;	End of Power Up Test
				;1697	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   47
; BASE  .MCD [242,1110]      Power Up Test

				;1698	; Now decode the power up options.
				;1699	
				;1700	=1*1*****				; Abort to ROM[240] for P-U-T.
				;1701	PWR-UP5:				; Finish P-U-T GP write.
				;1702		LLD.W	[024, RA],		; Load vector address for option 0.
U 0243, 0000,0560,1232,0411	;1703				NAF/P.OPTION	; Dispatch.
				;1704	=
				;1705	=10********0	; Option 0.  Vector through 24.
U 2006, 0037,7771,0440,0000	;1706	NPLA0	[P.OPTION, ^X XXX XXX XXX XXX 00X]
U 2007, 0000,0701,7772,1131	;1707		ARI.W	[RA]			; Shove the address into Output Latch.
				;1708	=
U 1131, 0000,0321,7767,1132	;1709		RD.W	[PC]			; Read in the PC from the vector.
				;1710	
U 1132, 0000,0701,7772,0033	;1711		ARI.W	[RA]			; Now get address of the PS.
				;1712	
				;1713	=0*0*****				; If PC fetch aborts, go to ODT-ABORT.
				;1714		RD.W	[PS],			; Read it in and
				;1715			VECTOR PS PROTECT,	;  load PS<13:12>.
U 0033, 0000,0321,5740,0107	;1716				NAF/PSW-LOAD	; End up with common code.
				;1717	=
				;1718	=10********0	; Option 1.  Enter ODT.
U 2010, 0037,7771,0440,0002	;1719	NPLA0	[P.OPTION, ^X XXX XXX XXX XXX 01X]
				;1720		NOP.W	[RF, RF],		; TBS
U 2011, 0000,1771,7777,1317	;1721				NAF/ENTER-ODT	; Go to standard ODT entry.
				;1722	=
				;1723	=10********0	; Option 2.  Boot address is 173000.
U 2012, 0037,7771,0440,0004	;1724	NPLA0	[P.OPTION, ^X XXX XXX XXX XXX 10X]
				;1725		LLSW.W	[366, PC],		; Generate address 173000.
U 2013, 0000,0461,7327,1134	;1726				NAF/PWR-UP6	; Join code below.
				;1727	=
				;1728	=10********0	; Option 3.  User specified boot address.
U 2014, 0037,7771,0440,0006	;1729	NPLA0	[P.OPTION, ^X XXX XXX XXX XXX 11X]
U 2015, 0000,0461,7727,1133	;1730		LLSW.W	[376, PC]		; Construct mask for user boot address.
				;1731	=
U 1133, 0000,1511,7767,1134	;1732		AND.W	[RF, PC]		; Obtain VA<15:9>, starting address.
				;1733	
				;1734	PWR-UP6:
U 1134, 0000,0561,6000,0107	;1735		LLD.W	[340, PS]		; Block interrupts for Options 2 and 3.
				;1736	
				;1737	=0*0*****				; Abort to ROM[0] for M-TRAP.
				;1738	PSW-LOAD:
U 0107, 0000,0271,3740,0113	;1739		OUTS	[PSW, PS]		; Update new Control chip PS<7:4> to
				;1740	=					;  arbitrate interrupt priority and Trace Trap.
				;1741	
				;1742	=0*0*****				; Abort to ROM[0] for "Power Up".
				;1743	PSW-LOAD1:				; Clear SSFF for POWER-UP and ODT "G".
				;1744		OUTC	[CPY_TBIT-CLR_SSFF],	; Copy ITFF from PS<4>.
U 0113, 0000,0261,6637,0044	;1745				NAF/RE-SYNC	; Wait for Interrupt Blocking Logic
				;1746	=					;  before ckecking interrupts at IRDF.
				;1747	
;1748	.NOBIN
;1749	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   48
; BASE  .MCD [242,1110]      ID1 Q-Logic Next Addresses

;1750		.TOC	"	ID1 Q-Logic Next Addresses"
;1751	
;1752	;
;1753	;	The Q-Logic is specifically designed to aid the microcode implementation
;1754	;	of the PDP11 Base Instruction Set.  In addition, the Q-logic facilitates
;1755	;	interrupt service handling and is also integrally related to the J-11
;1756	;	Prefetch and Predecode mechanism.
;1757	;
;1758	;	The Q-Logic's major components consist of the QIR, the QPLA, the ID/RFS
;1759	;	Detection Logic, and the Q-Logic Override Logic.
;1760	;
;1761	;	The Q-Logic is activated upon detection of certain predefined NAFs
;1762	;	known as the ID (Instruction Decode) addresses.  These addresses are
;1763	;	detected by the ID/RFS Detection Logic.  When detected, the Q-Logic
;1764	;	Override Logic is enabled to zero bits of the NA based on the output
;1765	;	of the QPLA.  The input to the QPLA is the QIR (which normally contains
;1766	;	the Opcode of the instruction currently being executed), the signal
;1767	;	ID1SVC (which indicates a service condition), and DPPC and DPPB
;1768	;	(flip-flops which indicate the status of the Prefetch mechanism).
;1769	;
;1770	;	ID1 (NAF of 477) is the main Instruction Decode address.  This address
;1771	;	is an input into the equation which generates the signal MPRDC-L.
;1772	;
;1773	;	MPRDC-L = ID1.DATAV.-ID1SVC
;1774	;
;1775	;	That is, MPRDC-L is asserted only if ID1 (the NAF is 477 and no demand
;1776	;	abort), the data in the Prefetch Buffer is valid (the PPC is then valid),
;1777	;	and there are no service conditions pending.  When MPRDC-L is received by
;1778	;	the Data chip, the contents of the Prefetch Buffer is loaded into the IR
;1779	;	and the PC is incremented by two.  Thus starts the beginning of the
;1780	;	execution of a new PDP11 macroinstruction.
;1781	;
;1782	;	The Q-logic can modify the microinstruction flow as shown graphically
;1783	;	on the following page.  Thus the next microinstruction can be accessed
;1784	;	from a number of different Next Addresses (NAs).
;1785	;
;1786	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   49
; BASE  .MCD [242,1110]      ID1 Q-Logic Next Addresses

;1787	;
;1788	;
;1789	;
;1790	;			477	      ID1 (Instruction Decode One)		477
;1791	;	    -------------------------------------------------------------------------------
;1792	;	     400|    440|    460|    467|    470|    471|    474|    475|    476|    477|
;1793	;		|	|	|	|	|	|	|	|	|	|
;1794	;		|	|	|	|	|	|	|	|	|	|
;1795	;		|	|	|	|	|	|	|	|	|    -------
;1796	;		|	|	|	|	|	|	|	|	|     Misc.
;1797	;		|	|	|	|	|	|	|	|	|     Decode
;1798	;		|	|	|	|	|	|	|	|    -------
;1799	;		|	|	|	|	|	|	|	|      DOP
;1800	;		|	|	|	|	|	|	|	|     Source
;1801	;		|	|	|	|	|	|	|	|      Mode
;1802	;		|	|	|	|	|	|	|	|     Decode
;1803	;		|	|	|	|	|	|	|    -------
;1804	;		|	|	|	|	|	|	|      SOP
;1805	;		|	|	|	|	|	|	|  Destination
;1806	;		|	|	|	|	|	|	|      Mode
;1807	;		|	|	|	|	|	|	|     Decode
;1808	;		|	|	|	|	|	|    -------
;1809	;		|	|	|	|	|	|      DOP
;1810	;		|	|	|	|	|	|  Destination
;1811	;		|	|	|	|	|	|      Mode
;1812	;		|	|	|	|	|	|     Decode
;1813	;		|	|	|	|	|    -------
;1814	;		|	|	|	|	|      SOP
;1815	;		|	|	|	|	|   Execution
;1816	;		|	|	|	|    -------
;1817	;		|	|	|	|      DOP
;1818	;		|	|	|	|   Execution
;1819	;		|	|	|    -------
;1820	;		|	|	|      JOP
;1821	;		|	|	|     Decode
;1822	;		|	|    -------
;1823	;		|	|    Prefetch
;1824	;		|	|     Buffer
;1825	;		|	|    Invalid
;1826	;		|    -------
;1827	;		|      PPC
;1828	;		|    Invalid
;1829	;	     -------
;1830	;	     Service
;1831	;	      Decode
;1832	;
;1833	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   50
; BASE  .MCD [242,1110]      ID1 Q-Logic Next Addresses

;1834	;
;1835	;	The following equations specify the resulting NA at ID1 based on the
;1836	;	Q-Logic inputs:
;1837	;
;1838	;	DOP	=	The QIR contains a Double Operand instruction
;1839	;	SOP	=	The QIR contains a Single Operand instruction
;1840	;	JOP	=	The QIR contains a JMP or JSR instruction
;1841	;	DATAV	=	The Prefetch Buffer Data is valid
;1842	;	PPCV	=	The Physical Program Counter is valid
;1843	;	ID1SVC	=	An interrupt is pending
;1844	;	SM0	=	The Source Mode is zero
;1845	;	DM0	=	The Desination Mode is zero
;1846	;
;1847	;
;1848	;	 NA			Condition
;1849	;	----			---------
;1850	;
;1851	;	477		-DOP.-SOP.-JOP.DATAV.PPCV.-ID1SVC
;1852	;
;1853	;	476		DOP.-SM0.DATAV.PPCV.-ID1SVC
;1854	;
;1855	;	475		SOP.-DM0.DATAV.PPCV.-ID1SVC
;1856	;
;1857	;	474		DOP.SM0.-DM0.DATAV.PPCV.-ID1SVC
;1858	;
;1859	;	471		SOP.DM0.DATAV.PPCV.-ID1SVC
;1860	;
;1861	;	470		DOP.SM0.DM0.DATAV.PPCV.-ID1SVC
;1862	;
;1863	;	467		JOP.DATAV.PPCV.-ID1SVC
;1864	;
;1865	;	460		-DATAV.PPCV.-ID1SVC
;1866	;
;1867	;	440		-PPCV.-ID1SVC
;1868	;
;1869	;	400		ID1SVC
;1870	;
;1871	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   51
; BASE  .MCD [242,1110]      Prefetch Pipeline Resynchronization Sequences

;1872		.TOC	"		Prefetch Pipeline Resynchronization Sequences"
;1873	
;1874	;
;1875	;	The Q-logic can detect the conditions Physical Program Counter Invalid
;1876	;	(from the flip-flop DPPC), and Prefetch Buffer Invalid (from the flip
;1877	;	-flop DPPB).  If these conditions exist at ID1 (477), the Q-Logic
;1878	;	overrides the NA to 440 (PPC Invalid) or 460 (Prefetch Buffer Invalid).
;1879	;
;1880	;	The signal MKPB-L from the Data chip sets DPPC and DPPB if any one of
;1881	;	the following is detected:
;1882	;
;1883	;		1)  Explicit writes to the PS
;1884	;		2)  Explicit writes to the MMU registers
;1885	;		3)  Instruction stream overwrites
;1886	;		4)  Writes to the PC
;1887	;		5)  Writes to the Cache Control Register
;1888	;
;1889	;	DPPB is also set if MABORT-L is asserted during a Prefetch operation,
;1890	;	and remains set if a demand RDI microinstruction is executed.
;1891	;
;1892	;
				;1893	.BIN
				;1894	
				;1895	PPC-INVALID:	; Physical Program Counter Invalid.
				;1896	=10********0
U 2016, 0037,7777,2000,0000	;1897	PLA0	[^0 100 000, ^X]
U 2017, 0000,1561,7367,0044	;1898		MOV.W	[PC, PC]		; VPC <-- PC.  Start from scratch.
				;1899	=
				;1900	=0*1*****				; Must abort to ROM[40].
				;1901	RE-SYNC:				; Resynchronize and check interrupts.
				;1902		RSYNC,				; PPC <-- Relocated(VPC).  VPC <-- VPC + 2.
U 0044, 0000,1621,7740,0460	;1903				NAF/IRDF	; Now load Prefetch Buffer.  Q-Logic can
				;1904	=					;  override to 400, Interrupt Service Decode.
				;1905	
				;1906	DPPC:		; Prefetch Buffer Invalid.
				;1907	=10********0
U 2020, 0037,7777,3000,0000	;1908	PLA0	[^0 110 000, ^X]		; NAF = 460 aborts to ROM[40] as required.
				;1909		RDF,				; Demand Prefetch.  PB <-- M[PPC].
				;1910						; PPC <-- Relocated(VPC).  VPC <-- VPC + 2.
U 2021, 0000,0311,7777,1477	;1911				NAF/NOP-PF
				;1912	=
				;1913						; IR, PIR, QIR <-- [PB].  PB <-- M[PPC].
				;1914						; PPC <-- Relocated(VPC).  VPC <-- VPC + 2.
				;1915						; PC <-- PC + 2.
				;1916	;1477:					; Must be overridable to ID1 (477).
				;1917	;NOP-PF:				;  Must also abort to ROM[40].
				;1918	;	NOP.W	[RF, PS],		; Do nothing, but allow Predecode to write
				;1919	;					;  IR on A-bus<31:16> from Prefetch Buffer.
				;1920	;		PREFETCH,		; Initiate a Prefetch request cycle now
				;1921	;					;  that all other bus cycles are completed.
				;1922	;			NAF/ID1		; Initiate Predecode.  See "ID1 Q-Logic Next
				;1923	;					;  Addresses" for possible NAs.
				;1924	
				;1925	
;1926	.NOBIN
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   52
; BASE  .MCD [242,1110]      Prefetch Pipeline Resynchronization Sequences

;1927	
;1928	;
;1929	;	After this sequence is executed (assuming no aborts or relocation errors),
;1930	;	the prefetch pipeline is said to be in steady state.  Steady state is sometimes
;1931	;	represented as follows:
;1932	;
;1933	;	Pipeline
;1934	;	 Level		State
;1935	;	--------	-----
;1936	;
;1937	;	    1		IR	<-- M[Relocated(PC at last predecode)]
;1938	;
;1939	;	    2		PB	<-- M[Relocated(PC)]
;1940	;			PV	<-- 1	(Data chip copy)
;1941	;			DATAV	<-- 1	(Control chip copy)
;1942	;
;1943	;	    3		PPC	<-- Relocated(PC+2)
;1944	;			PCS<0>	<-- 0	(Data chip copy)
;1945	;			PPCV	<-- 1	(Control chip copy)
;1946	;
;1947	;	    4		VPC	<-- PC+4
;1948	;
;1949	;
;1950	;	Note that:
;1951	;		DPPB	= -DATAV
;1952	;		DPPC	= -PPCV
;1953	;
;1954	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   53
; BASE  .MCD [242,1110]      SOPs, DOPs, and Q-Logic Organization

;1955		.TOC	"		SOPs, DOPs, and Q-Logic Organization"
;1956	
;1957	;
;1958	;	This section is intended to show, mainly graphically, the operation of
;1959	;	the Q-Logic as it pertains to SOPs and DOPs only.  It is included here
;1960	;	because of it's "hidden" effect upon microinstruction sequencing.
;1961	;	Without a good understanding of the Q-Logic it is quite difficult to
;1962	;	follow SOP and DOP execution.  For further information, refer to the
;1963	;	J-11 Control Chip Specification and the section entitled "ID1 Q-Logic
;1964	;	Next Addresses" in this document.
;1965	;
;1966	;	The Q-Logic provides for a fast decode of SOPs and DOPs and for Source
;1967	;	Mode or Destination Mode 0.  This information is realized with NA
;1968	;	overrides.  That is, the Q-Logic converts an NAF as accesses from the
;1969	;	PLA/ROM array to an NA which accesses the next microinstruction.
;1970	;
;1971	;	The following symbols are used to illustrate SOP and DOP execution:
;1972	;
;1973	;		ID1		Instruction Decode one
;1974	;		ID2		Instruction Decode two
;1975	;		ID3		Instruction Decode three
;1976	;		DM0		Destination Mode zero
;1977	;		SM0		Source Mode zero
;1978	;		Dst.adr		The Destination Operand's address
;1979	;		Src.adr		The Source Operand's address
;1980	;		M[x]		The contents of Memory at address x
;1981	;		DOP[x, y]	The result of a function of two variables x and y
;1982	;		SOP[x]		The result of a function of one variable x
;1983	;		PREFETCH	The initiation of a bus cycle to fetch an I-stream word
;1984	;
;1985	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   54
; BASE  .MCD [242,1110]      SOPs, DOPs, and Q-Logic Organization

;1986	;
;1987	;	The following diagram illustrates the general flow of a SOP.
;1988	;
;1989	;
;1990	;				ID1(477) / Q-Logic
;1991	;				------------------
;1992	;					|
;1993	;					|
;1994	;		475		-DM0	|
;1995	;		--------------------<---|
;1996	;			  |		|
;1997	;			  |		|
;1998	;			  V		V   DM0
;1999	;					|
;2000	;		  RE <-- M[Dst.adr]	|
;2001	;					|
;2002	;			  |		|
;2003	;		ID3	  V  (473/471)	|   (471)	     ID3
;2004	;		------------------------|------------------------
;2005	;			  |				|
;2006	;			  |				|
;2007	;		   -DM0   V				V   DM0
;2008	;
;2009	;		M[Dst.adr] <-- SOP[RE]		RDST <-- SOP[RDST],
;2010	;
;2011	;			  |			      PREFETCH
;2012	;			  V
;2013	;							|
;2014	;			NOP,				|
;2015	;							|
;2016	;		      PREFETCH				|
;2017	;							|
;2018	;			  |				|
;2019	;			  V	 ID1(477) / Q-Logic	V
;2020	;			-----------------------------------
;2021	;
;2022	;
;2023	;	Upon detection of a SOP in the QIR, the Q-Logic will override the NAF to
;2024	;	ID3 (471) for Destination Mode 0, or 475 otherwise.  If 475, the Destination
;2025	;	Operand, in memory, is fetched into scratch register RE and the NAF is set
;2026	;	to ID3 (473 or 471) by microcode.  At ID3, microcode then makes a decision as
;2027	;	to Mode 0.  If Mode 0, the SOP is executed upon the general register RDST.
;2028	;	A bus cycle is simultaneously conducted to fetch a future I-stream word.
;2029	;	If not Mode 0, the SOP is executed upon the scratch register RE which also
;2030	;	writes the result back to memory.  A separate cycle is needed to fetch the
;2031	;	I-stream word.
;2032	;
;2033	;	There are exceptions to the general flow shown above.  For example, CLR(B)
;2034	;	and SXT only write to the destination address; TST(B) only reads.  In
;2035	;	addition, some instructions are treated as SOPs by the Q-Logic which aren't
;2036	;	really SOPs at all (e.g. EIS instructions, CSM and MTPS).
;2037	;
;2038	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   55
; BASE  .MCD [242,1110]      SOPs, DOPs, and Q-Logic Organization

;2039	;
;2040	;	The following diagram illustrates the general flow of a DOP.
;2041	;
;2042	;
;2043	;				ID1(477) / Q-Logic
;2044	;				------------------
;2045	;					|
;2046	;					|
;2047	;		476		-SM0	|
;2048	;		--------------------<---|
;2049	;			  |		|
;2050	;			  |		|
;2051	;			  V		V   SM0
;2052	;					|
;2053	;		  RF <-- M[Src.adr]	|
;2054	;					|
;2055	;			  |		|
;2056	;		ID2(474)  V		|   -DM0	 (474)ID2
;2057	;		------------->----------|--->--------------------
;2058	;			 		|		|
;2059	;			 		|		|
;2060	;				  DM0	V		V
;2061	;					|
;2062	;					|	RE <-- M[Dst.adr]
;2063	;					|
;2064	;					|		|
;2065	;	ID3			(470)	|   (472/470)	V	      ID3
;2066	;	--------------------------------|--------------------------------
;2067	;	SM0.DM0 |      -SM0.DM0 |		| SM0.-DM0	| -SM0.-DM0
;2068	;		|		|		|		|
;2069	;		|		|		|		V
;2070	;		|		|		|
;2071	;		|		|		|     M[Dst.adr] <-- DOP[RF, RE]
;2072	;		|		|		V
;2073	;		|		|				|
;2074	;		|		|  M[Dst.adr] <-- DOP[RSRC, RE]	|
;2075	;		|		V				|
;2076	;		|				|		|
;2077	;		|    RDST <-- DOP[RF, RDST],	|		|
;2078	;		|				|		|
;2079	;		|	    PREFETCH		|		|
;2080	;		V				V		V
;2081	;				|
;2082	;   RDST <-- DOP[RSRC, RDST],	|	       NOP,	       NOP,
;2083	;				|
;2084	;	    PREFETCH		|	    PREFETCH	    PREFETCH
;2085	;				|
;2086	;		|		|		|		|
;2087	;		V   ID1(477)	V   Q-Logic	V   ID1(477)	V
;2088	;	-------------------------------------------------------------------
;2089	;
;2090	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   56
; BASE  .MCD [242,1110]      SOPs, DOPs, and Q-Logic Organization

;2091	;
;2092	;	Upon detection of a DOP in the QIR at ID1, the Q-Logic overrides to 476,
;2093	;	if the Source Mode is not 0, to ID2 (474) if the Source Mode is 0 but the
;2094	;	Destination Mode is not 0, or to ID3 (470) if both Modes are 0. At 476,
;2095	;	the Source Operand, in memory, is fetch into scratch register RF and the NAF
;2096	;	is set to ID2 (474) by microcode.  At ID2, the Q-logic will override to
;2097	;	ID3 (470) if the Destination Mode is 0.  If the Q-logic does not override,
;2098	;	the Destination Operand, in memory, is fetch into scratch register RE and the
;2099	;	NAF is set to ID3 (472/470) by microcode.  At ID3, microcode then makes
;2100	;	decisions as to where to locate the two operands.  If the Destination Mode is
;2101	;	not 0, the result of the DOP operation is written back to memory.  A separate
;2102	;	bus cycle is needed to fetch the future I-stream word.  If the Destination
;2103	;	Operand is a general register, the bus can simultaneously be used to fetch
;2104	;	from the I-stream.
;2105	;
;2106	;	There are exceptions to the general flow shown above.  For example, MOV(B)
;2107	;	only writes to the destination address; CMP(B) and BIT(B) only read.  In
;2108	;	addition, if the destination is the PC, a PREFETCH cannot occur the same cycle.
;2109	;; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   57
; BASE  .MCD [242,1110]      DOP Source Mode Decode

;2110		.TOC	"			DOP Source Mode Decode"
;2111	
;2112	;
;2113	;	This code is executed for Double Operand instructions (DOPs) only,
;2114	;	and then only if the Source Mode is not zero.  This code fetches
;2115	;	the source operand according to the mode and register specified
;2116	;	in bits<11:6> of the macroinstruction.
;2117	;
;2118	;	The last microinstruction executed had an NAF of ID1 (477).  This
;2119	;	initiated a Predecode operation and enabled the Q-Logic.  The Q-Logic
;2120	;	detected a DOP with a Source Mode not equal to zero and therefore
;2121	;	zeroed NA<0> only indicating that Source Mode addressing must be done.
;2122	;
;2123	;
;2124	; Entry conditions:
;2125	;
;2126	;	NA = 476
;2127	;	QIR contains Opcode (DOP)
;2128	;	PIR contains Opcode (DOP)
;2129	;
;2130	; Exit conditions:
;2131	;
;2132	;	NAF = 474 (ID2)
;2133	;	RF<7:0>  contains source operand for byte operations
;2134	;	RF<15:0> contains source operand for word operations
;2135	;
;2136	; Method:
;2137	;
;2138	;	PLAs are used almost exclusively to separate the various addressing
;2139	;	modes and provide necessary byte to word overrides.
;2140	;
;2141	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   58
; BASE  .MCD [242,1110]      Source Mode 1

;2142		.TOC	"				Source Mode 1"
;2143	
;2144	;
;2145	; Mode 1:
;2146	;
;2147	;	Register specifies operand address.
;2148	;
;2149	; Do:
;2150	;	AR	[RSRC]			; Relocate operand address.
;2151	;	RD.()	[RF],			; Read byte or word operand.
;2152	;			NAF/ID2		; Do second instruction decode.
;2153	;
;2154	;
;2155	;
				;2156	.BIN
				;2157	
				;2158	SRC-MODE-1:	; Relocate operand address for Mode 1.
				;2159	=10********0
U 2022, 0037,0777,3700,1000	;2160	PLA0	[^0 111 110, ^X XXX 001 XXX XXX XXX]
				;2161		AR	[RSRC],			; ODD TRAP enabled for word OPs (WRD-OVR).
U 2023, 0000,0731,7747,0576	;2162				NAF/576		; SRC-RD-X.  Finish bus cycle.
				;2163	=
				;2164	SRC-RD-X:	; Read operand or operand address.
				;2165	=10********0
U 2024, 0437,7777,7300,0000	;2166	PLA0	[^1 11X 110, ^X]
				;2167		RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
U 2025, 0000,0327,7777,0474	;2168				NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2169	=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2170	
				;2171	WRD-OVR-1:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2172	=10********0
U 2026, 4527,7777,3200,0000	;2173	PLA0	[^X 11X 1X0, ^0 XXX XXX XXX XXX XXX]	; See NOTE 1.
				;2174			BYTE --> WORD,		; Force word Read or Address increment by two.
				;2175			ODD TRAP,		; Force ODD TRAP enable for Address instructions.
U 2027, 0000,1771,7377,1777	;2176				NAF/1777	; Do not alter NAF.
				;2177	=
				;2178	WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;2179	=10********0
U 2030, 5520,7777,2216,0000	;2180	PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;2181			BYTE --> WORD,		; Force word Read or Address increment by two.
				;2182			ODD TRAP,		; Force ODD TRAP enable for Address instructions.
U 2031, 0000,1771,7377,1777	;2183				NAF/1777	; Do not alter NAF.
				;2184	=
				;2185	
;2186	.NOBIN
;2187	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   59
; BASE  .MCD [242,1110]      Source Mode 2

;2188		.TOC	"				Source Mode 2"
;2189	
;2190	;
;2191	; Mode 2:
;2192	;
;2193	;	Register specifies operand address.
;2194	;	Register is post-autoincremented.
;2195	;
;2196	; Do:
;2197	;	ARI.()	[RSRC]			; Relocate operand address and autoincrement.
;2198	;	RD.()	[RF],			; Read byte or word operand.
;2199	;			NAF/ID2		; Do second instruction decode.
;2200	;
;2201	; Or:
;2202	;	RDI	[RF],			; Read I-stream word for Mode 27.
;2203	;			NAF/ID2		; Go directly to second decode.
;2204	;
;2205	;
;2206	;
				;2207	.BIN
				;2208	
				;2209	SRC-MODE-2:	; Relocate operand address for Mode 2.
				;2210	=10********0
U 2032, 0037,0777,3700,2000	;2211	PLA0	[^0 111 110, ^X XXX 010 XXX XXX XXX]
				;2212		ARI.B	[RSRC],			; Word overrides cause ODD TRAP to be enabled
				;2213						;  and increment by two not one (WRD-OVR).
				;2214			LD MMR1,		; MMR1 records the amount.
U 2033, 0000,0704,7747,0576	;2215				NAF/576		; SRC-RD-X.  Finish bus cycle.
				;2216	=
				;2217	;SRC-RD-X:	; Read operand or operand address.
				;2218	;=10********0
				;2219	;PLA0	[^1 11X 110, ^X]
				;2220	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2221	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2222	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2223	
				;2224	SRC-MODE-27-37:	; Do I-stream read for Modes 27, or 37.
				;2225	=10********0
U 2034, 0037,1077,3700,2700	;2226	PLA0	[^0 111 110, ^X XXX 01X 111 XXX XXX]
				;2227		RDI	[RF+],			; Override both ARI and RSRC and
				;2228						;  read Prefetch Buffer instead.
U 2035, 0000,0301,7745,0474	;2229				NAF/474		; Go to ID2 for Mode 2, or
				;2230	=					;  SRC-ADDR-X (464) for Mode 3 (566 AND 474).
				;2231	
				;2232	WRD-OVR-3:	; Detect R6 (SP) and increment/decrement by two.
				;2233	=10********0
U 2036, 0037,6077,3700,0600	;2234	PLA0	[^0 111 110, ^X XXX XX0 110 XXX XXX]
				;2235			BYTE --> WORD,		; Force Address increment/decrement by two.
U 2037, 0000,1771,7777,1777	;2236				NAF/1777	; Do not alter NAF.
				;2237	=
				;2238	;WRD-OVR-1:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2239	;=10********0
				;2240	;PLA0	[^X 11X 1X0, ^0 XXX XXX XXX XXX XXX]	; See NOTE 1.
				;2241	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2242	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   60
; BASE  .MCD [242,1110]      Source Mode 2

				;2243	;			NAF/1777	; Do not alter NAF.
				;2244	;=
				;2245	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;2246	;=10********0
				;2247	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;2248	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2249	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2250	;			NAF/1777	; Do not alter NAF.
				;2251	;=
				;2252	
;2253	.NOBIN
;2254	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   61
; BASE  .MCD [242,1110]      Source Mode 3

;2255		.TOC	"				Source Mode 3"
;2256	
;2257	;
;2258	; Mode 3:
;2259	;
;2260	;	Register specifies pointer to operand address.
;2261	;	Register is post-autoincremented.
;2262	;
;2263	; Do:
;2264	;	ARI.W	[RSRC]			; Relocate pointer and autoincrement.
;2265	;	RD.W	[RF]			; Read word length operand address.
;2266	;	AR	[RF]			; Relocate operand address.
;2267	;	RD.()	[RF],			; Read byte or word operand.
;2268	;			NAF/ID2		; Do second instruction decode.
;2269	;
;2270	; Or:
;2271	;	RDI	[RF]			; Read I-stream word for Mode 37.
;2272	;	AR	[RF]			; Relocate operand address.
;2273	;	RD.()	[RF],			; Read byte or word operand.
;2274	;			NAF/ID2		; Do second instruction decode.
;2275	;
;2276	;
;2277	;
				;2278	.BIN
				;2279	
				;2280	SRC-MODE-3:	; Relocate pointer for Mode 3.
				;2281	=10********0
U 2040, 0037,0777,3700,3000	;2282	PLA0	[^0 111 110, ^X XXX 011 XXX XXX XXX]
				;2283		ARI.W	[RSRC],			; Always increment by two.
				;2284			LD MMR1,		; MMR1 records the amount.
				;2285			ODD TRAP,		; Must be a word address.
U 2041, 0000,0700,7347,0566	;2286				NAF/566		; SRC-RD-0.  Finish first bus cycle.
				;2287	=
				;2288	;SRC-RD-X:	; Read operand or operand address.
				;2289	;=10********0
				;2290	;PLA0	[^1 11X 110, ^X]
				;2291	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2292	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2293	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2294	
				;2295			; Turns on at SRC-RD-0 (566) or SRC-ADDR-0 (564).
				;2296	ODD-OVR:	; Override for operand address fetch.
				;2297	=10********0
U 2042, 0137,6777,7200,1000	;2298	PLA0	[^1 110 1X0, ^X XXX XX1 XXX XXX XXX]	; Any odd mode.
				;2299			BYTE --> WORD,		; Do word read at SRC-RD-0.
				;2300			ODD TRAP,		; Enable ODD TRAP at SRC-ADDR-0.
U 2043, 0000,1771,7377,1767	;2301				NAF/1767	; Clear NAF<3> to indicate first bus cycle.
				;2302	=					; Go to 464 (SRC-ADDR-X) or 566 (SRC-RD-0).
				;2303	
				;2304	;SRC-MODE-27-37:; Do I-stream read for Modes 27, or 37.
				;2305	;=10********0
				;2306	;PLA0	[^0 111 110, ^X XXX 01X 111 XXX XXX]
				;2307	;	RDI	[RF+],			; Override both ARI and RSRC and
				;2308	;					;  read Prefetch Buffer instead.
				;2309	;			NAF/474		; Go to ID2 for Mode 2, or
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   62
; BASE  .MCD [242,1110]      Source Mode 3

				;2310	;=					;  SRC-ADDR-X (464) for Mode 3 (566 AND 474).
				;2311	
				;2312	SRC-ADDR-X:	; Relocate operand or pointer address.
				;2313	=10********0
U 2044, 4037,7777,3200,0000	;2314	PLA0	[^X 110 100, ^X]
				;2315		AR	[RF],			; ODD TRAP with (WRD-OVR), or indirect (ODD-OVR).
U 2045, 0000,0731,7777,0576	;2316				NAF/576		; SRC-RD-X for last reference, or
				;2317	=					; SRC-RD-0 (566) for indirect reference (ODD-OVR).
				;2318	
				;2319	;SRC-RD-X:	; Read operand or operand address.
				;2320	;=10********0
				;2321	;PLA0	[^1 11X 110, ^X]
				;2322	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2323	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2324	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2325	
				;2326	;WRD-OVR-1:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2327	;=10********0
				;2328	;PLA0	[^X 11X 1X0, ^0 XXX XXX XXX XXX XXX]	; See NOTE 1.
				;2329	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2330	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2331	;			NAF/1777	; Do not alter NAF.
				;2332	;=
				;2333	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;2334	;=10********0
				;2335	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;2336	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2337	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2338	;			NAF/1777	; Do not alter NAF.
				;2339	;=
				;2340	
;2341	.NOBIN
;2342	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   63
; BASE  .MCD [242,1110]      Source Mode 4

;2343		.TOC	"				Source Mode 4"
;2344	
;2345	;
;2346	; Mode 4:
;2347	;
;2348	;	Register is pre-autodecremented.
;2349	;	Register specifies operand address.
;2350	;
;2351	; Do:
;2352	;	ARD.()	[RSRC]			; Decrement address by one or two.
;2353	;	AR	[RSRC]			; Relocate operand address.
;2354	;	RD.()	[RF],			; Read byte or word operand.
;2355	;			NAF/ID2		; Do second instruction decode.
;2356	;
;2357	; Or:	(for Mode 47)
;2358	;	ARD.W	[RSRC]			; Decrement address by two.
;2359	;	MOV.W	[PC, PC]		; Load VPC.
;2360	;	RSYNC				; Relocate new VPC to PPC.
;2361	;	RD.()	[RF],			; Read byte or word operand.  PPC is address.
;2362	;			NAF/ID2		; Do second instruction decode.
;2363	;
;2364	;
;2365	;
				;2366	.BIN
				;2367	
				;2368	SRC-MODE-4:	; Decrement address for Mode 4.
				;2369	=10********0
U 2046, 0037,0777,3700,4000	;2370	PLA0	[^0 111 110, ^X XXX 100 XXX XXX XXX]
				;2371		ARD.B	[RSRC],			; Word OPs decrement by two (WRD-OVR).
				;2372			LD MMR1,		; MMR1 records the amount.
				;2373			NO ABORTS,		; Disable aborts.  Decrement and load MMR1 only.
U 2047, 0000,0714,7547,0564	;2374				NAF/564		; SRC-ADDR-0.  Go relocate operand address.
				;2375	=					; SRC-RSYNC if Mode 47 (SRC-MODE-47-57).
				;2376	
				;2377	SRC-MODE-47-57:	; RSYNC (NAF) override for Modes 47, and 57.
				;2378	=10********0
U 2050, 0037,1077,3700,4700	;2379	PLA0	[^0 111 110, ^X XXX 10X 111 XXX XXX]
				;2380			BYTE --> WORD,		; Decrement PC by two.
U 2051, 0000,1771,7777,0060	;2381				NAF/SRC-RSYNC	; Override 564 to do RSYNC.
				;2382	=
				;2383	=0*0***0*00				; Must override from 0564.
				;2384	SRC-RSYNC:
U 0060, 0000,1561,7367,1135	;2385		MOV.W	[PC, PC]		; ARD does not load VPC.  Update VPC.
				;2386	=
				;2387		RSYNC,				; Relocate new VPC and drive PPC next cycle.
				;2388						; Must provide correct address if RDI is
				;2389						;  executed in "Destination Mode Decode".
U 1135, 0000,1621,7740,0566	;2390				NAF/566		; SRC-RD-0.  Read operand or operand address.
				;2391	
				;2392	;SRC-ADDR-X:	; Relocate operand or pointer address.
				;2393	SRC-ADDR-0:	; Override RF to RSRC for Mode 4, first reference Mode 5.
				;2394	=10********0
U 2052, 0037,1777,7200,4000	;2395	PLA0	[^1 110 100, ^X XXX 10X XXX XXX XXX]
				;2396		AR	[RSRC],			; ODD TRAP with (WRD-OVR), or indirect (ODD-OVR).
				;2397			SOVFF,			; Check for Yellow Stack Overflow Trap.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   64
; BASE  .MCD [242,1110]      Source Mode 4

U 2053, 0000,0731,6747,0576	;2398				NAF/576		; SRC-RD-X for last reference, or
				;2399	=					; SRC-RD-0 (566) for indirect reference (ODD-OVR).
				;2400	
				;2401	;SRC-RD-X:	; Read operand or operand address.
				;2402	;=10********0
				;2403	;PLA0	[^1 11X 110, ^X]
				;2404	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2405	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2406	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2407	
				;2408	;WRD-OVR-3:	; Detect R6 (SP) and increment/decrement by two.
				;2409	;=10********0
				;2410	;PLA0	[^0 111 110, ^X XXX XX0 110 XXX XXX]
				;2411	;		BYTE --> WORD,		; Force Address increment/decrement by two.
				;2412	;			NAF/1777	; Do not alter NAF.
				;2413	;=
				;2414	;WRD-OVR-1:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2415	;=10********0
				;2416	;PLA0	[^X 11X 1X0, ^0 XXX XXX XXX XXX XXX]	; See NOTE 1.
				;2417	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2418	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2419	;			NAF/1777	; Do not alter NAF.
				;2420	;=
				;2421	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;2422	;=10********0
				;2423	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;2424	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2425	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2426	;			NAF/1777	; Do not alter NAF.
				;2427	;=
				;2428	
;2429	.NOBIN
;2430	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   65
; BASE  .MCD [242,1110]      Source Mode 5

;2431		.TOC	"				Source Mode 5"
;2432	
;2433	;
;2434	; Mode 5:
;2435	;
;2436	;	Register is pre-autodecremented.
;2437	;	Register specifies pointer to operand address.
;2438	;
;2439	; Do:
;2440	;	ARD.W	[RSRC]			; Decrement address by two.
;2441	;	AR	[RSRC]			; Relocate pointer address.
;2442	;	RD.W	[RF]			; Read operand address.
;2443	;
;2444	; Or:	(for Mode 57)
;2445	;	ARD.W	[RSRC]			; Decrement address by two.
;2446	;	MOV.W	[PC, PC]		; Load VPC.
;2447	;	RSYNC				; Relocate new VPC to PPC.
;2448	;	RD.W	[RF]			; Read operand address.  PPC is address.
;2449	;
;2450	; Then:
;2451	;	AR	[RF]			; Relocate operand address.
;2452	;	RD.()	[RF],			; Read byte or word operand.
;2453	;			NAF/ID2		; Do second instruction decode.
;2454	;
;2455	;
;2456	;
				;2457	.BIN
				;2458	
				;2459	SRC-MODE-5:	; Decrement address for Mode 5.
				;2460	=10********0
U 2054, 0037,0777,3700,5000	;2461	PLA0	[^0 111 110, ^X XXX 101 XXX XXX XXX]
				;2462		ARD.W	[RSRC],			; Always decrement pointer by two.
				;2463			LD MMR1,		; MMR1 records the amount.
				;2464			NO ABORTS,		; Disable aborts.  Decrement and load MMR1 only.
U 2055, 0000,0710,7547,0564	;2465				NAF/564		; SRC-ADDR-0.  Go relocate pointer address.
				;2466	=					; SRC-RSYNC if Mode 57 (SRC-MODE-47-57).
				;2467	
				;2468	;SRC-MODE-47-57:	; RSYNC (NAF) override for Modes 47, and 57.
				;2469	;=10********0
				;2470	;PLA0	[^0 111 110, ^X XXX 10X 111 XXX XXX]
				;2471	;		BYTE --> WORD,		; Decrement PC by two.
				;2472	;			NAF/SRC-RSYNC	; Override 564 to do RSYNC.
				;2473	;=
				;2474	;=0*0***0*00				; Must override from 0564.
				;2475	;SRC-RSYNC:
				;2476	;	MOV.W	[PC, PC]		; ARD does not load VPC.  Update VPC.
				;2477	;=
				;2478	;	RSYNC,				; Relocate new VPC and drive PPC next cycle.
				;2479	;					; Must provide correct address if RDI is
				;2480	;					;  executed in "Destination Mode Decode".
				;2481	;			NAF/566		; SRC-RD-0.  Read operand or operand address.
				;2482	;
				;2483	;SRC-ADDR-X:	; Relocate operand or pointer address.
				;2484	;SRC-ADDR-0:	; Override RF to RSRC for Mode 4, first reference Mode 5.
				;2485	;=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   66
; BASE  .MCD [242,1110]      Source Mode 5

				;2486	;PLA0	[^1 110 100, ^X XXX 10X XXX XXX XXX]
				;2487	;	AR	[RSRC],			; ODD TRAP with (WRD-OVR), or indirect (ODD-OVR).
				;2488	;		SOVFF,			; Check for Yellow Stack Overflow Trap.
				;2489	;			NAF/576		; SRC-RD-X for last reference, or
				;2490	;=					; SRC-RD-0 (566) for indirect reference (ODD-OVR).
				;2491	;
				;2492	;SRC-RD-X:	; Read operand or operand address.
				;2493	;=10********0
				;2494	;PLA0	[^1 11X 110, ^X]
				;2495	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2496	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2497	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2498	;
				;2499	;		; Turns on at SRC-RD-0 (566) or SRC-ADDR-0 (564).
				;2500	;ODD-OVR:	; Override for operand address fetch.
				;2501	;=10********0
				;2502	;PLA0	[^1 110 1X0, ^X XXX XX1 XXX XXX XXX]	; Any odd mode.
				;2503	;		BYTE --> WORD,		; Do word read at SRC-RD-0.
				;2504	;		ODD TRAP,		; Enable ODD TRAP at SRC-ADDR-0.
				;2505	;			NAF/1767	; Clear NAF<3> to indicate first bus cycle.
				;2506	;=					; Go to 464 (SRC-ADDR-X) or 566 (SRC-RD-0).
				;2507	;
				;2508	;SRC-ADDR-X:	; Relocate operand or pointer address.
				;2509	;=10********0
				;2510	;PLA0	[^X 110 100, ^X]
				;2511	;	AR	[RF],			; ODD TRAP with (WRD-OVR), or indirect (ODD-OVR).
				;2512	;			NAF/576		; SRC-RD-X for last reference, or
				;2513	;=					; SRC-RD-0 (566) for indirect reference (ODD-OVR).
				;2514	;
				;2515	;SRC-RD-X:	; Read operand or operand address.
				;2516	;=10********0
				;2517	;PLA0	[^1 11X 110, ^X]
				;2518	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2519	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2520	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2521	
				;2522	;WRD-OVR-1:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2523	;=10********0
				;2524	;PLA0	[^X 11X 1X0, ^0 XXX XXX XXX XXX XXX]	; See NOTE 1.
				;2525	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2526	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2527	;			NAF/1777	; Do not alter NAF.
				;2528	;=
				;2529	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;2530	;=10********0
				;2531	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;2532	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2533	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2534	;			NAF/1777	; Do not alter NAF.
				;2535	;=
				;2536	
;2537	.NOBIN
;2538	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   67
; BASE  .MCD [242,1110]      Source Mode 6

;2539		.TOC	"				Source Mode 6"
;2540	
;2541	;
;2542	; Mode 6:
;2543	;
;2544	;	Register added to I-stream word is operand address.
;2545	;
;2546	; Do:
;2547	;	RDI	[RF]			; Read I-stream word from Prefetch Buffer.
;2548	;	ADD.W	[RSRC, RF]		; Add offset to calculate operand address.
;2549	;	AR	[RF]			; Relocate operand address.
;2550	;	RD.()	[RF],			; Read byte or word operand.
;2551	;			NAF/ID2		; Do second instruction decode.
;2552	;
;2553	;
				;2554	.BIN
				;2555	
				;2556	SRC-MODE-6-7:	; Read I-stream word for Modes 6 and 7.
				;2557	=10********0
U 2056, 0037,1777,3700,6000	;2558	PLA0	[^0 111 110, ^X XXX 11X XXX XXX XXX]
U 2057, 0000,0301,7777,1136	;2559		RDI	[RF]			; Read I-stream data from Prefetch Buffer.
				;2560	=
				;2561		ADD.W	[RSRC, RF],		; Add offset.  Calculate operand or pointer address.
U 1136, 0000,1441,6377,0564	;2562				NAF/564		; SRC-ADDR-0.  Relocate calculated address.
				;2563	
				;2564	;SRC-ADDR-X:	; Relocate operand or pointer address.
				;2565	;=10********0
				;2566	;PLA0	[^X 110 100, ^X]
				;2567	;	AR	[RF],			; ODD TRAP with (WRD-OVR), or indirect (ODD-OVR).
				;2568	;			NAF/576		; SRC-RD-X for last reference, or
				;2569	;=					; SRC-RD-0 (566) for indirect reference (ODD-OVR).
				;2570	;
				;2571	;SRC-RD-X:	; Read operand or operand address.
				;2572	;=10********0
				;2573	;PLA0	[^1 11X 110, ^X]
				;2574	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2575	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2576	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2577	
				;2578	;WRD-OVR-1:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2579	;=10********0
				;2580	;PLA0	[^X 11X 1X0, ^0 XXX XXX XXX XXX XXX]	; See NOTE 1.
				;2581	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2582	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2583	;			NAF/1777	; Do not alter NAF.
				;2584	;=
				;2585	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;2586	;=10********0
				;2587	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;2588	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2589	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2590	;			NAF/1777	; Do not alter NAF.
				;2591	;=
;2592	.NOBIN
;2593	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   68
; BASE  .MCD [242,1110]      Source Mode 7

;2594		.TOC	"				Source Mode 7"
;2595	
;2596	;
;2597	; Mode 7:
;2598	;
;2599	;	Register added to I-stream word is pointer to operand address.
;2600	;
;2601	; Do:
;2602	;	RDI	[RF]			; Read I-stream word from Prefetch Buffer.
;2603	;	ADD.W	[RSRC, RF]		; Add offset to calculate pointer to operand address.
;2604	;	AR	[RF]			; Relocate pointer.
;2605	;	RD.W	[RF]			; Read operand address.
;2606	;	AR	[RF]			; Relocate operand address.
;2607	;	RD.()	[RF],			; Read byte or word operand.
;2608	;			NAF/ID2		; Do second instruction decode.
;2609	;
;2610	;
;2611	;
				;2612	.BIN
				;2613	
				;2614	;SRC-MODE-6-7:	; Read I-stream word for Modes 6 and 7.
				;2615	;=10********0
				;2616	;PLA0	[^0 111 110, ^X XXX 11X XXX XXX XXX]
				;2617	;	RDI	[RF]			; Read I-stream data from Prefetch Buffer.
				;2618	;=
				;2619	;	ADD.W	[RSRC, RF],		; Add offset.  Calculate operand or pointer address.
				;2620	;			NAF/564		; SRC-ADDR-0.  Relocate calculated address.
				;2621	;
				;2622	;SRC-ADDR-X:	; Relocate operand or pointer address.
				;2623	;=10********0
				;2624	;PLA0	[^X 110 100, ^X]
				;2625	;	AR	[RF],			; ODD TRAP with (WRD-OVR), or indirect (ODD-OVR).
				;2626	;			NAF/576		; SRC-RD-X for last reference, or
				;2627	;=					; SRC-RD-0 (566) for indirect reference (ODD-OVR).
				;2628	;
				;2629	;SRC-RD-X:	; Read operand or operand address.
				;2630	;=10********0
				;2631	;PLA0	[^1 11X 110, ^X]
				;2632	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2633	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2634	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2635	;
				;2636	;		; Turns on at SRC-RD-0 (566) or SRC-ADDR-0 (564).
				;2637	;ODD-OVR:	; Override for operand address fetch.
				;2638	;=10********0
				;2639	;PLA0	[^1 110 1X0, ^X XXX XX1 XXX XXX XXX]	; Any odd mode.
				;2640	;		BYTE --> WORD,		; Do word read at SRC-RD-0.
				;2641	;		ODD TRAP,		; Enable ODD TRAP at SRC-ADDR-0.
				;2642	;			NAF/1767	; Clear NAF<3> to indicate first bus cycle.
				;2643	;=					; Go to 464 (SRC-ADDR-X) or 566 (SRC-RD-0).
				;2644	;
				;2645	;SRC-ADDR-X:	; Relocate operand or pointer address.
				;2646	;=10********0
				;2647	;PLA0	[^X 110 100, ^X]
				;2648	;	AR	[RF],			; ODD TRAP with (WRD-OVR), or indirect (ODD-OVR).
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   69
; BASE  .MCD [242,1110]      Source Mode 7

				;2649	;			NAF/576		; SRC-RD-X for last reference, or
				;2650	;=					; SRC-RD-0 (566) for indirect reference (ODD-OVR).
				;2651	;
				;2652	;SRC-RD-X:	; Read operand or operand address.
				;2653	;=10********0
				;2654	;PLA0	[^1 11X 110, ^X]
				;2655	;	RD.B	[RF],			; RD.W for word OP (WRD-OVR) or address (ODD-OVR).
				;2656	;			NAF/474		; ID2.  Do second decode.  NAF override (ODD-OVR) to
				;2657	;=					;  SRC-ADDR-X (464) for indirect, Modes 3,5, or 7.
				;2658	
				;2659	;WRD-OVR-1:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2660	;=10********0
				;2661	;PLA0	[^X 11X 1X0, ^0 XXX XXX XXX XXX XXX]	; See NOTE 1.
				;2662	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2663	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2664	;			NAF/1777	; Do not alter NAF.
				;2665	;=
				;2666	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;2667	;=10********0
				;2668	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;2669	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2670	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2671	;			NAF/1777	; Do not alter NAF.
				;2672	;=
				;2673	
;2674	.NOBIN
;2675	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   70
; BASE  .MCD [242,1110]      SOP and DOP Destination Mode Decode

;2676		.TOC	"			SOP and DOP Destination Mode Decode"
;2677	
;2678	;
;2679	;	This code is executed for Single Operand Instructions (SOPs) or	Double
;2680	;	Operand Instructions (DOPs), but only if the Destination Mode is not
;2681	;	zero.  This code fetches the Destination Operand according to the mode
;2682	;	and register specified in bits<5:0> of the macroinstruction.
;2683	;
;2684	;	The last microinstruction executed had either an NAF of ID1 (477), or
;2685	;	ID2 (474).  If ID1, the Q-Logic detected:  1) a SOP with Destination
;2686	;	Mode not zero, or  2) a DOP with Source Mode zero and Destination Mode
;2687	;	not zero.  It therefore zeroed NA<1> (and NA<0> for DOPs) to indicate
;2688	;	that Destination Mode addressing may be done immediately.  If ID2, the
;2689	;	Q-Logic detected a non-zero Destination Mode and did not affect the NA.
;2690	;	In either case, the Q-Logic detected that Destination Mode addressing
;2691	;	must be done.
;2692	;
;2693	;
;2694	; Entry Conditions:
;2695	;
;2696	;	NA = 475 for SOPs
;2697	;	   = 474 for DOPs
;2698	;	QIR contains Opcode
;2699	;	PIR contains Opcode
;2700	;
;2701	; Exit Conditions:
;2702	;
;2703	;	NAF = 473 or 471 (ID3)
;2704	;	RE<7:0>  contains Destination Operand for byte operations
;2705	;	RE<15:0> contains Destination Operand for word operations
;2706	;
;2707	; Method:
;2708	;
;2709	;	PLAs are used almost exclusively to separate the various addressing
;2710	;	modes and provide the necessary byte to word, write to read, and
;2711	;	NAF overrides.
;2712	;
;2713	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   71
; BASE  .MCD [242,1110]      Destination Mode 1

;2714		.TOC	"				Destination Mode 1"
;2715	
;2716	
;2717	;
;2718	; Mode 1:
;2719	;
;2720	;	Register specifies operand address.
;2721	;
;2722	; Do:	(for write-only instructions)
;2723	;	AW	[RDST],			; Relocate operand address and initiate write.
;2724	;			NAF/ID3		; Go directly to third instruction decode.
;2725	;
;2726	; Or:	(for read-modify-write instructions)
;2727	;	AW	[RDST]			; Relocate operand address for write.
;2728	;	RMW.()	[RE],			; Read operand and initiate write.
;2729	;			NAF/ID3		; Do third instruction decode.
;2730	;
;2731	; Or:	(for read-only instructions)
;2732	;	AR	[RDST]			; Relocate operand address for read.
;2733	;	RD.()	[RE],			; Read operand.
;2734	;			NAF/ID3		; Do third instruction decode.
;2735	;
;2736	;
;2737	;
				;2738	.BIN
				;2739	
				;2740	DST-MODE-1:	; Relocate operand address for Mode 1.
				;2741	=10********0
U 2060, 0077,7707,3600,0010	;2742	PLA0	[^0 111 10X, ^X XXX XXX XXX 001 XXX]
				;2743		AW	[RDST],			; ODD TRAP overrides for word OPs (WRD-OVR).
				;2744						; READ overrides for read-only (RO-OVR).
U 2061, 0000,0771,7746,0573	;2745				NAF/573		; DST-RD-1 (573) for read-modify-write.
				;2746						; DST-RD-0 (571) for read-only (RO-OVR).
				;2747	=					; Or ID3 (473) if write-only (WO-OVR).
				;2748	
				;2749	DST-RD-1:	; Read operand for read-modify-write.
				;2750	=10********0
U 2062, 0037,7777,7540,0000	;2751	PLA0	[^1 111 011, ^X]
				;2752		RMW.B	[RE],			; Word OP overrides (WRD-OVR).  LOCKED for ASRB.
U 2063, 0000,0337,7776,0473	;2753				NAF/473		; ID3 (473).  Finish instruction.
				;2754	=
				;2755	DST-RD-0:	; Read operand for read-only.
				;2756	=10********0
U 2064, 0037,7777,7440,0000	;2757	PLA0	[^1 111 001, ^X]
				;2758		RD.B	[RE],			; Word override for word OPs (WRD-OVR).
U 2065, 0000,0327,7776,0473	;2759				NAF/473		; ID3 (473).  Finish instruction.
				;2760	=
				;2761	WO-OVR-1:	; Write-only (NAF) override for MOV.
				;2762	=10********0
U 2066, 1070,7777,2601,0000	;2763	PLA0	[^0 1X1 10X, ^X 001 XXX XXX XXX XXX]
				;2764		NOP.B	[RF, RE],		; No OR-array output may be all 1's.
U 2067, 0000,1777,7776,1677	;2765				NAF/1677	; Override to ID3 (473).
				;2766	=
				;2767	WO-OVR-2:	; Write-only (NAF) override for CLR.
				;2768	=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   72
; BASE  .MCD [242,1110]      Destination Mode 1

U 2070, 1070,0077,2600,5000	;2769	PLA0	[^0 1X1 10X, ^X 000 101 000 XXX XXX]
				;2770		NOP.B	[RF, RE],		; No OR-array output may be all 1's.
U 2071, 0000,1777,7776,1677	;2771				NAF/1677	; Override to ID3 (473).
				;2772	=
				;2773	WO-OVR-3:	; Write-only (NAF) override for SXT and MFPS.
				;2774	=10********0
U 2072, 1070,0077,2600,6700	;2775	PLA0	[^0 1X1 10X, ^X 000 110 111 XXX XXX]
				;2776		NOP.B	[RF, RE],		; No OR-array output may be all 1's.
U 2073, 0000,1777,7776,1677	;2777				NAF/1677	; Override to ID3 (473).
				;2778	=
				;2779	WO-OVR-4:	; Write-only (NAF) and space override for MTPI, Mode 1.
				;2780	=10********0
U 2074, 0060,0007,3600,6610	;2781	PLA0	[^0 111 10X, ^0 000 110 110 001 XXX]
				;2782			I SPACE,		; Use I Space PARs and PDRs
				;2783			PREVIOUS MODE,		;  selected by PS<13:12>.
U 2075, 0000,1777,3637,1677	;2784				NAF/1677	; Override to ID3 (473).
				;2785	=
				;2786			; Write-only (NAF) and space override for MTPD, Mode 1.
				;2787	WO-OVR-5:	; Word OP override for Modes 1 and 4.
				;2788	=10********0
U 2076, 0060,0057,3610,6600	;2789	PLA0	[^0 111 10X, ^1 000 110 110 X0X XXX]
				;2790			D SPACE,		; Use D Space PARs and PDRs
				;2791			PREVIOUS MODE,		;  selected by PS<13:12>.
				;2792			BYTE --> WORD,		; Word override for Modes 1 and 4.
				;2793			ODD TRAP,		; Must be a word address.
U 2077, 0000,1771,3337,1677	;2794				NAF/1677	; Override to ID3 (473).
				;2795	=
				;2796	RO-OVR-1:	; Read-only override for CMP and BIT.
				;2797	=10********0
U 2100, 1071,7777,2602,0000	;2798	PLA0	[^0 1X1 10X, ^X 01X XXX XXX XXX XXX]
				;2799			WRITE --> READ,		; Override AW to AR.
U 2101, 0000,1737,7777,1775	;2800				NAF/1775	; Override to DST-RD-0 (571).
				;2801	=
				;2802	RO-OVR-2:	; Read-only override for TST.
				;2803	=10********0
U 2102, 1070,0077,2600,5700	;2804	PLA0	[^0 1X1 10X, ^X 000 101 111 XXX XXX]
				;2805			WRITE --> READ,		; Override AW to AR.
U 2103, 0000,1737,7777,1775	;2806				NAF/1775	; Override to DST-RD-0 (571).
				;2807	=
				;2808	RO-OVR-3:	; Read-only override for MTPS.
				;2809	=10********0
U 2104, 1060,0077,2610,6400	;2810	PLA0	[^0 1X1 10X, ^1 000 110 100  XXX XXX]
				;2811			WRITE --> READ,		; Override AW to AR.
U 2105, 0000,1737,7777,1775	;2812				NAF/1775	; Override to DST-RD-0 (571).
				;2813	=
				;2814	RO-OVR-4:	; Read-only override for EIS instructions.
				;2815	=10********0
U 2106, 1060,3777,2607,0000	;2816	PLA0	[^0 1X1 10X, ^0 111 0XX XXX XXX XXX]
				;2817			WRITE --> READ,		; Override AW to AR.
U 2107, 0000,1737,7777,1775	;2818				NAF/1775	; Override to DST-RD-0 (571).
				;2819	=
				;2820	RO-OVR-5:	; Read-only override for CSM.
				;2821	=10********0
U 2110, 1060,0077,2600,7000	;2822	PLA0	[^0 1X1 10X, ^0 000 111 000 XXX XXX]
				;2823			WRITE --> READ,		; Override AW to AR.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   73
; BASE  .MCD [242,1110]      Destination Mode 1

U 2111, 0000,1737,7777,1775	;2824				NAF/1775	; Override to DST-RD-0 (571).
				;2825	=
				;2826	RO-OVR-6:	; Read-only and space override for MFPI, Mode 1.
				;2827	=10********0
U 2112, 0060,0007,3600,6510	;2828	PLA0	[^0 111 10X, ^0 000 110 101 001 XXX]
				;2829			WRITE --> READ,		; Override AW to AR.
				;2830			MFPI SPACE,		; Use I Space unless PS<15:12> = 1111.
				;2831			PREVIOUS MODE,		; Use PS<13:12> to select PARs and PDRs.
U 2113, 0000,1737,3677,1775	;2832				NAF/1775	; Override to DST-RD-0 (571).
				;2833	=
				;2834			; Read-only and space override for MFPD, Mode 1.
				;2835	RO-OVR-7:	; Word OP override for Modes 1 and 4.
				;2836	=10********0
U 2114, 0060,0057,3610,6500	;2837	PLA0	[^0 111 10X, ^1 000 110 101 X0X XXX]
				;2838			WRITE --> READ,		; Override AW to AR.
				;2839			D SPACE,		; Use D Space PARs and PDRs
				;2840			PREVIOUS MODE,		;  selected by PS<13:12>.
				;2841			BYTE --> WORD,		; Word override for Modes 1 and 4.
				;2842			ODD TRAP,		; Must be a word address.
U 2115, 0000,1731,3337,1775	;2843				NAF/1775	; Override to DST-RD-0 (571).
				;2844	=
				;2845	LOCKED:		; Read locked override for ASRB.
				;2846	=10********0
U 2116, 0020,0077,7550,6200	;2847	PLA0	[^1 111 011, ^1 000 110 010 XXX XXX]
				;2848			READ LOCKED,		; Multiprocessor hook for ASRB.
U 2117, 0000,1776,7777,1777	;2849				NAF/1777	; Do not affect NAF.
				;2850	=
				;2851	WRD-OVR-4:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2852	=10********0
U 2120, 1067,7777,2600,0000	;2853	PLA0	[^0 1X1 10X, ^0 XXX XXX XXX XXX XXX]	; See NOTE 3.
				;2854			BYTE --> WORD,		; Force word Read or Address increment by two.
				;2855			ODD TRAP,		; Force ODD TRAP enable for Address instructions.
U 2121, 0000,1771,7377,1777	;2856				NAF/1777	; Do not alter NAF.
				;2857	=
				;2858	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;2859	;=10********0
				;2860	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;2861	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;2862	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;2863	;			NAF/1777	; Do not alter NAF.
				;2864	;=
				;2865	WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;2866	=10********0
U 2122, 4167,7777,3400,0000	;2867	PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
				;2868			BYTE --> WORD,		; Force word Read or word Operate.
U 2123, 0000,1771,7777,1777	;2869				NAF/1777	; Do not alter NAF.
				;2870	=
				;2871	WRD-OVR-6:	; Detect SUB (word operation) at DST-RD-1.
				;2872	=10********0
U 2124, 0020,7777,7556,0000	;2873	PLA0	[^1 111 011, ^1 110 XXX XXX XXX XXX]
				;2874			BYTE --> WORD,		; Force word Read.
U 2125, 0000,1771,7777,1777	;2875				NAF/1777	; Do not alter NAF.
				;2876	=
				;2877	WRD-OVR-7:	; Detect MFPD (word operation) at DST-RD-0.
				;2878	=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   74
; BASE  .MCD [242,1110]      Destination Mode 1

U 2126, 0020,0077,7450,6500	;2879	PLA0	[^1 111 001, ^1 000 110 101 XXX XXX]
				;2880			BYTE --> WORD,		; Force word Read.
U 2127, 0000,1771,7777,1777	;2881				NAF/1777	; Do not alter NAF.
				;2882	=
				;2883	
;2884	.NOBIN
;2885	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   75
; BASE  .MCD [242,1110]      Destination Mode 2

;2886		.TOC	"				Destination Mode 2"
;2887	
;2888	
;2889	;
;2890	; Mode 2:
;2891	;
;2892	;	Register specifies operand address.
;2893	;	Register is post-autoincremented.
;2894	;
;2895	; Do:	(for write-only instructions)
;2896	;	AWI.()	[RDST],			; Relocate operand address, increment, and initiate write.
;2897	;			NAF/ID3		; Go directly to third instruction decode.
;2898	;
;2899	; Or:	(for read-modify-write instructions)
;2900	;	AWI.()	[RDST]			; Relocate operand address for write and increment.
;2901	;	RMW.()	[RE],			; Read operand and initiate write.
;2902	;			NAF/ID3		; Do third instruction decode.
;2903	;
;2904	; Or:	(for read-only instructions)
;2905	;	ARI	[RDST]			; Relocate operand address for read and increment.
;2906	;	RD.()	[RE],			; Read operand.
;2907	;			NAF/ID3		; Do third instruction decode.
;2908	;
;2909	; Or:	(for read-only Mode 27 instructions)
;2910	;	RDI	[RE+],			; Read Prefetch Buffer instead and
;2911	;			NAF/ID3		;  go directly to third decode.
;2912	;
;2913	;
;2914	;
				;2915	.BIN
				;2916	
				;2917	DST-MODE-2:	; Relocate operand address for Mode 2.
				;2918	=10********0
U 2130, 0077,7707,3600,0020	;2919	PLA0	[^0 111 10X, ^X XXX XXX XXX 010 XXX]
				;2920		AWI.B	[RDST],			; ODD TRAP, WORD overrides for word OPs (WRD-OVR).
				;2921						; READ overrides for read-only (RO-OVR).
				;2922			LD MMR1,		; Record autoincrement in MMR1.
U 2131, 0000,0744,7746,0573	;2923				NAF/573		; DST-RD-1 (573) for read-modify-write.
				;2924						; DST-RD-0 (571) for read-only (RO-OVR).
				;2925	=					; Or ID3 (473) if write-only (WO-OVR).
				;2926	
				;2927	;DST-RD-1:	; Read operand for read-modify-write.
				;2928	;=10********0
				;2929	;PLA0	[^1 111 011, ^X]
				;2930	;	RMW.B	[RE],			; Word OP overrides (WRD-OVR).  LOCKED for ASRB.
				;2931	;			NAF/473		; ID3 (473).  Finish instruction.
				;2932	;=
				;2933	;DST-RD-0:	; Read operand for read-only.
				;2934	;=10********0
				;2935	;PLA0	[^1 111 001, ^X]
				;2936	;	RD.B	[RE],			; Word override for word OPs (WRD-OVR).
				;2937	;			NAF/473		; ID3 (473).  Finish instruction.
				;2938	;=
				;2939	RO-M27-1:	; Read-only Mode 27 override for CMP and BIT.
				;2940	=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   76
; BASE  .MCD [242,1110]      Destination Mode 2

U 2132, 0071,7700,3602,0027	;2941	PLA0	[^0 111 10X, ^X 01X XXX XXX 010 111]
				;2942		RDI	[RE+],			; Override ARI and RDST both.  Read PB.
U 2133, 0000,0301,7744,0471	;2943				NAF/471		; ID3 (471).  Finish instruction.
				;2944	=
				;2945	RO-M27-2:	; Read-only Mode 27 override for TST.
				;2946	=10********0
U 2134, 0070,0000,3600,5727	;2947	PLA0	[^0 111 10X, ^X 000 101 111 010 111]
				;2948		RDI	[RE+],			; Override ARI and RDST both.  Read PB.
U 2135, 0000,0301,7744,0471	;2949				NAF/471		; ID3 (471).  Finish instruction.
				;2950	=
				;2951	RO-M27-3:	; Read-only Mode 27 override for MTPS.
				;2952	=10********0
U 2136, 0060,0000,3610,6427	;2953	PLA0	[^0 111 10X, ^1 000 110 100 010 111]
				;2954		RDI	[RE+],			; Override ARI and RDST both.  Read PB.
U 2137, 0000,0301,7744,0471	;2955				NAF/471		; ID3 (471).  Finish instruction.
				;2956	=
				;2957	RO-M27-4:	; Read-only Mode 27 override for EIS instructions.
				;2958	=10********0
U 2140, 0060,3700,3607,0027	;2959	PLA0	[^0 111 10X, ^0 111 0XX XXX 010 111]
				;2960		RDI	[RE+],			; Override ARI and RDST both.  Read PB.
U 2141, 0000,0301,7744,0471	;2961				NAF/471		; ID3 (471).  Finish instruction.
				;2962	=
				;2963	RO-M27-5:	; Read-only Mode 27 override for CSM.
				;2964	=10********0
U 2142, 0060,0000,3600,7027	;2965	PLA0	[^0 111 10X, ^0 000 111 000 010 111]
				;2966		RDI	[RE+],			; Override ARI and RDST both.  Read PB.
U 2143, 0000,0301,7744,0471	;2967				NAF/471		; ID3 (471).  Finish instruction.
				;2968	=
				;2969	;WO-OVR-1:	; Write-only (NAF) override for MOV.
				;2970	;=10********0
				;2971	;PLA0	[^0 1X1 10X, ^X 001 XXX XXX XXX XXX]
				;2972	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;2973	;			NAF/1677	; Override to ID3 (473).
				;2974	;=
				;2975	;WO-OVR-2:	; Write-only (NAF) override for CLR.
				;2976	;=10********0
				;2977	;PLA0	[^0 1X1 10X, ^X 000 101 000 XXX XXX]
				;2978	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;2979	;			NAF/1677	; Override to ID3 (473).
				;2980	;=
				;2981	;WO-OVR-3:	; Write-only (NAF) override for SXT and MFPS.
				;2982	;=10********0
				;2983	;PLA0	[^0 1X1 10X, ^X 000 110 111 XXX XXX]
				;2984	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;2985	;			NAF/1677	; Override to ID3 (473).
				;2986	;=
				;2987	WO-OVR-6:	; Write-only (NAF) and space override for MTPI, Mode 2.
				;2988	=10********0
U 2144, 0060,0007,3600,6620	;2989	PLA0	[^0 111 10X, ^0 000 110 110 010 XXX]
				;2990			I SPACE,		; Use I Space PARs and PDRs
				;2991			PREVIOUS MODE,		;  selected by PS<13:12>.
U 2145, 0000,1777,3637,1677	;2992				NAF/1677	; Override to ID3 (473).
				;2993	=
				;2994	WO-OVR-7:	; Write-only (NAF) and space override for MTPD, Mode 2.
				;2995	=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   77
; BASE  .MCD [242,1110]      Destination Mode 2

U 2146, 0060,0007,3610,6620	;2996	PLA0	[^0 111 10X, ^1 000 110 110 010 XXX]
				;2997			D SPACE,		; Use D Space PARs and PDRs
				;2998			PREVIOUS MODE,		;  selected by PS<13:12>.
				;2999			BYTE --> WORD,		; Word override for Mode 2.
				;3000			ODD TRAP,		; Must be a word address.
U 2147, 0000,1771,3337,1677	;3001				NAF/1677	; Override to ID3 (473).
				;3002	=
				;3003	;RO-OVR-1:	; Read-only override for CMP and BIT.
				;3004	;=10********0
				;3005	;PLA0	[^0 1X1 10X, ^X 01X XXX XXX XXX XXX]
				;3006	;		WRITE --> READ,		; Override AW to AR.
				;3007	;			NAF/1775	; Override to DST-RD-0 (571).
				;3008	;=
				;3009	;RO-OVR-2:	; Read-only override for TST.
				;3010	;=10********0
				;3011	;PLA0	[^0 1X1 10X, ^X 000 101 111 XXX XXX]
				;3012	;		WRITE --> READ,		; Override AW to AR.
				;3013	;			NAF/1775	; Override to DST-RD-0 (571).
				;3014	;=
				;3015	;RO-OVR-3:	; Read-only override for MTPS.
				;3016	;=10********0
				;3017	;PLA0	[^0 1X1 10X, ^1 000 110 100  XXX XXX]
				;3018	;		WRITE --> READ,		; Override AW to AR.
				;3019	;			NAF/1775	; Override to DST-RD-0 (571).
				;3020	;=
				;3021	;RO-OVR-4:	; Read-only override for EIS instructions.
				;3022	;=10********0
				;3023	;PLA0	[^0 1X1 10X, ^0 111 0XX XXX XXX XXX]
				;3024	;		WRITE --> READ,		; Override AW to AR.
				;3025	;			NAF/1775	; Override to DST-RD-0 (571).
				;3026	;=
				;3027	;RO-OVR-5:	; Read-only override for CSM.
				;3028	;=10********0
				;3029	;PLA0	[^0 1X1 10X, ^0 000 111 000 XXX XXX]
				;3030	;		WRITE --> READ,		; Override AW to AR.
				;3031	;			NAF/1775	; Override to DST-RD-0 (571).
				;3032	;=
				;3033	RO-OVR-8:	; Read-only and space override for MFPI, Mode 2.
				;3034	=10********0
U 2150, 0060,0007,3600,6520	;3035	PLA0	[^0 111 10X, ^0 000 110 101 010 XXX]
				;3036			WRITE --> READ,		; Override AW to AR.
				;3037			MFPI SPACE,		; Use I Space unless PS<15:12> = 1111.
				;3038			PREVIOUS MODE,		; Use PS<13:12> to select PARs and PDRs.
U 2151, 0000,1737,3677,1775	;3039				NAF/1775	; Override to DST-RD-0 (571).
				;3040	=
				;3041	RO-OVR-9:	; Read-only and space override for MFPD, Mode 2.
				;3042	=10********0
U 2152, 0060,0007,3610,6520	;3043	PLA0	[^0 111 10X, ^1 000 110 101 010 XXX]
				;3044			WRITE --> READ,		; Override AW to AR.
				;3045			D SPACE,		; Use D Space PARs and PDRs
				;3046			PREVIOUS MODE,		;  selected by PS<13:12>.
				;3047			BYTE --> WORD,		; Word override for Mode 2.
				;3048			ODD TRAP,		; Must be a word address.
U 2153, 0000,1731,3337,1775	;3049				NAF/1775	; Override to DST-RD-0 (571).
				;3050	=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   78
; BASE  .MCD [242,1110]      Destination Mode 2

				;3051	;LOCKED:	; Read locked override for ASRB.
				;3052	;=10********0
				;3053	;PLA0	[^1 111 011, ^1 000 110 010 XXX XXX]
				;3054	;		READ LOCKED,		; Multiprocessor hook for ASRB.
				;3055	;			NAF/1777	; Do not affect NAF.
				;3056	;=
				;3057	;WRD-OVR-4:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3058	;=10********0
				;3059	;PLA0	[^0 1X1 10X, ^0 XXX XXX XXX XXX XXX]	; See NOTE 3.
				;3060	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3061	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3062	;			NAF/1777	; Do not alter NAF.
				;3063	;=
				;3064	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;3065	;=10********0
				;3066	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;3067	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3068	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3069	;			NAF/1777	; Do not alter NAF.
				;3070	;=
				;3071	;WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3072	;=10********0
				;3073	;PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
				;3074	;		BYTE --> WORD,		; Force word Read or word Operate.
				;3075	;			NAF/1777	; Do not alter NAF.
				;3076	;=
				;3077	;WRD-OVR-6:	; Detect SUB (word operation) at DST-RD-1.
				;3078	;=10********0
				;3079	;PLA0	[^1 111 011, ^1 110 XXX XXX XXX XXX]
				;3080	;		BYTE --> WORD,		; Force word Read.
				;3081	;			NAF/1777	; Do not alter NAF.
				;3082	;=
				;3083	;WRD-OVR-7:	; Detect MFPD (word operation) at DST-RD-0.
				;3084	;=10********0
				;3085	;PLA0	[^1 111 001, ^1 000 110 101 XXX XXX]
				;3086	;		BYTE --> WORD,		; Force word Read.
				;3087	;			NAF/1777	; Do not alter NAF.
				;3088	;=
				;3089	WRD-OVR-8:	; Detect R6 (SP) or R7 (PC) and increment/decrement by two.
				;3090	=10********0
U 2154, 0077,7761,3600,0006	;3091	PLA0	[^0 111 10X, ^X XXX XXX XXX XX0 11X]
				;3092			BYTE --> WORD,		; Force Address increment/decrement by two.
U 2155, 0000,1771,7777,1777	;3093				NAF/1777	; Do not alter NAF.
				;3094	=
				;3095	
;3096	.NOBIN
;3097	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   79
; BASE  .MCD [242,1110]      Destination Mode 3

;3098		.TOC	"				Destination Mode 3"
;3099	
;3100	;
;3101	; Mode 3:
;3102	;
;3103	;	Register specifies pointer to operand address.
;3104	;	Register is post-autoincremented.
;3105	;
;3106	; Do:
;3107	;	ARI.W	[RDST]			; Relocate pointer and autoincrement.
;3108	;	RD.W	[RE]			; Read word length operand address.
;3109	;
;3110	; Or:
;3111	;	RDI	[RE+]			; Read I-stream word for Mode 37.
;3112	;
;3113	; Then:	(for write-only instructions)
;3114	;	AW	[RE],			; Relocate operand address and initiate write.
;3115	;			NAF/ID3		; Go directly to third instruction decode.
;3116	;
;3117	; Then:	(for read-modify-write instructions)
;3118	;	AW	[RE]			; Relocate operand address for write.
;3119	;	RMW.()	[RE],			; Read operand and initiate write.
;3120	;			NAF/ID3		; Do third instruction decode.
;3121	;
;3122	; Then:	(for read-only instructions)
;3123	;	AR	[RE]			; Relocate operand address for read.
;3124	;	RD.()	[RE],			; Read operand.
;3125	;			NAF/ID3		; Do third instruction decode.
;3126	;
;3127	
				;3128	.BIN
				;3129	
				;3130	DST-MODE-3:	; Relocate pointer for Mode 3.
				;3131	=10********0
U 2156, 0077,7707,3600,0030	;3132	PLA0	[^0 111 10X, ^X XXX XXX XXX 011 XXX]
				;3133		ARI.W	[RDST],			; Always increment pointer by two.
				;3134			LD MMR1,		; MMR1 records the amount.
				;3135			ODD TRAP,		; Must be a word address.
U 2157, 0000,0700,7346,1454	;3136				NAF/RD-ADDR	; Read address.  Finish first bus cycle.
				;3137	=
				;3138	=1001*110*				; For Mode 37, this NAF must be overriddable to
				;3139						;  DST-ADDR (454), but must not be overridden by
				;3140	RD-ADDR:				;  WO-OVRs or RO-OVRs.  Must also abort to ROM[40].
				;3141		RD.W	[RE],			; Read address of final operand.
U 1454, 0000,0321,7776,0454	;3142				NAF/454		; DST-ADDR.  Do address cycle for operand.
				;3143	=
				;3144	DST-MODE-37:	; Override for special case Mode 37.
				;3145	=10********0
U 2160, 0077,7700,3600,0037	;3146	PLA0	[^0 111 10X, ^X XXX XXX XXX 011 111]
				;3147		RDI	[RE+],			; Override ARI and RDST both. Read PB.
U 2161, 0000,0301,7744,0454	;3148				NAF/454		; DST-ADDR.  Go directly to final address cycle.
				;3149	=
				;3150	DST-ADDR:	; Do appropriate final address cycle.
				;3151	=10********0
U 2162, 0037,7777,2600,0000	;3152	PLA0	[^0 101 100, ^X]
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   80
; BASE  .MCD [242,1110]      Destination Mode 3

				;3153		AW	[RE],			; ODD TRAP overrides for word OPs (WRD-OVR).
				;3154						; READ overrides for read-only (RO-OVR).
U 2163, 0000,0771,7776,0573	;3155				NAF/573		; DST-RD-1 (573) for read-modify-write.
				;3156						; DST-RD-0 (571) for read-only (RO-OVR).
				;3157	=					; Or ID3 (473) if write-only (WO-OVR).
				;3158	
				;3159	;DST-RD-1:	; Read operand for read-modify-write.
				;3160	;=10********0
				;3161	;PLA0	[^1 111 011, ^X]
				;3162	;	RMW.B	[RE],			; Word OP overrides (WRD-OVR).  LOCKED for ASRB.
				;3163	;			NAF/473		; ID3 (473).  Finish instruction.
				;3164	;=
				;3165	;DST-RD-0:	; Read operand for read-only.
				;3166	;=10********0
				;3167	;PLA0	[^1 111 001, ^X]
				;3168	;	RD.B	[RE],			; Word override for word OPs (WRD-OVR).
				;3169	;			NAF/473		; ID3 (473).  Finish instruction.
				;3170	;=
				;3171	;WO-OVR-1:	; Write-only (NAF) override for MOV.
				;3172	;=10********0
				;3173	;PLA0	[^0 1X1 10X, ^X 001 XXX XXX XXX XXX]
				;3174	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3175	;			NAF/1677	; Override to ID3 (473).
				;3176	;=
				;3177	;WO-OVR-2:	; Write-only (NAF) override for CLR.
				;3178	;=10********0
				;3179	;PLA0	[^0 1X1 10X, ^X 000 101 000 XXX XXX]
				;3180	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3181	;			NAF/1677	; Override to ID3 (473).
				;3182	;=
				;3183	;WO-OVR-3:	; Write-only (NAF) override for SXT and MFPS.
				;3184	;=10********0
				;3185	;PLA0	[^0 1X1 10X, ^X 000 110 111 XXX XXX]
				;3186	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3187	;			NAF/1677	; Override to ID3 (473).
				;3188	;=
				;3189	WO-OVR-8:	; Write-only (NAF) and space override for MTPI, Modes 3-7.
				;3190	=10********0	; Modes 0-2 never get to 454.
U 2164, 0060,0077,2600,6600	;3191	PLA0	[^0 101 10X, ^0 000 110 110 XXX XXX]
				;3192			I SPACE,		; Use I Space PARs and PDRs
				;3193			PREVIOUS MODE,		;  selected by PS<13:12>.
U 2165, 0000,1777,3637,1677	;3194				NAF/1677	; Override to ID3 (473).
				;3195	=
				;3196	WO-OVR-9:	; Write-only (NAF) and space override for MTPD, Modes 3-7.
				;3197	=10********0	; Modes 0-2 never get to 454.
U 2166, 0060,0077,2610,6600	;3198	PLA0	[^0 101 10X, ^1 000 110 110 XXX XXX]
				;3199			D SPACE,		; Use D Space PARs and PDRs
				;3200			PREVIOUS MODE,		;  selected by PS<13:12>.
				;3201			BYTE --> WORD,		; Word override for Modes 3-7.
				;3202			ODD TRAP,		; Must be a word address.
U 2167, 0000,1771,3337,1677	;3203				NAF/1677	; Override to ID3 (473).
				;3204	=
				;3205	;RO-OVR-1:	; Read-only override for CMP and BIT.
				;3206	;=10********0
				;3207	;PLA0	[^0 1X1 10X, ^X 01X XXX XXX XXX XXX]
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   81
; BASE  .MCD [242,1110]      Destination Mode 3

				;3208	;		WRITE --> READ,		; Override AW to AR.
				;3209	;			NAF/1775	; Override to DST-RD-0 (571).
				;3210	;=
				;3211	;RO-OVR-2:	; Read-only override for TST.
				;3212	;=10********0
				;3213	;PLA0	[^0 1X1 10X, ^X 000 101 111 XXX XXX]
				;3214	;		WRITE --> READ,		; Override AW to AR.
				;3215	;			NAF/1775	; Override to DST-RD-0 (571).
				;3216	;=
				;3217	;RO-OVR-3:	; Read-only override for MTPS.
				;3218	;=10********0
				;3219	;PLA0	[^0 1X1 10X, ^1 000 110 100  XXX XXX]
				;3220	;		WRITE --> READ,		; Override AW to AR.
				;3221	;			NAF/1775	; Override to DST-RD-0 (571).
				;3222	;=
				;3223	;RO-OVR-4:	; Read-only override for EIS instructions.
				;3224	;=10********0
				;3225	;PLA0	[^0 1X1 10X, ^0 111 0XX XXX XXX XXX]
				;3226	;		WRITE --> READ,		; Override AW to AR.
				;3227	;			NAF/1775	; Override to DST-RD-0 (571).
				;3228	;=
				;3229	;RO-OVR-5:	; Read-only override for CSM.
				;3230	;=10********0
				;3231	;PLA0	[^0 1X1 10X, ^0 000 111 000 XXX XXX]
				;3232	;		WRITE --> READ,		; Override AW to AR.
				;3233	;			NAF/1775	; Override to DST-RD-0 (571).
				;3234	;=
				;3235	RO-OVR-10:	; Read-only and space override for MFPI, Modes 3-7.
				;3236	=10********0	; Modes 0-2 never get to 454.
U 2170, 0060,0077,2600,6500	;3237	PLA0	[^0 101 10X, ^0 000 110 101 XXX XXX]
				;3238			WRITE --> READ,		; Override AW to AR.
				;3239			MFPI SPACE,		; Use I Space unless PS<15:12> = 1111.
				;3240			PREVIOUS MODE,		; Use PS<13:12> to select PARs and PDRs.
U 2171, 0000,1737,3677,1775	;3241				NAF/1775	; Override to DST-RD-0 (571).
				;3242	=
				;3243	RO-OVR-11:	; Read-only and space override for MFPD, Modes 3-7.
				;3244	=10********0	; Modes 0-2 never get to 454.
U 2172, 0060,0077,2610,6500	;3245	PLA0	[^0 101 10X, ^1 000 110 101 XXX XXX]
				;3246			WRITE --> READ,		; Override AW to AR.
				;3247			D SPACE,		; Use D Space PARs and PDRs
				;3248			PREVIOUS MODE,		;  selected by PS<13:12>.
				;3249			BYTE --> WORD,		; Word override for Modes 3-7.
				;3250			ODD TRAP,		; Must be a word address.
U 2173, 0000,1731,3337,1775	;3251				NAF/1775	; Override to DST-RD-0 (571).
				;3252	=
				;3253	;LOCKED:	; Read locked override for ASRB.
				;3254	;=10********0
				;3255	;PLA0	[^1 111 011, ^1 000 110 010 XXX XXX]
				;3256	;		READ LOCKED,		; Multiprocessor hook for ASRB.
				;3257	;			NAF/1777	; Do not affect NAF.
				;3258	;=
				;3259	;WRD-OVR-4:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3260	;=10********0
				;3261	;PLA0	[^0 1X1 10X, ^0 XXX XXX XXX XXX XXX]	; See NOTE 3.
				;3262	;		BYTE --> WORD,		; Force word Read or Address increment by two.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   82
; BASE  .MCD [242,1110]      Destination Mode 3

				;3263	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3264	;			NAF/1777	; Do not alter NAF.
				;3265	;=
				;3266	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;3267	;=10********0
				;3268	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;3269	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3270	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3271	;			NAF/1777	; Do not alter NAF.
				;3272	;=
				;3273	;WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3274	;=10********0
				;3275	;PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
				;3276	;		BYTE --> WORD,		; Force word Read or word Operate.
				;3277	;			NAF/1777	; Do not alter NAF.
				;3278	;=
				;3279	;WRD-OVR-6:	; Detect SUB (word operation) at DST-RD-1.
				;3280	;=10********0
				;3281	;PLA0	[^1 111 011, ^1 110 XXX XXX XXX XXX]
				;3282	;		BYTE --> WORD,		; Force word Read.
				;3283	;			NAF/1777	; Do not alter NAF.
				;3284	;=
				;3285	;WRD-OVR-7:	; Detect MFPD (word operation) at DST-RD-0.
				;3286	;=10********0
				;3287	;PLA0	[^1 111 001, ^1 000 110 101 XXX XXX]
				;3288	;		BYTE --> WORD,		; Force word Read.
				;3289	;			NAF/1777	; Do not alter NAF.
				;3290	;=
				;3291	
;3292	.NOBIN
;3293	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   83
; BASE  .MCD [242,1110]      Destination Mode 4

;3294		.TOC	"				Destination Mode 4"
;3295	
;3296	;
;3297	; Mode 4:
;3298	;
;3299	;	Register is pre-autodecremented.
;3300	;	Register specifies operand address.
;3301	;
;3302	; Do:
;3303	;	ARD.()	[RDST]			; Decrement address by one or two.
;3304	;
;3305	; Then:	(for write-only instructions)
;3306	;	AW	[RDST],			; Relocate operand address and initiate write.
;3307	;			NAF/ID3		; Go directly to third instruction decode.
;3308	;
;3309	; Then:	(for read-modify-write instructions)
;3310	;	AW	[RDST]			; Relocate operand address for write.
;3311	;	RMW.()	[RE],			; Read operand and initiate write.
;3312	;			NAF/ID3		; Do third instruction decode.
;3313	;
;3314	; Then:	(for read-only instructions)
;3315	;	AR	[RDST]			; Relocate operand address for read.
;3316	;	RD.()	[RE],			; Read operand.
;3317	;			NAF/ID3		; Do third instruction decode.
;3318	;
;3319	;
;3320	;
				;3321	.BIN
				;3322	
				;3323	DST-MODE-4:	; Decrement address for Mode 4.
				;3324	=10********0
U 2174, 0077,7707,3600,0040	;3325	PLA0	[^0 111 10X, ^X XXX XXX XXX 100 XXX]
				;3326		ARD.B	[RDST],			; Word OPs decrement by two (WRD-OVR).
				;3327			LD MMR1,		; MMR1 records the amount.
				;3328			NO ABORTS,		; Disable aborts.  Decrement and load MMR1 only.
U 2175, 0000,0714,7546,0454	;3329				NAF/454		; DST-ADDR (454).  Do appropriate address cycle.
				;3330	=
				;3331	DST-ADDR-MD-4:	; For Mode 4, do final address cycle using RDST.
				;3332	=10********0
U 2176, 0037,7707,2600,0040	;3333	PLA0	[^0 101 100, ^X XXX XXX XXX 100 XXX]
				;3334		AW	[RDST],			; ODD TRAP overrides for word OPs (WRD-OVR).
				;3335						; READ overrides for read-only (RO-OVR).
				;3336			SOVFF,			; Check for Yellow Stack Overflow Trap.
U 2177, 0000,0771,6746,0573	;3337				NAF/573		; DST-RD-1 (573) for read-modify-write.
				;3338						; DST-RD-0 (571) for read-only (RO-OVR).
				;3339	=					; Or ID3 (473) if write-only (WO-OVR).
				;3340	
				;3341	;DST-RD-1:	; Read operand for read-modify-write.
				;3342	;=10********0
				;3343	;PLA0	[^1 111 011, ^X]
				;3344	;	RMW.B	[RE],			; Word OP overrides (WRD-OVR).  LOCKED for ASRB.
				;3345	;			NAF/473		; ID3 (473).  Finish instruction.
				;3346	;=
				;3347	;DST-RD-0:	; Read operand for read-only.
				;3348	;=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   84
; BASE  .MCD [242,1110]      Destination Mode 4

				;3349	;PLA0	[^1 111 001, ^X]
				;3350	;	RD.B	[RE],			; Word override for word OPs (WRD-OVR).
				;3351	;			NAF/473		; ID3 (473).  Finish instruction.
				;3352	;=
				;3353	;WO-OVR-1:	; Write-only (NAF) override for MOV.
				;3354	;=10********0
				;3355	;PLA0	[^0 1X1 10X, ^X 001 XXX XXX XXX XXX]
				;3356	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3357	;			NAF/1677	; Override to ID3 (473).
				;3358	;=
				;3359	;WO-OVR-2:	; Write-only (NAF) override for CLR.
				;3360	;=10********0
				;3361	;PLA0	[^0 1X1 10X, ^X 000 101 000 XXX XXX]
				;3362	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3363	;			NAF/1677	; Override to ID3 (473).
				;3364	;=
				;3365	;WO-OVR-3:	; Write-only (NAF) override for SXT and MFPS.
				;3366	;=10********0
				;3367	;PLA0	[^0 1X1 10X, ^X 000 110 111 XXX XXX]
				;3368	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3369	;			NAF/1677	; Override to ID3 (473).
				;3370	;=
				;3371	;WO-OVR-8:	; Write-only (NAF) and space override for MTPI, Modes 3-7.
				;3372	;=10********0	; Modes 0-2 never get to 454.
				;3373	;PLA0	[^0 101 10X, ^0 000 110 110 XXX XXX]
				;3374	;		I SPACE,		; Use I Space PARs and PDRs
				;3375	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3376	;			NAF/1677	; Override to ID3 (473).
				;3377	;=
				;3378	;WO-OVR-9:	; Write-only (NAF) and space override for MTPD, Modes 3-7.
				;3379	;=10********0	; Modes 0-2 never get to 454.
				;3380	;PLA0	[^0 101 10X, ^1 000 110 110 XXX XXX]
				;3381	;		D SPACE,		; Use D Space PARs and PDRs
				;3382	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3383	;		BYTE --> WORD,		; Word override for Modes 3-7.
				;3384	;		ODD TRAP,		; Must be a word address.
				;3385	;			NAF/1677	; Override to ID3 (473).
				;3386	;=
				;3387	;RO-OVR-1:	; Read-only override for CMP and BIT.
				;3388	;=10********0
				;3389	;PLA0	[^0 1X1 10X, ^X 01X XXX XXX XXX XXX]
				;3390	;		WRITE --> READ,		; Override AW to AR.
				;3391	;			NAF/1775	; Override to DST-RD-0 (571).
				;3392	;=
				;3393	;RO-OVR-2:	; Read-only override for TST.
				;3394	;=10********0
				;3395	;PLA0	[^0 1X1 10X, ^X 000 101 111 XXX XXX]
				;3396	;		WRITE --> READ,		; Override AW to AR.
				;3397	;			NAF/1775	; Override to DST-RD-0 (571).
				;3398	;=
				;3399	;RO-OVR-3:	; Read-only override for MTPS.
				;3400	;=10********0
				;3401	;PLA0	[^0 1X1 10X, ^1 000 110 100  XXX XXX]
				;3402	;		WRITE --> READ,		; Override AW to AR.
				;3403	;			NAF/1775	; Override to DST-RD-0 (571).
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   85
; BASE  .MCD [242,1110]      Destination Mode 4

				;3404	;=
				;3405	;RO-OVR-4:	; Read-only override for EIS instructions.
				;3406	;=10********0
				;3407	;PLA0	[^0 1X1 10X, ^0 111 0XX XXX XXX XXX]
				;3408	;		WRITE --> READ,		; Override AW to AR.
				;3409	;			NAF/1775	; Override to DST-RD-0 (571).
				;3410	;=
				;3411	;RO-OVR-5:	; Read-only override for CSM.
				;3412	;=10********0
				;3413	;PLA0	[^0 1X1 10X, ^0 000 111 000 XXX XXX]
				;3414	;		WRITE --> READ,		; Override AW to AR.
				;3415	;			NAF/1775	; Override to DST-RD-0 (571).
				;3416	;=
				;3417	;RO-OVR-10:	; Read-only and space override for MFPI, Modes 3-7.
				;3418	;=10********0	; Modes 0-2 never get to 454.
				;3419	;PLA0	[^0 101 10X, ^0 000 110 101 XXX XXX]
				;3420	;		WRITE --> READ,		; Override AW to AR.
				;3421	;		MFPI SPACE,		; Use I Space unless PS<15:12> = 1111.
				;3422	;		PREVIOUS MODE,		; Use PS<13:12> to select PARs and PDRs.
				;3423	;			NAF/1775	; Override to DST-RD-0 (571).
				;3424	;=
				;3425	;RO-OVR-11:	; Read-only and space override for MFPD, Modes 3-7.
				;3426	;=10********0	; Modes 0-2 never get to 454.
				;3427	;PLA0	[^0 101 10X, ^1 000 110 101 XXX XXX]
				;3428	;		WRITE --> READ,		; Override AW to AR.
				;3429	;		D SPACE,		; Use D Space PARs and PDRs
				;3430	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3431	;		BYTE --> WORD,		; Word override for Modes 3-7.
				;3432	;		ODD TRAP,		; Must be a word address.
				;3433	;			NAF/1775	; Override to DST-RD-0 (571).
				;3434	;=
				;3435	;LOCKED:	; Read locked override for ASRB.
				;3436	;=10********0
				;3437	;PLA0	[^1 111 011, ^1 000 110 010 XXX XXX]
				;3438	;		READ LOCKED,		; Multiprocessor hook for ASRB.
				;3439	;			NAF/1777	; Do not affect NAF.
				;3440	;=
				;3441	;WO-OVR-5:	; Write-only (NAF) and space override for MTPD, Mode 1.
				;3442	;=10********0	; Word OP override for Modes 1 and 4.
				;3443	;PLA0	[^0 111 10X, ^1 000 110 110 X0X XXX]
				;3444	;		D SPACE,		; Use D Space PARs and PDRs
				;3445	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3446	;		BYTE --> WORD,		; Word override for Modes 1 and 4.
				;3447	;		ODD TRAP,		; Must be a word address.
				;3448	;			NAF/1677	; Override to ID3 (473).
				;3449	;=
				;3450	;RO-OVR-7:	; Read-only and space override for MFPD, Mode 1.
				;3451	;=10********0	; Word OP override for Modes 1 and 4.
				;3452	;PLA0	[^0 111 10X, ^1 000 110 101 X0X XXX]
				;3453	;		WRITE --> READ,		; Override AW to AR.
				;3454	;		D SPACE,		; Use D Space PARs and PDRs
				;3455	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3456	;		BYTE --> WORD,		; Word override for Modes 1 and 4.
				;3457	;		ODD TRAP,		; Must be a word address.
				;3458	;			NAF/1775	; Override to DST-RD-0 (571).
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   86
; BASE  .MCD [242,1110]      Destination Mode 4

				;3459	;=
				;3460	;WRD-OVR-4:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3461	;=10********0
				;3462	;PLA0	[^0 1X1 10X, ^0 XXX XXX XXX XXX XXX]	; See NOTE 3.
				;3463	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3464	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3465	;			NAF/1777	; Do not alter NAF.
				;3466	;=
				;3467	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;3468	;=10********0
				;3469	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;3470	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3471	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3472	;			NAF/1777	; Do not alter NAF.
				;3473	;=
				;3474	;WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3475	;=10********0
				;3476	;PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
				;3477	;		BYTE --> WORD,		; Force word Read or word Operate.
				;3478	;			NAF/1777	; Do not alter NAF.
				;3479	;=
				;3480	;WRD-OVR-6:	; Detect SUB (word operation) at DST-RD-1.
				;3481	;=10********0
				;3482	;PLA0	[^1 111 011, ^1 110 XXX XXX XXX XXX]
				;3483	;		BYTE --> WORD,		; Force word Read.
				;3484	;			NAF/1777	; Do not alter NAF.
				;3485	;=
				;3486	;WRD-OVR-7:	; Detect MFPD (word operation) at DST-RD-0.
				;3487	;=10********0
				;3488	;PLA0	[^1 111 001, ^1 000 110 101 XXX XXX]
				;3489	;		BYTE --> WORD,		; Force word Read.
				;3490	;			NAF/1777	; Do not alter NAF.
				;3491	;=
				;3492	;WRD-OVR-8:	; Detect R6 (SP) or R7 (PC) and increment/decrement by two.
				;3493	;=10********0
				;3494	;PLA0	[^0 111 10X, ^X XXX XXX XXX XX0 11X]
				;3495	;		BYTE --> WORD,		; Force Address increment/decrement by two.
				;3496	;			NAF/1777	; Do not alter NAF.
				;3497	;=
				;3498	
;3499	.NOBIN
;3500	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   87
; BASE  .MCD [242,1110]      Destination Mode 5

;3501		.TOC	"				Destination Mode 5"
;3502	
;3503	;
;3504	; Mode 5:
;3505	;
;3506	;	Register is pre-autodecremented.
;3507	;	Register specifies pointer to operand address.
;3508	;
;3509	; Do:
;3510	;	ARD.W	[RDST]			; Decrement address by two.
;3511	;	AR	[RDST]			; Relocate pointer address.
;3512	;	RD.W	[RE]			; Read word length operand address.
;3513	;
;3514	; Then:	(for write-only instructions)
;3515	;	AW	[RE],			; Relocate operand address and initiate write.
;3516	;			NAF/ID3		; Go directly to third instruction decode.
;3517	;
;3518	; Then:	(for read-modify-write instructions)
;3519	;	AW	[RE]			; Relocate operand address for write.
;3520	;	RMW.()	[RE],			; Read operand and initiate write.
;3521	;			NAF/ID3		; Do third instruction decode.
;3522	;
;3523	; Then:	(for read-only instructions)
;3524	;	AR	[RE]			; Relocate operand address for read.
;3525	;	RD.()	[RE],			; Read operand.
;3526	;			NAF/ID3		; Do third instruction decode.
;3527	;
;3528	;
;3529	;
				;3530	.BIN
				;3531	
				;3532	DST-MODE-5:	; Decrement pointer for Mode 5.
				;3533	=10********0
U 2200, 0077,7707,3600,0050	;3534	PLA0	[^0 111 10X, ^X XXX XXX XXX 101 XXX]
				;3535		ARD.W	[RDST],			; Always decrement pointer by two.
				;3536			LD MMR1,		; MMR1 records the amount.
U 2201, 0000,0710,7546,0045	;3537			NO ABORTS		; Disable aborts.  Decrement and load MMR1 only.
				;3538	=
				;3539	=*001***0*				; NAF must not be overridden by WO-OVRs or RO-OVRs.
				;3540						;  Must also abort to ROM[40].
				;3541		AR	[RDST],			; Relocate pointer address.
				;3542			ODD TRAP,		; Must be a word address.
				;3543			SOVFF,			; Check for Yellow Stack Overflow Trap.
U 0045, 0000,0731,6346,1454	;3544				NAF/RD-ADDR	; Read address.  Finish first bus cycle.
				;3545	=
				;3546	;=1001*110*				; For Mode 37, this NAF must be overriddable to
				;3547	;					;  DST-ADDR (454), but must not be overridden by
				;3548	;RD-ADDR:				;  WO-OVRs or RO-OVRs.  Must also abort to ROM[40].
				;3549	;	RD.W	[RE],			; Read address of final operand.
				;3550	;			NAF/454		; DST-ADDR.  Do address cycle for operand.
				;3551	;=
				;3552	;DST-ADDR:	; Do appropriate final address cycle.
				;3553	;=10********0
				;3554	;PLA0	[^0 101 100, ^X]
				;3555	;	AW	[RE],			; ODD TRAP overrides for word OPs (WRD-OVR).
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   88
; BASE  .MCD [242,1110]      Destination Mode 5

				;3556	;					; READ overrides for read-only (RO-OVR).
				;3557	;			NAF/573		; DST-RD-1 (573) for read-modify-write.
				;3558	;					; DST-RD-0 (571) for read-only (RO-OVR).
				;3559	;=					; Or ID3 (473) if write-only (WO-OVR).
				;3560	;
				;3561	;DST-RD-1:	; Read operand for read-modify-write.
				;3562	;=10********0
				;3563	;PLA0	[^1 111 011, ^X]
				;3564	;	RMW.B	[RE],			; Word OP overrides (WRD-OVR).  LOCKED for ASRB.
				;3565	;			NAF/473		; ID3 (473).  Finish instruction.
				;3566	;=
				;3567	;DST-RD-0:	; Read operand for read-only.
				;3568	;=10********0
				;3569	;PLA0	[^1 111 001, ^X]
				;3570	;	RD.B	[RE],			; Word override for word OPs (WRD-OVR).
				;3571	;			NAF/473		; ID3 (473).  Finish instruction.
				;3572	;=
				;3573	;WO-OVR-1:	; Write-only (NAF) override for MOV.
				;3574	;=10********0
				;3575	;PLA0	[^0 1X1 10X, ^X 001 XXX XXX XXX XXX]
				;3576	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3577	;			NAF/1677	; Override to ID3 (473).
				;3578	;=
				;3579	;WO-OVR-2:	; Write-only (NAF) override for CLR.
				;3580	;=10********0
				;3581	;PLA0	[^0 1X1 10X, ^X 000 101 000 XXX XXX]
				;3582	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3583	;			NAF/1677	; Override to ID3 (473).
				;3584	;=
				;3585	;WO-OVR-3:	; Write-only (NAF) override for SXT and MFPS.
				;3586	;=10********0
				;3587	;PLA0	[^0 1X1 10X, ^X 000 110 111 XXX XXX]
				;3588	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3589	;			NAF/1677	; Override to ID3 (473).
				;3590	;=
				;3591	;WO-OVR-8:	; Write-only (NAF) and space override for MTPI, Modes 3-7.
				;3592	;=10********0	; Modes 0-2 never get to 454.
				;3593	;PLA0	[^0 101 10X, ^0 000 110 110 XXX XXX]
				;3594	;		I SPACE,		; Use I Space PARs and PDRs
				;3595	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3596	;			NAF/1677	; Override to ID3 (473).
				;3597	;=
				;3598	;WO-OVR-9:	; Write-only (NAF) and space override for MTPD, Modes 3-7.
				;3599	;=10********0	; Modes 0-2 never get to 454.
				;3600	;PLA0	[^0 101 10X, ^1 000 110 110 XXX XXX]
				;3601	;		D SPACE,		; Use D Space PARs and PDRs
				;3602	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3603	;		BYTE --> WORD,		; Word override for Modes 3-7.
				;3604	;		ODD TRAP,		; Must be a word address.
				;3605	;			NAF/1677	; Override to ID3 (473).
				;3606	;=
				;3607	;RO-OVR-1:	; Read-only override for CMP and BIT.
				;3608	;=10********0
				;3609	;PLA0	[^0 1X1 10X, ^X 01X XXX XXX XXX XXX]
				;3610	;		WRITE --> READ,		; Override AW to AR.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   89
; BASE  .MCD [242,1110]      Destination Mode 5

				;3611	;			NAF/1775	; Override to DST-RD-0 (571).
				;3612	;=
				;3613	;RO-OVR-2:	; Read-only override for TST.
				;3614	;=10********0
				;3615	;PLA0	[^0 1X1 10X, ^X 000 101 111 XXX XXX]
				;3616	;		WRITE --> READ,		; Override AW to AR.
				;3617	;			NAF/1775	; Override to DST-RD-0 (571).
				;3618	;=
				;3619	;RO-OVR-3:	; Read-only override for MTPS.
				;3620	;=10********0
				;3621	;PLA0	[^0 1X1 10X, ^1 000 110 100  XXX XXX]
				;3622	;		WRITE --> READ,		; Override AW to AR.
				;3623	;			NAF/1775	; Override to DST-RD-0 (571).
				;3624	;=
				;3625	;RO-OVR-4:	; Read-only override for EIS instructions.
				;3626	;=10********0
				;3627	;PLA0	[^0 1X1 10X, ^0 111 0XX XXX XXX XXX]
				;3628	;		WRITE --> READ,		; Override AW to AR.
				;3629	;			NAF/1775	; Override to DST-RD-0 (571).
				;3630	;=
				;3631	;RO-OVR-5:	; Read-only override for CSM.
				;3632	;=10********0
				;3633	;PLA0	[^0 1X1 10X, ^0 000 111 000 XXX XXX]
				;3634	;		WRITE --> READ,		; Override AW to AR.
				;3635	;			NAF/1775	; Override to DST-RD-0 (571).
				;3636	;=
				;3637	;RO-OVR-10:	; Read-only and space override for MFPI, Modes 3-7.
				;3638	;=10********0	; Modes 0-2 never get to 454.
				;3639	;PLA0	[^0 101 10X, ^0 000 110 101 XXX XXX]
				;3640	;		WRITE --> READ,		; Override AW to AR.
				;3641	;		MFPI SPACE,		; Use I Space unless PS<15:12> = 1111.
				;3642	;		PREVIOUS MODE,		; Use PS<13:12> to select PARs and PDRs.
				;3643	;			NAF/1775	; Override to DST-RD-0 (571).
				;3644	;=
				;3645	;RO-OVR-11:	; Read-only and space override for MFPD, Modes 3-7.
				;3646	;=10********0	; Modes 0-2 never get to 454.
				;3647	;PLA0	[^0 101 10X, ^1 000 110 101 XXX XXX]
				;3648	;		WRITE --> READ,		; Override AW to AR.
				;3649	;		D SPACE,		; Use D Space PARs and PDRs
				;3650	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3651	;		BYTE --> WORD,		; Word override for Modes 3-7.
				;3652	;		ODD TRAP,		; Must be a word address.
				;3653	;			NAF/1775	; Override to DST-RD-0 (571).
				;3654	;=
				;3655	;LOCKED:	; Read locked override for ASRB.
				;3656	;=10********0
				;3657	;PLA0	[^1 111 011, ^1 000 110 010 XXX XXX]
				;3658	;		READ LOCKED,		; Multiprocessor hook for ASRB.
				;3659	;			NAF/1777	; Do not affect NAF.
				;3660	;=
				;3661	;WO-OVR-5:	; Write-only (NAF) and space override for MTPD, Mode 1.
				;3662	;=10********0	; Word OP override for Modes 1 and 4.
				;3663	;PLA0	[^0 111 10X, ^1 000 110 110 X0X XXX]
				;3664	;		D SPACE,		; Use D Space PARs and PDRs
				;3665	;		PREVIOUS MODE,		;  selected by PS<13:12>.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   90
; BASE  .MCD [242,1110]      Destination Mode 5

				;3666	;		BYTE --> WORD,		; Word override for Modes 1 and 4.
				;3667	;		ODD TRAP,		; Must be a word address.
				;3668	;			NAF/1677	; Override to ID3 (473).
				;3669	;=
				;3670	;RO-OVR-7:	; Read-only and space override for MFPD, Mode 1.
				;3671	;=10********0	; Word OP override for Modes 1 and 4.
				;3672	;PLA0	[^0 111 10X, ^1 000 110 101 X0X XXX]
				;3673	;		WRITE --> READ,		; Override AW to AR.
				;3674	;		D SPACE,		; Use D Space PARs and PDRs
				;3675	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3676	;		BYTE --> WORD,		; Word override for Modes 1 and 4.
				;3677	;		ODD TRAP,		; Must be a word address.
				;3678	;			NAF/1775	; Override to DST-RD-0 (571).
				;3679	;=
				;3680	;WRD-OVR-4:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3681	;=10********0
				;3682	;PLA0	[^0 1X1 10X, ^0 XXX XXX XXX XXX XXX]	; See NOTE 3.
				;3683	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3684	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3685	;			NAF/1777	; Do not alter NAF.
				;3686	;=
				;3687	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;3688	;=10********0
				;3689	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;3690	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3691	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3692	;			NAF/1777	; Do not alter NAF.
				;3693	;=
				;3694	;WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3695	;=10********0
				;3696	;PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
				;3697	;		BYTE --> WORD,		; Force word Read or word Operate.
				;3698	;			NAF/1777	; Do not alter NAF.
				;3699	;=
				;3700	;WRD-OVR-6:	; Detect SUB (word operation) at DST-RD-1.
				;3701	;=10********0
				;3702	;PLA0	[^1 111 011, ^1 110 XXX XXX XXX XXX]
				;3703	;		BYTE --> WORD,		; Force word Read.
				;3704	;			NAF/1777	; Do not alter NAF.
				;3705	;=
				;3706	;WRD-OVR-7:	; Detect MFPD (word operation) at DST-RD-0.
				;3707	;=10********0
				;3708	;PLA0	[^1 111 001, ^1 000 110 101 XXX XXX]
				;3709	;		BYTE --> WORD,		; Force word Read.
				;3710	;			NAF/1777	; Do not alter NAF.
				;3711	;=
				;3712	
;3713	.NOBIN
;3714	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   91
; BASE  .MCD [242,1110]      Destination Mode 6

;3715		.TOC	"				Destination Mode 6"
;3716	
;3717	;
;3718	; Mode 6:
;3719	;
;3720	;	Register added to I-stream word is operand address.
;3721	;
;3722	; Do:
;3723	;	RDI	[RE]			; Read I-stream word from Prefetch Buffer.
;3724	;	ADD.W	[RDST, RE]		; Add offset to calculate operand address.
;3725	;
;3726	; Then:	(for write-only instructions)
;3727	;	AW	[RE],			; Relocate operand address and initiate write.
;3728	;			NAF/ID3		; Go directly to third instruction decode.
;3729	;
;3730	; Then:	(for read-modify-write instructions)
;3731	;	AW	[RE]			; Relocate operand address for write.
;3732	;	RMW.()	[RE],			; Read operand and initiate write.
;3733	;			NAF/ID3		; Do third instruction decode.
;3734	;
;3735	; Then:	(for read-only instructions)
;3736	;	AR	[RE]			; Relocate operand address for read.
;3737	;	RD.()	[RE],			; Read operand.
;3738	;			NAF/ID3		; Do third instruction decode.
;3739	;
;3740	;
;3741	;
				;3742	.BIN
				;3743	
				;3744	DST-MODE-6:	; Read I-stream word for Mode 6.
				;3745	=10********0
U 2202, 0077,7707,3600,0060	;3746	PLA0	[^0 111 10X, ^X XXX XXX XXX 110 XXX]
U 2203, 0000,0301,7776,0050	;3747		RDI	[RE]			; Read I-stream data from Prefetch Buffer.
				;3748	=
				;3749	=*001***0*				; NAF must not be overridden by WO-OVRs or RO-OVRs.
				;3750						;  Must also abort to ROM[40].
				;3751		ADD.W	[RDST, RE],		; Add offset.  RE now contains operand address.
U 0050, 0000,1441,6336,0454	;3752				NAF/454		; DST-ADDR.  Do address cycle for operand.
				;3753	=
				;3754	;DST-ADDR:	; Do appropriate final address cycle.
				;3755	;=10********0
				;3756	;PLA0	[^0 101 100, ^X]
				;3757	;	AW	[RE],			; ODD TRAP overrides for word OPs (WRD-OVR).
				;3758	;					; READ overrides for read-only (RO-OVR).
				;3759	;			NAF/573		; DST-RD-1 (573) for read-modify-write.
				;3760	;					; DST-RD-0 (571) for read-only (RO-OVR).
				;3761	;=					; Or ID3 (473) if write-only (WO-OVR).
				;3762	
				;3763	;DST-RD-1:	; Read operand for read-modify-write.
				;3764	;=10********0
				;3765	;PLA0	[^1 111 011, ^X]
				;3766	;	RMW.B	[RE],			; Word OP overrides (WRD-OVR).  LOCKED for ASRB.
				;3767	;			NAF/473		; ID3 (473).  Finish instruction.
				;3768	;=
				;3769	;DST-RD-0:	; Read operand for read-only.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   92
; BASE  .MCD [242,1110]      Destination Mode 6

				;3770	;=10********0
				;3771	;PLA0	[^1 111 001, ^X]
				;3772	;	RD.B	[RE],			; Word override for word OPs (WRD-OVR).
				;3773	;			NAF/473		; ID3 (473).  Finish instruction.
				;3774	;=
				;3775	;WO-OVR-1:	; Write-only (NAF) override for MOV.
				;3776	;=10********0
				;3777	;PLA0	[^0 1X1 10X, ^X 001 XXX XXX XXX XXX]
				;3778	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3779	;			NAF/1677	; Override to ID3 (473).
				;3780	;=
				;3781	;WO-OVR-2:	; Write-only (NAF) override for CLR.
				;3782	;=10********0
				;3783	;PLA0	[^0 1X1 10X, ^X 000 101 000 XXX XXX]
				;3784	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3785	;			NAF/1677	; Override to ID3 (473).
				;3786	;=
				;3787	;WO-OVR-3:	; Write-only (NAF) override for SXT and MFPS.
				;3788	;=10********0
				;3789	;PLA0	[^0 1X1 10X, ^X 000 110 111 XXX XXX]
				;3790	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3791	;			NAF/1677	; Override to ID3 (473).
				;3792	;=
				;3793	;WO-OVR-8:	; Write-only (NAF) and space override for MTPI, Modes 3-7.
				;3794	;=10********0	; Modes 0-2 never get to 454.
				;3795	;PLA0	[^0 101 10X, ^0 000 110 110 XXX XXX]
				;3796	;		I SPACE,		; Use I Space PARs and PDRs
				;3797	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3798	;			NAF/1677	; Override to ID3 (473).
				;3799	;=
				;3800	;WO-OVR-9:	; Write-only (NAF) and space override for MTPD, Modes 3-7.
				;3801	;=10********0	; Modes 0-2 never get to 454.
				;3802	;PLA0	[^0 101 10X, ^1 000 110 110 XXX XXX]
				;3803	;		D SPACE,		; Use D Space PARs and PDRs
				;3804	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3805	;		BYTE --> WORD,		; Word override for Modes 3-7.
				;3806	;		ODD TRAP,		; Must be a word address.
				;3807	;			NAF/1677	; Override to ID3 (473).
				;3808	;=
				;3809	;RO-OVR-1:	; Read-only override for CMP and BIT.
				;3810	;=10********0
				;3811	;PLA0	[^0 1X1 10X, ^X 01X XXX XXX XXX XXX]
				;3812	;		WRITE --> READ,		; Override AW to AR.
				;3813	;			NAF/1775	; Override to DST-RD-0 (571).
				;3814	;=
				;3815	;RO-OVR-2:	; Read-only override for TST.
				;3816	;=10********0
				;3817	;PLA0	[^0 1X1 10X, ^X 000 101 111 XXX XXX]
				;3818	;		WRITE --> READ,		; Override AW to AR.
				;3819	;			NAF/1775	; Override to DST-RD-0 (571).
				;3820	;=
				;3821	;RO-OVR-3:	; Read-only override for MTPS.
				;3822	;=10********0
				;3823	;PLA0	[^0 1X1 10X, ^1 000 110 100  XXX XXX]
				;3824	;		WRITE --> READ,		; Override AW to AR.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   93
; BASE  .MCD [242,1110]      Destination Mode 6

				;3825	;			NAF/1775	; Override to DST-RD-0 (571).
				;3826	;=
				;3827	;RO-OVR-4:	; Read-only override for EIS instructions.
				;3828	;=10********0
				;3829	;PLA0	[^0 1X1 10X, ^0 111 0XX XXX XXX XXX]
				;3830	;		WRITE --> READ,		; Override AW to AR.
				;3831	;			NAF/1775	; Override to DST-RD-0 (571).
				;3832	;=
				;3833	;RO-OVR-5:	; Read-only override for CSM.
				;3834	;=10********0
				;3835	;PLA0	[^0 1X1 10X, ^0 000 111 000 XXX XXX]
				;3836	;		WRITE --> READ,		; Override AW to AR.
				;3837	;			NAF/1775	; Override to DST-RD-0 (571).
				;3838	;=
				;3839	;RO-OVR-10:	; Read-only and space override for MFPI, Modes 3-7.
				;3840	;=10********0	; Modes 0-2 never get to 454.
				;3841	;PLA0	[^0 101 10X, ^0 000 110 101 XXX XXX]
				;3842	;		WRITE --> READ,		; Override AW to AR.
				;3843	;		MFPI SPACE,		; Use I Space unless PS<15:12> = 1111.
				;3844	;		PREVIOUS MODE,		; Use PS<13:12> to select PARs and PDRs.
				;3845	;			NAF/1775	; Override to DST-RD-0 (571).
				;3846	;=
				;3847	;RO-OVR-11:	; Read-only and space override for MFPD, Modes 3-7.
				;3848	;=10********0	; Modes 0-2 never get to 454.
				;3849	;PLA0	[^0 101 10X, ^1 000 110 101 XXX XXX]
				;3850	;		WRITE --> READ,		; Override AW to AR.
				;3851	;		D SPACE,		; Use D Space PARs and PDRs
				;3852	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3853	;		BYTE --> WORD,		; Word override for Modes 3-7.
				;3854	;		ODD TRAP,		; Must be a word address.
				;3855	;			NAF/1775	; Override to DST-RD-0 (571).
				;3856	;=
				;3857	;LOCKED:	; Read locked override for ASRB.
				;3858	;=10********0
				;3859	;PLA0	[^1 111 011, ^1 000 110 010 XXX XXX]
				;3860	;		READ LOCKED,		; Multiprocessor hook for ASRB.
				;3861	;			NAF/1777	; Do not affect NAF.
				;3862	;=
				;3863	;WRD-OVR-4:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3864	;=10********0
				;3865	;PLA0	[^0 1X1 10X, ^0 XXX XXX XXX XXX XXX]	; See NOTE 3.
				;3866	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3867	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3868	;			NAF/1777	; Do not alter NAF.
				;3869	;=
				;3870	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;3871	;=10********0
				;3872	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;3873	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;3874	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;3875	;			NAF/1777	; Do not alter NAF.
				;3876	;=
				;3877	;WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;3878	;=10********0
				;3879	;PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   94
; BASE  .MCD [242,1110]      Destination Mode 6

				;3880	;		BYTE --> WORD,		; Force word Read or word Operate.
				;3881	;			NAF/1777	; Do not alter NAF.
				;3882	;=
				;3883	;WRD-OVR-6:	; Detect SUB (word operation) at DST-RD-1.
				;3884	;=10********0
				;3885	;PLA0	[^1 111 011, ^1 110 XXX XXX XXX XXX]
				;3886	;		BYTE --> WORD,		; Force word Read.
				;3887	;			NAF/1777	; Do not alter NAF.
				;3888	;=
				;3889	;WRD-OVR-7:	; Detect MFPD (word operation) at DST-RD-0.
				;3890	;=10********0
				;3891	;PLA0	[^1 111 001, ^1 000 110 101 XXX XXX]
				;3892	;		BYTE --> WORD,		; Force word Read.
				;3893	;			NAF/1777	; Do not alter NAF.
				;3894	;=
				;3895	;WRD-OVR-8:	; Detect R6 (SP) or R7 (PC) and increment/decrement by two.
				;3896	;=10********0
				;3897	;PLA0	[^0 111 10X, ^X XXX XXX XXX XX0 11X]
				;3898	;		BYTE --> WORD,		; Force Address increment/decrement by two.
				;3899	;			NAF/1777	; Do not alter NAF.
				;3900	;=
				;3901	
;3902	.NOBIN
;3903	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   95
; BASE  .MCD [242,1110]      Destination Mode 7

;3904		.TOC	"				Destination Mode 7"
;3905	
;3906	;
;3907	; Mode 7:
;3908	;
;3909	;	Register added to I-stream word is pointer to operand address.
;3910	;
;3911	; Do:
;3912	;	RDI	[RE]			; Read I-stream word from Prefetch Buffer.
;3913	;	ADD.W	[RDST, RE]		; Add offset to calculate pointer.
;3914	;	AR	[RE]			; Relocate pointer.
;3915	;	RD.W	[RE]			; Read operand address.
;3916	;
;3917	; Then:	(for write-only instructions)
;3918	;	AW	[RE],			; Relocate operand address and initiate write.
;3919	;			NAF/ID3		; Go directly to third instruction decode.
;3920	;
;3921	; Then:	(for read-modify-write instructions)
;3922	;	AW	[RE]			; Relocate operand address for write.
;3923	;	RMW.()	[RE],			; Read operand and initiate write.
;3924	;			NAF/ID3		; Do third instruction decode.
;3925	;
;3926	; Then:	(for read-only instructions)
;3927	;	AR	[RE]			; Relocate operand address for read.
;3928	;	RD.()	[RE],			; Read operand.
;3929	;			NAF/ID3		; Do third instruction decode.
;3930	;
;3931	;
;3932	;
				;3933	.BIN
				;3934	
				;3935	DST-MODE-7:	; Read I-stream word for Mode 7.
				;3936	=10********0
U 2204, 0077,7707,3600,0070	;3937	PLA0	[^0 111 10X, ^X XXX XXX XXX 111 XXX]
U 2205, 0000,0301,7776,0051	;3938		RDI	[RE]			; Read I-stream data from Prefetch Buffer.
				;3939	=
				;3940						; NAF must not be overridden by WO-OVRs or RO-OVRs.
				;3941	=*001***0*				;  Must also abort to ROM[40].
U 0051, 0000,1441,6336,0046	;3942		ADD.W	[RDST, RE]		; Add offset.  RE now contains pointer address.
				;3943	=
				;3944	=*0*1*****				; Must abort to ROM[40].
				;3945		AR	[RE],			; Relocate pointer address.
				;3946			ODD TRAP,		; Must be a word address.
U 0046, 0000,0731,7376,1454	;3947				NAF/RD-ADDR	; Read address.  Finish first bus cycle.
				;3948	=
				;3949	;=1001*110*				; For Mode 37, this NAF must be overriddable to
				;3950	;					;  DST-ADDR (454), but must not be overridden by
				;3951	;RD-ADDR:				;  WO-OVRs or RO-OVRs.  Must also abort to ROM[40].
				;3952	;	RD.W	[RE],			; Read address of final operand.
				;3953	;			NAF/454		; DST-ADDR.  Do address cycle for operand.
				;3954	;=
				;3955	;DST-ADDR:	; Do appropriate final address cycle.
				;3956	;=10********0
				;3957	;PLA0	[^0 101 100, ^X]
				;3958	;	AW	[RE],			; ODD TRAP overrides for word OPs (WRD-OVR).
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   96
; BASE  .MCD [242,1110]      Destination Mode 7

				;3959	;					; READ overrides for read-only (RO-OVR).
				;3960	;			NAF/573		; DST-RD-1 (573) for read-modify-write.
				;3961	;					; DST-RD-0 (571) for read-only (RO-OVR).
				;3962	;=					; Or ID3 (473) if write-only (WO-OVR).
				;3963	
				;3964	;DST-RD-1:	; Read operand for read-modify-write.
				;3965	;=10********0
				;3966	;PLA0	[^1 111 011, ^X]
				;3967	;	RMW.B	[RE],			; Word OP overrides (WRD-OVR).  LOCKED for ASRB.
				;3968	;			NAF/473		; ID3 (473).  Finish instruction.
				;3969	;=
				;3970	;DST-RD-0:	; Read operand for read-only.
				;3971	;=10********0
				;3972	;PLA0	[^1 111 001, ^X]
				;3973	;	RD.B	[RE],			; Word override for word OPs (WRD-OVR).
				;3974	;			NAF/473		; ID3 (473).  Finish instruction.
				;3975	;=
				;3976	;WO-OVR-1:	; Write-only (NAF) override for MOV.
				;3977	;=10********0
				;3978	;PLA0	[^0 1X1 10X, ^X 001 XXX XXX XXX XXX]
				;3979	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3980	;			NAF/1677	; Override to ID3 (473).
				;3981	;=
				;3982	;WO-OVR-2:	; Write-only (NAF) override for CLR.
				;3983	;=10********0
				;3984	;PLA0	[^0 1X1 10X, ^X 000 101 000 XXX XXX]
				;3985	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3986	;			NAF/1677	; Override to ID3 (473).
				;3987	;=
				;3988	;WO-OVR-3:	; Write-only (NAF) override for SXT and MFPS.
				;3989	;=10********0
				;3990	;PLA0	[^0 1X1 10X, ^X 000 110 111 XXX XXX]
				;3991	;	NOP.B	[RF, RE],		; No OR-array output may be all 1's.
				;3992	;			NAF/1677	; Override to ID3 (473).
				;3993	;=
				;3994	;WO-OVR-8:	; Write-only (NAF) and space override for MTPI, Modes 3-7.
				;3995	;=10********0	; Modes 0-2 never get to 454.
				;3996	;PLA0	[^0 101 10X, ^0 000 110 110 XXX XXX]
				;3997	;		I SPACE,		; Use I Space PARs and PDRs
				;3998	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;3999	;			NAF/1677	; Override to ID3 (473).
				;4000	;=
				;4001	;WO-OVR-9:	; Write-only (NAF) and space override for MTPD, Modes 3-7.
				;4002	;=10********0	; Modes 0-2 never get to 454.
				;4003	;PLA0	[^0 101 10X, ^1 000 110 110 XXX XXX]
				;4004	;		D SPACE,		; Use D Space PARs and PDRs
				;4005	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;4006	;		BYTE --> WORD,		; Word override for Modes 3-7.
				;4007	;		ODD TRAP,		; Must be a word address.
				;4008	;			NAF/1677	; Override to ID3 (473).
				;4009	;=
				;4010	;RO-OVR-1:	; Read-only override for CMP and BIT.
				;4011	;=10********0
				;4012	;PLA0	[^0 1X1 10X, ^X 01X XXX XXX XXX XXX]
				;4013	;		WRITE --> READ,		; Override AW to AR.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   97
; BASE  .MCD [242,1110]      Destination Mode 7

				;4014	;			NAF/1775	; Override to DST-RD-0 (571).
				;4015	;=
				;4016	;RO-OVR-2:	; Read-only override for TST.
				;4017	;=10********0
				;4018	;PLA0	[^0 1X1 10X, ^X 000 101 111 XXX XXX]
				;4019	;		WRITE --> READ,		; Override AW to AR.
				;4020	;			NAF/1775	; Override to DST-RD-0 (571).
				;4021	;=
				;4022	;RO-OVR-3:	; Read-only override for MTPS.
				;4023	;=10********0
				;4024	;PLA0	[^0 1X1 10X, ^1 000 110 100  XXX XXX]
				;4025	;		WRITE --> READ,		; Override AW to AR.
				;4026	;			NAF/1775	; Override to DST-RD-0 (571).
				;4027	;=
				;4028	;RO-OVR-4:	; Read-only override for EIS instructions.
				;4029	;=10********0
				;4030	;PLA0	[^0 1X1 10X, ^0 111 0XX XXX XXX XXX]
				;4031	;		WRITE --> READ,		; Override AW to AR.
				;4032	;			NAF/1775	; Override to DST-RD-0 (571).
				;4033	;=
				;4034	;RO-OVR-5:	; Read-only override for CSM.
				;4035	;=10********0
				;4036	;PLA0	[^0 1X1 10X, ^0 000 111 000 XXX XXX]
				;4037	;		WRITE --> READ,		; Override AW to AR.
				;4038	;			NAF/1775	; Override to DST-RD-0 (571).
				;4039	;=
				;4040	;RO-OVR-10:	; Read-only and space override for MFPI, Modes 3-7.
				;4041	;=10********0	; Modes 0-2 never get to 454.
				;4042	;PLA0	[^0 101 10X, ^0 000 110 101 XXX XXX]
				;4043	;		WRITE --> READ,		; Override AW to AR.
				;4044	;		MFPI SPACE,		; Use I Space unless PS<15:12> = 1111.
				;4045	;		PREVIOUS MODE,		; Use PS<13:12> to select PARs and PDRs.
				;4046	;			NAF/1775	; Override to DST-RD-0 (571).
				;4047	;=
				;4048	;RO-OVR-11:	; Read-only and space override for MFPD, Modes 3-7.
				;4049	;=10********0	; Modes 0-2 never get to 454.
				;4050	;PLA0	[^0 101 10X, ^1 000 110 101 XXX XXX]
				;4051	;		WRITE --> READ,		; Override AW to AR.
				;4052	;		D SPACE,		; Use D Space PARs and PDRs
				;4053	;		PREVIOUS MODE,		;  selected by PS<13:12>.
				;4054	;		BYTE --> WORD,		; Word override for Modes 3-7.
				;4055	;		ODD TRAP,		; Must be a word address.
				;4056	;			NAF/1775	; Override to DST-RD-0 (571).
				;4057	;=
				;4058	;LOCKED:	; Read locked override for ASRB.
				;4059	;=10********0
				;4060	;PLA0	[^1 111 011, ^1 000 110 010 XXX XXX]
				;4061	;		READ LOCKED,		; Multiprocessor hook for ASRB.
				;4062	;			NAF/1777	; Do not affect NAF.
				;4063	;=
				;4064	;WRD-OVR-4:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;4065	;=10********0
				;4066	;PLA0	[^0 1X1 10X, ^0 XXX XXX XXX XXX XXX]	; See NOTE 3.
				;4067	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;4068	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   98
; BASE  .MCD [242,1110]      Destination Mode 7

				;4069	;			NAF/1777	; Do not alter NAF.
				;4070	;=
				;4071	;WRD-OVR-2:	; Detect SUB (subtract is a word operation).
				;4072	;=10********0
				;4073	;PLA0	[^X 1XX 1X0, ^1 110 XXX XXX XXX XXX]	; See NOTE 2.
				;4074	;		BYTE --> WORD,		; Force word Read or Address increment by two.
				;4075	;		ODD TRAP,		; Force ODD TRAP enable for Address instructions.
				;4076	;			NAF/1777	; Do not alter NAF.
				;4077	;=
				;4078	;WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;4079	;=10********0
				;4080	;PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
				;4081	;		BYTE --> WORD,		; Force word Read or word Operate.
				;4082	;			NAF/1777	; Do not alter NAF.
				;4083	;=
				;4084	;WRD-OVR-6:	; Detect SUB (word operation) at DST-RD-1.
				;4085	;=10********0
				;4086	;PLA0	[^1 111 011, ^1 110 XXX XXX XXX XXX]
				;4087	;		BYTE --> WORD,		; Force word Read.
				;4088	;			NAF/1777	; Do not alter NAF.
				;4089	;=
				;4090	;WRD-OVR-7:	; Detect MFPD (word operation) at DST-RD-0.
				;4091	;=10********0
				;4092	;PLA0	[^1 111 001, ^1 000 110 101 XXX XXX]
				;4093	;		BYTE --> WORD,		; Force word Read.
				;4094	;			NAF/1777	; Do not alter NAF.
				;4095	;=
				;4096	
;4097	.NOBIN
;4098	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page   99
; BASE  .MCD [242,1110]      Destination Mode 7

;4099	;
;4100	;	PLA override notes as referenced above:
;4101	;
;4102	
;4103	NOTE 1:
;4104	;	This PLA detects Word OPs, EIS instructions, and CSM at:
;4105	;
;4106	;	464	SRC-ADDR-X (1)			564	SRC-ADDR-X (0)
;4107	;	466	unused				566	SRC-RD-X (0)
;4108	;	474	DOP Destination Decode		574	unused
;4109	;	476	Source Decode			576	SRC-RD-X (1)
;4110	
;4111	NOTE 2:
;4112	;	This PLA detects SUB at:
;4113	;
;4114	;	444	unused				544	unused
;4115	;	446	unused				546	unused
;4116	;	454	DST-ADDR			554	unused
;4117	;	456	unused				556	unused
;4118	;	464	SRC-ADDR-X (1)			564	SRC-ADDR-X (0)
;4119	;	466	unused				566	SRC-RD-X (0)
;4120	;	474	DOP Destination Decode		574	unused
;4121	;	476	Source Decode			576	SRC-RD-X (1)
;4122	;
;4123	;	Notice that one PLA at DST-ADDR (454) would significantly
;4124	;	free up the PLA addressing space.
;4125	
;4126	NOTE 3:
;4127	;	This PLA detects Word OPs, EIS instructions, and CSM at:
;4128	;
;4129	;	454	DST-ADDR			455	unused
;4130	;	474	DOP Destination Decode		475	SOP Destination Decode
;4131	
;4132	NOTE 4:
;4133	;	This PLA detects Word OPs, EIS instructions, and CSM at:
;4134	;
;4135	;	470	DOP Execution			570	unused
;4136	;	471	SOP Execution			571	DST-RD-0
;4137	;	472	DOP Execution			572	unused
;4138	;	473	SOP Execution			573	DST-RD-1
;4139	
;4140	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  100
; BASE  .MCD [242,1110]      SOP and DOP Execution

;4141		.TOC	"			SOP and DOP Execution"
;4142	
;4143	;
;4144	;	This is ID3 (470-473), the execution phase.  All SOPs and DOPs
;4145	;	eventually end up here.
;4146	;
;4147	;	SOPs get here after Destination Decode (475), unless the Destination
;4148	;	Mode is zero.  If thats the case, the Q-Logic zeroes NA<2:1> at ID1 (477)
;4149	;	indicating that no addressing is required.
;4150	;
;4151	;	DOPs can get here from one of three places.  If the Destination Mode
;4152	;	is not zero, they get here from Destination Decode (474).  If the
;4153	;	Destination Mode is zero but the Source Mode is not zero, they get
;4154	;	here from Source Mode Decode.  In that case, the Q-Logic zeroes NA<2>
;4155	;	at ID2 (474).  If both Source and Destination Modes are zero, they
;4156	;	get here directly from ID1 (477), because the Q-Logic zeroes NA<2:0>.
;4157	;
;4158	;	Mode zero is taken care of during this phase by using PLA overrides
;4159	;	to modify the skeleton microinstruction into a microinstruction which
;4160	;	selects the actual PDP11 register specified in the macroinstruction.
;4161	;
;4162	;	PLA overrides are also used to enable the Prefetch control bit, affect
;4163	;	the NAF, and change byte length Operates to word length Operates.
;4164	;
;4165	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  101
; BASE  .MCD [242,1110]      SOP Execution

;4166		.TOC	"				SOP Execution"
;4167	
;4168	;
;4169	; Entry Conditions:
;4170	;
;4171	;	NA = 471 or 473
;4172	;	PIR contains Opcode
;4173	;
;4174	; Exit Conditions:
;4175	;
;4176	;	NAF = ID1 (477)
;4177	;
;4178	; Method:
;4179	;
;4180	;	Each SOP is broken out separately and the corresponding
;4181	;	microinstruction is executed.
;4182	;
;4183	; Do: (if -DM0.-TST)
;4184	;	SOP.()*	[RE, RE]		; Write to memory and update CC.
;4185	;
;4186	;	NOP.W	[RF, PS],		; Then do separate
;4187	;		PREFETCH,		;  Prefetch
;4188	;			NAF/ID1		;  and Predecode.
;4189	;
;4190	; Do: (if DM0.-PC.-TST)
;4191	;	SOP.()*	[RDST, RDST],		; Write to register, update CC, and do
;4192	;		PREFETCH,		;  Prefetch
;4193	;			NAF/ID1		;  and Predecode.
;4194	;
;4195	; Do: (if DM0.PC.-TST)
;4196	;	SOP.()*	[RDST, RDST]		; Write to PC and update CC.
;4197	;
;4198	;	NOP.W	[RF, PS],		; Then do separate
;4199	;		PREFETCH,		;  Prefetch
;4200	;			NAF/ID1		;  and Predecode.
;4201	;
;4202	; Do: (if -DM0.TST)
;4203	;	TST.()*	[RE, PS],		; Update CC and do
;4204	;		PREFETCH,		;  Prefetch
;4205	;			NAF/ID1		;  and Predecode.
;4206	;
;4207	; Do: (if DM0.TST)
;4208	;	TST.()*	[RDST, PS],		; Update CC and do
;4209	;		PREFETCH,		;  Prefetch
;4210	;			NAF/ID1		;  and Predecode.
;4211	;
;4212	
;4213	
;4214	
				;4215	.BIN
				;4216	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  102
; BASE  .MCD [242,1110]      SOP Execution

				;4217	SWAB:		; Do SWAB.
				;4218	=10********0
U 2206, 0120,0077,3440,0300	;4219	PLA0	[^0 111 0X1, ^0 000 000 011 XXX XXX]
				;4220		SWAB.W*	[RE, RE],		; Override RE to RDST if Mode 0, and NAF to
U 2207, 0000,1461,5736,1477	;4221				NAF/NOP-PF	;  ID1 (477) if Modes 00-06 (PF-OVR).
				;4222	=
				;4223	CLR:		; Do CLR(B).
				;4224	=10********0
U 2210, 0130,0077,3440,5000	;4225	PLA0	[^0 111 0X1, ^X 000 101 000 XXX XXX]
				;4226		CLR.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4227						;  BYTE to WORD if word Opcode,
U 2211, 0000,1047,5736,1477	;4228				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4229	=
				;4230	COM:		; Do COM(B).
				;4231	=10********0
U 2212, 0130,0077,3440,5100	;4232	PLA0	[^0 111 0X1, ^X 000 101 001 XXX XXX]
				;4233		COM.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4234						;  BYTE to WORD if word Opcode,
U 2213, 0000,1477,5736,1477	;4235				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4236	=
				;4237	INC:		; Do INC(B).
				;4238	=10********0
U 2214, 0130,0077,3440,5200	;4239	PLA0	[^0 111 0X1, ^X 000 101 010 XXX XXX]
				;4240		INC.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4241						;  BYTE to WORD if word Opcode,
U 2215, 0000,1367,5736,1477	;4242				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4243	=
				;4244	DEC:		; Do DEC(B).
				;4245	=10********0
U 2216, 0130,0077,3440,5300	;4246	PLA0	[^0 111 0X1, ^X 000 101 011 XXX XXX]
				;4247		DEC.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4248						;  BYTE to WORD if word Opcode,
U 2217, 0000,1457,5736,1477	;4249				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4250	=
				;4251	NEG:		; Do NEG(B).
				;4252	=10********0
U 2220, 0130,0077,3440,5400	;4253	PLA0	[^0 111 0X1, ^X 000 101 100 XXX XXX]
				;4254		NEG.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4255						;  BYTE to WORD if word Opcode,
U 2221, 0000,1337,5736,1477	;4256				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4257	=
				;4258	ADC:		; Do ADC(B).
				;4259	=10********0
U 2222, 0130,0077,3440,5500	;4260	PLA0	[^0 111 0X1, ^X 000 101 101 XXX XXX]
				;4261		ADC.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4262						;  BYTE to WORD if word Opcode,
U 2223, 0000,1647,5736,1477	;4263				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4264	=
				;4265	SBC:		; Do SBC(B).
				;4266	=10********0
U 2224, 0130,0077,3440,5600	;4267	PLA0	[^0 111 0X1, ^X 000 101 110 XXX XXX]
				;4268		SBC.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4269						;  BYTE to WORD if word Opcode,
U 2225, 0000,1617,5736,1477	;4270				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4271	=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  103
; BASE  .MCD [242,1110]      SOP Execution

				;4272	TST:		; Do TST(B).
				;4273	=10********0
U 2226, 0130,0077,3440,5700	;4274	PLA0	[^0 111 0X1, ^X 000 101 111 XXX XXX]
				;4275		TST.B*	[RE, PS],		; Override :  RE to RDST if Mode 0, and
				;4276						;  BYTE to WORD if word Opcode.
				;4277			PREFETCH,		; Do Prefetch and go directly to
U 2227, 0000,1666,5700,0477	;4278				NAF/ID1		;  ID1 (477) as TST(B) is read-only.
				;4279	=					; Use PS for Predecode write to IR.
				;4280	ROR:		; Do ROR(B).
				;4281	=10********0
U 2230, 0130,0077,3440,6000	;4282	PLA0	[^0 111 0X1, ^X 000 110 000 XXX XXX]
				;4283		ROR.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4284						;  BYTE to WORD if word Opcode,
U 2231, 0000,1247,5736,1477	;4285				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4286	=
				;4287	ROL:		; Do ROL(B).
				;4288	=10********0
U 2232, 0130,0077,3440,6100	;4289	PLA0	[^0 111 0X1, ^X 000 110 001 XXX XXX]
				;4290		ROL.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4291						;  BYTE to WORD if word Opcode,
U 2233, 0000,1217,5736,1477	;4292				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4293	=
				;4294	ASR:		; Do ASR(B).
				;4295	=10********0
U 2234, 0130,0077,3440,6200	;4296	PLA0	[^0 111 0X1, ^X 000 110 010 XXX XXX]
				;4297		ASR.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4298						;  BYTE to WORD if word Opcode,
U 2235, 0000,1347,5736,1477	;4299				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4300	=
				;4301	ASL:		; Do ASL(B).
				;4302	=10********0
U 2236, 0130,0077,3440,6300	;4303	PLA0	[^0 111 0X1, ^X 000 110 011 XXX XXX]
				;4304		ASL.B*	[RE, RE],		; Override :  RE to RDST if Mode 0,
				;4305						;  BYTE to WORD if word Opcode,
U 2237, 0000,1237,5736,1477	;4306				NAF/NOP-PF	;  NAF to ID1 (477) if Modes 00-06 (PF-OVR).
				;4307	=
				;4308	SXT:		; Do SXT.
				;4309	=10********0
U 2240, 0120,0077,3440,6700	;4310	PLA0	[^0 111 0X1, ^0 000 110 111 XXX XXX]
				;4311		SXT.W*	[RE, RE],		; Override RE to RDST if Mode 0, and NAF to
U 2241, 0000,1061,5736,1477	;4312				NAF/NOP-PF	;  ID1 (477) if Modes 00-06 (PF-OVR).
				;4313	=
				;4314	XOR:		; Do XOR.  XOR treated as SOP but specifies register in Opcode.
				;4315	=10********0
U 2242, 0120,0777,3447,4000	;4316	PLA0	[^0 111 0X1, ^0 111 100 XXX XXX XXX]
				;4317		XOR.W*	[RSRC, RE],		; Override RE to RDST if Mode 0, and NAF to
U 2243, 0000,1541,4376,1477	;4318				NAF/NOP-PF	;  ID1 (477) if Modes 00-06 (PF-OVR).
				;4319	=
				;4320	MFPS:		; Do MFPS.  MFPS treated as SOP but moves PS<7:0>.
				;4321	=10********0
U 2244, 0120,0077,3450,6700	;4322	PLA0	[^0 111 0X1, ^1 000 110 111 XXX XXX]
				;4323		MOV.B*	[PS, RE],		; Override RE to RDST if Mode 0, and NAF to
U 2245, 0000,1567,4036,1477	;4324				NAF/NOP-PF	;  ID1 (477) if Modes 00-06 (PF-OVR).
				;4325	=
				;4326	MFPS0:		; Override for MFPS Mode 0.  Must sign extend upper byte.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  104
; BASE  .MCD [242,1110]      SOP Execution

				;4327	=10********0
U 2246, 0120,0007,3450,6700	;4328	PLA0	[^0 111 0X1, ^1 000 110 111 000 XXX]
				;4329		MOVS.W*	[PS, RDST],		; Override MOV.B to MOVS.W for Mode 0.
U 2247, 0000,1021,4006,1477	;4330				NAF/NOP-PF	;  ID1 (477) if Modes 00-06 (PF-OVR).
				;4331	=
				;4332	1477:					; Must be overridable to ID1 (477).
				;4333	NOP-PF:					;  Must also abort to ROM[40].
				;4334		NOP.W	[RF, PS],		; Do nothing, but allow Predecode to write
				;4335						;  IR on A-bus<31:16> from Prefetch Buffer.
				;4336			PREFETCH,		; Initiate a Prefetch request cycle now
				;4337						;  that all other bus cycles are completed.
U 1477, 0000,1770,7740,0477	;4338				NAF/ID1		; Initiate Predecode.  See "ID1 Q-Logic Next
				;4339						;  Addresses" for possible NAs.
				;4340	
				;4341	SOP-DM0:	; Turns on at SOP execution.
				;4342	=10********0	; Register select and NAF override for Mode 0.
U 2250, 0137,7707,3440,0000	;4343	PLA0	[^0 111 0X1, ^X XXX XXX XXX 000 XXX]
				;4344		RE_RE --> RDST_RDST,		; Override RE to RDST (PDP11 register).
U 2251, 0000,1777,6347,1777	;4345				NAF/1777	; Do not affect NAF.
				;4346	=
				;4347	PF-OVR-1:	; Turns on at CLR(B) to TST(B), and XOR execution.
				;4348	=10********0	; Prefetch and NAF override for Destination Modes 00-03.
U 2252, 0137,1703,3440,4000	;4349	PLA0	[^0 111 0X1, ^X XXX 10X XXX 000 0XX]
				;4350			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2253, 0000,1776,7777,0477	;4351				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4352	=					; See "ID1 Q-Logic Next Addresses".
				;4353	
				;4354	PF-OVR-2:	; Turns on at CLR(B) to TST(B), and XOR execution.
				;4355	=10********0	; Prefetch and NAF override for Destination Modes 04-05.
U 2254, 0137,1701,3440,4004	;4356	PLA0	[^0 111 0X1, ^X XXX 10X XXX 000 10X]
				;4357			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2255, 0000,1776,7777,0477	;4358				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4359	=					; See "ID1 Q-Logic Next Addresses".
				;4360	
				;4361	PF-OVR-3:	; Turns on at CLR(B) to TST(B), and XOR execution.
				;4362	=10********0	; Prefetch and NAF override for Destination Mode 06.
U 2256, 0137,1700,3440,4006	;4363	PLA0	[^0 111 0X1, ^X XXX 10X XXX 000 110]
				;4364			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2257, 0000,1776,7777,0477	;4365				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4366	=					; See "ID1 Q-Logic Next Addresses".
				;4367	
				;4368	PF-OVR-4:	; Turns on at SWAB, and ROR(B) to ASL(B) execution.
				;4369	=10********0	; Prefetch and NAF override for Destination Modes 00-03.
U 2260, 0130,6303,3440,0000	;4370	PLA0	[^0 111 0X1, ^X 000 XX0 0XX 000 0XX]
				;4371			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2261, 0000,1776,7777,0477	;4372				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4373	=					; See "ID1 Q-Logic Next Addresses".
				;4374	
				;4375	PF-OVR-5:	; Turns on at SWAB, and ROR(B) to ASL(B) execution.
				;4376	=10********0	; Prefetch and NAF override for Destination Modes 04-05.
U 2262, 0130,6301,3440,0004	;4377	PLA0	[^0 111 0X1, ^X 000 XX0 0XX 000 10X]
				;4378			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2263, 0000,1776,7777,0477	;4379				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4380	=					; See "ID1 Q-Logic Next Addresses".
				;4381	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  105
; BASE  .MCD [242,1110]      SOP Execution

				;4382	PF-OVR-6:	; Turns on at SWAB, and ROR(B) to ASL(B) execution.
				;4383	=10********0	; Prefetch and NAF override for Destination Mode 06.
U 2264, 0130,6300,3440,0006	;4384	PLA0	[^0 111 0X1, ^X 000 XX0 0XX 000 110]
				;4385			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2265, 0000,1776,7777,0477	;4386				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4387	=					; See "ID1 Q-Logic Next Addresses".
				;4388	
				;4389	PF-OVR-7:	; Turns on at SXT, MFPS execution.
				;4390	=10********0	; Prefetch and NAF override for Destination Modes 00-03.
U 2266, 0130,0003,3440,6700	;4391	PLA0	[^0 111 0X1, ^X 000 110 111 000 0XX]
				;4392			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2267, 0000,1776,7777,0477	;4393				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4394	=					; See "ID1 Q-Logic Next Addresses".
				;4395	
				;4396	PF-OVR-8:	; Turns on at SXT, MFPS execution.
				;4397	=10********0	; Prefetch and NAF override for Destination Modes 04-05.
U 2270, 0130,0001,3440,6704	;4398	PLA0	[^0 111 0X1, ^X 000 110 111 000 10X]
				;4399			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2271, 0000,1776,7777,0477	;4400				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4401	=					; See "ID1 Q-Logic Next Addresses".
				;4402	
				;4403	PF-OVR-9:	; Turns on at SXT, MFPS execution.
				;4404	=10********0	; Prefetch and NAF override for Destination Mode 06.
U 2272, 0130,0000,3440,6706	;4405	PLA0	[^0 111 0X1, ^X 000 110 111 000 110]
				;4406			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2273, 0000,1776,7777,0477	;4407				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4408	=					; See "ID1 Q-Logic Next Addresses".
				;4409	
				;4410	;WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;4411	;=10********0
				;4412	;PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
				;4413	;		BYTE --> WORD,		; Force word Read or word Operate.
				;4414	;			NAF/1777	; Do not alter NAF.
				;4415	;=
				;4416	
;4417	.NOBIN
;4418	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  106
; BASE  .MCD [242,1110]      DOP Execution

;4419		.TOC	"				DOP Execution"
;4420	
;4421	;
;4422	; Entry Conditions:
;4423	;
;4424	;	NA = 470 or 472
;4425	;	PIR contains Opcode
;4426	;
;4427	; Exit Conditions:
;4428	;
;4429	;	NAF = ID1 (477)
;4430	;
;4431	; Method:
;4432	;
;4433	;	Each DOP is broken out separately and the corresponding
;4434	;	microinstruction is executed.
;4435	;
;4436	; Do: (if -SM0.-DM0)
;4437	;	DOP.()*	[RF, RE]		; Write to memory and update CC.
;4438	;
;4439	;	NOP.W	[RF, PS],		; Then do separate
;4440	;		PREFETCH,		;  Prefetch
;4441	;			NAF/ID1		;  and Predecode.
;4442	;
;4443	; Do: (if SM0.-DM0)
;4444	;	DOP.()*	[RSRC, RE]		; Write to memory and update CC.
;4445	;
;4446	;	NOP.W	[RF, PS],		; Then do separate
;4447	;		PREFETCH,		;  Prefetch
;4448	;			NAF/ID1		;  and Predecode.
;4449	;
;4450	; Do: (if -SM0.DM0.-PC)
;4451	;	DOP.()*	[RF, RDST],		; Write to register, update CC, and do
;4452	;		PREFETCH,		;  Prefetch
;4453	;			NAF/ID1		;  and Predecode.
;4454	;
;4455	; Do: (if -SM0.DM0.PC)
;4456	;	DOP.()*	[RF, RDST]		; Write to PC and update CC.
;4457	;
;4458	;	NOP.W	[RF, PS],		; Then do separate
;4459	;		PREFETCH,		;  Prefetch
;4460	;			NAF/ID1		;  and Predecode.
;4461	;
;4462	; Do: (if SM0.DM0.-PC)
;4463	;	DOP.()*	[RSRC, RDST],		; Write to register, update CC, and do
;4464	;		PREFETCH,		;  Prefetch
;4465	;			NAF/ID1		;  and Predecode.
;4466	;
;4467	; Do: (if SM0.DM0.PC)
;4468	;	DOP.()*	[RSRC, RDST]		; Write to PC and update CC.
;4469	;
;4470	;	NOP.W	[RF, PS],		; Then do separate
;4471	;		PREFETCH,		;  Prefetch
;4472	;			NAF/ID1		;  and Predecode.
;4473	;; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  107
; BASE  .MCD [242,1110]      DOP Execution

				;4474	.BIN
				;4475	
				;4476	MOV:		; Do MOV(B).
				;4477	=10********0
U 2274, 0130,7777,3401,0000	;4478	PLA0	[^0 111 0X0, ^X 001 XXX XXX XXX XXX]
				;4479		MOV.B*	[RF, RE],		; Override :  RF to RSRC if Source Mode 0,
				;4480						;  RE to RDST if Destination Mode 0,
				;4481						;  BYTE to WORD if word Opcode,
U 2275, 0000,1567,5776,1477	;4482				NAF/NOP-PF	;  NAF to ID1 (477) if Dest. Modes 00-06 (PF-OVR).
				;4483	=
				;4484	MOVS:		; Override for MOVB  SS, Rx.  Must sign-extend to upper byte.
				;4485	=10********0
U 2276, 0120,7707,3411,0000	;4486	PLA0	[^0 111 0X0, ^1 001 XXX XXX 000 XXX]
				;4487		MOVS.W*	[RF, RDST],		; Override :  RF to RSRC if Source Mode 0,
U 2277, 0000,1021,5746,1477	;4488				NAF/NOP-PF	;  NAF to ID1 (477) for Dest. Modes 00-06 (PF-OVR).
				;4489	=
				;4490	CMP:		; Do CMP(B).
				;4491	=10********0
U 2300, 0130,7777,3402,0000	;4492	PLA0	[^0 111 0X0, ^X 010 XXX XXX XXX XXX]
				;4493		CMP.B*	[RF, RE],		; Override :  RF to RSRC if Source Mode 0, and
				;4494						;  RE to RDST if Destination Mode 0,
				;4495						;  BYTE to WORD if word Opcode,
U 2301, 0000,1437,5776,1477	;4496				NAF/NOP-PF	;  NAF to ID1 (477) for Dest. Modes 00-06 (PF-OVR).
				;4497	=
				;4498	BIT:		; Do BIT(B).
				;4499	=10********0
U 2302, 0130,7777,3403,0000	;4500	PLA0	[^0 111 0X0, ^X 011 XXX XXX XXX XXX]
				;4501		BIT.B*	[RF, RE],		; Override :  RF to RSRC if Source Mode 0,
				;4502						;  RE to RDST if Destination Mode 0,
				;4503						;  BYTE to WORD if word Opcode,
U 2303, 0000,1507,5776,1477	;4504				NAF/NOP-PF	;  NAF to ID1 (477) for Dest. Modes 00-06 (PF-OVR).
				;4505	=
				;4506	BIC:		; Do BIC(B).
				;4507	=10********0
U 2304, 0130,7777,3404,0000	;4508	PLA0	[^0 111 0X0, ^X 100 XXX XXX XXX XXX]
				;4509		BIC.B*	[RF, RE],		; Override :  RF to RSRC if Source Mode 0,
				;4510						;  RE to RDST if Destination Mode 0,
				;4511						;  BYTE to WORD if word Opcode,
U 2305, 0000,1557,5776,1477	;4512				NAF/NOP-PF	;  NAF to ID1 (477) if Dest. Modes 00-06 (PF-OVR).
				;4513	=
				;4514	BIS:		; Do BIS(B).
				;4515	=10********0
U 2306, 0130,7777,3405,0000	;4516	PLA0	[^0 111 0X0, ^X 101 XXX XXX XXX XXX]
				;4517		BIS.B*	[RF, RE],		; Override :  RF to RSRC if Source Mode 0,
				;4518						;  RE to RDST if Destination Mode 0,
				;4519						;  BYTE to WORD if word Opcode,
U 2307, 0000,1577,5776,1477	;4520				NAF/NOP-PF	;  NAF to ID1 (477) if Dest. Modes 00-06 (PF-OVR).
				;4521	=
				;4522	ADD:		; Do ADD.
				;4523	=10********0
U 2310, 0120,7777,3406,0000	;4524	PLA0	[^0 111 0X0, ^0 110 XXX XXX XXX XXX]
				;4525		ADD.W*	[RF, RE],		; Override :  RF to RSRC if Source Mode 0,
				;4526						;  RE to RDST if Destination Mode 0,
U 2311, 0000,1441,5776,1477	;4527				NAF/NOP-PF	;  NAF to ID1 (477) if Dest. Modes 00-06 (PF-OVR).
				;4528	=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  108
; BASE  .MCD [242,1110]      DOP Execution

				;4529	SUB:		; Do SUB.
				;4530	=10********0
U 2312, 0120,7777,3416,0000	;4531	PLA0	[^0 111 0X0, ^1 110 XXX XXX XXX XXX]
				;4532		SUB.W*	[RF, RE],		; Override :  RF to RSRC if Source Mode 0,
				;4533						;  RE to RDST if Destination Mode 0,
U 2313, 0000,1411,5776,1477	;4534				NAF/NOP-PF	;  NAF to ID1 (477) if Dest. Modes 00-06 (PF-OVR).
				;4535	=
				;4536	;1477:					; Must be overridable to ID1 (477).
				;4537	;NOP-PF:				;  Must also abort to ROM[40].
				;4538	;	NOP.W	[RF, PS],		; Do nothing, but allow Predecode to write
				;4539	;					;  IR on A-bus<31:16> from Prefetch Buffer.
				;4540	;		PREFETCH,		; Initiate a Prefetch request cycle now
				;4541	;					;  that all other bus cycles are completed.
				;4542	;			NAF/ID1		; Initiate Predecode.  See "ID1 Q-Logic Next
				;4543	;					;  Addresses" for possible NAs.
				;4544	
				;4545	DOP-SM0:	; Turns on at DOP execution.
				;4546	=10********0	; Register select override for Source Mode 0.
U 2314, 0137,0777,3400,0000	;4547	PLA0	[^0 111 0X0, ^X XXX 000 XXX XXX XXX]
				;4548		NOP.B	[RSRC, RE],		; Override RF to RSRC (PDP11 register).
U 2315, 0000,1777,6376,1777	;4549				NAF/1777	; Do not affect NAF.
				;4550	=
				;4551	DOP-DM0:	; Turns on at DOP execution.
				;4552	=10********0	; Register select and NAF override for Destination Mode 0.
U 2316, 0137,7707,3400,0000	;4553	PLA0	[^0 111 0X0, ^X XXX XXX XXX 000 XXX]
				;4554		NOP.B	[RF, RDST],		; Override RE to RDST (PDP11 register).
U 2317, 0000,1777,7746,1777	;4555				NAF/1777	; Do not affect NAF.
				;4556	=
				;4557	PF-OVR-10:	; Turns on at DOP execution.
				;4558	=10********0	; Prefetch and NAF override for Destination Modes 00-03.
U 2320, 0137,7703,3400,0000	;4559	PLA0	[^0 111 0X0, ^X XXX XXX XXX 000 0XX]
				;4560			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2321, 0000,1776,7777,0477	;4561				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4562	=					; See "ID1 Q-Logic Next Addresses".
				;4563	
				;4564	PF-OVR-11:	; Turns on at DOP execution.
				;4565	=10********0	; Prefetch and NAF override for Destination Modes 04 and 05.
U 2322, 0137,7701,3400,0004	;4566	PLA0	[^0 111 0X0, ^X XXX XXX XXX 000 10X]
				;4567			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2323, 0000,1776,7777,0477	;4568				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4569	=					; See "ID1 Q-Logic Next Addresses".
				;4570	
				;4571	PF-OVR-12:	; Turns on at DOP execution.
				;4572	=10********0	; Prefetch and NAF override for Destination Mode 06.
U 2324, 0137,7700,3400,0006	;4573	PLA0	[^0 111 0X0, ^X XXX XXX XXX 000 110]
				;4574			PREFETCH,		; Do Prefetch now as no bus cycle in progress.
U 2325, 0000,1776,7777,0477	;4575				NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4576	=					; See "ID1 Q-Logic Next Addresses".
				;4577	
				;4578	;WRD-OVR-5:	; Detect Word SOPs or DOPs, EIS instructions, and CSM.
				;4579	;=10********0
				;4580	;PLA0	[^X 111 0XX, ^0 XXX XXX XXX XXX XXX]	; See NOTE 4.
				;4581	;		BYTE --> WORD,		; Force word Read or word Operate.
				;4582	;			NAF/1777	; Do not alter NAF.
				;4583	;=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  109
; BASE  .MCD [242,1110]      DOP Execution

				;4584	
;4585	.NOBIN
;4586	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  110
; BASE  .MCD [242,1110]      MTPS

;4587		.TOC	"			MTPS"
;4588	
;4589	;
;4590	; MTPS:
;4591	;
;4592	;	Treated as SOP by Q-Logic.
;4593	;	Source Operand (SRC) specified as Destination Mode.
;4594	;
;4595	; If Kernel Mode:
;4596	;
;4597	;	PS<7:5,3:0>	<-- SRC<7:5,3:0>.
;4598	;
;4599	; If not Kernel Mode:
;4600	;
;4601	;	PS<3:0>		<-- SRC<3:0>.
;4602	;
;4603	
				;4604	.BIN
				;4605	
				;4606	MTPS:		; Do MTPS.
				;4607	=10********0
U 2326, 0120,0077,3450,6400	;4608	PLA0	[^0 111 0X1, ^1 000 110 100 XXX XXX]
U 2327, 0000,1567,7704,0047	;4609		MOV.B	[RE, RE+]		; --> MOV.B  [RDST, RE+] for Mode 0.
				;4610	=
				;4611	;SOP-DM0:	; Turns on at SOP execution.
				;4612	;=10********0	; Register select and NAF override for Mode 0.
				;4613	;PLA0	[^0 111 0X1, ^X XXX XXX XXX 000 XXX]
				;4614	;	RE_RE --> RDST_RDST,		; Override RE to RDST (PDP11 register).
				;4615	;			NAF/1777	; Do not affect NAF.
				;4616	;=
				;4617	=**0*1*****				; Must abort to ROM[40] for Mode not 0.
U 0047, 0000,0164,6077,1137	;4618		JKM	[MTPS-KM]		; Separate Kernel from other modes.
				;4619	=
U 1137, 0000,1547,6036,1140	;4620		XOR.B	[PS, RE]		; Set bits in RE which don't match PS.
				;4621	
				;4622		LAND.B	[017, RE],		; Not Kernel Mode, force RE<7:4> to indicate match.
U 1140, 0000,0516,0776,1142	;4623				NAF/MTPS1	; Join common code.
				;4624	MTPS-KM:
U 1141, 0000,0517,6776,1142	;4625		LAND.B	[357, RE]		; For Kernel Mode, force RE<4> to indicate match.
				;4626	MTPS1:
U 1142, 0000,1547,7700,0011	;4627		XOR.B	[RE, PS]		; Now toggle those bits which didn't
				;4628						;  match and were not masked out.
				;4629	
				;4630	=0*					; Must not be overridden for SPL.
				;4631	PSW-LD-PF:
				;4632		OUTS	[PSW, PS],		; Update new Control chip PS<7:5>
U 0011, 0000,0271,3740,1235	;4633				NAF/RESET-NOP	;  to arbitrate interrupt priority.
				;4634	=
				;4635	;RESET-NOP:				; For MTPS and SPL, wait for Control chip.
				;4636	;	LMSTK	[NOP-PF, RF],		; Set up return address from RESET-SUB.
				;4637	;			NAF/NOP-PF	; For not Kernel Mode, treat as NOP.
				;4638	
;4639	.NOBIN
;4640	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  111
; BASE  .MCD [242,1110]      MFPI and MFPD

;4641		.TOC	"			MFPI and MFPD"
;4642	
;4643	;
;4644	;	-(SP)	<-- SRC from previous mode.
;4645	;
;4646	;	Treated as SOP by Q-Logic.
;4647	;	Source Operand (SRC) specified as Destination Mode.
;4648	;
;4649	; MFPI not Mode 0:
;4650	;	Final address relocation is done using the I-Space PARs and PDRs
;4651	;	selected by PS<13:12>.
;4652	;
;4653	; MFPD not Mode 0:
;4654	;	Final address relocation is done using the D-Space PARs and PDRs
;4655	;	selected by PS<13:12>.
;4656	;
;4657	; Mode 0:
;4658	;	Mode 0 is handled here by using MOVPM which is the same as
;4659	;	a MOV except that it selects the SP specified by PS<13:12> if
;4660	;	RDST resolves to R6.
;4661	;
				;4662	.BIN
				;4663	
				;4664	;SOP-DM0:	; Turns on at SOP execution.
				;4665	;=10********0	; Register select and NAF override for Mode 0.
				;4666	;PLA0	[^0 111 0X1, ^X XXX XXX XXX 000 XXX]
				;4667	;	RE_RE --> RDST_RDST,		; Override RE to RDST (PDP11 register).
				;4668	;			NAF/1777	; Do not affect NAF.
				;4669	;=
				;4670	MFPI-MFPD:	; Breakout MFPI and MFPD.
				;4671	=10********0
U 2330, 0130,0077,3440,6500	;4672	PLA0	[^0 111 0X1, ^X 000 110 101 XXX XXX]
U 2331, 0000,1121,7704,0052	;4673		MOVPM.W	[RE, RE+]		; <-- MOVPM.W [RDST, RE+] for Mode 0;
				;4674	=					;  otherwise same as MOV.W [RE, RE+].
				;4675	
				;4676	=**0*1*****				; Must abort to ROM[40] for Mode not 0.
				;4677		ARD.W	[SP],			; Decrement the SP by two and
				;4678			LD MMR1,		;  save in MMR1 in case of abort
U 0052, 0000,0710,7566,1143	;4679			NO ABORTS		;  next cycle.
				;4680	=
				;4681		AW	[SP],			; Now relocate for real and
				;4682			ODD TRAP,		;  check for an odd address
U 1143, 0000,0771,6366,1144	;4683			SOVFF			;  or Yellow Stack violation.
				;4684	
				;4685		MOV.W*	[RE, RE],		; Finish write, then go Prefetch and Predecode.
U 1144, 0000,1561,5736,1477	;4686				NAF/NOP-PF	; NOP-PF aborts to ROM[40] as required.
				;4687	
;4688	.NOBIN
;4689	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  112
; BASE  .MCD [242,1110]      MTPI and MTPD

;4690		.TOC	"			MTPI and MTPD"
;4691	
;4692	;
;4693	;	DST in previous mode <-- (SP)+
;4694	;
;4695	;	Not treated as SOP or DOP by Q-Logic but invokes "Destination Mode Decode" as DOP.
;4696	;
;4697	; MTPI not Mode 0:
;4698	;	Final address relocation is done using the I-Space PARs and PDRs
;4699	;	selected by PS<13:12>.
;4700	;
;4701	; MTPD not Mode 0:
;4702	;	Final address relocation is done using the D-Space PARs and PDRs
;4703	;	selected by PS<13:12>.
;4704	;
;4705	; Mode 0:
;4706	;	Mode 0 is handled here by using MOVPM which is the same as
;4707	;	a MOV except that it selects the SP specified by PS<13:12> if
;4708	;	RDST resolves to R6.
;4709	;
;4710	
				;4711	.BIN
				;4712	
				;4713	MTPI-MTPD:	; Breakout MTPI and MTPD at 477.
				;4714	=10********0
U 2332, 0030,0077,3740,6600	;4715	PLA0	[^0 111 111, ^X 000 110 110 XXX XXX]
				;4716		ARI.W	[SP],			; Relocate SP in current space a increment by two.
				;4717			LD MMR1,		; Save amount in MMR1 in case of abort.
U 2333, 0000,0700,7366,1145	;4718			ODD TRAP		; Check for an odd address.
				;4719	=
				;4720		RD.W	[RF],			; Pop the stack to RF.
U 1145, 0000,0321,7777,0474	;4721				NAF/ID2		; Invoke "Destination Mode Decode".
				;4722						; Return to 470 for Mode 0 or 473 otherwise.
				;4723	
				;4724	;DOP-DM0:	; Turns on at DOP execution.
				;4725	;=10********0	; Register select and NAF override for Destination Mode 0.
				;4726	;PLA0	[^0 111 0X0, ^X XXX XXX XXX 000 XXX]
				;4727	;	NOP.B	[RF, RDST],		; Override RE to RDST (PDP11 register).
				;4728	;			NAF/1777	; Do not affect NAF.
				;4729	;=
				;4730	MTPI-MTPD2:	; Get here after addressing or directly if Mode 0.
				;4731	=10********0
U 2334, 0170,0077,3400,6600	;4732	PLA0	[^0 111 0XX, ^X 000 110 110 XXX XXX]
				;4733		MOVPM.W* [RF, RE],		; <-- MOVPM.W* [RF, RDST] if Mode 0;
				;4734						;  otherwise same as MOV.W* [RF, RE].
				;4735						; Finish bus write if not Mode 0;
				;4736						;  otherwise simply move to PDP11 register.
U 2335, 0000,1121,5776,1477	;4737				NAF/NOP-PF	; Turn on Prefetch and override to
				;4738	=					;  ID1 for Modes 00 - 06 (PF-OVR).
				;4739	
				;4740	;PF-OVR-10:	; Turns on at DOP execution.
				;4741	;=10********0	; Prefetch and NAF override for Destination Modes 00-03.
				;4742	;PLA0	[^0 111 0X0, ^X XXX XXX XXX 000 0XX]
				;4743	;		PREFETCH,		; Do Prefetch now as no bus cycle in progress.
				;4744	;			NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  113
; BASE  .MCD [242,1110]      MTPI and MTPD

				;4745	;=					; See "ID1 Q-Logic Next Addresses".
				;4746	;
				;4747	;PF-OVR-11:	; Turns on at DOP execution.
				;4748	;=10********0	; Prefetch and NAF override for Destination Modes 04 and 05.
				;4749	;PLA0	[^0 111 0X0, ^X XXX XXX XXX 000 10X]
				;4750	;		PREFETCH,		; Do Prefetch now as no bus cycle in progress.
				;4751	;			NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4752	;=					; See "ID1 Q-Logic Next Addresses".
				;4753	;
				;4754	;PF-OVR-12:	; Turns on at DOP execution.
				;4755	;=10********0	; Prefetch and NAF override for Destination Mode 06.
				;4756	;PLA0	[^0 111 0X0, ^X XXX XXX XXX 000 110]
				;4757	;		PREFETCH,		; Do Prefetch now as no bus cycle in progress.
				;4758	;			NAF/ID1		; Override NOP-PF NAF to ID1 (477). Predecode.
				;4759	;=					; See "ID1 Q-Logic Next Addresses".
				;4760	;
				;4761	;1477:					; Must be overridable to ID1 (477).
				;4762	;NOP-PF:				;  Must also abort to ROM[40].
				;4763	;	NOP.W	[RF, PS],		; Do nothing, but allow Predecode to write
				;4764	;					;  IR on A-bus<31:16> from Prefetch Buffer.
				;4765	;		PREFETCH,		; Initiate a Prefetch request cycle now
				;4766	;					;  that all other bus cycles are completed.
				;4767	;			NAF/ID1		; Initiate Predecode.  See "ID1 Q-Logic Next
				;4768	;					;  Addresses" for possible NAs.
				;4769	
;4770	.NOBIN
;4771	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  114
; BASE  .MCD [242,1110]      TSTSET and WRTLCK

;4772		.TOC	"			TSTSET and WRTLCK"
;4773	
;4774	;
;4775	; TSTSET:
;4776	;
;4777	;	Read/lock destination word and store in R0.
;4778	;	Write/unlock R0 OR 1 into destination.
;4779	;
;4780	;	N <-- R0 LSS 0;
;4781	;	Z <-- R0 EQL 0;
;4782	;	V <-- 0;
;4783	;	C <-- R0<0>
;4784	;
;4785	;	Trap to 10 if Mode 0.
;4786	;
;4787	; WRTLCK:
;4788	;
;4789	;	Read/lock destination.
;4790	;	Write/unlock R0 into destination.
;4791	;
;4792	;	N <-- R0 LSS 0;
;4793	;	Z <-- R0 EQL 0;
;4794	;	V <-- 0;
;4795	;	C <-- unchanged
;4796	;
;4797	;	Trap to 10 if Mode 0.
;4798	;
;4799	
				;4800	.BIN
				;4801	
				;4802	TSTSET-WRTLCK:	; Breakout TSTSET and WRTLCK at ID1.
				;4803	=10********0
U 2336, 0020,0177,3740,7200	;4804	PLA0	[^0 111 111, ^0 000 111 01X XXX XXX]
				;4805		LLD.W	[001, RF],		; Used for TSTSET only.
U 2337, 0000,0560,0077,0475	;4806				NAF/475		; Enter "Destination Decode" as SOP.
				;4807	=					; Mode 0 will not respond (except for WRD-OVRs).
				;4808	
				;4809	;1777:					; NAF out of PLA was all ones.
				;4810	;	LLD.L	[010, RA],		; Load trap vector to scratch.
				;4811	;			NAF/M-TRAP	; Join trap code at "Micro Trap".
				;4812	
				;4813	LOCKED2:	; Read locked override for TSTSET and WRTLCK.
				;4814	=10********0
U 2340, 0020,0177,7540,7200	;4815	PLA0	[^1 111 011, ^0 000 111 01X XXX XXX]
				;4816			READ LOCKED,		; Multiprocessor hook.  Lock memory.
U 2341, 0000,1776,7777,1777	;4817				NAF/1777	; Do not alter NAF.
				;4818	=
				;4819	TSTSET:		; Breakout TSTSET only at ID3.
				;4820	=10********0
U 2342, 0120,0077,3440,7200	;4821	PLA0	[^0 111 0X1, ^0 000 111 010 XXX XXX]
U 2343, 0000,1571,7737,0053	;4822		BIS.W	[RE, RF]		; Write/unlock Destination OR 1.
				;4823	=
				;4824	=0*1*****				; Must abort to ROM[40] for read.
U 0053, 0000,1341,5737,0056	;4825		ASR.W*	[RE, RF]		; Set C from Destination<0>.
				;4826	=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  115
; BASE  .MCD [242,1110]      TSTSET and WRTLCK

				;4827	=0*1*****				; Must abort to ROM[40] for write-back.
				;4828		MOV.W*	[RE, R0],		; Update N, Z, and V; leave C alone.
				;4829			PREFETCH,		; Fetch future I-Stream word.
U 0056, 0000,1560,5720,0477	;4830				NAF/ID1		; Do it.  Decode current instruction.
				;4831	=
				;4832	WRTLCK:		; Breakout WRTLCK only at ID3.
				;4833	=10********0
U 2344, 0120,0077,3440,7300	;4834	PLA0	[^0 111 0X1, ^0 000 111 011 XXX XXX]
				;4835		MOV.W*	[R0, RE],		; Write R0 to Destination.
U 2345, 0000,1561,5036,1477	;4836				NAF/NOP-PF	; Wait for bus cycle then go do it.
				;4837	=
				;4838	
;4839	.NOBIN
;4840	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  116
; BASE  .MCD [242,1110]      CSM

;4841		.TOC	"			CSM"
;4842	
;4843	;
;4844	;	Treated as SOP by Q-Logic.
;4845	;	Source Operand (SRC) specified as Destination Mode.
;4846	;
;4847	; If MMR3<3>=1  AND  PS<15:14><>00 then
;4848	;
;4849	;	Begin
;4850	;
;4851	;	Supervisor SP	<-- Current Mode SP;
;4852	;	Temp<15:4>	<-- PS<15:4>;
;4853	;	Temp<3:0>	<-- 0;
;4854	;	PS<13:12>	<-- PS<15:14>;
;4855	;	PS<15:14>	<-- 01;
;4856	;	PS<4>		<-- 0;
;4857	;	-(SP)		<-- Temp;
;4858	;	-(SP)		<-- PC;
;4859	;	-(SP)		<-- SRC;
;4860	;	PC		<-- (10), Supervisor I-space;
;4861	;
;4862	;	End
;4863	;
;4864	; Else vector through 10 in Kernel Mode.
;4865	;
;4866	
				;4867	.BIN
				;4868	
				;4869	;SOP-DM0:	; Turns on at SOP execution.
				;4870	;=10********0	; Register select and NAF override for Mode 0.
				;4871	;PLA0	[^0 111 0X1, ^X XXX XXX XXX 000 XXX]
				;4872	;	RE_RE --> RDST_RDST,		; Override RE to RDST (PDP11 register).
				;4873	;			NAF/1777	; Do not affect NAF.
				;4874	;=
				;4875	CSM:		; Breakout CSM.
				;4876	=10********0
U 2346, 0120,0077,3440,7000	;4877	PLA0	[^0 111 0X1, ^0 000 111 000 XXX XXX]
U 2347, 0000,1561,7704,0061	;4878		MOV.W	[RE, RE+]		; Move RE/RDST to RE.
				;4879	=
				;4880	=**0*1*****				; Must abort to ROM[40] for mode not 0.
U 0061, 0000,0211,0132,1146	;4881		INPR.W	[MMR3, RA]		; Get MMR3 from MMUR.
				;4882	=
U 1146, 0000,1461,6033,1147	;4883		SWAB.W	[PS, RB]		; Get Current Mode info down to Literal land.
				;4884	
U 1147, 0000,1467,7572,1150	;4885		SWAB.B	[RB, RA]		; Move Current Mode up for simultaneous
				;4886						;  decode of MMR3<3> and mode.
				;4887	
U 1150, 0000,0271,6772,1151	;4888		OUTS	[LD_PIR, RA]		; Stuff it into PIR.
				;4889	
				;4890		LBIS.B	[360, RB],		; Preset Current and Previous Modes to all 1's.
U 1151, 0000,0577,7033,0432	;4891				NAF/P.CSM	; Invoke PLA to check Current Mode and MMR3.
				;4892	
				;4893	=10********0	; Check for not Kernel and MMR3<3>=1.
U 2350, 0027,7767,1510,0010	;4894	NPLA0	[P.CSM, ^1XXXXXXX XXXX1XXX]
				;4895		LBIC.B	[220, RB],		; Set Current Mode to 01.  Set Previous Mode
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  117
; BASE  .MCD [242,1110]      CSM

U 2351, 0000,0557,1033,1152	;4896				NAF/CSM3	;  to 10 only if other PLA doesn't turn on.
				;4897	=
				;4898	=10********0	; Check for not Kernel and MMR3<3>=1.
U 2352, 0033,7767,1504,0010	;4899	NPLA0	[P.CSM, ^X1XXXXXX XXXX1XXX]
				;4900		LBIC.B	[240, RB],		; Set Current Mode to 01.  Set Previous Mode
U 2353, 0000,0557,2033,1152	;4901				NAF/CSM3	;  to 01 only if other PLA doesn't turn on.
				;4902	=
				;4903				; Both PLAs turn on for User Mode (LBIC.B  [200, RB]).
				;4904				; If neither PLA turns on, treat as illegal instruction at 1777.
				;4905	CSM3:
U 1152, 0000,1561,6037,1153	;4906		MOV.W	[PS, RF]		; Before changing modes, save the old PS.
				;4907	
U 1153, 0000,0550,0757,1154	;4908		LBIC.W	[017, RF.H]		; Create Temp in RF.H, leave RF.L alone for abort.
				;4909	
U 1154, 0000,1561,7334,1155	;4910		MOV.W	[SP, RC]		; Save old SP as new Supervisor SP.
				;4911	
U 1155, 0000,1467,7540,1156	;4912		SWAB.B	[RB, PS]		; Switch context to Supervisor Mode.
				;4913	
U 1156, 0000,0530,0432,1157	;4914		LMSTK	[CSM-ABORT, RA]		; LLD.W	[010, RA].
				;4915						; Set abort return for clean MMU.
				;4916						; Load EU register with new PC address.
				;4917						; Wait for PS to settle.
				;4918	
				;4919		ARD.W	[RC],			; Decrement SP by two.
U 1157, 0000,0711,7574,1160	;4920			NO ABORTS		; Get the aborts next time.
				;4921	
				;4922		AWD.W	[RC],			; Decrement SP by two.
U 1160, 0000,0751,7374,1161	;4923			ODD TRAP		; Must be a word address.
				;4924	
U 1161, 0000,1561,6773,1162	;4925		MOV.W	[RF.H, RB]		; Push Temp onto stack.
				;4926	
U 1162, 0000,0751,7774,0244	;4927		AWD.W	[RC]			; Decrement SP by two.
				;4928	
				;4929	=1*1*****				; Abort to ROM[240] where RFS is.
U 0244, 0000,1561,7373,1163	;4930		MOV.W	[PC, RB]		; Push PC onto stack.
				;4931	=
U 1163, 0000,0771,7774,0245	;4932		AW	[RC]			; Relocate SP for final push.
				;4933	
				;4934	=1*1*****				; Abort to ROM[240] where RFS is.
U 0245, 0000,1561,7736,1164	;4935		MOV.W	[RE, RE]		; Push SRC onto stack.
				;4936	=
				;4937	
				;4938		AR	[RA],			; Relocate PC address in Supervisor
U 1164, 0000,0731,7632,0246	;4939			I SPACE			;  I Space.
				;4940	
				;4941	=1*1*****				; Abort to ROM[240] where RFS is.
U 0246, 0000,0321,7767,1165	;4942		RD.W	[PC]			; Read new PC.  MMR2 has old PC if abort.
				;4943	=
U 1165, 0000,0556,1000,0247	;4944		LBIC.B	[020, PS]		; Clear T-bit now that no aborts occured.
				;4945	
				;4946	=1*1*****				; Abort to ROM[240] where RFS is.
				;4947		MOV.W	[RC, SP],		; Finally, update the new SP.
U 0247, 0000,1561,7626,0107	;4948				NAF/PSW-LOAD	; Update new Control chip PS<4>.
				;4949	=
				;4950	;=0*0*****				; Abort to ROM[0] for M-TRAP.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  118
; BASE  .MCD [242,1110]      CSM

				;4951	;PSW-LOAD:
				;4952	;	OUTS	[PSW, PS]		; Update new Control chip PS<7:4> to
				;4953	;=					;  arbitrate interrupt priority and Trace Trap.
				;4954	;
				;4955	;=0*0*****				; Abort to ROM[0] for "Power Up".
				;4956	;PSW-LOAD1:				; Clear SSFF for POWER-UP and ODT "G".
				;4957	;	OUTC	[CPY_TBIT-CLR_SSFF],	; Copy ITFF from PS<4>.
				;4958	;			NAF/RE-SYNC	; Wait for Interrupt Blocking Logic
				;4959	;=					;  before ckecking interrupts at IRDF.
				;4960	
				;4961	10:					; Set literal for LMSTK above.
				;4962	CSM-ABORT:				; Get here if abort occured.
				;4963		MOV.W	[RF, PS],		; Restore the PS to original state.
U 0010, 0000,1561,7740,0040	;4964				NAF/40		; Now service abort in usual manner.
				;4965	
				;4966	;1777:					; NAF out of PLA was all ones.
				;4967	;	LLD.L	[010, RA],		; Load trap vector to scratch.
				;4968	;			NAF/M-TRAP	; Join trap code at "Micro Trap".
				;4969	
;4970	.NOBIN
;4971	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  119
; BASE  .MCD [242,1110]      EIS - Extended Instruction Set

;4972		.TOC	"			EIS - Extended Instruction Set"
;4973	
;4974		.TOC	"				MUL - Multiply"
;4975	;
;4976	; MUL:
;4977	;
;4978	;	Treated as SOP by Q-Logic.
;4979	;	Source Operand (SRC) specified as Destination Mode.
;4980	;
;4981	;	RSRC, RSRC+1 <-- RSRC * SRC
;4982	;
;4983	;	The 16-bit two's complement integers in RSRC and SRC are multiplied.
;4984	;	The 32-bit result is left in RSRC and RSRC+1.  Note that if RSRC is
;4985	;	an odd register, only the low order product is stored.
;4986	;
;4987	; Entry Conditions:
;4988	;
;4989	;	RE contains Source Operand (Mode 0 handled here).
;4990	;	PIR contains Opcode.
;4991	;
;4992	; Exit Conditions:
;4993	;
;4994	;	NAF = ID1 (477).
;4995	;
;4996	; Method:
;4997	;
;4998	;	The Source Operand (Multiplier) is loaded into the SR and tested.  RSRC,
;4999	;	the Multiplicand, is loaded into RE<31:16>; RE<15:0> is cleared.  The
;5000	;	Partial Product in RSRC+1 is (effectively) cleared while the CNTR is
;5001	;	loaded simultaneously.  The SMULS microinstruction is used in conjuction
;5002	;	with the Control chip CNTR to calculate the result.  A correction step
;5003	;	is needed if the Multiplier was negative.  MTST sets the Condition Codes
;5004	;	and the high order 16-bit result is store if RSRC is an even register.
;5005	;
;5006	
				;5007	.BIN
				;5008	
				;5009	;SOP-DM0:	; Turns on at SOP execution.
				;5010	;=10********0	; Register select and NAF override for Mode 0.
				;5011	;PLA0	[^0 111 0X1, ^X XXX XXX XXX 000 XXX]
				;5012	;	RE_RE --> RDST_RDST,		; Override RE to RDST (PDP11 register).
				;5013	;			NAF/1777	; Do not affect NAF.
				;5014	;=
				;5015	MUL:		; Do MUL.
				;5016	=10********0
U 2354, 0120,0777,3447,0000	;5017	PLA0	[^0 111 0X1, ^0 111 000 XXX XXX XXX]	; Any mode.
U 2355, 0000,0251,0336,0064	;5018		OUTR.W	[SR, RE]		; Load SR, but test for negative Multiplier.
				;5019	=					; <-- OUTR.W [SR, RDST] for Mode 0.
				;5020	
				;5021	=**0*1*****				; Must abort to ROM[40] for mode not 0.
U 0064, 0000,0174,7437,1166	;5022		JAN	[NEG-MUL]		; Do a separate loop and correction
				;5023	=					;  step if multiplier negative.
				;5024	
				;5025		MOV.L	[RSRC, RE.H],		; RE<31:16> <-- Multiplicand.  RE<15:0> <-- 0.
U 1166, 0000,1563,6356,1167	;5026				NAF/POS-MUL	; Go to NEG-MUL if Multiplier negative.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  120
; BASE  .MCD [242,1110]      MUL - Multiply

				;5027	POS-MUL:
				;5028		LCNTR.L	[020, RSRC+1],		; CNTR <-- 16. for 16-bit multiply.
				;5029						; IR, RSRC+1<15:0> is Partial Product.
U 1167, 0000,0522,1003,0075	;5030				NAF/P-MUL	; Do loop.  Initial 20 in RSRC+1 is shifted out.
				;5031	
				;5032	=0					; Constrain NAF for CNTR loop.
				;5033	MUL2:
				;5034		MTST*	[RF, RSRC+1],		; Special CC update for MUL.  Tests A-port.
U 0074, 0000,1673,5743,0402	;5035				NAF/P.MUL	; Invoke PLA check for even register.
				;5036	P-MUL:
				;5037		SMULS.L	[RE, RSRC+1],		; If SR<0> = 1, add Multiplicand to Partial Product.
				;5038			DECR CNTR,		;  Shift Product (IR,RSRC+1<15:0>) right regardless.
U 0075, 0000,1143,3703,0075	;5039				NAF/P-MUL	; Loop on this till done, then go to MUL2.
				;5040	=
				;5041	NEG-MUL:
				;5042		LCNTR.L	[020, RSRC+1],		; CNTR <-- 16. for 16-bit multiply.
				;5043						; IR, RSRC+1<15:0> is Partial Product.
U 1170, 0000,0522,1003,0121	;5044				NAF/N-MUL	; Do loop.  Initial 20 in RSRC+1 is shifted out.
				;5045	
				;5046	=0					; Constrain NAF for CNTR loop.
				;5047		SUB.L	[RE, RSRC+1],		; Correct Product by subtracting Multiplicand.
U 0120, 0000,1413,7703,0074	;5048				NAF/MUL2	; Join common MTST code.
				;5049	N-MUL:
				;5050		SMULS.L	[RE, RSRC+1],		; If SR<0> = 1, add Multiplicand to Partial Product.
				;5051			DECR CNTR,		;  Shift Product (IR,RSRC+1<15:0>) right regardless.
U 0121, 0000,1143,3703,0121	;5052				NAF/N-MUL	; Loop on this till done, then do correction.
				;5053	=
				;5054	=10********0	; RSRC even.  Store Product<31:16> in RSRC.
U 2356, 0037,7677,0100,0000	;5055	NPLA0	[P.MUL, ^X XXX XXX XX0 XXX XXX]
				;5056		MOV.W	[IRFE, RSRC],		; RSRC <-- Product<31:16>.
				;5057			PREFETCH,		; PPCV already 0 if RSRC+1 = PC.
U 2357, 0000,1560,6047,0477	;5058				NAF/ID1		; Predecode next instruction.
				;5059	=
				;5060	=10********0	; RSRC odd.  RSRC+1 already correct.
U 2360, 0037,7677,0100,0100	;5061	NPLA0	[P.MUL, ^X XXX XXX XX1 XXX XXX]
				;5062		NOP.W	[RF, PS],		; Nothing to do.
				;5063			PREFETCH,		; PPCV already 0 if RSRC+1 = PC.
U 2361, 0000,1770,7740,0477	;5064				NAF/ID1		; Predecode next instruction.
				;5065	=
				;5066	
;5067	.NOBIN
;5068	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  121
; BASE  .MCD [242,1110]      DIV - Divide

;5069		.TOC	"				DIV - Divide"
;5070	
;5071	;
;5072	; DIV:
;5073	;
;5074	;	Treated as SOP by Q-Logic.
;5075	;	Source Operand (SRC) specified as Destination Mode.
;5076	;
;5077	;	RSRC, RSRC+1 <-- RSRC, RSRC+1 / SRC
;5078	;
;5079	;	The 32-bit two's complement integer in RSRC and RSRC+1 is divided by the
;5080	;	Source Operand (SRC).  The Quotient is left in RSRC; the Remainder in RSRC+1.
;5081	;	Division is performed so that the Remainder is of the same sign as the
;5082	;	Dividend.  RSRC must be an even register.
;5083	;
;5084	; Entry Conditions:
;5085	;
;5086	;	RE contains Source Operand (Mode 0 handled here).
;5087	;	PIR contains Opcode.
;5088	;
;5089	; Exit Conditions:
;5090	;
;5091	;	NAF = ID1 (477).
;5092	;
;5093	; Method:
;5094	;
;5095	;	A non-restoring divide algorithm is used.  Non-restoring divide uses
;5096	;	the fact that:
;5097	;
;5098	;	2 * (Partial Remainder - Divisor + Divisor) - Divisor = 2 * (Partial Remainder - Divisor) + Divisor
;5099	;
;5100	;	That is, after a failed attempt at division (- Divisor), instead of restoring
;5101	;	the Partial Remainder by adding the Divisor back in (+ Divisor), the non-restored
;5102	;	Partial Remainder is rotated and division is tried again by adding the Divisor.
;5103	;
;5104	;   1)	The Divisor in RDST or RE is first tested for zero.  If it is zero, both
;5105	;	C and V are set and the instruction is terminated.
;5106	;   2)	The absolute value of the Divisor is stored in RA<31:16> with RA<15:0>
;5107	;	being cleared.  The Dividend in RSRC and RSRC+1 is loaded into RC, the
;5108	;	absolute value is taken and loaded into RF.
;5109	;   3)	The CNTR is loaded for 17. iterations and SR<15:0> is cleared.  The DIVS
;5110	;	microinstruction is executed 17 times using the two absolute values, the
;5111	;	result being stored in the SR.
;5112	;   4)	The final carry out is tested to see if a correction step is needed.  The
;5113	;	Quotient is retrieved from the SR and the remainder is adjusted and
;5114	;	corrected if need be and stored in RF<15:0>.  The original sign of the
;5115	;	Dividend (RSRC<15>) and Divisor are XORed to determine the sign of the
;5116	;	result.  The result is negated if need be and stored in it's final
;5117	;	destination (RSRC).
;5118	;   5)	MTST is used to determine whether an overflow occured.  If it did, V is
;5119	;	set and C is cleared.  Finally, the original sign of the Dividend
;5120	;	determines the sign of the Remainder, it is negated if need be and stored
;5121	;	in it's final destination (RSRC+1).  Prefetch and Predecode is asserted
;5122	;	the same cycle unless R6 and R7 was used.
;5123	;
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  122
; BASE  .MCD [242,1110]      DIV - Divide

				;5124	.BIN
				;5125	
				;5126	;SOP-DM0:	; Turns on at SOP execution.
				;5127	;=10********0	; Register select and NAF override for Mode 0.
				;5128	;PLA0	[^0 111 0X1, ^X XXX XXX XXX 000 XXX]
				;5129	;	RE_RE --> RDST_RDST,		; Override RE to RDST (PDP11 register).
				;5130	;			NAF/1777	; Do not affect NAF.
				;5131	;=
				;5132	DIV-MD-0:	; Start DIV for Mode 0.
				;5133	=10********0
U 2362, 0020,0707,3447,1000	;5134	PLA0	[^0 111 001, ^0 111 001 XXX 000 XXX]
				;5135		MOV.W	[RDST, RE+],		; Save Divisor for Mode 0.  Test for 0.
U 2363, 0000,1561,6304,0473	;5136				NAF/473		; Join code for not Mode 0.
				;5137	=
				;5138	DIV-MD-27:	; Start DIV for Mode 27.
				;5139	=10********0
U 2364, 0020,0700,3447,1027	;5140	PLA0	[^0 111 001, ^0 111 001 XXX 010 111]
				;5141		JAZ	[DIV-ZERO],		; Mode 27 goes to 471 because RO-OVR
U 2365, 0000,0110,2137,0065	;5142				NAF/DIV0	;  and RO-M27-4 both turn on at 475.
				;5143	=
				;5144	DIV:		; Start DIV for not Mode 0, not Mode 27.
				;5145	=10********0
U 2366, 0020,0777,3547,1000	;5146	PLA0	[^0 111 011, ^0 111 001 XXX XXX XXX]
U 2367, 0000,0110,2137,0065	;5147		JAZ	[DIV-ZERO]		; AZ was set from RD, RDI, or Mode 0 MOV.
				;5148	=					; Test for divide by 0.  Beware of WRD-OVR-5.
				;5149	=0*1*****
				;5150	DIV0:					; Must abort to ROM[40] for not Mode 0.
U 0065, 0000,1173,5712,1171	;5151		ANNEG.L* [RE, RA.H]		; RA<31:16> <-- |Divisor|.  RA<15:0> <-- 0.
				;5152	=					; RE<15> has original sign used later.
				;5153						; Set CC = 01XX for DIV-ZERO (11/70 compatible).
				;5154	
U 1171, 0000,1561,6174,1172	;5155		MOV.W	[RSRC+1, RC]		; Pack Dividend into RC.
				;5156	
U 1172, 0000,1561,6354,1173	;5157		MOV.W	[RSRC, RC.H]		; RC<31:0> <-- Dividend<31:0>.
				;5158	
U 1173, 0000,1173,7637,1174	;5159		ANNEG.L	[RC, RF]		; RF <-- |Dividend<31:0>|.
				;5160						; RC<31> has original sign used later.
				;5161	
U 1174, 0000,0522,1053,1175	;5162		LCNTR.L	[021, RB.H]		; CNTR <-- 17.  RB<15:0> <-- 0.
				;5163	
				;5164		OUTR.L	[SR, RB],		; SR<15:0> <-- 0, used by MTST.  AC <-- 0.
U 1175, 0000,0253,0333,0127	;5165				NAF/DIV1	; Skip down to divide loop.
				;5166	
				;5167	=0					; Get here after divide loop.
				;5168		JAC	[FIX-R],		; If Remainder < 0, needs restored.
U 0126, 0000,0135,0037,1176	;5169				NAF/DIV2	; Skip down to DIV2.
				;5170	DIV1:
				;5171		DIVS.L*	[RA, RF],		; Do non-restoring divide for 17. iterations.
				;5172			DECR CNTR,		; Remainder ends up in C'RF<31:17>;
				;5173						;  Quotient in SR<16:0> (includes overflow bit).
U 0127, 0000,1053,1537,0127	;5174				NAF/DIV1	; Loop on this till done, then go back.
				;5175	=
				;5176	DIV2:
U 1176, 0000,0213,0333,1177	;5177		INPR.L	[SR, RB]		; RB <-- |Quotient| and overflow bit.
				;5178						; Go to FIX-R if AC was 1.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  123
; BASE  .MCD [242,1110]      DIV - Divide

				;5179	
				;5180		ROR.L	[RF.H, RF],		; Adjust Remainder after last shift and
				;5181						;  store in RF<15:0> for ANNEG and Predecode.
U 1177, 0000,1243,6777,1202	;5182				NAF/DIV3	; Skip down to common code.
				;5183	FIX-R:
U 1200, 0000,1243,7777,1201	;5184		ROR.L	[RF, RF]		; Adjust Remainder after last shift.
				;5185	
U 1201, 0000,1443,6537,1202	;5186		ADD.L	[RA.H, RF]		; Restore Remainder by adding in Divisor and
				;5187						;  store in RF<15:0> for ANNEG and Predecode.
				;5188	DIV3:
U 1202, 0000,1541,6376,1203	;5189		XOR.W	[RSRC, RE]		; Calculate Quotient sign in AN.
				;5190	
U 1203, 0000,1173,7547,1204	;5191		ANNEG.L	[RB, RSRC]		; Negate Quotient if need be.
				;5192						; Store in final destination.
				;5193	
U 1204, 0000,1673,5747,1205	;5194		MTST*	[RF, RSRC]		; Test 32-bit result for overflow since
				;5195						;  only 16-bits are stored.
				;5196	
				;5197		JAC	[DIV-OVF],		; Jump if Quotient overflow.
U 1205, 0000,0135,0337,0403	;5198				NAF/P.DIV	; Invoke PLA NAF override for R6, R7.
				;5199	
				;5200	=10********0	; Default for R6 and R7 override.
U 2370, 0037,7777,0140,0000	;5201	NPLA0	[P.DIV, ^X]
				;5202		TST.L	[RC, RC],		; Set AN from original Dividend sign.
U 2371, 0000,1663,7634,0157	;5203				NAF/DIV-END-1	; Overridden to DIV-END-0 for R6, R7.
				;5204	=
				;5205	=10********0	; Override NAF for R6 and R7.
U 2372, 0037,7177,0140,0600	;5206	NPLA0	[P.DIV, ^X XXX XXX 11X XXX XXX]
				;5207		TST.L	[RC, RC],		; Set AN from original Dividend sign.
U 2373, 0000,1663,7634,0156	;5208				NAF/DIV-END-0	; Override to DIV-END-0 for R6, R7.
				;5209	=
				;5210	=0					; Align NAFs for NAF override.
				;5211	DIV-END-0:
				;5212		ANNEG.W	[RF, RSRC+1],		; Give Remainder same sign and store.
U 0156, 0000,1171,7743,1477	;5213				NAF/NOP-PF	; Cannot do PREFETCH while writing VPC.
				;5214	DIV-END-1:
				;5215		ANNEG.W	[RF, RSRC+1],		; Give Remainder same sign and store.
				;5216			PREFETCH,		; Do PREFETCH simultaneously.
U 0157, 0000,1170,7743,0477	;5217				NAF/ID1		; Predecode next instruction and all done.
				;5218	=
				;5219	=00***00***				; Neither WRD-OVR-5 nor SOP-DM0 at DIV
				;5220	DIV-ZERO:				;  may override jump address.
				;5221		LBIS.B	[003, PS],		; Set V = 1, C = 1 (i.e. divide by zero).
U 0042, 0000,0576,0140,1477	;5222				NAF/NOP-PF	; Terminate instruction.
				;5223	=
				;5224	DIV-OVF:
U 1206, 0000,1561,6607,1207	;5225		MOV.W	[RC.H, RSRC]		; Restore original operand.
				;5226	
				;5227		LXOR.B	[003, PS],		; MTST* left V=0, C=1.  Complement these.
U 1207, 0000,0546,0140,1477	;5228				NAF/NOP-PF	; All done.  Do NOP, PREFETCH.
				;5229	
;5230	.NOBIN
;5231	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  124
; BASE  .MCD [242,1110]      ASH - Arithmetic Shift

;5232		.TOC	"				ASH - Arithmetic Shift"
;5233	
;5234	;
;5235	; ASH:
;5236	;
;5237	;	Treated as SOP by Q-Logic.
;5238	;	Source Operand specified as Destination Mode.
;5239	;	SRC = Source Operand<5:0>.
;5240	;
;5241	;	RSRC <-- RSRC   Shifted arithmetically NN places to the left (if SRC >= 0 ),
;5242	;			or right (if SRC < 0 ), where NN = |SRC|.
;5243	;
;5244	; Entry Conditions:
;5245	;
;5246	;	RE contains Source Operand (RDST for Mode 0).
;5247	;	PIR contains Opcode.
;5248	;
;5249	; Exit Conditions:
;5250	;
;5251	;	NAF = ID1 (477).
;5252	;
;5253	; Method:
;5254	;
;5255	;	The Source Operand (SRC) is loaded into the PIR to determine the shift count for
;5256	;	right or left shift.  The condition codes are set for a zero shift while waiting
;5257	;	for the PIR.  A LCNTR microinstruction is then dynamically altered to load the
;5258	;	shift count (1's complement for the negative case).  If the count is positive,
;5259	;	a NAF override forces a left shift.  If the count is 0 or -1, NAF overrides
;5260	;	force appropriate action.  In either case, the CNTR is used and finally the
;5261	;	condition codes are set.
;5262	;
;5263	
				;5264	.BIN
				;5265	
				;5266	;SOP-DM0:	; Turns on at SOP execution.
				;5267	;=10********0	; Register select and NAF override for Mode 0.
				;5268	;PLA0	[^0 111 0X1, ^X XXX XXX XXX 000 XXX]
				;5269	;	RE_RE --> RDST_RDST,		; Override RE to RDST (PDP11 register).
				;5270	;			NAF/1777	; Do not affect NAF.
				;5271	;=
				;5272	ASH:		; Do ASH.
				;5273	=10********0
U 2374, 0120,0777,3447,2000	;5274	PLA0	[^0 111 0X1, ^0 111 010 XXX XXX XXX]
U 2375, 0000,0271,6776,0071	;5275		OUTS	[LD_PIR, RE]		; Test for positive(left) or negative(right) shift.
				;5276	=					; <-- OUTS [LD_PIR_MSTK, RDST] for Mode 0.
				;5277	
				;5278	=**0*1*****				; Must abort to ROM[40] for not Mode 0.
				;5279		TST.W*	[RSRC, RSRC],		; In case of no shift, simply update CC.
				;5280						;  C and V are cleared.
U 0071, 0000,1661,4347,0536	;5281				NAF/536		; Invoke PLA to load CNTR and separate cases.
				;5282	=
				;5283	ASH1:		; Default for EXTRX-X, ASHX-0-OVR and ASHX-NEG-1 PLAs.
				;5284	=10********0
U 2376, 0037,7777,5700,0000	;5285	PLA0	[^1 011 110, ^X]
				;5286		LCNTR.W	[037, RE],		; Load CNTR with shift count.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  125
; BASE  .MCD [242,1110]      ASH - Arithmetic Shift

U 2377, 0000,0520,1776,0023	;5287				NAF/ASH-R	; Overridden to NOP-PF1 for no shift or
				;5288	=					;  to ASH-L for positive shift or
				;5289						;  to ASH-R1 for negative 1 shift.
				;5290	
				;5291	ASHX-0-OVR:	; SRC<5:0> = 0.  No shift.
				;5292	=10********0
U 2400, 0437,7700,5300,0000	;5293	PLA0	[^1 01X 110, ^X XXX XXX XXX 000 000]
				;5294		NOP.W	[RF, RF],		; Do not override microinstruction.
U 2401, 0000,1771,7777,0030	;5295				NAF/ASHC-NO	; Override to NOP-PF1 for ASH or
				;5296	=					;  to ASHC-NO for ASHC.
				;5297	
				;5298	EXTR0-0:	; Override on 0 in PIR<5> and PIR<0>.
				;5299	=10********0
U 2402, 0177,7736,5600,0000	;5300	PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX XX0]
				;5301		LBIS.B	[336, RF],		; Override literal<5,0> (SPL, ASHX).
U 2403, 0000,0577,5737,1775	;5302				NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5303	=
				;5304	EXTR0-1:	; Override on 0 in PIR<5> and PIR<1>.
				;5305	=10********0
U 2404, 0177,7735,5600,0000	;5306	PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX X0X]
				;5307		LBIS.B	[275, RF],		; Override literal<6,1> (SPL, ASHX).
U 2405, 0000,0577,3677,1775	;5308				NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5309	=
				;5310	EXTR0-2:	; Override on 0 in PIR<5> and PIR<2>.
				;5311	=10********0
U 2406, 0177,7733,5600,0000	;5312	PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX 0XX]
				;5313		LBIS.B	[173, RF],		; Override literal<7,2> (SPL, ASHX).
U 2407, 0000,0576,7577,1775	;5314				NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5315	=
				;5316	EXTR0-3:	; Override on 0 in PIR<5> and PIR<3>.
				;5317	=10********0
U 2410, 0077,7727,5700,0000	;5318	PLA0	[^1 011 11X, ^X XXX XXX XXX 0X0 XXX]
				;5319		LBIS.B	[367, RF],		; Override literal<3>.
U 2411, 0000,0577,7377,1775	;5320				NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5321	=
				;5322	EXTR0-4:	; Override on 0 in PIR<5> and PIR<4>.
				;5323	=10********0
U 2412, 0077,7717,5700,0000	;5324	PLA0	[^1 011 11X, ^X XXX XXX XXX 00X XXX]
				;5325		LBIS.B	[357, RF],		; Override literal<4>.
U 2413, 0000,0577,6777,1775	;5326				NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5327	=
				;5328	ASHX-NEG-1:	; SRC<5:0> = -1.  One right shift only.
				;5329	=10********0
U 2414, 0437,7700,5300,0077	;5330	PLA0	[^1 01X 110, ^X XXX XXX XXX 111 111]
				;5331		NOP.W	[RF, RF],		; Do not override microinstruction.
U 2415, 0000,1771,7777,0036	;5332				NAF/ASHC-R1	; Override to ASH-R1 or ASHC-R1.
				;5333	=
				;5334	EXTR1-0:	; Override on 1 in PIR<5> and PIR<0>.
				;5335	=10********0
U 2416, 0077,7736,5700,0041	;5336	PLA0	[^1 011 11X, ^X XXX XXX XXX 1XX XX1]
				;5337		LBIS.B	[376, RF],		; Override literal<0>.
U 2417, 0000,0577,7737,1777	;5338				NAF/1777	; Do not override NAF.
				;5339	=
				;5340	EXTR1-1:	; Override on 1 in PIR<5> and PIR<1>.
				;5341	=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  126
; BASE  .MCD [242,1110]      ASH - Arithmetic Shift

U 2420, 0077,7735,5700,0042	;5342	PLA0	[^1 011 11X, ^X XXX XXX XXX 1XX X1X]
				;5343		LBIS.B	[375, RF],		; Override literal<1>.
U 2421, 0000,0577,7677,1777	;5344				NAF/1777	; Do not override NAF.
				;5345	=
				;5346	EXTR1-2:	; Override on 1 in PIR<5> and PIR<2>.
				;5347	=10********0
U 2422, 0077,7733,5700,0044	;5348	PLA0	[^1 011 11X, ^X XXX XXX XXX 1XX 1XX]
				;5349		LBIS.B	[373, RF],		; Override literal<2>.
U 2423, 0000,0577,7577,1777	;5350				NAF/1777	; Do not override NAF.
				;5351	=
				;5352	EXTR1-3:	; Override on 1 in PIR<5> and PIR<3>.
				;5353	=10********0
U 2424, 0077,7727,5700,0050	;5354	PLA0	[^1 011 11X, ^X XXX XXX XXX 1X1 XXX]
				;5355		LBIS.B	[367, RF],		; Override literal<3>.
U 2425, 0000,0577,7377,1777	;5356				NAF/1777	; Do not override NAF.
				;5357	=
				;5358	EXTR1-4:	; Override on 1 in PIR<5> and PIR<4>.
				;5359	=10********0
U 2426, 0077,7717,5700,0060	;5360	PLA0	[^1 011 11X, ^X XXX XXX XXX 11X XXX]
				;5361		LBIS.B	[357, RF],		; Override literal<4>.
U 2427, 0000,0577,6777,1777	;5362				NAF/1777	; Do not override NAF.
				;5363	=
				;5364	;=0*0*0*0000				; Must override from 0537 for ASHC.
				;5365						; Align NAs for both ASH and ASHC.
				;5366	;NOP-PF1:				; Get here after left shift loop or on no shift.
				;5367	;	NOP.W	[RF, PS],		; Allow Predecode to write IR on A-bus<31:16>.
				;5368	;		PREFETCH,		; Fetch future I-stream word.
				;5369	;			NAF/ID1		; Predecode.  See "ID1 Q-Logic Next Addresses"
				;5370	;ASH-L:
				;5371	;	ASL.W*	[RSRC, RSRC],		; Shift PDP11 register NN times.
				;5372	;		DECR CNTR,		; Final CC update is correct.
				;5373	;			NAF/ASH-L	; Back up to NOP-PF1 when done.
				;5374	;ASH-R1:
				;5375	;	ASR.W*	[RSRC, RSRC],		; Do final shift.  C, N, Z are correct.  V is wrong.
				;5376	;			NAF/ASH4	; Skip down to fix V.
				;5377	;ASH-R:
				;5378	;	ASR.W	[RSRC, RSRC],		; Shift PDP11 register NN-1 times.
				;5379	;		DECR CNTR,		; Go back to ASH-R1 when done and
				;5380	;			NAF/ASH-R	;  do final right shift.
				;5381	ASH4:
				;5382		MOV.W*	[RSRC, RSRC],		; Set V=0 (no sign change).  Leave C, N, Z alone.
				;5383			PREFETCH,		; Fetch future I-stream word.
U 1210, 0000,1560,4347,0477	;5384				NAF/ID1		; Predecode.  See "ID1 Q-Logic Next Addresses"
				;5385						; If RSRC = PC, MKPB-L has already cleared
				;5386						;  DATAV and PPCV, no prefetch occurs, and the
				;5387						;  resynchronization sequence is invoked.
				;5388	
;5389	.NOBIN
;5390	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  127
; BASE  .MCD [242,1110]      ASHC - Arithmetic Shift Combined

;5391		.TOC	"				ASHC - Arithmetic Shift Combined"
;5392	
;5393	;
;5394	; ASHC:
;5395	;
;5396	;	Treated as SOP by Q-Logic.
;5397	;	Source Operand specified as Destination Mode.
;5398	;	SRC = Source Operand<5:0>.
;5399	;
;5400	;	RSRC, RSRC+1 <-- RSRC, RSRC+1  Shifted arithmetically NN places to the left
;5401	;			 (if SRC >= 0 ), or right (if SRC < 0 ), where NN = |SRC|.
;5402	;
;5403	; Entry Conditions:
;5404	;
;5405	;	RE contains Source Operand (RDST for Mode 0).
;5406	;	PIR contains Opcode.
;5407	;
;5408	; Exit Conditions:
;5409	;
;5410	;	NAF = ID1 (477).
;5411	;
;5412	; Method:
;5413	;
;5414	;	Both the PIR and CNTR are loaded with the Source Operand.  RSRC is loaded
;5415	;	into RF<31:0> and the PLA is invoked to separate special cases:
;5416	;		A)  SRC = 0.  Update CC only and do Prefetch, Predecode.
;5417	;		B)  SRC<16:5> = 0.  Begin left shift immediately as CNTR is correct.
;5418	;		C)  SRC = -1.  Do one right shift only.
;5419	;	If none of these is the case, a LCNTR microinstruction is dynamically
;5420	;	altered to load the shift count (1's complement for a negative count).
;5421	;	NAF overrides select the right or left shift and the CNTR is used to count.
;5422	;	Finally, the CC are updated, then Prefetch and Predecode.
;5423	;
;5424	
				;5425	.BIN
				;5426	
				;5427	;SOP-DM0:	; Turns on at SOP execution.
				;5428	;=10********0	; Register select and NAF override for Mode 0.
				;5429	;PLA0	[^0 111 0X1, ^X XXX XXX XXX 000 XXX]
				;5430	;	RE_RE --> RDST_RDST,		; Override RE to RDST (PDP11 register).
				;5431	;			NAF/1777	; Do not affect NAF.
				;5432	;=
				;5433	ASHC:		; Do ASHC.
				;5434	=10********0
U 2430, 0120,0777,3447,3000	;5435	PLA0	[^0 111 0X1, ^0 111 011 XXX XXX XXX]
U 2431, 0000,0271,4776,0072	;5436		OUTS	[LD_PIR_CNTR, RE]	; Test for positive(left) or negative(right) shift.
				;5437	=					; <-- OUTS [LD_PIR_CNTR_MSTK, RDST] for Mode 0.
				;5438	
				;5439	=**0*1*****				; Must abort to ROM[40] for not Mode 0.
				;5440		MOV.W	[RSRC, RF.H],		; RF<31:16> <-- Even RSRC.  Pack into 32-bit RF.
U 0072, 0000,1561,6357,0526	;5441				NAF/526		; Invoke PLA translation to separate cases.
				;5442	=
				;5443	ASHC1:		; Default for ASHX-0-OVR, ASHC-MASK, and ASHX-NEG-1 overrides.
				;5444	=10********0
U 2432, 0037,7777,5300,0000	;5445	PLA0	[^1 010 110, ^X]
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  128
; BASE  .MCD [242,1110]      ASHC - Arithmetic Shift Combined

				;5446		MOV.W	[RSRC+1, RF],		; RF<15:0> <-- Odd RSRC.
U 2433, 0000,1561,6177,0537	;5447				NAF/537		; ASHC2.  Overridden if no need to reload CNTR.
				;5448	=
				;5449	;ASHX-0-OVR:	; SRC<5:0> = 0.  No shift.
				;5450	;=10********0
				;5451	;PLA0	[^1 01X 110, ^X XXX XXX XXX 000 000]
				;5452	;	NOP.W	[RF, RF],		; Do not override microinstruction.
				;5453	;			NAF/ASHC-NO	; Override to NOP-PF1 for ASH or
				;5454	;=					;  to ASHC-NO for ASHC.
				;5455	
				;5456	ASHC-MASK:	; SRC<16:5> = 0.  No need to reload CNTR.
				;5457	=10********0
U 2434, 0020,0037,5300,0000	;5458	PLA0	[^1 010 110, ^0 000 000 000 0XX XXX]
				;5459		MOV.W	[RSRC+1, RF],		; RF<15:0> <-- Odd RSRC.
U 2435, 0000,1561,6177,0035	;5460				NAF/ASHC-L	; Override ASHC2 (0537) to ASHC-L.
				;5461	=
				;5462	;ASHX-NEG-1:	; SRC<5:0> = -1.  One right shift only.
				;5463	;=10********0
				;5464	;PLA0	[^1 01X 110, ^X XXX XXX XXX 111 111]
				;5465	;	NOP.W	[RF, RF],		; Do not override microinstruction.
				;5466	;			NAF/ASHC-R1	; Override to ASH-R1 or ASHC-R1.
				;5467	;=
				;5468	ASHC2:		; Default for constant extract PLAs.
				;5469	=10********0
U 2436, 0037,7777,5740,0000	;5470	PLA0	[^1 011 111, ^X]
				;5471		LCNTR.W	[037, RE],		; Load CNTR with shift count.
U 2437, 0000,0520,1776,0037	;5472				NAF/ASHC-R	; Overridden to ASHC-L for positive case.
				;5473	=
				;5474	;EXTR0-0:	; Override on 0 in PIR<5> and PIR<0>.
				;5475	;=10********0
				;5476	;PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX XX0]
				;5477	;	LBIS.B	[336, RF],		; Override literal<5,0> (SPL, ASHX).
				;5478	;			NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5479	;=
				;5480	;EXTR0-1:	; Override on 0 in PIR<5> and PIR<1>.
				;5481	;=10********0
				;5482	;PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX X0X]
				;5483	;	LBIS.B	[275, RF],		; Override literal<6,1> (SPL, ASHX).
				;5484	;			NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5485	;=
				;5486	;EXTR0-2:	; Override on 0 in PIR<5> and PIR<2>.
				;5487	;=10********0
				;5488	;PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX 0XX]
				;5489	;	LBIS.B	[173, RF],		; Override literal<7,2> (SPL, ASHX).
				;5490	;			NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5491	;=
				;5492	;EXTR0-3:	; Override on 0 in PIR<5> and PIR<3>.
				;5493	;=10********0
				;5494	;PLA0	[^1 011 11X, ^X XXX XXX XXX 0X0 XXX]
				;5495	;	LBIS.B	[367, RF],		; Override literal<3>.
				;5496	;			NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5497	;=
				;5498	;EXTR0-4:	; Override on 0 in PIR<5> and PIR<4>.
				;5499	;=10********0
				;5500	;PLA0	[^1 011 11X, ^X XXX XXX XXX 00X XXX]
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  129
; BASE  .MCD [242,1110]      ASHC - Arithmetic Shift Combined

				;5501	;	LBIS.B	[357, RF],		; Override literal<4>.
				;5502	;			NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;5503	;=
				;5504	;EXTR1-0:	; Override on 1 in PIR<5> and PIR<0>.
				;5505	;=10********0
				;5506	;PLA0	[^1 011 11X, ^X XXX XXX XXX 1XX XX1]
				;5507	;	LBIS.B	[376, RF],		; Override literal<0>.
				;5508	;			NAF/1777	; Do not override NAF.
				;5509	;=
				;5510	;EXTR1-1:	; Override on 1 in PIR<5> and PIR<1>.
				;5511	;=10********0
				;5512	;PLA0	[^1 011 11X, ^X XXX XXX XXX 1XX X1X]
				;5513	;	LBIS.B	[375, RF],		; Override literal<1>.
				;5514	;			NAF/1777	; Do not override NAF.
				;5515	;=
				;5516	;EXTR1-2:	; Override on 1 in PIR<5> and PIR<2>.
				;5517	;=10********0
				;5518	;PLA0	[^1 011 11X, ^X XXX XXX XXX 1XX 1XX]
				;5519	;	LBIS.B	[373, RF],		; Override literal<2>.
				;5520	;			NAF/1777	; Do not override NAF.
				;5521	;=
				;5522	;EXTR1-3:	; Override on 1 in PIR<5> and PIR<3>.
				;5523	;=10********0
				;5524	;PLA0	[^1 011 11X, ^X XXX XXX XXX 1X1 XXX]
				;5525	;	LBIS.B	[367, RF],		; Override literal<3>.
				;5526	;			NAF/1777	; Do not override NAF.
				;5527	;=
				;5528	;EXTR1-4:	; Override on 1 in PIR<5> and PIR<4>.
				;5529	;=10********0
				;5530	;PLA0	[^1 011 11X, ^X XXX XXX XXX 11X XXX]
				;5531	;	LBIS.B	[357, RF],		; Override literal<4>.
				;5532	;			NAF/1777	; Do not override NAF.
				;5533	;=
				;5534	;=0*0*0*0000				; Must override from 0537 for ASHC.
				;5535						; Align NAs for both ASH and ASHC.
				;5536	20:					;* Temporary fix for constraint problem.
				;5537	NOP-PF1:				; Get here after left shift loop or on no shift.
				;5538		NOP.W	[RF, PS],		; Allow Predecode to write IR on A-bus<31:16>.
				;5539			PREFETCH,		; Fetch future I-stream word.
U 0020, 0000,1770,7740,0477	;5540				NAF/ID1		; Predecode.  See "ID1 Q-Logic Next Addresses"
				;5541	21:
				;5542	ASH-L:
				;5543		ASL.W*	[RSRC, RSRC],		; Shift PDP11 register NN times.
				;5544			DECR CNTR,		; Final CC update is correct.
U 0021, 0000,1231,0347,0021	;5545				NAF/ASH-L	; Back up to NOP-PF1 when done.
				;5546	22:
				;5547	ASH-R1:
				;5548		ASR.W*	[RSRC, RSRC],		; Do final shift.  C, N, Z are correct.  V is wrong.
U 0022, 0000,1341,4347,1210	;5549				NAF/ASH4	; Skip down to fix V.
				;5550	23:
				;5551	ASH-R:
				;5552		ASR.W	[RSRC, RSRC],		; Shift PDP11 register NN-1 times.
				;5553			DECR CNTR,		; Go back to ASH-R1 when done and
U 0023, 0000,1341,2347,0023	;5554				NAF/ASH-R	;  do final right shift.
				;5555	;ASH4:
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  130
; BASE  .MCD [242,1110]      ASHC - Arithmetic Shift Combined

				;5556	;	MOV.W*	[RSRC, RSRC],		; Set V=0 (no sign change).  Leave C, N, Z alone.
				;5557	;		PREFETCH,		; Fetch future I-stream word.
				;5558	;			NAF/ID1		; Predecode.  See "ID1 Q-Logic Next Addresses"
				;5559	30:
				;5560	;=1000					; Start new block for ASHC.
				;5561	ASHC-NO:				; SRC = 0.  Do not shift.
				;5562		TST.L*	[RF, RF],		; Simply update CC.  C and V are cleared.
U 0030, 0000,1663,5777,1477	;5563				NAF/NOP-PF	; Finish up with NOP, PREFETCH.
				;5564	34:
				;5565	;=1100
				;5566	ASHC-END:				; Get here after last shift.
				;5567		MOV.W	[RF.H, RSRC],		; Even RSRC <-- RF<31:16>.  Unpack.
U 0034, 0000,1561,6747,0410	;5568				NAF/P.ASHC	; Decode right/left for final unpack.
				;5569	35:
				;5570	ASHC-L:
				;5571		ASL.L*	[RF, RF],		; Shift RF<31:0> NN times.
				;5572			DECR CNTR,		; Final N, Z, V, C are correct.
U 0035, 0000,1233,1777,0035	;5573				NAF/ASHC-L	; Skip back to unpack when done.
				;5574	36:
				;5575	ASHC-R1:
				;5576		ASR.L*	[RF, RF],		; Shift RF<31:0> one more time.
				;5577						; Final N, Z, C are correct.  V is wrong.
U 0036, 0000,1343,5777,0034	;5578				NAF/ASHC-END	; Go unpack, then fix V.
				;5579	37:
				;5580	ASHC-R:
				;5581		ASR.L	[RF, RF],		; Shift RF<31:0> NN-1 times.
				;5582			DECR CNTR,
U 0037, 0000,1343,3777,0037	;5583				NAF/ASHC-R	; Skip back for final shift when done.
				;5584	;=					; Terminate ASH and ASHC constraint.
				;5585	
				;5586	=10********0	; Final unpack for left shift.
U 2440, 0037,7737,0400,0000	;5587	NPLA0	[P.ASHC, ^X XXX XXX XXX 0XX XXX]
				;5588		MOV.W	[RF, RSRC+1],		; Odd RSRC <-- RF<15:0>.  Finish unpack.
U 2441, 0000,1561,7743,1477	;5589				NAF/NOP-PF	; All done.  Do NOP, PREFETCH.
				;5590	=
				;5591	=10********0	; Final unpack for right shift.
U 2442, 0037,7737,0400,0040	;5592	NPLA0	[P.ASHC, ^X XXX XXX XXX 1XX XXX]
				;5593		MOV.L*	[RF, RSRC+1],		; Odd RSRC <-- RF<15:0>.  Finish unpack.
				;5594						; Leave C alone, clear V, N and Z stay the same.
U 2443, 0000,1563,5743,1477	;5595				NAF/NOP-PF	; All done.  Do NOP, PREFETCH.
				;5596	=
				;5597	
;5598	.NOBIN
;5599	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  131
; BASE  .MCD [242,1110]      JOP Decode

;5600		.TOC	"		JOP Decode"
;5601	
;5602	;
;5603	; Entry Conditions:
;5604	;
;5605	;	NA = 467.  The Q-Logic zeroed NA<3>.
;5606	;
;5607	; Exit Conditions:
;5608	;
;5609	;	NAF = IRDF where the resulting NA is:
;5610	;			460 - to finish resynchronization, or
;5611	;			400 - to service interrupt.
;5612	; Method:
;5613	;
;5614	;	Both JMPs and JSRs are emulated here.
;5615	;
;5616	;	For JMPs, the required addressing is done and the operand is loaded
;5617	;	into the PC.
;5618	;
;5619	;	PC	<-- Operand
;5620	;
;5621	;	For JSRs, the required addressing is done and the operand is placed
;5622	;	into a scratch register, the SP is decremented and the link register
;5623	;	(RSRC) is written to the Stack.  The PC is then transferred to the
;5624	;	link register and the operand is moved to the PC.
;5625	;
;5626	;	RF	<-- Operand
;5627	;	SP	<-- SP - 2
;5628	;	M[SP]	<-- RSRC
;5629	;	RSRC	<-- PC
;5630	;	PC	<-- RF
;5631	;
;5632	;	If the link register is the PC, the step RSRC <-- PC is redundant.
;5633	;	This is a frequently used case and the code is therefore optimized
;5634	;	to eliminate this step.  Mode 67 is also optimized.  See the comments
;5635	;	at the beginning of Mode 6.
;5636	;
;5637	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  132
; BASE  .MCD [242,1110]      JOP Mode 0

;5638		.TOC	"			JOP Mode 0"
;5639	
;5640	;
;5641	; Mode 0:
;5642	;
;5643	;	Illegal transfer to register.
;5644	;	Trap to vector 10, Illegal Instruction Trap.
;5645	;
;5646	; JMP:
;5647	;
;5648	;	NOP.B	[RF, PC]		; JMPXX override to 1776.
;5649	; 1776:
;5650	;	LLD.L	[010, RA],		; Load vector address to scratch.
;5651	;			NAF/M-TRAP	; Join code at "Micro Trap".
;5652	;
;5653	; JSR:
;5654	;
;5655	;	NOP.B	[RF, RF]		; No PLA translation at 467.
;5656	; 1777:
;5657	;	LLD.L	[010, RA],		; Load vector address to scratch.
;5658	;			NAF/M-TRAP	; Join code at "Micro Trap".
;5659	;
;5660	
				;5661	.BIN
				;5662	
				;5663	
				;5664	;JMPXX:		; Detect any JMP.  NAF and PC override.
				;5665	;=10********0
				;5666	;PLA0	[^0 X10 11X, ^0 000 000 001 XXX XXX]
				;5667	;	NOP.B	[RF, PC],		; Override RF to PC for Modes 1,3,4,5 or 7.
				;5668	;			NAF/1776	; Override NAF<0> for JMP breakout.
				;5669	;=
				;5670	
				;5671	1776:
				;5672		LLD.L	[010, RA],		; Load vector address to scratch.
U 1776, 0000,0562,0432,1271	;5673				NAF/M-TRAP	; Join code at "Micro Trap".
				;5674	
				;5675	;1777:					; NAF out of PLA was all ones.
				;5676	;	LLD.L	[010, RA],		; Load trap vector to scratch.
				;5677	;			NAF/M-TRAP	; Join trap code at "Micro Trap".
				;5678	
;5679	.NOBIN
;5680	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  133
; BASE  .MCD [242,1110]      JOP Mode 1

;5681		.TOC	"			JOP Mode 1"
;5682	
;5683	;
;5684	; Mode 1:
;5685	;
;5686	;	Register specifies operand.
;5687	;
;5688	; JMP:
;5689	;
;5690	;	MOV.W	[RDST, PC]		; Move operand to PC.
;5691	;
;5692	; JSR:
;5693	;
;5694	;	MOV.W	[RDST, RF]		; Move operand to scratch.
;5695	;	ARD.W	[SP]			; Decrement SP by 2.
;5696	;	AW	[SP]			; Relocate SP address.
;5697	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;5698	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;5699	;	MOV.W	[RF, PC]		; Move operand to PC.
;5700	;
;5701	;    *  Not executed if link register is PC.
;5702	;
;5703	; Then:
;5704	;
;5705	;	RSYNC,				; Resynchronize the PPC.
;5706	;		NAF/IRDF		; Service interrupt or fetch instruction.
;5707	;
;5708	
				;5709	.BIN
				;5710	
				;5711	JOP1X:		; Breakout JMP or JSR Mode 1.
				;5712	=10********0
U 2444, 0037,7707,3340,0010	;5713	PLA0	[^0 110 111, ^X XXX XXX XXX 001 XXX]
				;5714		MOV.W	[RDST, RF],		; Move operand to scratch or PC.
U 2445, 0000,1561,6337,0027	;5715				NAF/JOP1-1	; Overridden to JOP1-0 for JMPs.
				;5716	=
				;5717	JMPXX:		; Detect any JMP.  NAF and PC override.
				;5718	=10********0
U 2446, 2060,0077,1300,0100	;5719	PLA0	[^0 X10 11X, ^0 000 000 001 XXX XXX]
				;5720		NOP.B	[RF, PC],		; Override RF to PC for Modes 1,3,4,5 or 7.
U 2447, 0000,1777,7767,1776	;5721				NAF/1776	; Override NAF<0> for JMP breakout.
				;5722	=
				;5723	;=0*000*0**0				; Allocation for JMPXX and JSR37 override.
				;5724	;JOP1-0:
				;5725	;	RSYNC,				; Relocate VPC to PPC.
				;5726	;			NAF/IRDF	; Go Read Demand Prefetch.  Allow interrupt first.
				;5727	;JOP1-1:
				;5728	;	ARD.W	[SP],			; Decrement SP by 2.
				;5729	;		LD MMR1,		; Record general register change.
				;5730	;		NO ABORTS,		; Get aborts later.
				;5731	;			NAF/463		; JSR1.  Invoke PLA check for link = PC.
				;5732	;=					; Must abort to ROM[040].
				;5733	
				;5734	JSR1:		; Default PLA for link = PC override.
				;5735	=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  134
; BASE  .MCD [242,1110]      JOP Mode 1

U 2450, 0037,7777,3140,0000	;5736	PLA0	[^0 110 011, ^X]
				;5737		AW	[SP],			; Relocate SP address.
				;5738			ODD TRAP,		; Must be a word address.
				;5739			SOVFF,			; Check for Yellow Stack Violation.
U 2451, 0000,0771,6366,1465	;5740				NAF/JSR-1	; Can be overridden to JSR-0 (465).
				;5741	=
				;5742	JSR7XX:		; Detect link = PC and override NAF.
				;5743	=10********0
U 2452, 0037,7077,3140,0700	;5744	PLA0	[^0 110 011, ^X XXX XXX 111 XXX XXX]
				;5745		NOP.W	[RF, RF],		; Do not change AW.
U 2453, 0000,1771,7777,0465	;5746				NAF/465		; Override to JSR-0 (465).
				;5747	=
				;5748	=1**11*1*1				; Must override to 465.
				;5749	JSR-1:					; Not executed if link = PC.
				;5750		MOV.W	[RSRC, RSRC],		; Write link register to stack.
U 1465, 0000,1561,6347,0465	;5751				NAF/465		; Go move PC to link register.
				;5752	=
				;5753	JSR-0:		; Default PLA for JOP67 and JSRO37 overrides.
				;5754	=10********0
U 2454, 0037,7777,3240,0000	;5755	PLA0	[^0 110 101, ^X]
				;5756		MOV.W	[PC, RSRC],		; Move PC to link or write to stack.
U 2455, 0000,1561,7347,0146	;5757				NAF/MOV-PC	; Join common final step.
				;5758	=
				;5759	;=110					; Skip  =101.  Will abort to ROM[40].
				;5760	;MOV-PC:
				;5761	;	MOV.W	[RF, PC],		; Move operand to PC.
				;5762	;			NAF/RE-SYNC	; Join common RSYNC.
				;5763	;=					; RE-SYNC aborts to ROM[40].
				;5764	
;5765	.NOBIN
;5766	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  135
; BASE  .MCD [242,1110]      JOP Mode 2

;5767		.TOC	"			JOP Mode 2"
;5768	
;5769	;
;5770	; Mode 2:
;5771	;
;5772	;	Register specifies operand.
;5773	;	Register is autoincremented.
;5774	;
;5775	; JMP:
;5776	;
;5777	;	MOV.W	[RDST, RF+]		; Move operand to scratch.
;5778	;	ARI.W	[RDST]			; Increment register by 2.
;5779	;	MOV.W	[RF, PC]		; Move operand to PC.
;5780	;
;5781	; JSR:
;5782	;
;5783	;	MOV.W	[RDST, RF+]		; Move operand to scratch.
;5784	;	ARI.W	[RDST]			; Increment register by 2.
;5785	;	ARD.W	[SP]			; Decrement SP by 2.
;5786	;	AW	[SP]			; Relocate SP address.
;5787	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;5788	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;5789	;	MOV.W	[RF, PC]		; Move operand to PC.
;5790	;
;5791	;    *  Not executed if link register is PC.
;5792	;
;5793	; Then:
;5794	;
;5795	;	RSYNC,				; Resynchronize the PPC.
;5796	;		NAF/IRDF		; Service interrupt or fetch instruction.
;5797	;
;5798	
				;5799	.BIN
				;5800	
				;5801	JOP2X:		; Breakout JMP or JSR Mode 2.
				;5802	=10********0
U 2456, 0037,7707,3340,0020	;5803	PLA0	[^0 110 111, ^X XXX XXX XXX 010 XXX]
				;5804		MOV.W	[RDST, RF+],		; Move operand to scratch.
U 2457, 0000,1561,6305,0253	;5805				NAF/JOP2-1	; Overridden to JOP2-0 for JMPs.
				;5806	=
				;5807	;JMPXX:		; Detect any JMP.  NAF and PC override.
				;5808	;=10********0
				;5809	;PLA0	[^0 X10 11X, ^0 000 000 001 XXX XXX]
				;5810	;	NOP.B	[RF, PC],		; Override RF to PC for Modes 1,3,4,5, or 7.
				;5811	;			NAF/1776	; Override NAF<0> for JMP breakout.
				;5812	;=
				;5813	=0					; Two NAs for JMPXX override.
				;5814	JOP2-0:
				;5815		ARI.W	[RDST],			; Increment register by 2.
				;5816			NO ABORTS,		; Don't really do a bus cycle
				;5817			LD MMR1,		;  but record amount in MMR1.
U 0252, 0000,0700,7546,0146	;5818				NAF/MOV-PC	; Join common last step.
				;5819	JOP2-1:
				;5820		ARI.W	[RDST],			; Increment register by 2.
				;5821			NO ABORTS,		; Don't really do a bus cycle
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  136
; BASE  .MCD [242,1110]      JOP Mode 2

				;5822			LD MMR1,		;  but record amount in MMR1.
U 0253, 0000,0700,7546,0027	;5823				NAF/JOP1-1	; Join common JSR code.
				;5824	=
				;5825	;JOP1-1:
				;5826	;	ARD.W	[SP],			; Decrement SP by 2.
				;5827	;		LD MMR1,		; Record general register change.
				;5828	;		NO ABORTS,		; Get aborts later.
				;5829	;			NAF/463		; JSR1.  Invoke PLA check for link = PC.
				;5830	;=					; Must abort to ROM[040].
				;5831	;
				;5832	;JSR1:		; Default PLA for link = PC override.
				;5833	;=10********0
				;5834	;PLA0	[^0 110 011, ^X]
				;5835	;	AW	[SP],			; Relocate SP address.
				;5836	;		ODD TRAP,		; Must be a word address.
				;5837	;		SOVFF,			; Check for Yellow Stack Violation.
				;5838	;			NAF/JSR-1	; Can be overridden to JSR-0 (465).
				;5839	;=
				;5840	;JSR7XX:		; Detect link = PC and override NAF.
				;5841	;=10********0
				;5842	;PLA0	[^0 110 011, ^X XXX XXX 111 XXX XXX]
				;5843	;	NOP.W	[RF, RF],		; Do not change AW.
				;5844	;			NAF/465		; Override to JSR-0 (465).
				;5845	;=
				;5846	;=1**11*1*1				; Must override to 465.
				;5847	;JSR-1:					; Not executed if link = PC.
				;5848	;	MOV.W	[RSRC, RSRC],		; Write link register to stack.
				;5849	;			NAF/465		; Go move PC to link register.
				;5850	;=
				;5851	;JSR-0:		; Default PLA for JOP67 and JSRO37 overrides.
				;5852	;=10********0
				;5853	;PLA0	[^0 110 101, ^X]
				;5854	;	MOV.W	[PC, RSRC],		; Move PC to link or write to stack.
				;5855	;			NAF/MOV-PC	; Join common final step.
				;5856	;=
				;5857	;=110					; Skip  =101.  Will abort to ROM[40].
				;5858	;MOV-PC:
				;5859	;	MOV.W	[RF, PC],		; Move operand to PC.
				;5860	;			NAF/RE-SYNC	; Join common RSYNC.
				;5861	;=					; RE-SYNC aborts to ROM[40].
				;5862	
;5863	.NOBIN
;5864	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  137
; BASE  .MCD [242,1110]      JOP Mode 3

;5865		.TOC	"			JOP Mode 3"
;5866	
;5867	;
;5868	; Mode 3:
;5869	;
;5870	;	Register specifies operand address.
;5871	;	Register is autoincremented.
;5872	;
;5873	; JMP:
;5874	;
;5875	;	ARI.W	[RDST]			; Relocate operand address and autoincrement.
;5876	;	RD.W	[PC]			; Read operand to PC.
;5877	;
;5878	; JSR - not Mode 37:
;5879	;
;5880	;	ARI.W	[RDST]			; Relocate operand address and autoincrement.
;5881	;	RD.W	[RF]			; Read operand to scratch.
;5882	;	ARD.W	[SP]			; Decrement SP by 2.
;5883	;	AW	[SP]			; Relocate SP address.
;5884	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;5885	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;5886	;	MOV.W	[RF, PC]		; Move operand to PC.
;5887	;
;5888	;    *  Not executed if link register is PC.
;5889	;
;5890	; JSR - Mode 37:
;5891	;
;5892	;	RDI	[RE+]			; Read I-stream word to scratch.
;5893	;	ARD.W	[SP]			; Decrement SP by 2.
;5894	;	AW	[SP]			; Relocate SP address.
;5895	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;5896	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;5897	;	MOV.W	[RE, PC]		; Move operand to PC.
;5898	;
;5899	;    *  Not executed if link register is PC.
;5900	;
;5901	; Then:
;5902	;
;5903	;	RSYNC,				; Resynchronize the PPC.
;5904	;		NAF/IRDF		; Service interrupt or fetch instruction.
;5905	;
;5906	
				;5907	.BIN
				;5908	
				;5909	JOP3X:		; Breakout JMP or JSR Mode 3.
				;5910	=10********0
U 2460, 0037,7707,3340,0030	;5911	PLA0	[^0 110 111, ^X XXX XXX XXX 011 XXX]
				;5912		ARI.W	[RDST],			; Relocate address and autoincrement.
				;5913			LD MMR1,		; Record amount in MMR1.
				;5914			ODD TRAP,		; Must be a word address.
U 2461, 0000,0700,7346,0427	;5915				NAF/427		; PC-RD.  Go read to PC or RF.
				;5916	=
				;5917	JSR37:		; Override for JSR Mode 37.
				;5918	=10********0
U 2462, 0020,0700,3340,4037	;5919	PLA0	[^0 110 111, ^0 000 100 XXX 011 111]
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  138
; BASE  .MCD [242,1110]      JOP Mode 3

				;5920		RDI	[RE+],			; Override ARI to RDI.  Read I-stream.
				;5921						; Must use RE+.  Cannot use RF+.
U 2463, 0000,0301,7744,0027	;5922				NAF/JOP1-1	; Override 427 to common JSR code.
				;5923	=					; Must override 427.
				;5924	
				;5925	PC-RD:		; Read to PC for JMPs or RF for JSRs.
				;5926	=10********0
U 2464, 0077,7767,1300,0010	;5927	PLA0	[^0 010 11X, ^X XXX XXX XXX XX1 XXX]		; Need not be abort NA.
				;5928		RD.W	[RF],			; RF overridden to PC for JMPs (JMPXX).
U 2465, 0000,0321,7777,0027	;5929				NAF/JOP1-1	; Join common RSYNC or Stack decrement.
				;5930	=
				;5931	;JMPXX:		; Detect any JMP.  NAF and PC override.
				;5932	;=10********0
				;5933	;PLA0	[^0 X10 11X, ^0 000 000 001 XXX XXX]
				;5934	;	NOP.B	[RF, PC],		; Override RF to PC for Modes 1,3,4,5, or 7.
				;5935	;			NAF/1776	; Override NAF<0> for JMP breakout.
				;5936	;=
				;5937	;=0*000*0**0				; Allocation for JMPXX and JSR37 override.
				;5938	26:					;* Temporary fix for constraint problem.
				;5939	JOP1-0:
				;5940		RSYNC,				; Relocate VPC to PPC.
U 0026, 0000,1621,7740,0460	;5941				NAF/IRDF	; Go Read Demand Prefetch.  Allow interrupt first.
				;5942	27:
				;5943	JOP1-1:					; Must override from 427.
				;5944		ARD.W	[SP],			; Decrement SP by 2.
				;5945			LD MMR1,		; Record general register change.
				;5946			NO ABORTS,		; Get aborts later.
U 0027, 0000,0710,7566,0463	;5947				NAF/463		; JSR1.  Invoke PLA check for link = PC.
				;5948	;=					; Must abort to ROM[040].
				;5949	
				;5950	;JSR1:		; Default PLA for link = PC override.
				;5951	;=10********0
				;5952	;PLA0	[^0 110 011, ^X]
				;5953	;	AW	[SP],			; Relocate SP address.
				;5954	;		ODD TRAP,		; Must be a word address.
				;5955	;		SOVFF,			; Check for Yellow Stack Violation.
				;5956	;			NAF/JSR-1	; Can be overridden to JSR-0 (465).
				;5957	;=
				;5958	;JSR7XX:		; Detect link = PC and override NAF.
				;5959	;=10********0
				;5960	;PLA0	[^0 110 011, ^X XXX XXX 111 XXX XXX]
				;5961	;	NOP.W	[RF, RF],		; Do not change AW.
				;5962	;			NAF/465		; Override to JSR-0 (465).
				;5963	;=
				;5964	;=1**11*1*1				; Must override to 465.
				;5965	;JSR-1:					; Not executed if link = PC.
				;5966	;	MOV.W	[RSRC, RSRC],		; Write link register to stack.
				;5967	;			NAF/465		; Go move PC to link register.
				;5968	;=
				;5969	;JSR-0:		; Default PLA for JOP67 and JSRO37 overrides.
				;5970	;=10********0
				;5971	;PLA0	[^0 110 101, ^X]
				;5972	;	MOV.W	[PC, RSRC],		; Move PC to link or write to stack.
				;5973	;			NAF/MOV-PC	; Join common final step.
				;5974	;=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  139
; BASE  .MCD [242,1110]      JOP Mode 3

				;5975	JSRO37:		; NAF override for JSR Mode 37.  Use RE.
				;5976	=10********0
U 2466, 0037,7700,3240,0037	;5977	PLA0	[^0 110 101, ^X XXX XXX XXX 011 111]
				;5978		MOV.W	[PC, RSRC],		; Move PC to link or write to stack.
U 2467, 0000,1561,7347,0144	;5979				NAF/JSR37-100	; Override MOV-PC to JSR37-100.
				;5980	=
				;5981	;JSR37-100:
				;5982	;	MOV.W	[RE, PC],		; Move RE to PC for JSR37.
				;5983	;			NAF/RE-SYNC	; Join common RSYNC.
				;5984	;					; RE-SYNC aborts to ROM[40].
				;5985	;
				;5986	;=110					; Skip  =101.  Will abort to ROM[40].
				;5987	;MOV-PC:
				;5988	;	MOV.W	[RF, PC],		; Move operand to PC.
				;5989	;			NAF/RE-SYNC	; Join common RSYNC.
				;5990	;=					; RE-SYNC aborts to ROM[40].
				;5991	
;5992	.NOBIN
;5993	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  140
; BASE  .MCD [242,1110]      JOP Mode 4

;5994		.TOC	"			JOP Mode 4"
;5995	
;5996	;
;5997	; Mode 4:
;5998	;
;5999	;	Register is autodecremented.
;6000	;	Register specifies operand.
;6001	;
;6002	; JMP:
;6003	;
;6004	;	ARD.W	[RDST]			; Decrement register by 2.
;6005	;	MOV.W	[RDST, PC]		; Move operand to PC.
;6006	;
;6007	; JSR:
;6008	;
;6009	;	ARD.W	[RDST]			; Decrement register by 2.
;6010	;	MOV.W	[RDST, RF]		; Move operand to scratch.
;6011	;	ARD.W	[SP]			; Decrement SP by 2.
;6012	;	AW	[SP]			; Relocate SP address.
;6013	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;6014	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;6015	;	MOV.W	[RF, PC]		; Move operand to PC.
;6016	;
;6017	;    *  Not executed if link register is PC.
;6018	;
;6019	; Then:
;6020	;
;6021	;	RSYNC,				; Resynchronize the PPC.
;6022	;		NAF/IRDF		; Service interrupt or fetch instruction.
;6023	;
;6024	
				;6025	.BIN
				;6026	
				;6027	JOP4X:		; Breakout JMP or JSR Mode 4.
				;6028	=10********0
U 2470, 0037,7707,3340,0040	;6029	PLA0	[^0 110 111, ^X XXX XXX XXX 100 XXX]
				;6030		ARD.W	[RDST],			; Decrement register by 2.
				;6031			NO ABORTS,		; Don't really do a bus cycle
				;6032			LD MMR1,		;  but record amount in MMR1.
U 2471, 0000,0710,7546,0426	;6033				NAF/426		; Not overridden by JMPXX.
				;6034	=
				;6035	JOP4:		; Default PLA for Mode 4.
				;6036	=10********0
U 2472, 0037,7707,1300,0040	;6037	PLA0	[^0 010 110, ^X XXX XXX XXX 100 XXX]
				;6038		MOV.W	[RDST, RF],		; For JMP, move operand to PC.
U 2473, 0000,1561,6337,0027	;6039				NAF/JOP1-1	; JMPXX override to JOP1-0.
				;6040	=
				;6041	;JMPXX:		; Detect any JMP.  NAF and PC override.
				;6042	;=10********0
				;6043	;PLA0	[^0 X10 11X, ^0 000 000 001 XXX XXX]
				;6044	;	NOP.B	[RF, PC],		; Override RF to PC for Modes 1,3,4,5, or 7.
				;6045	;			NAF/1776	; Override NAF<0> for JMP breakout.
				;6046	;=
				;6047	;=0*000*0**0				; Allocation for JMPXX and JSR37 override.
				;6048	;JOP1-0:
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  141
; BASE  .MCD [242,1110]      JOP Mode 4

				;6049	;	RSYNC,				; Relocate VPC to PPC.
				;6050	;			NAF/IRDF	; Go Read Demand Prefetch.  Allow interrupt first.
				;6051	;JOP1-1:
				;6052	;	ARD.W	[SP],			; Decrement SP by 2.
				;6053	;		LD MMR1,		; Record general register change.
				;6054	;		NO ABORTS,		; Get aborts later.
				;6055	;			NAF/463		; JSR1.  Invoke PLA check for link = PC.
				;6056	;=					; Must abort to ROM[040].
				;6057	
				;6058	;JSR1:		; Default PLA for link = PC override.
				;6059	;=10********0
				;6060	;PLA0	[^0 110 011, ^X]
				;6061	;	AW	[SP],			; Relocate SP address.
				;6062	;		ODD TRAP,		; Must be a word address.
				;6063	;		SOVFF,			; Check for Yellow Stack Violation.
				;6064	;			NAF/JSR-1	; Can be overridden to JSR-0 (465).
				;6065	;=
				;6066	;JSR7XX:		; Detect link = PC and override NAF.
				;6067	;=10********0
				;6068	;PLA0	[^0 110 011, ^X XXX XXX 111 XXX XXX]
				;6069	;	NOP.W	[RF, RF],		; Do not change AW.
				;6070	;			NAF/465		; Override to JSR-0 (465).
				;6071	;=
				;6072	;=1**11*1*1				; Must override to 465.
				;6073	;JSR-1:					; Not executed if link = PC.
				;6074	;	MOV.W	[RSRC, RSRC],		; Write link register to stack.
				;6075	;			NAF/465		; Go move PC to link register.
				;6076	;=
				;6077	;JSR-0:		; Default PLA for JOP67 and JSRO37 overrides.
				;6078	;=10********0
				;6079	;PLA0	[^0 110 101, ^X]
				;6080	;	MOV.W	[PC, RSRC],		; Move PC to link or write to stack.
				;6081	;			NAF/MOV-PC	; Join common final step.
				;6082	;=
				;6083	;=110					; Skip  =101.  Will abort to ROM[40].
				;6084	;MOV-PC:
				;6085	;	MOV.W	[RF, PC],		; Move operand to PC.
				;6086	;			NAF/RE-SYNC	; Join common RSYNC.
				;6087	;=					; RE-SYNC aborts to ROM[40].
				;6088	
;6089	.NOBIN
;6090	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  142
; BASE  .MCD [242,1110]      JOP Mode 5

;6091		.TOC	"			JOP Mode 5"
;6092	
;6093	;
;6094	; Mode 5:
;6095	;
;6096	;	Register is autodecremented.
;6097	;	Register specifies operand address.
;6098	;
;6099	; JMP:
;6100	;
;6101	;	ARD.W	[RDST]			; Pre-autodecrement operand address.
;6102	;	AR	[RDST]			; Relocate operand address.
;6103	;	RD.W	[PC]			; Read operand to PC.
;6104	;
;6105	; JSR:
;6106	;
;6107	;	ARD.W	[RDST]			; Pre-autodecrement operand address.
;6108	;	AR	[RDST]			; Relocate operand address.
;6109	;	RD.W	[RF]			; Read operand to scratch.
;6110	;	ARD.W	[SP]			; Decrement SP by 2.
;6111	;	AW	[SP]			; Relocate SP address.
;6112	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;6113	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;6114	;	MOV.W	[RF, PC]		; Move operand to PC.
;6115	;
;6116	;    *  Not executed if link register is PC.
;6117	;
;6118	; Then:
;6119	;
;6120	;	RSYNC,				; Resynchronize the PPC.
;6121	;		NAF/IRDF		; Service interrupt or fetch instruction.
;6122	;
;6123	
				;6124	.BIN
				;6125	
				;6126	JOP5X:		; Breakout JMP or JSR Mode 5.
				;6127	=10********0
U 2474, 0037,7707,3340,0050	;6128	PLA0	[^0 110 111, ^X XXX XXX XXX 101 XXX]
				;6129		ARD.W	[RDST],			; Pre-autodecrement operand address.
				;6130			NO ABORTS,		; Don't really do a bus cycle
				;6131			LD MMR1,		;  but record amount in MMR1.
U 2475, 0000,0710,7546,0256	;6132				NAF/JOP5	; Now go relocate.
				;6133	=
				;6134	=0					; Must not be affected by JMPXX override.
				;6135	JOP5:
				;6136		AR	[RDST],			; Relocate operand address.
				;6137			ODD TRAP,		; Must be a word address.
				;6138			SOVFF,			; Check for Yellow Stack Trap.
U 0256, 0000,0731,6346,0427	;6139				NAF/427		; PC-RD.  Go read operand to PC or RF.
				;6140	=
				;6141	;PC-RD:		; Read to PC for JMPs or RF for JSRs.
				;6142	;=10********0
				;6143	;PLA0	[^0 010 11X, ^X XXX XXX XXX XX1 XXX]		; Need not be abort NA.
				;6144	;	RD.W	[RF],			; RF overridden to PC for JMPs (JMPXX).
				;6145	;			NAF/JOP1-1	; Join common RSYNC or Stack decrement.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  143
; BASE  .MCD [242,1110]      JOP Mode 5

				;6146	;=
				;6147	;JMPXX:		; Detect any JMP.  NAF and PC override.
				;6148	;=10********0
				;6149	;PLA0	[^0 X10 11X, ^0 000 000 001 XXX XXX]
				;6150	;	NOP.B	[RF, PC],		; Override RF to PC for Modes 1,3,4,5, or 7.
				;6151	;			NAF/1776	; Override NAF<0> for JMP breakout.
				;6152	;=
				;6153	;=0*000*0**0				; Allocation for JMPXX and JSR37 override.
				;6154	;JOP1-0:
				;6155	;	RSYNC,				; Relocate VPC to PPC.
				;6156	;			NAF/IRDF	; Go Read Demand Prefetch.  Allow interrupt first.
				;6157	;JOP1-1:
				;6158	;	ARD.W	[SP],			; Decrement SP by 2.
				;6159	;		LD MMR1,		; Record general register change.
				;6160	;		NO ABORTS,		; Get aborts later.
				;6161	;			NAF/463		; JSR1.  Invoke PLA check for link = PC.
				;6162	;=					; Must abort to ROM[040].
				;6163	
				;6164	;JSR1:		; Default PLA for link = PC override.
				;6165	;=10********0
				;6166	;PLA0	[^0 110 011, ^X]
				;6167	;	AW	[SP],			; Relocate SP address.
				;6168	;		ODD TRAP,		; Must be a word address.
				;6169	;		SOVFF,			; Check for Yellow Stack Violation.
				;6170	;			NAF/JSR-1	; Can be overridden to JSR-0 (465).
				;6171	;=
				;6172	;JSR7XX:		; Detect link = PC and override NAF.
				;6173	;=10********0
				;6174	;PLA0	[^0 110 011, ^X XXX XXX 111 XXX XXX]
				;6175	;	NOP.W	[RF, RF],		; Do not change AW.
				;6176	;			NAF/465		; Override to JSR-0 (465).
				;6177	;=
				;6178	;=1**11*1*1				; Must override to 465.
				;6179	;JSR-1:					; Not executed if link = PC.
				;6180	;	MOV.W	[RSRC, RSRC],		; Write link register to stack.
				;6181	;			NAF/465		; Go move PC to link register.
				;6182	;=
				;6183	;JSR-0:		; Default PLA for JOP67 and JSRO37 overrides.
				;6184	;=10********0
				;6185	;PLA0	[^0 110 101, ^X]
				;6186	;	MOV.W	[PC, RSRC],		; Move PC to link or write to stack.
				;6187	;			NAF/MOV-PC	; Join common final step.
				;6188	;=
				;6189	;=110					; Skip  =101.  Will abort to ROM[40].
				;6190	;MOV-PC:
				;6191	;	MOV.W	[RF, PC],		; Move operand to PC.
				;6192	;			NAF/RE-SYNC	; Join common RSYNC.
				;6193	;=					; RE-SYNC aborts to ROM[40].
				;6194	
;6195	.NOBIN
;6196	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  144
; BASE  .MCD [242,1110]      JOP Mode 6

;6197		.TOC	"			JOP Mode 6"
;6198	
;6199	;
;6200	; Mode 6:
;6201	;
;6202	;	Register added to I-stream word is operand.
;6203	;
;6204	; JMP - not Mode 67:
;6205	;
;6206	;	RDI	[RF+]			; Read I-stream word to scratch.
;6207	;	ADD.W	[RDST, RF]		; Calculate operand.
;6208	;	MOV.W	[RF, PC]		; Move operand to PC.
;6209	;
;6210	; JSR - not Mode 67:
;6211	;
;6212	;	RDI	[RF+]			; Read I-stream word to scratch.
;6213	;	ADD.W	[RDST, RF]		; Calculate operand.
;6214	;	ARD.W	[SP]			; Decrement SP by 2.
;6215	;	AW	[SP]			; Relocate SP address.
;6216	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;6217	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;6218	;	MOV.W	[RF, PC]		; Move operand to PC.
;6219	;
;6220	;    *  Not executed if link register is PC.
;6221	;
;6222	; JMP - Mode 67:
;6223	;
;6224	;	RDI	[RF+]			; Read I-stream word to scratch.
;6225	;	ADD.W	[RF, PC]		; Calculate operand with PC.
;6226	;
;6227	; JSR - Mode 67:
;6228	;
;6229	;	RDI	[RF+]			; Read I-stream word to scratch.
;6230	;	ARD.W	[SP]			; Decrement SP by 2.
;6231	;	AW	[SP]			; Relocate SP address.
;6232	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;6233	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;6234	;	ADD.W	[RF, PC]		; Calculate operand with PC.
;6235	;
;6236	;    *  Not executed if link register is PC.
;6237	;
;6238	; Then:
;6239	;
;6240	;	RSYNC,				; Resynchronize the PPC.
;6241	;		NAF/IRDF		; Service interrupt or fetch instruction.
;6242	;
;6243	
				;6244	.BIN
				;6245	
				;6246	JOP6X:		; Breakout JMP or JSR Mode 6.
				;6247	=10********0
U 2476, 0037,7707,3340,0060	;6248	PLA0	[^0 110 111, ^X XXX XXX XXX 110 XXX]
				;6249		RDI	[RF+],			; Read I-stream word to scratch.
U 2477, 0000,0301,7745,0143	;6250				NAF/JSR6X-011	; NAF<0> overridden for JMP,
				;6251	=					;  NAF<2:1> overridden for Mode 67.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  145
; BASE  .MCD [242,1110]      JOP Mode 6

				;6252	
				;6253	JOP67:		; Breakout JMP or JSR Mode 67 and override NAF.
				;6254	=10********0
U 2500, 0137,7700,3240,0067	;6255	PLA0	[^0 110 1X1, ^X XXX XXX XXX 110 111]
				;6256		NOP.W	[RF, RF],		; Do not change microinstruction.
U 2501, 0000,1771,7777,1771	;6257				NAF/1771	; Override NAF<2:1> for Mode 67.
				;6258	=
				;6259	;JMPXX:		; Detect any JMP.  NAF and PC override.
				;6260	;=10********0
				;6261	;PLA0	[^0 X10 11X, ^0 000 000 001 XXX XXX]
				;6262	;	NOP.B	[RF, PC],		; Override RF to PC for Modes 1,3,4,5, or 7.
				;6263	;			NAF/1776	; Override NAF<0> for JMP breakout.
				;6264	;=
				;6265	=0*1**000				; Make all abort to ROM[40].
				;6266	JMP67-000:
				;6267		ADD.W	[RF, PC],		; Calculate operand with PC.
U 0140, 0000,1441,7767,0044	;6268				NAF/RE-SYNC	; Join common RSYNC.
				;6269	JSR67-001:
				;6270		ARD.W	[SP],			; Decrement SP by 2.
				;6271			LD MMR1,		; Record general register change.
				;6272			NO ABORTS,		; Get aborts later.
U 0141, 0000,0710,7566,0463	;6273				NAF/463		; JSR1.  Invoke PLA check for link = PC.
				;6274	JMP6X-010:
				;6275		ADD.W	[RDST, RF],		; Calculate operand.
U 0142, 0000,1441,6337,0146	;6276				NAF/MOV-PC	; Finish up with common code.
				;6277	JSR6X-011:
				;6278		ADD.W	[RDST, RF],		; Calculate operand.
U 0143, 0000,1441,6337,0141	;6279				NAF/JSR67-001	; Join common JSR code.
				;6280	JSR37-100:
				;6281		MOV.W	[RE, PC],		; Move RE to PC for JSR37.
U 0144, 0000,1561,7727,0044	;6282				NAF/RE-SYNC	; Join common RSYNC.
				;6283						; RE-SYNC aborts to ROM[40].
				;6284	
				;6285	=110					; Skip  =101.  Will abort to ROM[40].
				;6286	MOV-PC:
				;6287		MOV.W	[RF, PC],		; Move operand to PC.
U 0146, 0000,1561,7767,0044	;6288				NAF/RE-SYNC	; Join common RSYNC.
				;6289	=					; RE-SYNC aborts to ROM[40].
				;6290	
				;6291	;JSR1:		; Default PLA for link = PC override.
				;6292	;=10********0
				;6293	;PLA0	[^0 110 011, ^X]
				;6294	;	AW	[SP],			; Relocate SP address.
				;6295	;		ODD TRAP,		; Must be a word address.
				;6296	;		SOVFF,			; Check for Yellow Stack Violation.
				;6297	;			NAF/JSR-1	; Can be overridden to JSR-0 (465).
				;6298	;=
				;6299	;JSR7XX:		; Detect link = PC and override NAF.
				;6300	;=10********0
				;6301	;PLA0	[^0 110 011, ^X XXX XXX 111 XXX XXX]
				;6302	;	NOP.W	[RF, RF],		; Do not change AW.
				;6303	;			NAF/465		; Override to JSR-0 (465).
				;6304	;=
				;6305	;=1**11*1*1				; Must override to 465.
				;6306	;JSR-1:					; Not executed if link = PC.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  146
; BASE  .MCD [242,1110]      JOP Mode 6

				;6307	;	MOV.W	[RSRC, RSRC],		; Write link register to stack.
				;6308	;			NAF/465		; Go move PC to link register.
				;6309	;=
				;6310	;JSR-0:		; Default PLA for JOP67 and JSRO37 overrides.
				;6311	;=10********0
				;6312	;PLA0	[^0 110 101, ^X]
				;6313	;	MOV.W	[PC, RSRC],		; Move PC to link or write to stack.
				;6314	;			NAF/MOV-PC	; Join common final step.
				;6315	;=
				;6316	;JOP67:		; Breakout JMP or JSR Mode 67 and override NAF.
				;6317	;=10********0
				;6318	;PLA0	[^0 110 1X1, ^X XXX XXX XXX 110 111]
				;6319	;	NOP.W	[RF, RF],		; Do not change microinstruction.
				;6320	;			NAF/1771	; Override NAF<2:1> for Mode 67.
				;6321	;=
				;6322	;=0*1**000				; Make all abort to ROM[40].
				;6323	;JMP67-000:
				;6324	;	ADD.W	[RF, PC],		; Calculate operand with PC.
				;6325	;			NAF/RE-SYNC	; Join common RSYNC.
				;6326	;
				;6327	;=110					; Skip  =101.  Will abort to ROM[40].
				;6328	;MOV-PC:
				;6329	;	MOV.W	[RF, PC],		; Move operand to PC.
				;6330	;			NAF/RE-SYNC	; Join common RSYNC.
				;6331	;=					; RE-SYNC aborts to ROM[40].
				;6332	
;6333	.NOBIN
;6334	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  147
; BASE  .MCD [242,1110]      JOP Mode 7

;6335		.TOC	"			JOP Mode 7"
;6336	
;6337	;
;6338	; Mode 7:
;6339	;
;6340	;	Register added to I-stream word is operand address.
;6341	;
;6342	; JMP:
;6343	;
;6344	;	RDI	[RF+]			; Read I-stream word to scratch.
;6345	;	ADD.W	[RDST, RF]		; Calculate operand address.
;6346	;	AR	[RF]			; Relocate operand address.
;6347	;	RD.W	[PC]			; Read operand to PC.
;6348	;
;6349	; JSR:
;6350	;
;6351	;	RDI	[RF+]			; Read I-stream word to scratch.
;6352	;	ADD.W	[RDST, RF]		; Calculate operand address.
;6353	;	AR	[RF]			; Relocate operand address.
;6354	;	RD.W	[RF]			; Read operand to scratch.
;6355	;	ARD.W	[SP]			; Decrement SP by 2.
;6356	;	AW	[SP]			; Relocate SP address.
;6357	;    *  MOV.W	[RSRC, RSRC]		; Write link register to stack.
;6358	;	MOV.W	[PC, RSRC]		; Move PC to link or write to stack.
;6359	;	MOV.W	[RF, PC]		; Move operand to PC.
;6360	;
;6361	;    *  Not executed if link register is PC.
;6362	;
;6363	; Then:
;6364	;
;6365	;	RSYNC,				; Resynchronize the PPC.
;6366	;		NAF/IRDF		; Service interrupt or fetch instruction.
;6367	;
;6368	
				;6369	.BIN
				;6370	
				;6371	JOP7X:		; Breakout JMP or JSR Mode 7.
				;6372	=10********0
U 2502, 0037,7707,3340,0070	;6373	PLA0	[^0 110 111, ^X XXX XXX XXX 111 XXX]
				;6374		RDI	[RF+],			; Read I-stream word to scratch.
U 2503, 0000,0301,7745,0266	;6375				NAF/JOP7	; Now go calculate operand address.
				;6376	=
				;6377	=0					; Must not be affected by JMPXX override.
				;6378	JOP7:
U 0266, 0000,1441,6337,0073	;6379		ADD.W	[RDST, RF]		; Calculate operand address.
				;6380	=
				;6381	=0*1*****				; Must abort to ROM[40].
				;6382		AR	[RF],			; Relocate operand address.
				;6383			ODD TRAP,		; Must be a word address.
U 0073, 0000,0731,7377,0427	;6384				NAF/427		; PC-RD.  Go read operand to PC or RF.
				;6385	=
				;6386	;PC-RD:		; Read to PC for JMPs or RF for JSRs.
				;6387	;=10********0
				;6388	;PLA0	[^0 010 11X, ^X XXX XXX XXX XX1 XXX]		; Need not be abort NA.
				;6389	;	RD.W	[RF],			; RF overridden to PC for JMPs (JMPXX).
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  148
; BASE  .MCD [242,1110]      JOP Mode 7

				;6390	;			NAF/JOP1-1	; Join common RSYNC or Stack decrement.
				;6391	;=
				;6392	;JMPXX:		; Detect any JMP.  NAF and PC override.
				;6393	;=10********0
				;6394	;PLA0	[^0 X10 11X, ^0 000 000 001 XXX XXX]
				;6395	;	NOP.B	[RF, PC],		; Override RF to PC for Modes 1,3,4,5, or 7.
				;6396	;			NAF/1776	; Override NAF<0> for JMP breakout.
				;6397	;=
				;6398	;=0*000*0**0				; Allocation for JMPXX and JSR37 override.
				;6399	;JOP1-0:
				;6400	;	RSYNC,				; Relocate VPC to PPC.
				;6401	;			NAF/IRDF	; Go Read Demand Prefetch.  Allow interrupt first.
				;6402	;JOP1-1:
				;6403	;	ARD.W	[SP],			; Decrement SP by 2.
				;6404	;		LD MMR1,		; Record general register change.
				;6405	;		NO ABORTS,		; Get aborts later.
				;6406	;			NAF/463		; JSR1.  Invoke PLA check for link = PC.
				;6407	;=					; Must abort to ROM[040].
				;6408	
				;6409	;JSR1:		; Default PLA for link = PC override.
				;6410	;=10********0
				;6411	;PLA0	[^0 110 011, ^X]
				;6412	;	AW	[SP],			; Relocate SP address.
				;6413	;		ODD TRAP,		; Must be a word address.
				;6414	;		SOVFF,			; Check for Yellow Stack Violation.
				;6415	;			NAF/JSR-1	; Can be overridden to JSR-0 (465).
				;6416	;=
				;6417	;JSR7XX:		; Detect link = PC and override NAF.
				;6418	;=10********0
				;6419	;PLA0	[^0 110 011, ^X XXX XXX 111 XXX XXX]
				;6420	;	NOP.W	[RF, RF],		; Do not change AW.
				;6421	;			NAF/465		; Override to JSR-0 (465).
				;6422	;=
				;6423	;=1**11*1*1				; Must override to 465.
				;6424	;JSR-1:					; Not executed if link = PC.
				;6425	;	MOV.W	[RSRC, RSRC],		; Write link register to stack.
				;6426	;			NAF/465		; Go move PC to link register.
				;6427	;=
				;6428	;JSR-0:		; Default PLA for JOP67 and JSRO37 overrides.
				;6429	;=10********0
				;6430	;PLA0	[^0 110 101, ^X]
				;6431	;	MOV.W	[PC, RSRC],		; Move PC to link or write to stack.
				;6432	;			NAF/MOV-PC	; Join common final step.
				;6433	;=
				;6434	;=110					; Skip  =101.  Will abort to ROM[40].
				;6435	;MOV-PC:
				;6436	;	MOV.W	[RF, PC],		; Move operand to PC.
				;6437	;			NAF/RE-SYNC	; Join common RSYNC.
				;6438	;=					; RE-SYNC aborts to ROM[40].
				;6439	
;6440	.NOBIN
;6441	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  149
; BASE  .MCD [242,1110]      Miscellaneous Instruction Decode

;6442		.TOC	"		Miscellaneous Instruction Decode"
;6443	
;6444	;
;6445	; Entry Conditions:
;6446	;
;6447	;	NA = 477.  The Q-Logic did not effect the NAF.
;6448	;
;6449	; Exit Conditions:
;6450	;
;6451	;	NAF is dependent on instruction executed.
;6452	;
;6453	; Method:
;6454	;
;6455	;	Dependent on instruction executed.
;6456	;
;6457	
;6458	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  150
; BASE  .MCD [242,1110]      Branches

;6459		.TOC	"			Branches"
;6460	
;6461	;
;6462	; Branch: (Branch on PS Condition Codes)
;6463	;	PC	<-- PC + IRFE  if condition true.
;6464	;
;6465	; SOB:	  (Subtract one and branch if not equal zero)
;6466	;	RSRC	<-- RSRC - 1
;6467	;	PC	<-- PC - IRFE  if RSRC is not zero.
;6468	;
;6469	;	The IR Field Extractor (IRFE) automatically calculates the branch displacement when an AOBC or SOBC
;6470	;	microinstruction is executed.  In addition, AOBC and SOBC don't write back to the A-port register
;6471	;	unless the branch condition is satisfied.  In the Control chip, AOBC and SOBC set PPCV so that the
;6472	;	following RSYNC can go directly to ID1.  If the branch is taken, MKPB-L clears DATAV so the short
;6473	;	resynchronization sequence at NA = 460 is executed.
;6474	;
				;6475	.BIN
				;6476	
				;6477	=10********0	; Detect BR.
U 2504, 0020,0377,3740,0400	;6478	PLA0	[^0 111 111, ^0 000 000 1XX XXX XXX]
				;6479		AOBC.W	[IRFE, PC],
U 2505, 0000,1721,6067,1212	;6480				NAF/RSYNC-PF	; Join common RSYNC-PF.
				;6481	=
				;6482	=10********0	; Detect BNE, and BEQ.
U 2506, 0020,0777,3740,1000	;6483	PLA0	[^0 111 111, ^0 000 001 XXX XXX XXX]
				;6484		AOBC.W	[IRFE, PC],
U 2507, 0000,1721,6067,1212	;6485				NAF/RSYNC-PF	; Join common RSYNC-PF.
				;6486	=
				;6487	=10********0	; Detect BGE, BLT, BGT, and BLE.
U 2510, 0020,1777,3740,2000	;6488	PLA0	[^0 111 111, ^0 000 01X XXX XXX XXX]
				;6489		AOBC.W	[IRFE, PC],
U 2511, 0000,1721,6067,1212	;6490				NAF/RSYNC-PF	; Join common RSYNC-PF.
				;6491	=
				;6492	=10********0	; Detect BPL, BMI, BHI, BLOS, BVC, BVS, BCC (BHIS), and BCS (BLO).
U 2512, 0020,3777,3750,0000	;6493	PLA0	[^0 111 111, ^1 000 0XX XXX XXX XXX]
				;6494		AOBC.W	[IRFE, PC],
U 2513, 0000,1721,6067,1212	;6495				NAF/RSYNC-PF	; Join common RSYNC-PF.
				;6496	=
				;6497	SOB:		; Detect SOB.
				;6498	=10********0
U 2514, 0020,0777,3747,7000	;6499	PLA0	[^0 111 111, ^0 111 111 XXX XXX XXX]
U 2515, 0000,1451,6347,1211	;6500		DEC.W	[RSRC, RSRC]		; Decrement the loop counter.
				;6501	=
				;6502		SOBC.W	[IRFE, PC],		; Subtract offset AZ = 0.
U 1211, 0000,1401,6067,1212	;6503				NAF/RSYNC-PF	; Join common RSYNC-PF.
				;6504	RSYNC-PF:
				;6505		RSYNC,				; Relocate VPC to PPC.
				;6506			PREFETCH,		; Do Prefetch if branch not taken.
U 1212, 0000,1620,7740,0477	;6507				NAF/ID1		; Decode I-stream if branch not taken,
				;6508						;  otherwise, finish resynchronization at 460.
;6509	.NOBIN

; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  151
; BASE  .MCD [242,1110]      RTI and RTT

;6510		.TOC	"			RTI and RTT"
;6511	
;6512	;
;6513	;	PC	<-- (SP)+
;6514	;	PS	<-- (SP)+
;6515	;		If not Kernel Mode:
;6516	;			PS<7:5> is unchanged.
;6517	;			PS<15:11> ORed from stack.
;6518	;	Control chip PS<7:4> loaded from new PS.
;6519	; Then:
;6520	;	RTI loads the ITFF from new PS.
;6521	;	RTT clears the ITFF.
;6522	;
;6523	
				;6524	.BIN
				;6525	
				;6526	RTI-RTT:	; Break out RTI and RTT.
				;6527	=10********0
U 2516, 0020,0004,3740,0002	;6528	PLA0	[^0 111 111, ^0 000 000 000 000 X10]
				;6529		ARI.W	[SP],			; Relocate SP in current mode and increment by two.
				;6530			ODD TRAP,		; Must be a word address.
U 2517, 0000,0700,7366,1213	;6531			LD MMR1			; Record change in MMR1.
				;6532	=
U 1213, 0000,0321,7767,1214	;6533		RD.W	[PC]			; Load PC.  MMR2 still has PC if abort.
				;6534	
U 1214, 0000,0165,1137,0145	;6535		JKM	[RTx_KERNEL]		; Jump around special processing
				;6536	=0*1*****				; Force abort to ROM[040].
				;6537		ARI.W	[SP],			; Relocate SP again and pop.
U 0145, 0000,0700,7766,1215	;6538			LD MMR1			; Again record the change for MMU.
				;6539	=
U 1215, 0000,0321,7777,1216	;6540		RD.W	[RF] 			; Read new PS data
U 1216, 0000,0557,6037,0147	;6541	 	LBIC.B	[340,RF]		; Priority is cleared out
				;6542	=0*1*****				; Force abort to ROM[040].
U 0147, 0000,0467,7436,1217	;6543		LLSW.B	[370,RE]		; Setup mask to save old modes <15:11>
				;6544	=
U 1217, 0000,0567,6036,1220	;6545		LLD.B	[340,RE]		; Also save old priority information
U 1220, 0000,1511,7700,1221	;6546		AND.W	[RE,PS]			; Clear out all but <15:11> and <7:5>
				;6547		BIS.W	[RF,PS],		; Build new PS information
U 1221, 0000,1571,7740,1223	;6548			NAF/RTx_CONVERGE	; Go and update control chip PS
				;6549	RTx_KERNEL:
U 1222, 0000,0321,7740,1223	;6550		RD.W	[PS]			; Kernel mode directly copys input
				;6551	RTx_CONVERGE:
				;6552		OUTS	[PSW, PS],		; Update Control chip PS<7:4>, interrupt
				;6553						;  priority and T-bit.
U 1223, 0000,0271,3740,0441	;6554				NAF/P.RTX	; Decode again.  Must abort to ROM[40].
				;6555	
				;6556	=10********0	; RTI only.
U 2520, 0037,7773,2040,0000	;6557	NPLA0	[P.RTX, ^X XXX XXX XXX XXX 0XX]
				;6558		OUTC	[CPY_T-BIT],		; RTI allows a T-Bit Trap before next instruction.
U 2521, 0000,0261,6777,0044	;6559				NAF/RE-SYNC	; Resychronize after asserting MKPB-L.
				;6560	=
				;6561	=10********0	; RTT only.
U 2522, 0037,7773,2040,0004	;6562	NPLA0	[P.RTX, ^X XXX XXX XXX XXX 1XX]
				;6563		OUTC	[CLR_ITFF],		; RTT inhibits T-Bit Trap before next instruction.
U 2523, 0000,0261,3777,0044	;6564				NAF/RE-SYNC	; Resychronize after asserting MKPB-L.

; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  152
; BASE  .MCD [242,1110]      RTI and RTT

				;6565	=
				;6566	
;6567	.NOBIN
;6568	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  153
; BASE  .MCD [242,1110]      RTS

;6569		.TOC	"			RTS"
;6570	
;6571	;
;6572	;	PC	<-- RDST
;6573	;	RDST	<-- (SP)+
;6574	;
;6575	; If RDST = PC, this simplifies to:
;6576	;
;6577	;	RDST	<-- (SP)+
;6578	;
;6579	; Because RTS PC is frequently used, this special case is optimized.
;6580	;
;6581	
				;6582	.BIN
				;6583	
				;6584	RTS:
				;6585	=10********0	; Breakout RTS for R0 - R3.
U 2524, 0020,0003,3740,0200	;6586	PLA0	[^0 111 111, ^0 000 000 010 000 0XX]
				;6587		MOV.W	[RDST, PC],		; Move link register to PC.
U 2525, 0000,1561,6327,1224	;6588				NAF/RTS4	; Join common code.
				;6589	=
				;6590	=10********0	; Breakout RTS for R4 - R5.
U 2526, 0020,0001,3740,0204	;6591	PLA0	[^0 111 111, ^0 000 000 010 000 10X]
				;6592		MOV.W	[RDST, PC],		; Move link register to PC.
U 2527, 0000,1561,6327,1224	;6593				NAF/RTS4	; Join common code.
				;6594	=
				;6595	=10********0	; Breakout RTS for R6.
U 2530, 0020,0000,3740,0206	;6596	PLA0	[^0 111 111, ^0 000 000 010 000 110]
				;6597		MOV.W	[RDST, PC],		; Move link register to PC.
U 2531, 0000,1561,6327,1224	;6598				NAF/RTS4	; Join common code.
				;6599	=
				;6600	RTS4:
				;6601		ARI.W	[SP],			; Relocate SP and increment.
				;6602			ODD TRAP,		; Must be a word address.
				;6603			LD MMR1,		; Record increment in MMR1.
U 1224, 0000,0700,7366,1225	;6604				NAF/RTS6	; Join common code.
				;6605	
				;6606	=10********0	; Breakout RTS for PC.
U 2532, 0020,0000,3740,0207	;6607	PLA0	[^0 111 111, ^0 000 000 010 000 111]
				;6608		ARI.W	[SP],			; Relocate SP and increment.
				;6609			ODD TRAP,		; Must be a word address.
				;6610			LD MMR1,		; Record increment in MMR1.
U 2533, 0000,0700,7366,1225	;6611				NAF/RTS6	; Join common code.
				;6612	=
				;6613	RTS6:
				;6614		RD.W	[RDST],			; Pop stack to link register or PC.
U 1225, 0000,0321,7746,0044	;6615				NAF/RE-SYNC	; Resychronize after asserting MKPB-L.
				;6616	
;6617	.NOBIN
;6618	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  154
; BASE  .MCD [242,1110]      BPT, IOT, EMT, and TRAP

;6619		.TOC	"			BPT, IOT, EMT, and TRAP"
;6620	
;6621	;
;6622	;	 PC	<-- (Vector)
;6623	;	 PS	<-- (Vector + 2)
;6624	;	-(SP)	<-- Old PS
;6625	;	-(SP)	<-- Old PC
;6626	;
;6627	
				;6628	.BIN
				;6629	
				;6630	BPT:		; Breakout BPT.
				;6631	=10********0
U 2534, 0020,0000,3740,0003	;6632	PLA0	[^0 111 111, ^0 000 000 000 000 011]
				;6633		LLD.L	[014, RA],		; Load vector address.
U 2535, 0000,0562,0632,1271	;6634				NAF/M-TRAP	; Join trap sequence at "Micro Trap".
				;6635	=
				;6636	IOT:		; Breakout IOT.
				;6637	=10********0
U 2536, 0020,0000,3740,0004	;6638	PLA0	[^0 111 111, ^0 000 000 000 000 100]
				;6639		LLD.L	[020, RA],		; Load vector address.
U 2537, 0000,0562,1032,1271	;6640				NAF/M-TRAP	; Join trap sequence at "Micro Trap".
				;6641	=
				;6642	EMT:		; Breakout EMT.
				;6643	=10********0
U 2540, 0020,0377,3750,4000	;6644	PLA0	[^0 111 111, ^1 000 100 0XX XXX XXX]
				;6645		LLD.L	[030, RA],		; Load vector address.
U 2541, 0000,0562,1432,1271	;6646				NAF/M-TRAP	; Join trap sequence at "Micro Trap".
				;6647	=
				;6648	TRAP:		; Breakout TRAP.
				;6649	=10********0
U 2542, 0020,0377,3750,4400	;6650	PLA0	[^0 111 111, ^1 000 100 1XX XXX XXX]
				;6651		LLD.L	[034, RA],		; Load vector address.
U 2543, 0000,0562,1632,1271	;6652				NAF/M-TRAP	; Join trap sequence at "Micro Trap".
				;6653	=
				;6654	
;6655	.NOBIN
;6656	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  155
; BASE  .MCD [242,1110]      CCC, SCC, and NOP

;6657		.TOC	"			CCC, SCC, and NOP"
;6658	
;6659	;
;6660	; CCC and NOP:
;6661	;
;6662	;	PS<3:0>	<-- PS<3:0> AND -IR<3:0>
;6663	;
;6664	; SCC:
;6665	;
;6666	;	PS<3:0>	<-- PS<3:0> OR IR<3:0>
;6667	;
;6668	
				;6669	.BIN
				;6670	
				;6671	CCC-SCC-NOP:	; Breakout CCC, SCC, and NOP.
				;6672	=10********0
U 2544, 0020,0037,3740,0240	;6673	PLA0	[^0 111 111, ^0 000 000 010 1XX XXX]
U 2545, 0000,1567,6072,1226	;6674		MOV.B	[IRFE, RA]		; Move IR<7:0> to scratch.
				;6675	=
				;6676		LAND.B	[017, RA],		; Save only IR<3:0>.
U 1226, 0000,0516,0772,0430	;6677				NAF/P.XCC	; Breakout for BIC/BIS.
				;6678	
				;6679	=10********0	; Now breakout CCC and NOP only.
U 2546, 0020,0017,1400,0240	;6680	NPLA0	[P.XCC, ^0 000 000 010 10X XXX]
				;6681		BIC.B	[RA, PS],		; Do AND -IR<3:0>.  For NOP, IR<3:0> = 0.
				;6682			PREFETCH,		; Read future I-stream word.
U 2547, 0000,1556,7500,0477	;6683				NAF/ID1		; Decode next instruction.
				;6684	=
				;6685	=10********0	; Breakout SCC only.
U 2550, 0020,0017,1400,0260	;6686	NPLA0	[P.XCC, ^0 000 000 010 11X XXX]
				;6687		BIS.B	[RA, PS],		; Do OR IR<3:0>.
				;6688			PREFETCH,		; Read future I-stream word.
U 2551, 0000,1576,7500,0477	;6689				NAF/ID1		; Decode next instruction.
				;6690	=
				;6691	
;6692	.NOBIN
;6693	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  156
; BASE  .MCD [242,1110]      MARK

;6694		.TOC	"			MARK"
;6695	
;6696	;
;6697	;	SP	<-- PC + 2 * NN,
;6698	;			where NN = IR<5:0>
;6699	;	PC	<-- R5
;6700	;	R5	<-- (SP)+
;6701	;
;6702	
				;6703	.BIN
				;6704	
				;6705	MARK:		; Breakout MARK.
				;6706	=10********0
U 2552, 0020,0077,3740,6400	;6707	PLA0	[^0 111 111, ^0 000 110 100 XXX XXX]
U 2553, 0000,1041,7532,1227	;6708		CLR.W	[RA, RA]		; Initialize scratch to zero.
				;6709	=
U 1227, 0000,1237,6072,1230	;6710		ASL.B	[IRFE, RA]		; Calulate 2 * IR<5:0>.  Note that RA<7> = 0.
				;6711	
U 1230, 0000,1441,7372,1231	;6712		ADD.W	[PC, RA]		; Calulate new SP value.  RA is used so
				;6713						;  that an MMU abort still has old SP.
				;6714	
U 1231, 0000,1561,7267,1232	;6715		MOV.W	[R5, PC]		; Update PC.  MMR2 has old PC.
				;6716	
				;6717		ARI.W	[RA],			; Relocate SP and increment for pop.
U 1232, 0000,0701,7372,1233	;6718			ODD TRAP		; The calculated SP is even anyways.
				;6719	
U 1233, 0000,0321,7765,1234	;6720		RD.W	[R5]			; Read (SP)+ to R5.
				;6721	
				;6722		MOV.W	[RA, SP],		; Now update SP if no abort.
U 1234, 0000,1561,7526,0044	;6723				NAF/RE-SYNC	; Go resynchronize.
				;6724						; RE-SYNC aborts to ROM[040] as required.
				;6725	
;6726	.NOBIN
;6727	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  157
; BASE  .MCD [242,1110]      RESET

;6728		.TOC	"			RESET"
;6729	
;6730	;
;6731	; If Kernel Mode:
;6732	;
;6733	;	Asserts BINIT L on Q-bus for a minimum of 10 microseconds, and
;6734	;	deasserts BINIT L for a minimum of 90 microseconds.
;6735	;	Clears MMR0 and MMR3.
;6736	;	Resynchronizes prefetch pipeline.
;6737	;
;6738	; If not Kernel Mode:
;6739	;
;6740	;	No operation.
;6741	;
;6742	; Method:
;6743	;
;6744	;	Calls a subroutine which is also used at "Power Up".
;6745	;
;6746	
				;6747	.BIN
				;6748	
				;6749	RESET:		; Breakout RESET instruction.
				;6750	=10********0
U 2554, 0020,0000,3740,0005	;6751	PLA0	[^0 111 111, ^0 000 000 000 000 101]
U 2555, 0000,0160,1537,1235	;6752		JKM	[RESET-SUB]		; Test for Kernel Mode.
				;6753	=
				;6754	
				;6755	;This next address is constrained to this address so that it will
				;6756	;not change from assembly to assembly.  This is a return point from
				;6757	;other chips.
				;6758	
				;6759	1235:
				;6760	RESET-NOP:				; For MTPS and SPL, wait for Control chip.
				;6761		LMSTK	[NOP-PF, RF],		; Set up return address from RESET-SUB.
U 1235, 0000,0536,3777,1477	;6762				NAF/NOP-PF	; For not Kernel Mode, treat as NOP.
				;6763	;RESET-SUB:
				;6764	;	AWG.W	[BINIT_ON]		; Assert BINIT L next cycle.
				;6765	;
				;6766	;1500:					; For TUMS use only.
				;6767	;	LCNTR.W	[105, RA],		; Load CNTR for 10 us wait (69.).
				;6768	;			NAF/RESET1	; Start wait loop.  Skip next instruction.
				;6769	;
				;6770	;=0					; Constrain NAF for CNTR loop.
				;6771	;	AWG.W	[BINIT_OFF],		; Deassert BINIT L next cycle.
				;6772	;			NAF/RESET2	; Go turn off BINIT L.  Skip next instruction.
				;6773	;RESET1:
				;6774	;	CLR.W	[RA, RA],		; Clear EU register for OUTR.
				;6775	;		DECR CNTR,		; Loop here for a while.
				;6776	;			NAF/RESET1	; Go back one when done.
				;6777	;=
				;6778	;1501:					; For TUMS use only.
				;6779	;RESET2:
				;6780	;	LCNTR.W	[310, RB],		; Load CNTR for 90 us wait (200.).
				;6781	;			NAF/RESET3	; Skip past next instruction.
				;6782	;
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  158
; BASE  .MCD [242,1110]      RESET

				;6783	;=0					; Constrain NAF for CNTR loop.
				;6784	;	LLCM.W	[005, RE],		; RE <-- 177772, PIRQ.
				;6785	;			NAF/RESET4	; Skip over loop.
				;6786	;RESET3:
				;6787	;	OUTR.W	[MMR0, RA]		; Clear MMR0.
				;6788	;=
				;6789	;	OUTR.W	[MMR3, RA]		; Clear MMR3.
				;6790	;
				;6791	;	MOV.W	[PC, PC],		; Clear PPCV since MMU gets turned off.
				;6792	;		DECR CNTR,		; Decrement the loop counter.
				;6793	;			NAF/RESET3	; Loop on three microinstructions.
				;6794	;RESET4:
				;6795	;	AW	[RE],			; Stuff PIRQ address into OL.  MMU is off.
				;6796	;			NAF/RESET5	; Write a zero to PIRQ.
				;6797	;
				;6798	;=0*0****0				; Abort to ROM[0] for ODT I/O routines.
				;6799	;RESET5:				; Return from print loop in ODT.
				;6800	;	CLR.W	[RA, RA],		; For RESET-SUB, clear PIRQ in all chips.
				;6801	;			NAF/240		; For RESET-SUB, abort to ROM[MSTK AND 240].
				;6802	;					; For SI power up, abort to ROM[240].
				;6803	;					; For ODT, save code; return.
				;6804	
				;6805	;1477:					; Must be overridable to ID1 (477).
				;6806	;NOP-PF:				;  Must also abort to ROM[40].
				;6807	;	NOP.W	[RF, PS],		; Do nothing, but allow Predecode to write
				;6808	;					;  IR on A-bus<31:16> from Prefetch Buffer.
				;6809	;		PREFETCH,		; Initiate a Prefetch request cycle now
				;6810	;					;  that all other bus cycles are completed.
				;6811	;			NAF/ID1		; Initiate Predecode.  See "ID1 Q-Logic Next
				;6812	;					;  Addresses" for possible NAs.
				;6813	
;6814	.NOBIN
;6815	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  159
; BASE  .MCD [242,1110]      HALT

;6816		.TOC	"			HALT"
;6817	
;6818	;
;6819	; If Kernel Mode:
;6820	;
;6821	;	If POKH not asserted, start Power Up sequence.
;6822	;	(Probably end of Power Down Routine.)
;6823	;
;6824	;	If POKH is asserted, test HALT option:
;6825	;
;6826	;	Option		Result
;6827	;	------		------
;6828	;	  0		Go to MICRO-ODT.
;6829	;	  1		Vector through 4.
;6830	;
;6831	; If not Kernel Mode, set CPU Error Register<7> and vector through 4.
;6832	;
;6833	
				;6834	.BIN
				;6835	
				;6836	HALT:		; Breakout HALT.
				;6837	=10********0
U 2556, 0020,0000,3740,0000	;6838	PLA0	[^0 111 111, ^0 000 000 000 000 000]
U 2557, 0000,0630,0037,1236	;6839		ARG.W	[OPTIONS]		; Read in POKH and options from SI.
				;6840	=
U 1236, 0000,0361,7777,1237	;6841		RDG.W	[RF]			; Stuff it into RF.
				;6842	
U 1237, 0000,0271,6777,1240	;6843		OUTS	[LD_PIR, RF]		; Now stuff it into PIR.
				;6844	
U 1240, 0000,0162,0777,1241	;6845		JKM	[417]			; Now test for Kernel Mode.
				;6846	
U 1241, 0000,0561,0012,1242	;6847		LLD.W	[200, RA.H]		; Prepare to set CPU Error Register<7>.
				;6848						; For Kernel Mode, go to H-POKH-X.
				;6849	
				;6850		LMSTK	[M-TRAP, RB],		; For not Kernel, set CPU Error Register<7>
U 1242, 0000,0535,3473,1265	;6851				NAF/SET-CPU	;  then vector through 4 at M-TRAP.
				;6852	
				;6853	H-POKH-F:	; POKH is not asserted.
				;6854	;POWER-UP:	; ABFF<0> = 0.  Power up.
				;6855	;=10********0
				;6856	;PLA0	[^0 00X 111, ^X XXX XXX XXX XXX XX0]
				;6857	;	LMSTK	[P-U-T1, RA],		; Set up return to do Power Up Test.
				;6858	;			NAF/PWR-UP-ODT	; Go to "Power Up" sequence.
				;6859	;=
				;6860	H-POKH-T0:	; POKH is asserted and HALT option 0.
				;6861	=10********0
U 2560, 0037,7766,0740,0001	;6862	PLA0	[^0 001 111, ^X XXX XXX XXX XX0 XX1]
				;6863		NOP.W	[RF, RF],		; Nothing to be done.
U 2561, 0000,1771,7777,1317	;6864				NAF/ENTER-ODT	; Go to standard ODT entry.
				;6865	=
				;6866	H-POKH-T1:	; POKH is asserted and HALT option 1.
				;6867	=10********0
U 2562, 0037,7766,0740,0011	;6868	PLA0	[^0 001 111, ^X XXX XXX XXX XX1 XX1]
				;6869		LMSTK	[M-TRAP, RB],		; For option 1, set CPU Error Register
U 2563, 0000,0535,3473,1265	;6870				NAF/SET-CPU	;  then vector through 4 at M-TRAP.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  160
; BASE  .MCD [242,1110]      HALT

				;6871	=
				;6872	
;6873	.NOBIN
;6874	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  161
; BASE  .MCD [242,1110]      MFPT

;6875		.TOC	"			MFPT"
;6876	
;6877	;
;6878	;	MFPT (Move From Processor Type) loads the constant 5 into R0.
;6879	;
;6880	
				;6881	.BIN
				;6882	
				;6883	MFPT:		; Breakout MFPT.
				;6884	=10********0
U 2564, 0020,0000,3740,0007	;6885	PLA0	[^0 111 111, ^0 000 000 000 000 111]
				;6886		LLD.W	[005, R0],		; Load 5 into R0.
U 2565, 0000,0560,0260,1477	;6887				NAF/NOP-PF	; Go pipeline.
				;6888	=
				;6889	;1477:					; Must be overridable to ID1 (477).
				;6890	;NOP-PF:				;  Must also abort to ROM[40].
				;6891	;	NOP.W	[RF, PS],		; Do nothing, but allow Predecode to write
				;6892	;					;  IR on A-bus<31:16> from Prefetch Buffer.
				;6893	;		PREFETCH,		; Initiate a Prefetch request cycle now
				;6894	;					;  that all other bus cycles are completed.
				;6895	;			NAF/ID1		; Initiate Predecode.  See "ID1 Q-Logic Next
				;6896	;					;  Addresses" for possible NAs.
				;6897	
;6898	.NOBIN
;6899	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  162
; BASE  .MCD [242,1110]      SPL

;6900		.TOC	"			SPL"
;6901	
;6902	;
;6903	; If Kernel Mode:
;6904	;
;6905	;	PS<7:5>	<-- IR<2:0>
;6906	;	Interrupts are not checked until new priority has stabilized.
;6907	;
;6908	; If not Kernel Mode:
;6909	;
;6910	;	No operation.
;6911	;
;6912	
				;6913	.BIN
				;6914	
				;6915	SPL:		; Breakout SPL.
				;6916	=10********0
U 2566, 0020,0007,3740,0230	;6917	PLA0	[^0 111 111, ^0 000 000 010 011 XXX]
				;6918		JKM	[SPL-KM],		; Test for Kernel Mode.
U 2567, 0000,0165,2177,1235	;6919				NAF/RESET-NOP	; Wait for pipelined jump.
				;6920	=
				;6921	;RESET-NOP:				; For MTPS and SPL, wait for Control chip.
				;6922	;	LMSTK	[NOP-PF, RF],		; Set up return address from RESET-SUB.
				;6923	;			NAF/NOP-PF	; For not Kernel Mode, treat as NOP.
				;6924	SPL-KM:
				;6925		LBIC.B	[340, PS],		; Clear out old priority, PS<7:5>.
U 1243, 0000,0557,6000,0534	;6926				NAF/534		; Transfer PIR<2:0> to PS<7:5>.
				;6927	
				;6928	SPL-KM1:	; Default for EXTRX-X overrides.
				;6929	=10********0
U 2570, 0037,7777,5600,0000	;6930	PLA0	[^1 011 100, ^X]
				;6931		LBIS.B	[340, PS],		; Set those bits not masked out.
U 2571, 0000,0577,6000,0011	;6932				NAF/PSW-LD-PF	; Join common code.
				;6933	=
				;6934	;EXTR0-0:	; Override on 0 in PIR<5> and PIR<0>.
				;6935	;=10********0
				;6936	;PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX XX0]
				;6937	;	LBIS.B	[336, RF],		; Override literal<5,0> (SPL, ASHX).
				;6938	;			NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;6939	;=
				;6940	;EXTR0-1:	; Override on 0 in PIR<5> and PIR<1>.
				;6941	;=10********0
				;6942	;PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX X0X]
				;6943	;	LBIS.B	[275, RF],		; Override literal<6,1> (SPL, ASHX).
				;6944	;			NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;6945	;=
				;6946	;EXTR0-2:	; Override on 0 in PIR<5> and PIR<2>.
				;6947	;=10********0
				;6948	;PLA0	[^1 011 1XX, ^X XXX XXX XXX 0XX 0XX]
				;6949	;	LBIS.B	[173, RF],		; Override literal<7,2> (SPL, ASHX).
				;6950	;			NAF/1775	; Override NAF<1> for left shift (ASH and ASHC).
				;6951	;=
				;6952	;=0*					; Must not be overridden for SPL.
				;6953	;PSW-LD-PF:
				;6954	;	OUTS	[PSW, PS],		; Update new Control chip PS<7:5>
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  163
; BASE  .MCD [242,1110]      SPL

				;6955	;			NAF/RESET-NOP	;  to arbitrate interrupt priority.
				;6956	;=
				;6957	;RESET-NOP:				; For MTPS and SPL, wait for Control chip.
				;6958	;	LMSTK	[NOP-PF, RF],		; Set up return address from RESET-SUB.
				;6959	;			NAF/NOP-PF	; For not Kernel Mode, treat as NOP.
				;6960	
;6961	.NOBIN
;6962	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  164
; BASE  .MCD [242,1110]      CIS Breakout

;6963		.TOC	"			CIS Breakout"
;6964	
;6965	;
;6966	;	All CIS instructions go to Control chip 3 for initial processing.
;6967	;	WCS (Writable Control Store) opcodes go to Control chip 1.
;6968	;
;6969	;	If CIS1 is not present in the system, Control chip 0 will re-assert
;6970	;	CSEL and force a jump to ROM[1].  In turn, ROM[1] forces an Illegal
;6971	;	Instruction Trap.
;6972	;
;6973	
				;6974	.BIN
				;6975	
				;6976	CIS:		; Breakout CIS or WCS Opcodes.
				;6977	=10********0
U 2572, 0020,0777,3747,6000	;6978	PLA0	[^0 111 111, ^0 111 110 XXX XXX XXX]
				;6979		JMP	[400, CIS1],		; Jump to Control chip 3, NA = 400.
U 2573, 0000,0002,0003,1777	;6980				NAF/1777	; CIS1 can be overwridden by WCS.
				;6981	=
				;6982	WCS:		; Breakout WCS Opcodes only.
				;6983	=10********0
U 2574, 0020,0077,3747,6700	;6984	PLA0	[^0 111 111, ^0 111 110 111 XXX XXX]
				;6985		JMP	[400, WCS],		; Jump to Control chip 1, NA = 400.
U 2575, 0000,0002,0001,1777	;6986				NAF/1777	; Override CIS1 to WCS.
				;6987	=
				;6988	
;6989	.NOBIN
;6990	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  165
; BASE  .MCD [242,1110]      Illegal Instructions

;6991		.TOC	"			Illegal Instructions"
;6992	
;6993	;
;6994	;	Both illegal instruction routines are included here.
;6995	;	Illegal instructions trap through vector 10.
;6996	;
;6997	;	ROM[1] services jumps to Control chips which don't answer back
;6998	;	by asserting CSEL.
;6999	;
;7000	;	ROM[1777] services PLA translations when no PLA turn on.  This will
;7001	;	occur at ID1 when an illegal instruction is executed.
;7002	;
;7003	
				;7004	.BIN
				;7005	
				;7006	1:					; ROM address is fixed by Control chip hardware.
				;7007		LLD.L	[010, RA],		; Load trap vector to scratch.
U 0001, 0000,0562,0432,1271	;7008				NAF/M-TRAP	; Join trap code at "Micro Trap".
				;7009	
				;7010	1777:					; NAF out of PLA was all ones.
				;7011		LLD.L	[010, RA],		; Load trap vector to scratch.
U 1777, 0000,0562,0432,1271	;7012				NAF/M-TRAP	; Join trap code at "Micro Trap".
				;7013	
;7014	.NOBIN
;7015	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  166
; BASE  .MCD [242,1110]      WAIT

;7016		.TOC	"			WAIT"
;7017	
;7018	;
;7019	;	The WAIT instruction effectively suspends processor execution until a
;7020	;	service condition becomes true.  At the micro level, the processor
;7021	;	simply continuously loads service information until a service flop
;7022	;	becomes asserted.
;7023	;
;7024	;	This code first loads the interrupt service information into the PIR,
;7025	;	then calls the "Interrupt Service Decode" PLAs as a subroutine.  If no
;7026	;	interrupt is serviced, it returns here and trys again.
;7027	;
;7028	
				;7029	.BIN
				;7030	
				;7031	WAIT:		; Breakout WAIT.
				;7032	=10********0
U 2576, 0020,0000,3740,0001	;7033	PLA0	[^0 111 111, ^0 000 000 000 000 001]
U 2577, 0000,0271,7737,1244	;7034		OUTS	[INTERRUPTS]		; Load interrupt service info to PIR.
				;7035	=
				;7036	WAIT1:					; Set up return if no interrupt pending.
				;7037		LMSTK	[WAIT2, RA],		; For hardware interrupt, set up abort return.
U 1244, 0000,0535,2272,0424	;7038				NAF/P.ISD	; Invoke "Interrupt Service Decode" PLAs.
				;7039	
				;7040	WAIT2:					; Return here if no interrupt pending
				;7041						;  or on abort from RDINTR.
				;7042		OUTS	[INTERRUPTS],		; Load interrupt service info into PIR.
U 1245, 0000,0271,7737,1244	;7043				NAF/WAIT1	; Continue looping.
				;7044	
;7045	.NOBIN
;7046	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  167
; BASE  .MCD [242,1110]      Interrupt Service Decode

;7047		.TOC	"		Interrupt Service Decode"
;7048	
;7049	;
;7050	;	ID1SVC is an input to the Q-Logic.  ID1SVC is defined by the equation:
;7051	;
;7052	;	ID1SVC = (PTYFF + ITFF + ISOVFF + PWRFF + HLTFF + FPEFF +
;7053	;		  acknowledged interrupts).-SSFF
;7054	;
;7055	;	where "acknowledged interrupts" refers to pending interrupts not blocked
;7056	;	by the Interrupt Blocking Logic.  If ID1SVC is true at ID1 or IRDF, the
;7057	;	Q-Logic zeroes NA<5:0> bringing the microcode to address 400 in PLA Bank 0.
;7058	;
;7059	; Entry Conditions:
;7060	;
;7061	;	NA = 400, the Q-Logic zeroed NA<5:0>.
;7062	;
;7063	; Exit Conditions:
;7064	;
;7065	;	NAF = M-TRAP, M-TRAP1, or M-TRAP2 to finish interrupt sequence.
;7066	;
;7067	; Method:
;7068	;
;7069	;	The interrupt flip-flops are loaded into the PIR and decoded.
;7070	;
;7071	
				;7072	.BIN
				;7073	
				;7074	INTERRUPT:	; Breakout interrupt service address.
				;7075	=10********0
U 2600, 0037,7777,0000,0000	;7076	PLA0	[^0 000 000, ^X]
U 2601, 0000,0271,7737,1246	;7077		OUTS	[INTERRUPTS]		; Load interrupt service flops into PIR.
				;7078	=
				;7079						; Set up return if no interrupt still pending.
				;7080		LMSTK	[440, RA],		; For hardware interrupt, set up abort return.
U 1246, 0000,0532,2032,0424	;7081				NAF/P.ISD	; Invoke PLA decode of interrupts.
				;7082	
				;7083	PARITY:		; Detect PTYFF, Parity Error.
				;7084	=10********0
U 2602, 0027,7777,1210,0000	;7085	NPLA0	[P.ISD, ^1 XXX XXX XXX XXX XXX]
U 2603, 0000,0260,7777,1247	;7086		OUTC	[CLR_PTYFF]		; Clear the Parity Error flop.
				;7087	=
U 1247, 0000,0670,2037,1250	;7088		AWG.W	[NMI_ACK]		; Acknowledge NMI emulation.
				;7089	
				;7090		LLD.L	[114, RA],		; Vector through 114.
U 1250, 0000,0562,4632,1273	;7091				NAF/M-TRAP2	; M-TRAP entry for infinite loop class.
				;7092	
				;7093	T-BIT:		; Detect ITFF, Trace Trap.
				;7094	=10********0
U 2604, 0027,5777,1200,2000	;7095	NPLA0	[P.ISD, ^0 XXX X1X XXX XXX XXX]
				;7096		LLD.L	[014, RA],		; Vector through 14.  M-TRAP resets ITFF.
U 2605, 0000,0562,0632,1273	;7097				NAF/M-TRAP2	; M-TRAP entry for infinite loop class.
				;7098	=
				;7099	STACK-OVF:	; Detect SOVFF, Stack Overflow.
				;7100	=10********0
U 2606, 0027,4777,1200,1000	;7101	NPLA0	[P.ISD, ^0 XXX X01 XXX XXX XXX]
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  168
; BASE  .MCD [242,1110]      Interrupt Service Decode

U 2607, 0000,0560,0412,1251	;7102		LLD.W	[010, RA.H]		; Prepare to set CPU Error Register<3>.
				;7103	=
				;7104	
				;7105	;This next address is constrained to this address so that it will
				;7106	;not change from assembly to assembly.  This is a return point from
				;7107	;other chips.
				;7108	
				;7109	1251:
				;7110	OVF-SET-CPU:
				;7111		LMSTK	[M-TRAP1, RB],		; Set the CPU Error Register then enter
U 1251, 0000,0535,3533,1265	;7112				NAF/SET-CPU	;  M-TRAP at special entry point.
				;7113	
				;7114	POWER-FAIL:	; Detect PWRFF, Power Fail.
				;7115	=10********0
U 2610, 0023,4777,1204,0000	;7116	NPLA0	[P.ISD, ^0 1XX X00 XXX XXX XXX]
U 2611, 0000,0670,6037,1253	;7117		AWG.W	[PWRF_ACK]		; Clear PWRFF on CPU Board next cycle.
				;7118	=
				;7119		LLD.W	[024, RA],		; Vector through 24.
U 1253, 0000,0560,1232,1271	;7120				NAF/M-TRAP	; Go to normal M-TRAP entry.
				;7121	
				;7122	FPA-EX:		; Detect FPEFF, Floating Point exeception.
				;7123	=10********0
U 2612, 0023,0777,1200,4000	;7124	NPLA0	[P.ISD, ^0 0XX 100 XXX XXX XXX]
U 2613, 0000,0630,0177,1254	;7125		ARG.W	[FPA_ACK]		; Shove GP code into Output Latch.
				;7126	=
U 1254, 0000,0361,7770,1255	;7127		RDG.W	[R8]			; Read FEC and acknowledge interrupt.
				;7128	
U 1255, 0000,0510,0750,1256	;7129		LAND.W	[017, R8.H]		; Mask off input garbage and move to
				;7130						; R8.H.
				;7131	
U 1256, 0000,0210,6670,1257	;7132		INPR.W	[FEATMP, R8]		; Get PC of last instruction.
				;7133	
U 1257, 0000,0410,0130,1260	;7134		LSUB.W	[002, R8]		; Compensate for instruction fetch.
				;7135	
				;7136		INPR.W	[FPS, RA],		; Get FPS for FID check.
U 1260, 0000,0210,2732,1756	;7137				NAF/FP-TRAP	; Join "Trap handler" in FP11.
				;7138	
				;7139	PIRQ-L7:	; Detect Programmable Interrupt Request Level 7.
				;7140	=10********0
U 2614, 0023,0757,1200,0020	;7141	NPLA0	[P.ISD, ^0 0XX 000 XXX X1X XXX]
				;7142		LLD.L	[240, RA],		; Vector through 240.
U 2615, 0000,0563,2032,1273	;7143				NAF/M-TRAP2	; M-TRAP entry for infinite loop class.
				;7144	=
				;7145	IRQ-L7:		; Detect Hardware Interrupt Request Level 7.
				;7146	=10********0
U 2616, 0023,0357,1200,0400	;7147	NPLA0	[P.ISD, ^0 0XX 000 1XX X0X XXX]
				;7148		ARG.W	[IRL7],			; Shove GP to Output Latch.
U 2617, 0000,0630,0437,1262	;7149				NAF/IREQ	; Join common code below.
				;7150	=
				;7151	PIRQ-L6:	; Detect Programmable Interrupt Request Level 6.
				;7152	=10********0
U 2620, 0023,0347,1200,0010	;7153	NPLA0	[P.ISD, ^0 0XX 000 0XX X01 XXX]
				;7154		LLD.L	[240, RA],		; Vector through 240.
U 2621, 0000,0563,2032,1273	;7155				NAF/M-TRAP2	; M-TRAP entry for infinite loop class.
				;7156	=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  169
; BASE  .MCD [242,1110]      Interrupt Service Decode

				;7157	EVENT:		; Detect MEVENT-L, line time clock interrupt.
				;7158	=10********0
U 2622, 0021,0347,1202,0000	;7159	NPLA0	[P.ISD, ^0 01X 000 0XX X00 XXX]
U 2623, 0000,0670,4037,1261	;7160		AWG.W	[BEVNT_ACK]		; Shove GP to Output Latch.
				;7161	=
				;7162		LLD.W	[100, RA],		; Load vector address and finish write.
U 1261, 0000,0560,4032,1271	;7163				NAF/M-TRAP	; Go to normal M-TRAP entry.
				;7164	
				;7165	IRQ-L6:		; Detect Hardware Interrupt Request Level 6.
				;7166	=10********0
U 2624, 0021,0147,1200,0200	;7167	NPLA0	[P.ISD, ^0 00X 000 01X X00 XXX]
				;7168		ARG.W	[IRL6],			; Shove GP to Output Latch.
U 2625, 0000,0630,0237,1262	;7169				NAF/IREQ	; Join common code below.
				;7170	=
				;7171	PIRQ-L5:	; Detect Programmable Interrupt Request Level 5.
				;7172	=10********0
U 2626, 0021,0143,1200,0004	;7173	NPLA0	[P.ISD, ^0 00X 000 00X X00 1XX]
				;7174		LLD.L	[240, RA],		; Vector through 240.
U 2627, 0000,0563,2032,1273	;7175				NAF/M-TRAP2	; M-TRAP entry for infinite loop class.
				;7176	=
				;7177	IRQ-L5:		; Detect Hardware Interrupt Request Level 5.
				;7178	=10********0
U 2630, 0021,0043,1200,0100	;7179	NPLA0	[P.ISD, ^0 00X 000 001 X00 0XX]
				;7180		ARG.W	[IRL5],			; Shove GP to Output Latch.
U 2631, 0000,0630,0137,1262	;7181				NAF/IREQ	; Join common code below.
				;7182	=
				;7183	PIRQ-L4:	; Detect Programmable Interrupt Request Level 4.
				;7184	=10********0
U 2632, 0021,0041,1200,0002	;7185	NPLA0	[P.ISD, ^0 00X 000 000 X00 01X]
				;7186		LLD.L	[240, RA],		; Vector through 240.
U 2633, 0000,0563,2032,1273	;7187				NAF/M-TRAP2	; M-TRAP entry for infinite loop class.
				;7188	=
				;7189	IRQ-L4:		; Detect Hardware Interrupt Request Level 4.
				;7190	=10********0
U 2634, 0021,0001,1200,0040	;7191	NPLA0	[P.ISD, ^0 00X 000 000 100 00X]
U 2635, 0000,0630,0077,1262	;7192		ARG.W	[IRL4]			; Shove GP to Output Latch.
				;7193	=
				;7194	IREQ:
				;7195		RDINTR	[RA],			; Read Interrupt Vector from device.
U 1262, 0000,0371,7772,1271	;7196				NAF/M-TRAP	; Go to normal M-TRAP entry.
				;7197	
				;7198	PIRQ-L3-1:	; Detect Programmable Interrupt Request Levels 3-1.
				;7199	=10********0
U 2636, 0021,0000,1200,0001	;7200	NPLA0	[P.ISD, ^0 00X 000 000 000 001]
				;7201		LLD.L	[240, RA],		; Vector through 240.
U 2637, 0000,0563,2032,1273	;7202				NAF/M-TRAP2	; M-TRAP entry for infinite loop class.
				;7203	=
				;7204	HALT-LINE:	; Detect HLTFF, Halt Line.
				;7205	=10********0
U 2640, 0020,0000,1201,0000	;7206	NPLA0	[P.ISD, ^0 001 000 000 000 000]
				;7207		NOP.W	[RF, RF],		; Nothing to be done.
U 2641, 0000,1771,7777,1317	;7208				NAF/ENTER-ODT	; Go to console emulator.
				;7209	=
				;7210	NO-INT:		; Check for interrupt removed.
				;7211	=10********0
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  170
; BASE  .MCD [242,1110]      Interrupt Service Decode

U 2642, 0020,0000,1200,0000	;7212	NPLA0	[P.ISD, ^0 000 000 000 000 000]
				;7213		NOP.W	[RF, RF],		; For interrupt service, return to
U 2643, 0000,1771,7777,0777	;7214				NAF/RFS		;  440 to resynchronize.
				;7215	=					; For WAIT, return to WAIT2.
				;7216	
;7217	.NOBIN
;7218	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  171
; BASE  .MCD [242,1110]      Abort Service Decode

;7219		.TOC	"	Abort Service Decode"
;7220	
;7221	;
;7222	;	When an abort occurs due to an MMU relocation error, or bus-timeout,
;7223	;	the microcode is forced to one of four ROM addresses.  Specifically,
;7224	;	bits<9:8,6,4:0> of the NA generated by the microinstruction
;7225	;	following the demand read or write are zeroed.  By microcode
;7226	;	convention, the abort addresses are used as follows:
;7227	;
;7228	;	  000		Multiple Abort, Power Up, and ODT
;7229	;	  040		Base Code Abort
;7230	;	  200		Floating Point
;7231	;	  240		General Purpose Abort Return
;7232	;
;7233	;	A Multiple Abort as defined here is an abort which occurs while
;7234	;	servicing a trap, interrupt, or abort service at "Micro Trap".
;7235	;
;7236	;	The Power Up routine is not included here.  It occurs first in the
;7237	;	microcode listing.
;7238	;
;7239	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  172
; BASE  .MCD [242,1110]      Base Code Abort

;7240		.TOC	"		Base Code Abort"
;7241	
;7242	;
;7243	; Entry Conditions:
;7244	;
;7245	;	NA = 040; NA was zeroed by Abort Logic.
;7246	;
;7247	; Exit Conditions:
;7248	;
;7249	;	NAF = ID1 (477)
;7250	;
;7251	; Method:
;7252	;
;7253	;	The Abort Service information is loaded into the PIR.  Internal
;7254	;	synchronous interrupt flip-flops are cleared as the macroinstruction
;7255	;	never completed execution.  Aborts which vector through location 4
;7256	;	update the CPU Error Register.
;7257	;
;7258	
				;7259	.BIN
				;7260	
				;7261	40:
				;7262	BASE-CODE-ABORT:
				;7263		LMSTK	[M-TRAP, RB],		; Set GET-VECTOR return address.
U 0040, 0000,0535,3473,1263	;7264				NAF/GET-VECTOR	; Call subroutine to get abort cause.
				;7265	
				;7266	; Subroutine to load vector and set CPU Error Register if applicable.
				;7267	; Called by:
				;7268	;	BASE-CODE-ABORT
				;7269	;	M-ABORT
				;7270	
				;7271	GET-VECTOR:				; Subroutine to load vector and set CPU Error.
U 1263, 0000,0271,7677,1264	;7272		OUTS	[ABORTS]		; PIR<4:0> <-- ABFF<4:0>.
				;7273	
				;7274		OUTC	[CLR_SVC_FFS],		; Clear SOVFF, PTYFF, SSFF, and ITFF.
				;7275						; Aborts load ITFF later.
U 1264, 0000,0260,1637,0404	;7276				NAF/P.ASD	; Decode Abort Service information.
				;7277	
				;7278	ADDR-ERROR:	; Odd address, internal register, etc.
				;7279	=10********0
U 2644, 0037,7753,0200,0024	;7280	NPLA0	[P.ASD, ^X XXX XXX XXX X1X 1XX]
				;7281		LLD.W	[100, RA.H],		; Prepare to set CPU Error Register<6>.
U 2645, 0000,0560,4012,1265	;7282				NAF/SET-CPU	; Join common code below.
				;7283	=
				;7284	MMU-ABORT:	; Non-resident, page length, read only.
				;7285	=10********0
U 2646, 0037,7753,0200,0020	;7286	NPLA0	[P.ASD, ^X XXX XXX XXX X1X 0XX]
				;7287		LLD.L	[250, RA],		; Vector through 250.
U 2647, 0000,0563,2432,0777	;7288				NAF/RFS		; Return from GET-VECTOR.
				;7289	=
				;7290	NXM-ABORT:	; Non-existent memory.
				;7291	=10********0
U 2650, 0037,7745,0200,0000	;7292	NPLA0	[P.ASD, ^X XXX XXX XXX X00 X0X]
				;7293		LLD.W	[040, RA.H],		; Prepare to set CPU Error Register<5>.
U 2651, 0000,0560,2012,1265	;7294				NAF/SET-CPU	; Join common code below.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  173
; BASE  .MCD [242,1110]      Base Code Abort

				;7295	=
				;7296	IO-TIMEOUT:	; I/O bus timeout.
				;7297	=10********0
U 2652, 0037,7745,0200,0002	;7298	NPLA0	[P.ASD, ^X XXX XXX XXX X00 X1X]
				;7299		LLD.W	[020, RA.H],		; Prepare to set CPU Error Register<4>.
U 2653, 0000,0560,1012,1265	;7300				NAF/SET-CPU	; Join common code below.
				;7301	=
				;7302	PARITY-ABORT:	; Parity abort.
				;7303	=10********0
U 2654, 0037,7747,0200,0010	;7304	NPLA0	[P.ASD, ^X XXX XXX XXX X01 XXX]
				;7305		LLD.L	[114, RA],		; Vector through 114.
U 2655, 0000,0562,4632,0777	;7306				NAF/RFS		; Return from GET-VECTOR.
				;7307	=
				;7308	
				;7309	; Subroutine to set CPU Error Register and load vector address 4.
				;7310	; Continuation of:
				;7311	;	GET-VECTOR
				;7312	; Called by:
				;7313	;	HALT instruction
				;7314	;	SOVF interrupt service
				;7315	;	Red Zone Stack trap (KM-SP)
				;7316	; Entry Conditions:
				;7317	;	RA.H must contain error bit to set.
				;7318	
				;7319	SET-CPU:
U 1265, 0000,0210,6753,1266	;7320		INPR.W	[CPU, RB.H]		; RB <-- CPU Error Register.
				;7321	
U 1266, 0000,1571,6513,1267	;7322		BIS.W	[RA.H, RB.H]		; Set error bits in RB.
				;7323	
U 1267, 0000,0250,6753,1270	;7324		OUTR.W	[CPU, RB.H]		; CPU Error Register <-- RB.
				;7325	
				;7326		LLD.L	[004, RA],		; Vector through 4.
U 1270, 0000,0562,0232,0777	;7327				NAF/RFS		; Return to M-TRAP, M-TRAP1, or M-ABORT1.
				;7328	
;7329	.NOBIN
;7330	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  174
; BASE  .MCD [242,1110]      Micro Trap

;7331		.TOC	"		Micro Trap"
;7332	
;7333	;
;7334	; Entry Conditions:
;7335	;
;7336	;	RA<15:0> contains vector address.
;7337	;	Entered from aborts, traps, and interrupt service.
;7338	;
;7339	; Entry Points:
;7340	;
;7341	;	M-TRAP		Normal, no frills entry.
;7342	;	M-TRAP1		Clears SOVFF after stack pushes for Stack overflow and Red Zone Abort.
;7343	;	M-TRAP2		Checks HLTFF before exiting to stop sunset loops.
;7344	;
;7345	; Exit Points:
;7346	;
;7347	;	RE-SYNC		If vector sequence was successful.
;7348	;	MULTIPLE-ABORT	If abort occurs.
;7349	;
;7350	; Method:
;7351	;
;7352	;	The vector PC and PS are read, and if successful, a flag is set indicating this.  The newly
;7353	;	selected SP is saved temporarily.  The old PC and PS are pushed onto the new stack and if no
;7354	;	aborts occur, the Control chip PS and ITFF are set from the vector.  If servicing a Stack
;7355	;	Overflow or an Emergency Stack push, the SOVFF is cleared after the stack pushes.  If servicing
;7356	;	the T-bit, Parity error flop, or PIRQ, the Halt line is checked to prevent sunset loops.
;7357	;
;7358	
				;7359	.BIN
				;7360	
				;7361	M-TRAP:
				;7362		LMSTK	[PSW-LOAD, RB],		; Load up no frills return address.
U 1271, 0000,0530,4373,0251	;7363				NAF/M-TRAP0	; Join common code.
				;7364	M-TRAP1:
				;7365		LMSTK	[OVF-RET, RB],		; Load SOVFF clear return address.
U 1272, 0000,0534,0133,0251	;7366				NAF/M-TRAP0	; Join common code.
				;7367	M-TRAP2:
U 1273, 0000,0532,0273,0251	;7368		LMSTK	[P.HLT-CK0, RB]		; Return to check HALT line for
				;7369						;  sunset loop prevention.
				;7370	
				;7371	=1*1*****				; If RDINTR aborts, go to ROM[240] then
				;7372	M-TRAP0:				;  RFS to 440 and resynchronize.
U 0251, 0000,1563,6016,1274	;7373		MOV.L	[PS, RE.H]		; RE.H <- Old PS.  Clear vector fetch flag (RE.L).
				;7374	=					; Save PS for stack push and multiple abort.
				;7375	
				;7376		ARI.W	[RA],			; Relocate Vector address in Data Space
				;7377			KERNEL MODE,		;  using Kernel PARs and PDRs.
U 1274, 0000,0701,1372,1275	;7378			ODD TRAP		; Must be a word address.  Fetch PC.
				;7379	
U 1275, 0000,0321,7777,1276	;7380		RD.W	[RF]			; RF.L <- New PC.  Save Old PC in case of abort.
				;7381	
				;7382		AR	[RA],			; Relocate New PS address in Data Space
U 1276, 0000,0731,1772,0131	;7383			KERNEL MODE		;  using Kernel PARs and PDRs.
				;7384	
				;7385	=0*0*****				; Go to Multiple Abort routine on abort.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  175
; BASE  .MCD [242,1110]      Micro Trap

				;7386		RD.W	[PS],			; Read in New PS.
U 0131, 0000,0321,5740,1277	;7387			VECTOR PS PROTECT	; PS<13:12> <-- Old PS<15:14>.
				;7388	=
U 1277, 0000,0560,0076,0133	;7389		LLD.W	[001, RE]		; Set vector fetch flag for multiple abort routine.
				;7390						; Also wait for PS to select SP.
				;7391	
				;7392	=0*0*****				; Go to Multiple Abort routine on abort.
U 0133, 0000,1561,7335,1300	;7393		MOV.W	[SP, RD]		; Save new SP for multiple abort routine.
				;7394	=
				;7395		ARD.W	[SP],			; SP <-- SP - 2.  SP selected by PS<15:14>.
U 1300, 0000,0711,7566,1301	;7396			NO ABORTS		; Get the aborts later.
				;7397	
				;7398		AWD.W	[SP],			; Relocate Stack address and do decrement.
U 1301, 0000,0751,7366,1302	;7399			ODD TRAP		; Must be a word address.
				;7400	
U 1302, 0000,1561,6733,1303	;7401		MOV.W	[RE.H, RB]		; Stack <-- Old PS.
				;7402	
				;7403		AW	[SP],			; Relocate Stack address again.
U 1303, 0000,0771,6766,1001	;7404			SOVFF			; Check for Stack Overflow.
				;7405	
				;7406	=0*0*****				; Go to Multiple Abort routine on abort.
U 1001, 0000,1561,7373,1304	;7407		MOV.W	[PC, RB]		; Stack <-- Old PC.
				;7408	=
				;7409		MOV.W	[RF, PC],		; PC <-- New PC.
U 1304, 0000,1561,7767,0777	;7410				NAF/RFS		; Pop.  MSTK address must abort to ROM[0].
				;7411	
				;7412	=10********0	; Return for T-bit, Parity, or PIRQ and no HALT line.
U 2656, 0036,7777,0240,0000	;7413	NPLA0	[P.HLT-CK0, ^X XX0 XXX XXX XXX XXX]	; HLTFF = 0.
				;7414		OUTS	[PSW, PS],		; Load up the Control chip PSW.
U 2657, 0000,0271,3740,0113	;7415				NAF/PSW-LOAD1	; Join code below.
				;7416	=
				;7417	=10********0	; Return for T-bit, Parity, or PIRQ and HALT line.
U 2660, 0036,7777,0241,0000	;7418	NPLA0	[P.HLT-CK0, ^X XX1 XXX XXX XXX XXX]	; HLTFF = 1.  Stop sunset loops.
				;7419		OUTS	[PSW, PS],		; Load up the Control chip PSW.
U 2661, 0000,0271,3740,1317	;7420				NAF/ENTER-ODT	; Go to ODT.
				;7421	=
				;7422	=0*0*****				; Go to Multiple Abort routine on abort.
				;7423	OVF-RET:				; Return here if SOVFF or Emergency Stack.
				;7424		OUTC	[CLR_SOVFF],		; Clear SOVFF else endless loop would occur.
U 1002, 0000,0261,5777,0107	;7425				NAF/PSW-LOAD	; Use common code.
				;7426	=
				;7427	;=0*0*****				; Abort to ROM[0] for M-TRAP.
				;7428	;PSW-LOAD:
				;7429	;	OUTS	[PSW, PS]		; Update new Control chip PS<7:4> to
				;7430	;=					;  arbitrate interrupt priority and Trace Trap.
				;7431	;
				;7432	;=0*0*****				; Abort to ROM[0] for "Power Up".
				;7433	;PSW-LOAD1:				; Clear SSFF for POWER-UP and ODT "G".
				;7434	;	OUTC	[CPY_TBIT-CLR_SSFF],	; Copy ITFF from PS<4>.
				;7435	;			NAF/RE-SYNC	; Wait for Interrupt Blocking Logic
				;7436	;=					;  before ckecking interrupts at IRDF.
				;7437	
;7438	.NOBIN
;7439	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  176
; BASE  .MCD [242,1110]      Multiple and ODT Abort, Power Up Breakout

;7440		.TOC	"		Multiple and ODT Abort, Power Up Breakout"
;7441	
;7442	;
;7443	; Entry Conditions:
;7444	;
;7445	;	NA = 000; NA was zeroed by Abort Logic or MINIT-L.
;7446	;
;7447	;	Entered from ODT, M-TRAP, or on Power Up.
;7448	;
;7449	; Exit Points:
;7450	;
;7451	;	NAF = PWR-UP-ODT	if entered by MINIT-L,
;7452	;	    = ODT-ABORT		if SSFF is set and abort occured,
;7453	;	    = M-TRAP		if abort from M-TRAP but not Red Zone,
;7454	;	    = M-TRAP1		if Red Zone Abort, or
;7455	;	    = ENTER-ODT		if HALT Line stopped endless loop.
;7456	;
;7457	; Method:
;7458	;
;7459	;	The SSFF, HLTFF, and ABFF<4:0> are loaded into the PIR.  If ABFF<0> = 0, the machine
;7460	;	is being Powered Up (see "Power Up").  If the SSFF is set, an abort occured from ODT
;7461	;	and this code sends it back.  If neither of these is the case, an abort occured while
;7462	;	servicing a trap, interrupt, or abort sequence at M-TRAP.  An abort of this nature is
;7463	;	referred to here as a multiple abort.
;7464	;
;7465	;	In the case of a multiple abort, the subroutine GET-VECTOR is called to fetch the
;7466	;	vector address into RA and set the CPU Error Register (if required).  RE is tested to
;7467	;	see if the abort was caused by the stack push.  Then the Halt line is checked to stop
;7468	;	sunset loops.  If the Halt line is not asserted AND the stack caused the abort AND it
;7469	;	was the Kernel stack, the KSP is set to 4 and called an emergency stack or Red Zone
;7470	;	Stack Abort, and the original PS is restored.  Otherwise, if the Halt line is not
;7471	;	asserted, the PS and SP are restored (if need be) before returning to M-TRAP.  If the
;7472	;	Halt line is asserted, the PS and SP are restored (if need be) before entering Micro-ODT.
;7473	;
;7474	;	On a multiple abort, a design objective was to insure that the visible state of the
;7475	;	machine was not altered before the abort at M-TRAP was serviced.  This is why the
;7476	;	PS and SP are always restored to their original state.  Hence, the PC and PS pushed
;7477	;	(if ever successful) will be that of the job originating the first trap sequence.
;7478	;
;7479	; In summary:
;7480	;	If -ABFF<0>		=> Call PWR-UP-ODT; Return to check options.
;7481	;	If ABFF<0>.SSFF		=> Go to ODT-ABORT.
;7482	;	If ABFF<0>.-SSFF	=> Call GET-VECTOR (to load vector address);
;7483	;				   Return to test for RE<>0 (SP caused abort);
;7484	;	    If -HLTFF.-SP	=> Go to M-TRAP.
;7485	;	    If -HLTFF.SP.-KM	=> Call RESTORE; Return to M-TRAP.
;7486	;	    If -HLTFF.SP.KM	=> KSP <-- 4; PS <-- Old PS;
;7487	;				   Call SET-CPU; Return to M-TRAP1.
;7488	;
;7489	;	    If HLTFF.-SP	=> Go to ENTER-ODT.
;7490	;	    If HLTFF.SP		=> Call RESTORE; Return to ENTER-ODT.
;7491	;
;7492	
				;7493	.BIN
				;7494	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  177
; BASE  .MCD [242,1110]      Multiple and ODT Abort, Power Up Breakout

				;7495	0:
				;7496	MULTIPLE-ABORT:
U 0000, 0000,0271,7677,1305	;7497		OUTS	[ABORTS]		; PIR<12,7,4:0> <-- HLTFF, SSFF, ABFF<4:0>.
				;7498	
				;7499		NOP.W	[RF, RF],		; Allow time for PLA translation.
U 1305, 0000,1771,7777,0407	;7500				NAF/407		; Invoke PLA decode.
				;7501	
				;7502	;H-POKH-F:	; POKH is not asserted.
				;7503	POWER-UP:	; ABFF<0> = 0.  Power up.
				;7504	=10********0
U 2662, 0437,7776,0340,0000	;7505	PLA0	[^0 00X 111, ^X XXX XXX XXX XXX XX0]
				;7506		LMSTK	[P-U-T1, RA],		; Set up return to do Power Up Test.
U 2663, 0000,0530,7572,0007	;7507				NAF/PWR-UP-ODT	; Go to "Power Up" sequence.
				;7508	=
				;7509	SSFF:		; SSFF = 1, ABFF<0> = 1.  Aborted from ODT.
				;7510	=10********0
U 2664, 0037,7576,0340,0201	;7511	PLA0	[^0 000 111, ^X XXX XXX X1X XXX XX1]
				;7512		NOP.W	[RF, RF],
U 2665, 0000,1771,7777,1757	;7513				NAF/ODT-ABORT	; Go to standard ODT abort entry.
				;7514	=
				;7515	M-ABORT:	; SSFF = 0, ABFF<0> = 1.  Aborted from M-TRAP.
				;7516	=10********0
U 2666, 0037,7576,0340,0001	;7517	PLA0	[^0 000 111, ^X XXX XXX X0X XXX XX1]
				;7518		LMSTK	[M-ABORT1, RB],		; Call subroutine to get vector address
U 2667, 0000,0535,4333,1263	;7519				NAF/GET-VECTOR	;  and set the CPU Error Register.
				;7520	=
				;7521	M-ABORT1:
				;7522		TST.W	[RE, RE],		; Did SP cause abort?  RE = 1 if true.
U 1306, 0000,1661,7736,0406	;7523				NAF/P.HLT-CK1	; Check halt line too.
				;7524	
				;7525	=10********0	; HLTFF = 0.  Halt line is not asserted.
U 2670, 0036,7777,0300,0000	;7526	NPLA0	[P.HLT-CK1, ^X XX0 XXX XXX XXX XXX]
U 2671, 0000,0115,3477,1307	;7527		JAZ	[M-TRAP]		; If not SP, go to M-TRAP.
				;7528	=
U 1307, 0000,0560,0212,1310	;7529		LLD.W	[004, RA.H]		; Assume Emergency Stack.  Used at SET-CPU.
				;7530						; Go to M-TRAP if not SP.
				;7531	
U 1310, 0000,0165,4537,1311	;7532		JKM	[KM-SP]			; Is it the Kernel Stack?
				;7533	
				;7534		LMSTK	[M-TRAP, RB],		; Assume not.  Just restore SP and PS.
U 1311, 0000,0535,3473,1315	;7535				NAF/RESTORE	; Go to KM-SP if the worst has happened.
				;7536	;RESTORE:
				;7537	;	MOV.W	[RD, SP]		; Restore SP to original state.
				;7538	;
				;7539	;	MOV.W	[RE.H, PS],		; Restore PS to original state.
				;7540	;			NAF/RFS		; Return to ENTER-ODT or M-TRAP.
				;7541	
				;7542	KM-SP:					; The Kernel SP aborted.
U 1312, 0000,0560,0226,1313	;7543		LLD.W	[004, SP]		; Set up Emergency Stack.
				;7544	
				;7545		MOV.W	[RE.H, PS],		; Restore the PS.
U 1313, 0000,1561,6700,1251	;7546				NAF/OVF-SET-CPU	; Join code for Stack Overflow.
				;7547	;OVF-SET-CPU:
				;7548	;	LMSTK	[M-TRAP1, RB],		; Set the CPU Error Register then enter
				;7549	;			NAF/SET-CPU	;  M-TRAP at special entry point.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  178
; BASE  .MCD [242,1110]      Multiple and ODT Abort, Power Up Breakout

				;7550	
				;7551	=10********0	; HLTFF = 1.  Stop endless loops.
U 2672, 0036,7777,0301,0000	;7552	NPLA0	[P.HLT-CK1, ^X XX1 XXX XXX XXX XXX]
U 2673, 0000,0115,4777,1314	;7553		JAZ	[ENTER-ODT]		; If not SP, go directly to ODT.
				;7554	=
				;7555		LMSTK	[ENTER-ODT, RB],	; Load return address from RESTORE.
U 1314, 0000,0535,4773,1315	;7556				NAF/RESTORE	; If SP, SP and PS need restored.
				;7557	RESTORE:
U 1315, 0000,1561,7666,1316	;7558		MOV.W	[RD, SP]		; Restore SP to original state.
				;7559	
				;7560		MOV.W	[RE.H, PS],		; Restore PS to original state.
U 1316, 0000,1561,6700,0777	;7561				NAF/RFS		; Return to ENTER-ODT or M-TRAP.
				;7562	
;7563	.NOBIN
;7564	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  179
; BASE  .MCD [242,1110]      General Purpose Abort Return

;7565		.TOC	"		General Purpose Abort Return"
;7566	
;7567	;
;7568	; Entry Condition:
;7569	;
;7570	;	NA = 240,	NA<9:8,6,4:0> zeroed by abort logic.
;7571	;	MSTK = Return address.
;7572	;
;7573	; Exit Conditions:
;7574	;
;7575	;	None.  MSTK is simply popped causing a return to whatever aborted.
;7576	;
;7577	
;7578	
				;7579	.BIN
				;7580	
				;7581	
				;7582	240:
				;7583	POP:
				;7584		NOP.W	[RF, RF],		; Nothing to do really.
U 0240, 0000,1771,7777,0777	;7585				NAF/RFS		; Return to individual abort servicing.
				;7586	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  180
; ODT   .MCD [242,1110]      ODT.MCD

				;7587		.TOC	"ODT.MCD"
				;7588		.TOC	"REVISION 2.07"
				;7589	
				;7590	
;7591	.NOBIN
;7592	
;7593	
;7594		.TOC	"	Revision History"
;7595	
;7596	
;7597	;	Revision History
;7598	;	----------------
;7599	;
;7600	; Rev     Date		Explaination	
;7601	; ---     ----		------------	
;7602	;
;7603	;	  Release
;7604	; 2.07	  12/15/81	KEH; Added LED 4/remote diagnoses hook.
;7605	; 2.06	  12/01/81	KEH; Squeezed two words from Print Routine by expanding
;7606	;			     P-ASCII and eliminating NOP at RETURN.
;7607	; 2.05	  11/20/81	KEH; Created RESET5 for shared code with base.
;7608	; 2.04	  09/09/81	KEH; Switch back to PLA bank 0.
;7609	;	  Release
;7610	; 1.03	  06/24/81	KEH; Switched to NPLA1 to free ID1 for FP11 decodes.
;7611	; 1.02	  04/14/81	KEH; Format change for release.  No code change.
;7612	; 1.01	  01/20/81	HND; Rewrote Control-Shift-S routine.
;7613	;			      Used Console Mode mapping instead
;7614	;			      of 16-Bit mapping so that I/O page
;7615	;			      is not accidently addressed.
;7616	; 1.00    1/12/81	HND; Release, rewritten to conserve ROM.	
;7617	;			      Assembled with Rev. 1.09 of BASE.MCD.	
;7618	; 0.07    9/04/80	HND; Internal, preliminary release.
;7619	;
;7620	;
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  181
; ODT   .MCD [242,1110]      Introductory Remarks

;7621		.PAGE	"	Introductory Remarks"
;7622		.TOC	"		ODT States"
;7623	
;7624	
;7625	
;7626	;	*****************************************************************************
;7627	;	*****************************************************************************
;7628	;	**                                                                         **
;7629	;	**	MICRO-ODT	MICRO-ODT	MICRO-ODT	MICRO-ODT           **
;7630	;	**                                                                         **
;7631	;	*****************************************************************************
;7632	;	*****************************************************************************
;7633	;
;7634	;
;7635	;	Microcoded Console On-Line Debugging Technique (ODT).  Six bits
;7636	;	define a unique ODT State.
;7637	;		
;7638	;
;7639	;	ODT STATE
;7640	;	--- -----
;7641	;
;7642	;	            |      
;7643	;	R   PS   P  |  N4   N2   N1  
;7644	;                   |  
;7645	;
;7646	;
;7647	;	R:	Register or Memory location indicator for the previous
;7648	;		location (only valid after <CR>).
;7649	;		0--> Memory address in ADDR register.
;7650	;		1--> Register designator in ADDR register.
;7651	;
;7652	;	PS:	Processor Status indicator if register mode for both previous
;7653	;		and current state (previous if P = 1, else current).
;7654	;	   	0--> No
;7655	;		1--> Yes
;7656	;
;7657	;	P:	Previous Location indicator.
;7658	;		0--> Can not open previous location.
;7659	;		1--> May open previous location with a "/" (last character was <CR>).
;7660	;
;7661	;	N1:	Register or Memory location indicator for the current state.
;7662	;		0--> Memory
;7663	;		1--> Register
;7664	;
;7665	;	N2:	Entering address or data information.
;7666	;		0--> DATA register contains a memory address or register designator.
;7667	;		1--> DATA register contains the new data for the memory location
;7668	;		     or register.  ADDR register holds the memory address or
;7669	;		     register designator.
;7670	;
;7671	;	N4:	Whether new information has been entered.
;7672	;		0--> No information in DATA register.
;7673	;		1--> Information in DATA register.
;7674	;
;7675	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  182
; ODT   .MCD [242,1110]      ODT States

;7676	
;7677	
;7678	;
;7679	;	ODT	   EXAMPLE OF	        VALID	      RESULTING	
;7680	;	STATE      TERM, OUTPUT         INPUT         ODT STATE    COMMENT
;7681	;	-----	   ------------         -----	      ---------	   -------
;7682	;
;7683	;	000,000    @                    0-7            000,100	
;7684	;					R,$	       000,001 	
;7685	;					G,P		 -         Leave Micro-ODT
;7686	;					CTL-SHIFT-S    000,000     
;7687	;	----------------------------------------------------------------------------
;7688	;	001,000    @                    /              000,010	   Open previous memory location
;7689	;					0-7	       000,100
;7690	;					R,$	       000,001 	
;7691	;					G,P		 -         Leave Micro-ODT
;7692	;					CTL-SHIFT-S    000,000     
;7693	;	----------------------------------------------------------------------------
;7694	;	101,000    @                    /              000,011	   Open previous register
;7695	;					0-7	       000,100
;7696	;					R,$	       000,001 	
;7697	;					G,P		 -         Leave Micro-ODT
;7698	;					CTL-SHIFT-S    000,000     
;7699	;	----------------------------------------------------------------------------
;7700	;	111,000    @                    /              010,011	   Re-open the PS 
;7701	;					0-7	       000,100
;7702	;					R,$	       000,001 	
;7703	;					G,P		 -         Leave Micro-ODT
;7704	;					CTL-SHIFT-S    000,000     
;7705	;	----------------------------------------------------------------------------
;7706	;	000,001    @R OR @$		0-7	       000,001
;7707	;					S	       010,101 
;7708	;	----------------------------------------------------------------------------
;7709	;	000,010    @200/123456 		0-7	       000,110
;7710	;		   			CR	       001,000
;7711	;					LF	       000,010
;7712	;	----------------------------------------------------------------------------
;7713	;	000,011    @R1/123456		0-7	       000,111	
;7714	;					CR	       101,000   
;7715	;					LF	       000,011   
;7716	;       ----------------------------------------------------------------------------
;7717	;	010,011    @RS/123456		0-7	       010,111	
;7718	;					CR	       111,000   
;7719	;					LF	       111,000   
;7720	;       ----------------------------------------------------------------------------
;7721	;	000,100    @200			0-7	       000,100
;7722	;					/	       000,010
;7723	;					G		 -	  Leave Micro-ODT
;7724	;	----------------------------------------------------------------------------
;7725	;	000,101    @R1       		0-7	       000,101
;7726	;					S	       010,101
;7727	;					/	       000,011
;7728	;	----------------------------------------------------------------------------
;7729	;	010,101    @RS       		0-7	       000,101
;7730	;					S	       010,101
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  183
; ODT   .MCD [242,1110]      ODT States

;7731	;					/	       010,011
;7732	;	----------------------------------------------------------------------------
;7733	;	000,110    @200/123456 1000	0-7	       000,110
;7734	;					CR	       001,000
;7735	;					LF	       000,010
;7736	;	----------------------------------------------------------------------------
;7737	;	000,111    @R1/123456 1000	0-7	       000,111 
;7738	;					CR	       101,000   
;7739	;					LF	       000,011  
;7740	;	----------------------------------------------------------------------------
;7741	;	010,111    @RS/123456 1000	0-7	       010,111 
;7742	;					CR	       111,000   
;7743	;					LF	       111,000  
;7744	;	----------------------------------------------------------------------------
;7745	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  184
; ODT   .MCD [242,1110]      Register Assignments

;7746	.TOC	"		Register Assignments"
;7747	
;7748	
;7749	;
;7750	;	ODT REGISTER ASSIGNMENTS
;7751	;
;7752	;
;7753	;	R8--> Used by the "Print Routine", bits<23:0> contains value to 
;7754	;		be displayed (right justified).
;7755	;
;7756	;	R9--> Used by the </> routine, to perform a 22-Bit Address Conversion.
;7757	;
;7758	;	RA--> Used with the LMSTK and LCNTR microinstructions, may be used as a
;7759	;		scratchpad register in any routine.
;7760	;
;7761	;	RB--> ADDR register, holds a memory address or register number.
;7762	;		Must not be used for anything else!
;7763	;
;7764	;	RC--> DATA register, holds any new data entered from the console.
;7765	;		Must not be used for anything else!
;7766	;
;7767	;	RD--> Bits<5:0> contain the current ODT State information.  Must not 
;7768	;		be used for anything else!
;7769	;
;7770	;	RE--> Bits<7:0> contain the character to be written or read from
;7771	;		the console.  Must not be used for anything else!
;7772	;	      Bits<23:16> are used for reading the done flag of the RCSR
;7773	;		and XCSR buffers.
;7774	;
;7775	;	RF--> Used for the "Control-Shift-S" routine, contains the starting
;7776	;		address for the APT hook.
;7777	;
;7778	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  185
; ODT   .MCD [242,1110]      Notes

;7779	.TOC	"		Notes"
;7780	
;7781	
;7782	;
;7783	;	Note:	#1	 NA<7,5> are constrained to zero.  If MABORT-L is
;7784	;			 asserted during a demand bus operation, the NA bits
;7785	;			 <9:8,6,4:0> of the second microinstruction following
;7786	;			 an Address class microinstruction are zeroed.  This
;7787	;			 forces a next address of 0 (octal) where a micro-
;7788	;			 code ABORT routine resides.  This routine checks the
;7789	;			 Single-Step Flip-Flop (SSFF), which was set by ODT
;7790	;			 and returns to ODT-ABORT, location 1757, where a 
;7791	;			 question mark is printed to the console.
;7792	;
;7793	;
;7794	;
;7795	;		#2	 NAF<4> is constrained to zero.  The NAF of
;7796	;			 the previous microinstruction was ANDed with 
;7797	;			 1757, which is the NAF of the Default PLA term. 
;7798	;			 To allow the previous microinstruction's NAF
;7799	;			 not to be changed, bit<4> must be equal to zero.
;7800	;
;7801	;
;7802	;
;7803	;		#3	 NAF<6> is constrained to one.  For the override
;7804	;			 to PROMPT to occur bit<6> must be equal to one. 
;7805	;
;7806	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  186
; ODT   .MCD [242,1110]      Initialization

;7807		.TOC	"	Initialization"
;7808	
;7809	;
;7810	; Entry point for MICRO ODT.
;7811	; Upon entry:
;7812	;
;7813	; 	1) Set Single Step Flip-flop.
;7814	;	2) Print Carriage Return <CR>, Line Feed <LF>.
;7815	;	3) Print the PC.
;7816	;	4) Clear the Console Terminal Receiver Buffer (RBUF).
;7817	;	5) Print <CR>, <LF>.
;7818	;	6) Print the Prompt character "@".
;7819	;	7) Initialize the ODT State to 00.
;7820	;	8) Wait for Console Terminal input.
;7821	;
;7822	
				;7823	.BIN
				;7824	
				;7825	ENTER-ODT:				; MULTIPLE-ABORT routine at ROM[0] checks SSFF.
U 1317, 0000,0261,7677,1320	;7826		OUTC	[SET_SSFF]		;  If set, re-enters ODT at ODT-ABORT.  This also
				;7827						;  sets up the Q-logic for an exit from ODT "P".
				;7828	
				;7829		LMSTK	[PRINT-PC, RA],
U 1320, 0000,0535,5072,1005	;7830				NAF/CR-LF	; Print a <CR>, <LF>.
				;7831	
				;7832	PRINT-PC:
U 1321, 0000,1561,7370,1322	;7833		MOV.W	[PC, R8]
				;7834	
				;7835		LMSTK	[CLEAR, RA],		; Convert 16-bit PC to ASCII and print.
U 1322, 0000,0535,5172,1006	;7836				NAF/PRINT-16
				;7837	
				;7838	CLEAR:					; ODT State in RD<5:0> = 00.
				;7839		LMSTK	[PROMPT, RD],		;  Clear RBUF by reading the contents
U 1323, 0000,0530,4035,1374	;7840				NAF/READ	;  and ignoring them.
				;7841	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  187
; ODT   .MCD [242,1110]      Command Input and Breakout

				;7842		.TOC	"	Command Input and Breakout"
				;7843	
				;7844	; Except character and load for decode.
				;7845	
				;7846	;0*00****				; See notes #1, and #2.
				;7847	0100:					; Address also used as return from 
				;7848	PROMPT:					;  the Control-Shift-S routine. 
				;7849		LMSTK	[PROMPT1, RA],	 
U 0100, 0000,0535,5232,1005	;7850				NAF/CR-LF	; Print a <CR>, <LF>.  
				;7851	
				;7852	PROMPT1:				; Load MSTK, RE<7:0> with 100 (ASCII	
				;7853		LMSTK	[WAITA, RE],		;  value of Prompt "@").
U 1324, 0000,0534,4036,0012	;7854				NAF/OUTPUT	;  Print the Prompt.
				;7855	
				;7856	1100:					; ASCII value of Prompt.
				;7857	WAITA:
U 1100, 0000,1043,7634,0151	;7858		CLR.L	[RC, RC]		; Clear DATA register for later use.
				;7859	
				;7860	=0****					; See note #2.
				;7861	WAITB:		
				;7862		LMSTK	[WAITC, RA],		; Wait for input from console.
U 0151, 0000,0535,5272,0004	;7863				NAF/INPUT	;  Put character into RE<7:0>.
				;7864	=
				;7865	WAITC:
U 1325, 0000,1467,7676,1326	;7866		SWAB.B	[RD, RE]		; Move ODT State to RE<15:8>.
				;7867	
U 1326, 0000,0271,6776,1327	;7868		OUTS	[LD_PIR, RE]		; Load RE<15:0> (ODT State <15:8> and 
				;7869						;  character <7:0>) to PIR for PLA breakout.
				;7870	
U 1327, 0000,0506,7036,1330	;7871		LBIT.B	[160, RE]		; Check for ASCII 000-017, 200-217.
				;7872						; <LF>, and <CR> fall into the above range.  
U 1330, 0000,0112,0077,1331	;7873		JAZ	[P.ODT]			; If true, do not echo character.
				;7874	
				;7875		LMSTK	[P.ODT, RA], 		; If false, echo the character.
U 1331, 0000,0532,0072,0012	;7876				NAF/OUTPUT	;  Then go to PLA breakout.
				;7877	
				;7878	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  188
; ODT   .MCD [242,1110]      Default PLA Term

				;7879		.TOC	"		Default PLA Term"
				;7880	
				;7881	;****************************************************************************
				;7882	;*                                                                          *
				;7883	;*         DEFAULT ACTION IF NO OTHER PLA TERMS ARE ACTIVATED               *
				;7884	;*                                                                          *
				;7885	;****************************************************************************
				;7886	
				;7887	; This term always turns on and is ANDed with all other P.ODT terms.
				;7888	
				;7889	=10********0	; Default for illegal character.
U 2674, 0037,7777,0040,0000	;7890	NPLA0	[P.ODT, ^X]
				;7891		NOP.W	[RF, RF],		; All terms must be word lenght.
U 2675, 0000,1771,7777,1757	;7892				NAF/1757	; All P.ODT NAFs must have NAF<4> = 0.
				;7893	=
				;7894	
				;7895	1757:
				;7896	ODT-ABORT:
				;7897		LMSTK	[ERROR, RE],		; ASCII value of <?>.
U 1757, 0000,0530,3776,0012	;7898				NAF/OUTPUT	; Print <?>.
				;7899	
				;7900	0077:
				;7901	ERROR:
				;7902		LLD.B	[000, RD],		; Set ODT State in RD<7:0> = 000.
U 0077, 0000,0566,0035,0100	;7903				NAF/PROMPT	
				;7904	
				;7905	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  189
; ODT   .MCD [242,1110]      R, $, and S

				;7906		.TOC	"		R, $, and S"
				;7907	
				;7908	
				;7909	;****************************************************************************
				;7910	;*                                                                          *
				;7911	;*                          "R",  "$",  A N D  "S"                          *
				;7912	;*                                                                          *
				;7913	;****************************************************************************
				;7914	
				;7915	
				;7916	=10********0   	; State = XXX 000; Character R or r.
U 2676, 0037,4240,0040,0122	;7917	NPLA0	[P.ODT, ^XX XXX 000 X1X10010]
				;7918		LLD.W	[001, RD],		; New ODT State = 01, internal register 
U 2677, 0000,0560,0075,0151	;7919				NAF/WAITB	;  designator.  Wait for more input.
				;7920	=
				;7921	
				;7922	=10********0	; State = XXX 000; Character $.
U 2700, 0037,4200,0040,0044	;7923	NPLA0	[P.ODT, ^XX XXX 000 X0100100]
				;7924		LLD.W	[001, RD],		; New ODT State = 01, internal register
U 2701, 0000,0560,0075,0151	;7925				NAF/WAITB	;  designator.  Wait for more input.
				;7926	=
				;7927	
				;7928	=10********0	; State = XXX X01; Character S or s.
U 2702, 0037,6240,0040,0523	;7929	NPLA0	[P.ODT, ^XX XXX X01 X1X10011]
				;7930		LLD.W	[025, RD],		; New ODT State = 25, PS designator.
U 2703, 0000,0560,1275,0151	;7931				NAF/WAITB	; Wait for input from console.
				;7932	=
				;7933	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  190
; ODT   .MCD [242,1110]      0-7 Octal Digits

				;7934		.TOC	"		0-7 Octal Digits"
				;7935	
				;7936	
				;7937	;*****************************************************************************
				;7938	;*                                                                           *
				;7939	;*                 "0 - 7",   O C T A L   D I G I T S                        *
				;7940	;*                                                                           *
				;7941	;*****************************************************************************
				;7942	
				;7943	
				;7944	=10********0	; State = XXX X0X; Character octal digit (0-7).
U 2704, 0037,6607,0040,0060	;7945	NPLA0	[P.ODT, ^XX XXX X0X X0110XXX]
U 2705, 0000,0550,3435,0153	;7946		LBIC.W	[070, RD]		; Clear ODT State<5:3>.
				;7947	=
				;7948	=0****					; See note #2.
				;7949		LBIS.B	[004, RD],		; Set State<2>.  Data has been entered.
U 0153, 0000,0576,0235,0311	;7950				NAF/NEW-STATE
				;7951	=
				;7952	
				;7953	=10********0	; ODT State = XXX X1X; Character octal digit (0-7).
U 2706, 0037,6607,0040,1060	;7954	NPLA0	[P.ODT, ^XX XXX X1X X0110XXX]
U 2707, 0000,0570,0235,0311	;7955		LBIS.W	[004, RD]		; Set State<2>.  Data has been entered.
				;7956	=
				;7957	=0****					; See note #2.
				;7958	NEW-STATE:
U 0311, 0000,0516,0376,1332	;7959		LAND.B	[007, RE]		; Mask all but the octal digit.
				;7960	=
				;7961		LCNTR.W	[003, RA],		; Set up counter for loop.
U 1332, 0000,0520,0172,0273	;7962				NAF/OCTAL1	; Skip to loop.
				;7963	=0
				;7964		ADD.B	[RE, RC],		; Add the octal digit into the 3 lsb's
U 0272, 0000,1447,7734,0151	;7965				NAF/WAITB	;  of the DATA register.
				;7966	OCTAL1:
				;7967		ASL.L	[RC, RC],		; Make room in DATA register for an
				;7968			DECR CNTR,		;  octal digit by shifting left
U 0273, 0000,1233,3634,0273	;7969				NAF/OCTAL1	;  3 places.
				;7970	=
				;7971	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  191
; ODT   .MCD [242,1110]      P, G

				;7972		.TOC	"		P, G"
				;7973	
				;7974	
				;7975	;****************************************************************************
				;7976	;*                                                                          *
				;7977	;*                            "P",  "G"                                     *
				;7978	;*                                                                          *
				;7979	;****************************************************************************
				;7980	
				;7981	
				;7982	=10********0	; State = XXX 000; Character P or p.
U 2710, 0037,4240,0040,0120	;7983	NPLA0	[P.ODT, ^XX XXX 000 X1X10000]
U 2711, 0000,0260,7777,0342	;7984		OUTC	[CLR_PTYFF]		; Clear parity error flop on exit.
				;7985	=
				;7986	=0****					; See note #2.
U 0342, 0000,0271,3740,1333	;7987		OUTS	[PSW, PS]		; Load CTL chip PSW with new interrupt
				;7988	=					;  priority.
				;7989		AWG.W	[LED4_OFF],		; Signal exit from ODT.
U 1333, 0000,0670,1637,0440	;7990				NAF/440		; Refill and synchronize the pipeline.
				;7991	;
				;7992	;	MOV.W	[PC, PC]		; VPC <-- PC.  Start from scratch.
				;7993	;
				;7994	
				;7995	
				;7996	=10********0	; ODT State = XXX X00; Character G or g.
U 2712, 0037,6240,0040,0107	;7997	NPLA0	[P.ODT, ^XX XXX X00 X1X00111]
U 2713, 0000,1561,7627,0343	;7998		MOV.W	[RC, PC]		; Load PC with new address, default = 0.
				;7999	=
				;8000	=0****					; See note #2.
				;8001		LMSTK	[GO1, RE],		; RE<7:0> = 000 a <null>.
U 0343, 0000,0534,0036,0012	;8002				NAF/OUTPUT	; Print <null> to console.
				;8003	=
				;8004	1000:
				;8005	GO1:
				;8006		LMSTK	[GO2, RA],		
U 1000, 0000,0535,5632,0012	;8007				NAF/OUTPUT	; Print second <null> to console.
				;8008	
				;8009	GO2:
				;8010		LMSTK	[PSW-LOAD, RA],		; Set up stack for base code.
U 1334, 0000,0530,4372,0007	;8011				NAF/PWR-UP-ODT	; Jump to base code routine.
				;8012	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  192
; ODT   .MCD [242,1110]      Slash

				;8013		.TOC	"		Slash"
				;8014	
				;8015	
				;8016	;****************************************************************************
				;8017	;*                                                                          *
				;8018	;*                          "/"     S L A S H                               *
				;8019	;*                                                                          *
				;8020	;****************************************************************************
				;8021	
				;8022	
				;8023	=10********0	; State = X0X 100, memory; Character </>.
U 2714, 0036,4200,0040,2057	;8024	NPLA0	[P.ODT, ^XX X0X 100 X0101111]
U 2715, 0000,0560,0135,0352	;8025		LLD.W	[002, RD]		; Set new ODT State = 02.
				;8026	=
				;8027	=0****					; See note #2.
U 0352, 0000,1563,7633,0057	;8028		MOV.L	[RC, RB]		; Save address in ADDR register for 
				;8029	=					;  later reference.
				;8030	;=0****		
				;8031	0057:					; Bit <4> already constrained to a 0.
				;8032	SLASH-AA:	
U 0057, 0000,1563,7571,1335	;8033		MOV.L	[RB, R9]		; A 22-bit physical address is converted to a
				;8034						;  virtual address residing in the CPAR and RC.
				;8035		LCNTR.B	[006, RA],		; Shift physical address right 6 places.
U 1335, 0000,0526,0332,0327	;8036				NAF/ALIGN
				;8037	=0
				;8038		LAND.B	[200, R9],		; Mask out bits <6:0> of the temporary CPAR. 
U 0326, 0000,0517,0031,1336	;8039				NAF/ALIGN1	 
				;8040	
				;8041	ALIGN:
				;8042		ASR.L	[R9, R9],		; Bits <21:13> of the physical address
				;8043			DECR CNTR,		;  aligned to bits <15:7> of the 	
U 0327, 0000,1343,3471,0327	;8044				NAF/ALIGN	;  temporary CPAR.
				;8045	=
				;8046	ALIGN1:
U 1336, 0000,0250,6371,1337	;8047		OUTR.W	[CPAR, R9]		; Move the temporary CPAR to the real CPAR.
				;8048	
				;8049		AR	[RB],			; Relocate RC (virtual address).
				;8050			CONSOLE MODE,		; PA<21:13> = CPAR<15:7>. 
U 1337, 0000,0731,5373,1340	;8051			ODD TRAP		; PA<12:0> = VA<12:0>.
				;8052	
U 1340, 0000,0321,7770,1341	;8053		RD.W	[R8]			; Contents of the physical address to R8<15:0>.
				;8054	
				;8055	PRINT-WORD:			
				;8056		LMSTK	[SLASH, RA],	
U 1341, 0000,0535,6132,1006	;8057				NAF/PRINT-16	; Print the word to the console.
				;8058	
				;8059	SLASH:
U 1342, 0000,0560,2036,1343	;8060		LLD.W	[040, RE]		; RE<7:0> with 040 (ASCII value of a "space").
				;8061	
				;8062		LMSTK	[WAITA, RA],		; Return to WAITA. 
U 1343, 0000,0534,4032,0012	;8063				NAF/OUTPUT	; Print the "space" to the console.
				;8064	
				;8065	
				;8066	=10********0	; State = X0X 101, register; Character </>.
U 2716, 0036,4200,0040,2457	;8067	NPLA0	[P.ODT, ^XX X0X 101 X0101111]
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  193
; ODT   .MCD [242,1110]      Slash

U 2717, 0000,0560,0175,0353	;8068		LLD.W	[003, RD]		; Set new ODT State = 03.
				;8069	=
				;8070	=0****					; See note #2.
				;8071						; Save register number in ADDR register
U 0353, 0000,1563,7633,1057	;8072		MOV.L	[RC, RB]		;  for later reference.
				;8073	=
				;8074	;=0****					; Bit <4> already constrained to a 0.
				;8075	1057:					
				;8076	SLASH-BB:
U 1057, 0000,0251,0373,1344	;8077		OUTR.W	[SIR, RB]		; Register number in RB<2:0> loaded into
				;8078						;  the shadow IR.
				;8079		MOV.W	[RDST, R8],		; Contents of selected register to R8<15:0>.
U 1344, 0000,1561,6330,1341	;8080				NAF/PRINT-WORD	; Join common code.
				;8081	
				;8082	
				;8083	
				;8084	=10********0	; State = X1X 101, PS; Character </>.
U 2720, 0036,4200,0041,2457	;8085	NPLA0	[P.ODT, ^XX X1X 101 X0101111]
U 2721, 0000,0560,1175,1007	;8086		LLD.W	[023, RD]		; Set new ODT State = 23.
				;8087	=
				;8088	=0****					; See note #2.
				;8089	SLASH-C:
				;8090		MOV.W	[PS, R8],		
U 1007, 0000,1561,6030,1341	;8091				NAF/PRINT-WORD	; Print out the contents of the PS word.
				;8092	=
				;8093	
				;8094	=10********0	; State = 10, memory; Character </>.
U 2722, 0034,0200,0040,4057	;8095	NPLA0	[P.ODT, ^XX 001 000 X0101111]
				;8096		LLD.W	[002, RD],		; Set new ODT State = 02.
U 2723, 0000,0560,0135,0057	;8097				NAF/SLASH-AA	; Join common code.
				;8098	=
				;8099	
				;8100	=10********0	; State = 50, register; Character </>.
U 2724, 0034,0200,0042,4057	;8101	NPLA0	[P.ODT, ^XX 101 000 X0101111]
				;8102		LLD.W	[003, RD],		; Set new ODT State = 03.
U 2725, 0000,0560,0175,1057	;8103				NAF/SLASH-BB	; Join common code.
				;8104	=
				;8105	
				;8106	
				;8107	=10********0	; State = 70, PS; Character </>.
U 2726, 0034,0200,0043,4057	;8108	NPLA0	[P.ODT, ^XX 111 000 X0101111]
				;8109		LLD.W	[023, RD],		; Set new ODT State = 23.
U 2727, 0000,0560,1175,1007	;8110				NAF/SLASH-C	; Join common code.
				;8111	=
				;8112	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  194
; ODT   .MCD [242,1110]      Carriage Return

				;8113		.TOC	"		Carriage Return"
				;8114	
				;8115	
				;8116	;*****************************************************************************
				;8117	;*                                                                           *
				;8118	;*                    "C R"   C A R R I A G E   R E T U R N                  *
				;8119	;*                                                                           *
				;8120	;*****************************************************************************
				;8121	
				;8122	
				;8123	=10********0	; MEMORY, default.
U 2730, 0037,6200,0040,1015	;8124	NPLA0	[P.ODT, ^XX XXX X10 X0001101]	; ODT State = X0X X10, character <CR>.
				;8125						; If no NAF override, then write new data to
				;8126						;  a memory location and close the location.
U 2731, 0000,0560,0435,0103	;8127		LLD.W	[010, RD]		; Set new ODT State = 10.
				;8128	=
				;8129	=1*0****				; See note #2 and #3.
				;8130		AW	[RB],			; Relocate the current memory location's
				;8131			CONSOLE MODE,		;  address.
U 0103, 0000,0771,5373,1345	;8132			ODD TRAP
				;8133	=
				;8134		MOV.W	[RC, RC],		; Write RC<15:0> (new data) to current
U 1345, 0000,1561,7634,0100	;8135				NAF/PROMPT	;  memory location.
				;8136	
				;8137	
				;8138	=10********0	; REGISTER, default.
U 2732, 0036,6200,0040,1415	;8139	NPLA0	[P.ODT, ^XX X0X X11 X0001101]	; ODT State = X0X X11, character <CR>.
				;8140						; If no NAF override, then write new data to
				;8141						;  a register location and close the register.
U 2733, 0000,0560,2435,0104	;8142		LLD.W	[050, RD]		; Set new ODT State = 50.
				;8143	=
				;8144	=1*0****				; See note #2 and #3.
				;8145		MOV.W	[RC, RDST],		; Write RC<15:0> (new data) to the 
U 0104, 0000,1561,7606,0100	;8146				NAF/PROMPT	;  current register location.
				;8147	=					; Join common code.
				;8148	
				;8149	
				;8150	=10********0	; PS, default.
U 2734, 0036,6200,0041,1415	;8151	NPLA0	[P.ODT, ^XX X1X X11 X0001101]	; ODT State = X1X X11, character <CR>.
				;8152						; If no NAF override, then write new
				;8153						; data to the PS and close the PS.
U 2735, 0000,0560,3435,0105	;8154		LLD.W	[070, RD]		; Set new ODT State = 70.
				;8155	=
				;8156	105:
				;8157	CARR1:
U 0105, 0000,1541,6034,1346	;8158		XOR.W	[PS, RC]		; Original PS<4>, T-bit is not
				;8159						;  permitted to change.
U 1346, 0000,0556,1034,1347	;8160		LBIC.B	[020, RC]		; By forcing bit<4> to a zero here, 
				;8161						;  the original T-bit is preserved.
				;8162		XOR.W	[RC, PS],
U 1347, 0000,1541,7600,0100	;8163				NAF/PROMPT	; Join common code.
				;8164	
				;8165	
				;8166	
				;8167	=10********0	; Override for no new data was entered.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  195
; ODT   .MCD [242,1110]      Carriage Return

U 2736, 0037,4600,0040,1015	;8168	NPLA0	[P.ODT, ^XX XXX 01X X0001101]	; Override NAF field to PROMPT. 
				;8169						; Do not change the Load Literal instruction.
				;8170						; Will turn on with the corresponding
				;8171						;  PLA and perform one of the following:
				;8172		NOP.W	[RF, RF],		; A) Close the current memory location.
U 2737, 0000,1771,7777,0100	;8173				NAF/PROMPT	; B) Close the current register location.
				;8174						; C) Close the PS word.
				;8175	=
				;8176	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  196
; ODT   .MCD [242,1110]      Line Feed

				;8177		.TOC	"		Line Feed"
				;8178	
				;8179	
				;8180	;******************************************************************************
				;8181	;*                                                                            *
				;8182	;*                   "LF"       L I N E    F E E D                            *
				;8183	;*                                                                            *
				;8184	;******************************************************************************
				;8185	
				;8186	
				;8187	=10********0	; MEMORY, default. 
U 2740, 0037,6200,0040,1012	;8188	NPLA0	[P.ODT, ^XX XXX X10 X0001010]	; ODT State = X0X X10, character <LF>.
				;8189						; If no NAF override, then write new data to
				;8190						;  a memory location and open next one.
				;8191		LLD.W	[002, RD],		; Set new ODT State = 02.
U 2741, 0000,0560,0135,0117	;8192				NAF/MEM-NEW-111	
				;8193	=
				;8194	
				;8195	=10********0	; REGISTER, default. 
U 2742, 0036,6200,0040,1412	;8196	NPLA0	[P.ODT, ^XX X0X X11 X0001010]	; ODT State = X0X X11, character <LF>.
				;8197						; If no NAF override, then write new data to
				;8198						;  a register location and open next one.
				;8199		LLD.W	[003, RD],		; Set new ODT State = 03.
U 2743, 0000,0560,0175,0115	;8200				NAF/REG-NEW-101	
				;8201	=
				;8202	
				;8203	=10********0	; PS, default.
U 2744, 0036,6200,0041,1412	;8204	NPLA0	[P.ODT, ^XX X1X X11 X0001010]	; ODT State = X1X 111, character <LF>.
				;8205						; If no NAF override, then write new
				;8206						;  data to the PS and close the PS.
				;8207		LLD.W	[070, RD],		; Set new ODT State = 70.
U 2745, 0000,0560,3435,0105	;8208				NAF/CARR1	; Join common code.
				;8209	=
				;8210	
				;8211	=10********0	; Override for no new data was entered.
U 2746, 0037,4600,0040,1012	;8212	NPLA0	[P.ODT, ^XX XXX 01X X0001010]	; Override NAF field.
				;8213	
				;8214		NOP.W	[RF, RF],		; Do not change the Load Literal instruction.
U 2747, 0000,1771,7777,1772	;8215				NAF/1772	; Override to REG-NO-000, MEM-NO-010
				;8216	=					;  or PROMPT.  
				;8217	
				;8218	
				;8219	=0*000
				;8220	REG-NO-000:
				;8221		LADD.W	[001, RB],		; Add 1 to the current register number.
U 0110, 0000,0440,0073,1353	;8222				NAF/LINE3
				;8223	
				;8224	
				;8225	=010
				;8226	MEM-NO-010:
				;8227		LADD.L	[002, RB],		; Add 2 to the current 22-bit memory address.
U 0112, 0000,0442,0133,1003	;8228				NAF/LINE
				;8229	
				;8230	=101
				;8231	REG-NEW-101:
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  197
; ODT   .MCD [242,1110]      Line Feed

				;8232		MOV.W	[RC, RDST],		; Write RC<15:0> (new data) to the 
U 0115, 0000,1561,7606,0110	;8233				NAF/REG-NO-000	;  current register location.
				;8234	
				;8235	=111					 
				;8236	MEM-NEW-111:				
				;8237		AW	[RB],			; Relocate current memory location's 
				;8238			CONSOLE MODE,		;  address using Console Mode.
U 0117, 0000,0771,5373,1350	;8239			ODD TRAP
				;8240	=
				;8241	
				;8242		MOV.W	[RC, RC],		; Write RC<15:0> (new data) to the 
U 1350, 0000,1561,7634,0112	;8243				NAF/MEM-NO-010	;  current memory location.
				;8244	
				;8245	=0*0*****				; See note #1.
				;8246	LINE:
				;8247		LMSTK	[LINE1, RA],
U 1003, 0000,0535,6472,1005	;8248				NAF/CR-LF	; Print a <CR> and <LF> to the console.
				;8249	=
				;8250	LINE1:
				;8251		LMSTK	[LINE2, RA],		
U 1351, 0000,0535,6532,1406	;8252				NAF/PRINT-22	; Print the 22-bit address to the console.
				;8253	
				;8254	LINE2:					; Set up return to SLASH-AA.
				;8255		LMSTK	[SLASH-AA, RE],		; Load RE<7:0> with 057 ASCII value of </>.
U 1352, 0000,0530,2776,0012	;8256				NAF/OUTPUT	; Print a </> to the console.
				;8257	
				;8258	LINE3:
				;8259		LMSTK	[LINE4, RA],
U 1353, 0000,0535,6632,1005	;8260				NAF/CR-LF	; Print a <CR> and <LF> to the console.
				;8261	
				;8262	LINE4:
				;8263		LMSTK	[LINE5, RE],		; Load MSTK, RE<7:0> with 122 (ASCII <R>).
U 1354, 0000,0530,5136,0012	;8264				NAF/OUTPUT	; Print an <R> to the console.
				;8265	
				;8266	122:
				;8267	LINE5:					; ASCII code for "R".
U 0122, 0000,1567,7576,1355	;8268		MOV.B	[RB, RE]		; Move register number to RE<7:0>.
				;8269	
				;8270		LMSTK	[LINE6, RA],
U 1355, 0000,0535,6732,1417	;8271				NAF/P-ASCII	; Print the ASCII number to the console.
				;8272	
				;8273	;P-ASCII:
				;8274	;	LAND.B	[007, RE]		; Save only the octal digit.
				;8275	;
				;8276	;	LBIS.B	[060, RE],		; Convert to ASCII format.
				;8277	;			NAF/OUTPUT	; Print the digit.
				;8278	
				;8279	LINE6:					; Set up return to SLASH-BB.
				;8280		LMSTK	[SLASH-BB, RE],		; Load RE<7:0> with 057 ASCII value of </>.
U 1356, 0000,0534,2776,0012	;8281				NAF/OUTPUT	; Print a </> to the console.
				;8282	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  198
; ODT   .MCD [242,1110]      Control-Shift-S

				;8283		.TOC	"		Control-Shift-S"
				;8284	
				;8285	
				;8286	;****************************************************************************
				;8287	;*                                                                          *
				;8288	;*                          "CONTROL-SHIFT-S"                               *
				;8289	;*                                                                          *
				;8290	;****************************************************************************
				;8291	
				;8292	
				;8293	=10********0	; State = XXX 000; Character Control-Shift-S.
U 2750, 0037,4200,0040,0023	;8294	NPLA0	[P.ODT, ^XX XXX 000 X0010011]
				;8295		LMSTK	[APT1, RA],		; Read in high byte <15:8> of starting
U 2751, 0000,0530,0272,0004	;8296				NAF/INPUT	;  address to RE<7:0>.
				;8297	=
				;8298	=00********				; Due to word length of default PLA, bits<9,8>=0.
				;8299	APT1:
U 0005, 0000,1467,7737,1357	;8300		SWAB.B	[RE, RF]		; Form high byte of address in  RF<15:8>.
				;8301	=
				;8302		LMSTK	[APT2, RA],		; Read low byte <7:0> of starting
U 1357, 0000,0535,7032,0004	;8303				NAF/INPUT	;  address to RE<7:0>.
				;8304	
				;8305	APT2:					; Finish constructing starting
U 1360, 0000,1567,7737,1361	;8306		MOV.B	[RE, RF]		;  address in RF<15:0>.
				;8307	
U 1361, 0000,0520,0572,1362	;8308		LCNTR.W	[013, RA]		; Set loop for 10(decimal) bytes of output.
				;8309	
				;8310	APT3:	
U 1362, 0000,1461,7775,1363	;8311		SWAB.W	[RF, RD]		; Move bits <15:13> of RF into RD<7:5>.
				;8312				
U 1363, 0000,0511,6035,1364	;8313		LAND.W	[340, RD]		; Clear bits <15:8,4:0>.
				;8314	
U 1364, 0000,1231,7675,1365	;8315		ASL.W	[RD, RD]		; Original bits <15:13> of RF are now aligned
				;8316						;  with bits <9:7> of the temporary CPAR.
				;8317	
				;8318		ASL.W	[RD, RD],		; Loop complete?   YES, goto PROMPT.
				;8319			DECR CNTR,		; NO, print out the next byte.
U 1365, 0000,1231,3675,0101	;8320				NAF/101		; RD<6:0> are zeroed, new ODT State = 00.
				;8321	
				;8322	101:					; Required so DECR CNTR will force a return
U 0101, 0000,0250,6375,1366	;8323		OUTR.W	[CPAR, RD]		;  to PROMPT (100).
				;8324						; Move temp CPAR to the real CPAR.
				;8325		ARI.B	[RF],			
U 1366, 0000,0705,5777,1367	;8326			CONSOLE MODE		; Relocate using calculated CPAR. 
				;8327	
U 1367, 0000,0327,7776,1370	;8328		RD.B	[RE]			; Read contents of relocated address
				;8329						;  to RE<7:0>. 
				;8330		LMSTK	[APT3, RA],
U 1370, 0000,0535,7132,0012	;8331				NAF/OUTPUT	; Print out the addressed byte.
				;8332	
				;8333	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  199
; ODT   .MCD [242,1110]      Subroutines

				;8334		.TOC	"	Subroutines"
				;8335	
				;8336		.TOC	"		Input Routine"
				;8337	
				;8338	
				;8339	;
				;8340	; Inputs from receiver buffer register.
				;8341	;
				;8342	; Entry points:
				;8343	;
				;8344	;	INPUT		When ready reads the RBUF.
				;8345	;	READ		Reads the RBUF.
				;8346	;
				;8347	; Entry conditions:
				;8348	;
				;8349	;	MSTK contains the return address.
				;8350	;
				;8351	; Exit points:
				;8352	;	
				;8353	;	If RBUF or RCSR abort goto ROM[0].
				;8354	;
				;8355	; Exit conditions:
				;8356	;
				;8357	;	RA<15:0>	Destroyed.
				;8358	;	RE<23:16>	Destroyed.
				;8359	;	RE<7:0>		Contains input character.
				;8360	;
				;8361	
				;8362	=0*00****				; See notes #1, and #2.
				;8363	INPUT:
U 0004, 0000,0471,0772,1371	;8364		LLCM.W	[217, RA]		; Generate the virtual address of RCSR = 177560.
				;8365	=
				;8366	
				;8367		AR	[RA],			; Relocate RCSR address using
U 1371, 0000,0731,7572,1372	;8368			16-BIT MAP		;  16-bit mapping.
				;8369	
U 1372, 0000,0327,7756,1373	;8370		RD.B	[RE.H]			; Read RCSR to RE<23:16>.
				;8371	
				;8372		JAN	[READ],			; Wait for ready flag (RCSR<7> = 1), then goto READ.
U 1373, 0000,0175,7637,0004	;8373				NAF/INPUT
				;8374	
				;8375	READ:
U 1374, 0000,0471,0672,1375	;8376		LLCM.W	[215, RA]		; Generate the address of RBUF = 177562
				;8377	
				;8378		AR	[RA],			; Relocate RBUF address using
U 1375, 0000,0731,7572,1376	;8379			16-BIT MAP		;  16-bit mapping.
				;8380	
U 1376, 0000,0327,7776,1377	;8381		RD.B	[RE]			; Read character to RE<7:0>.
				;8382	
				;8383	RETURN:					; Wait for abort on NA = RESET5.
				;8384		ASL.L	[R8, R8],		; For Print Routine, start accumulating
				;8385						;  octal digit; Otherwise, NOP.
U 1377, 0000,1233,7430,0024	;8386				NAF/RESET5	; Set abort NA to ODT-ABORT.
				;8387	
				;8388	;=0*0****0				; Abort to ROM[0] for ODT I/O routines.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  200
; ODT   .MCD [242,1110]      Input Routine

				;8389	;RESET5:				; Return from print loop in ODT.
				;8390	;	CLR.W	[RA, RA],		; For RESET-SUB, clear PIRQ in all chips.
				;8391	;			NAF/240		; For RESET-SUB, abort to ROM[MSTK AND 240].
				;8392	;					; For SI power up, abort to ROM[240].
				;8393	;					; For ODT, save code; return.
				;8394	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  201
; ODT   .MCD [242,1110]      Output Routine

				;8395	.TOC	"		Output Routine"
				;8396	
				;8397	
				;8398	; Outputs to transmitter buffer register.
				;8399	;
				;8400	; Entry conditions:
				;8401	;
				;8402	;	RE<7:0>		Contains data to be output.
				;8403	;	MSTK		Contains the return address(s).
				;8404	;			Note:  If entered from CR-LF, PRINT-16, or PRINT-22
				;8405	;			       the microstack is filled to its maximum of two.	
				;8406	;
				;8407	; Exit points:
				;8408	;
				;8409	;	If XCSR or XBUF abort goto ROM[0].
				;8410	;	
				;8411	; Exit conditions:
				;8412	;
				;8413	;	RA<15:0>	Destroyed.
				;8414	;	RE<23:16>	Destroyed.
				;8415	;
				;8416	
				;8417	
				;8418	=0*00****				; See notes #1, and #2.
				;8419	OUTPUT:
U 0012, 0000,0671,1637,1004	;8420		AWG.W	[LED4_ON]		; Light LED 4 and signal RD processor.
				;8421	=
				;8422	=0*0*****				; See note #1.
				;8423	OUTPUT1:
U 1004, 0000,0471,0572,1400	;8424		LLCM.W	[213, RA]		; RA <= 177564; virtual address of XCSR.
				;8425	=
				;8426		AR	[RA],			; Relocate XCSR address using
U 1400, 0000,0731,7572,1401	;8427			16-BIT MAP		;  16-bit mapping.
				;8428	
U 1401, 0000,0327,7756,1402	;8429		RD.B	[RE.H]			; Read XCSR to RE<23:16>.
				;8430	
				;8431		JAN	[WRITE],		; Wait for Done flag (XCSR<7> = 1),
U 1402, 0000,0176,0177,1004	;8432				NAF/OUTPUT1	;  then goto WRITE.
				;8433	
				;8434	WRITE:
U 1403, 0000,0471,0472,1404	;8435		LLCM.W	[211, RA]		; RA <= 177566; virtual address of XBUF.
				;8436	
				;8437		AW	[RA],			; Relocate XBUF address using
U 1404, 0000,0771,7572,1405	;8438			16-BIT MAP		;  16-bit mapping.
				;8439	
				;8440		MOV.B	[RE, RE],		; Write RE<7:0> to XBUF (print character).
U 1405, 0000,1567,7736,1377	;8441				NAF/RETURN	; Wait for possible abort condition. 
				;8442	
				;8443	;RETURN:				; Wait for abort on NA = RESET5.
				;8444	;	ASL.L	[R8, R8],		; For Print Routine, start accumulating
				;8445	;					;  octal digit; Otherwise, NOP.
				;8446	;			NAF/RESET5	; Set abort NA to ODT-ABORT.
				;8447	
				;8448	;=0*0****0				; Abort to ROM[0] for ODT I/O routines.
				;8449	;RESET5:				; Return from print loop in ODT.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  202
; ODT   .MCD [242,1110]      Output Routine

				;8450	;	CLR.W	[RA, RA],		; For RESET-SUB, clear PIRQ in all chips.
				;8451	;			NAF/240		; For RESET-SUB, abort to ROM[MSTK AND 240].
				;8452	;					; For SI power up, abort to ROM[240].
				;8453	;					; For ODT, save code; return.
				;8454	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  203
; ODT   .MCD [242,1110]      Carriage Return and Line Feed

				;8455		.TOC	"		Carriage Return and Line Feed"
				;8456	
				;8457	
				;8458	;
				;8459	; Prints <CR> and <LF>.
				;8460	;
				;8461	; Entry conditions:
				;8462	;
				;8463	;	MSTK		Contains the return address.
				;8464	;
				;8465	; Exit conditions:
				;8466	;
				;8467	;	RE<15:0>	Destroyed.
				;8468	;	RA<15:0>	Destroyed.
				;8469	;
				;8470	
				;8471	=0*0*****
				;8472	CR-LF:
				;8473		LMSTK	[RETN1, RE],		; Load MSTK, RE<15:0> with 015 (ASCII <CR>).
U 1005, 0000,0530,0676,0012	;8474				NAF/OUTPUT	; Print <CR>.
				;8475	=
				;8476	
				;8477	0015:
				;8478	RETN1:
				;8479		LLD.B	[012, RE],		; ASCII value of <LF>.
U 0015, 0000,0566,0536,0012	;8480				NAF/OUTPUT	; Print <LF>.  Return to CR-LF call.
				;8481	
				;8482	
				;8483	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  204
; ODT   .MCD [242,1110]      Print Routine

				;8484		.TOC	"		Print Routine"
				;8485	
				;8486	
				;8487	;
				;8488	; Converts 22-bit addresses and 16-bit data to ASCII octal digits
				;8489	;  and prints to console.
				;8490	;
				;8491	; Entry points:
				;8492	;
				;8493	;	PRINT-22	Prints 22-bit addresses.
				;8494	;	PRINT-16	Prints 16-bit data.
				;8495	;
				;8496	; Entry conditions:
				;8497	;
				;8498	;	RB<23:0>	Value to be displayed, for PRINT-22.
				;8499	;	RB<15:0>	Value to be displayed, for PRINT-16.
				;8500	;	MSTK		Contains the return address.
				;8501	;
				;8502	; Exit conditions:
				;8503	;
				;8504	;	R8<31:0>	Destroyed.
				;8505	;	RA<15:0>	Destroyed.
				;8506	;	RE<15:0>	Destroyed.
				;8507	;
				;8508	
				;8509	
				;8510	PRINT-22:
U 1406, 0000,1233,7570,1407	;8511		ASL.L	[RB, R8]		; Move address (memory location) to R8
				;8512						;  and align MSB of the 22-bit address
U 1407, 0000,1233,7430,1410	;8513		ASL.L	[R8, R8]		;  with R8<23>.
				;8514	
				;8515		LCNTR.B	[010, RA],		; Load CNTR for 8 (decimal) digits printed.
U 1410, 0000,0526,0432,1413	;8516				NAF/PRINT1	; Join common code.
				;8517	
				;8518	=0*0*****
				;8519	PRINT-16:
U 1006, 0000,1461,7430,1411	;8520		SWAB.W	[R8, R8]		; Align MSB of 16-bit data with R8<23>
				;8521	=
U 1411, 0000,1567,7410,1412	;8522		MOV.B	[R8, R8.H]		;  by swapping bytes.
				;8523	
U 1412, 0000,0526,0332,1413	;8524		LCNTR.B	[06, RA]		; Load CNTR for 6 digits printed.
				;8525	
				;8526	PRINT1:
				;8527		LLSW.B	[000, R8.H],		; Clear R8<31:24> in preperation of
U 1413, 0000,0466,0010,0025	;8528				NAF/PRINT2	;  1st digit.  Go shift once.
				;8529	
				;8530	PRINT3:
				;8531		ASL.L	[R8, R8],		; Shift 2nd time. (1st shift at RETURN).
				;8532						; If CNTR is 0, last digit was already
				;8533			DECR CNTR,		;  printed, goto RESET5.
U 1414, 0000,1233,3430,0025	;8534				NAF/PRINT2	; Otherwise, finish shifting at PRINT2.
				;8535	
				;8536	=0*0****0				; Abort to ROM[0] for ODT I/O routines.
				;8537	RESET5:					; Return from print loop in ODT.
				;8538		CLR.W	[RA, RA],		; For RESET-SUB, clear PIRQ in all chips.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  205
; ODT   .MCD [242,1110]      Print Routine

U 0024, 0000,1041,7532,0240	;8539				NAF/240		; For RESET-SUB, abort to ROM[MSTK AND 240].
				;8540						; For SI power up, abort to ROM[240].
				;8541						; For ODT, save code; return.
				;8542	PRINT2:
U 0025, 0000,1233,7430,1415	;8543		ASL.L	[R8, R8]		; Shift digit into position. 
				;8544	=
				;8545	
U 1415, 0000,1461,6436,1416	;8546		SWAB.W	[R8.H, RE]		; Move octal digit in R8<31:24> to RE<7:0>.
				;8547	
U 1416, 0000,0536,0632,1417	;8548		LMSTK	[PRINT3, RA]		; Set return for top of loop.
				;8549	
				;8550	P-ASCII:
U 1417, 0000,0516,0376,1420	;8551		LAND.B	[007, RE]		; Save only the octal digit.
				;8552	
				;8553		LBIS.B	[060, RE],		; Convert to ASCII format.
U 1420, 0000,0576,3036,0012	;8554				NAF/OUTPUT	; Print the digit.
				;8555	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  206
; FP11  .MCD [242,1110]      FP11.MCD

				;8556		.TOC	"FP11.MCD"
				;8557		.TOC	"REVISION 3.37"
				;8558	
				;8559	
;8560	.NOBIN
;8561	
;8562	
;8563		.TOC	"	Revision History"
;8564	
;8565	;
;8566	;	Revision History
;8567	;	----------------
;8568	;
;8569	; Rev.     Date		Explaination
;8570	; ----     ----		------------
;8571	;
;8572	;	Release		01/04/83	(Mini-pass for RTI-RTT fix)
;8573	; 3.37 	 01/04/83	KEH; Added FCC masking between RDG.W and Prefetch/Predecode
;8574	;			     for FPA timing (see CFCC3).
;8575	; 3.36	 06/17/82	KEH; Left PC alone after abort instead of restoring it.
;8576	;			     MMR2 has PC for MMU aborts.
;8577	; 3.35	 06/11/82	KEH; Used JC to test for STCfi exception.
;8578	;			     Switched to ANNEG instead of NNEG also in STCfi.
;8579	; 3.34	 05/13/82	KEH; Fixed hot ABS/NEG mode 27 by expanding use of
;8580	;			     P.FSRC-R0.
;8581	; 3.33	 03/17/82	KEH; Fixed hot STST non-mode 0.
;8582	; 3.32   03/05/82	KEH; Fixed register code in hot mode 0 stores.
;8583	; 3.31   02/27/82	KEH; Caused FP-TRAP to do full resynchronize if FID as
;8584	;			     ID1 flips PIR select when FPE acknowledged.
;8585	; 3.30   02/15/82	KEH; Fixed LDEXP bug and speeded up hot non-io.
;8586	;	 Release
;8587	; 2.29   01/21/82	KEH; Finished rewrite.  Eliminated PC save in FEATMP
;8588	;			     for warm FP.
;8589	; 2.28   01/15/82	KEH; Switched sense of CPFF because new warm DST/FDST
;8590	;			     mode 0 decode must use old PIR<12>.
;8591	; 2.27   01/14/82	KEH; Finished support mode.  Started addressing
;8592	;			     rewrite for warm speedup.
;8593	; 2.26   01/06/82	KEH; Changed SRC and SETx/CFCC operand register.
;8594	; 2.25   01/02/82	KEH; Started adding FPA support code.
;8595	; 2.24   12/30/81	KEH; Fixed PC restore for STCfi interrupt.
;8596	; 2.23   12/19/81	KEH; Fixed abort NA for FSRC mode 27.
;8597	; 2.22   12/09/81	KEH; Addressing rewrite.  Added more interrupt checks.
;8598	; 2.21   12/02/81	KEH; Started using new MMU scratchpads.
;8599	; 2.20   11/13/81	KEH; Fixed MODf exponent boundary conditions.
;8600	; 2.19   11/06/81	KEH; Changed FEC register due to conflict with CMPf.
;8601	; 2.18   10/30/81	KEH; ADDf/SUBf alignment change.  Speeded alignment by
;8602	;			     decoding arbitrary out of shift boundary (~64).
;8603	;			     Hundreds of miscellaneous changes due to debug.
;8604	; 2.17   09/15/81	KEH; Integrated addressing.  Added ABSf and NEGf.
;8605	;			     Started debug.
;8606	; 2.16   08/13/81	KEH; Interleaved AC and FSRC register assignments for
;8607	;			     ADDf/SUBf overrides.
;8608	; 2.15   08/08/81	KEH; Re-organized end sequence for arithmetics;
;8609	;			     store AC and FCCs before checking over/underflow.
;8610	;			     Minor time penalty for interrupts disabled.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  207
; FP11  .MCD [242,1110]      Revision History

;8611	;			     Modified LDEXP for new end sequence.
;8612	;			     Integrated LDCfd with LDf and new arithmetic.
;8613	; 2.14   08/05/81	KEH; Deleted DIVf optimization.  First bit, -AC, was
;8614	;			     used for local normalization (1 cycle average).
;8615	;			     Shared more overhead code with MULf/MODf and
;8616	;			     gained 1.5 cycles average back again.
;8617	; 2.13   07/22/81	KEH; Finished CMP.  Started MOD.
;8618	;	 Release
;8619	; 1.12   06/22/81	KEH; Started ADD and SUB.  Integrated LDCif, LDEXP.
;8620	;			     Started integration of all arithmetics.
;8621	; 1.11   05/27/81	KEH; Moved more code into Common Routine section.
;8622	; 1.10   05/17/81	KEH; Changed Interrupt Restore to RFS for FPA support.
;8623	;			     Added many miscellaneous instructions.
;8624	; 1.09   05/13/81	KEH; Added Mantissa Extractors and Interrupt Restore.
;8625	; 1.08   05/07/81	KEH; Added Exponent Extractors and integrated them.
;8626	; 1.07   05/01/81	KEH; Started on MUL, MOD, and DIV loops and planning.
;8627	; 1.06   04/15/81	KEH; Fixed STEXP to set CCs, FCCs based on DST.
;8628	; 1.05   04/06/81	KEH; Padded out code with instruction descriptions.
;8629	; 1.04   04/04/81	KEH; Rewrite of STCfi for maximum of 8 shifts.
;8630	; 1.03   04/01/81	KEH; Added name PLAs; Generalized common tasks.
;8631	; 1.02   03/24/81	KEH; Altered LDCif to call normalization PLAs.
;8632	; 1.01   03/22/81	KEH; Altered SETx and CFCC to eliminate explicit address
;8633	;			     constraints.  Reorganized code.
;8634	; 1.00   01/14/81	HND; Started writing code.
;8635	;
;8636	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  208
; FP11  .MCD [242,1110]      Introductory Remarks

;8637		.PAGE	"	Introductory Remarks"
;8638	
;8639	;
;8640	;	This microcode implements the PDP-11 Floating Point Instruction Set.
;8641	;	This code resides in Control chip 0 along with the Base Instruction
;8642	;	Set and Micro-ODT.
;8643	;
;8644	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  209
; FP11  .MCD [242,1110]      Floating Point Addressing

;8645		.TOC	"	Floating Point Addressing"
;8646	
;8647	;
;8648	; Floating point instructions are categorized
;8649	; by their type of addressing.
;8650	;
;8651	
;8652	; No addressing instructions:
;8653	;	SETf		000 000 00f 001
;8654	;	SETi		000 000 00l 010
;8655	;	CFCC		000 000 000 000
;8656	;
;8657	
;8658	; SRC addressing instructions:
;8659	;	LDFPS		000 001 XXX XXX
;8660	;	LDEXP		110 1AC XXX XXX
;8661	;	LDCif		111 0AC XXX XXX
;8662	; Do:
;8663	;	RE	<= SRC	(longword for LDCLf)
;8664	;
;8665	
;8666	; DST addressing instructions:
;8667	;	STST		000 011 XXX XXX
;8668	;	STFPS		000 010 XXX XXX
;8669	;	STEXP		101 0AC XXX XXX
;8670	;	STCfi		101 1AC XXX XXX
;8671	; Do:
;8672	;	DST	<= RF.H
;8673	;	DST	<= RF.H @ RF.L	(STST and STCfL only)
;8674	;
;8675	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  210
; FP11  .MCD [242,1110]      Floating Point Addressing

;8676	; FSRC addressing instructions:
;8677	;	TSTf		000 101 XXX XXX
;8678	;	LDf		010 1AC XXX XXX
;8679	;	LDCfd		111 1AC XXX XXX
;8680	;	CMPf		011 1AC XXX XXX
;8681	;	ADDf		010 0AC XXX XXX
;8682	;	SUBf		011 0AC XXX XXX
;8683	;	MULf		001 0AC XXX XXX
;8684	;	MODf		001 1AC XXX XXX
;8685	;	DIVf		100 1AC XXX XXX
;8686	; Do:
;8687	;	RB.L	<= FSRC.3		(RF for hot mode 27)
;8688	;	RF.L	<= FSRC.2
;8689	;	RD	<= FSRC.1 @ FSRC.0	(Double only)
;8690	;
;8691	
;8692	; FDST addressing instructions:
;8693	;	STf		100 0AC XXX XXX
;8694	;	CLRf		000 100 XXX XXX
;8695	;	STCfd		110 0AC XXX XXX
;8696	; Do:
;8697	;	FDST.3	<= RF.H
;8698	;	FDST.2	<= RF.L
;8699	;	FDST.1	<= RD.H			(Double only)
;8700	;	FDST.0	<= RD.L			(Double only)
;8701	;
;8702	
;8703	; FRMW addressing instructions:
;8704	;	ABSf		000 110 XXX XXX
;8705	;	NEGf		000 111 XXX XXX
;8706	; Do:
;8707	;	FSRC addressing, then re-enter as
;8708	;	FDST addressing.
;8709	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  211
; FP11  .MCD [242,1110]      Floating Point Addressing

				;8710	.BIN
				;8711	
				;8712	
				;8713	; Initial breakout.
				;8714	; Generate 6 NAs.
				;8715	
				;8716	=10********0	; Breakout warm floating ops.
U 2752, 0000,7777,3777,0000	;8717	NPLA0	[ID1, ^1 1111 XXX XXX XXX XXX]
				;8718		MOV.W	[IRFE, R9],		; Opcode to a-bus for OUTS reload.
U 2753, 0000,1561,6071,1671	;8719				NAF/FPD0	; Overridden if mode 0 or non-io.
				;8720	=
				;8721	=10********0	; Breakout hot floating ops.
U 2754, 0000,7777,3757,0000	;8722	NPLA0	[ID1, ^0 1111 XXX XXX XXX XXX]
				;8723		MOV.W	[IRFE, R9],		; Opcode to a-bus for OUTS reload.
U 2755, 0000,1561,6071,0673	;8724				NAF/P.FPC3	; Invoke FP class overrides.
				;8725	=
				;8726	=10********0	; Override on mode 0 floating ops.
U 2756, 0020,7707,3757,0000	;8727	NPLA0	[ID1, ^X 1111 XXX XXX 000 XXX]
				;8728		NOP.W	[RF, RF],
U 2757, 0000,1771,7777,0672	;8729				NAF/P.FPC2	; Override; Invoke FP class overrides.
				;8730	=
				;8731	=10********0	; Override on no addressing.
U 2760, 0020,0077,3757,0000	;8732	NPLA0	[ID1, ^X 1111 000 000 XXX XXX]
				;8733		NOP.W	[RF, RF],
U 2761, 0000,1771,7777,0262	;8734				NAF/FPD3	; Override; Salvage warm/hot decode.
				;8735	=
				;8736	=0**0***000	; Warm.non-io		; Must override P.FPC0 (0670).
				;8737		INPR.W	[FPS, RE],		; Get FPS for update.
U 0260, 0000,0210,2736,0732	;8738				NAF/P.FPE2	; Disable PIR<16> check for warm.
				;8739						; Entry for warm CFCC.
				;8740	=10
				;8741	FPD3:		; Hot.non-io		; Ignore mode 0 override.
U 0262, 0000,0210,6650,1421	;8742		INPR.W	[FEATMP, R8.H]		; Get potential FEA of previous op.
				;8743	=
				;8744		INPR.W	[FPS, RE],		; Get FPS for update.
U 1421, 0000,0210,2736,0731	;8745				NAF/P.FPE1	; Check PIR<16> for hot.
				;8746						; No need to save PC.
				;8747	
				;8748	=*11*111*0*				; FPD0 AND P.FPC2 (672) => P.FPC0 (670).
				;8749	FPD0:		; Warm.non-mode 0.
				;8750		OUTS	[LD_FPS, R9],		; Load FPS flops.
U 1671, 0000,0271,7571,0670	;8751				NAF/P.FPC0	; Now invoke class overrides.
				;8752	=
				;8753	
				;8754	; The FP class overrides (see next page) are invoked by:
				;8755	;
				;8756	;	P.FPC0	= 0670		; Short modes decode.
				;8757	;	P.FPC1	= 0671		; unused.
				;8758	;	P.FPC2	= 0672		; Hot mode zero decode.
				;8759	;	P.FPC3	= 0673		; Hot non-mode 0 decode.
				;8760	;	P.FPC4	= 0674		; Long modes second decode.
				;8761	;	P.FPC5	= 0675		; Ditto.
				;8762	;	P.FPC6	= 0676		; Ditto.
				;8763	;	P.FPC7	= 0677		; Ditto.  High address for mode 37 override.
				;8764	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  212
; FP11  .MCD [242,1110]      Floating Point Addressing

				;8765	; FP class overrides.
				;8766	
				;8767	; These override zero NAF bits to distinguish instruction class:
				;8768	;
				;8769	;=00	; DST class.
				;8770	;=01	; FDST class.
				;8771	;=10	; SRC class.
				;8772	;=11	; FSRC class (default).
				;8773	
				;8774	; Integer stores.
				;8775	; P.FPCx
				;8776	=11********0	; STCfi and STEXP.
U 3000, 0377,0777,3400,5000	;8777	PLA1	[^0 111 XXX, ^XXXX 101 XXX XXX XXX]
				;8778		NOP.W	[RF, RF],
U 3001, 0000,1771,7777,1774	;8779				NAF/1774	; Override NAF<1:0>.
				;8780	=
				;8781	=11********0	; STFPS and STST.
U 3002, 0377,0177,3400,0200	;8782	PLA1	[^0 111 XXX, ^XXXX 000 01X XXX XXX]
				;8783		NOP.W	[RF, RF],
U 3003, 0000,1771,7777,1774	;8784				NAF/1774	; Override NAF<1:0>.
				;8785	=
				;8786	
				;8787	; Floating stores.
				;8788	; P.FPCx
				;8789	=11********0	; STf and STCfd.
U 3004, 0377,2377,3400,4000	;8790	PLA1	[^0 111 XXX, ^XXXX 1X0 0XX XXX XXX]
				;8791		NOP.W	[RF, RF],
U 3005, 0000,1771,7777,1775	;8792				NAF/1775	; Override NAF<1>.
				;8793	=
				;8794	=11********0	; CLRf.
U 3006, 0377,0077,3400,0400	;8795	PLA1	[^0 111 XXX, ^XXXX 000 100 XXX XXX]
				;8796		NOP.W	[RF, RF],
U 3007, 0000,1771,7777,1775	;8797				NAF/1775	; Override NAF<1>.
				;8798	=
				;8799	
				;8800	; Integer loads.
				;8801	; P.FPCx
				;8802	=11********0	; LDCif.
U 3010, 0377,0377,3400,7000	;8803	PLA1	[^0 111 XXX, ^XXXX 111 0XX XXX XXX]
				;8804		NOP.W	[RF, RF],
U 3011, 0000,1771,7777,1776	;8805				NAF/1776	; Override NAF<0>.
				;8806	=
				;8807	=11********0	; LDEXP.
U 3012, 0377,0377,3400,6400	;8808	PLA1	[^0 111 XXX, ^XXXX 110 1XX XXX XXX]
				;8809		NOP.W	[RF, RF],
U 3013, 0000,1771,7777,1776	;8810				NAF/1776	; Override NAF<0>.
				;8811	=
				;8812	=11********0	; LDFPS.
U 3014, 0377,0077,3400,0100	;8813	PLA1	[^0 111 XXX, ^XXXX 000 001 XXX XXX]
				;8814		NOP.W	[RF, RF],
U 3015, 0000,1771,7777,1776	;8815				NAF/1776	; Override NAF<0>.
				;8816	=
				;8817	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  213
; FP11  .MCD [242,1110]      Floating Point Addressing

				;8818	; Dispatch for hot FP mode 0.
				;8819	; Quick FSRC and FDST mode.
				;8820	
				;8821	; For FSRC and FDST, support FEA only.
				;8822	; For SRC and DST, pass integer data with GP read/writes.
				;8823	; J-11 has STST data.
				;8824	
				;8825	=11********0	; Default for class overrides.
U 3016, 0037,7777,3500,0000	;8826	NPLA1	[P.FPC2, ^X]
				;8827		INPR.W	[FEATMP, R8.H],		; Get potential FEA for previous op.
U 3017, 0000,0210,6650,0137	;8828				NAF/FPD2	; Separate into classes.
				;8829	=
				;8830	; P.FPC2 + P.FPC3
				;8831	=11********0	; Override on STST.
U 3020, 0077,0077,3500,0300	;8832	PLA1	[^0 111 01X, ^XXXX 000 011 XXX XXX]
				;8833		NOP.W	[RF, RF],
U 3021, 0000,1771,7777,1773	;8834				NAF/1773	; Override NAF<2>.  NAF<1:0> overridden
				;8835	=					;  by class overrides.
				;8836	
				;8837	=000	; STST.
				;8838		INPR.W	[FEC, RF.H],		; Get FEC received at FPE acknowledge.
U 0130, 0000,0210,2317,0731	;8839				NAF/P.FPE1	; Needn't save PC (can't except).
				;8840						; Check for previous FPE.
				;8841	=00	; DST class.-STST.
				;8842		ARG.W	[FPA_RD],		; Initiate read of integer data.
U 0134, 0000,0630,0077,1422	;8843				NAF/FPA1	; Skip.
				;8844		; FDST class.
				;8845		OUTR.W	[FEATMP, PC],		; Save potential FEA of this op.
U 0135, 0000,0250,6667,0731	;8846				NAF/P.FPE1	; Check for previous FPE.
				;8847		; SRC class.
				;8848		AWG.W	[FPA_WR],		; Initiate GP write of integer data.
U 0136, 0000,0670,0177,1423	;8849				NAF/FPA2	; Skip.
				;8850	FPD2:	; FSRC class.
				;8851		OUTR.W	[FEATMP, PC],		; Save potential FEA of this op.
U 0137, 0000,0250,6667,0731	;8852				NAF/P.FPE1	; Check for previous FPE.
				;8853	=
				;8854	FPA1:
				;8855		RDG.W	[RF.H],			; Get integer data to scratch.
				;8856						; Update RDST after FPE check.
U 1422, 0000,0361,7757,0137	;8857				NAF/FPD2	; Go back.  Join FSRC mode 0.
				;8858	FPA2:
U 1423, 0000,1561,6336,1424	;8859		MOV.W	[RDST, RE]		; Send integer data to FPA.
				;8860	
				;8861		NOP.B	[RF, RF],		; Stall.  Wait for overlapped FPE.
U 1424, 0000,1777,7777,0137	;8862				NAF/FPD2	; Go back.  Join FSRC mode 0.
				;8863	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  214
; FP11  .MCD [242,1110]      Floating Point Addressing

				;8864	; Dispatch for hot FP non-mode 0.
				;8865	; FPS flops reload.
				;8866	; Special cases decode.
				;8867	
				;8868	=11********0	; Default for class overrides.
U 3022, 0037,7777,3540,0000	;8869	NPLA1	[P.FPC3, ^X]
				;8870		OUTS	[LD_FPS, R9],		; PIR <= FPS flops, CPFF, opcode.
U 3023, 0000,0271,7571,1674	;8871				NAF/FPD1	; Separate into classes.
				;8872	=
				;8873	=11********0	; Override for STf speedup.
U 3024, 0037,0377,3540,4000	;8874	NPLA1	[P.FPC3, ^XXXX 100 0XX XXX XXX]
				;8875		NOP.W	[RF, RF],
U 3025, 0000,1771,7777,0670	;8876				NAF/P.FPC0	; Override to address calculation.
				;8877	=
				;8878	;; P.FPC2 + P.FPC3
				;8879	;=11********0	; Override on STST.
				;8880	;PLA1	[^0 111 01X, ^XXXX 000 011 XXX XXX]
				;8881	;	NOP.W	[RF, RF],
				;8882	;			NAF/1773	; Override NAF<2>.
				;8883	;=
				;8884	
				;8885	=11*111000	; STST.			; Must override to P.FPC0 for STf.
				;8886		INPR.W	[FEC, RF.H],		; Get last FEC recieved.
U 1670, 0000,0210,2317,1425	;8887				NAF/STST0	; Skip.
				;8888	
				;8889	=100					; Start new block.
				;8890	FPD1:	; -STST.-STf.
				;8891		MOV.W	[PC, R9.H],		; Save initial PC.
U 1674, 0000,1561,7351,0670	;8892				NAF/P.FPC0	; Dispatch to address calculation.
				;8893	=
				;8894	STST0:
				;8895		INPR.W	[FEA, RF],		; Get last FEA.
U 1425, 0000,0210,2777,0670	;8896				NAF/P.FPC0	; Join address calculation.
				;8897	
				;8898	; For non-mode 0, the class overrides are invoked
				;8899	; again after address calculation.
				;8900	
				;8901	; STST and STf cannot cause exceptions.  Thus,
				;8902	; an accurate PC needn't be saved in FEATMP.
				;8903	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  215
; FP11  .MCD [242,1110]      Floating Point Addressing

				;8904	; Address calculation.
				;8905	; Instruction class (and mode 27) separation.
				;8906	
				;8907	; Short modes (one cycle).
				;8908	
				;8909	=11********0	; Mode 0 (warm only).
U 3026, 0037,7707,3400,0000	;8910	NPLA1	[P.FPC0, ^XXXX XXX XXX 000 XXX]
				;8911		OUTS	[LD_FPS, R9],		; Load FPS flops for mode 0.
U 3027, 0000,0271,7571,0637	;8912				NAF/P.FSRC	; Class decode.
				;8913	=
				;8914	=11********0	; Mode 1.
U 3030, 0037,7707,3400,0010	;8915	NPLA1	[P.FPC0, ^XXXX XXX XXX 001 XXX]
				;8916		MOV.W	[RDST, RE],		; Save RDST for ARI's.
U 3031, 0000,1561,6336,0637	;8917				NAF/P.FSRC	; Class decode.
				;8918	=
				;8919	=11********0	; Mode 2.
U 3032, 0037,7707,3400,0020	;8920	NPLA1	[P.FPC0, ^XXXX XXX XXX 010 XXX]
				;8921		OUTR.W	[MMUTMP, RDST],		; Save RDST for abort processing.
U 3033, 0000,0250,2346,0637	;8922				NAF/P.FSRC	; Class decode.
				;8923	=
				;8924	=11********0	; Override on mode 27.
U 3034, 0037,7700,3400,0027	;8925	NPLA1	[P.FPC0, ^XXXX XXX XXX 010 111]
				;8926		OUTR.W	[MMUTMP, RDST],		; Save RDST for abort processing.
U 3035, 0000,0250,2346,1773	;8927				NAF/1773	; Override NAF<2> to
				;8928	=					;  alternative addresses.
				;8929	=11********0	; Override on mode 37.
U 3036, 0037,7700,3400,0037	;8930	NPLA1	[P.FPC0, ^XXXX XXX XXX 011 111]
				;8931		RDI	[RE+],			; Override ARI.W  [RDST],
U 3037, 0000,0301,7744,0637	;8932				NAF/P.FSRC	; Override P.FPC7.  Class decode.
				;8933	=
				;8934	=11********0	; Mode 4.
U 3040, 0037,7707,3400,0040	;8935	NPLA1	[P.FPC0, ^XXXX XXX XXX 100 XXX]
				;8936		OUTR.W	[MMUTMP, RDST],		; Save RDST for abort processing.
U 3041, 0000,0250,2346,0637	;8937				NAF/P.FSRC	; Class decode.
				;8938	=
				;8939	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  216
; FP11  .MCD [242,1110]      Floating Point Addressing

				;8940	; Long modes (two or more cycles).
				;8941	
				;8942	=11********0	; Mode 3 default.
U 3042, 0037,7707,3400,0030	;8943	NPLA1	[P.FPC0, ^XXXX XXX XXX 011 XXX]
				;8944		ARI.W	[RDST],			; Relocate.
				;8945			ODD TRAP,		; Even address only.
U 3043, 0000,0701,7346,0677	;8946				NAF/P.FPC7	; Use high address for mode 37 override.
				;8947	=
				;8948	=11********0	; Mode 5.
U 3044, 0037,7707,3400,0050	;8949	NPLA1	[P.FPC0, ^XXXX XXX XXX 101 XXX]
				;8950		ARD.W	[RDST],			; First decrement.
U 3045, 0000,0711,7546,0124	;8951			NO ABORTS		; Don't do MMU abort.
				;8952	=
				;8953	=00					; Ignore class overrides.
				;8954		AR	[RDST],			; Now relocate for real.
				;8955			ODD TRAP,		; Must be even.
				;8956			SOVFF,			; Catch stack overflow.
U 0124, 0000,0731,6346,0674	;8957				NAF/P.FPC4	; Finish up.
				;8958	=
				;8959	=11********0	; Mode 6.
U 3046, 0037,7707,3400,0060	;8960	NPLA1	[P.FPC0, ^XXXX XXX XXX 110 XXX]
				;8961		RDI	[RE],			; Read offset.
U 3047, 0000,0301,7776,0674	;8962				NAF/P.FPC4	; Finish up.
				;8963	=
				;8964	=11********0	; Mode 7.
U 3050, 0037,7707,3400,0070	;8965	NPLA1	[P.FPC0, ^XXXX XXX XXX 111 XXX]
U 3051, 0000,0301,7776,0154	;8966		RDI	[RE]			; Read offset.
				;8967	=
				;8968	=00					; Ignore class overrides.
U 0154, 0000,1441,6336,0221	;8969		ADD.W	[RDST, RE]		; Compute pointer to address.
				;8970	=
				;8971	=1*0*****				; Abort to ROM[200].
				;8972		AR	[RE],			; Now get address.
				;8973			ODD TRAP,		; Even address only.
U 0221, 0000,0731,7376,0674	;8974				NAF/P.FPC4	; Finish up.
				;8975	=
				;8976	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  217
; FP11  .MCD [242,1110]      Floating Point Addressing

				;8977	; Long modes continued.
				;8978	
				;8979	=11********0	; Modes 3X, 5, and 7 continued.
U 3052, 0177,7767,3600,0010	;8980	PLA1	[^0 111 1XX, ^XXXX XXX XXX XX1 XXX]
				;8981		RD.W	[RE],			; Read final address.
U 3053, 0000,0321,7776,0637	;8982				NAF/P.FSRC	; Class decode.
				;8983	=
				;8984	=11********0	; Modes 6 continued.
U 3054, 0037,7767,3600,0000	;8985	NPLA1	[P.FPC4, ^XXXX XXX XXX XX0 XXX]
				;8986		ADD.W	[RDST, RE],		; Compute address.
U 3055, 0000,1441,6336,0637	;8987				NAF/P.FSRC	; Class decode.
				;8988	=
				;8989	
				;8990	;=1*0**000				; Abort to ROM[200] for mode 6.
				;8991	;	P.DST0		= 0630		; Alternate DST execution.
				;8992	;	P.FDST0		= 0631		; Alternate FDST execution.
				;8993	;	P.SRC0		= 0632		; Alternate SRC mode 27 address.
				;8994	;	P.FSRC0		= 0633		; Alternate FSRC length decode.
				;8995	;	P.DST		= 0634		; DST execution.
				;8996	;	P.FDST		= 0635		; FDST execution.
				;8997	;	P.SRC		= 0636		; SRC addressing.
				;8998	;	P.FSRC		= 0637		; FSRC addressing.
				;8999	;=
				;9000	
				;9001	; Abort pending for modes 3, 5, and 7.
				;9002	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  218
; FP11  .MCD [242,1110]      Floating Point Addressing

				;9003	; These overrides may affect all relocation operations.
				;9004	
				;9005	
				;9006	=11********0	; Override for mode 17.
U 3056, 1677,7700,0100,0017	;9007	PLA1	[^0 0XX X1X, ^XXXX XXX XXX 001 111]
				;9008		AWI.W	[RF],			; Overrides to (AWI.ARI =>) ARI.
				;9009			I SPACE,		; Use I Space for mode 17.
U 3057, 0000,0741,7637,1777	;9010				NAF/1777
				;9011	=
				;9012	=11********0	; Override for mode 2.
U 3060, 1677,7707,0100,0020	;9013	PLA1	[^0 0XX X1X, ^XXXX XXX XXX 010 XXX]
				;9014		NOP.B	[RF, RSRC],		; Override RE to RDST.
U 3061, 0000,1777,7747,1777	;9015				NAF/1777
				;9016	=
				;9017	
				;9018	; The mode 2 override causes:
				;9019	;	RE  . RSRC	=> RDST		; Normal mode 2.
				;9020	;	RE+ . RSRC	=> RE+		; SRC mode 27.
				;9021	;	RF+ . RSRC	=> RF+		; FSRC mode 27.
				;9022	
				;9023	
				;9024	
				;9025	; The affected addresses are:
				;9026	;1 3		P.FSRC		= 0637	; Entry to FSRC addressing.
				;9027	;12		P.SRC		= 0636	; Entry to SRC addressing.
				;9028	;1 3		P.FSRC0		= 0633	; FSRC mode/ length overrides.
				;9029	;1		P.SRC0		= 0632	; SRC 27 address.
				;9030	;  3				= 0627	; unused.
				;9031	; 2		P.SRC1		= 0626	; SRC 2nd relocation.
				;9032	;  3		P.FSRC1		= 0623	; FSRC mode/length overrides.
				;9033	;				= 0622	; unused.
				;9034	;   4		P.DST-E		= 0617	; Entry to DST addressing.
				;9035	;   4 6		P.FDST-E	= 0616	; FDST mode/length overrides.
				;9036	;    5		P.DST1		= 0613	; Second DST relocation.
				;9037	;    56		P.FDST1		= 0612	; FDST mode/length overrides.
				;9038	;      78	P.FSRC2		= 0607	; FSRC 3rd relocation.
				;9039	;      7	P.FSRC3		= 0606	; FSRC 4th relocation.
				;9040	;	89	P.FDST2		= 0603	; FDST 3rd relocation.
				;9041	;	 9	P.FDST3		= 0602	; FDST 4th relocation.
				;9042	
				;9043	; The decimal digits indicate necessary adjacency.
				;9044	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  219
; FP11  .MCD [242,1110]      SRC Addressing

				;9045		.TOC	"		SRC Addressing"
				;9046	
				;9047	
				;9048	; SRC mode 0.
				;9049	
				;9050	=11********0	; SRC mode 0 (warm only).
U 3062, 0037,7707,1700,0000	;9051	NPLA1	[P.SRC, ^XXXX XXX XXX 000 XXX]
				;9052		MOV.W	[RDST, RE],		; Move it to scratchpad.
U 3063, 0000,1561,6336,0614	;9053				NAF/P.SRC-R	; Dispatch to special LDCif address.
				;9054	=					; P.SRC-R<0> = 0 (length override).
				;9055	
				;9056	
				;9057	; SRC mode 27.
				;9058	
				;9059	=11********0	; SRC mode 27.
U 3064, 0037,7777,1500,0000	;9060	NPLA1	[P.SRC0, ^X]
				;9061		RDI	[RE+],			; Read I-stream data.
				;9062						; Ignore mode 2 override.
U 3065, 0000,0301,7744,0614	;9063				NAF/P.SRC-R	; Special LDCif address.
				;9064	=
				;9065	
				;9066	
				;9067	; SRC non mode 0, 4, or 27.
				;9068	
				;9069	; P.SRC + P.SRC1
				;9070	=11********0	; Default for mode overrides.
U 3066, 0437,7757,1300,0020	;9071	PLA1	[^0 01X 110, ^XXXX XXX XXX X1X XXX]
				;9072		ARI.W	[RE],			; Relocate operand address.
				;9073			ODD TRAP,		; Even address only.
U 3067, 0000,0701,7376,0203	;9074				NAF/SRC3	; Two word block.
				;9075	=
				;9076	; P.SRC + P.SRC1
				;9077	=11********0	; Default for mode overrides.
U 3070, 0437,7767,1300,0010	;9078	PLA1	[^0 01X 110, ^XXXX XXX XXX XX1 XXX]
				;9079		ARI.W	[RE],			; Relocate operand address.
				;9080			ODD TRAP,		; Even address only.
U 3071, 0000,0701,7376,0203	;9081				NAF/SRC3	; Two word block.
				;9082	=
				;9083	=11********0	; Override for LDCLf.
U 3072, 0033,0377,1704,7000	;9084	NPLA1	[P.SRC, ^X1XX 111 0XX XXX XXX]
				;9085		NOP.B	[RF, RE],
U 3073, 0000,1777,7776,1776	;9086				NAF/1776	; Override NAF<0>.
				;9087	=
				;9088	=1*0****0; Two word.			; Abort to ROM[200].
				;9089		RD.W	[RE.H],			; Read high word.
U 0202, 0000,0321,7756,0626	;9090				NAF/P.SRC1	; Loop back.
				;9091	SRC3:	; One word.
				;9092		RD.W	[RE],			; Read low word.
U 0203, 0000,0321,7776,0714	;9093				NAF/P.FSRC-R	; Start SRC instruction
				;9094	=					;  for non-mode 0 or 27.
				;9095	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  220
; FP11  .MCD [242,1110]      SRC Addressing

				;9096	; SRC mode 4.
				;9097	
				;9098	=11********0	; Mode 4 default for LDCLf override.
U 3074, 0037,7707,1700,0040	;9099	NPLA1	[P.SRC, ^XXXX XXX XXX 100 XXX]
				;9100		ARD.W	[RDST],			; Decrement.
				;9101			NO ABORTS,		; Don't use MMU.
U 3075, 0000,0711,7546,0333	;9102				NAF/SRC4	; Two word block.
				;9103	=
				;9104	;=11********0	; Override for LDCLf.
				;9105	;NPLA1	[P.SRC, ^X1XX 111 0XX XXX XXX]
				;9106	;	NOP.B	[RF, RE],
				;9107	;			NAF/1776	; Override NAF<0>.
				;9108	;=
				;9109	=0	; Two word.
				;9110		ARD.W	[RDST],			; Relocate for real and decrement.
				;9111			ODD TRAP,		; Must be even.
U 0332, 0000,0711,7346,1426	;9112				NAF/SRC5	; Skip.
				;9113	SRC4:	; One word.
				;9114		AR	[RDST],			; Now relocate real address.
				;9115			ODD TRAP,		; Must be even.
				;9116			SOVFF,			; Check stack overflow.
U 0333, 0000,0731,6346,0203	;9117				NAF/SRC3	; Join common.
				;9118	=
				;9119	;=1*0*****				; Abort to ROM[200].
				;9120	;SRC3:
				;9121	;	RD.W	[RE],			; Read low word.
				;9122	;			NAF/P.FSRC-R	; Start SRC instruction
				;9123	;=					;  for non-mode 0 or 27.
				;9124	
				;9125	; For LDCLf only.
				;9126	SRC5:
U 1426, 0000,0321,7776,1427	;9127		RD.W	[RE]			; Read low word first.
				;9128	
				;9129		AR	[RDST],			; Relocate again.
U 1427, 0000,0731,6746,0223	;9130			SOVFF			; Catch Stack overflow.
				;9131	
				;9132	=1*0*****				; Abort to ROM[200].
				;9133		RD.W	[RE.H],			; Read high part.
U 0223, 0000,0321,7756,0714	;9134				NAF/P.FSRC-R	; Start LDCLf
				;9135	=					;  for non-mode 0 or 27.
				;9136	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  221
; FP11  .MCD [242,1110]      FSRC Addressing

				;9137		.TOC	"		FSRC Addressing"
				;9138	
				;9139	
				;9140	; Floating/double length overrides.
				;9141	
				;9142	; These overrides distinquish between
				;9143	; FSRC floating/double length operands.
				;9144	;
				;9145	; They are invoked by:
				;9146	;	P.FSRC	= 0637		; Mode 4 decode.
				;9147	;	P.FSRC0	= 0633		; Mode 0 and 27 decode.
				;9148	;		= 0627		; unused.
				;9149	;	P.FSRC1	= 0623		; Midway decode.
				;9150	
				;9151	
				;9152	=11********0	; Override if FD.-(DIVf + LDCfd).
U 3076, 0627,3777,1150,0000	;9153	PLA1	[^0 01X X11, ^1XXX 0XX XXX XXX XXX]
				;9154		NOP.L	[RF, RF],
U 3077, 0000,1773,7777,1773	;9155				NAF/1773	; Override NAF<2>.
				;9156	=
				;9157	=11********0	; Override if FD.DIVf.
U 3100, 0627,1777,1150,4000	;9158	PLA1	[^0 01X X11, ^1XXX 10X XXX XXX XXX]
				;9159		NOP.L	[RF, RF],
U 3101, 0000,1773,7777,1773	;9160				NAF/1773	; Override NAF<2>.
				;9161	=
				;9162	=11********0	; Override if -FD.LDCfd (i.e. LDCDF).
U 3102, 0627,1777,1140,6000	;9163	PLA1	[^0 01X X11, ^0XXX 11X XXX XXX XXX]
				;9164		NOP.L	[RF, RF],
U 3103, 0000,1773,7777,1773	;9165				NAF/1773	; Override NAF<2>.
				;9166	=
				;9167	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  222
; FP11  .MCD [242,1110]      FSRC Addressing

				;9168	;  FSRC mode 0.
				;9169	
				;9170	=11********0	; FSRC mode 0 (warm only).
U 3104, 0037,7707,1740,0000	;9171	NPLA1	[P.FSRC, ^XXXX XXX XXX 000 XXX]
				;9172		INPR.W	[AC20.3, RB],		; Get FSRC.3.
U 3105, 0000,0211,2473,0633	;9173				NAF/P.FSRC0	; Invoke length decode now that
				;9174	=					;  FPS flops are valid.
				;9175	; P.FSRC + P.FDST
				;9176	=11********0	; Override for illegal modes.
U 3106, 0137,7701,1640,0006	;9177	PLA1	[^0 011 1X1, ^XXXX XXX XXX 000 11X]
				;9178		NOP.W	[RF, RF],		; No change.
U 3107, 0000,1771,7777,0201	;9179				NAF/ILL-MD	; Override all.
				;9180	=
				;9181	0201:
				;9182	ILL-MD:
				;9183		LLD.W	[002, R8.H],		; Load exception code.
U 0201, 0000,0560,0110,1747	;9184				NAF/FIUV1	; See "Trap Handler".
				;9185	
				;9186	
				;9187	=11********0	; Warm FSRC mode 0 continued.
U 3110, 0037,7757,1540,0000	;9188	NPLA1	[P.FSRC0, ^XXXX XXX XXX X0X XXX]
				;9189		INPR.W	[AC20.2, RF],		; Get FSRC.2.
U 3111, 0000,0211,6477,0714	;9190				NAF/P.FSRC-R	; Overrides to P.FSRC-R0 for double.
				;9191	=
				;9192	=11********0	; Warm FSRC mode 0 double length.
U 3112, 0036,7757,4401,0000	;9193	NPLA1	[P.FSRC-R0, ^XXX1 XXX XXX X0X XXX]
U 3113, 0000,0211,2055,0336	;9194		INPR.W	[AC20.1, RD.H]		; Get FSRC.1.
				;9195	=
				;9196	=0					; Ignore FD override.
				;9197		INPR.W	[AC20.0, RD],		; Get FSRC.0.
U 0336, 0000,0211,6075,0714	;9198				NAF/P.FSRC-R	; Go to instruction breakout.
				;9199	=
				;9200	
				;9201	; This is the only use of P.FSRC-R0 for warm.
				;9202	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  223
; FP11  .MCD [242,1110]      FSRC Addressing

				;9203	; FSRC mode 27.
				;9204	
				;9205	=11********0	; Warm FSRC mode 27.
U 3114, 0036,7757,1541,0020	;9206	NPLA1	[P.FSRC0, ^XXX1 XXX XXX X1X XXX]
				;9207		CLR.W	[RF, RF+],		; Clear FSRC.2.  Ignore mode 2 override.
U 3115, 0000,1041,7745,0267	;9208				NAF/FSRC27	; Two word block.
				;9209	=
				;9210	=0**
U 0263, 0000,1043,7675,0267	;9211		CLR.L	[RD, RD]		; Clear FSRC.1 and FSRC.0.
				;9212	
				;9213	FSRC27:
				;9214		RDI	[RB],			; Get FSRC.3.
U 0267, 0000,0301,7773,0714	;9215				NAF/P.FSRC-R	; Decode instruction.
				;9216	=
				;9217	
				;9218	
				;9219	=11********0	; Hot FSRC mode 27.
U 3116, 0036,7757,1540,0020	;9220	NPLA1	[P.FSRC0, ^XXX0 XXX XXX X1X XXX]
				;9221		RDI	[RF+],			; Get FSRC.3.  Ignore mode 2 override.
U 3117, 0000,0301,7745,0710	;9222				NAF/P.FSRC-R0	; Ignore double length override.
				;9223	=					; See "Hot Support".
				;9224	
				;9225	; Hot FSRC mode 27 cannot go to P.FSRC-R directly because of
				;9226	; double length override conflict with warm mode 0.
				;9227	
				;9228	; "Hot support" has the only use of P.FSRC-R0 for hot.
				;9229	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  224
; FP11  .MCD [242,1110]      FSRC Addressing

				;9230	; FSRC non mode 0, 4, or 27 loads.
				;9231	
				;9232	=11********0	; Default for overrides.
U 3120, 0037,7757,1740,0020	;9233	NPLA1	[P.FSRC, ^XXXX XXX XXX X1X XXX]
				;9234		ARI.W	[RE],			; Relocate.
				;9235			ODD TRAP,		; Even address only.
U 3121, 0000,0701,7376,0210	;9236				NAF/FSRC10	; Skip.
				;9237	=
				;9238	=11********0	; Default for overrides.
U 3122, 0037,7767,1740,0010	;9239	NPLA1	[P.FSRC, ^XXXX XXX XXX XX1 XXX]
				;9240		ARI.W	[RE],			; Relocate.
U 3123, 0000,0701,7376,0210	;9241			ODD TRAP		; Even address only.
				;9242	=
				;9243	=1*0**0**				; Abort to ROM[200].
				;9244	FSRC10:					; Ignore length override.
				;9245		RD.W	[RB],			; Read FSRC.3.
U 0210, 0000,0321,7773,0623	;9246				NAF/P.FSRC1	; Invoke overrides.
				;9247	=
				;9248	=11********0	; Default for double length/mode overrides.
U 3124, 0037,7777,1140,0000	;9249	NPLA1	[P.FSRC1, ^X]
				;9250		ARI.W	[RE],			; Relocate.
U 3125, 0000,0701,7776,0215	;9251				NAF/FSRC5	; Two word block.
				;9252	=
				;9253	=1*0**0**				; Abort to ROM[200].
				;9254		; Double length.
				;9255		RD.W	[RF],			; Read FSRC.2.
U 0211, 0000,0321,7777,0607	;9256				NAF/P.FSRC2	; Continue.
				;9257		; Floating length.
				;9258	FSRC5:
				;9259		RD.W	[RF],			; Read FSRC.2.
U 0215, 0000,0321,7777,0714	;9260				NAF/P.FSRC-R	; Start instruction decode.
				;9261	=
				;9262	
				;9263	; P.FSRC2 + P.FSRC3
				;9264	=11********0	; Default for overrides.
U 3126, 0077,7777,0300,0000	;9265	PLA1	[^0 000 11X, ^X]
				;9266		ARI.W	[RE],
U 3127, 0000,0701,7776,0205	;9267				NAF/FSRC11	; Overridden on first time thru.
				;9268	=
				;9269	; P.FSRC2 + P.FDST2
				;9270	=11********0	; Default for overrides.
U 3130, 0237,7777,0140,0000	;9271	PLA1	[^0 000 X11, ^X]
				;9272		NOP.W	[RF, RF],
U 3131, 0000,1771,7777,1776	;9273				NAF/1776	; Zero NAF<0> on first time thru.
				;9274	=
				;9275	=1*0****0				; Abort to ROM[200].
				;9276		RD.W	[RD.H],			; Read FSRC.1.
U 0204, 0000,0321,7755,0606	;9277				NAF/P.FSRC3	; Loop back.  Don't override.
				;9278	FSRC11:
				;9279		RD.W	[RD],			; Read FSRC.0.
U 0205, 0000,0321,7775,0714	;9280				NAF/P.FSRC-R	; Start instruction decode.
				;9281	=
				;9282	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  225
; FP11  .MCD [242,1110]      FSRC Addressing

				;9283	; FSRC mode 4.
				;9284	
				;9285	=11********0	; Mode 4.
U 3132, 0037,7707,1740,0040	;9286	NPLA1	[P.FSRC, ^XXXX XXX XXX 100 XXX]
				;9287		ARD.W	[RDST],			; Always decrement by two.
				;9288			NO ABORTS,		; Don't use MMU.
U 3133, 0000,0711,7546,0376	;9289				NAF/FSRC6	; Overridden if double.
				;9290	=
				;9291	=0**	; Double length.
				;9292		ARD.W	[RDST],			; Decrement and relocate.
				;9293			ODD TRAP,		; Even address only.
U 0372, 0000,0711,7346,1431	;9294				NAF/FSRC7	; Skip.
				;9295	
				;9296	FSRC6:	; Floating length.
				;9297		ARD.W	[RDST],			; Decrement and relocate.
U 0376, 0000,0711,7346,0225	;9298			ODD TRAP		; Even address only.
				;9299	=
				;9300	=1*0*****				; Abort to ROM[200] for double.
U 0225, 0000,0321,7777,1430	;9301		RD.W	[RF]			; Read FSRC.2.
				;9302	=
				;9303		AR	[RDST],			; Last time.
U 1430, 0000,0731,6746,0227	;9304			SOVFF			; Check stack overflow.
				;9305	
				;9306	=1*0*****				; Abort to ROM[200].
				;9307		RD.W	[RB],			; Read FSRC.3.
U 0227, 0000,0321,7773,0714	;9308				NAF/P.FSRC-R	; Start decode.
				;9309	=
				;9310	
				;9311	; Double length only.
				;9312	FSRC7:
U 1431, 0000,0321,7775,1432	;9313		RD.W	[RD]			; Read FSRC.0.
				;9314	
U 1432, 0000,0711,7746,0231	;9315		ARD.W	[RDST]			; Relocate.
				;9316	
				;9317	=1*0*****				; Abort to ROM[200].
U 0231, 0000,0321,7755,0271	;9318		RD.W	[RD.H]			; Read FSRC.1.
U 0271, 0000,1777,7777,0376	;9319				NAF/FSRC6	; Go back and finish up.
				;9320	=
				;9321	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  226
; FP11  .MCD [242,1110]      DST/FDST Addressing

				;9322		.TOC	"		DST/FDST Addressing"
				;9323	
				;9324	
				;9325	
				;9326	; P.DST + P.DST0
				;9327	=11********0	; Link for hot DST (non-mode 0).
U 3134, 0236,7777,1400,0000	;9328	PLA1	[^0 011 X00, ^XXX0 XXX XXX XXX XXX]
				;9329		INPR.W	[FEATMP, R8.H],		; Get potential FEA.
U 3135, 0000,0210,6650,0617	;9330				NAF/P.DST-E	; Enter DST addressing.
				;9331	=
				;9332	; P.FDST + P.FDST0
				;9333	=11********0	; Link for hot FDST (non-mode 0).
U 3136, 0236,7777,1440,0000	;9334	PLA1	[^0 011 X01, ^XXX0 XXX XXX XXX XXX]
				;9335		INPR.W	[FEATMP, R8.H],		; Get potential FEA.
U 3137, 0000,0210,6650,0616	;9336				NAF/P.FDST-E	; Enter FDST addressing.
				;9337	=
				;9338	
				;9339	=11********0	; Propagate entry info.
U 3140, 0037,7777,0700,0000	;9340	NPLA1	[P.FDST-E, ^X]
				;9341		NOP.W	[RF, RF],
U 3141, 0000,1771,7777,1772	;9342				NAF/1772	; Override NAF<2,0> for FDST entry.
				;9343	=
				;9344	
				;9345	; These overrides distinquish between
				;9346	; DST integer/longword length operands.
				;9347	
				;9348	=11********0	; Override for STST.
U 3142, 0037,0077,0740,0300	;9349	NPLA1	[P.DST-E, ^XXXX 000 011 XXX XXX]
				;9350		NOP.B	[RF, RE],
U 3143, 0000,1777,7776,1776	;9351				NAF/1776	; Override NAF<0> for two word op.
				;9352	=
				;9353	=11********0	; Override for STCfL.
U 3144, 0033,0377,0744,5400	;9354	NPLA1	[P.DST-E, ^X1XX 101 1XX XXX XXX]
				;9355		NOP.B	[RF, RE],
U 3145, 0000,1777,7776,1776	;9356				NAF/1776	; Override NAF<0> for two word op.
				;9357	=
				;9358	
				;9359	; These overrides distinquish between
				;9360	; FDST floating/double length operands.
				;9361	;
				;9362	; They are invoked by:
				;9363	;	P.FDST-E	= 0616		; Mode 0 and 4 decode.
				;9364	;	P.FDST1		= 0612		; Midway decode.
				;9365	
				;9366	=11********0	; Override if FD.-STCfd.
U 3146, 0227,5777,0510,0000	;9367	PLA1	[^0 001 X10, ^1XXX X0X XXX XXX XXX]
				;9368		NOP.W	[RF, RF],
U 3147, 0000,1771,7777,1775	;9369				NAF/1775	; Override NAF<1>.
				;9370	=
				;9371	=11********0	; Override if -FD.STCfd (i.e. STCFD).
U 3150, 0227,5777,0500,2000	;9372	PLA1	[^0 001 X10, ^0XXX X1X XXX XXX XXX]
				;9373		NOP.W	[RF, RF],
U 3151, 0000,1771,7777,1775	;9374				NAF/1775	; Override NAF<1>.
				;9375	=
				;9376	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  227
; FP11  .MCD [242,1110]      DST/FDST Addressing

				;9377	; DST mode 0.
				;9378	
				;9379	=11********0	; DST mode 0.
U 3152, 0037,7707,0740,0000	;9380	NPLA1	[P.DST-E, ^XXXX XXX XXX 000 XXX]
				;9381		MOV.W	[RF.H, RDST],		; Store high order only.
U 3153, 0000,1561,6746,0734	;9382				NAF/P.FP-END	; Decode exception status.
				;9383	=					; P.FP-END<0> must be 0 due
				;9384						;  to length overrides.
				;9385	
				;9386	
				;9387	=11********0	; FDST mode 0.
U 3154, 0037,7707,0700,0000	;9388	NPLA1	[P.FDST-E, ^XXXX XXX XXX 000 XXX]
				;9389		OUTR.W	[AC20.3, RF.H],		; Write FDST.3.
U 3155, 0000,0251,2457,0152	;9390				NAF/FDST4	; Two word block.
				;9391	=
				;9392	=000	; Double length.		; Ignore FDST mode override.
				;9393	FDST4A:
				;9394		OUTR.W	[AC20.0, RD],		; Write FDST.0.
U 0150, 0000,0251,6075,1433	;9395				NAF/FDST4B	; Skip.
				;9396	=010	; Floating length.
				;9397	FDST4:
				;9398		OUTR.W	[AC20.2, RF],		; Finish single or double.
U 0152, 0000,0251,6477,0734	;9399				NAF/P.FP-END	; Test for exception.
				;9400	=
				;9401	FDST4B:
				;9402		OUTR.W	[AC20.1, RD.H],		; Write FDST.1.
U 1433, 0000,0251,2055,0152	;9403				NAF/FDST4	; Finish up.
				;9404	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  228
; FP11  .MCD [242,1110]      DST/FDST Addressing

				;9405	; Non mode 0 or 4.
				;9406	
				;9407	; P.DST-E + P.FDST-E
				;9408	=11********0	; Default.
U 3156, 0077,7757,0700,0020	;9409	PLA1	[^0 001 11X, ^XXXX XXX XXX X1X XXX]
				;9410		AWI.W	[RE],			; Relocate.
				;9411			ODD TRAP,		; Must be a word address.
U 3157, 0000,0741,7376,0235	;9412				NAF/DST2	; Let overrides do decode.
				;9413	=
				;9414	; P.DST-E + P.FDST-E
				;9415	=11********0	; Default.
U 3160, 0077,7767,0700,0010	;9416	PLA1	[^0 001 11X, ^XXXX XXX XXX XX1 XXX]
				;9417		AWI.W	[RE],			; Relocate.
				;9418			ODD TRAP,		; Must be a word address.
U 3161, 0000,0741,7376,0235	;9419				NAF/DST2	; Let overrides do decode.
				;9420	=
				;9421	; P.DST-E + P.FDST-E
				;9422	=11********0	; Mode 27 override.
U 3162, 0077,7700,0700,0027	;9423	PLA1	[^0 001 11X, ^XXXX XXX XXX 010 111]
				;9424		NOP.B	[RF, RDST],		; Override RE to RDST.
U 3163, 0000,1777,7746,1760	;9425				NAF/1760	; Override to one word only.
				;9426	=
				;9427	=1*0*0000				; Abort to ROM[200] for DST2 mode 4.
				;9428		; Mode 27 special case.
				;9429		MOV.W	[RF.H, RC],		; Write one word only.
U 0220, 0000,1561,6774,0734	;9430				NAF/P.FP-END	; Test for exception.
				;9431	=1000	; FDST.
				;9432		MOV.W	[RF.H, RC],		; Write FDST.3.
U 0230, 0000,1561,6774,0612	;9433				NAF/P.FDST1	; Invoke decode.
				;9434	=1100	; DST two word.
				;9435		MOV.W	[RF.H, RC],		; Write first word.
U 0234, 0000,1561,6774,0613	;9436				NAF/P.DST1	; Skip.
				;9437	=1101
				;9438	DST2:	; DST one word.
				;9439		MOV.W	[RF.H, RC],		; Write one word; last mode 4.
U 0235, 0000,1561,6774,0734	;9440				NAF/P.FP-END	; Test for exception.
				;9441	=
				;9442	
				;9443	; P.DST1 + P.FDST1
				;9444	=11********0	; Default for mode/length overrides.
U 3164, 0077,7777,0500,0000	;9445	PLA1	[^0 001 01X, ^X]
				;9446		AWI.W	[RE],			; Relocate.
U 3165, 0000,0741,7776,0216	;9447				NAF/FDST7	; Two word block for FDST.
				;9448	=
				;9449	=1*0***0*; Double length.		; Abort to ROM[200].
				;9450		MOV.W	[RF, RC],		; Write FDST.2.
U 0214, 0000,1561,7774,0603	;9451				NAF/P.FDST2	; Invoke mode overrides.
				;9452	
				;9453	FDST7:	; Floating single.
				;9454		MOV.W	[RF, RC],		; Write FDST.2.
U 0216, 0000,1561,7774,0734	;9455				NAF/P.FP-END	; Test for exception.
				;9456	=
				;9457	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  229
; FP11  .MCD [242,1110]      DST/FDST Addressing

				;9458	; For double length.
				;9459	
				;9460	; P.FDST2 + P.FDST3
				;9461	=11********0	; Default for overrides.
U 3166, 0077,7777,0100,0000	;9462	PLA1	[^0 000 01X, ^X]
				;9463		AWI.W	[RE],
U 3167, 0000,0741,7776,0213	;9464				NAF/FDST11	; Overridden on first time thru.
				;9465	=
				;9466	;; P.FSRC2 + P.FDST2
				;9467	;=11********0	; Default for overrides.
				;9468	;PLA1	[^0 000 X11, ^X]
				;9469	;	NOP.W	[RF, RF],
				;9470	;			NAF/1776	; Zero NAF<0> on first time thru.
				;9471	;=
				;9472	=1*0****0				; Abort to ROM[200].
				;9473		MOV.W	[RD.H, RC],		; Write FDST.1.
U 0212, 0000,1561,6674,0602	;9474				NAF/P.FDST3	; Loop back.  Don't override.
				;9475	FDST11:
				;9476		MOV.W	[RD, RC],		; Write FDST.0.
U 0213, 0000,1561,7674,0734	;9477				NAF/P.FP-END	; Test for exception.
				;9478	=
				;9479	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  230
; FP11  .MCD [242,1110]      DST/FDST Addressing

				;9480	; Mode 4 is different.
				;9481	
				;9482	; P.DST-E + P.FDST-E
				;9483	=11********0	; Mode 4.
U 3170, 0077,7707,0700,0040	;9484	PLA1	[^0 001 11X, ^XXXX XXX XXX 100 XXX]
				;9485		ARD.W	[RDST],			; Just decrement.
				;9486			NO ABORTS,		; Don't use MMU.
U 3171, 0000,0711,7546,0163	;9487				NAF/DST4	; Overridden if double.
				;9488	=
				;9489	=000	; Double length.
				;9490		AWD.W	[RDST],			; Now relocate for real.
				;9491			ODD TRAP,		; Must be even.
U 0160, 0000,0751,7346,1434	;9492				NAF/FDST9	; Skip.
				;9493	=010
				;9494	FDST5:	; FDST single/DST two.
				;9495		AWD.W	[RDST],			; Now relocate for real.
				;9496			ODD TRAP,		; Must be even.
U 0162, 0000,0751,7346,0233	;9497				NAF/FDST8	; Skip.
				;9498	=011
				;9499	DST4:	; DST one.
				;9500		AW	[RDST],			; Now relocate for real.
				;9501			ODD TRAP,		; Must be even.
				;9502			SOVFF,			; Clock SOVFF.
U 0163, 0000,0771,6346,0235	;9503				NAF/DST2	; Join non-mode 4 code.
				;9504	=
				;9505	;=1*0*0000				; Abort to ROM[200] for DST2 mode 4.
				;9506	;=1101
				;9507	;DST2:	; DST one word.
				;9508	;	MOV.W	[RF.H, RC],		; Write one word; last mode 4.
				;9509	;			NAF/P.FP-END	; Test for exception.
				;9510	;=
				;9511	=1*0*****				; Abort to ROM[200].
				;9512	FDST8:
				;9513		MOV.W	[RF, RC],		; Write the low word.
U 0233, 0000,1561,7774,0163	;9514				NAF/DST4	; Go back and write high word.
				;9515	=
				;9516	; Double length only.
				;9517	FDST9:
U 1434, 0000,1561,7674,1435	;9518		MOV.W	[RD, RC]		; Write FDST.0.
				;9519	
U 1435, 0000,0751,7746,0303	;9520		AWD.W	[RDST]			; Decrement and relocate again.
				;9521	
				;9522	=1*0*****				; Abort to ROM[200].
				;9523		MOV.W	[RD.H, RC],		; Write FDST.1.
U 0303, 0000,1561,6674,0162	;9524				NAF/FDST5	; Go back and finish up.
				;9525	=
				;9526	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  231
; FP11  .MCD [242,1110]      Post-addressing

				;9527		.TOC	"		Post-addressing"
				;9528	
				;9529		.TOC	"			Warm DST/FDST"
				;9530	
				;9531	; Test for warm FP exception.
				;9532	; Wait for abort.
				;9533	
				;9534	=11********0	; Default for store class exception checking.
U 3172, 0036,7777,5601,0000	;9535	NPLA1	[P.FP-END, ^XXX1 XXX XXX XXX XXX]
				;9536		NOP.B	[RF, RE],		; Overridden if STCfi or STCDF.
U 3173, 0000,1777,7776,0316	;9537				NAF/MUL20D	; Wait for abort to ROM[200].
				;9538	=
				;9539	=11********0	; Override for STCfi.
U 3174, 0036,0377,5601,5400	;9540	NPLA1	[P.FP-END, ^XXX1 101 1XX XXX XXX]
				;9541		JC	[TST-FI1],		; Test C for exception.
U 3175, 0000,0036,1737,0302	;9542				NAF/TST-FI	; Override MUL20D to TST-FI.
				;9543	=
				;9544	=11********0	; Override for STCDF.
U 3176, 0024,0377,5611,6000	;9545	NPLA1	[P.FP-END, ^1X01 110 0XX XXX XXX]
				;9546		TST.W	[R8.H, RE],		; Test R8.H for no exception code.
U 3177, 0000,1661,6436,0300	;9547				NAF/TST-DF	; Override MUL20D to TST-DF.
				;9548	=
				;9549	;=1*0*0000				; Abort to ROM[200] on MUL20D
				;9550	;					;  for addressing (see P.FP-END).
				;9551	;TST-DF:				; Must align with MUL20D.
				;9552	;	JAZ	[NOP-PF],		; If R8.H is 0 then no exception.
				;9553	;			NAF/UN-OV1	; Proceed as if exception.
				;9554	;=0
				;9555	;TST-FI:				; Must align with MUL20D.
				;9556	;	ASR.W	[RA, RF],		; RF<7> <= FIC.
				;9557	;			NAF/NOP-PF	; If C zero than no exception.
				;9558	;=110	; In range case.
				;9559	;MUL20D:
				;9560	;	NOP.W	[RF, PS],		; Allow writing of IR.
				;9561	;		PREFETCH,		; Request another word.
				;9562	;			NAF/ID1		; Invoke simultaneous decode.
				;9563	
				;9564	TST-FI1:
U 1436, 0000,1667,7777,1437	;9565		TST.B	[RF, RF]		; AN <= FIC.
				;9566	
U 1437, 0000,0177,3377,1440	;9567		JAN	[UN-OV1]		; If FIC => Get FEA.
				;9568	
				;9569		LLD.W	[006, R8.H],		; Load FEC register.
U 1440, 0000,0560,0310,1477	;9570				NAF/NOP-PF	; Take JAN to trap.
				;9571	
				;9572	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  232
; FP11  .MCD [242,1110]      Hot Support

				;9573		.TOC	"			Hot Support"
				;9574	
				;9575	
				;9576	; P.SRC-R + P.FSRC-R0 + P.FSRC-R
				;9577	=11********0	; Link for hot SRC/FSRC instructions.
U 3200, 4236,7777,0400,0000	;9578	PLA1	[^X 001 X00, ^XXX0 XXX XXX XXX XXX]
				;9579		INPR.W	[FEATMP, R8.H],		; Get potential FEA of previous op.
U 3201, 0000,0210,6650,0734	;9580				NAF/P.FP-END	; Sync up with DST/FDST class.
				;9581	=					; P.FP-END<0> must be 0
				;9582						;  due to double override.
				;9583						; P.FP-END must abort to ROM[200].
				;9584	
				;9585	; P.FSRC-R0 + P.FSRC-R
				;9586	=11********0	; Override on hot ABSf/NEGf.
U 3202, 0236,0177,4400,0600	;9587	PLA1	[^1 001 X00, ^XXX0 000 11X XXX XXX]
				;9588		INPR.W	[FEATMP, R8.H],		; Get potential FEA of previous op.
U 3203, 0000,0210,6650,0700	;9589				NAF/P.REST0	; Override P.FP-END.
				;9590	=
				;9591	
				;9592	; Test for hot FP exception.
				;9593	; Wait for abort.
				;9594	; Update FEATMP after abort threat.
				;9595	
				;9596	=11********0	; Breakout hot FP.
U 3204, 0036,7777,5600,0000	;9597	NPLA1	[P.FP-END, ^XXX0 XXX XXX XXX XXX]
				;9598		OUTR.W	[FEATMP, R9.H],		; Update FEATMP with initial PC.
U 3205, 0000,0250,6651,0731	;9599				NAF/P.FPE1	; Wait for abort to ROM[200].
				;9600	=					; Test for late FPE.
				;9601	
				;9602	; These instructions require post processing:
				;9603	;
				;9604	;	LDFPS	000 001		Update FPS after FPE.
				;9605	;
				;9606	;	STEXP	000 0XX		Read PS and update RDST after FPE.
				;9607	;	STCfi	000 1XX
				;9608	;
				;9609	;	STST	000 010		Update RDST after FPE.
				;9610	;	STFPS	000 011
				;9611	;
				;9612	;	SETx	000 000		Update FPS after FPE.
				;9613	;
				;9614	;	CFCC	000 000		Read and copy CCs.
				;9615	;
				;9616	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  233
; FP11  .MCD [242,1110]      Hot Support

				;9617	; P.FPEx
				;9618	
				;9619	; This code checks for an overlapped FPE for hot, continues warm/hot non-io.
				;9620	;
				;9621	; Entry points:
				;9622	;	P.FPE2		Warm.non-io.
				;9623	;	P.FPE1		Hot (check PIR<16>).
				;9624	;	P.FPE0		Hot.second time thru (don't check PIR<16>).
				;9625	;
				;9626	; Exit points:
				;9627	;	INT		If FPE.
				;9628	;	FIUV1		If -FPE.Illegal instruction.
				;9629	;	ID1		If -FPE.-Illegal instruction.
				;9630	
				;9631	; Jam brakes on if interrupt pending.
				;9632	; Override all instructions and check FPE before continuing.
				;9633	
				;9634	=11********0	; Interrupt pending.
U 3206, 0017,7777,5460,0000	;9635	NPLA1	[P.FPE1, ^1 XXXX XXX XXX XXX XXX]
				;9636		JMP	[0000, 00],		; Override all microinstructions.
U 3207, 0000,0000,0000,0002	;9637				NAF/FPE-CK1	; Override all NAFs.
				;9638	=
				;9639	0002:					; Override all NAFs.
				;9640	FPE-CK1:
U 0002, 0000,0271,7737,1441	;9641		OUTS	[INTERRUPTS]		; Load SVC flops to check FPE.
				;9642	
				;9643		OUTS	[LD_FPS, R9],		; Reload opcode for second time thru.
U 1441, 0000,0271,7571,0770	;9644				NAF/P.FPE-CK	; Look for FPE specifically.
				;9645	
				;9646	=11********0	; Yes FPE.
U 3210, 0037,3777,7400,4000	;9647	NPLA1	[P.FPE-CK, ^XXXX 1XX XXX XXX XXX]
				;9648		OUTR.W	[FEATMP, R8.H],		; Replace original FEATMP.
U 3211, 0000,0250,6650,1740	;9649				NAF/INT		; See "Interrupt Restore".
				;9650	=
				;9651	=11********0	; Not FPE.
U 3212, 0037,3777,7400,0000	;9652	NPLA1	[P.FPE-CK, ^XXXX 0XX XXX XXX XXX]
				;9653		NOP.B	[RE, RF],		; Stall for second translation.
U 3213, 0000,1777,7737,0730	;9654				NAF/P.FPE0	; Re-enter; disable PIR<16> override.
				;9655	=
				;9656	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  234
; FP11  .MCD [242,1110]      Hot Support

				;9657	; These are overridden on PIR<16> and 1st time thru.
				;9658	; They cannot be overridden on 2nd time thru.
				;9659	
				;9660	; These instructions require no post processing.
				;9661	
				;9662	; P.FPE0 + P.FPE1
				;9663	=11********0	; No post processing (CLRf + TSTf + ABSf + NEGf).
U 3214, 0077,0377,5400,0400	;9664	PLA1	[^1 011 00X, ^XXXX 000 1XX XXX XXX]
				;9665		NOP.W	[RF, PS],		; Allow writing IR on a-bus.
				;9666			PREFETCH,		; Get next I-stream.
U 3215, 0000,1770,7740,0477	;9667				NAF/ID1		; Parallel decode.
				;9668	=					; Must override to ROM[002].
				;9669	; P.FPE0 + P.FPE1
				;9670	=11********0	; No post processing (MULf + MODf).
U 3216, 0077,0777,5400,1000	;9671	PLA1	[^1 011 00X, ^XXXX 001 XXX XXX XXX]
				;9672		NOP.W	[RF, PS],		; Allow writing IR on a-bus.
				;9673			PREFETCH,		; Get next I-stream.
U 3217, 0000,1770,7740,0477	;9674				NAF/ID1		; Parallel decode.
				;9675	=					; Must override to ROM[002].
				;9676	; P.FPE0 + P.FPE1
				;9677	=11********0	; No post processing (STf + DIVf).
U 3220, 0077,0777,5400,4000	;9678	PLA1	[^1 011 00X, ^XXXX 100 XXX XXX XXX]
				;9679		NOP.W	[RF, PS],		; Allow writing IR on a-bus.
				;9680			PREFETCH,		; Get next I-stream.
U 3221, 0000,1770,7740,0477	;9681				NAF/ID1		; Parallel decode.
				;9682	=					; Must override to ROM[002].
				;9683	; P.FPE0 + P.FPE1
				;9684	=11********0	; No post processing (all others).
U 3222, 0077,5777,5400,2000	;9685	PLA1	[^1 011 00X, ^XXXX X1X XXX XXX XXX]
				;9686		NOP.W	[RF, PS],		; Allow writing IR on a-bus.
				;9687			PREFETCH,		; Get next I-stream.
U 3223, 0000,1770,7740,0477	;9688				NAF/ID1		; Parallel decode.
				;9689	=					; Must override to ROM[002].
				;9690	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  235
; FP11  .MCD [242,1110]      Hot Support

				;9691	; These are overridden on PIR<16> and 1st time thru.
				;9692	; They cannot be overridden on 2nd time thru.
				;9693	
				;9694	; These instructions require post processing.
				;9695	
				;9696	; P.FPE0 + P.FPE1
				;9697	=11********0	; Override for mode 0.
U 3224, 0077,7707,5400,0000	;9698	PLA1	[^1 011 00X, ^XXXX XXX XXX 000 XXX]
				;9699		NOP.B	[RF, RDST],		; Override RF => RDST.
U 3225, 0000,1777,7746,1677	;9700				NAF/1677	; Zero NAF<6>.
				;9701	=					; Must not override ID1.
				;9702	; P.FPE0 + P.FPE1
				;9703	=11********0	; Breakout for LDFPS.
U 3226, 0077,0077,5400,0100	;9704	PLA1	[^1 011 00X, ^XXXX 000 001 XXX XXX]
U 3227, 0000,0270,7744,0206	;9705		OUTS	[CLK_FPS, RE+]		; Update CTL chip FPS copy.
				;9706	=
				;9707						; Ignore double override for warm.
				;9708						; Ignore mode 0 NAF override for hot.
				;9709	=100***10				; Must override to ROM[002] for hot.
				;9710	LDFPS-N:				; Must abort to ROM[200] for warm.
				;9711		OUTR.W	[FPS, RE],		; Store it away.
				;9712						; The three unused bits, FPS<13:12,4>,
				;9713						;  will be zeroed by STFPS.
U 0206, 0000,0250,2736,1477	;9714				NAF/NOP-PF	; All done.
				;9715	=
				;9716	; P.FPE0 + P.FPE1
				;9717	=11********0	; Breakout for STEXP + STCfi.
U 3230, 0077,0777,5400,5000	;9718	PLA1	[^1 011 00X, ^XXXX 101 XXX XXX XXX]
				;9719		LBIC.W	[017, PS],		; Pre-clear for update.
U 3231, 0000,0550,0740,0106	;9720				NAF/STCC-N	; Overridden if mode 0.
				;9721	=
				;9722	=0****1*	; Mode 0 block.		; Must override to ROM[002].
U 0006, 0000,1561,6746,0106	;9723		MOV.W	[RF.H, RDST]		; Update mode 0 data.
				;9724	STCC-N:
				;9725		ARG.W	[FPA_RD],		; Initiate CC read.
U 0106, 0000,0630,0077,1442	;9726				NAF/CFCC3	; Join hot CFCC.
				;9727	=
				;9728	; P.FPE0 + P.FPE1
				;9729	=11********0	; Breakout for STST + STFPS.
U 3232, 0077,0177,5400,0200	;9730	PLA1	[^1 011 00X, ^XXXX 000 01X XXX XXX]
				;9731		MOV.W	[RF.H, RF],		; RF => RDST for mode 0.
U 3233, 0000,1561,6777,1477	;9732				NAF/NOP-PF	; Ignore mode 0 NAF override.
				;9733	=					; All done.
				;9734	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  236
; FP11  .MCD [242,1110]      No Addressing

				;9735		.TOC	"		No Addressing"
				;9736	
				;9737	
				;9738	; Warm or hot.
				;9739	
				;9740	; P.FPEx
				;9741	=11********0	; Default.  Catch illegal opcodes.
U 3234, 0177,0077,5400,0000	;9742	PLA1	[^1 011 0XX, ^XXXX 000 000 XXX XXX]
				;9743		NOP.W	[RF, RF],		; Do not change microinstruction.
U 3235, 0000,1771,7777,0067	;9744				NAF/ILL-OP	; Overridden to SETX or CFCC if not illegal.
				;9745	=
				;9746	; P.FPEx
				;9747	=11********0	; Breakout SETI and SETL only.
U 3236, 0177,0010,5400,0002	;9748	PLA1	[^1 011 0XX, ^XXXX 000 000 00X 010]
				;9749		LBIS.W	[100, RE+],		; LBIS -> LBIC for SETI.
				;9750						; FPS<6> (FL) <= 0 or 1.
U 3237, 0000,0570,4004,0062	;9751				NAF/SETX	; Override ILL-OP.
				;9752	=
				;9753	; P.FPEx
				;9754	=11********0	; Breakout SETF and SETD only.
U 3240, 0177,0010,5400,0001	;9755	PLA1	[^1 011 0XX, ^XXXX 000 000 00X 001]
				;9756		LBIS.W	[200, RE+],		; LBIS -> LBIC for SETF.
				;9757						; FPS<7> (FD) <= 0 or 1.
U 3241, 0000,0571,0004,0062	;9758				NAF/SETX	; Override ILL-OP.
				;9759	=
				;9760	; P.FPEx
				;9761	=11********0	; Override for SETI or SETF (and CFCC).
U 3242, 0177,0003,5400,0000	;9762	PLA1	[^1 011 0XX, ^XXXX 000 000 000 0XX]
				;9763		LBIC.W	[377, RE+],		; Override LBIS (or NOP) to LBIC.
U 3243, 0000,0551,7744,1777	;9764				NAF/1777	; Do not affect NAF if ILL-OP.
				;9765	=
				;9766	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  237
; FP11  .MCD [242,1110]      No Addressing

				;9767	=11********0	; Breakout warm CFCC only.
U 3244, 0037,0000,5500,0000	;9768	NPLA1	[P.FPE2, ^XXXX 000 000 000 000]
				;9769		LBIC.W	[017, PS],		; Clear out PS<3:0> for FCC load.
U 3245, 0000,0550,0740,0063	;9770				NAF/CFCC1	; Override ILL-OP.
				;9771	=
				;9772	; P.FPE0 + P.FPE1
				;9773	=11********0	; Breakout hot CFCC only.
U 3246, 0077,0000,5400,0000	;9774	PLA1	[^1 011 00X, ^XXXX 000 000 000 000]
				;9775		LBIC.W	[017, PS],		; Clear out PS<3:0> for FCC load.
U 3247, 0000,0550,0740,0066	;9776				NAF/CFCC2	; Override ILL-OP.
				;9777	=
				;9778						; Align four NA's with ILL-OP.
				;9779	=0***010				; Ignore mode 0 NAF override.
				;9780						; Must override to ROM[002].
				;9781	SETX:
				;9782		OUTS	[CLK_FPS, RE],		; Update control chips FPS copy.
U 0062, 0000,0270,7776,0206	;9783				NAF/LDFPS-N	; Store FPS and NOP-PF.
				;9784	CFCC1:
				;9785		LAND.W	[017, RE],		; Mask out FPS<15:4> saving FCC.
U 0063, 0000,0510,0776,1443	;9786				NAF/CFCC4	; Update CC's and PREFETCH.
				;9787	CFCC2:
				;9788		ARG.W	[FPA_RD],		; Initiate CC read.
U 0066, 0000,0630,0077,1442	;9789				NAF/CFCC3	; Join hot STEXP or STCfi.
				;9790	ILL-OP:
				;9791		LLD.W	[002, R8.H],		; Set exception code.
U 0067, 0000,0560,0110,1747	;9792				NAF/FIUV1	; Calculate FEA and trap.
				;9793	=					; See "Trap Handler".
				;9794	CFCC3:
				;9795		RDG.W	[RE],			; Read CCs from FPA.
U 1442, 0000,0361,7776,0063	;9796				NAF/CFCC1	; Add delay between FPA write and read
				;9797	
				;9798	CFCC4:
				;9799		BIS.B	[RE, PS],		; OR in FCC to CC and all done.
				;9800			PREFETCH,		; Read future I-stream word.
U 1443, 0000,1576,7700,0477	;9801				NAF/ID1		; Decode next instruction.
				;9802	
;9803	.NOBIN
;9804	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  238
; FP11  .MCD [242,1110]      Warm Floating Point Execution

;9805		.TOC	"	Warm Floating Point Execution"
;9806	
;9807		.TOC	"		SRC Instructions"
;9808	
;9809		.TOC	"			LDFPS"
;9810	
;9811	;
;9812	; LDFPS:
;9813	;	FPS <= SRC.
;9814	;
;9815	
				;9816	.BIN
				;9817	
				;9818	; After operand fetch.
				;9819	
				;9820	; P.FSRC-R + P.SRC-R
				;9821	=11********0	; Breakout LDFPS after SRC addressing.
U 3250, 4036,0077,0601,0100	;9822	PLA1	[^X 001 100, ^XXX1 000 001 XXX XXX]
				;9823		OUTS	[CLK_FPS, RE],		; Update control chips FPS copy.
U 3251, 0000,0270,7776,0206	;9824				NAF/LDFPS-N	; See hot post processing.
				;9825	=
				;9826	;					; Ignore double override for warm.
				;9827	;					; Ignore mode 0 NAF override for hot.
				;9828	;=100***10				; Must override to ROM[002] for hot.
				;9829	;LDFPS-N:				; Must abort to ROM[200] for warm.
				;9830	;	OUTR.W	[FPS, RE],		; Store it away.
				;9831	;					; The three unused bits, FPS<13:12,4>,
				;9832	;					;  will be zeroed by STFPS.
				;9833	;			NAF/NOP-PF	; All done.
				;9834	;=
				;9835	
;9836	.NOBIN
;9837	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  239
; FP11  .MCD [242,1110]      LDEXP

;9838		.TOC	"			LDEXP"
;9839	
;9840	;
;9841	; LDEXP:
;9842	;	Exp(AC)	<= (SRC + 200)<7:0>.
;9843	;
;9844	; If overflow or underflow and interrupt disabled:
;9845	;	AC	<= exact 0.
;9846	;
;9847	;	FC	<= 0.
;9848	;	FV	<= 1 if SRC > 177; 0 otherwise.
;9849	;	FZ	<= 1 if AC = 0; 0 otherwise.
;9850	;	FN	<= 1 if AC < 0; 0 otherwise.
;9851	;
				;9852	.BIN
				;9853	
				;9854	; After operand fetch.
				;9855	
				;9856	; P.FSRC-R + P.SRC-R
				;9857	=11********0	; Breakout LDEXP after SRC addressing.
U 3252, 4036,0377,0601,6400	;9858	PLA1	[^X 001 100, ^XXX1 110 1XX XXX XXX]
U 3253, 0000,0211,2533,0224	;9859		INPR.W	[AC76.3, RB]		; Retrieve AC.3.
				;9860	=
				;9861	=1*0****0				; Abort to ROM[200].
				;9862						; Ignore double override.
U 0224, 0000,0210,2732,1444	;9863		INPR.W	[FPS, RA]		; Retrieve FPS.
				;9864	=
U 1444, 0000,0441,0036,1445	;9865		LADD.W	[200, RE]		; Convert Exp to excess 200 notation.
				;9866	
U 1445, 0000,1233,7573,1446	;9867		ASL.L	[RB, RB]		; Align exponent with byte boundaries.
				;9868	
U 1446, 0000,1467,7733,1447	;9869		SWAB.B	[RE, RB]		; Move new Exp into RB<15:8>.
				;9870	
U 1447, 0000,1561,7730,1450	;9871		MOV.W	[RE, R8]		; Switch register for "Under/overflow".
				;9872	
				;9873		SWAB.B	[R8, RF.H],		; Duplicate Exp for 0 or 377 cases.
U 1450, 0000,1467,7417,1115	;9874				NAF/LDEXP1	; See "Store/update FCCs".
				;9875	
;9876	.NOBIN
;9877	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  240
; FP11  .MCD [242,1110]      LDCif

;9878		.TOC	"			LDCif"
;9879	
;9880	;
;9881	; LDCif:
;9882	;	AC	<= Converted(SRC).
;9883	;
;9884	;	The 2's complement integer is converted to FP format.
;9885	;	LDCLF may not be exact; other forms are exact.
;9886	;	No interrupts may occur.
;9887	;
;9888	;	FC	<= 0.
;9889	;	FV	<= 0.
;9890	;	FZ	<= 1 if AC = 0; 0 otherwise.
;9891	;	FN	<= 1 if AC < 0; 0 otherwise.
;9892	;
;9893	; Method:
;9894	;	An integer is converted by shifting it's MSB (in ABS form) into the
;9895	;	hidden bit position.  The number of shifts required (the power of 2)
;9896	;	determines the exponent.  The sign is adjusted last.
;9897	;
;9898	; Assumes:
;9899	;	RE for long;
;9900	;	RE.L for integer.
;9901	;
;9902	
				;9903	.BIN
				;9904	
				;9905	; After operand fetch.
				;9906	
				;9907	; P.FSRC-R + P.SRC-R
				;9908	=11********0	; Breakout integer.
U 3254, 4032,0377,0601,7000	;9909	PLA1	[^X 001 100, ^X0X1 111 0XX XXX XXX]
				;9910		LLD.W	[211, R8],		; Set exponent for no shift case.
U 3255, 0000,0561,0470,0226	;9911				NAF/LDCIF1	; Skip.
				;9912	=
				;9913	=11********0	; Breakout long for modes 0 or 27.
U 3256, 0032,0377,0605,7000	;9914	NPLA1	[P.SRC-R, ^X1X1 111 0XX XXX XXX]
U 3257, 0000,0561,1470,0226	;9915		LLD.W	[231, R8]		; Set exponent for no shift case.
				;9916	=
				;9917	=1*0****0				; Abort to ROM[200].
				;9918	LDCIF1:					; Ignore double override.
U 0226, 0000,1561,7733,1451	;9919		MOV.W	[RE, RB]		; AN, RB<15> <= Sign.
				;9920	=
				;9921		ANNEG.L	[RE, RF.H],		; Take ABS of operand.
U 1451, 0000,1173,7717,0713	;9922				NAF/P.OPCD2	; Skip.  Invoke double override.
				;9923	
				;9924	=11********0	; Breakout long for non-mode 0 or 27.
U 3260, 0032,0377,4605,7000	;9925	NPLA1	[P.FSRC-R, ^X1X1 111 0XX XXX XXX]
U 3261, 0000,0561,1470,0232	;9926		LLD.W	[231, R8]		; Set exponent for no shift case.
				;9927	=
				;9928	=1*0****0				; Abort to ROM[200].
				;9929						; Ignore double override.
U 0232, 0000,1561,6733,1452	;9930		MOV.W	[RE.H, RB]		; AN, RB<15> <= Sign.
				;9931	=
				;9932		ANNEG.L	[RE, RF],		; Take ABS of operand.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  241
; FP11  .MCD [242,1110]      LDCif

U 1452, 0000,1173,7737,0713	;9933				NAF/P.OPCD2	; Invoke double override.
				;9934	
				;9935	=11********0	; Default for double override.
U 3262, 0037,0377,4540,7000	;9936	NPLA1	[P.OPCD2, ^XXXX 111 0XX XXX XXX]
				;9937		ASL.L	[RB, RB],		; RB<16> <= sign (skip SUB4).
U 3263, 0000,1233,7573,0347	;9938				NAF/LDCIF2	; Two word block.
				;9939	=
				;9940	=0
U 0346, 0000,0250,6340,0347	;9941		OUTR.W	[CPAR, PS]		; Save CCs for double precision.
				;9942	
				;9943	LDCIF2:
U 0347, 0000,0210,2732,1453	;9944		INPR.W	[FPS, RA]		; Load FPS (skip NRM).
				;9945	=
U 1453, 0000,0253,0317,1455	;9946		OUTR.L	[SR, RF.H]		; SR <= 0 for shifts.
				;9947	
U 1455, 0000,0520,0136,1456	;9948		LCNTR.W	[002, RE]		; Check two words at normalization.
				;9949	
				;9950		MOV.W	[RF.H, RE],		; Get high word for OUTS load.
U 1456, 0000,1561,6776,1015	;9951				NAF/NORM-F	; Join long normalization.
				;9952	
;9953	.NOBIN
;9954	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  242
; FP11  .MCD [242,1110]      DST Instructions

;9955		.TOC	"		DST Instructions"
;9956	
;9957		.TOC	"			STST"
;9958	
;9959	;
;9960	; STST:
;9961	;	DST	<= FEC.
;9962	;	DST + 2	<= FEA.
;9963	;
;9964	
				;9965	.BIN
				;9966	
				;9967	; FPS flops not yet valid for mode 0.
				;9968	
				;9969	; P.DST + P.DST0
				;9970	=11********0	; Breakout STST.
U 3264, 0236,0077,1401,0300	;9971	PLA1	[^0 011 X00, ^XXX1 000 011 XXX XXX]
U 3265, 0000,0210,2317,0305	;9972		INPR.W	[FEC, RF.H]		; Get FEC.
				;9973	=
				;9974	=1*0*****				; Abort to ROM[200].
				;9975		INPR.W	[FEA, RF],		; Get FEA.
U 0305, 0000,0210,2777,0617	;9976				NAF/P.DST-E	; Enter DST addressing.
				;9977	=
				;9978	
;9979	.NOBIN
;9980	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  243
; FP11  .MCD [242,1110]      STFPS

;9981		.TOC	"			STFPS"
;9982	
;9983	;
;9984	; STFPS:
;9985	;	DST	<= FPS.
;9986	;
;9987	
				;9988	.BIN
				;9989	
				;9990	; FPS flops not yet valid for mode 0.
				;9991	
				;9992	; P.DST + P.DST0
				;9993	=11********0	; Breakout STFPS.
U 3266, 0236,0077,1401,0200	;9994	PLA1	[^0 011 X00, ^XXX1 000 010 XXX XXX]
U 3267, 0000,0210,2732,0307	;9995		INPR.W	[FPS, RA]		; Get the FPS.
				;9996	=
				;9997	=1*0*****				; Abort to ROM[200].
U 0307, 0000,0467,4777,1457	;9998		LLSW.B	[317, RF]		; Construct mask for unused bits.
				;9999	=
U 1457, 0000,0567,6777,1460	;10000		LLD.B	[357, RF]		; RF<13:12,4> equal zero.
				;10001	
				;10002		AND.W	[RA, RF.H],		; Zero two unused bits and unimplemented
				;10003						;  maintanence bit.  Transfer to RF.H.
U 1460, 0000,1511,7517,0617	;10004				NAF/P.DST-E	; Write FPS to memory.
				;10005	
;10006	.NOBIN
;10007	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  244
; FP11  .MCD [242,1110]      STEXP

;10008		.TOC	"			STEXP"
;10009	
;10010	;
;10011	; STEXP:
;10012	;	DST	<= Exp - 200.
;10013	;
;10014	;	Convert exponent to 2's complement and store.
;10015	;
;10016	;	C, FC	<= 0.
;10017	;	V, FV	<= 0.
;10018	;	Z, FZ	<= 1 if DST = 0; 0 otherwise.
;10019	;	N, FN	<= 1 if DST < 0; 0 otherwise.
;10020	;
;10021	
				;10022	.BIN
				;10023	
				;10024	; FPS flops not yet valid for mode 0.
				;10025	
				;10026	; P.DST + P.DST0
				;10027	=11********0	; Breakout STEXP.
U 3270, 0236,0377,1401,5000	;10028	PLA1	[^0 011 X00, ^XXX1 101 0XX XXX XXX]
U 3271, 0000,0211,2537,0313	;10029		INPR.W	[AC76.3, RF]		; Move AC.3 to EU register.
				;10030	=
				;10031	=1*0*****				; Abort to ROM[200].
U 0313, 0000,1233,7777,1461	;10032		ASL.L	[RF, RF]		; Shift Exp to byte boundaries.
				;10033	=
U 1461, 0000,1461,7777,1462	;10034		SWAB.W	[RF, RF]		; RF<7:0> <= Exp.
				;10035	
U 1462, 0000,0466,0037,1463	;10036		LLSW.B	[000, RF]		; Clear out mantissa garbage.
				;10037	
U 1463, 0000,0411,0017,1464	;10038		LSUB.W	[200, RF.H]		; Unbias the Exp. and transfer to RF.H.
				;10039	
U 1464, 0000,1661,4777,1466	;10040		TST.W*	[RF.H, RF]		; Update N, and Z; clear V, and C.
				;10041	
				;10042	; Copy CCs to FCCs.
				;10043	ST-CPY-CC:
U 1466, 0000,0210,2732,1467	;10044		INPR.W	[FPS, RA]		; Get the FPS.
				;10045	
U 1467, 0000,1547,6032,1470	;10046		XOR.B	[PS, RA]		; For RA<7:4>, 2 XOR's => no change.
				;10047	
U 1470, 0000,0556,0772,1471	;10048		LBIC.B	[017, RA]		; For RA<3:0>, PS XOR 0 => PS.
				;10049	
U 1471, 0000,1547,6032,1472	;10050		XOR.B	[PS, RA]		; Result is RA<3:0> <= PS<3:0>.
				;10051	
				;10052		OUTR.W	[FPS, RA],		; Store new FPS.
U 1472, 0000,0250,2732,0617	;10053				NAF/P.DST-E	; Write the result to memory.
				;10054	
;10055	.NOBIN
;10056	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  245
; FP11  .MCD [242,1110]      STCfi

;10057		.TOC	"			STCfi"
;10058	
;10059	;
;10060	; STCfi:
;10061	;	DST	<= Converted(AC)
;10062	;
;10063	;	Operand is converted from FP to 2's complement.
;10064	;	If the result is out of the integer range, zero is stored
;10065	;	and FC gets set.  Convertion error interrupt may occur.
;10066	;
;10067	;	C, FC	<= 1 if conversion error; 0 otherwise.
;10068	;	V, FV	<= 0.
;10069	;	Z, FZ	<= 1 if DST = 0; 0 otherwise.
;10070	;	N, FN	<= 1 if DST < 0; 0 otherwise.
;10071	;
;10072	; Method:
;10073	;	First the boundaries on the FP number are checked.  If all is well,
;10074	;	the exponent is used to determine the number of shifts.  Finally, the
;10075	;	2's complement representation is generated.
;10076	;
;10077	
				;10078	.BIN
				;10079	
				;10080	; FPS flops not yet valid for mode 0.
				;10081	
				;10082	; P.DST + P.DST0
				;10083	=11********0	; Breakout STCfi.
U 3272, 0236,0377,1401,5400	;10084	PLA1	[^0 011 X00, ^XXX1 101 1XX XXX XXX]
				;10085		INPR.W	[AC76.3, RB],		; Get AC.3 for OUTS load.
U 3273, 0000,0211,2533,0714	;10086				NAF/P.FSRC-R	; Join "Arithmetics" to fetch AC.
				;10087	=					; P.FSRC-R must abort to ROM[200].
				;10088	
				;10089	; The rest of the AC will be fetched, PS store if double,
				;10090	; and interrupts checked (by accident).
				;10091	
				;10092	=11********0	; Breakout STCfI.
U 3274, 0013,0377,2600,5400	;10093	NPLA1	[P.FSRC-R1, ^0 X0XX 101 1XX XXX XXX]
				;10094		LLCM.W	[207, R8],		; Load offset (-210) to shift count.
U 3275, 0000,0471,0370,0764	;10095				NAF/P.MAN4	; Invoke mantissa extractors.
				;10096	=
				;10097	=11********0	; Breakout STCfL.
U 3276, 0013,0377,2604,5400	;10098	NPLA1	[P.FSRC-R1, ^0 X1XX 101 1XX XXX XXX]
				;10099		LLCM.W	[227, R8],		; Load offset (-230) to shift count.
U 3277, 0000,0471,1370,0764	;10100				NAF/P.MAN4	; Invoke mantissa extractors.
				;10101	=
				;10102	=11********0	; Default for mantissa extractors.
U 3300, 0037,7777,7200,0000	;10103	NPLA1	[P.MAN4, ^X]
U 3301, 0000,0561,7757,1473	;10104		LLD.W	[377, RF.H]		; Restore hidden bit and transfer
				;10105	=					;  to RF<31:16>.
				;10106	
				;10107		OUTS	[LD_FPS, R9],		; Reload FPS flops and opcode.
U 1473, 0000,0271,7571,0661	;10108				NAF/P.EXP1	; Check Exp boundaries.
				;10109	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  246
; FP11  .MCD [242,1110]      STCfi

				;10110	; Call Exp extractors to override literal and NAF.
				;10111	
				;10112	=11********0	; Default for Exp extractors.
U 3302, 0037,7777,3040,0000	;10113	NPLA1	[P.EXP1, ^X]
				;10114		LADD.W	[377, R8],		; Calculate shift count.
U 3303, 0000,0441,7770,0172	;10115				NAF/STCFI0	; Overridden if Exp =< 200.
				;10116	=
				;10117	=11********0	; Override for Exp = 200 separately.  All fraction.
U 3304, 0030,0177,3044,0000	;10118	NPLA1	[P.EXP1, ^X 100 000 00X XXX XXX]
				;10119		LADD.W	[200, R8],		; Result is zero.  Update CCs.
U 3305, 0000,0441,0030,1775	;10120				NAF/1775	; Override.  Store zero.
				;10121	=
				;10122	; Block for bias override.
				;10123	=000	; Exp =< 200.
				;10124		CLR.L*	[RF, RF],		; Result is zero.  Set CCs.
U 0170, 0000,1043,5777,1466	;10125				NAF/ST-CPY-CC	; Go copy condition codes.
				;10126	
				;10127	=010	; Exp > 200.			; Ignore UV and Exp = 0 overrides.
				;10128	STCFI0:
U 0172, 0000,0176,4137,1474	;10129		JAN	[STCFI1]		; If negative, do right shift.
				;10130	=
U 1474, 0000,0113,2137,1475	;10131		JAZ	[P.INT2]		; If zero, do no shifts.
				;10132						; Check interrupts.
				;10133	
U 1475, 0000,0430,0430,1476	;10134		LCMP.W	[010, R8]		; (Rb - Ra).  Positive, too large?
				;10135	
				;10136		JAN	[STCFI8],		; Definate overflow.
U 1476, 0000,0176,4437,0713	;10137				NAF/P.OPCD2	; Invoke Double override.
				;10138	
				;10139	=11********0	; Default for double override.
U 3306, 0037,0377,4540,5400	;10140	NPLA1	[P.OPCD2, ^XXXX 101 1XX XXX XXX]
				;10141		OUTS	[LD_CNTR, R8],		; OK.  Shift to left.
U 3307, 0000,0271,5770,0363	;10142				NAF/STCFI3	; Load SR with something.
				;10143	=
				;10144	=0	; STCDi.
				;10145		OUTR.L	[SR, RC],		; SR <= low order bits for double.
U 0362, 0000,0253,0334,0643	;10146				NAF/P.INT3	; Skip.  Check interrupts.
				;10147	STCFI3:
				;10148		OUTR.L	[SR, RC.H],		; Load all 0's to SR for floating.
U 0363, 0000,0253,0314,0643	;10149				NAF/P.INT3	; Skip.  Check interrupts.
				;10150	=
				;10151	; Right shifts.
				;10152	STCFI1:
U 1502, 0000,1331,7430,1503	;10153		NEG.W	[R8, R8]		; Take absolute value of shift count.
				;10154	
				;10155		OUTS	[LD_CNTR, R8],		; Load shift count.
U 1503, 0000,0271,5770,0641	;10156				NAF/P.INT1	; Check interrupts.
				;10157	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  247
; FP11  .MCD [242,1110]      STCfi

				;10158	=11********0	; Right shift and interrupt check.
U 3310, 0017,0377,2040,5400	;10159	NPLA1	[P.INT1, ^0 XXXX 101 1XX XXX XXX]
				;10160		LSR.L	[RF, RF],		; Do alignment.
				;10161			DECR CNTR,
U 3311, 0000,1203,3777,0641	;10162				NAF/P.INT1	; Loop to P.INT0 when done.
				;10163	=
				;10164	=11********0	; Left shift and interrupt check.
U 3312, 0017,0377,2140,5400	;10165	NPLA1	[P.INT3, ^0 XXXX 101 1XX XXX XXX]
				;10166		ASL.Q	[RF, RF],		; Do alignment.
				;10167			DECR CNTR,
U 3313, 0000,1313,3777,0643	;10168				NAF/P.INT3	; Loop to P.INT2 when done.
				;10169	=
				;10170	; P.INT0 + P.INT2
				;10171	=11********0	; Integer; after loops (and interrupt check).
U 3314, 0113,0377,2000,5400	;10172	PLA1	[^0 100 0X0, ^0 X0XX 101 1XX XXX XXX]
U 3315, 0000,1041,7777,1504	;10173		CLR.W	[RF, RF]		; Discard fraction bits for ANNEG.L.
				;10174	=
				;10175		ADC.W*	[RB, RB.H],		; See note.
U 1504, 0000,1641,5553,1505	;10176				NAF/STCFI7	; Skip.
				;10177	
				;10178	; P.INT0 + P.INT2
				;10179	=11********0	; Long; after loops (and interrupt check).
U 3316, 0113,0377,2004,5400	;10180	PLA1	[^0 100 0X0, ^0 X1XX 101 1XX XXX XXX]
				;10181		ADC.W*	[RB, RB.H],		; See note.
U 3317, 0000,1641,5553,1505	;10182				NAF/STCFI7
				;10183	=
				;10184	; Note:
				;10185	;	This ADC has little to do with adding C.  It performs the following:
				;10186	;	N, RB<31> <= old RB<15>, the correct sign of the result.
				;10187	;	Z, V, C <= 0, correct CCs if no overflow.
				;10188	;	Note that Exp(RB) is never all 1's or all 0's.
				;10189	
				;10190	STCFI7:
U 1505, 0000,1173,7777,1506	;10191		ANNEG.L	[RF, RF]		; Form 2's complement integer.
				;10192	
U 1506, 0000,1543,7773,1507	;10193		XOR.L	[RF, RB]		; Do correct sign and real sign match?
				;10194	
				;10195		JAN	[STCFI8],		; Take JAN if signs don't match.
U 1507, 0000,0176,4437,1466	;10196				NAF/ST-CPY-CC	; Go copy CCs.
				;10197	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  248
; FP11  .MCD [242,1110]      STCfi

				;10198	; Overflow.
				;10199	STCFI8:					; Exponent is too large.
U 1510, 0000,1043,5777,1511	;10200		CLR.L*	[RF, RF]		; Clear result; set all but C correctly.
				;10201	
				;10202		LBIS.B	[001, PS],		; Set C.
U 1511, 0000,0576,0040,1466	;10203				NAF/ST-CPY-CC
				;10204	
				;10205	;; Copy CCs to FCCs.
				;10206	;ST-CPY-CC:
				;10207	;	INPR.W	[FPS, RA]		; Get the FPS.
				;10208	;
				;10209	;	XOR.B	[PS, RA]		; For RA<7:4>, 2 XOR's => no change.
				;10210	;
				;10211	;	LBIC.B	[017, RA]		; For RA<3:0>, PS XOR 0 => PS.
				;10212	;
				;10213	;	XOR.B	[PS, RA]		; Result is RA<3:0> <= PS<3:0>.
				;10214	;
				;10215	;	OUTR.W	[FPS, RA],		; Store new FPS.
				;10216	;			NAF/P.DST-E	; Write the result to memory.
				;10217	
;10218	.NOBIN
;10219	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  249
; FP11  .MCD [242,1110]      FSRC Instructions

;10220		.TOC	"		FSRC Instructions"
;10221	
;10222	;
;10223	; All FSRC instructions begin by loading the opcode and FPS into the PIR
;10224	; and fetching their source operands.
;10225	;
;10226	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  250
; FP11  .MCD [242,1110]      TSTf

;10227		.TOC	"			TSTf"
;10228	
;10229	;
;10230	; TSTf:
;10231	;	FSRC.
;10232	;
;10233	;	Set FCC based on FSRC.
;10234	;
;10235	;	Interrupt on undefined variable may occur.
;10236	;
;10237	;	FC	<= 0.
;10238	;	FV	<= 0.
;10239	;	FZ	<= 1 if AC = 0; 0 otherwise.
;10240	;	FN	<= 1 if AC < 0; 0 otherwise.
;10241	;
				;10242	.BIN
				;10243	
				;10244	=11********0	; Breakout TSTF/D after FSRC addressing and warm.
U 3320, 0036,0077,4601,0500	;10245	NPLA1	[P.FSRC-R, ^XXX1 000 101 XXX XXX]
U 3321, 0000,0271,6773,0236	;10246		OUTS	[LD_PIR, RB]		; Load FSRC.3 for UV check.
				;10247	=
				;10248	=1*0****0				; Abort to ROM[200].
				;10249						; Ignore double override.
				;10250		INPR.W	[FPS, RA],		; Retrieve FPS.
U 0236, 0000,0210,2732,0726	;10251				NAF/P.NZ6	; Set FCC and check FIUV.
				;10252	=
				;10253	;=11********0	; Default for FN and FZ overrides.
				;10254	;PLA1	[^1 01X 11X, ^X]
				;10255	;	LBIC.W	[017, RA],		; Clear FCCs.
				;10256	;			NAF/TSTF3	; High address of block.
				;10257	;=
				;10258	;; Block for FN and FZ overrides.
				;10259	;=00	; For TSTF only.
				;10260	;	LMSTK	[TSTF4, R9],		; Call check for FUIV or Mode 0.
				;10261	;			NAF/FIUV-CK	; Return if don't trap.
				;10262	;=01
				;10263	;	LBIS.W	[010, RA],		; Set FN.
				;10264	;			NAF/TSTF3
				;10265	;=10
				;10266	;	LBIS.W	[004, RA],		; Set FZ.
				;10267	;			NAF/TSTF3
				;10268	;=11
				;10269	;TSTF3:
				;10270	;	OUTR.W	[FPS, RA],		; So simple.
				;10271	;			NAF/NOP-PF	; All done.
				;10272	;=
				;10273	; Return from FIUV check.
				;10274	TSTF4:
				;10275		LBIS.W	[014, RA],		; Set both FN and FZ.
U 1512, 0000,0570,0632,0277	;10276				NAF/TSTF3	; And almost done.
				;10277	
;10278	.NOBIN
;10279	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  251
; FP11  .MCD [242,1110]      LDf

;10280		.TOC	"			LDf"
;10281	
;10282	;
;10283	; LDf:
;10284	;	AC	<= FSRC.
;10285	;
;10286	;	Load single or double precision into AC.
;10287	;
;10288	;	Interrupt on undefined variable may occur.
;10289	;
;10290	;	FC	<= 0.
;10291	;	FV	<= 0.
;10292	;	FZ	<= 1 if AC = 0; 0 otherwise.
;10293	;	FN	<= 1 if AC < 0; 0 otherwise.
;10294	;
				;10295	.BIN
				;10296	
				;10297	=11********0	; Breakout LDF/D after FSRC addressing and warm.
U 3322, 0036,0377,4601,2400	;10298	NPLA1	[P.FSRC-R, ^X XXX1 010 1XX XXX XXX]
U 3323, 0000,0271,6773,0304	;10299		OUTS	[LD_PIR, RB]		; Load FSRC.3 for UV check.
				;10300	=
				;10301	=1*0****0				; Abort to ROM[200].
				;10302						; Ignore double override.
				;10303	ADD8D:					; Entry for ADDf/SUBf, AC = 0 case.
				;10304		INPR.W	[FPS, RA],		; Retrieve FPS.
U 0304, 0000,0210,2732,0720	;10305				NAF/P.NZ0	; Set FCC and check FIUV.
				;10306	=
				;10307	=11********0	; Default for FN and FZ overrides.
U 3324, 0037,7777,5000,0000	;10308	NPLA1	[P.NZ0, ^X]
				;10309		LBIC.W	[017, RA],		; Clear FCCs.
U 3325, 0000,0550,0772,0167	;10310				NAF/LDF3	; High address of block.
				;10311	=
				;10312	; Block for FN and FZ overrides.
				;10313	=00	; For LDf only.
				;10314		LMSTK	[LDF2, R9],		; Return if don't trap on UV.
U 0164, 0000,0536,4571,1730	;10315				NAF/FIUV-CK	; Call subroutine.
				;10316	=01
				;10317		LBIS.W	[010, RA],		; Set FN.
U 0165, 0000,0570,0432,0167	;10318				NAF/LDF3
				;10319	=10
				;10320	LDF4:					; Entry for "Exact Zero".
				;10321		LBIS.W	[004, RA],		; Set FZ.
U 0166, 0000,0570,0232,0167	;10322				NAF/LDF3
				;10323	=11
				;10324	LDF3:
				;10325		OUTS	[LD_FPS, R9],		; Reload FD and opcode.
U 0167, 0000,0271,7571,1724	;10326				NAF/FPS-STR1	; Store FPS and AC.
				;10327	=
				;10328	LDF2:
				;10329		LBIS.W	[014, RA],		; Set FN and FZ.
U 1513, 0000,0570,0632,0167	;10330				NAF/LDF3	; Join above.
				;10331	
				;10332	; See "Store FCC/AC/Exit".
;10333	.NOBIN
;10334	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  252
; FP11  .MCD [242,1110]      LDCfd

;10335		.TOC	"			LDCfd"
;10336	
;10337	;
;10338	; LDCfd:
;10339	;	AC	<= Converted(FSRC).
;10340	;
;10341	;	Convert FSRC between floating/double precision and load.
;10342	;	FD indicates the precision of AC.
;10343	;
;10344	;	Interrupt on undefined variable may occur.
;10345	;	Overflow may occur for LDCDF and FT = 0.
;10346	;
;10347	;	FC	<= 0.
;10348	;	FV	<= 1 if conversion produces overflow; 0 otherwise.
;10349	;	FZ	<= 1 if AC = 0; 0 otherwise.
;10350	;	FN	<= 1 if AC < 0; 0 otherwise.
;10351	;
;10352	
				;10353	.BIN
				;10354	
				;10355	=11********0	; Breakout LDCFD/DF after FSRC addressing and warm.
U 3326, 0036,0377,4601,7400	;10356	NPLA1	[P.FSRC-R, ^XXX1 111 1XX XXX XXX]
U 3327, 0000,0271,6773,0306	;10357		OUTS	[LD_PIR, RB]		; Load FSRC.3 for Exp = 0 check.
				;10358	=
				;10359	=1*0****0				; Abort to ROM[200].
				;10360						; Ignore double override.
				;10361		OUTS	[LD_FPS, R9],		; Get FPS flops.
U 0306, 0000,0271,7571,0665	;10362				NAF/P.EXP5	; Invoke exponent extractors.
				;10363	=
				;10364	=11********0	; Default for Exp extractor overrides.
U 3330, 0037,7777,3240,0000	;10365	NPLA1	[P.EXP5, ^X]
				;10366		LLD.W	[377, R8],		; Get the exponent.
U 3331, 0000,0561,7770,0255	;10367				NAF/LDCFD0	; High address of three word block.
				;10368	=
				;10369	; Block for UV, Exp = 0, and normal.
				;10370	=000	; UV.
				;10371		LMSTK	[EXACT-0A, R9],		; Return if FIU disabled or AC.
U 0250, 0000,0531,2631,1730	;10372				NAF/FIUV-CK	; Call subroutine.
				;10373	
				;10374	=100	; Exp = 0.
				;10375	EXACT-0A:				; Store Exact 0 since Exp = 0.
				;10376		INPR.W	[FPS, RA],		; Get FPS.
U 0254, 0000,0210,2732,1726	;10377				NAF/EXACT-0B	; See "Exact Zero".
				;10378	
				;10379	=101	; Normal.
				;10380	LDCFD0:
				;10381		OUTR.L	[SR, RD],		; Load potential rounding bit.
U 0255, 0000,0253,0335,0713	;10382				NAF/P.OPCD2	; What mode are we in ?
				;10383	=
				;10384	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  253
; FP11  .MCD [242,1110]      LDCfd

				;10385	=11********0	; Default for double override.
U 3332, 0037,0377,4540,7400	;10386	NPLA1	[P.OPCD2, ^XXXX 111 1XX XXX XXX]
				;10387		MOV.W	[RB, RF.H],		; RF <= FSRC.3 @ FSRC.2.
U 3333, 0000,1561,7557,1013	;10388				NAF/LDCFD2	; Address of two word block.
				;10389	=
				;10390	=0
				;10391		CLR.L	[RD, RD],		; Source was single precision.
U 1012, 0000,1043,7675,1532	;10392				NAF/ADD8E	; Join ADD then LDf.
				;10393	LDCFD2:
				;10394		ASL.Q	[RF, RF],		; Shift in rounding bit.
U 1013, 0000,1313,7777,1545	;10395				NAF/ADD3	; Join ADD then round.
				;10396	=
				;10397	;ADD3:					; Effective ADD special; LDCfd.
				;10398	;	ASL.L	[RB, RB],		; Shift sign left for sign insertion.
				;10399	;			NAF/P.NRM0	; See "Rounding".
				;10400	
				;10401	;ADD8E:
				;10402	;	OUTS	[LD_PIR, RB],		; Now decode sign and store as AC.
				;10403	;			NAF/ADD8D	; Join LDf.
				;10404	
;10405	.NOBIN
;10406	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  254
; FP11  .MCD [242,1110]      Arithmetics

;10407		.TOC	"			Arithmetics"
;10408	
;10409	;
;10410	; Breakout on arithmetic opcodes and warm floating.
;10411	;
;10412	; AC required: (CMPf, ADDf, SUBf, MULf, MODf, and DIVf)
;10413	;	PIR	<= FSRC.3
;10414	;	RE.L	<= AC.2
;10415	;	RC	<= AC.1 @ AC.0		(Double only)
;10416	;	CPAR	<= PS			(Double only)
;10417	;
;10418	
				;10419	.BIN
				;10420	
				;10421	=11********0	; Retrieve AC for CMPf, SUBf, MULf, and MODf.
U 3334, 0036,2777,4601,1000	;10422	NPLA1	[P.FSRC-R, ^XXX1 0X1 XXX XXX XXX]
				;10423		INPR.W	[AC76.2, RE],		; Retrieve AC operand.
U 3335, 0000,0211,6536,0321	;10424				NAF/FSRC3	; NAF<0> overridden if Double.
				;10425	=
				;10426	=11********0	; Retrieve AC for ADDf.
U 3336, 0036,0377,4601,2000	;10427	NPLA1	[P.FSRC-R, ^XXX1 010 0XX XXX XXX]
				;10428		INPR.W	[AC76.2, RE],		; Retrieve AC operand.
U 3337, 0000,0211,6536,0321	;10429				NAF/FSRC3	; NAF<0> overridden if Double.
				;10430	=
				;10431	=11********0	; Retrieve AC for DIVf.
U 3340, 0036,0377,4601,4400	;10432	NPLA1	[P.FSRC-R, ^XXX1 100 1XX XXX XXX]
				;10433		INPR.W	[AC76.2, RE],		; Retrieve AC operand.
U 3341, 0000,0211,6536,0321	;10434				NAF/FSRC3	; NAF<0> overridden if Double.
				;10435	=
				;10436	=11********0	; Retrieve AC for STCfi.
U 3342, 0036,0377,4601,5400	;10437	NPLA1	[P.FSRC-R, ^XXX1 101 1XX XXX XXX]
				;10438		INPR.W	[AC76.2, RF],		; Retrieve AC operand to RF.
U 3343, 0000,0211,6537,0321	;10439				NAF/FSRC3	; NAF<0> overridden if Double.
				;10440	=
				;10441	=1*0****0				; Abort to ROM[200].
				;10442	FSRC3A:		; Double.
				;10443		OUTR.W	[CPAR, PS],		; Save PS for double.
U 0320, 0000,0250,6340,1514	;10444				NAF/FSRC3B	; Skip.
				;10445	FSRC3:		; Single.
				;10446		OUTS	[LD_PIR, RB],		; Load FSRC.3 for decode.
U 0321, 0000,0271,6773,0654	;10447				NAF/P.FSRC-R1	; Decode instruction and get AC76.3.
				;10448	=					; Invoke interrupt check.
				;10449	FSRC3B:
U 1514, 0000,0211,6134,1515	;10450		INPR.W	[AC76.0, RC]		; Double only.
				;10451	FSRC3C:
				;10452		INPR.W	[AC76.1, RC.H],		; Double only.
U 1515, 0000,0211,2114,0321	;10453				NAF/FSRC3	; Go back to common code.
				;10454	
				;10455	; STCfi is not an FSRC instruction but enters here
				;10456	; to fetch it's operands.
				;10457	
;10458	.NOBIN
;10459	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  255
; FP11  .MCD [242,1110]      CMPf

;10460		.TOC	"				CMPf"
;10461	
;10462	;
;10463	; CMPf:
;10464	;	FSRC - AC.
;10465	;
;10466	;	Compare two FP operands.  Set FCCs based on result.
;10467	;	If both exponents are zero, store exact zero in AC.
;10468	;
;10469	;	Interrupt on undefined variable may occur.
;10470	;
;10471	;	FC	<= 0.
;10472	;	FV	<= 0.
;10473	;	FZ	<= 1 if FSRC = AC; 0 otherwise.
;10474	;	FN	<= 1 if FSRC < AC; 0 otherwise.
;10475	;
;10476	; Algorithm:
;10477	;	Subtract AC from FSRC (including sign, exponent, and mantissa).
;10478	;	The following truth table shows the result :
;10479	;
;10480	;	  Sign	| Sign	| |AC| >  |		   |  F  F
;10481	;	  FSRC	|  AC	| |FSRC|  |   N  C  V  Z   |  N  Z
;10482	;	--------|-------|---------|----------------|--------
;10483	;	    0	|   0	|    0	  |   0  0  0  0   |  0  0
;10484	;	    0	|   0	|    1	  |   1  1  0  0   |  1  0
;10485	;	    0	|   1	|    0	  |   1  1  1  0   |  0  0
;10486	;	    0	|   1	|    1	  |   0  1  0  0   |  0  0
;10487	;	    1	|   0	|    0	  |   1  0  0  0   |  1  0
;10488	;	    1	|   0	|    1	  |   0  0  1  0   |  1  0
;10489	;	    1	|   1	|    0	  |   0  0  0  0   |  1  0
;10490	;	    1	|   1	|    1	  |   1  1  0  0   |  0  0
;10491	;	    X	|   X	|    X	  |   0  0  0  1   |  0  1
;10492	;
;10493	;	Minimization of Sign_FSRC @ PS results in
;10494	;
;10495	;	FN = -S.N.-V + S.-Z.-C
;10496	;	FZ = Z
;10497	;
;10498	
				;10499	.BIN
				;10500	
				;10501	; After operands have been fetched.
				;10502	; Check interrupts.
				;10503	
				;10504	=11********0	; Breakout CMPF/D after operand fetch.
U 3344, 0017,0377,2600,3400	;10505	NPLA1	[P.FSRC-R1, ^0 XXXX 011 1XX XXX XXX]
				;10506		INPR.W	[AC76.3, R8],		; Retrieve last of AC.
U 3345, 0000,0211,2530,0724	;10507				NAF/P.NZ4	; Check for UV and zero.
				;10508	=
				;10509	=11********0	; Default for FN and FZ overrides.
U 3346, 0037,7777,5200,0000	;10510	NPLA1	[P.NZ4, ^X]
				;10511		INPR.W	[FPS, RA],		; Retrieve FPS.
U 3347, 0000,0210,2732,0177	;10512				NAF/CMP1	; High address of block.
				;10513	=
				;10514	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  256
; FP11  .MCD [242,1110]      CMPf

				;10515	; Block for UV and Exp = 0.
				;10516	=00	; UV.
				;10517		LMSTK	[CMP2, R9],		; Return if disabled/AC.
U 0174, 0000,0530,7731,1730	;10518				NAF/FIUV-CK	; Check for FIUV or AC.
				;10519	=01	; Negative.
				;10520		OUTS	[LD_FPS, R9],		; Load FD and opcode for decode.
U 0175, 0000,0271,7571,1516	;10521				NAF/CMP3	; Skip.
				;10522	=10	; Zero.
				;10523	CMP2:
				;10524		OUTS	[LD_PIR, R8],		; Load AC.3 for decode.
U 0176, 0000,0271,6770,1524	;10525				NAF/CMP4	; Skip.
				;10526	=11	; Positive.
				;10527	CMP1:
				;10528		OUTS	[LD_FPS, R9],		; Load FD and opcode for decode.
U 0177, 0000,0271,7571,1516	;10529				NAF/CMP3
				;10530	=
				;10531	CMP3:
				;10532		OUTR.W	[CPAR, PS],		; Save PS to use CCs (Dup for FD).
U 1516, 0000,0250,6340,0772	;10533				NAF/P.OPCD1	; Decode FD.
				;10534	
				;10535	=11********0	; Single.
U 3350, 0027,0377,7500,3400	;10536	NPLA1	[P.OPCD1, ^0XXX 011 1XX XXX XXX]
				;10537		SUB.W*	[RE, RF],		; FSRC.2 - AC.2 (Ra - Rb).  Save C.
U 3351, 0000,1411,5737,1520	;10538				NAF/CMP6	; Skip.
				;10539	=
				;10540	=11********0	; Double.
U 3352, 0027,0377,7510,3400	;10541	NPLA1	[P.OPCD1, ^1XXX 011 1XX XXX XXX]
U 3353, 0000,1413,5635,1517	;10542		SUB.L*	[RC, RD]		; FSRC.10 - AC.10 (Ra - Rb).  Save C.
				;10543	=
U 1517, 0000,1651,5737,1520	;10544		SUBC.W*	[RE, RF]		; FSRC.2 - AC.2.  Propagate C.
				;10545	CMP6:
U 1520, 0000,1651,5413,1521	;10546		SUBC.W*	[R8, RB.H]		; Save CCs.  Save Sign_FSRC.
				;10547	
U 1521, 0000,1567,6033,1522	;10548		MOV.B	[PS, RB]		; Combine sign and CCs for decode.
				;10549	
U 1522, 0000,0271,6773,1523	;10550		OUTS	[LD_PIR, RB]		; Load for decode.
				;10551	
				;10552		INPR.W	[CPAR, PS],		; Restore PS.
U 1523, 0000,0210,6340,0736	;10553				NAF/P.CMP7	; Decode result.
				;10554	
				;10555	; FSRC is zero case.
				;10556	CMP4:
				;10557		NOP.B	[RF, RF],		; Stall.
U 1524, 0000,1777,7777,0737	;10558				NAF/P.CMP8	; Decode for FSRC is 0 case.
				;10559	
				;10560	=11********0	; Default for FN and FZ overrides.
U 3354, 0477,7777,5300,0000	;10561	PLA1	[^1 01X 11X, ^X]		; (P.CMP7, P.CMP8, P.NZ6, or P.NZ7).
				;10562		LBIC.W	[017, RA],		; Clear FCCs.
U 3355, 0000,0550,0772,0277	;10563				NAF/TSTF3	; High address of block.
				;10564	=
				;10565	; For FSRC <> 0 case.
				;10566	
				;10567	=11********0	; Override for -S.N.-V.
U 3356, 0027,7765,5700,0010	;10568	NPLA1	[P.CMP7, ^0XXX XXX XXX XX1 X0X]
				;10569		NOP.W	[RF, RF],
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  257
; FP11  .MCD [242,1110]      CMPf

U 3357, 0000,1771,7777,1775	;10570				NAF/1775	; Override to set FN.
				;10571	=
				;10572	=11********0	; Override for S.-Z.-C.
U 3360, 0027,7772,5710,0000	;10573	NPLA1	[P.CMP7, ^1XXX XXX XXX XXX 0X0]
				;10574		NOP.W	[RF, RF],
U 3361, 0000,1771,7777,1775	;10575				NAF/1775	; Override to set FN.
				;10576	=
				;10577	=11********0	; Override for Z.
U 3362, 0037,7773,5700,0004	;10578	NPLA1	[P.CMP7, ^XXXX XXX XXX XXX 1XX]
				;10579		NOP.W	[RF, RF],
U 3363, 0000,1771,7777,1776	;10580				NAF/1776	; Override to set FZ.
				;10581	=
				;10582	; For FSRC = 0 case.
				;10583	
				;10584	=11********0	; Override for AC positive.
U 3364, 0027,7777,5740,0000	;10585	NPLA1	[P.CMP8, ^0XXX XXX XXX XXX XXX]
				;10586		NOP.W	[RF, RF],
U 3365, 0000,1771,7777,1775	;10587				NAF/1775	; Override to set FN.
				;10588	=
				;10589	=11********0	; Override for AC zero.
U 3366, 0430,0177,5340,0000	;10590	PLA1	[^1 01X 111, ^X000 000 00X XXX XXX]	; (P.CMP8 or P.NZ7).
				;10591		NOP.W	[RF, RF],
U 3367, 0000,1771,7777,1770	;10592				NAF/1770	; Override to Exact Zero.
				;10593	=
				;10594	=000	; CMPf and ADDf.
				;10595	EXACT-0C:
				;10596		OUTS	[LD_FPS, R9],		; Load FD and opcode (or 0 for ADDf).
U 0270, 0000,0271,7571,1727	;10597				NAF/EXACT-0D	; See "Exact Zero".
				;10598	
				;10599	; Block for FN and FZ overrides.
				;10600	=00	; For TSTf only.
				;10601		LMSTK	[TSTF4, R9],		; Call check for FUIV and Mode 0.
U 0274, 0000,0536,4531,1730	;10602				NAF/FIUV-CK	; Return if don't trap.
				;10603	=01
				;10604		LBIS.W	[010, RA],		; Set FN.
U 0275, 0000,0570,0432,0277	;10605				NAF/TSTF3
				;10606	=10
				;10607		LBIS.W	[004, RA],		; Set FZ.
U 0276, 0000,0570,0232,0277	;10608				NAF/TSTF3
				;10609	=11
				;10610	TSTF3:
				;10611		OUTR.W	[FPS, RA],		; So simple.
U 0277, 0000,0250,2732,1477	;10612				NAF/NOP-PF	; All done.
				;10613	=
				;10614	;TSTF4:
				;10615	;	LBIS.W	[014, RA],		; Set both FN and FZ.
				;10616	;			NAF/TSTF3	; And almost done.
				;10617	
;10618	.NOBIN
;10619	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  258
; FP11  .MCD [242,1110]      ADDf, SUBf

;10620		.TOC	"				ADDf, SUBf"
;10621	
;10622	;
;10623	; ADDf:
;10624	;	AC	<= AC + FSRC.
;10625	;
;10626	;	Add two FP operands.
;10627	; SUBf:
;10628	;	AC	<= AC - FSRC.
;10629	;
;10630	;	Subtract two FP operands.
;10631	;
;10632	;	Interrupt on undefined variable may occur.
;10633	;	Underflow and overflow may occur.
;10634	;
;10635	;	FC	<= 0.
;10636	;	FV	<= 1 if overflow occurs; 0 otherwise.
;10637	;	FZ	<= 1 if AC = 0; 0 otherwise.
;10638	;	FN	<= 1 if AC < 0; 0 otherwise.
;10639	;
				;10640	.BIN
				;10641	
				;10642	; After operands have been fetched.
				;10643	; Check interrupts.
				;10644	
				;10645	=11********0	; Breakout ADDf after FSRC addressing.
U 3370, 0017,0377,2600,2000	;10646	NPLA1	[P.FSRC-R1, ^0 XXXX 010 0XX XXX XXX]
				;10647		INPR.W	[AC76.3, RA],		; Retrieve last of AC.
U 3371, 0000,0211,2532,0666	;10648				NAF/P.EXP6	; Do decode of FSRC.3.
				;10649	=
				;10650	=11********0	; Breakout SUBf after FSRC addressing.
U 3372, 0017,0377,2600,3000	;10651	NPLA1	[P.FSRC-R1, ^0 XXXX 011 0XX XXX XXX]
U 3373, 0000,0211,2532,1525	;10652		INPR.W	[AC76.3, RA]		; Retrieve last of AC.
				;10653	=
				;10654		COM.W	[RB, RB],		; Change sign of FSRC.
U 1525, 0000,1471,7573,0666	;10655				NAF/P.EXP6	; Do decode of FSRC.3.
				;10656	
				;10657	; Call Exp extractors on FSRC.3.
				;10658	
				;10659	=11********0	; Default for Exp extractors and overrides.
U 3374, 0037,7777,3300,0000	;10660	NPLA1	[P.EXP6, ^X]
				;10661		LLD.L	[377, R9.H],		; Overridden by Exp extractors.
U 3375, 0000,0563,7751,0335	;10662				NAF/ADD8	; High address of block.
				;10663	=
				;10664	; Block for UV, Exp = 0, and normal.
				;10665	=000
				;10666		LMSTK	[ADD8A, R9],		; FSRC is UV.  Is it an AC or disabled ?
U 0330, 0000,0531,5631,1730	;10667				NAF/FIUV-CK	; Go check it and return if true.
				;10668	=100
				;10669	ADD8A:					; FSRC is 0.  Result is AC.
				;10670		OUTS	[LD_PIR, RA],		; Decode AC.3 for FCC update.
U 0334, 0000,0271,6772,1526	;10671				NAF/ADD8B	; Skip.
				;10672	=101
				;10673	ADD8:
				;10674		OUTS	[LD_PIR, RA],		; Load AC.3 for Exp extractors.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  259
; FP11  .MCD [242,1110]      ADDf, SUBf

U 0335, 0000,0271,6772,0763	;10675				NAF/P.MAN3	; First extract mantissa from FSRC.3.
				;10676	=
				;10677	; Call mantissa extractors on FSRC.3.
				;10678	
				;10679	=11********0	; Default for mantissa extraction and hidden bit insertion.
U 3376, 0037,7777,7140,0000	;10680	NPLA1	[P.MAN3, ^X]
				;10681		LLD.W	[377, RF.H],		; Overridden by mantissa extractors.
U 3377, 0000,0561,7757,0667	;10682				NAF/P.EXP7	; Insert mantissa to high word.
				;10683	=
				;10684	; Call Exp extractors on AC.3.
				;10685	
				;10686	=11********0	; Default for Exp extraction and check of Exp = 0.
U 3400, 0037,7777,3340,0000	;10687	NPLA1	[P.EXP7, ^X]
				;10688		LLD.L	[377, R8.H],		; Overridden by Exp extractors.
U 3401, 0000,0563,7750,0341	;10689				NAF/ADD12	; High address of block.
				;10690	=
				;10691	=000					; Ignore UV and bias overrides.
				;10692		ASL.L	[RB, RB],		; AC is 0.  Result is new FSRC.
U 0340, 0000,1233,7573,1527	;10693				NAF/ADD8C	; Save new sign.  Skip.
				;10694	=001
				;10695	ADD12:
				;10696		SUB.W	[R8.H, R9],		; Calculate Exp difference.
				;10697						; Exp(FSRC) - Exp(AC).
U 0341, 0000,1411,6431,0762	;10698				NAF/P.MAN2	; Skip past zero cases.
				;10699	=
				;10700	; For zero cases only.
				;10701	
				;10702	; FSRC = 0.
				;10703	;  Simply update FCC on AC.  If AC is zero however, store exact zero.
				;10704	
				;10705	ADD8B:
				;10706		INPR.W	[FPS, RA],		; Retrieve FPS for update.
U 1526, 0000,0210,2732,0727	;10707				NAF/P.NZ7	; See FN and FZ overrides too.
				;10708	
				;10709	;=11********0	; Default for FN and FZ overrides.
				;10710	;PLA1	[^1 01X 11X, ^X]		; (P.CMP7, P.CMP8, P.NZ6, or P.NZ7).
				;10711	;	LBIC.W	[017, RA],		; Clear FCCs.
				;10712	;			NAF/TSTF3	; High address of block.
				;10713	;=
				;10714	;; For FSRC = 0 case.
				;10715	;
				;10716	;=11********0	; Override for AC zero.
				;10717	;PLA1	[^X 010 111, ^X000 000 00X XXX XXX]	; (P.CMP8 or P.NZ7).
				;10718	;	NOP.W	[RF, RF],
				;10719	;			NAF/1770	; Override to Exact Zero.
				;10720	;=
				;10721	;=000	; CMPf and ADDf.
				;10722	;EXACT-0C:
				;10723	;	OUTS	[LD_FPS, R9],		; Load FD and opcode (or 0 for ADDf).
				;10724	;			NAF/EXACT-0D	; See "Exact Zero".
				;10725	;
				;10726	;; Block for FN and FZ overrides.
				;10727	;=00	; For TSTf only.
				;10728	;	LMSTK	[FN.FZ1, R9],		; Call check for FUIV and Mode 0.
				;10729	;			NAF/FIUV-CK	; Return if don't trap.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  260
; FP11  .MCD [242,1110]      ADDf, SUBf

				;10730	;=01
				;10731	;	LBIS.W	[010, RA],		; Set FN.
				;10732	;			NAF/TSTF3
				;10733	;=10
				;10734	;	LBIS.W	[004, RA],		; Set FZ.
				;10735	;			NAF/TSTF3
				;10736	;=11
				;10737	;TSTF3:
				;10738	;	OUTR.W	[FPS, RA],		; So simple.
				;10739	;			NAF/NOP-PF	; All done.
				;10740	;=
				;10741	
				;10742	; AC = 0.
				;10743	;  Reconstruct FSRC.3 with new sign (in case of SUB), update FCC and store AC.
				;10744	
				;10745	ADD8C:
U 1527, 0000,1231,6773,1530	;10746		ASL.W	[RF.H, RB]		; Shift mantissa for Exp insertion.
				;10747	
U 1530, 0000,1467,6473,1531	;10748		SWAB.B	[R9.H, RB]		; Insert Exp writing over hidden bit.
				;10749	
U 1531, 0000,1343,7573,1532	;10750		ASR.L	[RB, RB]		; Restore sign and re-align.
				;10751	ADD8E:
				;10752		OUTS	[LD_PIR, RB],		; Now decode sign and store as AC.
U 1532, 0000,0271,6773,0304	;10753				NAF/ADD8D	; Join LDf.
				;10754	
				;10755	;ADD8D:					; Entry for ADDf/SUBf, AC = 0 case.
				;10756	;	INPR.W	[FPS, RA],		; Retrieve FPS.
				;10757	;			NAF/P.NZ0	; Set FCC and check FIUV.
				;10758	;=
				;10759	;=11********0	; Default for FN and FZ overrides.
				;10760	;NPLA1	[P.NZ0, ^X]
				;10761	;	LBIC.W	[017, RA],		; Clear FCCs.
				;10762	;			NAF/LDF3	; High address of block.
				;10763	;=
				;10764	;; Block for FN and FZ overrides.
				;10765	;=00	; For LDf only.
				;10766	;	LMSTK	[LDF2, R9],		; Return if don't trap on UV.
				;10767	;			NAF/FIUV-CK	; Call subroutine.
				;10768	;=01
				;10769	;	LBIS.W	[010, RA],		; Set FN.
				;10770	;			NAF/LDF3
				;10771	;=10
				;10772	;LDF4:					; Entry for "Exact Zero".
				;10773	;	LBIS.W	[004, RA],		; Set FZ.
				;10774	;			NAF/LDF3
				;10775	;=11
				;10776	;LDF3:
				;10777	;	OUTS	[LD_FPS, R9],		; Reload FD and opcode.
				;10778	;			NAF/FPS-STR1	; Store FPS and AC.
				;10779	;=
				;10780	;; See "Store FCC/AC/Exit".
				;10781	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  261
; FP11  .MCD [242,1110]      ADDf, SUBf

				;10782	; Non-zero cases.
				;10783	
				;10784	; Call mantissa extractors on AC.3.
				;10785	
				;10786	=11********0	; Default for mantissa extraction and hidden bit insertion.
U 3402, 0037,7777,7100,0000	;10787	NPLA1	[P.MAN2, ^X]
U 3403, 0000,0561,7756,1533	;10788		LLD.W	[377, RE.H]		; Overridden by mantissa extractors.
				;10789	=					; Insert mantissa to high word.
				;10790	
U 1533, 0000,0271,7571,1534	;10791		OUTS	[LD_FPS, R9]		; PIR <= FPS, Exp difference.
				;10792	
				;10793	;	R9 is reserved to hold the opcode for all other arithmetics.
				;10794	;	ADD and SUB leave the exponent difference in R9 and PIR.  This
				;10795	;	difference is bounded by -376 =< Diff =< 376.  Thus, PIR<11:8> is
				;10796	;	either all 0's or all 1's.  This pattern matches none of the other
				;10797	;	opcodes and hence is unique.
				;10798	
U 1534, 0000,1541,7552,1535	;10799		XOR.W	[RB, RA.H]		; AN, RA<31> <= signs different.
				;10800	
				;10801		JAN	[P.SUB1],		; If signs different, do subtract.
U 1535, 0000,0173,4277,0704	;10802				NAF/P.ADD1	; Get exponent and invoke overrides.
				;10803	
				;10804	; Invoke double override.
				;10805	; Decode Exponent difference, and difference is zero.
				;10806	
				;10807	=11********0	; Default for Exp(FSRC) > Exp(AC) and ADD or SUB.
U 3404, 0037,7777,4200,0000	;10808	NPLA1	[P.ADD1, ^X]
				;10809		MOV.W	[R9.H, R8],		; Take Exp(FSRC) as largest.
U 3405, 0000,1561,6470,0357	;10810				NAF/EFADD	; Set default for ADD.
				;10811	=
				;10812	=11********0	; Default for overrides and SUB only.
U 3406, 0037,7777,4240,0000	;10813	NPLA1	[P.SUB1, ^X]
				;10814		OUTR.L	[SR, RF.H],		; AC <= 0.  SR <= 0.
U 3407, 0000,0253,0317,0367	;10815				NAF/EFSUB	; Set default for SUB.
				;10816	=
				;10817	; P.ADD1 + P.SUB1 + P.ASF2
				;10818	=11********0	; Override for Exp(FSRC) < Exp(AC).
U 3410, 0177,3777,4200,4000	;10819	PLA1	[^1 000 1XX, ^XXXX 1XX XXX XXX XXX]
				;10820		NOP.B	[RE, RF],		; Override; Take AC as largest.
U 3411, 0000,1777,7737,1775	;10821				NAF/1775	; Override NAF<1>.
				;10822	=
				;10823	; P.ADD1 + P.SUB1
				;10824	=11********0	; Override for Exp(FSRC) = Exp(AC).
U 3412, 0077,0000,4200,0000	;10825	PLA1	[^1 000 10X, ^XXXX 000 000 000 000]
				;10826		NOP.B	[RE, RF],		; Doesn't change SR code.
U 3413, 0000,1777,7737,1771	;10827				NAF/1771	; Override NAF<2:1>.
				;10828	=
				;10829	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  262
; FP11  .MCD [242,1110]      ADDf, SUBf

				;10830	; Effective ADD block.
				;10831	
				;10832	=000	; Exponents equal and ADDD.
				;10833		SWAB.B	[R8, RE.H],		; Insert the exponent before add.
U 0350, 0000,1467,7416,1543	;10834				NAF/ADD2D	; Skip.
				;10835	=001	; Exponents equal and ADDF.
				;10836		SWAB.B	[R8, RE.H],		; Insert the exponent before add.
U 0351, 0000,1467,7416,1542	;10837				NAF/ADD2F	; Skip.
				;10838	=100	; Unequal exponents and ADDD; AC largest.
				;10839	ASF9D:
				;10840		ASL.L*	[RC, RC],		; Move binary point one left.
U 0354, 0000,1233,5634,1536	;10841				NAF/ADD4D	; Skip.
				;10842	=101	; Unequal exponents and ADDF; AC largest.
				;10843	ASF9F:
				;10844		ASL.L	[RE, RE],		; Move binary point one left.
U 0355, 0000,1233,7736,0706	;10845				NAF/P.ASF2	; Get sign.  Skip.
				;10846	=110	; Unequal exponents and ADDD; FSRC largest.
				;10847	ASF8D:
				;10848		ASL.L*	[RD, RD],		; Move binary point one left.
U 0356, 0000,1233,5675,1537	;10849				NAF/ADD5D	; Skip.
				;10850	=111	; Unequal exponents and ADDF; FSRC largest.
				;10851	EFADD:
				;10852		ASL.L	[RF, RF],		; Move binary point one left.
U 0357, 0000,1233,7777,0706	;10853				NAF/P.ASF2	; Get sign.  Skip.
				;10854	=
				;10855	ADD4D:
				;10856		ROL.L	[RE, RE],		; Ditto.  Propagate carry.
U 1536, 0000,1213,7736,0706	;10857				NAF/P.ASF2	; Get sign.  Skip.
				;10858	ADD5D:
				;10859		ROL.L	[RF, RF],		; Ditto.  Propagate carry.
U 1537, 0000,1213,7777,0706	;10860				NAF/P.ASF2	; Get sign.  Skip.
				;10861	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  263
; FP11  .MCD [242,1110]      ADDf, SUBf

				;10862	; Effective SUB block.
				;10863	
				;10864	=000	; Exponents equal and SUBD.
				;10865		XLDIVS*	[RC, RD],		; Low order FSRC - AC; shift.
U 0360, 0000,1113,5635,1547	;10866				NAF/SUB2D	; Skip.
				;10867	=001	; Exponents equal and SUBF.
				;10868		XLDIVS	[RE, RF],		; RF <= FSRC - AC.  Shift left.
U 0361, 0000,1113,7737,1546	;10869				NAF/SUB2F	; Skip.  Don't shift SR
				;10870						;  because of extended normalize.
				;10871	=100	; Unequal exponents and SUBD; AC largest.
				;10872		NEG.L*	[RD, RD],		; Negate smaller (FSRC).
U 0364, 0000,1333,5675,1540	;10873				NAF/SUB4D	; Skip.
				;10874	=101	; Unequal exponents and SUBF; AC largest.
				;10875		NEG.L	[RF, RF],		; Negate smaller (FSRC).
U 0365, 0000,1333,7777,0355	;10876				NAF/ASF9F	; Join common.
				;10877	=110	; Unequal exponents and SUBD; FSRC largest.
				;10878		NEG.L*	[RC, RC],		; Negate smaller (AC).
U 0366, 0000,1333,5634,1541	;10879				NAF/SUB5D	; Skip.
				;10880	=111	; Unequal exponents and SUBF; FSRC largest.
				;10881	EFSUB:
				;10882		NEG.L	[RE, RE],		; Negate smaller (AC).
U 0367, 0000,1333,7736,0357	;10883				NAF/EFADD	; Join common.
				;10884	=
				;10885	SUB4D:
				;10886		NEGC.L	[RF, RF],
U 1540, 0000,1373,7777,0354	;10887				NAF/ASF9D	; Join common.
				;10888	SUB5D:
				;10889		NEGC.L	[RE, RE],
U 1541, 0000,1373,7736,0356	;10890				NAF/ASF8D	; Join common.
				;10891	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  264
; FP11  .MCD [242,1110]      ADDf, SUBf

				;10892	; Exponents equal for ADD continued.
				;10893	
				;10894	; For this special case, the hidden bits add and increment the exponent.
				;10895	; The result is correct with the LSB as rounding bit.
				;10896	
				;10897	ADD2F:
				;10898		ADD.L	[RE, RF],		; Hidden bits increment Exp.
U 1542, 0000,1443,7737,1545	;10899				NAF/ADD3	; Rounding bit is RF<0>.
				;10900	ADD2D:
U 1543, 0000,1443,5635,1544	;10901		ADD.L*	[RC, RD]		; Add low order.
				;10902	
U 1544, 0000,1603,7737,1545	;10903		ADDC.L	[RE, RF]		; High order bits and carry.
				;10904	
				;10905	ADD3:					; Effective ADD special; LDCfd.
				;10906		ASL.L	[RB, RB],		; Shift sign left for sign insertion.
U 1545, 0000,1233,7573,0647	;10907				NAF/P.NRM0	; See "Rounding".
				;10908	
				;10909	; RF, RD <= Result.
				;10910	
				;10911	
				;10912	
				;10913	; Exponents equal for SUB continued.
				;10914	
				;10915	SUB2F:
				;10916		JAN	[SUB3F],		; Is result negative?
U 1546, 0000,0176,6537,1551	;10917				NAF/SUB4	; Skip.
				;10918	SUB2D:
U 1547, 0000,1153,7737,1550	;10919		XHDIVS	[RE, RF]		; High order bits and borrow; shift.
				;10920	
U 1550, 0000,0176,6577,1551	;10921		JAN	[SUB3D]			; Is result negative?
				;10922	SUB4:
				;10923		ASL.L	[RB, RB],		; If positive, FSRC is correct sign.
U 1551, 0000,1233,7573,1636	;10924				NAF/NRM		; Go normalize.  Take JAN to invert.
				;10925	
				;10926	; Invert the result.
				;10927	
				;10928	SUB3F:
				;10929		NEG.L	[RF, RF],		; 2's complement to signed magnitude.
U 1552, 0000,1333,7777,1555	;10930				NAF/SUB-TOGGLE	; Go toggle sign.
				;10931	SUB3D:
U 1553, 0000,1333,5675,1554	;10932		NEG.L*	[RD, RD]		; 2's complement to signed magnitude.
				;10933	
U 1554, 0000,1373,7777,1555	;10934		NEGC.L	[RF, RF]		; High order bits and borrow.
				;10935	
				;10936	SUB-TOGGLE:
				;10937		COM.L	[RB, RB],		; Toggle sign of result.
U 1555, 0000,1473,7573,1636	;10938				NAF/NRM		; Go normalize.
				;10939	=
				;10940	; RF, RD <= Result.
				;10941	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  265
; FP11  .MCD [242,1110]      ADDf, SUBf

				;10942	; Save sign, decode exponent difference.
				;10943	
				;10944	=11********0	; Default for Exp(FSRC) > Exp(AC).
U 3414, 0037,7777,4300,0000	;10945	NPLA1	[P.ASF2, ^X]
				;10946		ASL.L	[RB, RB],		; Sign(FSRC) is sign of result.
U 3415, 0000,1233,7573,1772	;10947				NAF/ASF10	; Default for large alignment.
				;10948	=					; May override to PLA space.
				;10949	;; P.ADD1 + P.SUB1 + P.ASF2
				;10950	;=11********0	; Override for Exp(FSRC) < Exp(AC).
				;10951	;PLA1	[^1 000 1XX, ^XXXX 1XX XXX XXX XXX]
				;10952	;	NOP.B	[RE, RF],		; Override; Take AC as largest.
				;10953	;			NAF/1775	; Override NAF<1>.
				;10954	;=
				;10955	=11********0	; Override NAF for Exp(FSRC)-Exp(AC) = +1.
U 3416, 0037,0000,4300,0001	;10956	NPLA1	[P.ASF2, ^XXXX 000 000 000 001]
				;10957		NOP.L	[RF, RF],		; Override NAF to
U 3417, 0000,1773,7777,0650	;10958				NAF/P.ALN0	;  P.ALN0 to skip alignment.
				;10959	=11********0	; Override NAF for Exp(FSRC)-Exp(AC) = -1.
U 3420, 0037,0000,4300,7777	;10960	NPLA1	[P.ASF2, ^XXXX 111 111 111 111]
				;10961		NOP.L	[RF, RF],		; Override NAF to
U 3421, 0000,1773,7777,0650	;10962				NAF/P.ALN0	;  P.ALN0 to skip alignment.
				;10963	=11********0	; Override NAF if shift < +64.
U 3422, 0037,0077,4300,0000	;10964	NPLA1	[P.ASF2, ^XXXX 000 000 XXX XXX]
				;10965		NOP.L	[RF, RF],
U 3423, 0000,1773,7777,1757	;10966				NAF/1757	; Override NAF to do alignment.
				;10967	=11********0	; Override NAF if shift =< -64.
U 3424, 0037,0077,4300,7700	;10968	NPLA1	[P.ASF2, ^XXXX 111 111 XXX XXX]
				;10969		NOP.L	[RF, RF],
U 3425, 0000,1773,7777,1757	;10970				NAF/1757	; Override NAF to do alignment.
				;10971	; No need to align.
				;10972	; P.ALN0:	= 0650.			; For alignments of +1 or -1.
				;10973	
				;10974	=111*101*00				; Must override to P.ALN0.
				;10975	; Align for Exp(AC) > Exp(FSRC).	; Ignore double override.
				;10976	
U 1750, 0000,1331,7471,1752	;10977		NEG.W	[R9, R9]		; Form positive count.
				;10978	
				;10979	; Align for Exp(FSRC) > Exp(AC).
				;10980	=0					; Skip double override.
				;10981		OUTS	[LD_CNTR, R9],		; Load the shift count to CNTR.
U 1752, 0000,0271,5771,1563	;10982				NAF/ASF5	; Skip to alignment.
				;10983	=0					; Skip double override.
				;10984	; Large alignment for Exp(AC) > Exp(FSRC).
				;10985		SWAB.W	[RF.H, RF],		; RF<7> <= sign_mantissa(FSRC).
U 1770, 0000,1461,6777,1556	;10986				NAF/ASF6A	; Skip to sign extension.
				;10987	=0					; Skip double override.
				;10988	; Large alignment for Exp(FSRC) > Exp(AC).
				;10989	ASF10:
				;10990		SWAB.W	[RE.H, RE],		; RE<7> <= sign_mantissa(AC).
U 1772, 0000,1461,6736,1560	;10991				NAF/ASF6B	; Skip to sign extension.
				;10992	=
				;10993	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  266
; FP11  .MCD [242,1110]      ADDf, SUBf

				;10994	; Sign extend smaller operand for out of shift range.
				;10995	
				;10996	ASF6A:
U 1556, 0000,1023,7777,1557	;10997		MOVS.L	[RF, RF]		; Replicate sign.
				;10998	
				;10999		MOVS.L	[RF, RD],		; Replicate sign for double.
U 1557, 0000,1023,7775,1562	;11000				NAF/ASF12	; Skip.
				;11001	ASF6B:
U 1560, 0000,1023,7736,1561	;11002		MOVS.L	[RE, RE]		; Replicate sign.
				;11003	
U 1561, 0000,1023,7734,1562	;11004		MOVS.L	[RE, RC]		; Replicate sign for double.
				;11005	
				;11006	ASF12:
				;11007		LCNTR.B	[002, R8.H],		; Do one (real) shift to get
U 1562, 0000,0526,0110,1563	;11008				NAF/ASF5	;  potential rounding bit right.
				;11009	
				;11010	; Note: AC overrides are usable here.
				;11011	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  267
; FP11  .MCD [242,1110]      ADDf, SUBf

				;11012	; Align operands.
				;11013	; All P.ALNx addresses check for interrupts.
				;11014	
				;11015	ASF5:
				;11016		CLR.L	[RA, RA],		; Needed for SMULS.
				;11017			DECR CNTR,		; Compensate for left shift of larger.
U 1563, 0000,1043,3532,0651	;11018				NAF/P.ALN1	; Separate mode and invoke override.
				;11019	
				;11020	; Odd P.ALNx addresses invoke this override.
				;11021	; Override for Exp(AC) < Exp(FSRC).  Shift AC.
				;11022	=11********0	; Override to AC registers.
U 3426, 0317,3777,2440,0000	;11023	PLA1	[^0 101 XX1, ^0 XXXX 0XX XXX XXX XXX]
				;11024		NOP.B	[RE, RE],		; Override to even registers.
U 3427, 0000,1777,7736,1777	;11025				NAF/1777
				;11026	=
				;11027	
				;11028	; Single precision.
				;11029	
				;11030	=11********0	; Default for Exp(FSRC) < Exp(AC).  Shift FSRC.
U 3430, 0007,7777,2440,0000	;11031	NPLA1	[P.ALN1, ^0 0XXX XXX XXX XXX XXX]
				;11032		SMULS.L	[RA, RF],		; Equivalent to ASR.Q which we don't
				;11033			DECR CNTR,		;  have.  SR <= potential rounding bit.
U 3431, 0000,1143,3537,0651	;11034				NAF/P.ALN1	; Loop.  Go to P.ALN0 when done.
				;11035	=
				;11036	; Double precision.
				;11037	
				;11038	=11********0	; Default for Exp(FSRC) < Exp(AC).  Shift FSRC.
U 3432, 0007,7777,2450,0000	;11039	NPLA1	[P.ALN1, ^0 1XXX XXX XXX XXX XXX]
				;11040		OUTR.L	[SR, RD],		; SR <= FSRC.1 @ FSRC.0.
U 3433, 0000,0253,0335,0653	;11041				NAF/P.ALN3	; Invoke AC override again.
				;11042	=
				;11043	=11********0	; Shift for double.
U 3434, 0007,7777,2550,0000	;11044	NPLA1	[P.ALN3, ^0 1XXX XXX XXX XXX XXX]
				;11045		SMULS.L* [RA, RF],		; Equivalent to ASR.Q which we don't
				;11046			DECR CNTR,		;  have.  C <= potential rounding bit.
U 3435, 0000,1143,1537,0653	;11047				NAF/P.ALN3	; Loop.  Fall thru to P.ALN2 when done.
				;11048	=
				;11049	=11********0	; After shifting.
U 3436, 0007,7777,2510,0000	;11050	NPLA1	[P.ALN2, ^0 1XXX XXX XXX XXX XXX]
				;11051		ROR.L	[RA, RA],		; RA<31> <= potential rounding bit.
U 3437, 0000,1243,7532,0655	;11052				NAF/P.ALN5	; Now invoke AC override again.
				;11053	=
				;11054	=11********0	; Retrieve result.
U 3440, 0007,7777,2650,0000	;11055	NPLA1	[P.ALN5, ^0 1XXX XXX XXX XXX XXX]
U 3441, 0000,0213,0335,1564	;11056		INPR.L	[SR, RD]		; Retrieve shifted result.
				;11057	=
				;11058	ASF13:
				;11059		OUTR.L	[SR, RA],		; SR<31> <= potential rounding bit.
U 1564, 0000,0253,0332,0650	;11060				NAF/P.ALN0	; Do the add or subtract.
				;11061	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  268
; FP11  .MCD [242,1110]      ADDf, SUBf

				;11062	; Do the add or subtract.
				;11063	; Check interrupts.
				;11064	
				;11065	=11********0	; Single.
U 3442, 0007,7777,2400,0000	;11066	NPLA1	[P.ALN0, ^0 0XXX XXX XXX XXX XXX]
				;11067		ADD.L	[RE, RF],		; Finish add or subtract.
U 3443, 0000,1443,7737,1636	;11068				NAF/NRM		; Go normalize.
				;11069	=
				;11070	=11********0	; Double.
U 3444, 0007,7777,2410,0000	;11071	NPLA1	[P.ALN0, ^0 1XXX XXX XXX XXX XXX]
U 3445, 0000,1443,5635,1565	;11072		ADD.L*	[RC, RD]		; Add low order.
				;11073	=
				;11074		ADDC.L	[RE, RF],		; Finish add or subtract.
U 1565, 0000,1603,7737,1636	;11075				NAF/NRM		; See "Normalization".
				;11076	
;11077	.NOBIN
;11078	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  269
; FP11  .MCD [242,1110]      MULf

;11079		.TOC	"				MULf"
;11080	
;11081	;
;11082	; MULf:
;11083	;	AC	<= AC * FSRC.
;11084	;
;11085	;	Multiply two FP operands.
;11086	;
;11087	;	Interrupt on undefined variable may occur.
;11088	;	Underflow and overflow may occur.
;11089	;
;11090	;	FC	<= 0.
;11091	;	FV	<= 1 if overflow occurs; 0 otherwise.
;11092	;	FZ	<= 1 if AC = 0; 0 otherwise.
;11093	;	FN	<= 1 if AC < 0; 0 otherwise.
;11094	;
;11095	; Notes:
;11096	;	This multiply uses an unsigned add and shift algorithm.
;11097	;
;11098	;	a = f1 * 2**k1
;11099	;	b = f2 * 2**k2
;11100	;	c = a * b
;11101	;	  = (f1 * f2) * (2**k1 * 2**k2)
;11102	;	  = d * 2**e
;11103	;    where:
;11104	;	d = f1 * f2	and 	e = k1 + k2
;11105	;    since:
;11106	;	1/2 =< f < 1	then	1/4 =< d < 1
;11107	;    thus, for the form:
;11108	;	g = f3 * 2**k3,
;11109	;	f3 = 2d		and	k3 = e - 1	if d < 1/2 (normalized 1 left)
;11110	;	f3 = d		and	k3 = e		if d >= 1/2
;11111	;	k3, not e, must be checked for underflow or overflow.
;11112	;    accuracy:
;11113	;     upper bound:
;11114	;	d =< du		and	f3 =< fu
;11115	;      where:
;11116	;	du = (1-lsb) * (1-lsb)
;11117	;	   = 1 - 2*lsb + lsb**2		and
;11118	;	fu = 1-2lsb (chopped or rounded)
;11119	;     lower bound:
;11120	;	d >= dl		and	f3 >= fl
;11121	;      where:
;11122	;	dl = 1/2 * 1/2 = 1/4		and
;11123	;	fl = 1/2 (chopped or rounded)
;11124	;     nearest bound: (nearest to, but less than 1/2)
;11125	;	d = dn		and	f3 = fn
;11126	;      where:
;11127	;	dn = (1/2 + lsb) * (1 - 2lsb)
;11128	;	   = 1/2 - 2lsb**2		and
;11129	;	fn = 1-lsb (chopped)	or	fn = 1/2 (rounded)
;11130	;	Thus, rounding may cause the exponent to change.
;11131	;    iterations:
;11132	;	i = 24 (floating)	or	i = 56 (double)
;11133	;    normalization and rounding:
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  270
; FP11  .MCD [242,1110]      MULf

;11134	;	The result's binary point is always shifted 1 left.  d is multiplied by
;11135	;	2, and k3 decremented, if the hidden bit is not aligned for exponent
;11136	;	insertion (i.e. d < 1/2).  Thus, for MULf, the rounding bit will be
;11137	;	result<0>.
;11138	;
;11139	
				;11140	.BIN
				;11141	
				;11142	; After operands have been fetched.
				;11143	; Check interrupts.
				;11144	
				;11145	=11********0	; Breakout MULf and MODf after FSRC addressing.
U 3446, 0017,0777,2600,1000	;11146	NPLA1	[P.FSRC-R1, ^0 XXXX 001 XXX XXX XXX]
				;11147		INPR.W	[AC76.3, RA],		; Retrieve last of AC.
U 3447, 0000,0211,2532,0662	;11148				NAF/P.EXP2	; Do decode of FSRC.3.
				;11149	=
				;11150	; Extract Exps and add them; fix up mantissa for multiply.
				;11151	
				;11152	; Call Exp extractors on FSRC.3.
				;11153	
				;11154	=11********0	; Default for Exp extractors and overrides.
U 3450, 0037,7777,3100,0000	;11155	NPLA1	[P.EXP2, ^X]
				;11156		LLD.W	[177, R8],		; Overridden by Exp extractors.
U 3451, 0000,0560,7770,0377	;11157				NAF/MUL8	; High address of block.
				;11158	=
				;11159	; Note:
				;11160	;  If the Exp is greater than 200, then LLD.W [177, R8] unbiases it.
				;11161	;  If the Exp is less than 200, then NAF<1> is overridden.
				;11162	
				;11163	; Block for UV, Exp = 0, biasing, and normal.
				;11164	=000
				;11165		LMSTK	[MUL9, R9],		; FSRC is UV.  Is it an AC or disabled ?
U 0370, 0000,0531,7631,1730	;11166				NAF/FIUV-CK	; Go check it and return if true.
				;11167	=100
				;11168	MUL9:
				;11169		INPR.W	[FPS, RA],		; FSRC is 0.  Result is 0.
U 0374, 0000,0210,2732,1726	;11170				NAF/EXACT-0B	; See "Exact Zero".
				;11171	=101
U 0375, 0000,0411,0030,0377	;11172		LSUB.W	[200, R8]		; Unbias the Exp manually.
				;11173	=111
				;11174	MUL8:					; Exp is now, or was unbiased above.
				;11175		OUTS	[LD_PIR, RA],		; Load AC.3 for Exp/mantissa extractors.
U 0377, 0000,0271,6772,0760	;11176				NAF/P.MAN0	; First extract mantissa from FSRC.3.
				;11177	=
				;11178	; Call mantissa extractors on FSRC.3.
				;11179	
				;11180	=11********0	; Default for mantissa extraction and hidden bit insertion.
U 3452, 0037,7777,7000,0000	;11181	NPLA1	[P.MAN0, ^X]
				;11182		LLD.W	[377, RF.H],		; Overridden by mantissa extractors.
U 3453, 0000,0561,7757,0761	;11183				NAF/P.MAN1	; Insert mantissa to high word.
				;11184	=
				;11185	; Call mantissa extractors on AC.3.
				;11186	
				;11187	=11********0	; Default for mantissa extraction and hidden bit insertion.
U 3454, 0037,7777,7040,0000	;11188	NPLA1	[P.MAN1, ^X]
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  271
; FP11  .MCD [242,1110]      MULf

U 3455, 0000,0561,7756,1566	;11189		LLD.W	[377, RE.H]		; Overridden by mantissa extractors.
				;11190	=					; Insert mantissa to high word.
				;11191	
				;11192		OUTS	[LD_FPS, R9],		; PIR <= FPS, Opcode.
U 1566, 0000,0271,7571,0663	;11193				NAF/P.EXP3	; First extract and check AC exponent.
				;11194	
				;11195	; Call Exp extractors on AC.3 and compute result's Exp.
				;11196	
				;11197	=11********0	; Default for Exp extraction and check of Exp = 0.
U 3456, 0037,7777,3140,0000	;11198	NPLA1	[P.EXP3, ^X]
				;11199		LADD.W	[377, R8],		; Overridden by Exp extractors.
U 3457, 0000,0441,7770,1011	;11200				NAF/MUL12	; High address of block.
				;11201	=
				;11202	=000					; Ignore UV and bias overrides.
				;11203	MUL10:
				;11204		INPR.W	[FPS, RA],		; AC is 0.  Result is 0.
U 1010, 0000,0210,2732,1726	;11205				NAF/EXACT-0B	; See "Exact Zero".
				;11206	=001
				;11207	MUL12:
				;11208		XOR.W	[RA, RB],		; RB<15> <= sign of result.
U 1011, 0000,1541,7533,0713	;11209				NAF/P.OPCD2	; Separate instructions.
				;11210	=					; Invoke double override.
				;11211	=11********0	; Breakout MULf and MODf.
U 3460, 0037,0777,4540,1000	;11212	NPLA1	[P.OPCD2, ^XXXX 001 XXX XXX XXX]
				;11213		CLR.L	[RA, RA],		; Clear partial product for both loops.
U 3461, 0000,1043,7532,1017	;11214				NAF/MULF0	; Invoke double override.
				;11215	=
				;11216	=0
				;11217	; Double precision multiply loop.
				;11218	MULD0:
				;11219		LCNTR.W	[040, R8.H],		; CNTR <= 32..
U 1016, 0000,0520,2010,1570	;11220				NAF/MULD0A	; Start double loop.
				;11221	
				;11222	; Single precision multiply loop.
				;11223	MULF0:
				;11224		LCNTR.W	[027, R8.H],		; CNTR <= 23..  Do 23. + 1 iterations.
U 1017, 0000,0520,1350,1567	;11225				NAF/MULF0A	; Start single loop.
				;11226	=
				;11227	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  272
; FP11  .MCD [242,1110]      MULf

				;11228	; Single precision multiply loop continued.
				;11229	MULF0A:
				;11230		OUTR.L	[SR, RE],		; SR <= Multiplier, AC.
U 1567, 0000,0253,0336,1023	;11231				NAF/MULF1	; Calculate result.
				;11232	=0
				;11233		ADD.L	[RA, RF],		; Fake SR<0> = 1, hidden bit.
				;11234						; Effectively shift binary point 1 left.
U 1022, 0000,1443,7537,1551	;11235				NAF/SUB4	; Get Sign.
				;11236	MULF1:
				;11237		UMULS.L	[RF, RA],		; Add based on SR<0> and shift right.
				;11238			DECR CNTR,		; Do 23. iterations + 1 more when done.
U 1023, 0000,1103,3772,1023	;11239				NAF/MULF1	; Loop on this till done.
				;11240	=
				;11241	;SUB4:
				;11242	;	ASL.L	[RB, RB],		; If positive, FSRC is correct sign.
				;11243	;			NAF/NRM		; Go normalize.  Take JAN to invert.
				;11244	
				;11245	; RF, SR <= Result.			; Result is normalized 38.6%
				;11246						;  (2*ln2-1) of the time.
				;11247	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  273
; FP11  .MCD [242,1110]      MULf

				;11248	; Double precision multiply loop continued.
				;11249	
				;11250	;	AC	= RE @ RC
				;11251	;	FSRC	= RF @ RD
				;11252	;	AC*FSRC	= RE*RF + (RC*RF + RD*RE)*2**-24 + (RC*RD)*2**-48
				;11253	;
				;11254	; RE*RF	24X24	|0|  M  |  N  |0|
				;11255	; RC*RF	32X24		|  P    |  Q  |0|
				;11256	; RE*RD	24X32	      |0|  R  |    S  |
				;11257	; RC*RD	32X32		      |	   T  |	  V   |
				;11258	; Result	|0| R E |  S U  | L T |0|
				;11259	
				;11260	
				;11261	; 1) Compute T and V.  Discard V.
				;11262	;    RA <= T.
				;11263	
				;11264	MULD0A:
				;11265		OUTR.L	[SR, RD],		; SR <= RD.
U 1570, 0000,0253,0335,1027	;11266				NAF/MULD1
				;11267	=0					; After 1st loop.
				;11268		LCNTR.W	[040, R8.H],		; CNTR <= 32..
U 1026, 0000,0520,2010,0640	;11269				NAF/P.INT0	; Check interrupts.
				;11270	MULD1:
				;11271		UMULS.L	[RC, RA],		; Compute 64-bit RC*RD.
				;11272			DECR CNTR,
U 1027, 0000,1103,3632,1027	;11273				NAF/MULD1	; Loop back when done.
				;11274	=
				;11275	; 2) Compute R and S.  T is initial partial product.  Retrieve S.
				;11276	;    RA <= R.  RD <= S.
				;11277	
				;11278	=11********0	; Check interrupts.
U 3462, 0007,0777,2010,1000	;11279	NPLA1	[P.INT0, ^0 1XXX 001 XXX XXX XXX]
				;11280		OUTR.L	[SR, RD],		; SR <= RD.  Discard result<-81:-112>.
U 3463, 0000,0253,0335,1055	;11281				NAF/MULD3
				;11282	=
				;11283	=0					; After 2nd loop.
				;11284		INPR.L	[SR, RD],		; Retrieve partial<-49:-80> from SR.
U 1054, 0000,0213,0335,0641	;11285				NAF/P.INT1	; RA @ RD has result so far.
				;11286	MULD3:
				;11287		UMULS.L	[RE, RA],		; Compute 56-bit RE*RD.
				;11288			DECR CNTR,
U 1055, 0000,1103,3732,1055	;11289				NAF/MULD3	; Loop back when done.
				;11290	=
				;11291	; 3) Compute M and N.  R is initial partial product.  Retrieve N.
				;11292	;    RA <= M.  RE <= N.
				;11293	
				;11294	=11********0	; Check interrupts.
U 3464, 0007,0777,2050,1000	;11295	NPLA1	[P.INT1, ^0 1XXX 001 XXX XXX XXX]
U 3465, 0000,0253,0337,1571	;11296		OUTR.L	[SR, RF]		; SR <= RF.
				;11297	=
				;11298		LCNTR.W	[030, R8.H],		; CNTR <= 24..
U 1571, 0000,0520,1410,1065	;11299				NAF/MULD4
				;11300	=0					; After 3rd loop.
				;11301		INPR.L	[SR, RE],		; Retrieve partial<-25:-48>@0.
U 1064, 0000,0213,0336,1572	;11302				NAF/MULD5	; RA @ RE @ RD has result so far.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  274
; FP11  .MCD [242,1110]      MULf

				;11303	MULD4:
				;11304		UMULS.L	[RE, RA],		; Compute 48-bit RF*RE.
				;11305			DECR CNTR,
U 1065, 0000,1103,3732,1065	;11306				NAF/MULD4	; Loop back when done.
				;11307	=
				;11308	; 4) Compute P and Q.  S is initial partial product.
				;11309	;    RD <= P.
				;11310	
				;11311	MULD5:
				;11312		OUTR.L	[SR, RF],		; SR <= RF.
U 1572, 0000,0253,0337,0642	;11313				NAF/P.INT2	; Check interrupts.
				;11314	
				;11315	=11********0	; Check interrupts.
U 3466, 0007,0777,2110,1000	;11316	NPLA1	[P.INT2, ^0 1XXX 001 XXX XXX XXX]
				;11317		LCNTR.W	[030, R8.H],		; CNTR <= 24..
U 3467, 0000,0520,1410,1067	;11318				NAF/MULD6
				;11319	=
				;11320	=0					; After 4th and final loop.
				;11321		ADD.L*	[RE, RD],		; Add N and P.
U 1066, 0000,1443,5735,1573	;11322				NAF/MULD7	; Skip.
				;11323	MULD6:
				;11324		UMULS.L	[RC, RD],		; Compute 56-bit RC*RF.
				;11325			DECR CNTR,
U 1067, 0000,1103,3635,1067	;11326				NAF/MULD6	; Loop back when done.
				;11327	=
				;11328	; 5) Add N and P.  Propagate carry to M.
				;11329	;    SR <= Result<-57:-80>@0.
				;11330	;    RD <= Result<-25:-56>.
				;11331	;    RE <= Result<-1:-24>.
				;11332	
				;11333	MULD7:
U 1573, 0000,1643,7537,1574	;11334		ADC.L	[RA, RF]		; Propagate carry.  Switch assignment.
				;11335	
				;11336	; 6) Shift binary point one left.
				;11337	;    SR <= Result<-58:-79>@0.
				;11338	;    RD <= Result<-26:-57>.
				;11339	;    RF <= Result<-1:-25>.
				;11340	
				;11341	MULD9:
U 1574, 0000,1313,5675,1575	;11342		ASL.Q*	[RD, RD]		; RF, RD, SR <= Result.
				;11343	
				;11344		ROL.L	[RF, RF],		; Propagate carry.
U 1575, 0000,1213,7777,1551	;11345				NAF/SUB4	; Get sign.
				;11346	;SUB4:
				;11347	;	ASL.L	[RB, RB],		; If positive, FSRC is correct sign.
				;11348	;			NAF/NRM		; Go normalize.  Take JAN to invert.
				;11349	
				;11350	; RF, RD, SR <= Result.			; Result is normalized 38.6%
				;11351						;  (2*ln2-1) of the time.
				;11352	
;11353	.NOBIN
;11354	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  275
; FP11  .MCD [242,1110]      MODf

;11355		.TOC	"				MODf"
;11356	
;11357	;
;11358	; MODf:
;11359	;	AC OR 1	<= INTEGER (AC * FSRC).
;11360	;	AC	<= FRACTION(AC * FSRC).
;11361	;
;11362	;	Multiply two FP operands.  Separate result into fraction and
;11363	;	integer parts and store as two FP numbers with identical signs.
;11364	;	If AC is odd, only the fractional part is stored.
;11365	;
;11366	;	Interrupt on undefined variable may occur.
;11367	;	Underflow and overflow may occur.
;11368	;
;11369	;	FC	<= 0.
;11370	;	FV	<= 1 if overflow occurs; 0 otherwise.
;11371	;	FZ	<= 1 if AC = 0; 0 otherwise.
;11372	;	FN	<= 1 if AC < 0; 0 otherwise.
;11373	;
;11374	;
;11375	; See "MULF/D".  MODf uses the same code for the basic multiply loops.
;11376	; The departure in instructions comes before normalization.
;11377	;
;11378	; MODD suffers from an inherent accuracy problem, by tradition.  The extreme
;11379	; example is EXP(PROD) = 56.  In this case, the infinite precision product
;11380	; could be represented as integer and fraction portions without error.
;11381	; Most FP11 processors have limited their ALUs to 60 bits however (the
;11382	; LSB = 2**-59).  Thus, the least significant bits (out to 2**-112) are lost.
;11383	; This code conforms to the inaccuracy by truncating the extra bits.  This
;11384	; has been justified by considering the more frequent uses of MODD:
;11385	;  A) Converting a binary fraction to decimal fraction:
;11386	;	Multiply by 10.  MODD is perfectly accurate in this application.
;11387	;  B) Reducing trigonometric arguements and calculating exponentials:
;11388	;	PI and e are irrational and cannot be represented to infinite precision.
;11389	;	Thus, any calculation involving these is limited to the same precision.
;11390	;
;11391	;
;11392	;
;11393	; There are three major cases of MOD:
;11394	;  1)	The integer portion of PROD is too large to be represented accurately in
;11395	;	L bits (i.e. L < EXP(PROD) < 400, where L is 24 or 56):
;11396	;	Store PROD in AC+1 and exact 0 in AC.  Overflow may occur.
;11397	;  2)	The integer portion of PROD can be represented accurately and as
;11398	;	non-zero (e.i. 0 < EXP(PROD) =< L):
;11399	;	Locate the binary point and store the integer portion in AC+1 and
;11400	;	the fraction portion in AC.
;11401	;  3)	The integer portion of PROD is zero:
;11402	;	Store exact zero in AC+1 and the fraction in AC.  Underflow may occur
;11403	;	if AC is too small.
;11404	;
;11405	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  276
; FP11  .MCD [242,1110]      MODf

				;11406	.BIN
				;11407	
				;11408	; From "Normalization".
				;11409	
				;11410	;NRM:
				;11411	;	MOV.W	[RF.H, RE]		; Retrieve Result.3 for OUTS load.
				;11412	;
				;11413	;	OUTS	[LD_FPS, RE],		; Decode alignment of hidden bit.
				;11414	;			NAF/P.MODF0	; Invoke check for MOD.
				;11415	;
				;11416	;=11********0	; Default for NAF override.
				;11417	;NPLA1	[P.MODF0, ^X]
				;11418	;	INPR.W	[FPS, RA],		; Retrieve FPS while waiting.
				;11419	;			NAF/P.NRM1	; Decode alignment.  P.NRM2 for MODf.
				;11420	;=
				;11421	;; P.MODF0 + P.MODF1
				;11422	;=11********0	; Override for MODf breakout (1st time through).
				;11423	;PLA1	[^0 000 10X, ^XXXX 001 1XX XXX XXX]	; MOD instruction.
				;11424	;	NOP.L	[RF, RF],		; PIR<11:8> = 0001 or 0000
				;11425	;					;  on second time through.
				;11426	;			NAF/1776	; Override to MODf.  See P.NRM2.
				;11427	;=
				;11428	
				;11429	; Discard extra bits in SR.
				;11430	; Beware of special double and truncate overrides.
				;11431	
				;11432	=11********0	; Default for double/truncate overrides.
U 3470, 0017,7777,2200,0000	;11433	NPLA1	[P.NRM2, ^0 XXXX XXX XXX XXX XXX]
				;11434		INPR.L	[SR, RC],		; Retrieve extra SR bits.
U 3471, 0000,0213,0334,0265	;11435				NAF/MOD0	; Two word block.
				;11436	=
				;11437	=00					; Ignore truncate override.
				;11438		LLSW.L	[300, RE.H],		; Form mask for two high order bits.
U 0264, 0000,0463,4016,1576	;11439				NAF/MOD0A	; Skip.  Be compatible with FPA/FP11-C
				;11440						;  and save 3 guard bits total.  The
				;11441						;  other bit is in RD<0>.
				;11442	MOD0:
U 0265, 0000,0472,0076,1576	;11443		LLCM.L	[001, RE]		; Kill hidden bit residue from MULF
				;11444	=					;  loop off the end.
				;11445	MOD0A:
				;11446		AND.L	[RE, RC],		; Mask (discard) the extra bits.
U 1576, 0000,1513,7734,0703	;11447				NAF/P.MOD1	; Check alignment of hidden bit.
				;11448	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  277
; FP11  .MCD [242,1110]      MODf

				;11449	; Check for normalized result.
				;11450	
				;11451	=11********0	; Normalize by one.  Default for Double override.
U 3472, 0037,6177,4140,0200	;11452	NPLA1	[P.MOD1, ^XXXX XX0 01X XXX XXX]
				;11453		DEC.W	[R8, R8],		; Componsate Exp for shift.
U 3473, 0000,1451,7430,1071	;11454				NAF/MOD2A	; Override if double.
				;11455	=
				;11456	=0
				;11457		ASL.Q*	[RD, RD],		; Align low order and SR.
U 1070, 0000,1313,5675,1577	;11458				NAF/MOD2B	; Skip single.
				;11459	MOD2A:
				;11460		ASL.Q	[RF, RF],		; Align hidden bit and SR.
U 1071, 0000,1313,7777,1600	;11461				NAF/MOD2	; Skip.
				;11462	=
				;11463	MOD2B:
U 1577, 0000,1213,7777,1600	;11464		ROL.L	[RF, RF]		; High order.
				;11465	MOD2:
				;11466		ASL.L	[RC, RC],		; Shift extra bits too.
U 1600, 0000,1233,7634,0702	;11467				NAF/P.MOD13	; Join no normalization case.
				;11468	
				;11469	=11********0	; Was not normal.  Default for double override.
U 3474, 0037,7777,4100,0000	;11470	NPLA1	[P.MOD13, ^X]
				;11471		LLCM.L	[000, RE],		; Start forming shift mask.
U 3475, 0000,0472,0036,1073	;11472				NAF/MOD3	; Two word block.
				;11473	=
				;11474	=11********0	; Already normalized.  Default for double override.
U 3476, 0037,6377,4140,0400	;11475	NPLA1	[P.MOD1, ^XXXX XX0 1XX XXX XXX]
				;11476		LLCM.L	[000, RE],		; Start forming shift mask.
U 3477, 0000,0472,0036,1073	;11477				NAF/MOD3	; Two word block.
				;11478	=
				;11479	=0
				;11480		OUTR.L	[SR, RE],		; Load all 1's for mask's double part.
U 1072, 0000,0253,0336,1601	;11481				NAF/MOD3A	; Skip.
				;11482	MOD3:
				;11483		LCMP.W	[230, R8],		; Single.  Is Exp > 230 (24.) ?
U 1073, 0000,0431,1430,1602	;11484				NAF/MOD3B	; Skip.
				;11485	=
				;11486	MOD3A:
U 1601, 0000,0431,3430,1602	;11487		LCMP.W	[270, R8]		; Double.  Is Exp > 270 (56.) ?
				;11488	MOD3B:
U 1602, 0000,0177,1037,1603	;11489		JAN	[MOD4]			; Take JAN if too large (case 1).
				;11490	
U 1603, 0000,1467,7417,1604	;11491		SWAB.B	[R8, RF.H]		; Always insert Exp over hidden bit.
				;11492	
U 1604, 0000,1561,7433,1605	;11493		MOV.W	[R8, RB]		; Save Exp in scratch RB.L.
				;11494	
U 1605, 0000,0411,0073,1606	;11495		LSUB.W	[201, RB]		; Generate possible shift count.
				;11496	
U 1606, 0000,0177,0777,1607	;11497		JAN	[MOD5]			; Take JAN if Exp =< 200 (no integer).
				;11498	
U 1607, 0000,0113,2037,1610	;11499		JAZ	[P.INT0]		; Take JAZ for no shifts.
				;11500	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  278
; FP11  .MCD [242,1110]      MODf

				;11501	; Case 2.  1 =< Exp =< L.
				;11502	
U 1610, 0000,0466,0016,1611	;11503		LLSW.B	[000, RE.H]		; Mask to always save the exponent.
				;11504						; Take JAZ for no shifts.
				;11505	
				;11506		OUTS	[LD_CNTR, RB],		; Load the shift count.
U 1611, 0000,0271,5773,0641	;11507				NAF/P.INT1	; Do shifts and check interrupts.
				;11508	
				;11509	=11********0	; Shift mask and check interrupts.
U 3500, 0017,0777,2040,0000	;11510	NPLA1	[P.INT1, ^0 XXXX 000 XXX XXX XXX]
				;11511		LSR.Q	[RE, RE],		; Shift mask, inserting 0's.
				;11512			DECR CNTR,
U 3501, 0000,1303,3736,0641	;11513				NAF/P.INT1	; Fall thru to P.INT0 when done.
				;11514	=
				;11515	=11********0	; After shift loop.
U 3502, 0017,0777,2000,0000	;11516	NPLA1	[P.INT0, ^0 XXXX 000 XXX XXX XXX]
				;11517		AND.L	[RF, RE],		; Save fraction in RE.
U 3503, 0000,1513,7776,0711	;11518				NAF/P.MOD6	; Call double override.
				;11519	=
				;11520	=11********0	; Default for double override.
U 3504, 0037,7777,4440,0000	;11521	NPLA1	[P.MOD6, ^X]
				;11522		BIC.L	[RE, RF],		; Save integer in RF.
U 3505, 0000,1553,7737,1075	;11523				NAF/MOD11	; Two word block.
				;11524	=
				;11525	=0
				;11526		INPR.L	[SR, RA],		; Retrieve second half of mask.
U 1074, 0000,0213,0332,1612	;11527				NAF/MOD10	; Skip.
				;11528	MOD11:
				;11529		OUTR.L	[SR, RC],		; Restore extra bits for normalization.
U 1075, 0000,0253,0334,1614	;11530				NAF/MOD12	; Skip.
				;11531	=
				;11532	MOD10:
U 1612, 0000,1513,7672,1613	;11533		AND.L	[RD, RA]		; Save low fraction in RA.
				;11534	
				;11535		BIC.L	[RA, RD],		; Save integer low portion in RD.
U 1613, 0000,1553,7535,1075	;11536				NAF/MOD11	; Go back.
				;11537	MOD12:
				;11538		LMSTK	[P.MOD14, RC],		; Return to P.MOD14 after
U 1614, 0000,0533,7474,0716	;11539				NAF/P.FORM+1	;  formatting and storing result.
				;11540	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  279
; FP11  .MCD [242,1110]      MODf

				;11541	; Case 2 continued.
				;11542	
				;11543	=11********0	; Single.
U 3506, 0027,7777,7440,0000	;11544	NPLA1	[P.MOD14, ^0XXX XXX XXX XXX XXX]
				;11545		MOV.L	[RE, RF],		; Move fraction to RF for compatibility.
U 3507, 0000,1563,7737,1551	;11546				NAF/SUB4	; Get sign again and re-enter normalize.
				;11547	=
				;11548	; RF, SR <= Result.
				;11549	
				;11550	=11********0	; Double.
U 3510, 0027,7777,7450,0000	;11551	NPLA1	[P.MOD14, ^1XXX XXX XXX XXX XXX]
U 3511, 0000,0410,0130,1615	;11552		LSUB.W	[002, R8]		; Compensate Exp for extra bits shift.
				;11553	=
U 1615, 0000,1313,5535,1616	;11554		ASL.Q*	[RA, RD]		; Shift in the extra bits and transfer.
				;11555	
				;11556		ROL.L	[RE, RF],		; Shift high and transfer fraction.
U 1616, 0000,1213,7737,1574	;11557				NAF/MULD9	; Join MULD and re-enter normalize.
				;11558	;MULD9:
				;11559	;	ASL.Q*	[RD, RD]		; RF, RD, SR <= Result.
				;11560	;
				;11561	;	ROL.L	[RF, RF],		; Propagate carry.
				;11562	;			NAF/SUB4	; Get sign.
				;11563	;;SUB4:
				;11564	;;	ASL.L	[RB, RB],		; If positive, FSRC is correct sign.
				;11565	;;			NAF/NRM		; Go normalize.  Take JAN to invert.
				;11566	
				;11567	; RF, RD, SR <= Result.
				;11568	
				;11569	
				;11570	; All fraction (case 3).
				;11571	MOD5:
				;11572		LMSTK	[P.NRM3, RE],		; Join rounding after zeroing
U 1617, 0000,0533,2336,1632	;11573				NAF/ZERO+1	;  AC+1.  Skip.  Check underflow later.
				;11574	
				;11575	; All integer (case 1).
				;11576	MOD4:
				;11577		LMSTK	[MOD9, RE],		; Return to clear fraction after
U 1620, 0000,0537,1076,0716	;11578				NAF/P.FORM+1	;  formatting AC+1.
				;11579	
				;11580	; Force a zero fraction while retaining check for overflow.
				;11581	MOD9:
U 1621, 0000,1043,7675,1622	;11582		CLR.L	[RD, RD]		; Clear for double.
				;11583	
				;11584	MOD9A:					; Enter fraction is zero from NORM.
U 1622, 0000,1043,7573,1623	;11585		CLR.L	[RB, RB]		; Clear AC and sign for store.
				;11586	
				;11587		CLR.L	[RE, RE],		; Clear AC.2 for store.
U 1623, 0000,1043,7736,0712	;11588				NAF/P.MULX8	; Share code at "Store/update FCCs"
				;11589						;  to check for overflow.
				;11590	
				;11591	; Note that if R8, Exp = 377; RF<31:24> is checked for 0 at "Under/overflow"
				;11592	; to catch mantissa overflow.  FORM2 conveniently leaves RF<31:24> equal
				;11593	; to 377 in this case.
				;11594	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  280
; FP11  .MCD [242,1110]      MODf

				;11595	; Subroutine to format and store AC+1.
				;11596	
				;11597	=11********0	; Default for double override.
U 3512, 0037,7777,4700,0000	;11598	NPLA1	[P.FORM+1, ^X]
				;11599		MOV.W	[RF.H, RB],		; RB<16:0> <= Sign @ AC.3 @ AC.2<15>.
U 3513, 0000,1561,6773,1077	;11600				NAF/FORM2	; Two word block.
				;11601	=
				;11602	=0
				;11603		ASR.L*	[RF, RF],		; Shift high and save C.
U 1076, 0000,1343,5777,1624	;11604				NAF/FORM2A	; Skip single.
				;11605	FORM2:
				;11606		ASR.L	[RF, RF],		; RF.L <= Result.2.
U 1077, 0000,1343,7777,1627	;11607				NAF/FORM3	; Skip.
				;11608	=
				;11609	FORM2A:
U 1624, 0000,1243,7675,1625	;11610		ROR.L	[RD, RD]		; Shift low with C.
				;11611	
U 1625, 0000,0251,6235,1626	;11612		OUTR.W	[AC76+1.0, RD]		; Save for double.
				;11613	
U 1626, 0000,0251,2215,1627	;11614		OUTR.W	[AC76+1.1, RD.H]	; Save for double.
				;11615	FORM3:
U 1627, 0000,0251,6637,1630	;11616		OUTR.W	[AC76+1.2, RF]		; Save Result.2 for both.
				;11617	
U 1630, 0000,1343,7573,1631	;11618		ASR.L	[RB, RB]		; RB<15:0> <= Result.3.
				;11619	
				;11620		OUTR.W	[AC76+1.3, RB],		; End of save.
U 1631, 0000,0251,2633,0777	;11621				NAF/RFS		; Return to caller.
				;11622	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  281
; FP11  .MCD [242,1110]      MODf

				;11623	; Subroutine to zero AC+1.
				;11624	;  Called for:
				;11625	;	Multiply operand is zero and MOD.
				;11626	;	Result is all fraction.
				;11627	;	Overflow with FIV = 0.
				;11628	
				;11629	ZERO+1:
				;11630		CLR.W	[RC, RC],		; Clear scratch for OUTR's.
U 1632, 0000,1041,7634,0701	;11631				NAF/P.MOD20	; Invoke Double override.
				;11632	
				;11633	=11********0	; Default for Double override.
U 3514, 0037,7777,4040,0000	;11634	NPLA1	[P.MOD20, ^X]
				;11635		OUTR.W	[AC76+1.3, RC],		; Clear highest word.
U 3515, 0000,0251,2634,1103	;11636				NAF/ZERO+1A	; Override if double.
				;11637	=
				;11638	=0
				;11639	ZERO+1C:
				;11640		OUTR.W	[AC76+1.1, RC],		; Zero lower words if double.
U 1102, 0000,0251,2234,1633	;11641				NAF/ZERO+1B	; Skip.
				;11642	ZERO+1A:
				;11643		OUTR.W	[AC76+1.2, RC],		; Finish single or double.
U 1103, 0000,0251,6634,0777	;11644				NAF/RFS		; Return to caller.
				;11645	=
				;11646	ZERO+1B:
				;11647		OUTR.W	[AC76+1.0, RC],		; Continue for double.
U 1633, 0000,0251,6234,1103	;11648				NAF/ZERO+1A	; Join common.
				;11649	
;11650	.NOBIN
;11651	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  282
; FP11  .MCD [242,1110]      DIVf

;11652		.TOC	"				DIVf"
;11653	
;11654	;
;11655	; DIVf:
;11656	;	AC	<= AC / FSRC.
;11657	;
;11658	;	Divide two FP operands.
;11659	;
;11660	;	Interrupt on undefined variable may occur.
;11661	;	Interrupt on divide by zero may occur.
;11662	;	Underflow and overflow may occur.
;11663	;
;11664	;	FC	<= 0.
;11665	;	FV	<= 1 if overflow occurs; 0 otherwise.
;11666	;	FZ	<= 1 if AC = 0; 0 otherwise.
;11667	;	FN	<= 1 if AC < 0; 0 otherwise.
;11668	;
;11669	; Notes:
;11670	;	This divide uses the same non-restoring divide as the EIS DIVide.
;11671	;	DIVF uses the DIVS microinstruction, DIVD uses the combination
;11672	;	XLDIVS and XHDIVS.
;11673	;
;11674	;	a = f1 * 2**k1
;11675	;	b = f2 * 2**k2
;11676	;	c = a / b
;11677	;	  = (f1 / f2) * (2**k1 / 2**k2)
;11678	;	  = d * 2**e
;11679	;    where:
;11680	;	d = f1 / f2	and 	e = k1 - k2
;11681	;    since:
;11682	;	1/2 =< f < 1	then	1/2 < d < 2
;11683	;    thus, for the form:
;11684	;	g = f3 * 2**k3,
;11685	;	f3 = d		and	k3 = e		if f1 < f2
;11686	;	f3 = d/2	and	k3 = e + 1	if f1 >= f2 (normalized 1 right)
;11687	;	f1 >= f2 if the first subtract results in no borrow-out.
;11688	;	k3, not e, must be checked for underflow or overflow.
;11689	;    accuracy:
;11690	;     upper bound:
;11691	;	d =< du		and	f3 =< fu
;11692	;      where:
;11693	;	du = (1-lsb) / 1/2
;11694	;	   = 2 - 2*lsb		and
;11695	;	fu = 1-lsb (chopped or rounded)
;11696	;     lower bound:
;11697	;	d >= dl		and	f3 >= fl
;11698	;      where:
;11699	;	dl = 1/2 / (1-lsb) = 1/2 * (1 + lsb + lsb**2 + lsb**3 ...)
;11700	;	   = 1/2 + 1/2 * lsb + 1/2 * lsb**2 + ...	and
;11701	;	fl = 1/2 (chopped)	or	fl = 1/2 + lsb (rounded)
;11702	;     nearest bound: (nearest to, but less than one)
;11703	;	d = dn		and	f3 = fn
;11704	;      where:
;11705	;	dn = (1-2lsb) / (1-lsb)
;11706	;	   = 1 - lsb - lsb**2 - lsb**3 - ...		and
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  283
; FP11  .MCD [242,1110]      DIVf

;11707	;	fn = 1 - 2lsb (chopped)	or	fn = 1 - lsb (rounded)
;11708	;	Thus, rounding cannot cause the exponent to change.
;11709	;    iterations:
;11710	;	i = 26 (floating)	or	i = 58 (double)
;11711	;	Thus, the last bit calculated is the potential rounding bit which
;11712	;	may be discarded during normalization.
;11713	;
;11714	
				;11715	.BIN
				;11716	
				;11717	; After operands have been fetched.
				;11718	; Check interrupts.
				;11719	
				;11720	=11********0	; Breakout DIVf after FSRC addressing.
U 3516, 0017,0377,2600,4400	;11721	NPLA1	[P.FSRC-R1, ^0 XXXX 100 1XX XXX XXX]
				;11722		INPR.W	[AC76.3, RA],		; Retrieve last of AC.
U 3517, 0000,0211,2532,0664	;11723				NAF/P.EXP4	; Do decode of FSRC.3.
				;11724	=
				;11725	; Call Exp extractors on FSRC.3.
				;11726	
				;11727	=11********0	; Default for Exp extractors and overrides.
U 3520, 0037,7777,3200,0000	;11728	NPLA1	[P.EXP4, ^X]
				;11729		LLCM.W	[377, R8],		; Overridden by Exp extractors.
U 3521, 0000,0471,7770,1025	;11730				NAF/DIVF1	; High address of block.
				;11731	=
				;11732	; Block for UV, Exp = 0, and normal.
				;11733	=000
				;11734		LMSTK	[DIVF0, R9],		; FSRC is UV.  Is it an AC or disabled ?
U 1020, 0000,0534,1231,1730	;11735				NAF/FIUV-CK	; Go check it and return if true.
				;11736	=100
				;11737	DIVF0:					; FSRC is 0.  Divide by zero trap.
				;11738		LLD.W	[004, R8.H],		; Load FEC register for FP-TRAP.
U 1024, 0000,0560,0210,1747	;11739				NAF/FIUV1	; See "Trap Handler".
				;11740	=101
				;11741	DIVF1:					; Exp was not zero.
				;11742		LADD.W	[201, R8],		; R8 <= -Exp(FSRC) + 200.
U 1025, 0000,0441,0070,0377	;11743				NAF/MUL8	; Join with MUL/MOD.
				;11744	=
				;11745	;MUL8:					; Exp is now, or was unbiased above.
				;11746	;	OUTS	[LD_PIR, RA],		; Load AC.3 for Exp/mantissa extractors.
				;11747	;			NAF/P.MAN0	; First extract mantissa from FSRC.3.
				;11748	;=
				;11749	;; Call mantissa extractors on FSRC.3.
				;11750	;
				;11751	;=11********0	; Default for mantissa extraction and hidden bit insertion.
				;11752	;NPLA1	[P.MAN0, ^X]
				;11753	;	LLD.W	[377, RF.H],		; Overridden by mantissa extractors.
				;11754	;			NAF/P.MAN1	; Insert mantissa to high word.
				;11755	;=
				;11756	;; Call mantissa extractors on AC.3.
				;11757	;
				;11758	;=11********0	; Default for mantissa extraction and hidden bit insertion.
				;11759	;NPLA1	[P.MAN1, ^X]
				;11760	;	LLD.W	[377, RE.H]		; Overridden by mantissa extractors.
				;11761	;=					; Insert mantissa to high word.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  284
; FP11  .MCD [242,1110]      DIVf

				;11762	;
				;11763	;	OUTS	[LD_FPS, R9],		; PIR <= FPS, Opcode.
				;11764	;			NAF/P.EXP3	; First extract and check AC exponent.
				;11765	;
				;11766	;; Call Exp extractors on AC.3 and compute result's Exp.
				;11767	;
				;11768	;=11********0	; Default for Exp extraction and check of Exp = 0.
				;11769	;NPLA1	[P.EXP3, ^X]
				;11770	;	LADD.W	[377, R8],		; Overridden by Exp extractors.
				;11771	;			NAF/MUL12	; High address of block.
				;11772	;=
				;11773	;=000					; Ignore UV and bias overrides.
				;11774	;MUL10:
				;11775	;	INPR.W	[FPS, RA],		; AC is 0.  Result is 0.
				;11776	;			NAF/EXACT-0B	; See "Exact Zero".
				;11777	;=001
				;11778	;MUL12:
				;11779	;	XOR.W	[RA, RB],		; RB<15> <= sign of result.
				;11780	;			NAF/P.OPCD2	; Separate instructions.
				;11781	;=					; Invoke double override.
				;11782	=11********0	; Breakout DIV.
U 3522, 0037,0377,4540,4400	;11783	NPLA1	[P.OPCD2, ^XXXX 100 1XX XXX XXX]
				;11784		LCNTR.W	[032, RB.H],		; CNTR <= 26..  RB<31> <= 0 for ASL.
U 3523, 0000,0520,1513,1105	;11785				NAF/DIVF2	; Separate loops.
				;11786	=
				;11787	=0
				;11788		ASL.L	[RB, RB],		; Shift sign for later (skip SUB4).
U 1104, 0000,1233,7573,1111	;11789				NAF/DIVF3	; Skip.  AC <= 0 for first iteration.
				;11790	DIVF2:
				;11791		OUTR.L	[SR, RF.H],		; SR <= 0; AC <= 0 for first iteration.
U 1105, 0000,0253,0317,1107	;11792				NAF/DIVF7	; Start loop.  Skip.
				;11793	=
				;11794	; Single precision.
				;11795	
				;11796	=0
				;11797	; After divide loop.
				;11798		INPR.L	[SR, RF],		; Retrieve the result.
U 1106, 0000,0213,0337,1551	;11799				NAF/SUB4	; Get sign ready.
				;11800	DIVF7:
				;11801		DIVS.L	[RF, RE],		; Compute 26 significant bits.
				;11802			DECR CNTR,		; One rounding, one potential rounding.
U 1107, 0000,1053,3776,1107	;11803				NAF/DIVF7	; Loop.  Fall thru when done.
				;11804	=
				;11805	;SUB4:
				;11806	;	ASL.L	[RB, RB],		; If positive, FSRC is correct sign.
				;11807	;			NAF/NRM		; Go normalize.  Take JAN to invert.
				;11808	
				;11809	; RF <= Result.
				;11810	; Result is normalized 50% of the time.
				;11811	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  285
; FP11  .MCD [242,1110]      DIVf

				;11812	; Double precision.
				;11813	
				;11814	; After first loop.
				;11815	=0
				;11816		INPR.L	[SR, RA],		; Retrieve first 26. bits of result.
U 1110, 0000,0213,0332,1634	;11817				NAF/DIVF4	; Skip.
				;11818	DIVF3:
				;11819		XLDIVS	[RD, RC],		; Compute 26. significant bits.
U 1111, 0000,1113,7674,0640	;11820				NAF/P.INT0	; Check interrupts.
				;11821	=
				;11822	=11********0	; First loop and interrupt check.
U 3524, 0007,0377,2010,4400	;11823	NPLA1	[P.INT0, ^0 1XXX 100 1XX XXX XXX]
				;11824		XHDIVS*	[RF, RE],		; SR <= result.  C <= AC.
				;11825			DECR CNTR,
U 3525, 0000,1153,1776,1111	;11826				NAF/DIVF3	; Fall thru when done.
				;11827	=
				;11828	DIVF4:
				;11829		LCNTR.W	[040, R8.H],		; Load CNTR for 32. more bits.  AC <= C.
U 1634, 0000,0520,2010,1113	;11830				NAF/DIVF5	; Start new loop.
				;11831	
				;11832	=0
				;11833	; After second loop.
				;11834		MOV.L	[RA, RF],		; Move to RF for compatibility.
U 1112, 0000,1563,7537,1635	;11835				NAF/DIVF6	; Skip.
				;11836	DIVF5:
				;11837		XLDIVS	[RD, RC],		; Compute 32. more significant bits.
U 1113, 0000,1113,7674,0641	;11838				NAF/P.INT1	; Check interrupts.
				;11839	=
				;11840	=11********0	; Second loop and interrupt check.
U 3526, 0007,0377,2050,4400	;11841	NPLA1	[P.INT1, ^0 1XXX 100 1XX XXX XXX]
				;11842		XHDIVS	[RF, RE],
				;11843			DECR CNTR,
U 3527, 0000,1153,3776,1113	;11844				NAF/DIVF5	; Fall thru when done.
				;11845	=
				;11846	DIVF6:
				;11847		INPR.L	[SR, RD],		; Retrieve remaining 32. bits.
U 1635, 0000,0213,0335,1636	;11848				NAF/NRM		; Go normalize.
				;11849	
				;11850	; RF @ RD <= Result.
				;11851	; Result is normalized 50% of the time.
				;11852	
;11853	.NOBIN
;11854	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  286
; FP11  .MCD [242,1110]      Arithmetic Routines

;11855		.TOC	"				Arithmetic Routines"
;11856	
;11857	;
;11858	; This code finishes all the arithmetic instructions.
;11859	;
;11860	
;11861		.TOC	"					Normalization"
;11862	
;11863	; Entry conditions:
;11864	;	Single precision:
;11865	;		RF @ SR = Pre-normalized result.
;11866	;	Double precision:
;11867	;		RF @ RD @ SR = Pre-normalized result.
;11868	;	RB<16> = Sign of result.
;11869	;	R8.L = Exponent.
;11870	;	The binary point is shifted one left.
;11871	;
;11872	
				;11873	.BIN
				;11874	
				;11875	NRM:
U 1636, 0000,1561,6776,1637	;11876		MOV.W	[RF.H, RE]		; Retrieve Result.3 for OUTS load.
				;11877	
				;11878		OUTS	[LD_FPS, RE],		; Decode alignment of hidden bit.
U 1637, 0000,0271,7576,0605	;11879				NAF/P.MODF0	; Invoke check for MOD.
				;11880	
				;11881	=11********0	; Default for NAF override.
U 3530, 0037,7777,0240,0000	;11882	NPLA1	[P.MODF0, ^X]
				;11883		INPR.W	[FPS, RA],		; Retrieve FPS while waiting.
U 3531, 0000,0210,2732,0645	;11884				NAF/P.NRM1	; Decode alignment.  P.NRM2 for MODf.
				;11885	=
				;11886	; P.MODF0 + P.MODF1
				;11887	=11********0	; Override for MODf breakout (1st time through).
U 3532, 0077,0377,0200,1400	;11888	PLA1	[^0 000 10X, ^XXXX 001 1XX XXX XXX]	; MOD instruction.
				;11889		NOP.W	[RF, RF],		; PIR<11:8> = 0001 or 0000
				;11890						;  on second time through.
U 3533, 0000,1771,7777,1776	;11891				NAF/1776	; Override to MODf.  See P.NRM2.
				;11892	=
				;11893	
				;11894	; See "Rounding" if result already normalized.
				;11895	
				;11896	;; Result is already normalized.
				;11897	;
				;11898	;=11********0	; Default for double/truncate overrides.
				;11899	;NPLA1	[P.NRM1, ^0 XXXX XX0 1XX XXX XXX]
				;11900	;	SWAB.B	[R8, RF.H],		; Insert exponent.
				;11901	;			NAF/MULX5	; Round or truncate.
				;11902	;=
				;11903	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  287
; FP11  .MCD [242,1110]      Normalization

				;11904	; Result >= 1 (from ADD or DIVf).
				;11905	
				;11906	=11********0	; Default for double/truncate overrides.
U 3534, 0017,6777,2240,1000	;11907	NPLA1	[P.NRM1, ^0 XXXX XX1 XXX XXX XXX]
				;11908		INC.W	[R8, R8],		; Correct exponent.
U 3535, 0000,1361,7430,0325	;11909				NAF/NRM0	; Two word block.
				;11910	=
				;11911	=00					; Ignore truncate override.
				;11912		LSR.L*	[RF, RF],		; High order; save carry.
U 0324, 0000,1203,5777,1640	;11913				NAF/NRM0A	; Skip.
				;11914	NRM0:
				;11915		LSR.L	[RF, RF],		; Hidden bit is now aligned.
U 0325, 0000,1203,7777,0646	;11916				NAF/P.NRM3	; Start inserting Exp/rounding.
				;11917	=
				;11918	NRM0A:
				;11919		ROR.L	[RD, RD],		; Low order; propagate carry.
U 1640, 0000,1243,7675,0646	;11920				NAF/P.NRM3	; Start inserting Exp/rounding.
				;11921	
				;11922	; 1/4 =< Result < 1/2 (From MULf or SUB).
				;11923	
				;11924	=11********0	; Default for double/truncate overrides.
U 3536, 0017,6177,2240,0200	;11925	NPLA1	[P.NRM1, ^0 XXXX XX0 01X XXX XXX]
				;11926		DEC.W	[R8, R8],		; Correct exponent.
U 3537, 0000,1451,7430,0345	;11927				NAF/NRM1	; Two word block.
				;11928	=
				;11929	=00					; Ignore truncate override.
				;11930		ASL.Q*	[RD, RD],		; Low order; save C.
U 0344, 0000,1313,5675,1641	;11931				NAF/NRM1A	; Skip.
				;11932	NRM1:
				;11933		ASL.Q	[RF, RF],		; Hidden bit is now aligned.
U 0345, 0000,1313,7777,0646	;11934				NAF/P.NRM3	; Start inserting Exp/rounding.
				;11935	=
				;11936	NRM1A:
				;11937		ROL.L	[RF, RF],		; High order; propagate carry.
U 1641, 0000,1213,7777,0646	;11938				NAF/P.NRM3	; Start inserting Exp/rounding.
				;11939	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  288
; FP11  .MCD [242,1110]      Normalization

				;11940	; Normalize result for SUBf Exp differences of 0 or 1.
				;11941	; Result < 1/4 (From SUBf, or MODf fraction part).
				;11942	
				;11943	=11********0	; Default for double/truncate overrides.
U 3540, 0017,6177,2240,0000	;11944	NPLA1	[P.NRM1, ^0 XXXX XX0 00X XXX XXX]
				;11945		LCNTR.W	[004, RB],		; Check 4 words for MODf.
U 3541, 0000,0520,0233,1015	;11946				NAF/NORM-F	; Two word block.
				;11947	=
				;11948	=00					; Ignore truncate override.
				;11949	NORM-D:
U 1014, 0000,0253,0335,1015	;11950		OUTR.L	[SR, RD]		; Load SR for double.
				;11951	
				;11952	NORM-F:					; Enter LDCif.
				;11953		OUTS	[LD_PIR, RE],		; Reload without FPS flops.
U 1015, 0000,0271,6776,0656	;11954				NAF/P.INT4	; Check interrupts while FD valid.
				;11955	=
				;11956	=11********0	; Catch interrupts.
U 3542, 0017,7777,2700,0000	;11957	NPLA1	[P.INT4, ^0 XXXX XXX XXX XXX XXX]
				;11958		OUTS	[LD_FPS, RF],		; Load FPS flops for later use.
U 3543, 0000,0271,7577,0773	;11959				NAF/P.NORM	; Invoke normalization PLAs.
				;11960	=
				;11961	=11********0	; Default for normalization overrides.
U 3544, 0037,7777,7540,0000	;11962	NPLA1	[P.NORM, ^X]
				;11963		NOP.W	[RF, RE],		; --> LCNTR.W	[xxx, RE].
				;11964			DECR CNTR,		; Zero NAF<0> if last check.
U 3545, 0000,1771,3776,1037	;11965				NAF/NORM-H	; High address of block.
				;11966	=
				;11967	; See uInstruction/NAF Overrides"
				;11968	
				;11969	=000	; Block for normalization overrides.
				;11970	=001
				;11971	NORM-K:		; No shift (or done).
				;11972		INPR.L	[SR, RD],		; Get low order for double.
U 1031, 0000,0213,0335,0646	;11973				NAF/P.NRM3	; Join Exp insertion and rounding.
				;11974	=010
				;11975		SUB.W	[RE, R8],		; Compensate Exp for shift.
U 1032, 0000,1411,7730,1031	;11976				NAF/NORM-K
				;11977	=011
				;11978	NORM-L:		; Left shift.
				;11979		ASL.Q	[RF, RF],		; Normalize for Exp insertion.
				;11980			DECR CNTR,
U 1033, 0000,1313,3777,1033	;11981				NAF/NORM-L	; Loop.
				;11982	=100
				;11983		ADD.W	[RE, R8],		; Compensate Exp for shift.
U 1034, 0000,1441,7730,1031	;11984				NAF/NORM-K
				;11985	=101
				;11986	NORM-R:		; Right shift.
				;11987		LSR.Q	[RF, RF],		; Normalize for Exp insertion.
				;11988			DECR CNTR,
U 1035, 0000,1303,3777,1035	;11989				NAF/NORM-R	; Loop.
				;11990	
				;11991	=110		; Entire result is zero.
				;11992		LLD.W	[001, R8],		; Force no under/overflow at
U 1036, 0000,0560,0070,1622	;11993				NAF/MOD9A	;  "Under/overflow".
				;11994	=111
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  289
; FP11  .MCD [242,1110]      Normalization

				;11995	NORM-H:		; Current word is all zero.
U 1037, 0000,0410,1030,1642	;11996		LSUB.W	[020, R8]		; Compensate for word shift.
				;11997	=
U 1642, 0000,1561,7757,1643	;11998		MOV.W	[RF, RF.H]		; Shift by 16.
				;11999	
U 1643, 0000,0213,0335,1644	;12000		INPR.L	[SR, RD]		; Retrieve SR for 16-bit shift.
				;12001	
U 1644, 0000,1561,6677,1645	;12002		MOV.W	[RD.H, RF]		; Shift double precision by 16.
				;12003	
U 1645, 0000,1563,7655,1646	;12004		MOV.L	[RD, RD.H]		; Shift continued; insert 0's.
				;12005	
				;12006		MOV.W	[RF.H, RE],		; Get new OUTS data for next reload.
U 1646, 0000,1561,6776,1014	;12007				NAF/NORM-D	; Start at top of loop.
				;12008	
				;12009	; Zero result continued.
				;12010						; RD is zero from above.
				;12011	;MOD9A:					; Enter fraction is zero from NORM.
				;12012	;	CLR.L	[RB, RB]		; Clear AC and sign for store.
				;12013	;
				;12014	;	CLR.L	[RE, RE],		; Clear AC.2 for store.
				;12015	;			NAF/P.MULX8	; Share code at "Store/update FCCs"
				;12016	;					;  to check for overflow.
				;12017	
				;12018	; The reason for continuing at P.MULX8 rather than ADD8D or EXACT-0 is to
				;12019	; insure that the PS is restored for double, and that AC+1 is not cleared
				;12020	; for MODf.
				;12021	
;12022	.NOBIN
;12023	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  290
; FP11  .MCD [242,1110]      Rounding

;12024		.TOC	"					Rounding"
;12025	
;12026	; Exponent insertion and rounding.
;12027	;
;12028	; Entry:
;12029	;	PIR contains FPS flops.
;12030	;	RF @ RD contains result (with rounding bit).
;12031	;	RB<16> contains sign.
;12032	; Exit:
;12033	;	PIR contains FPS.
;12034	;	RE @ RD	<= Result (without sign).
;12035	;	RB<16:0> <= Sign @ AC.0 @ AC.1<15>.
;12036	;
;12037	
				;12038	.BIN
				;12039	
				;12040	; Result is already normalized.
				;12041	
				;12042	=11********0	; Default for double/truncate overrides.
U 3546, 0017,6377,2240,0400	;12043	NPLA1	[P.NRM1, ^0 XXXX XX0 1XX XXX XXX]
				;12044		SWAB.B	[R8, RF.H],		; Insert exponent.
U 3547, 0000,1467,7417,1043	;12045				NAF/MULX5	; Round or truncate.
				;12046	=
				;12047	=11********0	; Result had to be normalized.
U 3550, 0017,7777,2300,0000	;12048	NPLA1	[P.NRM3, ^0 XXXX XXX XXX XXX XXX]
				;12049		SWAB.B	[R8, RF.H],		; Insert exponent.
U 3551, 0000,1467,7417,1043	;12050				NAF/MULX5	; Round or truncate.
				;12051	=
				;12052	=11********0	; Entry for ADD with exponents equal.
U 3552, 0017,7777,2340,0000	;12053	NPLA1	[P.NRM0, ^0 XXXX XXX XXX XXX XXX]
				;12054		INPR.W	[FPS, RA],		; Load FPS to skip normalization.
U 3553, 0000,0210,2732,1043	;12055				NAF/MULX5	; Four word block.
				;12056	=
				;12057	; P.NRMx
				;12058	=11********0	; Override if double.
U 3554, 0147,7777,2210,0000	;12059	PLA1	[^0 100 1XX, ^0 1XXX XXX XXX XXX XXX]
				;12060		NOP.B	[RE, RF],		; Can't have all ones.
U 3555, 0000,1777,7737,1776	;12061				NAF/1776	; Override NAF<0>.
				;12062	=
				;12063	; P.NRMx
				;12064	=11********0	; Override for truncate.
U 3556, 0155,7777,2202,0000	;12065	PLA1	[^0 100 1XX, ^0 XX1X XXX XXX XXX XXX]
				;12066		NOP.B	[RE, RF],		; Can't have all ones.
U 3557, 0000,1777,7737,1775	;12067				NAF/1775	; Override NAF<1>.
				;12068	=
				;12069	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  291
; FP11  .MCD [242,1110]      Rounding

				;12070	=00
				;12071	; Truncate/continue for double.
				;12072	MULX6:
				;12073		ASR.L*	[RF, RE],		; RE.L <= AC.2.
U 1040, 0000,1343,5776,1651	;12074				NAF/MULX6A	; Skip.
				;12075	=01
				;12076	; Truncate/continue for single.
				;12077	MULX7:
				;12078		ASR.L	[RF, RE],		; RE.L <= AC.2.
U 1041, 0000,1343,7776,1652	;12079				NAF/MULX7A	; Skip.
				;12080	=10
				;12081	; Rounding case for double.
				;12082		LLD.L	[001, RC],		; Form rounding up bit.
U 1042, 0000,0562,0074,1647	;12083				NAF/MULX5A	; Continue double.
				;12084	=11
				;12085	; Rounding case for single.
				;12086	MULX5:
				;12087		INC.L	[RF, RF],		; Round up for single.
U 1043, 0000,1363,7777,1041	;12088				NAF/MULX7	; Continue back at Truncate case.
				;12089	=
				;12090	MULX5A:
U 1647, 0000,1443,5635,1650	;12091		ADD.L*	[RC, RD]		; Round up for double continued.
				;12092	
				;12093		ADC.L	[RF, RF],		; And propagate the carry again.
U 1650, 0000,1643,7777,1040	;12094				NAF/MULX6	; Continue back at Truncate case.
				;12095	MULX6A:
U 1651, 0000,1243,7675,1652	;12096		ROR.L	[RD, RD]		; RD <= AC.1 @ AC.0.
				;12097	
				;12098	MULX7A:
				;12099		MOV.W	[RF.H, RB],		; Save result for sign insertion.
U 1652, 0000,1561,6773,0712	;12100				NAF/P.MULX8	; Start store.
				;12101	
;12102	.NOBIN
;12103	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  292
; FP11  .MCD [242,1110]      Store/update FCCs

;12104		.TOC	"					Store/update FCCs"
;12105	
;12106	; Store result; insert sign to AC.3 and update FCCs.
;12107	
				;12108	.BIN
				;12109	
				;12110	=11********0	; Default for double override.
U 3560, 0037,7777,4500,0000	;12111	NPLA1	[P.MULX8, ^X]
				;12112		OUTR.W	[AC76.2, RE],		; Store AC.2.
U 3561, 0000,0251,6536,1115	;12113				NAF/LDEXP1	; Two word block.
				;12114	=
				;12115	=0
				;12116		OUTR.W	[AC76.1, RD.H],		; Save low order mantissa.
U 1114, 0000,0251,2115,1653	;12117				NAF/LDEXP1A	; Skip.
				;12118	LDEXP1:
				;12119		ASR.L	[RB, RB],		; RB.L @ RE.L @ RD <= Final result.
U 1115, 0000,1343,7573,1655	;12120				NAF/LDEXP2	; Skip.
				;12121	=
				;12122	LDEXP1A:
U 1653, 0000,0251,6135,1654	;12123		OUTR.W	[AC76.0, RD]		; Save low order mantissa.
				;12124	
				;12125		INPR.W	[CPAR, PS],		; Restore PS for Double.
U 1654, 0000,0210,6340,1115	;12126				NAF/LDEXP1	; Start inserting sign.
				;12127	LDEXP2:
U 1655, 0000,0271,6773,1656	;12128		OUTS	[LD_PIR, RB]		; Load AC.3 for FCC update.
				;12129	
				;12130		OUTS	[LD_PIR, R8],		; Load Exp to check boundaries.
U 1656, 0000,0271,6770,0721	;12131				NAF/P.NZ1	; Invoke FN and FZ overrides.
				;12132	
				;12133	=11********0	; Default for FN and FZ overrides.
U 3562, 0037,7777,5040,0000	;12134	NPLA1	[P.NZ1, ^X]
				;12135		LBIC.W	[017, RA],		; Pre-clear for update.
U 3563, 0000,0550,0772,1047	;12136				NAF/FNZ-OK1	; High address of block.
				;12137	=
				;12138	=00
				;12139	FN.FZ1:					; Get here on both overrides.
				;12140		LBIS.W	[014, RA],		; Set FN and FZ.
U 1044, 0000,0570,0632,1047	;12141				NAF/FNZ-OK1	; Now flags are OK.
				;12142	FN.-FZ1:
				;12143		LBIS.W	[010, RA],		; Set FN.
U 1045, 0000,0570,0432,1047	;12144				NAF/FNZ-OK1	; Now flags are OK.
				;12145	-FN.FZ1:
				;12146		LBIS.W	[004, RA],		; Set FZ.
U 1046, 0000,0570,0232,1047	;12147				NAF/FNZ-OK1	; Now flags are OK.
				;12148	FNZ-OK1:
				;12149		OUTR.W	[AC76.3, RB],		; Store AC.3.
U 1047, 0000,0251,2533,0725	;12150				NAF/P.NZ5	; Invoke under/overflow Exp overrides.
				;12151	=
				;12152	
;12153	.NOBIN
;12154	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  293
; FP11  .MCD [242,1110]      Under/overflow

;12155		.TOC	"					Under/overflow"
;12156	
;12157	
;12158	; Because rounding can cause the exponent to increment (except for DIVf), the
;12159	; cases of (pre-rounded) Exp = 0 or 377 are double checked.  These cases affect
;12160	; the determination of under/overflow.
;12161	
;12162	
				;12163	.BIN
				;12164	
				;12165	=11********0	; Default.  (Catch overflow).
U 3564, 0037,7777,5240,0000	;12166	NPLA1	[P.NZ5, ^X]
				;12167		OUTR.W	[FPS, RA],		; Store the FCCs.
U 3565, 0000,0250,2732,0317	;12168				NAF/MUL20	; High address of block.
				;12169	=
				;12170	=11********0	; Override if 0 =< Exp =< 377.
U 3566, 0020,0377,5240,0000	;12171	NPLA1	[P.NZ5, ^0000 000 0XX XXX XXX]
				;12172		NOP.L	[RF, RF],		; Word may override long.
U 3567, 0000,1773,7777,1776	;12173				NAF/1776	; Override for in range (except 0 case).
				;12174	=
				;12175	=11********0	; Override for Exp = 0 (special case).
U 3570, 0020,0000,5240,0000	;12176	NPLA1	[P.NZ5, ^0000 000 000 000 000]
				;12177		NOP.L	[RF, RF],		; Word may override long.
U 3571, 0000,1773,7777,1770	;12178				NAF/1770	; Override to special check.
				;12179	=
				;12180	=11********0	; Override for Exp = 377 (special case).
U 3572, 0020,0000,5240,0377	;12181	NPLA1	[P.NZ5, ^0000 000 011 111 111]
				;12182		NOP.L	[RF, RF],		; Word may override long.
U 3573, 0000,1773,7777,1772	;12183				NAF/1772	; Override to special check.
				;12184	=
				;12185	;=11********0	; Override for result is negative.
				;12186	;PLA1	[^1 010 XXX, ^1XXX XXX XXX XXX XXX]
				;12187	;	NOP.W	[RF, RF],		; Can be overridden.
				;12188	;			NAF/1775	; Override NAF<1>.
				;12189	;=
				;12190	;=11********0	; Override for exponent is zero.
				;12191	;PLA1	[^1 010 XXX, ^X000 000 00X XXX XXX]
				;12192	;	NOP.W	[RF, RF],		; Can be overridden.
				;12193	;			NAF/1776	; Override NAF<0>.
				;12194	;=
				;12195	
				;12196	; These two instructions are for addressing.
				;12197	; Ignore them here (See P.FP-END).
				;12198	
				;12199	=1*0*0000				; Abort to ROM[200] on MUL20D
				;12200						;  for addressing (see P.FP-END).
				;12201	TST-DF:					; Must align with MUL20D.
				;12202		JAZ	[NOP-PF],		; If R8.H is 0 then no exception.
U 0300, 0000,0116,3777,1667	;12203				NAF/UN-OV1	; Proceed as if exception.
				;12204	=0
				;12205	TST-FI:					; Must align with MUL20D.
				;12206		ASR.W	[RA, RF],		; RF<7> <= FIC.
U 0302, 0000,1341,7537,1477	;12207				NAF/NOP-PF	; If C zero than no exception.
				;12208	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  294
; FP11  .MCD [242,1110]      Under/overflow

				;12209	; Block for biased exponent overrides.
				;12210	
				;12211	=000	; Special 0 cases.
				;12212		SWAB.W	[RF.H, RF],		; AZ <= (Exp = 0).
U 0310, 0000,1461,6777,1657	;12213				NAF/MUL20E	; Skip.
				;12214	
				;12215	=010	; Special 377 case.
				;12216		SWAB.W	[RF.H, RF],		; AZ <= (Exp = 0).
U 0312, 0000,1461,6777,1660	;12217				NAF/MUL20F	; Skip.
				;12218	
				;12219	=100	; LDEXP overflow case.		; SRC was positive but looks negative.
				;12220		LLD.W	[010, R8.H],		; Assume enabled; load exception code.
U 0314, 0000,0560,0410,1663	;12221				NAF/MUL20A	; Skip.
				;12222	
				;12223	=101	; Underflow case.
				;12224	MUL20C:
				;12225		LLD.W	[012, R8.H],		; Assume enabled; load exception code.
U 0315, 0000,0560,0510,1661	;12226				NAF/MUL20B	; Skip.
				;12227	
				;12228	=110	; In range case.
				;12229	MUL20D:
				;12230		NOP.W	[RF, PS],		; Allow writing of IR.
				;12231			PREFETCH,		; Request another word.
U 0316, 0000,1770,7740,0477	;12232				NAF/ID1		; Invoke simultaneous decode.
				;12233	
				;12234	=111	; Overflow case.
				;12235	MUL20:
				;12236		LLD.W	[010, R8.H],		; Assume enabled; load exception code.
U 0317, 0000,0560,0410,1663	;12237				NAF/MUL20A	; Skip.
				;12238	=
				;12239	; End block.
				;12240	
				;12241	; Exp was zero.  Is it still 0 ?
				;12242	MUL20E:
				;12243		JAZ	[MUL20C],		; If 0 then underflow.
U 1657, 0000,0111,4677,1235	;12244				NAF/RESET-NOP	; Otherwise; in range.
				;12245	; Exp was 377.  Is it now 0 ?
				;12246	MUL20F:
				;12247		JAZ	[MUL20],		; If 0 then overflow.
U 1660, 0000,0111,4777,1235	;12248				NAF/RESET-NOP	; Otherwise; in range.
				;12249	
				;12250	;RESET-NOP:				; For MTPS and SPL, wait for Control chip.
				;12251	;	LMSTK	[NOP-PF, RF],		; Set up return address from RESET-SUB.
				;12252	;			NAF/NOP-PF	; For not Kernel Mode, treat as NOP.
				;12253	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  295
; FP11  .MCD [242,1110]      Under/overflow

				;12254	; Underflow continued.
				;12255	MUL20B:
U 1661, 0000,1461,7537,1662	;12256		SWAB.W	[RA, RF]		; Get FIU to literal land.
				;12257	
				;12258		LBIT.B	[004, RF],		; Test FIU for zero.
U 1662, 0000,0506,0237,1666	;12259				NAF/UN-OV	; Skip.
				;12260	
				;12261	; Overflow continued.
				;12262	MUL20A:
U 1663, 0000,0570,0132,1664	;12263		LBIS.W	[002, RA]		; Set FV.
				;12264	
U 1664, 0000,1461,7537,1665	;12265		SWAB.W	[RA, RF]		; Get FIV to literal land.
				;12266	
U 1665, 0000,0506,0137,1666	;12267		LBIT.B	[002, RF]		; Test FIV for zero.
				;12268	
				;12269	UN-OV:
U 1666, 0000,0117,3537,1667	;12270		JAZ	[UN-OV0]		; If zero, don't trap.
				;12271	
				;12272	UN-OV1:
				;12273		MOV.W	[RDST, RC.H],		; Save RDST before "Register Restore".
U 1667, 0000,1561,6314,1751	;12274				NAF/UN-OV2	; See "Trap Handler".
				;12275						; Take JAZ for disabled.
				;12276	; If interrupt disabled.
				;12277	UN-OV0:					; Get here if interrupts disabled.
				;12278		LBIC.W	[014, RA],		; Clear FN and FZ but not FV.
U 1672, 0000,0550,0632,0270	;12279				NAF/EXACT-0C	; See "Exact Zero".
				;12280	
;12281	.NOBIN
;12282	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  296
; FP11  .MCD [242,1110]      FDST Instructions

;12283		.TOC	"		FDST Instructions"
;12284	
;12285		.TOC	"			STf"
;12286	
;12287	;
;12288	; STf:
;12289	;	FDST	<= AC.
;12290	;
;12291	;	Store single or double precision number from AC.
;12292	;
;12293	;	FC	<= FC.
;12294	;	FV	<= FV.
;12295	;	FZ	<= FZ.
;12296	;	FN	<= FN.
;12297	;
				;12298	.BIN
				;12299	
				;12300	; FPS flops not yet valid for mode 0.
				;12301	
				;12302	; P.FDST + P.FDST0
				;12303	=11********0	; Breakout STf for warm.
U 3574, 0236,0377,1441,4000	;12304	PLA1	[^0 011 X01, ^XXX1 100 0XX XXX XXX]
				;12305		INPR.W	[AC76.3, RF.H],		; Load AC into scratch.
U 3575, 0000,0211,2517,0601	;12306				NAF/P.STF	; Must override to ROM[201]
				;12307	=					;  and abort to ROM[200].
				;12308	;; P.FSRC + P.FDST
				;12309	;=11********0	; Override for illegal modes.
				;12310	;PLA1	[^0 011 1X1, ^XXXX XXX XXX 000 11X]
				;12311	;	NOP.W	[RF, RF],		; No change.
				;12312	;			NAF/ILL-MD	; Override all.
				;12313	;=
				;12314	;0201:
				;12315	;ILL-MD:
				;12316	;	LLD.W	[002, R8.H],		; Load exception code.
				;12317	;			NAF/FIUV1	; See "Trap Handler".
				;12318	
				;12319	=11********0	; Breakout STF.
U 3576, 0027,0377,0040,4000	;12320	NPLA1	[P.STF, ^0XXX 100 0XX XXX XXX]
				;12321		INPR.W	[AC76.2, RF],		; Load AC into scratch.
U 3577, 0000,0211,6537,0616	;12322				NAF/P.FDST-E	; Enter FDST addressing.
				;12323	=
				;12324	=11********0	; Breakout STD.
U 3600, 0027,0377,0050,4000	;12325	NPLA1	[P.STF, ^1XXX 100 0XX XXX XXX]
U 3601, 0000,0211,6537,1673	;12326		INPR.W	[AC76.2, RF]		; Load AC into scratch.
				;12327	=
U 1673, 0000,0211,2115,1675	;12328		INPR.W	[AC76.1, RD.H]		; Get low bits.
				;12329	
				;12330		INPR.W	[AC76.0, RD],		; Get the rest.
U 1675, 0000,0211,6135,0616	;12331				NAF/P.FDST-E	; Write AC to FDST.
				;12332	
;12333	.NOBIN
;12334	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  297
; FP11  .MCD [242,1110]      STCfd

;12335		.TOC	"			STCfd"
;12336	
;12337	;
;12338	; STCfd:
;12339	;	FDST	<= Converted(AC).
;12340	;
;12341	;	Convert AC between floating/double precision and store.
;12342	;	FD indicates the precision of AC.
;12343	;
;12344	;	Overflow may occur for STCDF and FT = 0 (rounding).
;12345	;
;12346	;	FC	<= 0.
;12347	;	FV	<= 1 if conversion produces overflow; 0 otherwise.
;12348	;	FZ	<= 1 if FDST = 0; 0 otherwise.
;12349	;	FN	<= 1 if FDST < 0; 0 otherwise.
;12350	;
;12351	
				;12352	.BIN
				;12353	
				;12354	; FPS flops not yet valid for mode 0.
				;12355	
				;12356	; P.FDST + P.FDST0
				;12357	=11********0	; Breakout STCFD/DF for warm only.
U 3602, 0236,0377,1441,6000	;12358	PLA1	[^0 011 X01, ^XXX1 110 0XX XXX XXX]
				;12359		INPR.W	[FPS, RA],		; Retrieve FPS.
U 3603, 0000,0210,2732,0207	;12360				NAF/STCF0	; Overridden if illegal op.
				;12361	=
				;12362	;; P.FSRC + P.FDST
				;12363	;=11********0	; Override for illegal modes.
				;12364	;PLA1	[^0 011 1X1, ^XXXX XXX XXX 000 11X]
				;12365	;	NOP.W	[RF, RF],		; No change.
				;12366	;			NAF/ILL-MD	; Override all.
				;12367	;=
				;12368	;0201:
				;12369	;ILL-MD:
				;12370	;	LLD.W	[002, R8.H],		; Load exception code.
				;12371	;			NAF/FIUV1	; See "Trap Handler".
				;12372	
				;12373	=1*0****1				; Must override to ROM[201]
				;12374	STCF0:					;  and abort to ROM[200].
U 0207, 0000,0213,2130,1676	;12375		INPR.L	[AC76.1, R8]		; Get AC.1 and clear R8.H for rounding.
				;12376	=
				;12377	; Get potential rounding bit into R8<31:0>
				;12378	;  and clear R8.H for P.FP-END.
				;12379	
U 1676, 0000,1233,6430,1677	;12380		ASL.L	[R8.H, R8]		; Shift AC76.1<15> to S<16> and mux
				;12381						;  S<31:16> to R8.L clearing R8.H.
U 1677, 0000,0211,2534,1700	;12382		INPR.W	[AC76.3, RC]		; Get AC.3 to low reg for OUTS load.
				;12383	
U 1700, 0000,0271,6774,1701	;12384		OUTS	[LD_PIR, RC]		; Load AC.3 for Exp = 0 check.
				;12385	
				;12386		LBIC.W	[017, RA],		; Clear the FCCs.
U 1701, 0000,0550,0772,0723	;12387				NAF/P.NZ3	; Invoke FZ override if Exp = 0.
				;12388	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  298
; FP11  .MCD [242,1110]      STCfd

				;12389	=11********0	; Default for FN and FZ overrides.
U 3604, 0037,7777,5140,0000	;12390	NPLA1	[P.NZ3, ^X]
				;12391		OUTS	[LD_FPS, R9],		; Load FPS and opcode.
U 3605, 0000,0271,7571,1053	;12392				NAF/STCFD0	; High address of two word block.
				;12393	=
				;12394	; Block for FN and FZ overrides.
				;12395	=00
				;12396		LBIS.W	[004, RA],		; UV from AC.
U 1050, 0000,0570,0232,1714	;12397				NAF/CLR2	; Store Exact zero.
				;12398	
				;12399		LBIS.W	[010, RA],		; Update FN since negative.
U 1051, 0000,0570,0432,1053	;12400				NAF/STCFD0	; Join common.
				;12401	CLR1:
				;12402		LBIS.W	[004, RA],		; Update FZ since Exp = 0.
U 1052, 0000,0570,0232,1714	;12403				NAF/CLR2	; Store Exact zero.
				;12404	STCFD0:
				;12405		INPR.W	[AC76.3, RF.H],		; Load AC.3 into scratch.
U 1053, 0000,0211,2517,0772	;12406				NAF/P.OPCD1	; What mode are we in ?
				;12407	=
				;12408	=11********0	; Default for rounding override.
U 3606, 0037,0377,7500,6000	;12409	NPLA1	[P.OPCD1, ^XXXX 110 0XX XXX XXX]
				;12410		INPR.W	[AC76.2, RF],		; Load AC.2 also.
U 3607, 0000,0211,6537,1117	;12411				NAF/CLR3	; Address of two word block.
				;12412	=
				;12413	=11********0	; Override if FD.-FT (rounding).
U 3610, 0025,0377,7510,6000	;12414	NPLA1	[P.OPCD1, ^1X0X 110 0XX XXX XXX]
				;12415		NOP.W	[RF, RF],		; Override NAF only.
U 3611, 0000,1771,7777,1776	;12416				NAF/1776	; Override NAF<0> for rounding.
				;12417	=
				;12418	=0	; Rounding case only.
				;12419		ADD.L	[R8, RF],		; Round up through Exp and sign.
U 1116, 0000,1443,7437,1702	;12420				NAF/STCFD3	; Skip.
				;12421	CLR3:
				;12422		CLR.L	[RD, RD],		; Clear FDST.1 and FDST.0.
U 1117, 0000,1043,7675,1715	;12423				NAF/CLR4
				;12424	=
				;12425	; Rounding case continued.
				;12426	STCFD3:
U 1702, 0000,0137,4237,1703	;12427		JAC	[STCFD5]		; Did overflow occur with sign = 1 ?
				;12428	
				;12429		JAV	[STCFD6],		; Did overflow occur with sign = 0 ?
U 1703, 0000,0157,4277,1715	;12430				NAF/CLR4
				;12431	
				;12432	; Resume both rounding and non-rounding cases.
				;12433	;CLR4:
				;12434	;	OUTR.W	[FPS, RA],		; Move altered RA<15:0> back to FPS.
				;12435	;			NAF/P.FDST-E	; Write AC to FDST.
				;12436	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  299
; FP11  .MCD [242,1110]      STCfd

				;12437	; Strictly for overflow case.
				;12438	STCFD5:
				;12439		LLSW.B	[200, RF.H],		; Restore sign.  Exp stays zero.
U 1704, 0000,0467,0017,1706	;12440				NAF/STCFD7	; Skip.
				;12441	STCFD6:
U 1705, 0000,0466,0017,1706	;12442		LLSW.B	[000, RF.H]		; Restore sign.  Exp stays zero.
				;12443	
				;12444	STCFD7:
U 1706, 0000,1461,7534,1707	;12445		SWAB.W	[RA, RC]		; Get FIV down do literal land.
				;12446	
U 1707, 0000,0506,0134,1710	;12447		LBIT.B	[002, RC]		; Test FIV.
				;12448	
U 1710, 0000,0117,4577,1711	;12449		JAZ	[STCFD8]		; Take JAZ if disabled.
				;12450	
U 1711, 0000,0570,0332,1712	;12451		LBIS.W	[006, RA]		; Set FV and FZ for overflow.
				;12452	
				;12453		LLD.W	[010, R8.H],		; Load exception code.
				;12454						; Set R8.H for P.FP-END.
U 1712, 0000,0560,0410,1715	;12455				NAF/CLR4	; Re-join common code.
				;12456	STCFD8:
				;12457		LBIC.W	[010, RA],		; Clear FN in case it was set.
U 1713, 0000,0550,0432,1714	;12458				NAF/CLR2	; Now store Exact 0.
				;12459	
;12460	.NOBIN
;12461	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  300
; FP11  .MCD [242,1110]      CLRf

;12462		.TOC	"			CLRf"
;12463	
;12464	;
;12465	; CLRf:
;12466	;	FDST	<= Exact 0.
;12467	;
;12468	;	Set FDST to zero.
;12469	;
;12470	;	FC	<= 0.
;12471	;	FV	<= 0.
;12472	;	FZ	<= 1.
;12473	;	FN	<= 0.
;12474	;
				;12475	.BIN
				;12476	
				;12477	; FPS flops not yet valid for mode 0.
				;12478	
				;12479	; P.FDST + P.FDST0
				;12480	=11********0	; Breakout CLRF/D for both warm and hot FP.
U 3612, 0236,0077,1441,0400	;12481	PLA1	[^0 011 X01, ^XXX1 000 100 XXX XXX]
				;12482		INPR.W	[FPS, RA],		; Retrieve FPS for FCC update.
U 3613, 0000,0210,2732,0217	;12483				NAF/CLRF0	; Overridden if illegal op.
				;12484	=
				;12485	;; P.FSRC + P.FDST
				;12486	;=11********0	; Override for illegal modes.
				;12487	;PLA1	[^0 011 1X1, ^XXXX XXX XXX 000 11X]
				;12488	;	NOP.W	[RF, RF],		; No change.
				;12489	;			NAF/ILL-MD	; Override all.
				;12490	;=
				;12491	;0201:
				;12492	;ILL-MD:
				;12493	;	LLD.W	[002, R8.H],		; Load exception code.
				;12494	;			NAF/FIUV1	; See "Trap Handler".
				;12495	
				;12496	=1*0****1				; Must override to ROM[201]
				;12497	CLRF0:					;  and abort to ROM[200].
				;12498		LBIC.W	[017, RA],		; Clear all FCCs.
U 0217, 0000,0550,0772,1052	;12499				NAF/CLR1
				;12500	=
				;12501	;CLR1:
				;12502	;	LBIS.W	[004, RA]		; Set FZ.
				;12503	;			NAF/CLR2
				;12504	CLR2:
				;12505		CLR.L	[RF, RF],		; Clear scratch registers for write.
U 1714, 0000,1043,7777,1117	;12506				NAF/CLR3
				;12507	;CLR3:
				;12508	;	CLR.L	[RD, RD],		; Clear FDST.1 and FDST.0.
				;12509	;			NAF/CLR4
				;12510	CLR4:
				;12511		OUTR.W	[FPS, RA],		; Move altered RA<15:0> back to FPS.
U 1715, 0000,0250,2732,0616	;12512				NAF/P.FDST-E	; Write AC to FDST.
				;12513	
;12514	.NOBIN
;12515	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  301
; FP11  .MCD [242,1110]      FRMW Instructions

;12516		.TOC	"		FRMW Instructions"
;12517	
;12518		.TOC	"			ABSf, NEGf"
;12519	
;12520	;
;12521	; ABSf:
;12522	;	FDST	<= ABS(FSRC).
;12523	;
;12524	;	Set FDST to it's absolute value.
;12525	;
;12526	;	Interrupt on undefined variable may occur.
;12527	;
;12528	;	FC	<= 0.
;12529	;	FV	<= 0.
;12530	;	FZ	<= 1 if FDST = 0; 0 otherwise.
;12531	;	FN	<= 0.
;12532	;
;12533	; NEGf:
;12534	;	FDST	<= -FDST.
;12535	;
;12536	;	Negate FDST.
;12537	;
;12538	;	Interrupt on undefined variable may occur.
;12539	;
;12540	;	FC	<= 0.
;12541	;	FV	<= 0.
;12542	;	FZ	<= 1 if FDST = 0; 0 otherwise.
;12543	;	FN	<= 1 if FDST < 0; 0 otherwise.
;12544	;
;12545	
				;12546	.BIN
				;12547	
				;12548	=11********0	; ABSf or NEGf.
U 3614, 0036,0177,4601,0600	;12549	NPLA1	[P.FSRC-R, ^XXX1 000 11X XXX XXX]
U 3615, 0000,0271,6773,0322	;12550		OUTS	[LD_PIR, RB]		; Load FSRC.3 for UV check.
				;12551	=
				;12552	=1*0****0				; Abort to ROM[200].
				;12553						; Ignore double override.
U 0322, 0000,0210,2732,1716	;12554		INPR.W	[FPS, RA]		; Get FPS.
				;12555	=
U 1716, 0000,1561,7557,1717	;12556		MOV.W	[RB, RF.H]		; Switch to RF.H for FDST addressing.
				;12557	
				;12558		OUTS	[LD_FPS, R9],		; Reload opcode and FPS flops.
U 1717, 0000,0271,7571,0722	;12559				NAF/P.NZ2	; Invoke FN, FZ overrides.
				;12560	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  302
; FP11  .MCD [242,1110]      ABSf, NEGf

				;12561	=11********0	; Default for FN, FZ overrides.
U 3616, 0037,7777,5100,0000	;12562	NPLA1	[P.NZ2, ^X]
				;12563		LBIC.W	[017, RA],		; Pre-clear FCCs.
U 3617, 0000,0550,0772,1063	;12564				NAF/ABS1	; Four word block.
				;12565	=
				;12566	=00	; UV.
				;12567		LMSTK	[ABS2, R9],		; Return if don't trap.
U 1060, 0000,0534,3131,1730	;12568				NAF/FIUV-CK	; Go check for AC or disabled.
				;12569	=01	; Negative.
				;12570	ABS3:
				;12571		LLSW.L	[200, RC.H],		; Load RC<31> for sign update.
U 1061, 0000,0463,0014,0772	;12572				NAF/P.OPCD1	; Decode instruction.
				;12573	=10	; Zero.
				;12574	ABS2:
				;12575		LBIS.W	[004, RA],		; Set FZ.
U 1062, 0000,0570,0232,1721	;12576				NAF/ABS6	; Skip.
				;12577	=11	; Positive.
				;12578	ABS1:
				;12579		LBIS.W	[010, RA],		; Set FN for NEGf.
U 1063, 0000,0570,0432,1061	;12580				NAF/ABS3	; Join common.
				;12581	=
				;12582	=11********0	; Breakout ABSf.
U 3620, 0037,0077,7500,0600	;12583	NPLA1	[P.OPCD1, ^XXXX 000 110 XXX XXX]
U 3621, 0000,1553,7637,1720	;12584		BIC.L	[RC, RF]		; Set FSRC.3<15> to 0.
				;12585	=
				;12586		LBIC.W	[010, RA],		; Clear FN also.
U 1720, 0000,0550,0432,1723	;12587				NAF/ABS5	; Store FPS.
				;12588	
				;12589	=11********0	; Breakout NEGf.
U 3622, 0037,0077,7500,0700	;12590	NPLA1	[P.OPCD1, ^XXXX 000 111 XXX XXX]
				;12591		XOR.L	[RC, RF],		; Toggle FSRC.3<15>.
U 3623, 0000,1543,7637,1723	;12592				NAF/ABS5	; Skip.
				;12593	=
				;12594	ABS6:
U 1721, 0000,1043,7777,1722	;12595		CLR.L	[RF, RF]		; Zero result.
				;12596	
U 1722, 0000,1043,7675,1723	;12597		CLR.L	[RD, RD]		; Clear for double.
				;12598	
				;12599	ABS5:
				;12600		OUTR.W	[FPS, RA],		; Store FPS.
U 1723, 0000,0250,2732,0700	;12601				NAF/P.REST0	; Now backup registers.
				;12602	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  303
; FP11  .MCD [242,1110]      ABSf, NEGf

				;12603	; Entry for hot ABSf/NEGf.
				;12604	
				;12605	=11********0	; Default for mode 2 or 4 and/or double overrides.
U 3624, 0037,7777,4000,0000	;12606	NPLA1	[P.REST0, ^X]
				;12607		NOP.W	[RF, RF],
U 3625, 0000,1771,7777,1121	;12608				NAF/ABS7	; Two word block.
				;12609	=
				;12610	;; P.REST0 + P.REST1.
				;12611	;=11********0	; Override for mode 2.
				;12612	;PLA1	[^X 000 000, ^XXXX XXX XXX 010 XXX]
				;12613	;	INPR.W	[MMUTMP, RDST],		; Retrieve original RDST.
				;12614	;			NAF/1777
				;12615	;=
				;12616	;; P.REST0 + P.REST1.
				;12617	;=11********0	; Override for mode 4.
				;12618	;PLA1	[^X 000 000, ^XXXX XXX XXX 100 XXX]
				;12619	;	INPR.W	[MMUTMP, RDST],		; Retrieve original RDST.
				;12620	;			NAF/1777
				;12621	;=
				;12622	=0	; Double.
				;12623		LSUB.W	[010, RE],		; Backup by 8 for double.
U 1120, 0000,0410,0436,0616	;12624				NAF/P.FDST-E	; Enter FDST addressing.
				;12625	ABS7:	; Single.
				;12626		LSUB.W	[004, RE],		; Backup by 4 for single.
U 1121, 0000,0410,0236,0616	;12627				NAF/P.FDST-E	; Enter FDST addressing.
				;12628	=
				;12629	
;12630	.NOBIN
;12631	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  304
; FP11  .MCD [242,1110]      Common Routines

;12632		.TOC	"	Common Routines"
;12633	
;12634		.TOC	"		uInstruction/NAF overrides"
;12635	
;12636		.TOC	"			Normalization PLAs"
;12637	
;12638	;
;12639	; These are the normalization PLAs.
;12640	; They are used to align the MSB (of 1) into the hidden bit position.
;12641	; For a specific instruction, they are used with a default PLA which
;12642	; specifies the high address of a 4 word block.  The shift count is
;12643	; loaded into the CNTR and returned in Ra.  The NA reflects the following:
;12644	;	000*	No shift required.
;12645	;	001*	Shift left.
;12646	;	010*	Shift right.
;12647	;	111*	Word is all 0's (default case).
;12648	;
;12649	
				;12650	.BIN
				;12651	
				;12652	=11********0
U 3626, 0027,7777,7550,0000	;12653	NPLA1	[P.NORM, ^1XXX XXX XXX XXX XXX]
				;12654		LCNTR.B	[007, RF],		; Seven shifts right.
U 3627, 0000,0526,0377,1775	;12655				NAF/1775
				;12656	=11********0
U 3630, 0023,7777,7544,0000	;12657	NPLA1	[P.NORM, ^01XX XXX XXX XXX XXX]
				;12658		LCNTR.B	[006, RF],		; Six shifts right.
U 3631, 0000,0526,0337,1775	;12659				NAF/1775
				;12660	=11********0
U 3632, 0021,7777,7542,0000	;12661	NPLA1	[P.NORM, ^001X XXX XXX XXX XXX]
				;12662		LCNTR.B	[005, RF],		; Five shifts right.
U 3633, 0000,0526,0277,1775	;12663				NAF/1775
				;12664	=11********0
U 3634, 0020,7777,7541,0000	;12665	NPLA1	[P.NORM, ^0001 XXX XXX XXX XXX]
				;12666		LCNTR.B	[004, RF],		; Four shifts right.
U 3635, 0000,0526,0237,1775	;12667				NAF/1775
				;12668	=11********0
U 3636, 0020,3777,7540,4000	;12669	NPLA1	[P.NORM, ^0000 1XX XXX XXX XXX]
				;12670		LCNTR.B	[003, RF],		; Three shifts right.
U 3637, 0000,0526,0177,1775	;12671				NAF/1775
				;12672	=11********0
U 3640, 0020,1777,7540,2000	;12673	NPLA1	[P.NORM, ^0000 01X XXX XXX XXX]
				;12674		LCNTR.B	[002, RF],		; Two shifts right.
U 3641, 0000,0526,0137,1775	;12675				NAF/1775
				;12676	=11********0
U 3642, 0020,0777,7540,1000	;12677	NPLA1	[P.NORM, ^0000 001 XXX XXX XXX]
				;12678		LCNTR.B	[001, RF],		; One shift right.
U 3643, 0000,0526,0077,1775	;12679				NAF/1775
				;12680	=11********0	; Align hidden bit here.
U 3644, 0020,0377,7540,0400	;12681	NPLA1	[P.NORM, ^0000 000 1XX XXX XXX]
				;12682		LCNTR.B	[000, RF],		; No shift required.
U 3645, 0000,0526,0037,1771	;12683				NAF/1771
				;12684	=11********0
U 3646, 0020,0177,7540,0200	;12685	NPLA1	[P.NORM, ^0000 000 01X XXX XXX]
				;12686		LCNTR.B	[001, RF],		; One shift left.
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  305
; FP11  .MCD [242,1110]      Normalization PLAs

U 3647, 0000,0526,0077,1773	;12687				NAF/1773
				;12688	=11********0
U 3650, 0020,0077,7540,0100	;12689	NPLA1	[P.NORM, ^0000 000 001 XXX XXX]
				;12690		LCNTR.B	[002, RF],		; Two shifts left.
U 3651, 0000,0526,0137,1773	;12691				NAF/1773
				;12692	=11********0
U 3652, 0020,0037,7540,0040	;12693	NPLA1	[P.NORM, ^0000 000 000 1XX XXX]
				;12694		LCNTR.B	[003, RF],		; Three shifts left.
U 3653, 0000,0526,0177,1773	;12695				NAF/1773
				;12696	=11********0
U 3654, 0020,0017,7540,0020	;12697	NPLA1	[P.NORM, ^0000 000 000 01X XXX]
				;12698		LCNTR.B	[004, RF],		; Four shifts left.
U 3655, 0000,0526,0237,1773	;12699				NAF/1773
				;12700	=11********0
U 3656, 0020,0007,7540,0010	;12701	NPLA1	[P.NORM, ^0000 000 000 001 XXX]
				;12702		LCNTR.B	[005, RF],		; Five shifts left.
U 3657, 0000,0526,0277,1773	;12703				NAF/1773
				;12704	=11********0
U 3660, 0020,0003,7540,0004	;12705	NPLA1	[P.NORM, ^0000 000 000 000 1XX]
				;12706		LCNTR.B	[006, RF],		; Six shifts left.
U 3661, 0000,0526,0337,1773	;12707				NAF/1773
				;12708	=11********0
U 3662, 0020,0001,7540,0002	;12709	NPLA1	[P.NORM, ^0000 000 000 000 01X]
				;12710		LCNTR.B	[007, RF],		; Seven shifts left.
U 3663, 0000,0526,0377,1773	;12711				NAF/1773
				;12712	=11********0
U 3664, 0020,0000,7540,0001	;12713	NPLA1	[P.NORM, ^0000 000 000 000 001]
				;12714		LCNTR.B	[010, RF], 		; Eight shifts left.
U 3665, 0000,0526,0437,1773	;12715				NAF/1773
				;12716	
;12717	.NOBIN
;12718	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  306
; FP11  .MCD [242,1110]      Exponent Extractors

;12719		.TOC	"			Exponent Extractors"
;12720	
;12721	;
;12722	; These overrides extract the exponent and contruct a literal microinstruction.
;12723	; They also override the NAF on UV, Exp = 0 and Exp<7> = 0.
;12724	; If UV,	NAF<2:0> <= 0.
;12725	; If Exp = 0,	NAF<1:0> <= 0.
;12726	; If Exp<7>=0	NAF<1>	 <= 0.
;12727	;
				;12728	.BIN
				;12729	
				;12730	=11********0	; Override for UV.
U 3666, 0360,0177,3010,0000	;12731	PLA1	[^0 110 XXX, ^1 000 000 00X XXX XXX]
				;12732		LBIS.B	[000, RF],
U 3667, 0000,0576,0037,1770	;12733				NAF/1770	; Override NAF<2:0>.
				;12734	=11********0	; Override for Exp = 0 and for UV.
U 3670, 0370,0177,3000,0000	;12735	PLA1	[^0 110 XXX, ^X 000 000 00X XXX XXX]
				;12736		LBIS.B	[000, RF],
U 3671, 0000,0576,0037,1774	;12737				NAF/1774	; Override NAF<1:0>.
				;12738	=11********0	; Override for Exp<7> = 0 and unbiased.
U 3672, 0373,7777,3000,0000	;12739	PLA1	[^0 110 XXX, ^X 0XX XXX XXX XXX XXX]
				;12740		LBIS.B	[177, RF],
U 3673, 0000,0576,7777,1775	;12741				NAF/1775	; Override NAF<1>.
				;12742	=11********0	; Override for Exp<6>.
U 3674, 0375,7777,3000,0000	;12743	PLA1	[^0 110 XXX, ^X X0X XXX XXX XXX XXX]
				;12744		LBIS.B	[277, RF],
U 3675, 0000,0577,3777,1777	;12745				NAF/1777	; Do not override NAF.
				;12746	=11********0	; Override for Exp<5>.
U 3676, 0376,7777,3000,0000	;12747	PLA1	[^0 110 XXX, ^X XX0 XXX XXX XXX XXX]
				;12748		LBIS.B	[337, RF],
U 3677, 0000,0577,5777,1777	;12749				NAF/1777	; Do not override NAF.
				;12750	=11********0	; Override for Exp<4>.
U 3700, 0377,3777,3000,0000	;12751	PLA1	[^0 110 XXX, ^X XXX 0XX XXX XXX XXX]
				;12752		LBIS.B	[357, RF],
U 3701, 0000,0577,6777,1777	;12753				NAF/1777	; Do not override NAF.
				;12754	=11********0	; Override for Exp<3>.
U 3702, 0377,5777,3000,0000	;12755	PLA1	[^0 110 XXX, ^X XXX X0X XXX XXX XXX]
				;12756		LBIS.B	[367, RF],
U 3703, 0000,0577,7377,1777	;12757				NAF/1777	; Do not override NAF.
				;12758	=11********0	; Override for Exp<2>.
U 3704, 0377,6777,3000,0000	;12759	PLA1	[^0 110 XXX, ^X XXX XX0 XXX XXX XXX]
				;12760		LBIS.B	[373, RF],
U 3705, 0000,0577,7577,1777	;12761				NAF/1777	; Do not override NAF.
				;12762	=11********0	; Override for Exp<1>.
U 3706, 0377,7377,3000,0000	;12763	PLA1	[^0 110 XXX, ^X XXX XXX 0XX XXX XXX]
				;12764		LBIS.B	[375, RF],
U 3707, 0000,0577,7677,1777	;12765				NAF/1777	; Do not override NAF.
				;12766	=11********0	; Override for Exp<0>.
U 3710, 0377,7577,3000,0000	;12767	PLA1	[^0 110 XXX, ^X XXX XXX X0X XXX XXX]
				;12768		LBIS.B	[376, RF],
U 3711, 0000,0577,7737,1777	;12769				NAF/1777	; Do not override NAF.
				;12770	
;12771	.NOBIN
;12772	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  307
; FP11  .MCD [242,1110]      Mantissa Extractors

;12773		.TOC	"			Mantissa Extractors"
;12774	
;12775	;
;12776	; These overrides extract the mantissa and contruct a literal microinstruction.
;12777	; They can be used to insert the hidden bit and clear the Exp.
;12778	;
				;12779	.BIN
				;12780	
				;12781	=11********0	; Override for mantissa<6>.
U 3712, 0377,7677,7000,0000	;12782	PLA1	[^1 110 XXX, ^X XXX XXX XX0 XXX XXX]
				;12783		LBIS.B	[277, RF],
U 3713, 0000,0577,3777,1777	;12784				NAF/1777
				;12785	=11********0	; Override for mantissa<5>.
U 3714, 0377,7737,7000,0000	;12786	PLA1	[^1 110 XXX, ^X XXX XXX XXX 0XX XXX]
				;12787		LBIS.B	[337, RF],
U 3715, 0000,0577,5777,1777	;12788				NAF/1777
				;12789	=11********0	; Override for mantissa<4>.
U 3716, 0377,7757,7000,0000	;12790	PLA1	[^1 110 XXX, ^X XXX XXX XXX X0X XXX]
				;12791		LBIS.B	[357, RF],
U 3717, 0000,0577,6777,1777	;12792				NAF/1777
				;12793	=11********0	; Override for mantissa<3>.
U 3720, 0377,7767,7000,0000	;12794	PLA1	[^1 110 XXX, ^X XXX XXX XXX XX0 XXX]
				;12795		LBIS.B	[367, RF],
U 3721, 0000,0577,7377,1777	;12796				NAF/1777
				;12797	=11********0	; Override for mantissa<2>.
U 3722, 0377,7773,7000,0000	;12798	PLA1	[^1 110 XXX, ^X XXX XXX XXX XXX 0XX]
				;12799		LBIS.B	[373, RF],
U 3723, 0000,0577,7577,1777	;12800				NAF/1777
				;12801	=11********0	; Override for mantissa<1>.
U 3724, 0377,7775,7000,0000	;12802	PLA1	[^1 110 XXX, ^X XXX XXX XXX XXX X0X]
				;12803		LBIS.B	[375, RF],
U 3725, 0000,0577,7677,1777	;12804				NAF/1777
				;12805	=11********0	; Override for mantissa<0>.
U 3726, 0377,7776,7000,0000	;12806	PLA1	[^1 110 XXX, ^X XXX XXX XXX XXX XX0]
				;12807		LBIS.B	[376, RF],
U 3727, 0000,0577,7737,1777	;12808				NAF/1777
				;12809	
;12810	.NOBIN
;12811	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  308
; FP11  .MCD [242,1110]      FN and FZ Overrides

;12812		.TOC	"			FN and FZ Overrides"
;12813	
;12814	;
;12815	; These overrides zero the NA to set FCCs.
;12816	;
;12817	
				;12818	.BIN
				;12819	
				;12820	=11********0	; Override for result is negative.
U 3730, 0367,7777,5010,0000	;12821	PLA1	[^1 010 XXX, ^1XXX XXX XXX XXX XXX]
				;12822		NOP.W	[RF, RF],		; Can be overridden.
U 3731, 0000,1771,7777,1775	;12823				NAF/1775	; Override NAF<1>.
				;12824	=
				;12825	=11********0	; Override for exponent is zero.
U 3732, 0370,0177,5000,0000	;12826	PLA1	[^1 010 XXX, ^X000 000 00X XXX XXX]
				;12827		NOP.W	[RF, RF],		; Can be overridden.
U 3733, 0000,1771,7777,1776	;12828				NAF/1776	; Override NAF<0>.
				;12829	=
				;12830	
;12831	.NOBIN
;12832	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  309
; FP11  .MCD [242,1110]      FD Override

;12833		.TOC	"			FD Override"
;12834	
;12835	;
;12836	; This override zeroes NA<0> to distinguish between Floating and Double.
;12837	;
;12838	
				;12839	.BIN
				;12840	
				;12841	=11********0	; Override NAF<0> if Double.
U 3734, 0767,7777,4010,0000	;12842	PLA1	[^1 00X XXX, ^1XXX XXX XXX XXX XXX]
				;12843		NOP.L	[RF, RF],		; May be overridden to word.
U 3735, 0000,1773,7777,1776	;12844				NAF/1776	; Override NAF<0>.
				;12845	=
				;12846	
;12847	.NOBIN
;12848	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  310
; FP11  .MCD [242,1110]      Miscellaneous

;12849		.TOC	"		Miscellaneous"
;12850	
;12851		.TOC	"			Store FCC/AC/Exit"
;12852	
;12853	;
;12854	; This code stores the FCC, stores the AC according to FD, and exits.
;12855	;
				;12856	.BIN
				;12857	
				;12858	FPS-STR1:
				;12859		OUTR.W	[AC76.3, RB],		; Begin of load to AC.
U 1724, 0000,0251,2533,0715	;12860				NAF/P.STR-AC1	; Invoke FD override.
				;12861	
				;12862	=11********0	; Default for Double override.
U 3736, 0037,7777,4640,0000	;12863	NPLA1	[P.STR-AC1, ^X]
				;12864		OUTR.W	[AC76.2, RF],		; Store result in FAC.
U 3737, 0000,0251,6537,1123	;12865				NAF/STR-AC7	; NAF<0> overriddden if Double.
				;12866	=
				;12867	;=11********0	; Override NAF<0> if Double.
				;12868	;PLA1	[^1 000 XXX, ^1XXX XXX XXX XXX XXX]
				;12869	;	NOP.L	[RF, RF],		; May be overridden to word.
				;12870	;			NAF/1776	; Override NAF<0>.
				;12871	;=
				;12872	=0					; Get here for Double only.
				;12873		OUTR.W	[AC76.1, RD.H],		; Store result in FAC.
U 1122, 0000,0251,2115,1725	;12874				NAF/STR-AC8
				;12875	STR-AC7:
				;12876		OUTR.W	[FPS, RA],		; Store away FPS.
U 1123, 0000,0250,2732,1477	;12877				NAF/NOP-PF	; All done.
				;12878	=
				;12879	STR-AC8:
				;12880		OUTR.W	[AC76.0, RD],		; Store result in FAC.
U 1725, 0000,0251,6135,1123	;12881				NAF/STR-AC7	; Store final word.
				;12882	
;12883	.NOBIN
;12884	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  311
; FP11  .MCD [242,1110]      Exact Zero

;12885		.TOC	"			Exact Zero"
;12886	
;12887	;
;12888	; This code stores an exact 0 into the AC based on FD, updates the FCCs
;12889	; and exits without checking for an exception.  It is primarily used when
;12890	; underflow or overflow occurs with the interrupt disabled or with zero
;12891	; operands for the arithmetics.
;12892	;
;12893	
				;12894	.BIN
				;12895	
				;12896	; From DIVf.
				;12897	;=000					; Ignore UV and bias overrides.
				;12898	;EXACT-0A:
				;12899	;	INPR.W	[FPS, RA],		; AC is 0.  Result is 0.
				;12900	;			NAF/EXACT-0B	; See "Exact Zero".
				;12901	EXACT-0B:
				;12902		LBIC.W	[017, RA],		; Preclear FCCs for update.
U 1726, 0000,0550,0772,0270	;12903				NAF/EXACT-0C	; See "Exact Zero".
				;12904	; From CMPf.
				;12905	;=000
				;12906	;EXACT-0C:
				;12907	;	OUTS	[LD_FPS, R9],		; Load FD and opcode.
				;12908	;			NAF/EXACT-0D	; See "Exact Zero".
				;12909	EXACT-0D:
				;12910		CLR.L	[RB, RB],		; Prepare to store all zeros.
U 1727, 0000,1043,7573,0604	;12911				NAF/P.MODF1	; Decode opcode for MODf.
				;12912	
				;12913	=11********0	; Default for MODf override.
U 3740, 0037,7777,0200,0000	;12914	NPLA1	[P.MODF1, ^X]
				;12915		CLR.W	[RF, RF],		; Clear scratch for AC.2.
U 3741, 0000,1041,7777,1125	;12916				NAF/EXACT-0F	; Two word block.
				;12917	=
				;12918	;; P.MODF0 + P.MODF1
				;12919	;=11********0	; Override for MODf breakout (1st time through).
				;12920	;PLA1	[^0 000 10X, ^XXXX 001 1XX XXX XXX]	; MOD instruction.
				;12921	;	NOP.L	[RF, RF],		; PIR<11:8> = 0001 or 0000
				;12922	;					;  on second time through.
				;12923	;			NAF/1776	; Override to MODf.  See P.NRM2.
				;12924	;=
				;12925	=0
				;12926		LMSTK	[EXACT-0F, RC],		; Return after zeroing AC+1.
U 1124, 0000,0534,5274,1632	;12927				NAF/ZERO+1	; Call MODf subroutine.
				;12928	EXACT-0F:
				;12929		CLR.L	[RD, RD],		; Store an exact zero.
U 1125, 0000,1043,7675,0166	;12930				NAF/LDF4	; See "LDf".
				;12931	=
;12932	.NOBIN
;12933	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  312
; FP11  .MCD [242,1110]      FIUV Check

;12934		.TOC	"			FIUV Check"
;12935	
;12936	;
;12937	; FSRC is the UV.
;12938	;  If FSRC is from an AC or FIUV disabled, then return (RFS).
;12939	;  If FSRC not from AC and FIUV enabled, then trap.
;12940	;
;12941	; This code clobbers R9, then restores it with the opcode.
;12942	; May also clobber R8.H.
;12943	
				;12944	.BIN
				;12945	
				;12946	; First check FIUV.
				;12947	
				;12948	FIUV-CK:
U 1730, 0000,0210,2731,1731	;12949		INPR.W	[FPS, R9]		; Retrieve FPS.
				;12950	
U 1731, 0000,1461,7471,1732	;12951		SWAB.W	[R9, R9]		; Move FIUV, FPS<11> to literal land.
				;12952	
U 1732, 0000,0506,0431,1733	;12953		LBIT.B	[010, R9]		; Is FIUV = 0?
				;12954	
U 1733, 0000,0111,2037,1734	;12955		JAZ	[POP]			; AZ = 1 if true.
				;12956	
				;12957	; Now check for AC.
				;12958	
U 1734, 0000,1561,6071,1735	;12959		MOV.W	[IRFE, R9]		; Get opcode to a-port register.
				;12960						;  Go to POP if FIUV = 0.
U 1735, 0000,0506,3431,1736	;12961		LBIT.B	[070, R9]		; Is FSRC mode equal 0.
				;12962	
U 1736, 0000,0111,2037,1737	;12963		JAZ	[POP]			; AZ = 1 if true.
				;12964	
				;12965		LLD.W	[014, R8.H],		; Load code for UV.
				;12966						;  Go to POP if FSRC mode = 0.
U 1737, 0000,0560,0610,1747	;12967				NAF/FIUV1	; Otherwise; see "Trap Handler".
				;12968	; No, return.
				;12969	
				;12970	;240:
				;12971	;POP:
				;12972	;	NOP.W	[RF, RF],		; Nothing to do.
				;12973	;			NAF/RFS		; Return to treat as FSRC = 0.
				;12974	
;12975	.NOBIN
;12976	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  313
; FP11  .MCD [242,1110]      Interrupt Check

;12977		.TOC	"			Interrupt Check"
;12978	
;12979	;
;12980	; These terms breakout pending interrupts.
;12981	; The general registers are restored,  synchronous flops are cleared,
;12982	; and the interrupt is serviced at ID1SVC.
;12983	;
;12984	
				;12985	.BIN
				;12986	
				;12987	; Catch interrupts.
				;12988	
				;12989	; P.INTx + P.ALNx
				;12990	=11********0	; Interrupt pending, single precision.
U 3742, 0747,7777,2020,0000	;12991	PLA1	[^0 10X XXX, ^1 0XXX XXX XXX XXX XXX]
				;12992		LMSTK	[0400, RF],		; RFS to service interrupt.
U 3743, 0000,0532,0037,1743	;12993				NAF/REST-GP	; Call "Register Restore".
				;12994	=
				;12995	; P.INTx + P.ALNx
				;12996	=11********0	; Interrupt pending, double precision.
U 3744, 0747,7777,2030,0000	;12997	PLA1	[^0 10X XXX, ^1 1XXX XXX XXX XXX XXX]
U 3745, 0000,0210,6340,1740	;12998		INPR.W	[CPAR, PS]		; Restore the PS for double.
				;12999	=
				;13000	; Entry for late FPE.
				;13001	INT:
U 1740, 0000,0260,1637,1741	;13002		OUTC	[CLR_SVC_FFS]		; Clear PTYFF, SOVFF, ITFF, and SSFF as
				;13003						;  this instruction never happened.
				;13004	
				;13005		LMSTK	[0400, RF],		; RFS to service interrupt.
U 1741, 0000,0532,0037,1743	;13006				NAF/REST-GP	; Call "Register Restore".
				;13007	
;13008	.NOBIN
;13009	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  314
; FP11  .MCD [242,1110]      Abort Processing

;13010		.TOC	"			Abort Processing"
;13011	
;13012	
;13013	;
;13014	; Floating Point aborts are processed at ROM[200].
;13015	; Because MMR1 is never clocked during addressing (due to modes 2 and 4),
;13016	; this code restores the GPRs such that MMR1 is correct.  The PC is not
;13017	; restored however so that debuggers can follow the normal rules in locating
;13018	; the offending instruction.  Note that MMR2 has the correct PC for MMU aborts.
;13019	;
;13020	
				;13021	.BIN
				;13022	
				;13023	200:					; Forced here asynchronously on abort.
				;13024		LMSTK	[FP-ABRT, RF],		; Return to FP-ABRT
U 0200, 0000,0537,6137,1743	;13025				NAF/REST-GP	;  after restoring registers.
				;13026	FP-ABRT:
				;13027		MOV.W	[RC, PC],		; Retain PC as noted above.
U 1742, 0000,1561,7627,0040	;13028				NAF/40		; Join normal abort processing at
				;13029						;  ROM[040].
				;13030	
;13031	.NOBIN
;13032	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  315
; FP11  .MCD [242,1110]      Register Restore

;13033		.TOC	"			Register Restore"
;13034	
;13035	;
;13036	; This code backs up the general registers when:
;13037	; 1) An interrupt is processed for the
;13038	;    instructions: ADDf, SUBf, MULf, MODf, DIVf and STCfi.
;13039	; 2) An abort occurs during addressing.
;13040	; 3) FPE is acknowledged during FPA support.
;13041	; 4) Warm FP calculates FEA.
;13042	;
;13043	
				;13044	.BIN
				;13045	
				;13046	; This subroutine restores the PC and RDST (which may be the same)
				;13047	; to there original state.
				;13048	
				;13049	REST-GP:
U 1743, 0000,1561,6071,1744	;13050		MOV.W	[IRFE, R9]		; Need opcode on a-bus.
				;13051	
U 1744, 0000,0271,7571,1745	;13052		OUTS	[LD_FPS, R9]		; Load opcode and FPS.
				;13053	
				;13054		MOV.W	[PC, RC],		; Save PC for warm FEA calculation.
U 1745, 0000,1561,7374,0600	;13055				NAF/P.REST1	; Decode mode for restore.
				;13056	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  316
; FP11  .MCD [242,1110]      Register Restore

				;13057	=11********0	; Default.  Modes 0, or 1.
U 3746, 0037,7777,0000,0000	;13058	NPLA1	[P.REST1, ^X]
				;13059		NOP.W	[RF, RF],		; Overridden for other modes.
U 3747, 0000,1771,7777,1746	;13060				NAF/REST-GP1	; Skip.
				;13061	=
				;13062	; P.REST0 + P.REST1.
				;13063	=11********0	; Override for mode 2.
U 3750, 4037,7707,0000,0020	;13064	PLA1	[^X 000 000, ^XXXX XXX XXX 010 XXX]
				;13065		INPR.W	[MMUTMP, RDST],		; Retrieve original RDST.
U 3751, 0000,0210,2346,1777	;13066				NAF/1777
				;13067	=
				;13068	=11********0	; Override for mode 3.
U 3752, 0037,7707,0000,0030	;13069	NPLA1	[P.REST1, ^XXXX XXX XXX 011 XXX]
				;13070		LSUB.W	[002, RDST],		; Always subtract 2.
U 3753, 0000,0410,0106,1777	;13071				NAF/1777
				;13072	=
				;13073	; P.REST0 + P.REST1.
				;13074	=11********0	; Override for mode 4.
U 3754, 4037,7707,0000,0040	;13075	PLA1	[^X 000 000, ^XXXX XXX XXX 100 XXX]
				;13076		INPR.W	[MMUTMP, RDST],		; Retrieve original RDST.
U 3755, 0000,0210,2346,1777	;13077				NAF/1777
				;13078	=
				;13079	=11********0	; Override for mode 5.
U 3756, 0037,7707,0000,0050	;13080	NPLA1	[P.REST1, ^XXXX XXX XXX 101 XXX]
				;13081		LADD.W	[002, RDST],		; Always add 2.
U 3757, 0000,0440,0106,1777	;13082				NAF/1777
				;13083	=
				;13084	=11********0	; Override for modes 6 or 7.
U 3760, 0037,7717,0000,0060	;13085	NPLA1	[P.REST1, ^XXXX XXX XXX 11X XXX]
				;13086		LSUB.W	[002, PC],		; Always subtract 2 from PC.
U 3761, 0000,0410,0127,1777	;13087				NAF/1777
				;13088	=
				;13089	=11********0	; Override for SETx + CFCC + illegal ops.
U 3762, 0037,0077,0000,0000	;13090	NPLA1	[P.REST1, ^XXXX 000 000 XXX XXX]
				;13091		NOP.B	[RF, RE+],		; Kill register select code.
U 3763, 0000,1777,7744,1777	;13092				NAF/1777
				;13093	=
				;13094	REST-GP1:
				;13095		LSUB.W	[002, PC],		; Back up for instruction fetch.
U 1746, 0000,0410,0127,0777	;13096				NAF/RFS		; Return to call.
				;13097	
				;13098	
;13099	.NOBIN
;13100	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  317
; FP11  .MCD [242,1110]      Trap Handler

;13101		.TOC	"			Trap Handler"
;13102	
;13103	;
;13104	;	This code sets the Floating Error (FER) flag, FPS<15>.  A four-bit
;13105	;	Floating Exception Code is stored in FEC, and the address of the
;13106	;	instruction producing the exception is stored in FEA.  An interrupt
;13107	;	is generated unless the Floating Interrupt Disable flag,
;13108	;	FPS<14> is set.
;13109	;
;13110	; Entry conditions:
;13111	;	R8.H	Contains the floating exception code.
;13112	;
;13113	
				;13114	.BIN
				;13115	
				;13116	; Entry for FIUV, DIVf by 0, and illegal opcodes.
				;13117	FIUV1:
				;13118		INPR.W	[FPS, RA],		; Get FID for UV or divide by 0 trap.
U 1747, 0000,0210,2732,1667	;13119				NAF/UN-OV1	; Join arithmetic under/overflow.
				;13120	
				;13121	; Entry for under/overflow.
				;13122	;UN-OV1:
				;13123	;	MOV.W	[RDST, RC.H]		; Save RDST before "Register Restore".
				;13124	;			NAF/UN-OV2	; See "Trap Handler".
				;13125	
				;13126	UN-OV2:
				;13127		LMSTK	[UN-OV3, RF],		; Calculate the original PC.
U 1751, 0000,0537,6577,1743	;13128				NAF/REST-GP	; See "Register Restore".
				;13129	UN-OV3:
U 1753, 0000,1561,7370,1754	;13130		MOV.W	[PC, R8]		; Save the PC just calculated.
				;13131	
U 1754, 0000,1561,7627,1755	;13132		MOV.W	[RC, PC]		; Restore PC saved at Register Restore.
				;13133	
U 1755, 0000,1561,6606,1756	;13134		MOV.W	[RC.H, RDST]		; Restore RDST finally.
				;13135	
				;13136	; Entry for FPE acknowledge.
				;13137	FP-TRAP:
U 1756, 0000,0461,0037,1760	;13138		LLSW.W	[200, RF]		; RF<15> <= 1.
				;13139	
U 1760, 0000,1571,7772,1761	;13140		BIS.W	[RF, RA]		; Set FER (FPS<15>).
				;13141	
U 1761, 0000,0250,2732,1762	;13142		OUTR.W	[FPS, RA]		; Store the FPS.
				;13143	
U 1762, 0000,0250,2310,1763	;13144		OUTR.W	[FEC, R8.H]		; Store the error code into FEC.
				;13145	
U 1763, 0000,1231,7537,1764	;13146		ASL.W	[RA, RF]		; AN, RF<15> <= FID.
				;13147	
U 1764, 0000,0172,2037,1765	;13148		JAN	[0440]			; Take JAN to disable interrupt.
				;13149						; Do full resynchronize for FPE.
				;13150	
U 1765, 0000,0250,2770,1766	;13151		OUTR.W	[FEA, R8]		; Store away FEA.
				;13152	
				;13153		LLD.W	[244, RA],		; Vector through 244.
U 1766, 0000,0561,2232,1271	;13154				NAF/M-TRAP	; Go to normal M-TRAP entry.
				;13155	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  318
; FP11  .MCD [242,1110]      Trap Handler

				;13156	
				;13157	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  319
; PLADEF.MCD [242,1110]      PLADEF.MCD

				;13158		.TOC	"PLADEF.MCD"
				;13159		.TOC	"REVISION 3.07"
				;13160	
				;13161	
;13162	.NOBIN
;13163	
;13164	
;13165		.TOC	"	Revision History"
;13166	
;13167	;
;13168	;	Revision History
;13169	;	----------------
;13170	;
;13171	; Rev.     Date		Explaination
;13172	; ----     ----		------------
;13173	;
;13174	; 3.07   05/13/82	KEH; Fixed ABS/NEG mode 27 by expanding the meaning of
;13175	;			     P.FSRC-R0 and reserving NA 610.
;13176	; 3.06   02/15/82	KEH; Fixed LDEXP bug and speeded up hot non-io.
;13177	;	 Release
;13178	; 2.05   01/14/82	KEH; Major change for second addressing rewrite.
;13179	; 2.04   01/12/82	KEH; Moved FD override block to 0700 for
;13180	;			     P.FP-END => P.REST0 hot ABSf/NEGf override.
;13181	; 2.03   01/08/82	KEH; Combined P.SRC-R and P.FSRC-R dispatch.
;13182	; 2.02   01/02/82	KEH; Moved P.OPTION to bank 0 after eliminating
;13183	;			     P-U-T constraint in base code.
;13184	; 2.01   12/08/81	KEH; Major reorganization for new addressing blocks.
;13185	; 2.00   12/08/81	KEH; Added this header and remarks.
;13186	;
;13187	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  320
; PLADEF.MCD [242,1110]      Introductory Remarks

;13188		.PAGE	"	Introductory Remarks"
;13189	
;13190	;
;13191	;	This file was generated in conjunction with the FP11 microcode.
;13192	;	It defines the PLA address assignments for CTL0.
;13193	;
;13194	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  321
; PLADEF.MCD [242,1110]      PLA Address Assignments

;13195		.TOC	"	PLA Address Assignments"
;13196	
;13197	;	This kludge allows NAF field values to be defined here.
;13198		DUMMY		"NAF/0"
;13199	
;13200	;	Now define the new NAFs.
;13201	;
;13202	;	NAF/=<9:0>, .NEXTADDRESS
;13203	
;13204	;		Base code definitions.
;13205			P.ODT		= 0401	; Only ODT address.
;13206			P.MUL		= 0402	; Decode RSRC<0>, MUL end case.
;13207			P.DIV		= 0403	; R6, R7 override, DIV end condition.
;13208			P.ASD		= 0404	; Decode Abort Service Information.
;13209			P.HLT-CK0	= 0405	; Decode HALT line for sunset loops.
;13210			P.HLT-CK1	= 0406	; Decode HALT line at MULTIPLE-ABORT.
;13211			P.ASHC		= 0410	; Final unpack for ASHC.
;13212			P.OPTION	= 0411	; Decode power up options.
;13213			P.POKH		= 0415	; Decode POKH and FPA present.
;13214			P.ISD		= 0424	; Prioritize interrupts.
;13215			P.XCC		= 0430	; Decode CCC/SCC/NOP.
;13216			P.CSM		= 0432	; Decode mode and MMR3<3>.
;13217			P.RTX		= 0441	; Decode RTI/RTT; T-bit end condition.
;13218	;		End of base code assignments.
;13219	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  322
; PLADEF.MCD [242,1110]      PLA Address Assignments

;13220	;		Floating point code definitions.
;13221	;		RESERVED	= 0600	; See P.RESTx at FD block.
;13222			P.STF		= 0601	; Abort ROM[200]; override to ROM[201].
;13223	
;13224	;;;		0 000 10X	; Block for MODf opcode override (see NRM).
;13225			P.MODF1		= 0604	; Exact Zero MODf detect.
;13226			P.MODF0		= 0605	; MODf breakout at arithmetic normalize.
;13227	
;13228	;		RESERVED	= 0610	; Aligns with P.SRC-R, P.FSRC-R0, and
;13229						;  P.FSRC-R for "Hot support"
;13230	;		RESERVED	= 0614	; See P.SRC-R at FD block.
;13231	
;13232	;;;;;		0 0XX X1X	; Mode 2X and 17 overrides (see "Floating Point Addressing").
;13233			P.FDST3		= 0602	; FDST 4rd relocation.
;13234			P.FDST2		= 0603	; FDST 3rd relocation.
;13235			P.FSRC3		= 0606	; FSRC 4th relocation.
;13236			P.FSRC2		= 0607	; FSRC 3rd relocation.
;13237			P.FDST1		= 0612	; FDST mode/length overrides.
;13238			P.DST1		= 0613	; Second DST relocation.
;13239			P.FDST-E	= 0616	; FDST mode/length overrides.
;13240			P.DST-E		= 0617	; Entry to DST addressing.
;13241	;				= 0622	; unused.
;13242			P.FSRC1		= 0623	; FSRC mode/length overrides.
;13243			P.SRC1		= 0626	; SRC 2nd relocation.
;13244	;				= 0627	; unused.
;13245	;		P.SRC0		= 0632	; SRC 27 address.
;13246	;		P.FSRC0		= 0633	; FSRC mode/length overrides.
;13247	;		P.SRC		= 0636	; Entry to SRC addressing.
;13248	;		P.FSRC		= 0637	; Entry to FSRC addressing.
;13249	
;13250	;;;;;		0 011 XXX	; Address calculation dispatch (generated at P.FPC0).
;13251			P.DST0		= 0630	; Alternate DST execution.
;13252			P.FDST0		= 0631	; Alternate FDST execution.
;13253			P.SRC0		= 0632	; Alternate SRC mode 27 address.
;13254			P.FSRC0		= 0633	; Alternate FSRC length decode.
;13255			P.DST		= 0634	; DST execution.
;13256			P.FDST		= 0635	; FDST execution.
;13257			P.SRC		= 0636	; SRC addressing.
;13258			P.FSRC		= 0637	; FSRC addressing.
;13259	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  323
; PLADEF.MCD [242,1110]      PLA Address Assignments

;13260	;;;;;		0 10X XXX	; Arithmetic interrupt check (see "Interrupt Check").
;13261			P.INT0		= 0640	; MULD, DIVD loops, MODf mask, STCfi.
;13262			P.INT1		= 0641	; Ditto.
;13263			P.INT2		= 0642	; MULD loop, STCfi.
;13264			P.INT3		= 0643	; MULD loop, STCfi.
;13265	;;;		0 100 1XX	; Sub-block for double/truncate overrides (see "Rounding").
;13266			P.NRM2		= 0644	; MODf.  P.NRM1 => P.NRM2 at P.MODF0.
;13267			P.NRM1		= 0645	; Not MODf.
;13268			P.NRM3		= 0646	; After normalize.
;13269			P.NRM0		= 0647	; For ADD special case.
;13270	;;;		0 101 XX1	; Sub-block for ADDf/SUBf AC register overrides (see ASF5).
;13271			P.ALN0		= 0650	; Do final ADD/SUB; ROM constraint.
;13272			P.ALN1		= 0651	; Shift; CNTR to P.ALN0.
;13273			P.ALN2		= 0652	; Anomaly for double alignment.
;13274			P.ALN3		= 0653	; Real double alignment.
;13275			P.FSRC-R1	= 0654	; Decode arithmetic instruction.
;13276			P.ALN5		= 0655	; For double alignment.
;13277			P.INT4		= 0656	; At generalized normalization.
;13278	
;13279	;;;;;		0 110 XXX	; Exponent extractor overrides (see "Exponent Extractors").
;13280			P.EXP1		= 0661	; STCfi.
;13281			P.EXP2		= 0662	; MUL.  FSRC.
;13282			P.EXP3		= 0663	; MUL.  AC.
;13283			P.EXP4		= 0664	; DIV, first extract.
;13284			P.EXP5		= 0665	; LDCfd.
;13285			P.EXP6		= 0666	; ADD/SUB.
;13286			P.EXP7		= 0667	; ADD/SUB.
;13287	
;13288	;;;;;		0 111 XXX	; FP class overrides (see initial breakout).
;13289			P.FPC0		= 0670	; Short modes decode.
;13290			P.FPC1		= 0671	; unused
;13291			P.FPC2		= 0672	; Hot mode 0 decode.
;13292			P.FPC3		= 0673	; Hot non-mode 0 decode.
;13293			P.FPC4		= 0674	; Long mode second decode.
;13294			P.FPC5		= 0675	; Ditto.
;13295			P.FPC6		= 0676	; Ditto.
;13296			P.FPC7		= 0677	; Ditto.  High address for mode 37.
;13297	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  324
; PLADEF.MCD [242,1110]      PLA Address Assignments

;13298	;;;;;		1 00X XXX	; FD (double) overrides (see "FD Override").
;13299	;;;		X 000 000	; Sub-block for Register Restore overrides.
;13300			P.REST0		= 0700	; Overrides P.FP-END (hot ABSf/NEGf).
;13301			P.REST1		= 0600	; Restore for restartability.
;13302	;;;				; Miscellaneous.
;13303			P.MOD20		= 0701	; Default for zeroing AC+1 for MOD.
;13304			P.MOD13		= 0702	; MODf; after normalization..
;13305			P.MOD1		= 0703	; MODf normalization.
;13306	;;;		1 000 1XX	; Sub-block for AC/NAF overrides (see P.SUB1).
;13307			P.ADD1		= 0704	; Effective ADD or SUB.
;13308			P.SUB1		= 0705	; Effective SUB only.
;13309			P.ASF2		= 0706	; Decode sign and Exp. diff. of one.
;13310	;		RESERVED	= 0707	; Unused for AC/NAF overrides.
;13311	;;;		1 001 X00	; Must align for warm FSRC mode 0.
;13312			P.FSRC-R0	= 0710	; Double length override from P.FSRC-R.
;13313	;;;		X 001 100	; Sub-block for SRC/FSRC, special LDCif entry.
;13314			P.FSRC-R	= 0714	; Entry for normal SRC/FSRC execution.
;13315					;=0	; P.SRC-R<0> must be 0 (SRC mode 0).
;13316			P.SRC-R		= 0614	; Special entry for SRC mode 0 or 27.
;13317	;;;				; Miscellaneous.
;13318			P.MOD6		= 0711	; MODf; after mask alignment.
;13319			P.MULX8		= 0712	; Entry for MODf store.
;13320			P.OPCD2		= 0713	; LDCfd, MULf, DIVf, STCfi.
;13321	;		RESERVED	= 0714	; See above.
;13322			P.STR-AC1	= 0715	; Default for LDf.
;13323			P.FORM+1	= 0716	; MODf formatting.
;13324	
;13325	;;;;;		1 010 XXX	; FN and FZ overrides (see "FN and FZ overrides").
;13326			P.NZ0		= 0720	; Default for LDf.
;13327			P.NZ1		= 0721	; Default for FCC Update/Exit.
;13328			P.NZ2		= 0722	; Default for ABSf/NEGf.
;13329			P.NZ3		= 0723	; Default for STCFD/DF Exp = 0 check.
;13330			P.NZ4		= 0724	; Default for CMPF/D FSRC decode.
;13331			P.NZ5		= 0725	; At "Under/overflow".
;13332	;;;		1 01X 11X	; Sub-block for CMPf, ADDf, and TSTf (see P.CMP7).
;13333			P.NZ6		= 0726	; Default for CMPF/D FSRC decode.
;13334			P.CMP7		= 0736	; CMPf for FSRC <> 0.
;13335	;;;		1 01X 111	; Sub-block for AC is zero (see P.CMP8).
;13336			P.NZ7		= 0727	; ADDf for FSRC = 0.
;13337			P.CMP8		= 0737	; CMPf for FSRC = 0.
;13338	
;13339	;;;;;		1 011 XXX	; Abort/miscellaneous assignments.
;13340	;		1 011 0XX	; Sub-block for warm non-io.
;13341	;		1 011 00X	; Sub-block for PIR<16> check.
;13342			P.FPE0		= 0730	; Must abort to ROM[200].
;13343			P.FPE1		= 0731	; Must abort to ROM[200].
;13344			P.FPE2		= 0732	; Warm non-io entry.
;13345	;		RESERVED	= 0733
;13346				;=1*0****0	; Hot SRC/FSRC abort; DST mode 0;
;13347						; Overrides to P.REST0.
;13348			P.FP-END	= 0734	; Breakout warm/hot.
;13349	;		P.CMP7		= 0736	; RESERVED above at FN/FZ overrides.
;13350	;		P.CMP8		= 0737	; RESERVED above at FN/FZ overrides.
;13351	; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  325
; PLADEF.MCD [242,1110]      PLA Address Assignments

;13352	;;;;;		1 100 XXX	; Unused.
;13353	
;13354	;;;;;		1 101 XXX	; Unused.
;13355	
;13356	;;;;;		1 110 XXX	; Mantissa extractor overrides (see "Mantissa Extractors").
;13357			P.MAN0		= 0760	; MULf, MODf, DIVf.  Extract FSRC.
;13358			P.MAN1		= 0761	; MULf, MODf, DIVf.  Extract AC.
;13359			P.MAN2		= 0762	; ADDf/SUBf.  Extract AC.
;13360			P.MAN3		= 0763	; ADDf/SUBf.  Extract FSRC.
;13361			P.MAN4		= 0764	; STCfi.
;13362	
;13363	;;;;;		1 111 XXX	; Miscellaneous assignments.
;13364			P.FPE-CK	= 0770	; Decode exception status.
;13365			P.MOD14		= 0771	; End of MODf.
;13366			P.OPCD1		= 0772	; CMPf, STCfd, and ABSf/NEGf.
;13367			P.NORM		= 0773	; Generalized normalization.
;13368	
;13369	;		End of FP assignments.
;13370	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  326
;                            Cross Reference Listing - Field Names and Defined Values

GPA				327 #	
	BEVNT_ACK		345 #	7160	
	BINIT_OFF		344 #	1376	
	BINIT_ON		343 #	1370	
	FPA_ACK			333 #	7125	
	FPA_OFF			336 #	
	FPA_ON			335 #	
	FPA_RD			331 #	8842	9725	9788	
	FPA_WR			337 #	8848	
	IRL4			352 #	7192	
	IRL5			351 #	7180	
	IRL6			350 #	7168	
	IRL7			349 #	7148	
	LED1_ON			338 #	1595	
	LED2_ON			339 #	1658	
	LED3_ON			340 #	1692	
	LED4_OFF		342 #	1359	7989	
	LED4_ON			341 #	8420	
	NMI_ACK			347 #	7088	
	OPTIONS			330 #	6839	
	OPTIONS_CLR		332 #	1421	
	PWRF_ACK		346 #	7117	
MICROINSTRUCTION		101 #	4344	
NAF				103 #	2162	2168	2176	2183	2215	2229	2236	2286	2301	2316	2374
				2390	2398	2465	2562	2745	2753	2759	2765	2771	2777	2784	2794
				2800	2806	2812	2818	2824	2832	2843	2849	2856	2869	2875	2881
				2923	2943	2949	2955	2961	2967	2992	3001	3039	3049	3093	3142
				3148	3155	3194	3203	3241	3251	3329	3337	3752	4345	4549	4555
				4806	4817	4964	5136	5281	5302	5308	5314	5320	5326	5338	5344
				5350	5356	5362	5441	5447	5721	5746	5751	5915	5947	6033	6139
				6257	6273	6384	6926	6980	6986	7500	7892	7990	8215	8320	8539
				8779	8784	8792	8797	8805	8810	8815	8834	8927	9010	9015	9086
				9155	9160	9165	9273	9342	9351	9356	9369	9374	9425	9700	9764
				10120	10570	10575	10580	10587	10592	10821	10827	10966	10970	11025	11891
				12061	12067	12173	12178	12183	12416	12655	12659	12663	12667	12671	12675
				12679	12683	12687	12691	12695	12699	12703	12707	12711	12715	12733	12737
				12741	12745	12749	12753	12757	12761	12765	12769	12784	12788	12792	12796
				12800	12804	12808	12823	12828	12844	13028	13066	13071	13077	13082	13087
				13092	
	-FN.FZ1			12145 #	
	ABS1			12564	12578 #	
	ABS2			12567	12574 #	
	ABS3			12570 #	12580	
	ABS5			12587	12592	12599 #	
	ABS6			12576	12594 #	
	ABS7			12608	12625 #	
	ADC			4258 #	
	ADD			4522 #	
	ADD12			10689	10695 #	
	ADD2D			10834	10900 #	
	ADD2F			10837	10897 #	
	ADD3			10395	10899	10905 #	
	ADD4D			10841	10855 #	
	ADD5D			10849	10858 #	
	ADD8			10662	10673 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  327
;                            Cross Reference Listing - Field Names and Defined Values


	ADD8A			10666	10669 #	
	ADD8B			10671	10705 #	
	ADD8C			10693	10745 #	
	ADD8D			10303 #	10753	
	ADD8E			10392	10751 #	
	ADDR-ERROR		7278 #	
	ALIGN			8036	8041 #	8044	
	ALIGN1			8039	8046 #	
	APT1			8295	8299 #	
	APT2			8302	8305 #	
	APT3			8310 #	8330	
	ASF10			10947	10989 #	
	ASF12			11000	11006 #	
	ASF13			11058 #	
	ASF5			10982	11008	11015 #	
	ASF6A			10986	10996 #	
	ASF6B			10991	11001 #	
	ASF8D			10847 #	10890	
	ASF9D			10839 #	10887	
	ASF9F			10843 #	10876	
	ASH			5272 #	
	ASH-L			5542 #	5545	
	ASH-R			5287	5551 #	5554	
	ASH-R1			5547 #	
	ASH1			5283 #	
	ASH4			5381 #	5549	
	ASHC			5433 #	
	ASHC-END		5566 #	5578	
	ASHC-L			5460	5570 #	5573	
	ASHC-MASK		5456 #	
	ASHC-NO			5295	5561 #	
	ASHC-R			5472	5580 #	5583	
	ASHC-R1			5332	5575 #	
	ASHC1			5443 #	
	ASHC2			5468 #	
	ASHX-0-OVR		5291 #	
	ASHX-NEG-1		5328 #	
	ASL			4301 #	
	ASR			4294 #	
	BASE-CODE-ABORT		7262 #	
	BIC			4506 #	
	BIS			4514 #	
	BIT			4498 #	
	BPT			6630 #	
	CARR1			8157 #	8208	
	CCC-SCC-NOP		6671 #	
	CFCC1			9770	9784 #	9796	
	CFCC2			9776	9787 #	
	CFCC3			9726	9789	9794 #	
	CFCC4			9786	9798 #	
	CIS			6976 #	
	CLEAR			7835	7838 #	
	CLR			4223 #	
	CLR1			12401 #	12499	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  328
;                            Cross Reference Listing - Field Names and Defined Values


	CLR2			12397	12403	12458	12504 #	
	CLR3			12411	12421 #	12506	
	CLR4			12423	12430	12455	12510 #	
	CLRF0			12483	12497 #	
	CMP			4490 #	
	CMP1			10512	10527 #	
	CMP2			10517	10523 #	
	CMP3			10521	10529	10531 #	
	CMP4			10525	10556 #	
	CMP6			10538	10545 #	
	COM			4230 #	
	CR-LF			7830	7850	8248	8260	8472 #	
	CSM			4875 #	
	CSM-ABORT		4914	4962 #	
	CSM3			4896	4901	4905 #	
	DEC			4244 #	
	DIV			5144 #	
	DIV-END-0		5208	5211 #	
	DIV-END-1		5203	5214 #	
	DIV-MD-0		5132 #	
	DIV-MD-27		5138 #	
	DIV-OVF			5197	5224 #	
	DIV-ZERO		5141	5147	5220 #	
	DIV0			5142	5150 #	
	DIV1			5165	5170 #	5174	
	DIV2			5169	5176 #	
	DIV3			5182	5188 #	
	DIVF0			11734	11737 #	
	DIVF1			11730	11741 #	
	DIVF2			11785	11790 #	
	DIVF3			11789	11818 #	11826	
	DIVF4			11817	11828 #	
	DIVF5			11830	11836 #	11844	
	DIVF6			11835	11846 #	
	DIVF7			11792	11800 #	11803	
	DOP-DM0			4551 #	
	DOP-SM0			4545 #	
	DPPC			1906 #	
	DST-ADDR		3150 #	
	DST-ADDR-MD-4		3331 #	
	DST-MODE-1		2740 #	
	DST-MODE-2		2917 #	
	DST-MODE-3		3130 #	
	DST-MODE-37		3144 #	
	DST-MODE-4		3323 #	
	DST-MODE-5		3532 #	
	DST-MODE-6		3744 #	
	DST-MODE-7		3935 #	
	DST-RD-0		2755 #	
	DST-RD-1		2749 #	
	DST2			9412	9419	9438 #	9503	
	DST4			9487	9499 #	9514	
	EFADD			10810	10851 #	10883	
	EFSUB			10815	10881 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  329
;                            Cross Reference Listing - Field Names and Defined Values


	EMT			6642 #	
	ENTER-ODT		1721	6864	7208	7420	7553	7555	7825 #	
	ERROR			7897	7901 #	
	EVENT			7157 #	
	EXACT-0A		10371	10375 #	
	EXACT-0B		10377	11170	11205	12901 #	
	EXACT-0C		10595 #	12279	12903	
	EXACT-0D		10597	12909 #	
	EXACT-0F		12916	12926	12928 #	
	EXTR0-0			5298 #	
	EXTR0-1			5304 #	
	EXTR0-2			5310 #	
	EXTR0-3			5316 #	
	EXTR0-4			5322 #	
	EXTR1-0			5334 #	
	EXTR1-1			5340 #	
	EXTR1-2			5346 #	
	EXTR1-3			5352 #	
	EXTR1-4			5358 #	
	FDST11			9464	9475 #	
	FDST4			9390	9397 #	9403	
	FDST4A			9393 #	
	FDST4B			9395	9401 #	
	FDST5			9494 #	9524	
	FDST7			9447	9453 #	
	FDST8			9497	9512 #	
	FDST9			9492	9517 #	
	FIUV-CK			10315	10372	10518	10602	10667	11166	11735	12568	12948 #	
	FIUV1			9184	9792	11739	12967	13117 #	
	FIX-R			5168	5183 #	
	FN.-FZ1			12142 #	
	FN.FZ1			12139 #	
	FNZ-OK1			12136	12141	12144	12147	12148 #	
	FORM2			11600	11605 #	
	FORM2A			11604	11609 #	
	FORM3			11607	11615 #	
	FP-ABRT			13024	13026 #	
	FP-TRAP			7137	13137 #	
	FPA-EX			7122 #	
	FPA1			8843	8854 #	
	FPA2			8849	8858 #	
	FPD0			8719	8749 #	
	FPD1			8871	8890 #	
	FPD2			8828	8850 #	8857	8862	
	FPD3			8734	8741 #	
	FPE-CK1			9637	9640 #	
	FPS-STR1		10326	12858 #	
	FSRC10			9236	9244 #	
	FSRC11			9267	9278 #	
	FSRC27			9208	9213 #	
	FSRC3			10424	10429	10434	10439	10445 #	10453	
	FSRC3A			10442 #	
	FSRC3B			10444	10449 #	
	FSRC3C			10451 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  330
;                            Cross Reference Listing - Field Names and Defined Values


	FSRC5			9251	9258 #	
	FSRC6			9289	9296 #	9319	
	FSRC7			9294	9312 #	
	GET-VECTOR		7264	7271 #	7519	
	GO1			8001	8005 #	
	GO2			8006	8009 #	
	H-POKH-F		6853 #	
	H-POKH-T0		6860 #	
	H-POKH-T1		6866 #	
	HALT			6836 #	
	HALT-LINE		7204 #	
	ID1			105 #	4278	4338	4351	4358	4365	4372	4379	4386	4393	4400	4407
				4561	4568	4575	4830	5058	5064	5217	5384	5540	6507	6683	6689
				8717	8722	8727	8732	9667	9674	9681	9688	9801	12232	
	ID2			106 #	4721	
	ID3			107 #	
	ILL-MD			9179	9182 #	
	ILL-OP			9744	9790 #	
	INC			4237 #	
	INPUT			7863	8296	8303	8363 #	8373	
	INT			9649	13001 #	
	INTERRUPT		7074 #	
	IO-TIMEOUT		7296 #	
	IOT			6636 #	
	IRDF			108 #	1903	5941	
	IREQ			7149	7169	7181	7194 #	
	IRQ-L4			7189 #	
	IRQ-L5			7177 #	
	IRQ-L6			7165 #	
	IRQ-L7			7145 #	
	JMP67-000		6266 #	
	JMP6X-010		6274 #	
	JMPXX			5717 #	
	JOP1-0			5939 #	
	JOP1-1			5715	5823	5922	5929	5943 #	6039	
	JOP1X			5711 #	
	JOP2-0			5814 #	
	JOP2-1			5805	5819 #	
	JOP2X			5801 #	
	JOP3X			5909 #	
	JOP4			6035 #	
	JOP4X			6027 #	
	JOP5			6132	6135 #	
	JOP5X			6126 #	
	JOP67			6253 #	
	JOP6X			6246 #	
	JOP7			6375	6378 #	
	JOP7X			6371 #	
	JSR-0			5753 #	
	JSR-1			5740	5749 #	
	JSR1			5734 #	
	JSR37			5917 #	
	JSR37-100		5979	6280 #	
	JSR67-001		6269 #	6279	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  331
;                            Cross Reference Listing - Field Names and Defined Values


	JSR6X-011		6250	6277 #	
	JSR7XX			5742 #	
	JSRO37			5975 #	
	KM-SP			7532	7542 #	
	LDCFD0			10367	10380 #	
	LDCFD2			10388	10393 #	
	LDCIF1			9911	9918 #	
	LDCIF2			9938	9943 #	
	LDEXP1			9874	12113	12118 #	12126	
	LDEXP1A			12117	12122 #	
	LDEXP2			12120	12127 #	
	LDF2			10314	10328 #	
	LDF3			10310	10318	10322	10324 #	10330	
	LDF4			10320 #	12930	
	LDFPS-N			9710 #	9783	9824	
	LINE			8228	8246 #	
	LINE1			8247	8250 #	
	LINE2			8251	8254 #	
	LINE3			8222	8258 #	
	LINE4			8259	8262 #	
	LINE5			8263	8267 #	
	LINE6			8270	8279 #	
	LOCKED			2845 #	
	LOCKED2			4813 #	
	M-ABORT			7515 #	
	M-ABORT1		7518	7521 #	
	M-TRAP			5673	6634	6640	6646	6652	6850	6869	7008	7012	7120	7163	7196
				7263	7361 #	7527	7534	13154	
	M-TRAP0			7363	7366	7372 #	
	M-TRAP1			7111	7364 #	
	M-TRAP2			7091	7097	7143	7155	7175	7187	7202	7367 #	
	MARK			6705 #	
	MEM-NEW-111		8192	8236 #	
	MEM-NO-010		8226 #	8243	
	MFPI-MFPD		4670 #	
	MFPS			4320 #	
	MFPS0			4326 #	
	MFPT			6883 #	
	MMU-ABORT		7284 #	
	MOD0			11435	11442 #	
	MOD0A			11439	11445 #	
	MOD10			11527	11532 #	
	MOD11			11523	11528 #	11536	
	MOD12			11530	11537 #	
	MOD2			11461	11465 #	
	MOD2A			11454	11459 #	
	MOD2B			11458	11463 #	
	MOD3			11472	11477	11482 #	
	MOD3A			11481	11486 #	
	MOD3B			11484	11488 #	
	MOD4			11489	11576 #	
	MOD5			11497	11571 #	
	MOD9			11577	11581 #	
	MOD9A			11584 #	11993	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  332
;                            Cross Reference Listing - Field Names and Defined Values


	MOV			4476 #	
	MOV-PC			5757	5818	6276	6286 #	
	MOVS			4484 #	
	MTPI-MTPD		4713 #	
	MTPI-MTPD2		4730 #	
	MTPS			4606 #	
	MTPS-KM			4618	4624 #	
	MTPS1			4623	4626 #	
	MUL			5015 #	
	MUL10			11203 #	
	MUL12			11200	11207 #	
	MUL2			5033 #	5048	
	MUL20			12168	12235 #	12247	
	MUL20A			12221	12237	12262 #	
	MUL20B			12226	12255 #	
	MUL20C			12224 #	12243	
	MUL20D			9537	12229 #	
	MUL20E			12213	12242 #	
	MUL20F			12217	12246 #	
	MUL8			11157	11174 #	11743	
	MUL9			11165	11168 #	
	MULD0			11218 #	
	MULD0A			11220	11264 #	
	MULD1			11266	11270 #	11273	
	MULD3			11281	11286 #	11289	
	MULD4			11299	11303 #	11306	
	MULD5			11302	11311 #	
	MULD6			11318	11323 #	11326	
	MULD7			11322	11333 #	
	MULD9			11341 #	11557	
	MULF0			11214	11223 #	
	MULF0A			11225	11229 #	
	MULF1			11231	11236 #	11239	
	MULTIPLE-ABORT		7496 #	
	MULX5			12045	12050	12055	12086 #	
	MULX5A			12083	12090 #	
	MULX6			12072 #	12094	
	MULX6A			12074	12095 #	
	MULX7			12077 #	12088	
	MULX7A			12079	12098 #	
	N-MUL			5044	5049 #	5052	
	NEG			4251 #	
	NEG-MUL			5022	5041 #	
	NEW-STATE		7950	7958 #	
	NO-INT			7210 #	
	NOP-PF			1911	4221	4228	4235	4242	4249	4256	4263	4270	4285	4292	4299
				4306	4312	4318	4324	4330	4333 #	4482	4488	4496	4504	4512	4520
				4527	4534	4686	4737	4836	5213	5222	5228	5563	5589	5595	6761
				6762	6887	9570	9714	9732	10612	12202	12207	12877	
	NOP-PF1			5537 #	
	NORM-D			11949 #	12007	
	NORM-F			9951	11946	11952 #	
	NORM-H			11965	11995 #	
	NORM-K			11971 #	11976	11984	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  333
;                            Cross Reference Listing - Field Names and Defined Values


	NORM-L			11978 #	11981	
	NORM-R			11986 #	11989	
	NOTE 1			4103 #	
	NOTE 2			4111 #	
	NOTE 3			4126 #	
	NOTE 4			4132 #	
	NRM			10924	10938	11068	11075	11848	11875 #	
	NRM0			11909	11914 #	
	NRM0A			11913	11918 #	
	NRM1			11927	11932 #	
	NRM1A			11931	11936 #	
	NXM-ABORT		7290 #	
	OCTAL1			7962	7966 #	7969	
	ODD-OVR			2296 #	
	ODT-ABORT		7513	7896 #	
	OUTPUT			7854	7876	7898	8002	8007	8063	8256	8264	8281	8331	8419 #	8474
				8480	8554	
	OUTPUT1			8423 #	8432	
	OVF-RET			7365	7423 #	
	OVF-SET-CPU		7110 #	7546	
	P-ASCII			8271	8550 #	
	P-MUL			5030	5036 #	5039	
	P-U-T1			1575 #	7506	
	P-U-T2			1589	1594 #	
	P-U-T3			1592	1598 #	
	P-U-T4			1635	1655	1661 #	
	P-U-T5			1646	1657 #	
	P.ADD1			10802	10808	13307 #	
	P.ALN0			10958	10962	11060	11066	11071	13271 #	
	P.ALN1			11018	11031	11034	11039	13272 #	
	P.ALN2			11050	13273 #	
	P.ALN3			11041	11044	11047	13274 #	
	P.ALN5			11052	11055	13276 #	
	P.ASD			7276	7280	7286	7292	7298	7304	13208 #	
	P.ASF2			10845	10853	10857	10860	10945	10956	10960	10964	10968	13309 #	
	P.ASHC			5568	5587	5592	13211 #	
	P.CMP7			10553	10568	10573	10578	13334 #	
	P.CMP8			10558	10585	13337 #	
	P.CSM			4891	4894	4899	13216 #	
	P.DIV			5198	5201	5206	13207 #	
	P.DST			13255 #	
	P.DST-E			9330	9349	9354	9380	9976	10004	10053	13240 #	
	P.DST0			13251 #	
	P.DST1			9436	13238 #	
	P.EXP1			10108	10113	10118	13280 #	
	P.EXP2			11148	11155	13281 #	
	P.EXP3			11193	11198	13282 #	
	P.EXP4			11723	11728	13283 #	
	P.EXP5			10362	10365	13284 #	
	P.EXP6			10648	10655	10660	13285 #	
	P.EXP7			10682	10687	13286 #	
	P.FDST			13256 #	
	P.FDST-E		9336	9340	9388	12322	12331	12512	12624	12627	13239 #	
	P.FDST0			13252 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  334
;                            Cross Reference Listing - Field Names and Defined Values


	P.FDST1			9433	13237 #	
	P.FDST2			9451	13234 #	
	P.FDST3			9474	13233 #	
	P.FORM+1		11539	11578	11598	13323 #	
	P.FP-END		9382	9399	9430	9440	9455	9477	9535	9540	9545	9580	9597	13348 #
				
	P.FPC0			8751	8876	8892	8896	8910	8915	8920	8925	8930	8935	8943	8949
				8960	8965	13289 #	
	P.FPC1			13290 #	
	P.FPC2			8729	8826	13291 #	
	P.FPC3			8724	8869	8874	13292 #	
	P.FPC4			8957	8962	8974	8985	13293 #	
	P.FPC5			13294 #	
	P.FPC6			13295 #	
	P.FPC7			8946	13296 #	
	P.FPE-CK		9644	9647	9652	13364 #	
	P.FPE0			9654	13342 #	
	P.FPE1			8745	8839	8846	8852	9599	9635	13343 #	
	P.FPE2			8738	9768	13344 #	
	P.FSRC			8912	8917	8922	8932	8937	8982	8987	9171	9233	9239	9286	13258 #
				
	P.FSRC-R		9093	9134	9190	9198	9215	9260	9280	9308	9925	10086	10245	10298
				10356	10422	10427	10432	10437	12549	13314 #	
	P.FSRC-R0		9193	9222	13312 #	
	P.FSRC-R1		10093	10098	10447	10505	10646	10651	11146	11721	13275 #	
	P.FSRC0			9173	9188	9206	9220	13254 #	
	P.FSRC1			9246	9249	13242 #	
	P.FSRC2			9256	13236 #	
	P.FSRC3			9277	13235 #	
	P.HLT-CK0		7368	7413	7418	13209 #	
	P.HLT-CK1		7523	7526	7552	13210 #	
	P.INT0			11269	11279	11499	11516	11820	11823	13261 #	
	P.INT1			10156	10159	10162	11285	11295	11507	11510	11513	11838	11841	13262 #	
	P.INT2			10131	11313	11316	13263 #	
	P.INT3			10146	10149	10165	10168	13264 #	
	P.INT4			11954	11957	13277 #	
	P.ISD			7038	7081	7085	7095	7101	7116	7124	7141	7147	7153	7159	7167
				7173	7179	7185	7191	7200	7206	7212	13214 #	
	P.MAN0			11176	11181	13357 #	
	P.MAN1			11183	11188	13358 #	
	P.MAN2			10698	10787	13359 #	
	P.MAN3			10675	10680	13360 #	
	P.MAN4			10095	10100	10103	13361 #	
	P.MOD1			11447	11452	11475	13305 #	
	P.MOD13			11467	11470	13304 #	
	P.MOD14			11538	11544	11551	13365 #	
	P.MOD20			11631	11634	13303 #	
	P.MOD6			11518	11521	13318 #	
	P.MODF0			11879	11882	13226 #	
	P.MODF1			12911	12914	13225 #	
	P.MUL			5035	5055	5061	13206 #	
	P.MULX8			11588	12100	12111	13319 #	
	P.NORM			11959	11962	12653	12657	12661	12665	12669	12673	12677	12681	12685	12689
				12693	12697	12701	12705	12709	12713	13367 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  335
;                            Cross Reference Listing - Field Names and Defined Values


	P.NRM0			10907	12053	13269 #	
	P.NRM1			11884	11907	11925	11944	12043	13267 #	
	P.NRM2			11433	13266 #	
	P.NRM3			11572	11916	11920	11934	11938	11973	12048	13268 #	
	P.NZ0			10305	10308	13326 #	
	P.NZ1			12131	12134	13327 #	
	P.NZ2			12559	12562	13328 #	
	P.NZ3			12387	12390	13329 #	
	P.NZ4			10507	10510	13330 #	
	P.NZ5			12150	12166	12171	12176	12181	13331 #	
	P.NZ6			10251	13333 #	
	P.NZ7			10707	13336 #	
	P.ODT			7873	7875	7890	7917	7923	7929	7945	7954	7983	7997	8024	8067
				8085	8095	8101	8108	8124	8139	8151	8168	8188	8196	8204	8212
				8294	13205 #	
	P.OPCD1			10533	10536	10541	12406	12409	12414	12572	12583	12590	13366 #	
	P.OPCD2			9922	9933	9936	10137	10140	10382	10386	11209	11212	11783	13320 #	
	P.OPTION		1703	1706	1719	1724	1729	13212 #	
	P.POKH			1429	1432	1437	1442	13213 #	
	P.REST0			9589	12601	12606	13300 #	
	P.REST1			13055	13058	13069	13080	13085	13090	13301 #	
	P.RTX			6554	6557	6562	13217 #	
	P.SRC			9051	9084	9099	13257 #	
	P.SRC-R			9053	9063	9914	13316 #	
	P.SRC0			9060	13253 #	
	P.SRC1			9090	13243 #	
	P.STF			12306	12320	12325	13222 #	
	P.STR-AC1		12860	12863	13322 #	
	P.SUB1			10801	10813	13308 #	
	P.XCC			6677	6680	6686	13215 #	
	PARITY			7083 #	
	PARITY-ABORT		7302 #	
	PC-RD			5925 #	
	PF-OVR-1		4347 #	
	PF-OVR-10		4557 #	
	PF-OVR-11		4564 #	
	PF-OVR-12		4571 #	
	PF-OVR-2		4354 #	
	PF-OVR-3		4361 #	
	PF-OVR-4		4368 #	
	PF-OVR-5		4375 #	
	PF-OVR-6		4382 #	
	PF-OVR-7		4389 #	
	PF-OVR-8		4396 #	
	PF-OVR-9		4403 #	
	PIRQ-L3-1		7198 #	
	PIRQ-L4			7183 #	
	PIRQ-L5			7171 #	
	PIRQ-L6			7151 #	
	PIRQ-L7			7139 #	
	POP			7583 #	12955	12963	
	POS-MUL			5026	5027 #	
	POWER-FAIL		7114 #	
	POWER-UP		7503 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  336
;                            Cross Reference Listing - Field Names and Defined Values


	PPC-INVALID		1895 #	
	PRINT-16		7836	8057	8519 #	
	PRINT-22		8252	8510 #	
	PRINT-PC		7829	7832 #	
	PRINT-WORD		8055 #	8080	8091	
	PRINT1			8516	8526 #	
	PRINT2			8528	8534	8542 #	
	PRINT3			8530 #	8548	
	PROMPT			7839	7848 #	7903	8135	8146	8163	8173	
	PROMPT1			7849	7852 #	
	PSW-LD-PF		4631 #	6932	
	PSW-LOAD		1716	1738 #	4948	7362	7425	8010	
	PSW-LOAD1		1743 #	7415	
	PWR-UP-ODT		1358 #	7507	8011	
	PWR-UP1			1362	1412 #	
	PWR-UP2			1420 #	1434	
	PWR-UP3			1439	1450 #	
	PWR-UP4			1451	1459 #	
	PWR-UP5			1683	1693	1701 #	
	PWR-UP6			1726	1734 #	
	RD-ADDR			3136	3140 #	3544	3947	
	RE-SYNC			1745	1901 #	6268	6282	6288	6559	6564	6615	6723	
	READ			7840	8372	8375 #	
	REG-NEW-101		8200	8231 #	
	REG-NO-000		8220 #	8233	
	RESET			6749 #	
	RESET-NOP		4633	6760 #	6919	12244	12248	
	RESET-SUB		1365	1369 #	6752	
	RESET1			1374	1378 #	1381	
	RESET2			1377	1384 #	
	RESET3			1386	1391 #	1398	
	RESET4			1390	1399 #	
	RESET5			1401	1458	1463	8386	8537 #	
	REST-GP			12993	13006	13025	13049 #	13128	
	REST-GP1		13060	13094 #	
	RESTORE			7535	7556	7557 #	
	RETN1			8473	8478 #	
	RETURN			8383 #	8441	
	RFS			109 #	7214	7288	7306	7327	7410	7561	7585	11621	11644	13096	
	RO-M27-1		2939 #	
	RO-M27-2		2945 #	
	RO-M27-3		2951 #	
	RO-M27-4		2957 #	
	RO-M27-5		2963 #	
	RO-OVR-1		2796 #	
	RO-OVR-10		3235 #	
	RO-OVR-11		3243 #	
	RO-OVR-2		2802 #	
	RO-OVR-3		2808 #	
	RO-OVR-4		2814 #	
	RO-OVR-5		2820 #	
	RO-OVR-6		2826 #	
	RO-OVR-7		2835 #	
	RO-OVR-8		3033 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  337
;                            Cross Reference Listing - Field Names and Defined Values


	RO-OVR-9		3041 #	
	ROL			4287 #	
	ROR			4280 #	
	RSYNC-PF		6480	6485	6490	6495	6503	6504 #	
	RTI-RTT			6526 #	
	RTS			6584 #	
	RTS4			6588	6593	6598	6600 #	
	RTS6			6604	6611	6613 #	
	RTX_CONVERGE		6548	6551 #	
	RTX_KERNEL		6535	6549 #	
	SBC			4265 #	
	SET-CPU			6851	6870	7112	7282	7294	7300	7319 #	
	SETX			9751	9758	9781 #	
	SLASH			8056	8059 #	
	SLASH-AA		8032 #	8097	8255	
	SLASH-BB		8076 #	8103	8280	
	SLASH-C			8089 #	8110	
	SOB			6497 #	
	SOP-DM0			4341 #	
	SPL			6915 #	
	SPL-KM			6918	6924 #	
	SPL-KM1			6928 #	
	SRC-ADDR-0		2393 #	
	SRC-ADDR-X		2312 #	
	SRC-MODE-1		2158 #	
	SRC-MODE-2		2209 #	
	SRC-MODE-27-37		2224 #	
	SRC-MODE-3		2280 #	
	SRC-MODE-4		2368 #	
	SRC-MODE-47-57		2377 #	
	SRC-MODE-5		2459 #	
	SRC-MODE-6-7		2556 #	
	SRC-RD-X		2164 #	
	SRC-RSYNC		2381	2384 #	
	SRC3			9074	9081	9091 #	9117	
	SRC4			9102	9113 #	
	SRC5			9112	9126 #	
	SSFF			7509 #	
	ST-CPY-CC		10043 #	10125	10196	10203	
	STACK-OVF		7099 #	
	STCC-N			9720	9724 #	
	STCF0			12360	12374 #	
	STCFD0			12392	12400	12404 #	
	STCFD3			12420	12426 #	
	STCFD5			12427	12438 #	
	STCFD6			12429	12441 #	
	STCFD7			12440	12444 #	
	STCFD8			12449	12456 #	
	STCFI0			10115	10128 #	
	STCFI1			10129	10152 #	
	STCFI3			10142	10147 #	
	STCFI7			10176	10182	10190 #	
	STCFI8			10136	10195	10199 #	
	STR-AC7			12865	12875 #	12881	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  338
;                            Cross Reference Listing - Field Names and Defined Values


	STR-AC8			12874	12879 #	
	STST0			8887	8894 #	
	SUB			4529 #	
	SUB-TOGGLE		10930	10936 #	
	SUB2D			10866	10918 #	
	SUB2F			10869	10915 #	
	SUB3D			10921	10931 #	
	SUB3F			10916	10928 #	
	SUB4			10917	10922 #	11235	11345	11546	11799	
	SUB4D			10873	10885 #	
	SUB5D			10879	10888 #	
	SWAB			4217 #	
	SXT			4308 #	
	T-BIT			7093 #	
	TRAP			6648 #	
	TST			4272 #	
	TST-DF			9547	12201 #	
	TST-FI			9542	12205 #	
	TST-FI1			9541	9564 #	
	TSTF3			10276	10563	10605	10608	10610 #	
	TSTF4			10274 #	10601	
	TSTSET			4819 #	
	TSTSET-WRTLCK		4802 #	
	UN-OV			12259	12269 #	
	UN-OV0			12270	12277 #	
	UN-OV1			9567	12203	12272 #	13119	
	UN-OV2			12274	13126 #	
	UN-OV3			13127	13129 #	
	WAIT			7031 #	
	WAIT1			7036 #	7043	
	WAIT2			7037	7040 #	
	WAITA			7853	7857 #	8062	
	WAITB			7861 #	7919	7925	7931	7965	
	WAITC			7862	7865 #	
	WCS			6982 #	
	WO-OVR-1		2761 #	
	WO-OVR-2		2767 #	
	WO-OVR-3		2773 #	
	WO-OVR-4		2779 #	
	WO-OVR-5		2787 #	
	WO-OVR-6		2987 #	
	WO-OVR-7		2994 #	
	WO-OVR-8		3189 #	
	WO-OVR-9		3196 #	
	WRD-OVR-1		2171 #	
	WRD-OVR-2		2178 #	
	WRD-OVR-3		2232 #	
	WRD-OVR-4		2851 #	
	WRD-OVR-5		2865 #	
	WRD-OVR-6		2871 #	
	WRD-OVR-7		2877 #	
	WRD-OVR-8		3089 #	
	WRITE			8431	8434 #	
	WRTLCK			4832 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  339
;                            Cross Reference Listing - Field Names and Defined Values


	XOR			4314 #	
	ZERO+1			11573	11629 #	12927	
	ZERO+1A			11636	11642 #	11648	
	ZERO+1B			11641	11646 #	
	ZERO+1C			11639 #	
OUTC_CONTROL			410 #	
	CLR_ALL			420 #	
	CLR_CPFF		415 #	1443	
	CLR_ITFF		418 #	6563	
	CLR_PTYFF		419 #	7086	7984	
	CLR_SOVFF		417 #	7424	
	CLR_SSFF		413 #	
	CLR_SVC_FFS		421 #	7274	13002	
	CPY_T-BIT		416 #	6558	
	CPY_TBIT-CLR_SSFF	422 #	1744	
	INI_ALL			423 #	1364	
	SET_CPFF		414 #	1438	
	SET_SSFF		412 #	7826	
OUTS_CONTROL			396 #	
	ABORTS			399 #	7272	7497	
	CLK_FPS			405 #	1415	9705	9782	9823	
	INTERRUPTS		398 #	7034	7042	7077	9641	
	LD_CNTR			403 #	10141	10155	10981	11506	
	LD_FPS			400 #	8750	8870	8911	9643	10107	10325	10361	10520	10528	10596	10791
				11192	11878	11958	12391	12558	13052	
	LD_PIR			402 #	1426	4888	5275	6843	7868	10246	10299	10357	10446	10524	10550
				10670	10674	10752	11175	11953	12128	12130	12384	12550	
	LD_PIR_CNTR		407 #	5436	
	MSTK			401 #	
	PSW			404 #	1739	4632	6552	7414	7419	7987	
RMMU				358 #	
	AC20.0			373 #	9197	9394	
	AC20.1			374 #	9194	9402	
	AC20.2			375 #	9189	9398	
	AC20.3			376 #	9172	9389	
	AC76+1.0		381 #	11612	11647	
	AC76+1.1		382 #	11614	11640	
	AC76+1.2		383 #	11616	11643	
	AC76+1.3		384 #	11620	11635	
	AC76.0			377 #	10450	12123	12330	12880	
	AC76.1			378 #	10452	12116	12328	12375	12873	
	AC76.2			379 #	10423	10428	10433	10438	12112	12321	12326	12410	12864	
	AC76.3			380 #	9859	10029	10085	10506	10647	10652	11147	11722	12149	12305	12382
				12405	12859	
	CCR			390 #	
	CPAR			360 #	8047	8323	9941	10443	10532	10552	12125	12998	
	CPU			361 #	1428	1578	1591	7320	7324	
	FEA			363 #	8895	9975	13151	
	FEATMP			367 #	7132	8742	8827	8845	8851	9329	9335	9579	9588	9598	9648
				
	FEC			366 #	8838	8886	9972	13144	
	FPS			364 #	1413	7136	8737	8744	9711	9863	9944	9995	10044	10052	10250
				10304	10376	10511	10611	10706	11169	11204	11883	12054	12167	12359	12482
				12511	12554	12600	12876	12949	13118	13142	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  340
;                            Cross Reference Listing - Field Names and Defined Values


	HIT_MISS		391 #	
	MMR0			386 #	1392	
	MMR1			387 #	
	MMR3			388 #	1394	4881	
	MMUTMP			370 #	8921	8926	8936	13065	13076	
	MMUTMP2			369 #	
	PIRQ			389 #	
	SIR			393 #	8077	
	SR			392 #	5018	5164	5177	9946	10145	10148	10381	10814	11040	11056	11059
				11230	11265	11280	11284	11296	11301	11312	11434	11480	11526	11529	11791
				11798	11816	11847	11950	11972	12000	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  341
;                            Cross Reference Listing - Macro Names

16-BIT MAP			1124 #	1581	1638	1652	1687	8368	8379	8427	8438	
ACNEG.B [,]			768 #	
ACNEG.B* [,]			771 #	
ACNEG.L [,]			770 #	
ACNEG.L* [,]			773 #	
ACNEG.W [,]			769 #	
ACNEG.W* [,]			772 #	
ADC.B [,]			698 #	
ADC.B* [,]			701 #	4261	
ADC.L [,]			700 #	11334	12093	
ADC.L* [,]			703 #	
ADC.W [,]			699 #	
ADC.W* [,]			702 #	10175	10181	
ADD.B [,]			677 #	7964	
ADD.B* [,]			680 #	
ADD.L [,]			679 #	5186	10898	11067	11233	12419	
ADD.L* [,]			682 #	10901	11072	11321	12091	
ADD.W [,]			678 #	2561	3751	3942	6267	6275	6278	6379	6712	8969	8986	11983
				
ADD.W* [,]			681 #	4525	
ADDC.B [,]			684 #	
ADDC.B* [,]			687 #	
ADDC.L [,]			686 #	10903	11074	
ADDC.L* [,]			689 #	
ADDC.W [,]			685 #	
ADDC.W* [,]			688 #	
AND.B [,]			840 #	
AND.B* [,]			843 #	
AND.L [,]			842 #	11446	11517	11533	
AND.L* [,]			845 #	
AND.W [,]			841 #	1732	6546	10002	
AND.W* [,]			844 #	
ANNEG.B [,]			782 #	
ANNEG.B* [,]			785 #	
ANNEG.L [,]			784 #	5159	5191	9921	9932	10191	
ANNEG.L* [,]			787 #	5151	
ANNEG.W [,]			783 #	5212	5215	
ANNEG.W* [,]			786 #	
AOBC.B [,]			733 #	
AOBC.B* [,]			736 #	
AOBC.L [,]			735 #	
AOBC.L* [,]			738 #	
AOBC.W [,]			734 #	6479	6484	6489	6494	
AOBC.W* [,]			737 #	
AR []				1042 #	1580	1637	1651	1686	2161	2315	2396	3541	3945	4938	6136
				6382	7382	8049	8367	8378	8426	8954	8972	9114	9129	9303	
ARD.B []			1047 #	2371	3326	
ARD.W []			1048 #	2462	3535	4677	4919	5944	6030	6129	6270	7395	8950	9100
				9110	9287	9292	9297	9315	9485	
ARG.W []			1058 #	1421	6839	7125	7148	7168	7180	7192	8842	9725	9788	
ARI.B []			1044 #	2212	8325	
ARI.W []			1045 #	1707	1711	2283	3133	4716	5815	5820	5912	6529	6537	6601
				6608	6717	7376	8944	9072	9079	9234	9240	9250	9266	
ASL.B [,]			925 #	6710	
ASL.B* [,]			928 #	4304	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  342
;                            Cross Reference Listing - Macro Names


ASL.L [,]			927 #	7967	8384	8511	8513	8531	8543	9867	9937	10032	10692	10844
				10852	10906	10923	10946	11466	11788	12380	
ASL.L* [,]			930 #	5571	10840	10848	
ASL.Q [,]			932 #	10166	10394	11460	11933	11979	
ASL.Q* [,]			933 #	11342	11457	11554	11930	
ASL.W [,]			926 #	8315	8318	10746	13146	
ASL.W* [,]			929 #	5543	
ASR.B [,]			901 #	
ASR.B* [,]			904 #	4297	
ASR.L [,]			903 #	5581	8042	10750	11606	11618	12078	12119	
ASR.L* [,]			906 #	5576	11603	12073	
ASR.W [,]			902 #	5552	12206	
ASR.W* [,]			905 #	4825	5548	
AW []				1050 #	1400	1460	2743	3153	3334	4681	4932	5737	7403	8130	8237
				8437	9500	
AWD.B []			1055 #	
AWD.W []			1056 #	1455	4922	4927	7398	9490	9495	9520	
AWG.W []			1060 #	1359	1370	1376	1595	1658	1692	7088	7117	7160	7989	8420
				8848	
AWI.B []			1052 #	2920	
AWI.W []			1053 #	9008	9410	9417	9446	9463	
BIC.B [,]			847 #	6681	
BIC.B* [,]			850 #	4509	
BIC.L [,]			849 #	11522	11535	12584	
BIC.L* [,]			852 #	
BIC.W [,]			848 #	
BIC.W* [,]			851 #	
BIS.B [,]			854 #	6687	9799	
BIS.B* [,]			857 #	4517	
BIS.L [,]			856 #	
BIS.L* [,]			859 #	
BIS.W [,]			855 #	4822	6547	7322	13140	
BIS.W* [,]			858 #	
BIT.B [,]			868 #	
BIT.B* [,]			871 #	4501	
BIT.L [,]			870 #	
BIT.L* [,]			873 #	
BIT.W [,]			869 #	
BIT.W* [,]			872 #	
CLR.B [,]			819 #	
CLR.B* [,]			822 #	4226	
CLR.L [,]			821 #	7858	9211	10391	11016	11213	11582	11585	11587	12422	12505	12595
				12597	12910	12929	
CLR.L* [,]			824 #	10124	10200	
CLR.W [,]			820 #	1379	1462	6708	8538	9207	10173	11630	12915	
CLR.W* [,]			823 #	
CMP.B [,]			789 #	
CMP.B* [,]			792 #	4493	
CMP.L [,]			791 #	
CMP.L* [,]			794 #	
CMP.W [,]			790 #	
CMP.W* [,]			793 #	
CNEG.B [,]			761 #	
CNEG.B* [,]			764 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  343
;                            Cross Reference Listing - Macro Names


CNEG.L [,]			763 #	
CNEG.L* [,]			766 #	
CNEG.W [,]			762 #	
CNEG.W* [,]			765 #	
COM.B [,]			826 #	
COM.B* [,]			829 #	4233	
COM.L [,]			828 #	10937	
COM.L* [,]			831 #	
COM.W [,]			827 #	10654	
COM.W* [,]			830 #	
CONSOLE MODE			1132 #	8050	8131	8238	8326	
D SPACE				1120 #	2790	2839	2997	3045	3199	3247	
DADP.B []			969 #	
DADP.B* []			972 #	
DADP.L []			971 #	
DADP.L* []			974 #	
DADP.W []			970 #	
DADP.W* []			973 #	
DEC.B [,]			719 #	
DEC.B* [,]			722 #	4247	
DEC.L [,]			721 #	
DEC.L* [,]			724 #	
DEC.W [,]			720 #	6500	11453	11926	
DEC.W* [,]			723 #	
DECR CNTR			1114 #	1380	1397	5038	5051	5172	5544	5553	5572	5582	7968	8043
				8319	8533	10161	10167	11017	11033	11046	11238	11272	11288	11305	11325
				11512	11802	11825	11843	11964	11980	11988	
DIVS.L [,]			956 #	11801	
DIVS.L* [,]			958 #	5171	
DIVS.W [,]			955 #	
DIVS.W* [,]			957 #	
DUMMY				13198 #	
I SPACE				1119 #	2782	2990	3192	4939	9009	
INC.B [,]			691 #	
INC.B* [,]			694 #	4240	
INC.L [,]			693 #	12087	
INC.L* [,]			696 #	
INC.W [,]			692 #	11908	
INC.W* [,]			695 #	
INPR.L [,]			1066 #	5177	11056	11284	11301	11434	11526	11798	11816	11847	11972	12000
				12375	
INPR.W [,]			1065 #	4881	7132	7136	7320	8737	8742	8744	8827	8838	8886	8895
				9172	9189	9194	9197	9329	9335	9579	9588	9859	9863	9944	9972
				9975	9995	10029	10044	10085	10250	10304	10376	10423	10428	10433	10438
				10450	10452	10506	10511	10552	10647	10652	10706	11147	11169	11204	11722
				11883	12054	12125	12305	12321	12326	12328	12330	12359	12382	12405	12410
				12482	12554	12949	12998	13065	13076	13118	
JAC []				1099 #	5168	5197	12427	
JAN []				1097 #	5022	8372	8431	9567	10129	10136	10195	10801	10916	10921	11489
				11497	13148	
JAV []				1100 #	12429	
JAZ []				1098 #	1589	5141	5147	7527	7553	7873	10131	11499	12202	12243	12247
				12270	12449	12955	12963	
JC []				1103 #	9541	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  344
;                            Cross Reference Listing - Macro Names


JKM []				1105 #	4618	6535	6752	6845	6918	7532	
JMP [,]				1107 #	6979	6985	9636	
JN []				1101 #	
JV []				1104 #	
JZ []				1102 #	
KERNEL MODE			1130 #	7377	7383	
LADD.B [,]			1012 #	
LADD.L [,]			1014 #	8227	
LADD.W [,]			1013 #	8221	9865	10114	10119	11199	11742	13081	
LAND.B [,]			1024 #	4622	4625	6676	7959	8038	8551	
LAND.L [,]			1026 #	
LAND.W [,]			1025 #	7129	8313	9785	
LBIC.B [,]			1028 #	4895	4900	4944	6541	6925	8160	10048	
LBIC.L [,]			1030 #	
LBIC.W [,]			1029 #	4908	7946	9719	9763	9769	9775	10309	10562	12135	12278	12386
				12457	12498	12563	12586	12902	
LBIS.B [,]			1020 #	4890	5221	5301	5307	5313	5319	5325	5337	5343	5349	5355
				5361	6931	7949	8553	10202	12732	12736	12740	12744	12748	12752	12756
				12760	12764	12768	12783	12787	12791	12795	12799	12803	12807	
LBIS.L [,]			1022 #	
LBIS.W [,]			1021 #	7955	9749	9756	10275	10317	10321	10329	10604	10607	12140	12143
				12146	12263	12396	12399	12402	12451	12575	12579	
LBIT.B [,]			1032 #	7871	12258	12267	12447	12953	12961	
LBIT.L [,]			1034 #	
LBIT.W [,]			1033 #	
LCMP.B [,]			1008 #	
LCMP.L [,]			1010 #	
LCMP.W [,]			1009 #	10134	11483	11487	
LCNTR.B [,]			1002 #	8035	8515	8524	11007	12654	12658	12662	12666	12670	12674	12678
				12682	12686	12690	12694	12698	12702	12706	12710	12714	
LCNTR.L [,]			1004 #	5028	5042	5162	
LCNTR.W [,]			1003 #	1373	1385	5286	5471	7961	8308	9948	11219	11224	11268	11298
				11317	11784	11829	11945	
LD MMR1				1134 #	2214	2284	2372	2463	2922	3134	3327	3536	4678	4717	5817
				5822	5913	5945	6032	6131	6271	6531	6538	6603	6610	
LLCM.B [,]			998 #	
LLCM.L [,]			1000 #	11443	11471	11476	
LLCM.W [,]			999 #	1389	1453	1576	1599	1662	8364	8376	8424	8435	10094	10099
				11729	
LLD.B [,]			990 #	6545	7902	8479	10000	
LLD.L [,]			992 #	5672	6633	6639	6645	6651	7007	7011	7090	7096	7142	7154
				7174	7186	7201	7287	7305	7326	10661	10688	12082	
LLD.W [,]			991 #	1702	1735	4805	6847	6886	7102	7119	7162	7281	7293	7299
				7389	7529	7543	7918	7924	7930	8025	8060	8068	8086	8096	8102
				8109	8127	8142	8154	8191	8199	8207	9183	9569	9791	9910	9915
				9926	10104	10366	10681	10788	11156	11182	11189	11738	11992	12220	12225
				12236	12453	12965	13153	
LLSW.B [,]			994 #	6543	8527	9998	10036	11503	12439	12442	
LLSW.L [,]			996 #	11438	12571	
LLSW.W [,]			995 #	1457	1725	1730	13138	
LMSTK [,]			1006 #	1362	1451	1635	1646	1683	4914	6761	6850	6869	7037	7080
				7111	7263	7362	7365	7368	7506	7518	7534	7555	7829	7835	7839
				7849	7853	7862	7875	7897	8001	8006	8010	8056	8062	8247	8251
				8255	8259	8263	8270	8280	8295	8302	8330	8473	8548	10314	10371
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  345
;                            Cross Reference Listing - Macro Names


				10517	10601	10666	11165	11538	11572	11577	11734	12567	12926	12992	13005
				13024	13127	
LSR.B [,]			915 #	
LSR.B* [,]			918 #	
LSR.L [,]			917 #	10160	11915	
LSR.L* [,]			920 #	11912	
LSR.Q [,]			922 #	11511	11987	
LSR.Q* [,]			923 #	
LSR.W [,]			916 #	
LSR.W* [,]			919 #	
LSUB.B [,]			1016 #	
LSUB.L [,]			1018 #	
LSUB.W [,]			1017 #	7134	10038	11172	11495	11552	11996	12623	12626	13070	13086	13095
				
LXOR.B [,]			1036 #	5227	
LXOR.L [,]			1038 #	
LXOR.W [,]			1037 #	
MFPI SPACE			1121 #	2830	3037	3239	
MOV.B [,]			798 #	4609	6674	8268	8306	8440	8522	10548	
MOV.B* [,]			801 #	4323	4479	
MOV.L [,]			800 #	5025	7373	8028	8033	8072	11545	11834	12004	
MOV.L* [,]			803 #	5593	
MOV.W [,]			799 #	1396	1898	2385	4878	4906	4910	4925	4930	4935	4947	4963
				5056	5135	5155	5157	5225	5440	5446	5459	5567	5588	5714	5750
				5756	5804	5978	6038	6281	6287	6587	6592	6597	6715	6722	7393
				7401	7407	7409	7545	7558	7560	7833	7998	8079	8090	8134	8145
				8232	8242	8718	8723	8859	8891	8916	9052	9381	9429	9432	9435
				9439	9450	9454	9473	9476	9513	9518	9523	9723	9731	9871	9919
				9930	9950	10387	10809	11493	11599	11876	11998	12002	12006	12099	12273
				12556	12959	13027	13050	13054	13130	13132	13134	
MOV.W* [,]			802 #	4685	4828	4835	5382	
MOVPM.B [,]			805 #	
MOVPM.B* [,]			808 #	
MOVPM.L [,]			807 #	
MOVPM.L* [,]			810 #	
MOVPM.W [,]			806 #	4673	
MOVPM.W* [,]			809 #	4733	
MOVS.B [,]			812 #	
MOVS.B* [,]			815 #	
MOVS.L [,]			814 #	10997	10999	11002	11004	
MOVS.L* [,]			817 #	
MOVS.W [,]			813 #	
MOVS.W* [,]			816 #	4329	4487	
MTST [,]			882 #	
MTST* [,]			883 #	5034	5194	
NEG.B [,]			747 #	
NEG.B* [,]			750 #	4254	
NEG.L [,]			749 #	10875	10882	10929	
NEG.L* [,]			752 #	10872	10878	10932	
NEG.W [,]			748 #	10153	10977	
NEG.W* [,]			751 #	
NEGC.B [,]			754 #	
NEGC.B* [,]			757 #	
NEGC.L [,]			756 #	10886	10889	10934	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  346
;                            Cross Reference Listing - Macro Names


NEGC.L* [,]			759 #	
NEGC.W [,]			755 #	
NEGC.W* [,]			758 #	
NNEG.B [,]			775 #	
NNEG.B* [,]			778 #	
NNEG.L [,]			777 #	
NNEG.L* [,]			780 #	
NNEG.W [,]			776 #	
NNEG.W* [,]			779 #	
NO ABORTS			1123 #	2373	2464	3328	3537	4679	4920	5816	5821	5946	6031	6130
				6272	7396	8951	9101	9288	9486	
NOP.B [,]			892 #	2764	2770	2776	4548	4554	5720	8861	9014	9085	9350	9355
				9424	9536	9653	9699	10557	10820	10826	11024	12060	12066	13091	
NOP.B* [,]			895 #	
NOP.L [,]			894 #	9154	9159	9164	10957	10961	10965	10969	12172	12177	12182	12843
				
NOP.L* [,]			897 #	
NOP.W [,]			893 #	1433	1720	4334	5062	5294	5331	5538	5745	6256	6863	7207
				7213	7499	7512	7584	7891	8172	8214	8728	8733	8778	8783	8791
				8796	8804	8809	8814	8833	8875	9178	9272	9341	9368	9373	9665
				9672	9679	9686	9743	10569	10574	10579	10586	10591	11889	11963	12230
				12415	12607	12822	12827	13059	
NOP.W* [,]			896 #	
ODD TRAP			1126 #	2175	2182	2285	2300	2793	2842	2855	3000	3048	3135	3202
				3250	3542	3946	4682	4718	4923	5738	5914	6137	6383	6530	6602
				6609	6718	7378	7399	8051	8132	8239	8945	8955	8973	9073	9080
				9111	9115	9235	9241	9293	9298	9411	9418	9491	9496	9501	
OUTC []				1074 #	1364	1438	1443	1744	6558	6563	7086	7274	7424	7826	7984
				13002	
OUTR.L [,]			1069 #	5164	9946	10145	10148	10381	10814	11040	11059	11230	11265	11280
				11296	11312	11480	11529	11791	11950	
OUTR.W [,]			1068 #	1392	1394	1413	1428	1578	1591	5018	7324	8047	8077	8323
				8845	8851	8921	8926	8936	9389	9394	9398	9402	9598	9648	9711
				9941	10052	10443	10532	10611	11612	11614	11616	11620	11635	11640	11643
				11647	12112	12116	12123	12149	12167	12511	12600	12859	12864	12873	12876
				12880	13142	13144	13151	
OUTS [,]			1072 #	1415	1426	1739	4632	4888	5275	5436	6552	6843	7414	7419
				7868	7987	8750	8870	8911	9643	9705	9782	9823	10107	10141	10155
				10246	10299	10325	10357	10361	10446	10520	10524	10528	10550	10596	10670
				10674	10752	10791	10981	11175	11192	11506	11878	11953	11958	12128	12130
				12384	12391	12550	12558	13052	
OUTS []				1071 #	7034	7042	7077	7272	7497	9641	
PDAD.B []			976 #	
PDAD.B* []			979 #	
PDAD.L []			978 #	
PDAD.L* []			981 #	
PDAD.W []			977 #	
PDAD.W* []			980 #	
PREFETCH			1113 #	4277	4336	4350	4357	4364	4371	4378	4385	4392	4399	4406
				4560	4567	4574	4829	5057	5063	5216	5383	5539	6506	6682	6688
				9666	9673	9680	9687	9800	12231	
PREVIOUS MODE			1131 #	2783	2791	2831	2840	2991	2998	3038	3046	3193	3200	3240
				3248	
RD.B []				1079 #	2167	2758	8328	8370	8381	8429	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  347
;                            Cross Reference Listing - Macro Names


RD.W []				1080 #	1583	1640	1654	1689	1709	1714	3141	4720	4942	5928	6533
				6540	6550	6614	6720	7380	7386	8053	8981	9089	9092	9127	9133
				9245	9255	9259	9276	9279	9301	9307	9313	9318	
RDF				1092 #	1909	
RDG.B []			1085 #	
RDG.W []			1086 #	1424	6841	7127	8855	9795	
RDI []				1090 #	2227	2559	2942	2948	2954	2960	2966	3147	3747	3938	5920
				6249	6374	8931	8961	8966	9061	9214	9221	
RDINTR []			1088 #	7195	
READ LOCKED			1141 #	2848	4816	
RMW.B []			1082 #	2752	
RMW.W []			1083 #	
ROL.B [,]			935 #	
ROL.B* [,]			938 #	4290	
ROL.L [,]			937 #	10856	10859	11344	11464	11556	11937	
ROL.L* [,]			940 #	
ROL.W [,]			936 #	
ROL.W* [,]			939 #	
ROR.B [,]			908 #	
ROR.B* [,]			911 #	4283	
ROR.L [,]			910 #	5180	5184	11051	11610	11919	12096	
ROR.L* [,]			913 #	
ROR.W [,]			909 #	
ROR.W* [,]			912 #	
RSYNC				986 #	1902	2387	5940	6505	
RTI-RTT PS PROTECT		1139 #	
SBC.B [,]			726 #	
SBC.B* [,]			729 #	4268	
SBC.L [,]			728 #	
SBC.L* [,]			731 #	
SBC.W [,]			727 #	
SBC.W* [,]			730 #	
SMULS.L [,]			951 #	5037	5050	11032	
SMULS.L* [,]			953 #	11045	
SMULS.W [,]			950 #	
SMULS.W* [,]			952 #	
SOBC.B [,]			740 #	
SOBC.B* [,]			743 #	
SOBC.L [,]			742 #	
SOBC.L* [,]			745 #	
SOBC.W [,]			741 #	6502	
SOBC.W* [,]			744 #	
SOVFF				1128 #	2397	3336	3543	4683	5739	6138	7404	8956	9116	9130	9304
				9502	
SUB.B [,]			705 #	
SUB.B* [,]			708 #	
SUB.L [,]			707 #	5047	
SUB.L* [,]			710 #	10542	
SUB.W [,]			706 #	1585	10696	11975	
SUB.W* [,]			709 #	4532	10537	
SUBC.B [,]			712 #	
SUBC.B* [,]			715 #	
SUBC.L [,]			714 #	
SUBC.L* [,]			717 #	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  348
;                            Cross Reference Listing - Macro Names


SUBC.W [,]			713 #	
SUBC.W* [,]			716 #	10544	10546	
SWAB.B [,]			885 #	4885	4912	7866	8300	9869	9873	10748	10833	10836	11491	12044
				12049	
SWAB.B* [,]			888 #	
SWAB.L [,]			887 #	
SWAB.L* [,]			890 #	
SWAB.W [,]			886 #	4883	8311	8520	8546	10034	10985	10990	12212	12216	12256	12265
				12445	12951	
SWAB.W* [,]			889 #	4220	
SXT.B [,]			833 #	
SXT.B* [,]			836 #	
SXT.L [,]			835 #	
SXT.L* [,]			838 #	
SXT.W [,]			834 #	
SXT.W* [,]			837 #	4311	
TST.B [,]			875 #	9565	
TST.B* [,]			878 #	4275	
TST.L [,]			877 #	5202	5207	
TST.L* [,]			880 #	5562	
TST.W [,]			876 #	7522	9546	
TST.W* [,]			879 #	5279	10040	
UMULS.L [,]			946 #	11237	11271	11287	11304	11324	
UMULS.L* [,]			948 #	
UMULS.W [,]			945 #	
UMULS.W* [,]			947 #	
VECTOR PS PROTECT		1140 #	1715	7387	
XHDIVS [,]			963 #	10919	11842	
XHDIVS* [,]			964 #	11824	
XLDIVS [,]			960 #	10868	11819	11837	
XLDIVS* [,]			961 #	10865	
XOR.B [,]			861 #	4620	4627	10046	10050	
XOR.B* [,]			864 #	
XOR.L [,]			863 #	10193	12591	
XOR.L* [,]			866 #	
XOR.W [,]			862 #	5189	8158	8162	10799	11208	
XOR.W* [,]			865 #	4317	
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  349
;                            Cross Reference Listing - Expression Names

; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  350
;                            Location / Line Number Index

U 0000		7497:	7008:	9641:	1413=	8364=	8300=	9723=	1359
U 0010		4964:	4633=	8420=	1362	1365	8480:	1377=	1381=
U 0020		5540:	5545:	5549:	5554:	8539=	8543=	5941:	5947:
U 0030		5563:	1589=	1370	1716=	5568:	5573:	5578:	5583:
U 0040		7264:	1394	5222=	1398	1903=	3544=	3947=	4618=
U 0050		3752=	3942=	4679=	4825=	1390=	1392=	4830=	8033:
U 0060		2385=	4881=	9783=	9786=	5022=	5151=	9789=	9792=
U 0070		1401	5281=	5441=	6384=	5035=	5039=	1415	7903:
U 0100		7850:	8323:	1421	8132=	8146=	8158:	9726=	1739=
U 0110		8222=	1424	8228=	1745=	1426	8233=	1429	8239=
U 0120		5048=	5052=	8268:	1451	8957=	1453	5169=	5174=
U 0130		8839=	7387=	1455	7393=	8843=	8846=	8849=	8852=
U 0140		6268=	6273=	6276=	6279=	6282=	6538=	6288=	6543=
U 0150		9395=	7863=	9399=	7950=	8969=	1458	5213=	5217=
U 0160		9492=	1460	9497=	9503=	10315=	10318=	10322=	10326=
U 0170		10125=	1463	10129=	1576	10518=	10521=	10525=	10529=
U 0200		13025:	9184:	9090=	9093=	9277=	9280=	9714=	12375=
U 0210		9246=	9256=	9474=	9477=	9451=	9260=	9455=	12499=
U 0220		9430=	8974=	1578	9134=	9863=	9301=	9919=	9308=
U 0230		9433=	9318=	9930=	9514=	9436=	9440=	10251=	1581
U 0240		7585:	1652=	1683=	1703=	4930=	4935=	4942=	4948=
U 0250		10372=	7373=	5818=	5823=	10377=	10382=	6139=	1583
U 0260		8738=	1585	8742=	9211=	11439=	11443=	6379=	9215=
U 0270		10597=	9319=	7965=	7969=	10602=	10605=	10608=	10612=
U 0300		12203=	1592	12207=	9524=	10305=	9976=	10362=	9998=
U 0310		12213=	7959=	12217=	10032=	12221=	12226=	12232=	12237=
U 0320		10444=	10447=	12554=	1595	11913=	11916=	8039=	8044=
U 0330		10667=	1599	9112=	9117=	10671=	10675=	9198=	1635
U 0340		10693=	10698=	7987=	8002=	11931=	11934=	9941=	9944=
U 0350		10834=	10837=	8028=	8072=	10841=	10845=	10849=	10853=
U 0360		10866=	10869=	10146=	10149=	10873=	10876=	10879=	10883=
U 0370		11166=	1638	9294=	1640	11170=	11172=	9298=	11176=
U 0400 - 0777 Unused
U 1000		8007:	7407=	7425=	8248=	8424=	8474=	8520=	8091=
U 1010		11205=	11209=	10392=	10395=	11950=	11954=	11220=	11225=
U 1020		11735=	1646	11235=	11239=	11739=	11743=	11269=	11273=
U 1030		1655	11973=	11976=	11981=	11984=	11989=	11993=	11996=
U 1040		12074=	12079=	12083=	12088=	12141=	12144=	12147=	12150=
U 1050		12397=	12400=	12403=	12406=	11285=	11289=	1658	8077:
U 1060		12568=	12572=	12576=	12580=	11302=	11306=	11322=	11326=
U 1070		11458=	11461=	11481=	11484=	11527=	11530=	11604=	11607=
U 1100		7858:	1662	11641=	11644=	11789=	11792=	11799=	11803=
U 1110		11817=	11820=	11835=	11838=	12117=	12120=	12420=	12423=
U 1120		12624=	12627=	12874=	12877=	12927=	12930=	1687	1689
U 1130		1693	1709	1711	1732	1735	2390	2562	4620
U 1140		4623	4625	4627	4683	4686	4721	4883	4885
U 1150		4888	4891	4906	4908	4910	4912	4914	4920
U 1160		4923	4925	4927	4932	4939	4944	5026	5030
U 1170		5044	5155	5157	5159	5162	5165	5177	5182
U 1200		5184	5186	5189	5191	5194	5198	5225	5228
U 1210		5384	6503	6507	6533	6535	6540	6541	6545
U 1220		6546	6548	6550	6554	6604	6615	6677	6710
U 1230		6712	6715	6718	6720	6723	6762:	6841	6843
U 1240		6845	6847	6851	6926	7038	7043	7081	7088
U 1250		7091	7112:	1193:	7120	7127	7129	7132	7134
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  351
;                            Location / Line Number Index


U 1260		7137	7163	7196	7272	7276	7320	7322	7324
U 1270		7327	7363	7366	7368	7378	7380	7383	7389
U 1300		7396	7399	7401	7404	7410	7500	7523	7529
U 1310		7532	7535	7543	7546	7556	7558	7561	7826
U 1320		7830	7833	7836	7840	7854	7866	7868	7871
U 1330		7873	7876	7962	7990	8011	8036	8047	8051
U 1340		8053	8057	8060	8063	8080	8135	8160	8163
U 1350		8243	8252	8256	8260	8264	8271	8281	8303
U 1360		8306	8308	8311	8313	8315	8320	8326	8328
U 1370		8331	8368	8370	8373	8376	8379	8381	8386
U 1400		8427	8429	8432	8435	8438	8441	8511	8513
U 1410		8516	8522	8524	8528	8534	8546	8548	8551
U 1420		8554	8745	8857	8859	8862	8896	9127	9130
U 1430		9304	9313	9315	9403	9518	9520	9565	9567
U 1440		9570	9644	9796	9801	9865	9867	9869	9871
U 1450		9874	9922	9933	9946	3142=	9948	9951	10000
U 1460		10004	10034	10036	10038	10040	5751=	10044	10046
U 1470		10048	10050	10053	10108	10131	10134	10137	4338:
U 1500		1374:	1386:	10153	10156	10176	10191	10193	10196
U 1510		10200	10203	10276	10330	10450	10453	10533	10544
U 1520		10546	10548	10550	10553	10558	10655	10707	10746
U 1530		10748	10750	10753	10791	10799	10802	10857	10860
U 1540		10887	10890	10899	10901	10903	10907	10917	10919
U 1550		10921	10924	10930	10932	10934	10938	10997	11000
U 1560		11002	11004	11008	11018	11060	11075	11193	11231
U 1570		11266	11299	11313	11334	11342	11345	11447	11464
U 1600		11467	11487	11489	11491	11493	11495	11497	11499
U 1610		11503	11507	11533	11536	11539	11554	11557	11573
U 1620		11578	11582	11585	11588	11610	11612	11614	11616
U 1630		11618	11621	11631	11648	11830	11848	11876	11879
U 1640		11920	11938	11998	12000	12002	12004	12007	12091
U 1650		12094	12096	12100	12123	12126	12128	12131	12244
U 1660		12248	12256	12259	12263	12265	12267	12270	12274
U 1670		8887=	8751=	12279	12328	8892=	12331	12380	12382
U 1700		12384	12387	12427	12430	12440	12442	12445	12447
U 1710		12449	12451	12455	12458	12506	12512	12556	12559
U 1720		12587	12595	12597	12601	12860	12881	12903	12911
U 1730		12949	12951	12953	12955	12959	12961	12963	12967
U 1740		13002	13006	13028	13050	13052	13055	13096	13119
U 1750		10977=	13128	10982=	13130	13132	13134	13138	7898:
U 1760		13140	13142	13144	13146	13148	13151	13154	
U 1770		10986=		10991=				5673:	7012:
U 2000		1432=	1434=	1437=	1439=	1442=	1443=	1706=	1707=
U 2010		1719=	1721=	1724=	1726=	1729=	1730=	1897=	1898=
U 2020		1908=	1911=	2160=	2162=	2166=	2168=	2173=	2176=
U 2030		2180=	2183=	2211=	2215=	2226=	2229=	2234=	2236=
U 2040		2282=	2286=	2298=	2301=	2314=	2316=	2370=	2374=
U 2050		2379=	2381=	2395=	2398=	2461=	2465=	2558=	2559=
U 2060		2742=	2745=	2751=	2753=	2757=	2759=	2763=	2765=
U 2070		2769=	2771=	2775=	2777=	2781=	2784=	2789=	2794=
U 2100		2798=	2800=	2804=	2806=	2810=	2812=	2816=	2818=
U 2110		2822=	2824=	2828=	2832=	2837=	2843=	2847=	2849=
U 2120		2853=	2856=	2867=	2869=	2873=	2875=	2879=	2881=
U 2130		2919=	2923=	2941=	2943=	2947=	2949=	2953=	2955=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  352
;                            Location / Line Number Index


U 2140		2959=	2961=	2965=	2967=	2989=	2992=	2996=	3001=
U 2150		3035=	3039=	3043=	3049=	3091=	3093=	3132=	3136=
U 2160		3146=	3148=	3152=	3155=	3191=	3194=	3198=	3203=
U 2170		3237=	3241=	3245=	3251=	3325=	3329=	3333=	3337=
U 2200		3534=	3537=	3746=	3747=	3937=	3938=	4219=	4221=
U 2210		4225=	4228=	4232=	4235=	4239=	4242=	4246=	4249=
U 2220		4253=	4256=	4260=	4263=	4267=	4270=	4274=	4278=
U 2230		4282=	4285=	4289=	4292=	4296=	4299=	4303=	4306=
U 2240		4310=	4312=	4316=	4318=	4322=	4324=	4328=	4330=
U 2250		4343=	4345=	4349=	4351=	4356=	4358=	4363=	4365=
U 2260		4370=	4372=	4377=	4379=	4384=	4386=	4391=	4393=
U 2270		4398=	4400=	4405=	4407=	4478=	4482=	4486=	4488=
U 2300		4492=	4496=	4500=	4504=	4508=	4512=	4516=	4520=
U 2310		4524=	4527=	4531=	4534=	4547=	4549=	4553=	4555=
U 2320		4559=	4561=	4566=	4568=	4573=	4575=	4608=	4609=
U 2330		4672=	4673=	4715=	4718=	4732=	4737=	4804=	4806=
U 2340		4815=	4817=	4821=	4822=	4834=	4836=	4877=	4878=
U 2350		4894=	4896=	4899=	4901=	5017=	5018=	5055=	5058=
U 2360		5061=	5064=	5134=	5136=	5140=	5142=	5146=	5147=
U 2370		5201=	5203=	5206=	5208=	5274=	5275=	5285=	5287=
U 2400		5293=	5295=	5300=	5302=	5306=	5308=	5312=	5314=
U 2410		5318=	5320=	5324=	5326=	5330=	5332=	5336=	5338=
U 2420		5342=	5344=	5348=	5350=	5354=	5356=	5360=	5362=
U 2430		5435=	5436=	5445=	5447=	5458=	5460=	5470=	5472=
U 2440		5587=	5589=	5592=	5595=	5713=	5715=	5719=	5721=
U 2450		5736=	5740=	5744=	5746=	5755=	5757=	5803=	5805=
U 2460		5911=	5915=	5919=	5922=	5927=	5929=	5977=	5979=
U 2470		6029=	6033=	6037=	6039=	6128=	6132=	6248=	6250=
U 2500		6255=	6257=	6373=	6375=	6478=	6480=	6483=	6485=
U 2510		6488=	6490=	6493=	6495=	6499=	6500=	6528=	6531=
U 2520		6557=	6559=	6562=	6564=	6586=	6588=	6591=	6593=
U 2530		6596=	6598=	6607=	6611=	6632=	6634=	6638=	6640=
U 2540		6644=	6646=	6650=	6652=	6673=	6674=	6680=	6683=
U 2550		6686=	6689=	6707=	6708=	6751=	6752=	6838=	6839=
U 2560		6862=	6864=	6868=	6870=	6885=	6887=	6917=	6919=
U 2570		6930=	6932=	6978=	6980=	6984=	6986=	7033=	7034=
U 2600		7076=	7077=	7085=	7086=	7095=	7097=	7101=	7102=
U 2610		7116=	7117=	7124=	7125=	7141=	7143=	7147=	7149=
U 2620		7153=	7155=	7159=	7160=	7167=	7169=	7173=	7175=
U 2630		7179=	7181=	7185=	7187=	7191=	7192=	7200=	7202=
U 2640		7206=	7208=	7212=	7214=	7280=	7282=	7286=	7288=
U 2650		7292=	7294=	7298=	7300=	7304=	7306=	7413=	7415=
U 2660		7418=	7420=	7505=	7507=	7511=	7513=	7517=	7519=
U 2670		7526=	7527=	7552=	7553=	7890=	7892=	7917=	7919=
U 2700		7923=	7925=	7929=	7931=	7945=	7946=	7954=	7955=
U 2710		7983=	7984=	7997=	7998=	8024=	8025=	8067=	8068=
U 2720		8085=	8086=	8095=	8097=	8101=	8103=	8108=	8110=
U 2730		8124=	8127=	8139=	8142=	8151=	8154=	8168=	8173=
U 2740		8188=	8192=	8196=	8200=	8204=	8208=	8212=	8215=
U 2750		8294=	8296=	8717=	8719=	8722=	8724=	8727=	8729=
U 2760		8732=	8734=						
U 2770 - 2777 Unused
U 3000		8777=	8779=	8782=	8784=	8790=	8792=	8795=	8797=
U 3010		8803=	8805=	8808=	8810=	8813=	8815=	8826=	8828=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  353
;                            Location / Line Number Index


U 3020		8832=	8834=	8869=	8871=	8874=	8876=	8910=	8912=
U 3030		8915=	8917=	8920=	8922=	8925=	8927=	8930=	8932=
U 3040		8935=	8937=	8943=	8946=	8949=	8951=	8960=	8962=
U 3050		8965=	8966=	8980=	8982=	8985=	8987=	9007=	9010=
U 3060		9013=	9015=	9051=	9053=	9060=	9063=	9071=	9074=
U 3070		9078=	9081=	9084=	9086=	9099=	9102=	9153=	9155=
U 3100		9158=	9160=	9163=	9165=	9171=	9173=	9177=	9179=
U 3110		9188=	9190=	9193=	9194=	9206=	9208=	9220=	9222=
U 3120		9233=	9236=	9239=	9241=	9249=	9251=	9265=	9267=
U 3130		9271=	9273=	9286=	9289=	9328=	9330=	9334=	9336=
U 3140		9340=	9342=	9349=	9351=	9354=	9356=	9367=	9369=
U 3150		9372=	9374=	9380=	9382=	9388=	9390=	9409=	9412=
U 3160		9416=	9419=	9423=	9425=	9445=	9447=	9462=	9464=
U 3170		9484=	9487=	9535=	9537=	9540=	9542=	9545=	9547=
U 3200		9578=	9580=	9587=	9589=	9597=	9599=	9635=	9637=
U 3210		9647=	9649=	9652=	9654=	9664=	9667=	9671=	9674=
U 3220		9678=	9681=	9685=	9688=	9698=	9700=	9704=	9705=
U 3230		9718=	9720=	9730=	9732=	9742=	9744=	9748=	9751=
U 3240		9755=	9758=	9762=	9764=	9768=	9770=	9774=	9776=
U 3250		9822=	9824=	9858=	9859=	9909=	9911=	9914=	9915=
U 3260		9925=	9926=	9936=	9938=	9971=	9972=	9994=	9995=
U 3270		10028=	10029=	10084=	10086=	10093=	10095=	10098=	10100=
U 3300		10103=	10104=	10113=	10115=	10118=	10120=	10140=	10142=
U 3310		10159=	10162=	10165=	10168=	10172=	10173=	10180=	10182=
U 3320		10245=	10246=	10298=	10299=	10308=	10310=	10356=	10357=
U 3330		10365=	10367=	10386=	10388=	10422=	10424=	10427=	10429=
U 3340		10432=	10434=	10437=	10439=	10505=	10507=	10510=	10512=
U 3350		10536=	10538=	10541=	10542=	10561=	10563=	10568=	10570=
U 3360		10573=	10575=	10578=	10580=	10585=	10587=	10590=	10592=
U 3370		10646=	10648=	10651=	10652=	10660=	10662=	10680=	10682=
U 3400		10687=	10689=	10787=	10788=	10808=	10810=	10813=	10815=
U 3410		10819=	10821=	10825=	10827=	10945=	10947=	10956=	10958=
U 3420		10960=	10962=	10964=	10966=	10968=	10970=	11023=	11025=
U 3430		11031=	11034=	11039=	11041=	11044=	11047=	11050=	11052=
U 3440		11055=	11056=	11066=	11068=	11071=	11072=	11146=	11148=
U 3450		11155=	11157=	11181=	11183=	11188=	11189=	11198=	11200=
U 3460		11212=	11214=	11279=	11281=	11295=	11296=	11316=	11318=
U 3470		11433=	11435=	11452=	11454=	11470=	11472=	11475=	11477=
U 3500		11510=	11513=	11516=	11518=	11521=	11523=	11544=	11546=
U 3510		11551=	11552=	11598=	11600=	11634=	11636=	11721=	11723=
U 3520		11728=	11730=	11783=	11785=	11823=	11826=	11841=	11844=
U 3530		11882=	11884=	11888=	11891=	11907=	11909=	11925=	11927=
U 3540		11944=	11946=	11957=	11959=	11962=	11965=	12043=	12045=
U 3550		12048=	12050=	12053=	12055=	12059=	12061=	12065=	12067=
U 3560		12111=	12113=	12134=	12136=	12166=	12168=	12171=	12173=
U 3570		12176=	12178=	12181=	12183=	12304=	12306=	12320=	12322=
U 3600		12325=	12326=	12358=	12360=	12390=	12392=	12409=	12411=
U 3610		12414=	12416=	12481=	12483=	12549=	12550=	12562=	12564=
U 3620		12583=	12584=	12590=	12592=	12606=	12608=	12653=	12655=
U 3630		12657=	12659=	12661=	12663=	12665=	12667=	12669=	12671=
U 3640		12673=	12675=	12677=	12679=	12681=	12683=	12685=	12687=
U 3650		12689=	12691=	12693=	12695=	12697=	12699=	12701=	12703=
U 3660		12705=	12707=	12709=	12711=	12713=	12715=	12731=	12733=
U 3670		12735=	12737=	12739=	12741=	12743=	12745=	12747=	12749=
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  354
;                            Location / Line Number Index


U 3700		12751=	12753=	12755=	12757=	12759=	12761=	12763=	12765=
U 3710		12767=	12769=	12782=	12784=	12786=	12788=	12790=	12792=
U 3720		12794=	12796=	12798=	12800=	12802=	12804=	12806=	12808=
U 3730		12821=	12823=	12826=	12828=	12842=	12844=	12863=	12865=
U 3740		12914=	12916=	12991=	12993=	12997=	12998=	13058=	13060=
U 3750		13064=	13066=	13069=	13071=	13075=	13077=	13080=	13082=
U 3760		13085=	13087=	13090=	13092=				
; CTL0P3.MCR [242,1110]      MICRO2  1H(17)     3-Feb-83  16:32:21                                                         Page  355
;                            Statistics


Memory	No. Microwords	High Addr
U		1761	2035

Pass 1 warnings detected:		0	Pass 2 warnings detected:	0
Pass 1 errors detected:			0	Pass 2 errors detected:		0
