2!		PROGRAM		: CPEXER.BAS
5!		VERSION		: V10.1
6!		EDIT		: A
7!		EDIT DATE	: 10-MAY-91
10	EXTEND
11	! &
	&
	&
	!		  C O P Y R I G H T &
	&
	&
  !		      Copyright (C) 1976, 1991 by &
  !	        Digital Equipment Corporation, Maynard, Mass. &
  !	&
  !	&
  !	This software is furnished under a license and may be used and &
  !	copied  only  in accordance with the terms of such license and &
  !	with the  inclusion  of  the  above  copyright  notice.   This &
  !	software  or  any  other copies thereof may not be provided or &
  !	otherwise made available to any other person.  No title to and &
  !	ownership of the software is hereby transferred. &
  !	&
  !	The information in this software is subject to change  without &
  !	notice  and should not be construed as a commitment by Digital &
  !	Equipment Corporation. &
  !	&
  !	DIGITAL assumes no responsibility for the use  or  reliability &
  !	of its software on equipment that is not supplied by DIGITAL. &
  !	&
  !******************************************************************* &
	&

20	! &
	&
	&
	!	M O D I F I C A T I O N    H I S T O R Y &
	&
	&

21	! VER/ED	EDIT DATE	REASON &
	!
99!	&

100	! &
	&
	&
	!	G E N E R A L    D E S C R I P T I O N &
	&
	&

101!	THE CENTRAL PROCESSOR EXERCISER IS DESIGNED TO PUT A HEAVY &
   !	LOAD ON THE CPU.  CPEXER RUNS COMPUTE BOUND FOR SHORT BURSTS AND &
   !	THEN SLEEPS FOR 5 SECONDS SO THAT AVERAGE PROCESSOR LOADING IS &
   !	NOT SUFFICIENT TO APPRECIABLY AFFECT THE PERFORMANCE OF
102!	SYSTEM.  THE CPEXER PROGRAM WAS DESIGNED TO TEST THE FPP OPTION, &
   !	BUT ALSO SERVES TO VERIFY GENERAL CPU INTEGRITY AND CORRECT &
   !	EIS OPERATION.  THERE IS ALSO A TEST OF THE PEEK FUNCTION FOR &
   !	KERNAL ADDRESSES 0 THRU 25000. &
   !
103!	THE TESTS PERFORMED BY CPEXER ARE BRIEFLY DESCRIBED BELOW. &
   !	IN MOST CASES THE RESULTS ARE COMPARED TO KNOWN VALUES.  TWO &
   !	GRIND TESTS ARE ALSO INCLUDED TO VERIFY CONSISTANT RESULTS OF &
   !	DUPLICATE CALCULATIONS.  FINALLY, A FEW MISCELLANEOUS TESTS &
   !	ARE PERFORMED WHICH HAVE DETECTED HARDWARE FAILURES PREVIOUSLY. &
   !
299!
300	! &
	&
	&
	!	I / O    C H A N N E L S &
	&
	&

301!	CHANNEL #		USED FOR &
   !
399!
400	! &
	&
	&
	!	V A R I A B L E    D E F I N I T I O N S &
	&
	&

401!	VARIABLE NAME		USED FOR &
   !
799!
800	! &
	&
	&
	!	F U N C T I O N / S U B R O U T I N E    D E S C . &
	&
	&

801!	FUNCTION/SUBROUTINE		USE &
   !
899!
900	! &
	&
	&
	&
	!	D I M E N S I O N   S T A T E M E N T S &
	&

910	DIM A(60%),C(60%) &
	! A IS THE PRE COMPUTED DATA ARRAY, C IS THE PROGRAM COMPUTED ARRAY &
	&

999	! &
	&
	&
	!	M A I N    C O D I N G    A R E A &
	&
	&

1000	ON ERROR GOTO 19000 &
	\ TEMP$=SYS(CHR$(6%)+CHR$(-21%)) &
	! SET UP STANDARD ERROR TRAP. &
	! PERMANENTLY DROP TEMPORARY PRIVILEGES. &

1010	I$="V10.1-A" &
	! SET UP VERSION AND EDIT NUMBER &

1020	PRINT "CPEXER";CHR$(9%);I$;CHR$(9%); &
		CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(0%)),3%),4%) &
	! SET UP STANDARD HEADER AND PRINT IT &

1030	JOB.NO%=ASCII(SYS(CHR$(6%)+CHR$(9%)))/2% &
		! GET OUR JOB NUMBER. &

1100	PRINT IF CCPOS(0%) &
	\ PRINT &
	\ PRINT "How many minutes to run <15>"; &
	\ INPUT LINE TEMP$ &
	\ GOTO 32767 IF ASCII(TEMP$)=27% &
	\ TEMP$=CVT$$(TEMP$,254%) &
	\ TEMP$="15" UNLESS LEN(TEMP$) &
	\ P5=VAL(TEMP$) &
	\ IF P5=-1. THEN &
		P5=1000000000000000000000000000000. &
	  ELSE	IF P5<=0. THEN &
			PRINT IF CCPOS(0%) &
	\		PRINT "?Illegal number of iterations selected" &
	\		GOTO 1100 &
		! GET DURATION OF TEST. &

1110	PRINT IF CCPOS(0%) &
	\ PRINT &
	\ PRINT "Detach <No>"; &
	\ INPUT LINE TEMP$ &
	\ GOTO 1100 IF ASCII(TEMP$)=27% &
	\ IF ASCII(CVT$$(TEMP$,254%))=89% THEN &
		PRINT "Type ATTACH";JOB.NO%;"when SYSTAT shows job"; &
			JOB.NO%;"in HB state." &
	\	PRINT &
	\	TEMP$=SYS(CHR$(6%)+CHR$(7%)) &
		! DETACH IF HE WANTS TO. &

1150	W9%=LEN(CVTF$(0.))/2% &
	\ ZERO.=0.0 &
	\ ZERO%=0% &
	\ BIG.NUM.=60000. &
	! SET W9% FOR 2 OR 4 WORD MATH PACKAGE. &
	! SET UP A FLOATING ZERO, &
	!  AN INTEGER ZERO, AND &
	!  A LARGE NUMBER TO FORCE ERRORS. &

1160	L=TIME(0%)/60% &
	\ T=TIME(1%) &
	! INITIALIZE START TIME AND SAVE CPU TIME. &

2000	J7%=PEEK(I7%) FOR I7%=0% TO 22000% STEP 2% &
	! PEEK CHECK FOR MAX INTERRUPTS AND MEMORY ACCESS &
	! THE PEEK UPPER LIMIT REDUCED TO 22000 FOR THE &
	! SAKE OF SMALL SYSTEM MONITORS. &

2010	GOSUB 2300 &
	\ RESTORE &
	! CHECK TIME AND RESET DATA POINTER &

2020	IF FNR%(35%) THEN GOSUB 4000 &
	\ GOSUB 2300 &
	! SINE BY FUNCTION AND TIME CHECK &

2030	GOSUB 4700 &
	\ GOSUB 2300 &
	! SINE BY POLYNOMIAL AND TIME CHECK &

2040	IF FNR%(60%) THEN GOSUB 4100 &
	\ GOSUB 2300 &
	! LOG BY FUNCTION AND TIME CHECK &

2050	IF FNR%(40%) THEN GOSUB 4200 &
	\ GOSUB 2300 &
	! EXP FUNCTION TEST AND TIME CHECK &

2060	IF FNR%(50%) THEN GOSUB 4300 &
	\ GOSUB 2300 &
	! SQR FUNCTION TEST AND TIME CHECK &

2070	GOSUB 4600 &
	\ GOSUB 2300 &
	! SQR BY NEWTON-RAPHSON METHOD AND TIME CHECK &
	&

2080	GOSUB 4400 &
	\ GOSUB 2300 &
	! LOG/EXP GRIND THEN CHECK TIME &

2090	GOSUB 4500 &
	\ GOSUB 2300 &
	! ATN/TAN GRIND THEN CHECK TIME &

2100	GOSUB 5000 &
	\ K%=K%+1% &
	! MISCELLANEOUS TESTS THEN INCREMENT PASS COUNT &

2110	IF E1%<>0% THEN 32700 &
	! IF ERRORS THEN GOTO ERROR EXIT &

2120	GOSUB 2300 &
	\ GOTO 2000 &
	! IF TIME NOT USED UP THEN RESTART TEST &

2299	! &
	&
	&
	!	T I M E   C H E C K   R O U T I N E &
	&

2300	T5=TIME(0%) &
	\ IF T5>=T6 THEN 2320 &
	! CHECK FOR MIDNIGHT PASSAGE - IS PRESENT TIME > LAST TIME &

2310	T7=T7+86400. &
	! MIDNIGHT HAS PASSED SO INCREMENT COMPARE TIME &

2320	T6=T5 &
	\ T5=(T5+T7)/60. &
	! SAVE LAST TIME AND CONVERT PRESENT TIME TO MINUTES &

2330	IF T5>=L+P5 THEN 8000 &
	! IF WE ARE FINISHED THEN TAKE EXIT &

2340	SLEEP 5% &
	\ RETURN &
	! HESITATE AND GIVE THE OTHER GUY A BREAK &
	&

4000	! &
	&
	&
	!	S I N E    T E S T   B A S I C +   F U N C T I O N &
	&
	&

4010	E%=0% &
	\ F1$="SIN" &
	! PRESET  ERROR COUNT, FUNCTION NAME &

4020	C(D%/10%)=SIN((D%/180.)*PI)	FOR D%=10% TO 350% STEP 10% &
	! COMPUTE ARRAY C OF 10 DEGREE STEPS FOR 360 DEGREES &

4025	J=FNR3(35%) &
	! ROUND RESULTS TO 3 PLACES &

4030	FOR D%=10% TO 350% STEP 10%
4040	I%=D%/10% &
	\ IF C(I%)==A(I%) THEN 4050 ELSE GOSUB 4800 &
	! IF RESULTS DO NOT EQUAL SUPPLIED VALUES THEN PRINT DIFFERENCES &

4050	NEXT D% &
	! END OF SINE FUNCTION TEST LOOP &

4060	GOTO 4900 &
	! GO TO EXIT ROUTINE FOR THIS TEST &
	&

4100	! &
	&
	&
	!	L O G A R I T H M   T E S T   B A S I C +   F U N C T I O N &
	&

4110	E%=0% &
	\ F1$="LOG" &
	\ I%=1% &
	! PRESET  ERROR COUNT, FUNCTION NAME &

4120	C(D%/10%)=LOG(D%)	FOR D%=10% TO 500% STEP 10% &
	\ C(51%)=LOG(0.1) &
	\ C(52%)=LOG(0.2) &
	\ C(53%)=LOG(0.3) &
	\ C(54%)=LOG(0.4) &
	\ C(55%)=LOG(0.5) &
	\ C(56%)=LOG(0.6) &
	\ C(57%)=LOG(0.7) &
	\ C(58%)=LOG(0.8) &
	\ C(59%)=LOG(0.9) &
	\ C(60%)=LOG(1.0) &
	! COMPUTE LOGS OF 60 NUMBERS &

4135	J=FNR3(60%) &
	! ROUND RESULTS TO 3 PLACES &

4140	FOR D%=10% TO 500% STEP 10% &

4150	IF C(I%)==A(I%) THEN 4160 ELSE GOSUB 4800 &
	! COMPARE ARRAY C OF KNOWN VALUES TO LOGS &

4160	I%=I%+1% &
	\ NEXT D% &
	! DO THE FIRST 50 OF THEM &

4170	FOR D=0.1 TO 1.01 STEP 0.1 &

4180	IF C(I%)==A(I%) THEN 4190 ELSE GOSUB 4820 &
	! COMPARE THE LAST 10 OF THEM &

4190	I%=I%+1% &
	\ NEXT D &
	! DO THE LAST 10 COMPARISONS &

4195	GOTO 4900 &
	! GO TO THE EXIT ROUTINE FOR THIS TEST &
	&

4200	! &
	&
	&
	!	E X P O N E N T I A L   T E S T &
	!	B A S I C +   F U N C T I O N &
	&

4210	E%=0% &
	\ F1$="EXP" &
	\ I%=21% &
	! PRESET  ERROR COUNT, FUNCTION NAME &

4220	FOR D%=1% TO 10% &

4225	C(D%)=EXP(D%) &
	\ C(D%+10%)=EXP(-D%) &
	\ NEXT D% &
	! CREATE THE FIRST 20 VALUES &

4230	FOR D=0.0 TO 0.91 STEP 0.1 &

4235	C(I%)=EXP(D) &
	\ C(I%+10%)=EXP(-D) &
	\ I%=I%+1% &
	\ NEXT D &
	\ I%=1% &
	! DO THE NEXT 20 VALUES &

4237	J=FNR3(40%) &
	! ROUND RESULTS TO 3 PLACES &

4240	FOR D%=1% TO 10% STEP 1% &

4245	IF C(I%)==A(I%) THEN 4250 ELSE GOSUB 4800 &
	! COMPARE ARRAY C TO KNOWN VALUES AND PRINT DIFFERENCES &

4250	I%=I%+1% &
	\ NEXT D% &
	! COMPARE THE FIRST 10 VALUES &

4255	FOR D%=-1% TO -10% STEP -1% &

4260	IF C(I%)==A(I%) THEN 4265 ELSE GOSUB 4800 &
	! COMPARE ARRAY C TO KNOWN VALUES &

4265	I%=I%+1% &
	\ NEXT D% &
	! COMPARE THE NEXT 10 VALUES &

4270	FOR D=0.0 TO 0.91 STEP 0.1 &

4275	IF C(I%)==A(I%) THEN 4280 ELSE GOSUB 4820 &
	! COMPARE ARRAY C TO KNOWN VALUES &

4280	I%=I%+1% &
	\ NEXT D &
	! COMPARE THE NEXT 10 VALUES &

4285	FOR D=-0.0 TO -0.91 STEP -0.1 &

4290	IF C(I%)==A(I%) THEN 4295 ELSE GOSUB 4820 &
	! COMPARE ARRAY C TO KNOWN VALUES &

4295	I%=I%+1% &
	\ NEXT D &
	\ GOTO 4900 &
	! COMPARE THE LAST 10 VALUES &
	! GO TO THE EXIT ROUTINE FOR THIS TEST &

4300	! &
	&
	&
	!	S Q U A R E   R O O T   T E S T &
	&

4310	E%=0% &
	\ F1$="SQR" &
	! PRESET  ERROR COUNT, FUNCTION NAME &

4315	IF W9%=4% THEN A(44%)=66.332 &
	! ROUND DOWN ELEMENT 44 FOR 4 WORD MATH PACKAGE &

4320	C(D%/100%)=SQR(D%)	FOR D%=100% TO 5000% STEP 100% &
	! COMPUTE THE SQUARE ROOTS OF 100 TO 5000 - 50 VALUES &

4325	J=FNR3(50%) &
	! ROUND RESULTS TO 3 PLACES &

4330	FOR D%=100% TO 5000% STEP 100% &

4340	I%=D%/100% &
	\ IF C(I%)==A(I%) THEN 4350 ELSE GOSUB 4800 &
	! COMPARE ARRAY C VALUES TO KNOWN VALUES &

4350	NEXT D% &
	\ GOTO 4900 &
	! COMPARE ALL 50 VALUES &
	! GO TO THE EXIT ROUTINE FOR THIS TEST &

4400	! &
	&
	&
	!	L O G ( E X P ( X ) )   G R I N D   T E S T &
	&

4410	E%=0% &
	\ F1$="EXP" &
	\ F2$="LOG" &
	! PRESET  ERROR COUNT, FUNCTION NAME &

4420	FOR D=1.0 TO 1000.0 STEP 3.0 &

4440	IF EXP(LOG(EXP(LOG(EXP(LOG(EXP(LOG(EXP(LOG(D)))))))))) <> &
	   EXP(LOG(EXP(LOG(EXP(LOG(EXP(LOG(EXP(LOG(D)))))))))) THEN &
	GOSUB 4870 &
	! GRIND AND PRINT ERRORS IF ANY &

4450	NEXT D &
	\ GOTO 4900 &
	! GO TO THE EXIT ROUTINE FOR THIS TEST &
	&

4500	! &
	&
	&
	!	A T N ( T A N ( X ) )   G R I N D   T E S T &
	&

4510	E%=0% &
	\ F1$="ATN" &
	\ F2$="TAN" &
	! PRESET  ERROR COUNT, FUNCTION NAME &

4520	FOR D=-1.50 TO 1.50 STEP 0.01 &

4530	IF ABS(D)<.001 THEN D=0 &
	! ROUND ALMOST 0 VALUES TO 0 &

4540	IF ATN(TAN(ATN(TAN(ATN(TAN(ATN(TAN(ATN(TAN(D)))))))))) <> &
	   ATN(TAN(ATN(TAN(ATN(TAN(ATN(TAN(ATN(TAN(D)))))))))) THEN &
	GOSUB 4870 &
	! GRIND TEST AND PRINT ERRORS IF ANY &

4550	NEXT D &
	\ GOTO 4900 &
	! GO TO THE EXIT ROUTINE FOR THIS TEST &

4600	! &
	&
	&
	!	S Q U A R E   R O O T   B Y   N E W T O N - R A P H S O N &
	&

4610	E%=0% &
	\ F1$="NEWTON SQR" &
	! PRESET  ERROR COUNT, FUNCTION NAME &

4615	IF W9%=4% THEN A(44%)=66.332 &
	! ROUND DOWN ON 4 WORD MATH PACKAGE &

4620	FOR D%=100% TO 5000% STEP 100% &

4630	I%=D%/100% &
	\ C(I%)=I% &
	\ X0=0.0 &
	\ I1%=0% &
	! SET UP VALUES TO BE CALCULATED &

4640	IF ABS(C(I%)-X0)<0.0001 THEN 4650 ELSE &
	IF I1%>20% THEN 4650 ELSE &
	X0=C(I%) &
	\ C(I%)=0.5*(X0+D%/X0) &
	\ I1%=I1%+1% &
	\ GOTO 4640 &
	! CALCULATE SQUARE ROOT &

4650	NEXT D% &
	\ GOTO 4325 &
	! CALCULATE ALL VALUES - JOIN COMMON COMPARE CODE &
	&

4700	! &
	&
	&
	!	S I N E   B Y   P O L Y N O M I A L &
	&

4710	E%=0% &
	\ F1$="PLYNOM. SIN" &
	! PRESET  ERROR COUNT, FUNCTION NAME &

4720	FOR D%=10% TO 350% STEP 10% &
	! DO EVERY 10 DEGREES FOR ONE CIRCLE &

4730	IF D%<=90%	THEN X1=D%	ELSE &
	IF D%<=270%	THEN X1=180%-D% ELSE &
			     X1=D%-360% &

4740	X1=X1/90 &
	\ X3=X1*X1*X1 &
	\ X5=X3*X1*X1 &
	\ X7=X5*X1*X1 &

4750	C(D%/10%)=1.57079*X1-.645921*X3+.079488*X5-.004362*X7 &
	! COMPUTE BY POLYNOMIAL &

4760	NEXT D% &
	\ GOTO 4025 &
	! DO ALL 35 VALUES THEN JOIN COMMON CODE FOR COMPARE &

4800	! &
	&
	&
	!	C O M P A R E   E R R O R   P R I N T E R   R O U T I N E &
	&

4805	GOSUB 4840 &
	! CHECK FOR FIRST TIME - PRINT HEADER &

4810	PRINT "?CPEXER - Computed value of ";F1$;"(";D%; &
	SPACE$(4-LEN(NUM1$(D%)));") was ";C(I%); &
	\ GOTO 4835 &
	! PRINT VALUES FOR FIXED POINT &

4820	GOSUB 4840 &
	! CHECK FOR FIRST TIME - PRINT HEADER &

4830	PRINT "?CPEXER - Computed value of ";F1$;"(";D; &
	SPACE$(4-LEN(NUM1$(D)));") was ";C(I%); &
	! PRINT VALUES FOR FLOATING POINT &

4835	PRINT SPACE$(7-LEN(NUM1$(C(I%))));",should be ";A(I%) &
	\ RETURN &
	! PRINT VALUES AND WHAT THEY SHOULD BE &

4840	E%=E%+1% &
	\ IF E%=1% THEN PRINT &
	\ PRINT "?CPEXER - ";F1$;" test failed for the following cases:" &
	! INCREMENT ERROR COUNT AND PRINT HEADER IF FIRST TIME &

4845	RETURN &
	! END OF ERROR PRINTER FOR FUNCTIONS &
	&

4870	! &
	&
	&
	!	C O N S I S T E N C Y   E R R O R   P R I N T E R &
	&

4875	E%=E%+1% &
	\ IF E%=1% THEN PRINT &
	\ PRINT "?CPEXER - ";F1$;"/";F2$; &
	" Consistency check failed for the following cases :" &
	! INCREMENT ERROR COUNT PRINT HEADER IF FIRST TIME &

4880	PRINT "?CPEXER - ";F1$;"(";F2$;"(...(";D; &
	SPACE$(9-LEN(NUM$(D)));")))))))))) <> ";F1$;"(";F2$;"(...(";D; &
	SPACE$(9-LEN(NUM$(D)));"))))))))))" &
	\ RETURN &
	! END OF CONSISTENCY ERROR PRINTER &

4900	! &
	&
	&
	!	S U B - F U N C T I O N   E X I T   R O U T I N E &
	&

4910	IF E%=0% THEN RETURN ELSE E1%=E1%+E% &
	\ PRINT "?CPEXER CPU,EIS,FIS,FPP,MUL,DIV or SHIFT Error" &
	\ PRINT "Continuing ..." &
	\ RETURN &
	! ERROR EXIT TO NEXT TEST AND GIVE MESSAGE &

5000	! &
	&
	&
	!	M I S C E L L A N E O U S   P R O B L E M   A R E A S &
	&

5010	E%=0% &
	! PRESET  ERROR COUNT, FUNCTION NAME &

5020	ON ERROR GOTO 5030 &
	! SET UP ERROR TRAP FOR THIS TEST &

5025	A=1.0/ZERO. &
	\ E%=E%+1% &
	\ PRINT &
	\ PRINT "?CPEXER Floating point divide by 0 didn't trap" &
	\ PRINT "Continuing ..." &
	! IF THE ERROR MAKES IT INCREMENT ERROR COUNT AND PRINT MESSAGE &

5030	RESUME 5032 &
	! TRY NEXT ONE &

5032	ON ERROR GOTO 5040 &
	! SET UP ERROR TRAP FOR THIS TEST &

5035	A%=1%/ZERO% &
	\ E%=E%+1% &
	\ PRINT &
	\ PRINT "?CPEXER Integer divide by zero didn't trap" &
	\ PRINT "Continuing ..." &
	! IF THE ERROR MAKES IT INCREMENT ERROR COUNT AND PRINT MESSAGE &

5040	RESUME 5042 &
	! CLEAR ERROR FLAG &

5042	ON ERROR GOTO 5050 &
	! SET UP ERROR TRAP FOR THIS TEST &

5045	A%=BIG.NUM. &
	\ E%=E%+1% &
	\ PRINT &
	\ PRINT "?CPEXER Forced integer conversion error didn't trap" &
	\ PRINT "Continuing ..." &
	! IF THE ERROR MAKES IT INCREMENT ERROR COUNT AND PRINT MESSAGE &

5050	RESUME 5052 &
	! RESET ERROR FLAG &

5052	ON ERROR GOTO 19000 &
	! RESET STANDARD ERROR TRAP &

5055	IF (INT(40.6621*100+0.5))/100==40.66 THEN &
		RETURN &
	ELSE	PRINT &
	\	PRINT "?CPEXER (INT(40.6621*100+0.5))/100 <> 40.66" &
	\	PRINT "Continuing ..." &
	! TRY SPECIAL TEST &

5060	GOTO 4900 &
	! GO TO THE EXIT ROUTINE FOR THIS TEST &

6000	! &
	&
	&
	!	R E A D   F U N C T I O N &

6005	DEF* FNR%(J%) &

6010	READ A(L%) FOR L%=1% TO J% &
	! READ ALL DATA VALUES REQUESTED INTO ARRAY A &

6020	FNR%=1% &
	\ FNEND &
	! END OF READ FUNCTION &
	&

6100	! &
	&
	&
	!	R O U N D   3  D I G I T S   F U N C T I O N &
	&

6105	DEF* FNR3(J%) &

6120	C(L%)=(INT(C(L%)*1000.0+0.5))/1000.0 FOR L%=1% TO J% &
	! DO THE ROUNDING &

6130	FNR3=L% &
	\ FNEND &
	! END OF ROUNDING FUNCTION &
	&

8000	! &
	&
	&
	!	N O R M A L   E X I T &
	&

8010	PRINT &
	\ PRINT NUM1$((TIME(1%)-T)/10%);" seconds of CPU time used in"; &
	\ PRINT K%;"pass"; &
	\ PRINT "es"; IF K%<>1% &
	\ PRINT "." &
	\ PRINT &
	\ PRINT "CPEXER finished at ";TIME$(0%) &
	\ GOTO 32767 &
	! NORMAL EXIT PATH &

9000	! &
	! SIN TEST DATA &
	!
9010	DATA .174,.342,.5,.643,.766,.866,.94,.985,1.0
9020	DATA .985,.94,.866,.766,.643,.5,.342,.174,0.0
9030	DATA -.174,-.342,-.5,-.643,-.766,-.866,-.94,-.985,-1.0
9040	DATA -.985,-.94,-.866,-.766,-.643,-.5,-.342,-.174
9100	! &
	! LOG TEST DATA &
	!
9110	DATA 2.303,2.996,3.401,3.689,3.912,4.094,4.248,4.382,4.5,4.605
9120	DATA 4.7,4.787,4.868,4.942,5.011,5.075,5.136,5.193,5.247,5.298
9130	DATA 5.347,5.394,5.438,5.481,5.521,5.561,5.598,5.635,5.67,5.704
9140	DATA 5.737,5.768,5.799,5.829,5.858,5.886,5.914,5.94,5.966,5.991
9150	DATA 6.016,6.04,6.064,6.087,6.109,6.131,6.153,6.174,6.194,6.215
9160	DATA -2.303,-1.609,-1.204,-.916,-.693,-.511,-.357,-.223,-.105,0
9200	! &
	! EXP TEST DATA &
	!
9210	DATA 2.718,7.389,20.086,54.598,148.413,403.429,1096.63,2980.96
9220	DATA 8103.08,22026.5,.368,.135,.05,.018,.007,.002
9230	DATA .001,0,0,0,1,1.105,1.221,1.35
9240	DATA 1.492,1.649,1.822,2.014,2.226,2.46,1,.905
9250	DATA .819,.741,.67,.607,.549,.497,.449,.407
9300	! &
	! SQR TEST DATA &
	!
9310	DATA 10,14.142,17.321,20,22.361,24.495,26.458,28.284
9320	DATA 30,31.623,33.166,34.641,36.056,37.417,38.73,40
9330	DATA 41.231,42.426,43.589,44.721,45.826,46.904,47.958,48.99
9340	DATA 50,50.99,51.962,52.915,53.852,54.772,55.678,56.569
9350	DATA 57.446,58.31,59.161,60,60.828,61.644,62.45,63.246
9360	DATA 64.031,64.807,65.574,66.333,67.082,67.823,68.557
9370	DATA 69.282,70,70.711 &
	&

19000	! &
	&
	&
	!	S T A N D A R D   E R R O R   T R A P &
	&

19010	S$=SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)) &
		! GET ERROR MESSAGE TEXT &
	\ RESUME 32767 IF ERR=11% AND ERL<=1110% &
		! EXIT QUIETLY IF USER TYPED CTRL/Z TO A PROMPT. &
	\ IF ERR=52% AND ERL=1100% THEN &
		PRINT "?Illegal number of minutes selected." &
	\	RESUME 1100% &
		! TRAP ILLEGAL NUMBERS. &

19020	E%=E%+1% &
	! INCREMENT TOTAL ERROR COUNT &

19030	PRINT &
	\ PRINT CVT$$(RIGHT(S$,3%),4%);" at line";ERL;"in CPEXER ";I$ &
		UNLESS ERL=2000% &
	! PRINT THE ERROR &

19060	IF ERL=2000 THEN &
		PRINT "?CPEXER PEEK failed at memory location";I7%; &
			"- ";CVT$$(RIGHT(S$,3%),4%) &
	\	PRINT "Continuing ..." &
	\	RESUME 2010 &
	! CHECK FOR PEEK ERROR. &

19070	RESUME 4900 &
	! RESUME AT 4900 TO PERFORM NEXT FUNCTION &

32700	PRINT &
	\ PRINT "?"; NUM1$(E1%); IF E1% &
	\ PRINT "No"; UNLESS E1% &
	\ PRINT " Errors detected in";K%; "Passes." &
	! PRINT NUMBER OF ERRORS AND PASSES IF ERRORS EXIST &

32710	PRINT &
	\ PRINT "?CPEXER aborting at ";TIME$(0%) &
	\ GOTO 32767 &

32767	END
