/*
 * RIM format
 *
 * 32aaaa dddddd  store dddddd at adr aaaa
 * 60aaaa         jmp to adr aaaa
 *
 * BIN loader: (digital-1-3-s-mb_ddt.bin)
 *
 * 327751: 730002		rpb          read tape
 * 327752: 327760		dio 7760     deposit to 7760
 * 327753: 107760		xct 7760     execute what we just read
 * 327754: 327776		dio 7776
 * 327755: 730002		rpb          read tape
 * 327756: 327777		dio 7777     deposit to 7777
 * 327757: 730002		rpb          read tape
 * 327760: 604542		jmp 4542
 * 327761: 217760		lac i 7760
 * 327762: 407776		add 7776     add to checksum
 * 327763: 247776		dac 7776     update checksum
 * 327764: 447760		idx 7760     7760++
 * 327765: 527777		sas 7777     skip if AC == 7777
 * 327766: 607757		jmp 7757
 * 327767: 207776		lac 7776     read checksum
 * 327770: 407777		add 7777     
 * 327771: 730002		rpb          read tape
 * 327772: 327776		dio 7776     deposit to 7776
 * 327773: 527776		sas 7776     skip if AC == 7776
 * 327774: 760400		hlt
 * 327775: 607751		jmp 7751
 * 607751: 000000
 *
 */
#include <stdio.h>
main()
{
unsigned char c;
unsigned int adr, val;
	do{
	  c = getchar();
	  if (c == 0x9a) break;		// first instruction
	}while(!feof(stdin));

	adr = c & 077;
	adr = (adr << 6) | (getchar() & 077);
	adr = (adr << 6) | (getchar() & 077);
	val = getchar() & 077;
	val = (val << 6) | getchar() & 077;
	val = (val << 6) | getchar() & 077;
	printf("%06o: %06o\n", adr, val);

	do{
	  c = getchar();
	  if(( c & 0x80) == 0) break; // end of RIM
	  adr = c & 077;
	  adr = (adr << 6) | (getchar() & 077);
	  adr = (adr << 6) | (getchar() & 077);
  	  val = getchar() & 077;
	  val = (val << 6) | getchar() & 077;
	  val = (val << 6) | getchar() & 077;
	  printf("%06o: %06o\n", adr, val);
	}while(!feof(stdin));

	/* program body */

	printf("\n");
	do{
		if(((val = getchar()) & 0x80) == 0) continue;
		val &= 077;
		val = (val << 6) | (getchar() & 077);
		val = (val << 6) | (getchar() & 077);
		printf("%06o\n", val);
	}while(!feof(stdin));

}

