/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	cam_config.c,v $
 * Revision 1.1.3.5  92/06/02  10:53:22  cam_proj_Janet_Schank
 * 	Moved all CAM include files out of sys.  Removed all "BOP" macros.
 * 	[92/05/26  13:02:47  Janet_Schank]
 * 
 * 	Added KZQSA support
 * 	[92/03/06  14:32:20  William_Dallas]
 * 
 * Revision 1.1.3.4  92/05/07  13:22:53  Thomas_Tierney
 * 	Merge with AG.
 * 	[92/05/07  12:42:46  Thomas_Tierney]
 * 
 * 	Check in for next ag.latest merge.
 * 	[92/04/30  10:11:56  Thomas_Tierney]
 * 
 * 	Check-in for remerge
 * 	[92/04/30  09:36:18  Thomas_Tierney]
 * 
 * 	Merge
 * 	[92/04/23  10:35:04  Thomas_Tierney]
 * 
 * 	Merged Maria Vella's CAM dev_t expansion work.
 * 	[92/04/21  16:17:01  Thomas_Tierney]
 * 
 * Revision 1.1.3.3  92/03/11  09:47:40  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.3.2  92/02/27  15:56:26  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.2.5  92/02/21  13:52:26  Janet_Schank
 * 	Added include of <mach/vm_param.h> for Alpha.
 * 	[92/02/21  13:28:00  Janet_Schank]
 * 
 * Revision 1.1.2.4  92/01/31  11:13:25  Janet_Schank
 * 	Made 64bit modifications
 * 	[92/01/31  09:37:02  Janet_Schank]
 * 
 * Revision 1.1.2.3  92/01/28  18:23:56  Janet_Schank
 * 	Merged in changes from LA.
 * 	[92/01/28  18:03:01  Janet_Schank]
 * 
 * Revision 1.1.2.2  92/01/17  13:18:26  Janet_Schank
 * 	CAM support added
 * 	[92/01/17  11:14:49  Janet_Schank]
 * 
 * $EndLog$
 */
#ifndef lint
static char *rcsid = "@(#)$RCSfile: cam_config.c,v $ $Revision: 1.1.3.5 $ (DEC) $Date: 92/06/02 10:53:22 $";
#endif

/************************************************************************
 *
 * File:	cam_config.c
 * Date:	March 8, 1991
 * Author:	Robin T. Miller
 *
 * Description:
 *	CAM peripheral driver configuration information.
 *
 * Modification History:
 *
 *	05/24/91	maria
 *			Added an entry in the CAM peripheral driver
 *			configuration table for the CAM disk driver.
 *
 *	06/07/91	maria
 *			Changed uba_driver structure to reflect the
 *			use of rz/asc for booting.
 *			Changed ifdef checks of NCAM to be NASC.
 *	06/20/91	dallas
 *			Added ctape to this file once again.
 *	06/28/91        rps
 *                      Added new configuration code.  Dynamic allocation
 *                      and addition of sim's.  
 *	07/03/91	jag
 *			changed the routines cdrv_*() to ccfg_*().
 *	07/31/91	dallas
 *			Added tz routines for the wrapper
 *	12/04/91	jag
 *			Corrected the comments for VENDORS to add their drivers.
 *
 */

/*
 * This version of cam_config.c is intended for OSF use.
 */
#include <io/common/iotypes.h>
#include <sys/types.h>			/* system level types */

#include <sys/param.h>			/* system level parameter defs */
#include <sys/buf.h>
#include <mach/vm_param.h>
#include <io/cam/dec_cam.h>
#include <io/cam/cam.h>
#include <hal/cpuconf.h>
#include <io/common/devdriver.h>
#include <io/cam/cam_config.h>
#include <io/cam/sim_config.h>
#include <io/cam/cam_debug.h>

#include "asc.h"
#include "sii.h"
#include "kzq.h"

extern int cpu;

#if NSII > 0 || NASC > 0 || NKZQ > 0

int cam_probe();

/* JAG: these should be together */
caddr_t camstd[] = { 0 };
extern struct controller *camminfo[];
extern struct device *camdinfo[];

extern int ccfg_slave();
extern int ccfg_attach(); 

extern CAM_HBA_LIST_ENTRY cam_hba_list[];
extern CAM_DME_LIST_ENTRY cam_dme_list[];
extern int cam_hba_entries;
extern int cam_hba_limit;
extern int cam_dme_entries;
extern int cam_dme_limit;

/*
 * Setup the driver structures for auto-configuration code.
 */

struct driver camdriver = {
	cam_probe,		/* CAM SIM ASC HBA probe function.	*/
	ccfg_slave,		/* CAM cdrv slave function.		*/
	(int (*)()) 0,
	ccfg_attach,		/* CAM cdrv attach function.		*/
	(int (*)()) 0,		/* Driver start transfer function.	*/
	camstd,			/* Pointer to device CSR addresses.	*/
	"rz",			/* Name of the device.			*/
	camdinfo,		/* Pointers to device structures.	*/
	"cam",			/* Name of the controller.		*/
	camminfo,		/* Pointers to controller structures.	*/
	0,			/* Want exclusive use of bdp's flag.	*/
	0,			/* Size of first csr area .		*/
	0,			/* Address space of first csr area.	*/
	0,			/* Size of second csr area.		*/
	0 			/* Address space of second csr area.	*/
};

#if NASC > 0
/*
 * Controller driver structure for ASC Host Bus Adapter (HBA).
 */
extern int sim94_probe();
extern int sim94_attach(), sim94_unload();
extern int ram94_dme_attach(), ram94_dme_unload();
extern int dma94_dme_attach(), dma94_dme_unload();

struct driver ascdriver = {
	sim94_probe,		/* CAM SIM ASC HBA probe function.	*/
	ccfg_slave,		/* CAM cdrv slave function.		*/
	0,
	ccfg_attach,		/* CAM cdrv attach function.		*/
	(int (*)()) 0,		/* Driver start transfer function.	*/
	camstd,			/* Pointer to device CSR addresses.	*/
	"rz",			/* Name of the device.			*/
	camdinfo,		/* Pointers to device structures.	*/
	"asc",			/* Name of the controller.		*/
	camminfo,		/* Pointers to controller structures.	*/
	0,			/* Want exclusive use of bdp's flag.	*/
	0,			/* Size of first csr area .		*/
	0,			/* Address space of first csr area.	*/
	0,			/* Size of second csr area.		*/
	0 			/* Address space of second csr area.	*/
};
#endif /* NASC > 0 */

#if NSII > 0
/*
 * Controller driver structure for SII Host Bus Adapter (HBA).
 */
extern simsii_probe();
extern int simsii_attach(), simsii_unload();
extern int ds3100_dme_attach(), ds3100_dme_unload();

struct driver siidriver = {
	simsii_probe,		/* CAM SIM SII HBA probe function.	*/
	ccfg_slave,		/* CAM cdrv slave function.		*/
	0,
	ccfg_attach,		/* CAM cdrv attach function.		*/
	(int (*)()) 0,		/* Driver start transfer function.	*/
	camstd,			/* Pointer to device CSR addresses.	*/
	"sii",		/* Name of the device.			*/
	camdinfo,		/* Pointers to device structures.	*/
	"sii",		/* Name of the controller.		*/
	camminfo,		/* Pointers to controller structures.	*/
	0,			/* Want exclusive use of bdp's flag.	*/
	0,			/* Size of first csr area .		*/
	0,			/* Address space of first csr area.	*/
	0,			/* Size of second csr area.		*/
	0 			/* Address space of second csr area.	*/
};

#endif /* NSII > 0 */

#if NKZQ > 0
/*
 * Controller driver structure for KZQ Host Bus Adapter (HBA).
 */
extern int simkzq_probe(), simkzq_slave();
extern int simkzq_attach(), simkzq_unload();
extern int ds5500_dme_attach(), ds5500_dme_unload();

struct driver kzqdriver = {
	simkzq_probe,		/* CAM SIM KZQ HBA probe function.	*/
	simkzq_slave,		/* CAM cdrv slave function.		*/
	0,
	ccfg_attach,		/* CAM cdrv attach function.		*/
	(int (*)()) 0,		/* Driver start transfer function.	*/
	camstd,			/* Pointer to device CSR addresses.	*/
	"kzq",			/* Name of the device.			*/
	camdinfo,		/* Pointers to device structures.	*/
	"kzq",			/* Name of the controller.		*/
	camminfo,		/* Pointers to controller structures.	*/
	0,			/* Want exclusive use of bdp's flag.	*/
	0,			/* Size of first CSR address space.	*/
	0,			/* Address space of first CSR area.	*/
	0,			/* Size of second CSR address space.	*/
	0			/* Address space of second CSR area.	*/
};
#endif /* NKZQ > 0 */

extern int cdisk_slave(), cdisk_attach();	/* Disk Driver */
extern int ctape_slave(), ctape_attach();	/* Tape Driver */

/* VENDOR: Add the extern declaratios for your hardware following this
    comment line! */

/*
 * CAM Peripheral Driver Configuration Table.
 */

CAM_PERIPHERAL_DRIVER cam_peripheral_drivers[] = {

	{ "rz", cdisk_slave, cdisk_attach },
	{ "tz", ctape_slave, ctape_attach }

/* VENDOR: Add your hardware entries following this comment line! */

};
int cam_pdrv_entries =
	sizeof(cam_peripheral_drivers) / sizeof(cam_peripheral_drivers[0]);

void
init_cam_components( void )
{
}

cam_probe(csr, prb)
caddr_t csr;
struct controller *prb;
{
    int retval = 1;
    char *hbaname;
    char *dmename;
    char modname[32];             /* this shouldn't be hard coded - RPS */

    switch( cpu )
        {
	case DS_3100:             /* sii base */
	    hbaname = "sii";
	    dmename = "siiram";
	    break;

        case DS_5000:             /* asc base */
	    if ( prb->ctlr_num == 0 )          /* base scsi? */
	      {
              hbaname = "asc";
	      dmename = "ram94";
	      }
            else                               /* TC scsi */
	      {
		if( tc_addr_to_name( csr, modname ) == -1)
		  printf("cam_probe: tc_addr_to_name failed ");
		hbaname = modname;
		dmename = modname;
	      }
	    break;

        case DS_5000_100:         /* asc base */
	    if ( prb->ctlr_num == 0 )               /* base scsi? */
	      {
		hbaname = "asc";
		dmename = "dma94";
	      }
            else                               /* TC scsi */
	      {
		if( tc_addr_to_name( csr, modname ) == -1)
		  printf("cam_probe: tc_addr_to_name failed ");
		hbaname = modname;
		dmename = modname;
	      }
	    break;

        case DS_5100:             /* sii base and extension */
	    hbaname = "sii";
	    dmename = "DS5100";
	    break;



	case DS_5500:             /* asc or kzq */
	    if(strcmp(prb->ctlr_name, "asc") == NULL){
		hbaname = "asc";
		dmename = "ram94";
	    }
	    else if( strcmp(prb->ctlr_name, "kzq") == NULL){
		hbaname = "kzq";
		dmename = "kzqram";
	    }
	    else {
		hbaname = modname;
		dmename = modname;
	    }
	    break;
	
	case DS_5400:             /* ? */
	case DS_5800:             /* ? */

        default:
	    if ( prb->ctlr_num == 0 )               /* base scsi? */
	      {
		hbaname = "asc";
		dmename = "dma94";
	      }
            else                               /* TC scsi */
	      {
		if( tc_addr_to_name( csr, modname ) == -1)
		  printf("cam_probe: tc_addr_to_name failed ");
		hbaname = modname;
		dmename = modname;
	      }
	    break;
	}

    if ( name_lookup_hba_probe( hbaname, csr, prb ) != CAM_REQ_CMP )
        {
	/* 
	 * If the attach fails don't do any further initialization.
	 */
	PRINTD( prb->ctlr_num, NOBTL, NOBTL, CAMD_INOUT,
	   ("cam_probe: hba probe lookup ('%s') failed.\n", hbaname ) );
	retval = CAM_FAILURE;
        }

    return retval;
    }

#endif


