/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vp_swap.h,v $
 * Revision 1.1.2.2  92/02/26  15:49:42  Charles_Briggs
 * 	UBC merge
 * 	[92/02/22  14:32:25  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: vp_swap.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/02/26 15:49:42 $
 */
#ifndef	__VP_SWAP__
#define __VP_SWAP__ 1
#include <mach/vm_param.h>
#include <vm/vmparam.h>
#include <sys/types.h>

/*
 * Operations to VOP_SWAP
 */

typedef enum {VPS_OPEN, VPS_CLOSE, VPS_MAP} vp_swap_op_t;


/*
 * Information returned by VP swap open and sent back on close
 */

struct vps_info {
	char	vps_flags;		/* Flags see below */
	short	vps_shift; 		/* shift to apply for VTOL */
	int	vps_size;		/* size of swap space */
	struct	vnode *vps_vp;		/* vnode */
	struct	vnode *vps_rvp;		/* rvnode */
	dev_t	vps_dev;		/* dev_t */
	vm_offset_t	
		vps_private;		/* vnode private pointer for vps_map */
};

#define	VPS_NOMAP	0x01		/* 
					 * swap offset to logical is shift 
					 * and don't call map function
					 * ie., single I/O operation by
					 * strategy routine can make the full
					 * page transfer
					 */
	

struct vps_map {
	vm_offset_t	vps_offset;	/* offset in file */
	short		vps_nblkno;	/* number of blocks in */
	vm_offset_t 	vps_private;	/* private date from open */
					/* block on the device */
#ifdef	PAGE_SIZE_FIXED
	daddr_t		vps_blkno[PAGE_SIZE/MIN_SWAPFSBLOCKSIZE];	
#else
	daddr_t		vps_blkno[MAX_PAGE_SIZE/MIN_SWAPFSBLOCKSIZE];
#endif	PAGE_SIZE_FIXED
};
	

#endif /* !__VP_SWAP__ */
