/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	sysinfo.h,v $
 * Revision 4.2.2.8  92/03/27  15:08:01  William_Brown
 * 	"added SIA hooks for DASS"
 * 
 * Revision 4.2.9.5  92/03/27  15:01:55  William_Brown
 * 	submit checkin
 * 
 * Revision 4.2.2.7  92/03/25  12:53:39  Debra_Haeck
 * 	bmerge -r$NEW
 * 	[92/03/25  10:44:27  Debra_Haeck]
 * 
 * 	bci before bsubmit
 * 	[92/03/25  10:12:11  Debra_Haeck]
 * 
 * 	added GSI_STATIC_DEF command.
 * 	[92/03/18  07:36:54  Debra_Haeck]
 * 
 * Revision 4.2.2.6  92/03/24  17:25:22  Carlos_Christensen
 * 	Merged with ag.latest
 * 	[92/03/19  16:35:14  Carlos_Christensen]
 * 
 * Revision 4.2.2.5  92/03/12  14:31:01  Timothy_Burke
 * 	Removed GSI_DEV_MOD command, it is now in the hal file.  Added
 * 	warning notice to also look in <hal/hal_sysinfo.h> before adding
 * 	a new GSI_ or SSI_ define.
 * 	[92/03/04  09:17:52  Timothy_Burke]
 * 
 * Revision 4.2.2.4  92/03/11  15:38:20  Daniel_Fay
 * 	Moved GSI_BOOTTYPE outside the #if ULT_BIN_COMPAT area.
 * 	[92/03/11  14:23:35  Daniel_Fay]
 * 
 * Revision 4.2.2.3  92/02/06  10:49:23  Philip_Cameron
 * 	Added GSI_COMPAT_MOD and GSI_DEV_MOD commands.
 * 	[92/02/04  15:06:09  Philip_Cameron]
 * 
 * Revision 4.2.2.2  92/01/22  14:48:57  Dave_Gerson
 * 	Appended SWOE layer macros reqd by {get,set}sysinfo() to data supplied
 * 	by OSF.  Eliminated inclusion of machine/sysinfo.h.
 * 	[92/01/21  14:39:41  Dave_Gerson]
 * 
 * Revision 4.2.2.5  92/03/12  14:31:01  Timothy_Burke
 * 	Removed GSI_DEV_MOD command, it is now in the hal file.  Added
 * 	warning notice to also look in <hal/hal_sysinfo.h> before adding
 * 	a new GSI_ or SSI_ define.
 * 	[92/03/04  09:17:52  Timothy_Burke]
 * 
 * Revision 4.2.2.4  92/03/11  15:38:20  Daniel_Fay
 * 	Moved GSI_BOOTTYPE outside the #if ULT_BIN_COMPAT area.
 * 	[92/03/11  14:23:35  Daniel_Fay]
 * 
 * Revision 4.2.2.3  92/02/06  10:49:23  Philip_Cameron
 * 	Added GSI_COMPAT_MOD and GSI_DEV_MOD commands.
 * 	[92/02/04  15:06:09  Philip_Cameron]
 * 
 * Revision 4.2.2.2  92/01/22  14:48:57  Dave_Gerson
 * 	Appended SWOE layer macros reqd by {get,set}sysinfo() to data supplied
 * 	by OSF.  Eliminated inclusion of machine/sysinfo.h.
 * 	[92/01/21  14:39:41  Dave_Gerson]
 * 
 * Revision 4.2.9.4  92/03/27  11:56:37  William_Brown
 * 	ci for ag merge
 * 
 * Revision 4.2.9.3  92/03/27  11:27:00  William_Brown
 * 	pre submit checkin two
 * 
 * Revision 4.2.9.2  92/03/27  10:27:31  William_Brown
 * 	pre-submit checkin
 * 
 * Revision 4.2  91/09/19  23:01:02  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: sysinfo.h,v $ $Revision: 4.2.2.8 $ (DEC) $Date: 92/03/27 15:08:01 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * IBM CONFIDENTIAL
 * Copyright International Business Machines Corp. 1989
 * Unpublished Work
 * All Rights Reserved
 * Licensed Material - Property of IBM
 */
/*
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */ 

/* sysinfo.h	5.2 87/01/09 18:25:51 */
/*
 * OSF/1 Release 1.0
 */

#ifndef _SYS_SYSINFO_H_
#define _SYS_SYSINFO_H_

/*  NOTE:  An assembly-language version of these structures exists
 *            in "sysinfo.m4".  BE SURE to update that file whenever
 *            <sys/sysinfo.h> is changed!!!
 */

#include <sys/types.h>

struct sysinfo {
#define	CPU_NTIMES	4 	/* number of cpu times */
	time_t	cpu[CPU_NTIMES];   /* this array is updated every clock tick,
			     and keys off the state of the current running
			     process */
#define	CPU_IDLE	0 /* slot incremented whenever the 'wait' process
			     is the current running process */
#define	CPU_USER	1 /* slot incremented whenever the current running
			     process is executing in user mode */
#define CPU_KERNEL	2 /* slot incremented whenever the current running 
			     process is executing in kernel mode */
#define	CPU_WAIT	3 /* slot is always zero. This slot used to be
			     incremented whenever the current running process
			     was waiting for a block i/o request to
			     complete. Currently, whenever a process becomes
			     blocked, it is put to sleep and a new process
			     is made the current running process (i.e. processes
			     no longer maintain control of the cpu when they 
			     become blocked). */
	time_t	wait[3];
#define	W_IO	0
#define	W_SWAP	1
#define	W_PIO	2
#define	sysfirst	bread	/* first sysinfo variable - used by sysrates()
			  	   sysfirst define should be maintained as 
				   first non-array sysinfo variable */
	long	bread;
	long	bwrite;
	long	lread;
	long	lwrite;
	long	phread;
	long	phwrite;
	long	pswitch;
	long	syscall;
	long	sysread;
	long	syswrite;
	long	sysfork;  /* field is incremented by one whenever a 'fork'
			     is done */
	long	sysexec;  /* field is incremented by one whenever a 'exec'
			     is done */
	long	runque;   /* every second the process table is scanned to
			     determine the number of processes that are
			     ready to run. If that count is > 0 the
			     current number of ready processes is added 
			     to 'runque' (i.e. 'runque' is a cummulative
			     total of ready processes at second intervals). */
	long	runocc;   /* whenever 'runque' is updated, 'runocc'
			     is incremented by 1 (can be used to compute
			     the simple average of ready processes). */
	long	swpque;   /* every second the process table is scanned to 
			     determine the number of processes that are
			     inactive because they are waiting to be paged
			     in. If that count is > 0 then the current number
			     of processes waiting to be paged in is added
			     to 'swpque' (i.e. 'swpque' is a cummulative
			     total of processes waiting to be swapped in
			     at second intervals). */
	long	swpocc;   /* whenever 'swpque' is updated, 'swpocc' is 
			     incremented by one (can be used to compute
			     the simple average of processes waiting to be 
			     paged in).*/
	long	iget;
	long	namei;
	long	dirblk;
	long	readch;
	long	writech;
	long	rcvint;
	long	xmtint;
	long	mdmint;
	long	rawch;
	long	canch;
	long	outch;
	long	msg;
	long	sema;
	long    ksched;   /* field is incremented by one whenever a kernel
                             process is created */
	long    koverf;   /* field is incremented by one whenever an  attempt
			     is made to create a kernel process and:
				- the user has forked to their maximum limit
					       - OR -
				- the configuration limit of processes has been
				  reached */
	long    kexit;    /* field is incremented by one immediately after the
			     kernel process becomes a zombie */
	long    rbread;         /** remote read requests       **/
	long    rcread;         /** reads from remote cache    **/
	long    rbwrt;          /** remote writes              **/
	long    rcwrt;          /** cached remote writes       **/
#define	syslast		rcwrt	/* last sysinfo variable - used by sysrates() 
				   syslast define should be maintained as 
				   last non-array sysinfo variable */
};

extern struct sysinfo sysinfo;
extern struct sysinfo sysrate;
extern struct sysinfo syshist;

struct syswait {
	short	iowait;
	short	physio;
};

extern struct syswait syswait;

struct syserr {
	long	inodeovf;
	long	fileovf;
	long	textovf;
	long	procovf;
	long	sbi[5];
#define	SBI_SILOC	0
#define	SBI_CRDRDS	1
#define	SBI_ALERT	2
#define	SBI_FAULT	3
#define	SBI_TIMEO	4
};

extern struct syserr syserr;

/*
 *	The following contains constants used with the getsysinfo() and
 *	setsysinfo() system calls.
 *
 *	Both of these calls are operation driven; particular
 *	flavors of operation may use arguments, identifiers, flags, etc.
 *	to define the actual result.
 *
 */

/***************************************************************************
 ***************************************************************************
 **  WARNING, HAZARD, WATCH OUT, NOTICE!!!!!!!!!!!!!!
 **
 ** Whenever adding a new GSI or SSI number look in both <hal/hal_sysinfo.h>
 ** and <sys/sysinfo.h> to make sure that the function numbers remain unique!
 ** The defines for GSI/SSI appear in these two header files and can not
 ** overlap, otherwise the hal variant would never be called!
 **
 ***************************************************************************
 ***************************************************************************/


/*
 *	getsysinfo() operation types
 */

#define GSI_PROG_ENV	1	/* Return process compatibility mode of */
                                /* the process as defined in <sys/exec.h> */

#define GSI_MAX_UPROCS	2	/* Return the maximum number of processes */
                                /* allowed per user id */

#define	GSI_TTYP	3	/* Return the device number of the */
                                /* controlling terminal */

#define GSI_BOOTDEV	5	/* Return the bootdev string */
				/* which is used for install */

#ifdef mips

/* 
 * these return value of the flag 
 * that turns on/off printing the 
 * fixed up unaligned access message 
 */
#define GSI_UACSYS      6       /* get system wide flag */

#define GSI_UACPARNT    7	/* get parents */

#define GSI_UACPROC     8	/* get current proc */

/*
 * Returns network interface boot type
 */
#define	GSI_BOOTTYPE	13	/* Network Interface boot type */

#endif /* mips */

#define	GSI_LMF		9	/* License management facility (LMF) */

#if ULT_BIN_COMPAT

#define GSI_MMAPALIGN   12      /* support for mmap device drivers */

#define GSI_VPTOTAL	14      /* number of vector processors in system */

#define GSI_SCS		15	/* Systems Communications Services */

#define	GSI_PHYSMEM	19	/* Amount of physical memory in KB */

#define GSI_DNAUID	20	/* DNA UID genterator (UUID) */

#endif /* ULT_BIN_COMPAT */


/* All values from 1 - 22 are reserved. This is for compatibility */
/* with ULTRIX							  */

#define GSI_ROOTDEV     31     /* root device */

#define GSI_DUMPDEV     32     /* dump device */

#define GSI_SWAPDEV     33     /* dump device */

#define GSI_COMPAT_MOD	35	/* return compat_mod struct	*/

#define	GSI_STATIC_DEF	36	/* return Assign_entry struct	*/

#define GSI_SIA_PROC_CRED_VAL	37	/* return SIA proc auth val */

/*
 *	setsysinfo() operation types
 */

#define	SSI_NVPAIRS	1	/* Use a list of name value pairs to modify */
                                /* pre-defined system variables */

#define	SSI_ZERO_STRUCT	2	/* Zero a pre-defined system structure */

#define	SSI_SET_STRUCT	3	/* Set a pre-defined system structure to */
                                /* supplied values */

/*
 *	setsysinfo() SSI_NVPAIRS variable names
 */

#define	SSIN_NFSPORTMON 1	/* A boolean which determines whether */
                                /* incoming NFS traffic is originating */
                                /* at a privileged port or not */

#define	SSIN_NFSSETLOCK	2	/* A boolean which determines whether NFS */
                                /* (daemon) style file and record locking */
                                /* is enabled or not */

#define SSIN_PROG_ENV	3	/* set prog environment, BSD, SYSV, POSIX */

#ifdef mips
/* see GSI_UACxxx */
#define SSIN_UACSYS	4	/* set system printing on/off */
#define SSIN_UACPARNT	5	/* set parent proc on/off */
#define SSIN_UACPROC	6	/* set current proc on/off */
#endif /* mips */

/* All values from 1 - 8 are reserved for compatibility with ULTRIX */
#define SSI_LMF         7       /* License managment faciility (LMF) */

#if	ULT_BIN_COMPAT
#define SSI_LOGIN	8	/* Identify caller as a login process */
				/* (Sets SLOGIN flag in proc struct) */
#endif /* ULT_BIN_COMPAT */

#define SSI_SLIMIT      9      /* BVT */
#define SSI_ULIMIT     10      /* BVT */
#define SSI_DUMPDEV    11      /* Set dump device */

#define SSI_SIA_PROC_CRED_VAL	12	/* set SIA proc auth val */

#endif /* _SYS_SYSINFO_H_ */
