/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	mi.h,v $
 * Revision 4.2  91/09/19  22:53:52  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: mi.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:53:52 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/** Copyright (c) 1988  Mentat Inc. */

#ifndef _MI_H
#define _MI_H

#include <sys/types.h>

#define GET_TYPE_FROM_FLAGS(flags)	(((flags) >> 8) & 0xFF)
#define	SET_TYPE_IN_FLAGS(flags, type)	(flags = ((flags) & ~0xFF00) | (((type) & 0xFF) << 8))

typedef struct gq_s {
	struct	gq_s *	gq_next;
	struct	gq_s *	gq_prev;
	char *		gq_data;
} GQ, * GQP;

#ifdef	_NO_PROTO

extern	int		mi_addr_scanf();
extern	queue_t *	mi_allocq();
extern	void		mi_bufcall();
extern	int		mi_close_comm();
extern	void		mi_free();
extern	char *		mi_gq_head();
extern	void		mi_gq_in();
extern	void		mi_gq_init();
extern	void		mi_gq_out();
extern	int		mi_iprintf();
extern	int		mi_link_device();
extern	int		mi_mpprintf();
extern	int		mi_mpprintf_putc();
extern	caddr_t		mi_next_ptr();
extern	int		mi_open_comm();
extern	int		mi_set_sth_wroff();
extern	int		mi_sprintf();
extern	int		mi_sprintf_putc();
extern	int		mi_strcmp();
extern	int		mi_strcmpf();
extern	int		mi_strncmpf();
extern	int		mi_strlen();
extern	int		mi_strlenf();
extern	int		mi_strlog();
extern	long		mi_strtol();
extern	void		mi_timer();
extern	mblk_t *	mi_timer_alloc();
extern	void		mi_timer_free();
extern	int		mi_timer_valid();
extern	int		mi_nd_get();
extern	int		mi_nd_set();
extern	mblk_t *	mi_tpi_ack_alloc();
extern	mblk_t *	mi_tpi_conn_con();
extern	mblk_t *	mi_tpi_conn_ind();
extern	mblk_t *	mi_tpi_conn_req();
extern	mblk_t *	mi_tpi_data_ind();
extern	mblk_t *	mi_tpi_data_req();
extern	mblk_t *	mi_tpi_discon_ind();
extern	mblk_t *	mi_tpi_discon_req();
extern	mblk_t *	mi_tpi_err_ack_alloc();
extern	mblk_t *	mi_tpi_exdata_ind();
extern	mblk_t *	mi_tpi_exdata_req();
extern	mblk_t *	mi_tpi_info_req();
extern	mblk_t *	mi_tpi_ioctl_info_req();
extern	mblk_t *	mi_tpi_ok_ack_alloc();
extern	mblk_t *	mi_tpi_ordrel_ind();
extern	mblk_t *	mi_tpi_ordrel_req();
extern	mblk_t *	mi_tpi_uderror_ind();
extern	mblk_t *	mi_tpi_unitdata_ind();
extern	mblk_t *	mi_tpi_unitdata_req();
extern	caddr_t		mi_zalloc();
extern	void		mi_bzero();

#else	/* _NO_PROTO */

extern	int		mi_addr_scanf(char *, char **, int, char *, int, char *);
extern	queue_t *	mi_allocq(struct streamtab *);
extern	void		mi_bufcall(queue_t *, int, int);
extern	int		mi_close_comm(caddr_t *, queue_t *);
extern	void		mi_free(caddr_t);
extern	char *		mi_gq_head(GQP);
extern	void		mi_gq_in(GQP, GQP);
extern	void		mi_gq_init(GQP, char *);
extern	void		mi_gq_out(GQP);
extern	int		mi_iprintf(char *, va_list, pfi_t, char *);
extern	int		mi_link_device(queue_t *, char *);
extern	int		mi_mpprintf(mblk_t *, char *, ...);
extern	int		mi_mpprintf_putc(char *, char);
extern	caddr_t		mi_next_ptr(caddr_t);
extern	int		mi_open_comm(caddr_t *, ulong, queue_t *, dev_t, int, int);
extern	int		mi_set_sth_wroff(queue_t *, int);
extern	int		mi_sprintf(char *, char *, ...);
extern	int		mi_sprintf_putc(char *, char);
extern	int		mi_strcmp(char *, char *);
extern	int		mi_strcmpf(char *, char *);
extern	int		mi_strncmpf(char *, char *, int);
extern	int		mi_strlen(char *);
extern	int		mi_strlenf(char *);
extern	int		mi_strlog(queue_t *, ...);
extern	long		mi_strtol(char *, char **, int);
extern	void		mi_timer(queue_t *, mblk_t *, long);
extern	mblk_t *	mi_timer_alloc(ulong);
extern	void		mi_timer_free(mblk_t *);
extern	int		mi_timer_valid(mblk_t *);
extern	int		mi_nd_get(queue_t *, char *, int, uint);
extern	int		mi_nd_set(queue_t *, char *, int, uint);
extern	mblk_t *	mi_tpi_ack_alloc(mblk_t *, uint, uint);
extern	mblk_t *	mi_tpi_conn_con(mblk_t *, char *, int, char *, int);
extern	mblk_t *	mi_tpi_conn_ind(mblk_t *, char *, int, char *, int, int);
extern	mblk_t *	mi_tpi_conn_req(mblk_t *, char *, int, char *, int);
extern	mblk_t *	mi_tpi_data_ind(mblk_t *, int, int);
extern	mblk_t *	mi_tpi_data_req(mblk_t *, int, int);
extern	mblk_t *	mi_tpi_discon_ind(mblk_t *, int, int);
extern	mblk_t *	mi_tpi_discon_req(mblk_t *, int);
extern	mblk_t *	mi_tpi_err_ack_alloc(mblk_t *, int, int);
extern	mblk_t *	mi_tpi_exdata_ind(mblk_t *, int, int);
extern	mblk_t *	mi_tpi_exdata_req(mblk_t *, int, int);
extern	mblk_t *	mi_tpi_info_req(void);
extern	mblk_t *	mi_tpi_ioctl_info_req(uint);
extern	mblk_t *	mi_tpi_ok_ack_alloc(mblk_t *);
extern	mblk_t *	mi_tpi_ordrel_ind(void);
extern	mblk_t *	mi_tpi_ordrel_req(void);
extern	mblk_t *	mi_tpi_uderror_ind(char *, int, char *, int, int);
extern	mblk_t *	mi_tpi_unitdata_ind(mblk_t *, char *, int, char *, int);
extern	mblk_t *	mi_tpi_unitdata_req(mblk_t *, char *, int, char *, int);
extern	caddr_t		mi_zalloc(ulong);
extern	void		mi_bzero(char *, int);

#endif	/* _NO_PROTO */

#endif /* _MI_H */
