/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	npsysap.h,v $
 * Revision 1.1.2.2  92/02/24  11:54:28  Peter_Keilty
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:41:48  Peter_Keilty]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: npsysap.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/02/24 11:54:28 $
 */
/*
 * derived from npsysap.h	5.1	(ULTRIX)	8/5/91
 */
/************************************************************************
 *                                                                      *
 *                      Copyright (c) 1988 - 1989 by                    *
 *              Digital Equipment Corporation, Maynard, MA              *
 *                      All rights reserved.                            *
 *                                                                      *
 *   This software is furnished under a license and may be used and     *
 *   copied  only  in accordance with the terms of such license and     *
 *   with the  inclusion  of  the  above  copyright  notice.   This     *
 *   software  or  any  other copies thereof may not be provided or     *
 *   otherwise made available to any other person.  No title to and     *
 *   ownership of the software is hereby transferred.                   *
 *                                                                      *
 *   The information in this software is subject to change  without     *
 *   notice  and should not be construed as a commitment by Digital     *
 *   Equipment Corporation.                                             *
 *                                                                      *
 *   Digital assumes no responsibility for the use  or  reliability     *
 *   of its software on equipment which is not supplied by Digital.     *
 *                                                                      *
 ************************************************************************
 *
 *
 *   Facility:	Systems Communication Architecture
 *		Computer Interconnect N_PORT Port Driver
 *
 *   Abstract:	This module contains Computer Interconnect N_PORT Port Driver
 *		constants and data structure definitions visible to SYSAPs.
 *
 *   Creator:	Peter Keilty	Creation Date:	July 1, 1991
 *	        This file derived from Todd Katz CI port driver.
 *
 *   Modification History:
 *
 *   31-Oct-1991	Peter Keilty
 *	Ported to OFS/1
 *
 */

/* CI Constants.
 */

/* N_PORT CI Data Structure Definitions.
 */
typedef struct _npbname {		/* Buffer Name structure	     */
    u_int    bdl_idx	: 8;		/* Index into buffer descriptor leaf */
    u_int    bdlt_idx	:12;		/* Index into BDLT		     */
    u_int    key	:12;		/* Buffer key - matched with command */
					/* ( sequence number )		     */
} NPBNAME;

typedef struct _npbhandle {		/* N_PORT Buffer Handle		     */
    u_int	    boff;		/* Transfer offset of buffer         */
    NPBNAME	    bname;		/* N_PORT buffer name		     */
} NPBHANDLE;

typedef	struct _nplpib	{		/* N_PORT CI Local Port Information  */
    u_int      dg_size;                 /* Size of application datagram      */
    u_int      msg_size;                /* Size of application message       */
    u_short     ovhd_pd;                /* Size of PD overhead 		     */
    u_short     ovhd;                   /* Size of PD + PPD overhead 	     */
    u_char	rpslogmap[ CIPPD_MAPSIZE ];/* Remote port state port log map */
} NPLPIB;

typedef struct _nppib	{		/* CI Path Information		     */
    struct	{			/* Remote port microcode level	     */
	u_int	rom_level	:  8;	/*  PROM/Self-test ucode rev level   */
	u_int	fn_level	:  8;	/*  Functional ucode revision level  */
	u_int			: 16;	
    } ucode_rev;
    u_int	  port_fcn;		/* Remote port functionality mask    */
    u_int	  port_fcn_ext;		/* Rem port functionality extension  */
    u_int	  port_fcn_ext2;	/* Rem port functionality extension 2*/
    u_char	  rport_state;		/* Remote port state		     */
#define	PS_UNINIT		0	/*  Uninitialized		     */
#define	PS_UNINIT_MAINT		1	/*  Maintenance/Uninitialized	     */
#define	PS_DISAB		2	/*  Disabled			     */
#define	PS_DISAB_MAINT		3	/*  Maintenance/Disabled	     */
#define	PS_ENAB			4	/*  Enabled			     */
#define	PS_ENAB_MAINT		5	/*  Maintenance/Enabled		     */
    u_char	  reset_port;		/* Remote port's resetting port      */
    u_short			: 16;
} NPPIB;
