/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	mips_ptrace.h,v $
 * Revision 1.1.3.2  91/11/20  13:45:38  Hal_Project
 * 	Moved from dec/machine/mips; pool reorg.
 * 	[91/11/18  00:08:11  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:12:02  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: mips_ptrace.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 91/11/20 13:45:38 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * derived from mips_ptrace.h	2.1	(ULTRIX/OSF)	12/3/90
 */

/*
 * register number definitions for PT_READ_U's and PT_WRITE_U's
 */
#define GPR_BASE	0			/* general purpose regs */
#define	NGP_REGS	32			/* number of gpr's */

#define FPR_BASE	(GPR_BASE+NGP_REGS)	/* fp regs */
#define	NFP_REGS	32			/* number of fp regs */

#define	SIG_BASE	(FPR_BASE+NFP_REGS)	/* sig handler addresses */
#define	NSIG_HNDLRS	32			/* number of signal handlers */

#define SPEC_BASE	(SIG_BASE+NSIG_HNDLRS)	/* base of spec purpose regs */
#define PC		SPEC_BASE+0		/* program counter */
#define	CAUSE		SPEC_BASE+1		/* cp0 cause register */
#define MMHI		SPEC_BASE+2		/* multiply high */
#define MMLO		SPEC_BASE+3		/* multiply low */
#define FPC_CSR		SPEC_BASE+4		/* fp csr register */
#define FPC_EIR		SPEC_BASE+5		/* fp eir register */
#define TRAPCAUSE	SPEC_BASE+6		/* multiplex SIGTRAP cause */
#define TRAPINFO	SPEC_BASE+7		/* associated info to SIGTRAP */
#define NSPEC_REGS	8			/* number of spec registers */
#define NPTRC_REGS	(SPEC_BASE + NSPEC_REGS)

/*
 * causes for SIGTRAP
 */
#define CAUSEEXEC	1		/* traced process exec'd */
#define CAUSEFORK	2		/* traced process fork'd */
#define CAUSEWATCH	3		/* traced process hit a watchpoint */
#define CAUSESINGLE	4		/* traced process executed 1 instr */
#define CAUSEBREAK	5		/* traced process hit a breakpoint */
#define	CAUSETRACEON	6		/* initial trap after PTRC_TRACEON */

