/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	cma_px.h,v $
 * Revision 4.3  91/11/26  11:29:57  devbld_zk3
 * 	Baselevel AG_BL0
 * 
 * Revision 4.2.2.2  91/10/24  15:43:54  William_Burns
 * 	Merge from ODE/TIN: revision 3.1.9.2
 * 	date: 91/10/22 19:23:20;  author: devrcs;  state: Exp;  lines added/del: 5/2
 * 	sccs rev: 3.2;  orig date: 91/10/03 16:03:34;  orig author: scales
 * 	Fix typo in os-impl symbol (removed extra underscore)
 * 	[91/10/24  14:43:52  William_Burns]
 * 
 * Revision 4.2  91/09/20  04:57:53  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *	@(#)$RCSfile: cma_px.h,v $ $Revision: 4.3 $ (DEC) $Date: 91/11/26 11:29:57 $
 */
/*
 *  Copyright (c) 1990. 1991 by
 *  Digital Equipment Corporation, Maynard Massachusetts.
 *  All rights reserved.
 *
 *  This software is furnished under a license and may be used and  copied
 *  only  in  accordance  with  the  terms  of  such  license and with the
 *  inclusion of the above copyright notice.  This software or  any  other
 *  copies  thereof may not be provided or otherwise made available to any
 *  other person.  No title to and ownership of  the  software  is  hereby
 *  transferred.
 *
 *  The information in this software is subject to change  without  notice
 *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment
 *  Corporation.
 *
 *  DIGITAL assumes no responsibility for the use or  reliability  of  its
 *  software on equipment which is not supplied by DIGITAL.
 */

/*
 *  FACILITY:
 *
 *	CMA services
 *
 *  ABSTRACT:
 *
 *	Header file for POSIX wrapper routines
 *
 *  AUTHORS:
 *
 *	Dave Butenhof
 *
 *  CREATION DATE:
 *
 *	18 May 1990
 *
 *  MODIFICATION HISTORY:
 *
 *	001	Webb Scales	25 Septemeber 1990
 *		Put in ifndef/define around POSIX type definitions to prevent
 *		collisions with other pre-POSIX facilities.
 *	002	Paul Curtin	 11 December 1990
 *		Added sigaction work, and split some of cma_px.h off
 *		into cma_sigwait.h
 *	003	Paul Curtin	31 January 1991
 *		Added _CMA_NOWRAPPERS_ conditional statements
 *	004	Dave Butenhof	5 February 1991
 *		To avoid breaking client code (now that this is pulled in
 *		transparently by cma.h, pthread.h, pthread_exc.h), drop all
 *		the header file includes; which means also dropping the
 *		prototypes (oh well).
 *	005	Dave Butenhof	10 May 1991
 *		Remove cma_signal() declaration... the macro is sufficient,
 *		since it will "reroute" the declaration in
 *		/usr/include/signal.h when the client code includes it.
 *	006	Dave Butenhof	23 May 1991
 *		Add conditionals for _CMA_UNIPROCESSOR_ so kernel-thread
 *		versions of DECthreads can still use some wrappers (e.g.,
 *		cma_sigaction()).
 *	007	Webb Scales	10 June 1991
 *		Conditionalize out sigaction macro for kernel threads.
 *	008	Webb Scales	 8 July 1991
 *		Fix typo in os-impl symbol name.
 */


#ifndef CMA_PX
#define CMA_PX

/*
 *  INCLUDE FILES
 */

/*
 * CONSTANTS AND MACROS
 */

#ifndef _CMA_NOWRAPPERS_
# if _CMA_UNIPROCESSOR_
#  define sigaction cma_sigaction   
# endif
#endif

/*
 * TYPEDEFS
 */

#if _CMA_OSIMPL_ == _CMA__OS_OSF
# include <sys/timers.h>
#else
# ifndef _TIMESPEC_T_
# define _TIMESPEC_T_
typedef struct timespec {
    unsigned long	tv_sec;		/* seconds */
    long		tv_nsec;	/* and nanoseconds */
    } timespec_t;
# endif
#endif

/*
 * INTERFACES
 */

#endif  /* CMA_PX */
/*  DEC/CMS REPLACEMENT HISTORY, Element CMA_PX.H */
/*  *12    8-JUL-1991 15:46:25 SCALES "Fix typo in os-impl symbol" */
/*  *11   10-JUN-1991 19:54:59 SCALES "Convert to stream format for ULTRIX build" */
/*  *10   10-JUN-1991 19:21:16 BUTENHOF "Fix the sccs headers" */
/*  *9    10-JUN-1991 18:22:56 SCALES "Add sccs headers for Ultrix" */
/*  *8    10-JUN-1991 17:54:54 SCALES "Conditionalize sigaction macro for kernel threads" */
/*  *7     5-JUN-1991 18:38:04 BUTENHOF "Include sys/timers.h for timespec" */
/*  *6    29-MAY-1991 17:02:17 BUTENHOF "Change wrapper macros for MP" */
/*  *5    10-MAY-1991 17:52:06 BUTENHOF "Remove prototype" */
/*  *4     6-FEB-1991 01:33:10 BUTENHOF "Drop prototypes to avoid pulling in signal.h, socket.h, etc." */
/*  *3    31-JAN-1991 16:37:42 CURTIN "added _CMA_NOWRAPPERS_ conditional statments" */
/*  *2    17-DEC-1990 14:34:36 CURTIN "split with cma_sigwait.h" */
/*  *1    12-DEC-1990 21:48:42 BUTENHOF "P1003.4a support" */
/*  DEC/CMS REPLACEMENT HISTORY, Element CMA_PX.H */
