/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  ERRNO definitions for transport errors	File: SKERRNO.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */
    
#ifndef DERRNO_H
    #define DERRNO_H

/*
 * DECnet error codes - "(xu)" means NOT YET SUPPORTED BY DECnet-ULTRIX
 */

#define EREJBYOBJ	    0	/* Connect: Rejected by object */
                            /* Disconnect: Disconnected by object */
#define	EINSNETRES	    1	/* Connect: Insufficient network resources */
#define EUNRNODNAM	    2	/* Connect: Unrecognized node name */
#define	EREMNODESHUT	    3	/* Connect: Remote node shutting down */
#define	EUNROBJ		    4	/* Connect: Unrecognized object */
#define	EINVOBJNAM	    5	/* Connect: Invalid object name format */
#define	EOBJBUSY	    6	/* Connect: Object too busy */
#define	EABTBYNMGT	    8	/* Disconnect: Abort by network management */
#define EUSERABORT          9   /* Disconnect: Abort by user (xu) */
#define	EINVNODNAM	    10	/* Connect: Invalid node name format */
#define	ELOCNODESHUT	    11	/* Connect: Local node shutting down */
#define	ENODERESOURCES	    32	/* Connect: No node resources for new logical link (xu) */
#define	EUSERESOURCES	    33	/* Connect: No user resources for new logical link (xu) */
#define	EACCCONREJ	    34	/* Connect: Access control rejected */
#define	EBADACCOUNT         36	/* Connect: Bad account information (xu) */
#define	ENORESPOBJ	    38	/* Connect: No response from object */
                            /* Disconnect: Remote node or object failed */
#define	ENODUNREACH	39  /* Connect: Node unreachable */
                            /* Disconnect: Connection lost, local timeout (xu) */
#define ENOLINK         41  /* Disconnect: Protocol failure, no such link (xu) */
#define ECOMPLETE       42  /* Disconnect: No error, disconnect completed (xu) */
#define ECONNTOOBIG     43  /* Connect: Connect image data field too long (xu) */

/* non-blocking and interrupt i/o */
#define	EWOULDBLOCK	35		/* Operation would block */
#define	EINPROGRESS	36		/* Operation now in progress */
#define	EALREADY	37		/* Operation already in progress */

/* ipc/network software */
/* argument errors */
#define	EDESTADDRREQ	39		/* Destination address required */
#define	EMSGSIZE	40		/* Message too long */
#define	EPROTOTYPE	41		/* Protocol wrong type for socket */
#define	ENOPROTOOPT	42		/* Protocol not available */
#define	EPROTONOSUPPORT	43		/* Protocol not supported */
#define	ESOCKTNOSUPPORT	44		/* Socket type not supported */
#define	EOPNOTSUPP	45		/* Operation not supported on socket */
#define	EPFNOSUPPORT	46		/* Protocol family not supported */
#define	EAFNOSUPPORT	47		/* Address family not supported by protocol family */
#define	EADDRINUSE	48		/* Address already in use */
#define	EADDRNOTAVAIL	49		/* Can't assign requested address */

	/* operational errors */
#define	ENETDOWN	50		/* Network is down */
#define	ENETUNREACH	51		/* Network is unreachable */
#define	ENETRESET	52		/* Network dropped connection on reset */
#define	ECONNABORTED	53		/* Software caused connection abort */
#define	ECONNRESET	54		/* Connection reset by peer */
#define	ENOBUFS		55		/* No buffer space available */
#define	EISCONN		56		/* Socket is already connected */
#define	ENOTCONN	57		/* Socket is not connected */
#define	ESHUTDOWN	58		/* Can't send after socket shutdown */
#define	ETOOMANYREFS	59		/* Too many references: can't splice */
#define	ETIMEDOUT	60		/* Connection timed out */
#define	ECONNREFUSED	61		/* Connection refused */
#define	ELOOP		62		/* Too many levels of symbolic links */
#ifndef WIN32
#define ENAMETOOLONG    63     /* File name too long */ 
#endif
#define EHOSTDOWN       64      /* Host is down */
#define EHOSTUNREACH    65      /* No route to host */
#ifndef WIN32
#define ENOTEMPTY       66     /* Directory not empty */
#endif
#define EPROCLIM        67      /* Too many processes */
#define EUSERS          68      /* Too many users */
#define EDQUOT          69      /* Disc quota exceeded */

#ifdef	PW3COM	/* Add some errno values */

	#define	FIRST_SOCK_ERROR	0
	#define	EBADVERSION		ENETUNREACH
	#define	EINVALSOCK		PW_ENOTSOCK
	#define	ETOOMANYSOCK		ENOBUFS
	/*
	 * These 2 are given explicit values because in normal practice they
	 * are in the C compiler's errno.h.  We don't want to ASSUME they've
	 * already included it.
	 */
	#define	ENODOSMEM		12
	#define	LAST_SOCK_ERROR		EDQUOT

#endif		/* PW3COM */

/*
 * PATHWORKS Error codes
 */
#define PW_EPERM       1       /* Not owner */
#define PW_ENOENT      2       /* No such file or directory */
#define PW_ESRCH       3       /* No such process */
#define PW_EINTR       4       /* Interrupted system call */
#define PW_EIO         5       /* I/O error */
#define PW_ENXIO       6       /* No such device or address */
#define PW_E2BIG       7       /* Arg list too long */
#define PW_ENOEXEC     8       /* Exec format error */
#define PW_EBADF       9       /* Bad file number */
#define PW_ECHILD      10      /* No children */
#define PW_EAGAIN      11      /* No more processes */
#define PW_ENOMEM      12      /* Not enough core */
#define PW_EACCES      13      /* Permission denied */
#define PW_EFAULT      14      /* Bad address */
#define PW_ENOTBLK     15      /* Block device required */
#define PW_EBUSY       16      /* Mount device busy */
#define PW_EEXIST      17      /* File exists */
#define PW_EXDEV       18      /* Cross-device link */
#define PW_ENODEV      19      /* No such device */
#define PW_ENOTDIR     20      /* Not a directory*/
#define PW_EISDIR      21      /* Is a directory */
#define PW_EINVAL      22      /* Invalid argument */
#define PW_ENFILE      23      /* File table overflow */
#define PW_EMFILE      24      /* Too many open files */
#define PW_ENOTTY      25      /* Not a typewriter */
#define PW_ETXTBSY     26      /* Text file busy */
#define PW_EFBIG       27      /* File too large */
#define PW_ENOSPC      28      /* No space left on device */
#define PW_ESPIPE      29      /* Illegal seek */
#define PW_EROFS       30      /* Read-only file system */
#define PW_EMLINK      31      /* Too many links */
#define PW_EPIPE       32      /* Broken pipe */

/* math software */
#define PW_EDOM        33      /* Argument too large */
#define PW_ERANGE      34      /* Result too large */

/* non-blocking and interrupt i/o */
#define PW_EWOULDBLOCK 35      /* Operation would block */
#define PW_EINPROGRESS 36      /* Operation now in progress */
#define PW_EALREADY    37      /* Operation already in progress */
#define PW_ENOTSOCK    38 	

/* ipc/network software */
/* argument errors */
#define PW_EDESTADDRREQ 39     /* Destination address required */
#define PW_EMSGSIZE    40      /* Message too long */
#define PW_EPROTOTYPE  41      /* Protocol wrong type for socket */
#define PW_ENOPROTOOPT 42      /* Protocol not available */
#define PW_EPROTONOSUPPORT 43  /* Protocol not supported */
#define PW_ESOCKTNOSUPPORT 44  /* Socket type not supported */
#define PW_EOPNOTSUPP  45      /* Operation not supported on socket */
#define PW_EPFNOSUPPORT 46     /* Protocol family not supported */
#define PW_EAFNOSUPPORT 47     /* Address family not supported by protocol family */
#define PW_EADDRINUSE  48      /* Address already in use */
#define PW_EADDRNOTAVAIL 49    /* Can't assign requested address */

/* operational errors */
#define PW_ENETDOWN    50      /* Network is down */
#define PW_ENETUNREACH 51      /* Network is unreachable */
#define PW_ENETRESET   52      /* Network dropped connection on reset */
#define PW_ECONNABORTED 53     /* Software caused connection abort */
#define PW_ECONNRESET  54      /* Connection reset by peer */
#define PW_ENOBUFS     55      /* No buffer space available */
#define PW_EISCONN     56      /* Socket is already connected */
#define PW_ENOTCONN    57      /* Socket is not connected */
#define PW_ESHUTDOWN   58      /* Can't send after socket shutdown */
#define PW_ETOOMANYREFS 59     /* Too many references: can't splice */
#define PW_ETIMEDOUT   60      /* Connection timed out */
#define PW_ECONNREFUSED 61     /* Connection refused */

/* */
#define PW_ELOOP       62      /* Too many levels of symbolic links */
#define PW_ENAMETOOLONG 63     /* File name too long */
#define PW_EHOSTDOWN   64      /* Host is down */
#define PW_EHOSTUNREACH 65     /* No route to host */
#define PW_ENOTEMPTY   66      /* Directory not empty */
#define PW_EPROCLIM    67      /* Too many processes */
#define PW_EUSERS      68      /* Too many users */
#define PW_EDQUOT      69      /* Disc quota exceeded */


#endif /* DERRNO_H */

