/*  *********************************************************************
    *  LAT Address families and such					*
    ********************************************************************* */

#define LATPROTO_LAT	1
#define LATPROTO_MAX	1


/*  *********************************************************************
    *  Definition for sockaddr_lat					*
    ********************************************************************* */

#define LAT_MAXADDL 64

struct lat_naddr {
	word	a_len;	
	byte	a_addr[LAT_MAXADDL];
	};

struct sockaddr_lat {
	word	slat_family;
	struct  lat_naddr slat_naddr;
	};


/*  *********************************************************************
    *  Parameter lists for the IOCB functions				*
    ********************************************************************* */

typedef struct localinfo_lat {
	byte	lcl_version[3];		/* our version # */
	byte	lcl_nodeaddr[6];	/* our local node address */
	word	lcl_slotsize;		/* maximum slot size */
	word	lcl_sockets;		/* # of sockets */
	} LOCALINFO_LAT;

/*
 * select() data structure for socket mask I/O examination
 */
typedef struct  select_lat
{
	unsigned short sel_nfds;	    /* Number of handles to select  */
	unsigned long  sel_read;	    /* Read handles mask */
	unsigned long  sel_write;	    /* Write handles mask */
	unsigned long  sel_except;	    /* Exception handles mask */
	unsigned short sel_seconds;	    /* Timeout value */
} SELECT_LAT;


typedef struct  select64_lat          /* extended select for 63 sockets */
{
	unsigned short sel64_nfds;	    /* Number of handles to select  */
	unsigned char  sel64_read[8];	    /* Read handles mask */
	unsigned char  sel64_write[8];	    /* Write handles mask */
	unsigned char  sel64_except[8];	    /* Exception handles mask */
	unsigned short sel64_seconds;	    /* Timeout value */
} SELECT64_LAT;

typedef struct  select256_lat          /* extended select for 255 sockets */
{
	unsigned short sel256_nfds;	    /* Number of handles to select  */
	unsigned char  sel256_read[32];	    /* Read handles mask */
	unsigned char  sel256_write[32];	    /* Write handles mask */
	unsigned char  sel256_except[32];	    /* Exception handles mask */
	unsigned short sel256_seconds;	    /* Timeout value */
} SELECT256_LAT;


/*
 * Shutdown function parameter list
 */
typedef struct	shutdown_lat
{
	unsigned short shd_how;	/* Type of shutdown */
} SHUTDOWN_LAT;

/*
 * Attach function parameter list data structure
 */			 
typedef struct	attach_lat
{		
        short   att_socket;             /* If non-zero, rest of members
                                         *  ignored and 'att_socket' socket's
                                         *  attributes are used for this attach,
                                         *  ie: accept function request
					 */
	unsigned short att_domain;	/* Domain */
	unsigned short att_type;	/* Communications type */
	unsigned short att_protocol;	/* Protocol */
        unsigned short att_srp;         /* Socket recovery period */
	unsigned short att_supreq;	/* Support requirements */
} ATTACH_LAT;   

/*
 * Listen function parameter list data structure
 */
typedef struct	listen_lat
{
	short	lsn_backlog;	/* Maximum backlog on incoming connects */
} LISTEN_LAT;

/*
 * Socket I/O control function parameter list data structure
 */									    
typedef struct	sioctl_lat
{
	short	sio_s;		    /* Socket */
	short	sio_request;	    /* Type of socket I/O request */
       /*
	* Long pointer to argument list
	*	long => (lo word)offset:(hi word)segment
        */
	exptr	sio_argp;	   /* Points to argument list */
} SIOCTL_LAT;

/*
 * Set/Getsockopt function parameter list data structure
 */				       
typedef struct  sockopt_lat
{		       
	short	sop_level;	/* Socket option level */
	short	sop_optname;	/* Socket option name */	     
       /* 
	* If sop_level = SOL_SOCKET, then rest of structure is null
	* Else if sop_level = DNPROTO_NSP, then 
	*	depending upon value of sop_optname,
	*	sop_optval may be a long pointer to either an accessdata_lat or
	*	optdata_lat structure, or a 1 byte array containing access mode
	*
        */
	exptr	sop_optval;	/* Socket option value */
       /*
	* For getsockopt(), sop_optlen is an address of int type to place
	* a returned option value length
	*
        */
	exptr	sop_optlen;	/* Socket option length */
} SOCKOPT_LAT;

/*
 *  This structure is used by TRMNLAXS to return the current
 *  status of the lat link.
 */

#define LATSTAT_TXEMPTY		0x20	// Values for ll_status
#define LATSTAT_STARTING	0x08
#define LATSTAT_INACTIVE	0x04
#define LATSTAT_CANTXMIT	0x02
#define LATSTAT_RXDATA		0x01

typedef struct linkinfo_lat {
	byte ll_state;
	byte ll_status;
	word ll_txleft;
	} LINKINFO_LAT;


/*
 * Send/Recv Buffer Descriptor structure
 *
 *  Note: first element must overlap old io_buffer pointer 
 */ 
typedef struct  buffer_lat
{
    exptr            io_buffer;      /* pointer to user buffer */
    unsigned short   io_buflen;      /* length of user buffer */
} BUFFER_LAT;



// Socket options
#define LAT_LINKINFO	1
#define LAT_SEARCH	2
#define LAT_SENDBREAK	3
#define LAT_PASSWORD	4
#define LAT_PORTNAME	5

#define LAT_BREAK_LONG	0
#define LAT_BREAK_SHORT 1

#define LATLINK_CONNECT 2
#define LATLINK_RUNNING	1
#define LATLINK_INACTIVE 0


