/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  NIOCB definitions			File: IOCB.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef IOCB_H
#define IOCB_H

// If none of the configuration #defines are set, assume DECnet
#if !defined(IOCB_INCL_LAT) && !defined(IOCB_INCL_DN) && !defined(IOCB_INCL_IN)
    #define IOCB_INCL_DN
#endif

// If IOCB_INCL_ALL is defined, rename the plists and define them all
#if defined(IOCB_INCL_ALL)
    #define IOCB_INCL_LAT
    #define IOCB_INCL_DN
    #define IOCB_INCL_IN
#endif

// Generic typedefs
#ifndef exptr
    typedef unsigned char byte;
    typedef unsigned short word;
    typedef unsigned long dword;
    #define exptr byte *
#endif

//Include files
#ifdef IOCB_INCL_DN
    #include "dn.h"             // DECnet socket symbols and structures
    #include "iocb_dn.h"
#endif
#ifdef IOCB_INCL_IN
    #include "in.h"             // TCP/IP socket symbols and structures
    #include "iocb_in.h"
#endif
#ifdef IOCB_INCL_LAT
    #include "iocb_lat.h"       // LAT symbols and structures
#endif

/*  *********************************************************************
    *  Function codes for all protocols					*
    ********************************************************************* */
#define	PRU_ATTACH		0	/* attach protocol to up */
#define	PRU_DETACH		1	/* detach protocol from up */
#define	PRU_BIND		2	/* bind socket to address */
#define	PRU_LISTEN		3	/* listen for connection */
#define	PRU_CONNECT		4	/* establish connection to peer */
#define	PRU_ACCEPT		5	/* accept connection from peer */
#define	PRU_DISCONNECT	6	/* disconnect from peer */
#define	PRU_SHUTDOWN	7	/* won't send any more data */
#define	PRU_RCVD		8	/* have taken data; more room now */
#define	PRU_SEND		9	/* send this data */
#define	PRU_ABORT		10	/* abort (fast DISCONNECT, DETATCH) */
#define	PRU_CONTROL		11	/* control operations on protocol */
#define PRU_GETNEXT             11      /* LAT-only */
#define	PRU_SENSE		12	/* return status into m */
#define	PRU_RCVOOB		13	/* retrieve out of band data */
#define	PRU_SENDOOB		14	/* send out of band data */
#define	PRU_SOCKADDR	15	/* fetch socket's address */
#define	PRU_PEERADDR	16	/* fetch peer's address */
#define	PRU_CONNECT2	17	/* connect two sockets */
#define PRU_RECVFROM	18	/* receive from below */
#define PRU_SENDTO		19	/* send to below */
#define PRU_NREQ		19	/* ?? */
#define PRU_CANCEL		20	/* Cancel previous function request */
#define PRU_NETBIOS		21	/* NETBIOS functions */
#define PRU_LOCALINFO	22	/* Local node information */
#define PRU_SELECT		23	/* Select I/O descriptors */
#define PRU_SIOCTL		24	/* Socket I/O control */
#define PRU_SETSOCKOPT	25	/* Set socket option */
#define PRU_GETSOCKOPT	26	/* Get socket option */
#define PRU_KERNELKNOW	27	/* Get kernel knowledge */
#define PRU_READLOG		28	/* read event log */
#define PRU_WRITELOG	29	/* write event log */
#define PRU_NMH 		30	/* network management request */

struct	nmh {
	short	nmh_func;
	short	nmh_entity;
	short	nmh_param;
	long 	nmh_val;
	short	nmh_cnt;
};

#ifdef IOCB_INCL_IN
    #define MIB_GET_MIB		 0		/* netstat, arp use MIB call */
    #define MIB_GET_COUNTERS 0		/* sub type of MIB_GET_MIB */
    #define MIB_GET_TABLE	 1		/* sub type of MIB_GET_MIB */

struct  mib {
	char   mib_func;
	char   mib_type;
	short  mib_entry_cnt;
	short  mib_buf_len;
	long   mib_buf_ptr;
	char   mib_depth;
	char   mib_tree[5];
	char   mib_reserved[4];
};
#endif

/*  *********************************************************************
    *  Shorthand definitions for iocb struction/union member access	*
    ********************************************************************* */

#define plcl 	    plist.io_localinfo
#ifdef IOCB_INCL_IN
    #define plcl_in 	plist.io_localinfo_in
#endif
#ifdef IOCB_INCL_LAT
    #define plcl_lat  	plist.io_localinfo_lat
#endif
#define patt	plist.io_attach
#define plsn 	plist.io_listen
#define psdn 	plist.io_sockaddr
#define psel 	plist.io_select
#define psel64	plist.io_select64
#define psel256	plist.io_select256
#define psio 	plist.io_sioctl
#define psop 	plist.io_sockopt
#define pedn 	plist.io_entrypts
#define pshd 	plist.io_shutdown
#define pbuf 	plist.io_bufd.io_buffer
#define plen 	plist.io_bufd.io_buflen
#define pclb 	plist.io_callback
#define psem 	plist.io_callback

/*  *********************************************************************
    *  IOCB structure.							*
    *  									*
    *  This consists of a header substructure which is fixed in size,	*
    *  followed by a parameter list that depends on the function.	*
    ********************************************************************* */

#define IOCB_SEAL   0x49    // IOCB  Seal "I"

typedef struct	niocb
{
#ifdef WIN32
    unsigned char   io_seal;    /* constant 'I'                    */
#endif
	unsigned char	io_fcode;   /* Function code 		           */
	short		    io_socket;  /* Socket handle 		           */
	unsigned short  io_flags;   /* Flags 			               */
	short 		    io_status;  /* Place for return status value   */
	short 		    io_errno;   /* Place for return of errno value */
	short 		    io_psize;   /* Size of function parameter list */
#ifndef WIN32
    unsigned char	io_resrv;   /* Reserved, must be zero	       */
#endif
    exptr		    io_callback; /* Callback address 		       */
	union		/* NIOCB Parameter Lists */
	{
		struct	localinfo_dn  io_localinfo;     /* localinfo for DECnet */
		struct	attach_dn     io_attach;     /* Attach (assign) */
		struct	listen_dn     io_listen;     /* Listen */
		struct	sockaddr_dn   io_sockaddr;   /* Connect, Connect Complete, */
						                     /* Accept, Bind, */
						                     /* Getsockaddr, Getpeeraddr */
		struct	select_dn     io_select;     /* Select */
		struct	select64_dn   io_select64;   /* Select64 */
		struct	select256_dn  io_select256;  /* Select256 */
		struct	sioctl_dn     io_sioctl;     /* Sioctl */
		struct	sockopt_dn    io_sockopt;    /* Set/Getsockopt */
		struct	shutdown_dn   io_shutdown;   /* Shutdown */
        struct  buffer_dn     io_bufd;       /* Buffer descriptor DECnet*/
	    struct	nmh           io_nmcb;
#ifdef IOCB_INCL_IN
		struct  localinfo_in  io_localinfo_in;  /* localinfo for IP */
		struct  sockaddr_in   io_sockaddr_in;  /* sockaddr for IP */
	    struct  tfbuffer_in   io_tfbufd;     /* Buffer descriptor IP */
#endif
#ifdef IOCB_INCL_LAT
		struct  localinfo_lat io_localinfo_lat; /* localinfo for LAT */
		struct  sockaddr_lat  io_sockaddr_lat; /* sockaddr for LAT */
        struct  buffer_lat    io_bufd_lat;   /* Buffer descriptor LAT */
#endif
		exptr	io_buffer;		             /* Cancel */
        } plist;
} NIOCB;


#endif	/* IOCB_H */

/*
 *   Flag Definitions for io_flags
 */
 
#define MSG_OOB 	    0x0001		/* process out-of-band data	     */
#define MSG_PEEK	    0x0002		/* peek at incoming message	     */
#define	MSG_DONTROUTE	0x0004		/* send without using routing tables */
#define MSG_ASYNC	    0x0008		/* perform function asynchronously   */
#define MSG_CALLBACK	0x0010		/* perform callback		     */
#define MSG_NEOM	    0x0020		/* don't do to End of Message	     */
#define MSG_NBOM	    0x0040		/* don't set Beginning of Message    */
#define MSG_NIOCB       0x0080      /* new IOCB format                   */
#define MSG_USRBUF      0x0100      /* use user buffer for data          */
#define MSG_USRWAIT     0x0200      /* don't spin in DNP                 */
#define MSG_TASKSWITCH  0x2000      /* allow task switch                 */
