/*****************************************************************************/
/*                                                                           */
/*  Copyright (c) 1990,1995                                                  */
/*  by DIGITAL Equipment Corporation, Maynard, Mass.                         */
/*                                                                           */
/*  This software is furnished under a license and may be used and  copied   */
/*  only  in  accordance  with  the  terms  of  such  license and with the   */
/*  inclusion of the above copyright notice.  This software or  any  other   */
/*  copies  thereof may not be provided or otherwise made available to any   */
/*  other person.  No title to and ownership of  the  software  is  hereby   */
/*  transferred.                                                             */
/*                                                                           */
/*  The information in this software is subject to change  without  notice   */
/*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   */
/*  Corporation.                                                             */
/*                                                                           */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its   */
/*  software on equipment which is not supplied by DIGITAL.                  */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                                                                             *
* Module:       TRMNLAXS.H                                                    *
*                                                                             *
* Purpose:      Contains the definitions of the library routines for          *
*               accessing LAT and CTERM sessions under MS-Windows 3.0 for the *
*               VT320 Terminal Emulator and other such applications           *
*                                                                             *
* Revisions:                                                                  *
*                                                                             *
*       Date            Developer       Description                           *
*       ------------    ------------    ------------------------------------- *
*       Apr,    1990    Moe Belanger    Original                              *
*       May 12, 1992    Ellen O'S       Increase service name length          *
*       Nov 10, 1992    Dennis Brannon  Added GetService, InquireServices,    *
*                                       and IE_NOSERVNAME                     *
*       Dec 06, 1994    RLG             Reformatted and added new functions   *
*                                                                             *
/******************************************************************************
;                                                                             *
; Function Declarations provided in TRMNLAXS.DLL                              *
;                                                                             *
******************************************************************************/
 int FAR PASCAL CloseSession( WORD SessionID );
 int FAR PASCAL GetLATService( LPSTR lpServiceName );  /* obsolete */
 int FAR PASCAL GetService( LPSTR lpServiceName, BYTE bType );
WORD FAR PASCAL GetStatus( WORD SessionID );
LONG FAR PASCAL InquireLATServices( VOID );  /* obsolete */
LONG FAR PASCAL InquireServices( BYTE bType );
BYTE FAR PASCAL InstalledAccess( BYTE bType );
 int FAR PASCAL OpenSession( LPSTR lpServiceName, LPSTR lpPassword, BYTE bType);
 int FAR PASCAL ReadData( WORD SessionID, LPSTR lpString, WORD wLength );
 int FAR PASCAL SendLATBreak( WORD SessionID );  /* obsolete */
 int FAR PASCAL WriteData( WORD SessionID, LPSTR lpString, WORD wLength );
 int FAR PASCAL SendBreak( WORD SessionID );
 int FAR PASCAL OpenTelnetSession( LPSTR lpServiceName, LPWORD lpPort);
 int FAR PASCAL GetInfo( WORD SessionID, BYTE bType, WORD wItemNumber,
                         WORD wTransportInfoSize, LPSTR TransportInfo);

/******************************************************************************
;                                                                             *
; Definition Declarations provided in TRMNLAXS.DLL                            *
;                                                                             *
******************************************************************************/
#define SERVICENAME_LENGTH    255      /* Length of service name            */
#define PASSWORD_LENGTH        32      /* Length of password                */

#define DONT_CARE               0       /* Try LAT first, then CTERM        */
#define LAT_ACCESS              1       /* Access the LAT driver            */
#define CTERM_ACCESS            2       /* Access the CTERM driver          */
#define BAPI_ACCESS             3       /* Access the TELNET driver         */
#define TELNET_ACCESS           3       /* Access the TELNET driver         */

/***************************************************************************/

/* LAT Status Bit Flags from GetStatus */
#define LAT_TRANSMIT_EMPTY       0x2000  /* Bit 5 - Transmit buffer empty  */
#define LAT_SESSION_STARTED      0x0800  /* Bit 3 - Session in start state */
#define LAT_SESSION_NOT_ACTIVE   0x0400  /* Bit 2 - Session not active     */
#define LAT_UNABLE_TO_TRANSMIT   0x0200  /* Bit 1 - Unable to transmit data*/
#define LAT_RECEIVE_AVAILABLE    0x0100  /* Bit 0 - Receive data available */

/* CTERM Status Bit Flags from GetStatus */
#define CTERM_SESSION_ABORTED    0x8000  /* Bit 7 - Session has been aborted*/
#define CTERM_DECNET_ERROR       0x4000  /* Bit 6 - DECnet error          */
#define CTERM_RECEIVE_BUFF_FULL  0x0400  /* Bit 2 - Receive Buffer Full   */
#define CTERM_TRACE_AVAILABLE    0x0200  /* Bit 1 - Write is pending      */
#define CTERM_RECEIVE_AVAILABLE  0x0100  /* Bit 0 - Receive data available*/

/* CTERM Return Codes in AL */
#define CTERM_NORMAL_DISCONNECT      0x00  /* Normal Disconnect              */
#define CTERM_UNKNOWN_HOST_MESSAGE   0x01  /* Unknown protocol message from host    */
#define CTERM_PROTOCOL_VIOLATION     0x02  /* Protocol violation by host    */
#define CTERM_NO_PROCESS_MESSAGE     0x03  /* Could not process the initial message */
#define CTERM_ERROR_RECEIVING        0x04  /* Error receiving message from host     */
#define CTERM_ERROR_SENDING          0x05  /* Error sending message to host */
#define CTERM_ERROR_CHECKING         0x06  /* Error checking for message from host  */
#define CTERM_PROTOCOL_NOT_SUPPORTED 0x07  /* Remote system does not support CTERM protocol */
#define CTERM_VERSION_NOT_SUPPORTED  0x08  /* Remote system does not support correct protocol version */
#define CTERM_BIND_NOT_RECEIVED      0x09  /* Did not receive BIND request message from host */
#define CTERM_BIND_NOT_SENT          0x0A  /* Could not send BIND request message to host */
#define CTERM_NO_SESSIONS            0x0B  /* No more sessions available   */
#define CTERM_SESSION_NOT_EXIST      0x0C  /* Session does not exist       */
#define CTERM_NO_MEMORY              0x0D  /* Not enough memory to complete operation */
#define CTERM_CONNECTION_BROKEN      0x0E  /* Connection has broken        */

/***************************************************************************/

/* Error Return Codes */

#define CE_SESSIONOK          0  /* Generic success return value        */
#define CE_NOSESSION         -1  /* Invalid session id                  */
#define CE_SESSIONTXQUE      -2  /* Unable to queue a character for transmission */
#define CE_NOCHAR            -3  /* No characters available on a read request */
#define CE_LATSTOP           -4  /* LAT circuit failure or stop error code */
#define CE_LATBRK            -5  /* Unable to send break to host via LAT */

/* Initialization Error Codes */

#define IE_NOTINSTALL        -6  /* LAT driver not installed            */
#define IE_NOSERVICE         -7  /* Service not in table or name error  */
#define IE_LATVIRTCIRC       -8  /* No more virtual circuit blocks available */
#define IE_NOSESSIONS        -9  /* No more sessions available          */
#define IE_NOMEMORY         -10  /* All SCBs allocated, no memory available */
#define IE_NOBUFFER         -11  /* Data buffer specification error     */
#define IE_LATCIRCSESS      -12  /* No more sessions available on this circuit*/
#define IE_LATNOSERVNAME    -13  /* No service name returned, have not called */
                        /*   the LAT service table reset function or have */
                        /*   reached the end of the table                 */
#define IE_LATOVERFLOW      -14  /* LAT service table overflow       */
#define IE_INVPASSWORD      -15  /* Invalid password for LAT session */

#define IE_NOSERVNAME  IE_LATNOSERVNAME  
    /* indicates reached end of LAT, CTERM, or TELNET service table */
    /*   or have not called InquireService to reset the table to    */
    /*   the top.                                                   */
    
/* Additional error codes for GetInfo */

#define CE_NOTIMPLEMENTED   -16  /* requested function is not implemented */
#define CE_INVALIDPARAMETER -17  /* bad argument was passed in */
