.so ../ADM/mac
.XX lex 375 "Lex \(em A Lexical Analyzer Generator"
.hc ~
...ND July 21, 1975
...TR 39
...RP
...TM 75-1274-15 39199 39199-11
.ds L \f2Lex\fP
.ds l \f2lex\fP
.nr dP 2
.nr dV 3p
.TL
Lex \(em A Lexical Analyzer Generator
.AU ``MH 2C-569'' 6377
M. E. Lesk
E. Schmidt
.AI
.MH
.AB
.PP
\*L helps write programs whose control flow
is directed by instances of regular
expressions in the input stream.
It is well suited for editor-script type transformations and
for segmenting input in preparation for
a parsing routine.
.PP
\*L source is a table of regular expressions and corresponding program fragments.
The table is translated to a program
which reads an input stream, copying it to an output stream
and partitioning the input
into strings which match the given expressions.
As each such string is recognized the corresponding
program fragment is executed.
The recognition of the expressions
is performed by a deterministic finite automaton
generated by \*l.
The program fragments written by the user are executed in the order in which the
corresponding regular expressions occur in the input stream.
.PP
The lexical analysis
programs written with \*l accept ambiguous specifications
and choose the longest
match possible at each input point.
If necessary, substantial look~ahead
is performed on the input, but the
input stream will be backed up to the
end of the current partition, so that the user
has general freedom to manipulate it.
.PP
\*L can generate analyzers in either C or Ratfor, a language
which can be translated automatically to portable Fortran.
This manual, however, will only discuss generating analyzers
in C.
\*L is designed to simplify
interfacing with \fIyacc\fP, for those
with access to this compiler-compiler system.
.AE
.2C
.NH
Introduction.
.PP
\*L is a program generator designed for
lexical processing of character input streams.
It accepts a high-level, problem oriented specification
for character string matching,
and
produces a program in a general purpose language which recognizes
regular expressions.
The regular expressions are specified by the user in the
source specifications given to \*l.
The \*l written code recognizes these expressions
in an input stream and partitions the input stream into
strings matching the expressions.  At the bound~aries
between strings
program sections
provided by the user are executed.
The \*l source file associates the regular expressions and the
program fragments.
As each expression appears in the input to the program written by \*l,
the corresponding fragment is executed.
.PP
The user supplies the additional code
beyond expression matching
needed to complete his tasks, possibly
including code written by other generators.
The program that recognizes the expressions is generated in the
general purpose programming language employed for the
user's program fragments.
Thus, a high level expression
language is provided to write the string expressions to be
matched while the user's freedom to write actions
is unimpaired.
This avoids forcing the user who wishes to use a string manipulation
language for input analysis to write processing programs in the same
and often inappropriate string handling language.
.PP
\*L is not a complete language, but rather a generator representing
a new language feature which can be added to
different programming languages, called ``host languages.'' 
Just as general purpose languages
can produce code to run on different computer hardware,
\*l can write code in different host languages.
The host language is used for the output code generated by \*l
and also for the program fragments added by the user.
Compatible run-time libraries for the different host languages
are also provided.
This makes \*l adaptable to different environments and
different users.
Each application
may be directed to the combination of hardware and host language appropriate
to the task, the user's background, and the properties of local
implementations.
At present, the only supported host language is C|reference(cbook),
although Fortran (in the form of Ratfor|reference(ratfor spe) has been available
in the past.
.PP
\*L turns the user's expressions and actions
(called
.I source
in this memo) into the host general-purpose language;
the generated program is named
.I yylex .
The
.I yylex
program
will recognize expressions
in a stream
(called
.I input
in this memo)
and perform the specified actions for each expression as it is detected.
See Figure 1.
.KF
.TS
center;
l _ r
l|c|r
l _ r
l _ r
l|c|r
l _ r
c s s
c s s.

Source \(->	\*l	\(-> yylex

.sp

Input \(->	yylex	\(-> Output

.sp
\fBFigure 1.\fP  An overview of \*l
.TE
.KE
.PP
For a trivial example, consider a program to delete
from the input
all blanks or tabs at the ends of lines.
.P1 0
%%
[ \et]+$	;
.P2
is all that is required.
The program
contains a
.CW %%
delimiter to mark the beginning of the rules, and
one rule.
This rule contains a regular expression
which matches one or more
instances of the characters blank or tab
(written
.CW \et
for visibility, in accordance with the C language convention)
just prior to the end of a line.
The brackets indicate the character
class made of blank and tab; the
.CW +
indicates ``one or more ...'';
and the
.CW $
indicates ``end of line,'' as in QED.
No action is specified,
so the program generated by \*l (yylex) will ignore these characters.
Everything else will be copied.
To change any remaining
string of blanks or tabs to a single blank,
add another rule:
.P1 0
%%
[ \et]+$	;
[ \et]+	printf(" ");
.P2
The finite automaton generated for this
source will scan for both rules at once,
observing at
the termination of the string of blanks or tabs
whether or not there is a newline character, and executing
the desired rule action.
The first rule matches all strings of blanks or tabs
at the end of lines, and the second
rule all remaining strings of blanks or tabs.
.PP
\*L can be used alone for simple transformations, or
for analysis and statistics gathering on a lexical level.
\*L can also be used with a parser generator
to perform the lexical analysis phase; it is particularly
easy to interface \*l and \fIyacc\fP|reference(latest yacc).
\*L programs recognize only regular expressions;
\fIyacc\fP writes parsers that accept a large class of context free grammars,
but require a lower level analyzer to recognize input tokens.
Thus, a combination of \*l and \fIyacc\fP is often appropriate.
When used as a preprocessor for a later parser generator,
\*l is used to partition the input stream,
and the parser generator assigns structure to
the resulting pieces.
The flow of control
in such a case (which might be the first half of a compiler,
for example) is shown in Figure 2.
Additional programs,
written by other generators
or by hand, can
be added easily to programs written by \*l.
.KF
.TS
center;
l c c c l
l c c c l
l c c c l
l _ c _ l
l|c|c|c|l
l _ c _ l
l c c c l
l _ c _ l
l|c|c|c|l
l _ c _ l
l c s s l.
	lexical		grammar
	rules		rules
	\(da		\(da

	\*l		\fIyacc\fP

	\(da		\(da

Input \(->	yylex	\(->	yyparse	\(-> Parsed input

.sp
	\fBFigure 2.\fP \*L with \fIyacc\fP
.TE
.KE
\fIYacc\fP users
will realize that the name
.I yylex
is what \fIyacc\fP expects its lexical analyzer to be named,
so that the use of this name by \*l simplifies
interfacing.
.PP
\*L generates a deterministic finite automaton from the regular expressions
in the source|reference(aho corasick).
The automaton is interpreted, rather than compiled, in order
to save space.
The result is still a fast analyzer.
In particular, the time taken by a \*l program
to recognize and partition an input stream is
proportional to the length of the input.
The number of \*l rules or
the complexity of the rules is
not important in determining speed,
unless rules which include
forward context require a significant amount of re~scanning.
What does increase with the number and complexity of rules
is the size of the finite
automaton, and therefore the size of the program
generated by \*l.
.PP
In the program written by \*l, the user's fragments
(representing the
.I actions
to be performed as each regular expression
is found)
are gathered
as cases of a switch.
The automaton interpreter directs the control flow.
Opportunity is provided for the user to insert either
declarations or additional statements in the routine containing
the actions, or to
add subroutines outside this action routine.
.PP
\*L is not limited to source which can
be interpreted on the basis of one character
look~ahead.
For example,
if there are two rules, one looking for
.CW ab
and another for
.CW abcdefg ,
and the input stream is
.CW abcdefh ,
\*L will recognize
.CW ab
and leave
the input pointer just before
.CW cdefh .
Such backup is more costly
than the processing of simpler languages.
.NH
\*L Source.
.PP
The general format of \*l source is:
.P1 0
{definitions}
%%
{rules}
%%
{user subroutines}
.P2
where the definitions and the user subroutines
are often omitted.
The second
.CW %%
is optional, but the first is required
to mark the beginning of the rules.
The absolute minimum \*l program is thus
.P1 0
%%
.P2
(no definitions, no rules) which translates into a program
which copies the input to the output unchanged.
.PP
In the outline of \*l programs shown above, the
.I rules
represent the user's control
decisions; they are a table, in which the left column
contains
.I
regular expressions
.R
(see section 3)
and the right column contains
.I actions ,
program fragments to be executed when the expressions
are recognized.
Thus an individual rule might appear
.P1 0
integer	printf("found keyword INT");
.P2
to look for the string
.CW integer
in the input stream and
print the message ``found keyword INT'' whenever it appears.
In this example the host procedural language is C and
the C library function
.I printf
is used to print the string.
The end
of the expression is indicated by the first blank or tab character.
If the action is merely a single C expression,
it can just be given on the right side of the line; if it is
compound, or takes more than a line, it should be enclosed in
braces.
As a slightly more useful example, suppose it is desired to
change a number of words from British to American spelling.
\*L rules such as
.P1 0
colour		printf("color");
mechanise	printf("mechanize");
petrol		printf("gas");
.P2
would be a start.  These rules are not quite enough,
since
the word
.CW petroleum
would become
.CW gaseum ;
a way of dealing
with this will be described later.
.NH
\*L Regular Expressions.
.PP
The definitions of regular expressions are very similar to those
in QED|reference(qed cstr).
A regular
expression specifies a set of strings to be matched.
It contains text characters (which match the corresponding
characters in the strings being compared)
and operator characters (which specify
repetitions, choices, and other features).
The letters of the alphabet and the digits are
always text characters; thus the regular expression
.P1 0
integer
.P2
matches the string
.CW integer
wherever it appears
and the expression
.P1 0
a57D
.P2
looks for the string
.CW a57D .
.PP
.I Operators .
The operator characters are
.P1 0
" \e [ ] ^ - ? . \(** + | ( ) $ / { } % < >
.P2
and if they are to be used as text characters, an escape
should be used.
The quotation mark operator (")
indicates that whatever is contained between a pair of quotes
is to be taken as text characters.
Thus
.P1 0
xyz"++"
.P2
matches the string
.CW xyz++
when it appears.  Note that a part of a string may be quoted.
It is harmless but unnecessary to quote an ordinary
text character; the expression
.P1 0
"xyz++"
.P2
is the same as the one above.
Thus by quoting every non-alphanumeric character
being used as a text character, the user can avoid remembering
the list above of current
operator characters, and is safe should further extensions to \*l
lengthen the list.
.PP
An operator character may also be turned into a text character
by preceding it with \e as in
.P1 0
xyz\e+\e+
.P2
which
is another, less readable, equivalent of the above expressions.
Another use of the quoting mechanism is to get a blank into
an expression; normally, as explained above, blanks or tabs end
a rule.
Any blank character not contained within
.CW []
(see below) must
be quoted.
Several normal C escapes with
.CW \e
are recognized:
.CW \en
is newline,
.CW \et
is tab, and
.CW \eb
is backspace.
To enter
.CW \e
itself, use
.CW \e\e .
Since newline is illegal in an expression,
.CW \en
must be used;
it is not
required to escape tab and backspace.
Every character but blank, tab, newline and the list above is always
a text character.
.PP
.I "Character classes" .
Classes of characters can be specified using the operator pair
.CW [] .
The construction
.CW [abc]
matches a
single character, which may be
.CW a ,
.CW b ,
or
.CW c .
Within square brackets,
most operator meanings are ignored.
Only three characters are special:
these are
.CW \e ,
.CW -
and
.CW  ^ .
The
.CW -
character
indicates ranges.  For example,
.P1 0
[a-z0-9<>_]
.P2
indicates the character class containing all the lower case letters,
the digits,
the angle brackets, and underline.
Ranges may be given in either order.
Using
.CW -
between any pair of characters which are
not both upper case letters, both lower case letters, or both digits
is implementation dependent and will get a warning message.
(E.g.,
.CW [0\e-z]
in ASCII is many more characters
than it is in EBCDIC).
If it is desired to include the
character - in a character class, it should be first or
last; thus
.P1 0
[-+0-9]
.P2
matches all the digits and the two signs.
.PP
In character classes,
the
.CW ^
operator must appear as the first character
after the left bracket; it indicates that the resulting string
is to be complemented with respect to the computer character set.
Thus
.P1 0
[^abc]
.P2
matches all characters except
.CW a ,
.CW b , or
.CW c ,
including
all special or control characters; or
.P1 0
[^a-zA-Z]
.P2
is any character which is not a letter.
The
.CW \e
character provides the usual escapes within
character class brackets.
.PP
.I "Arbitrary character" .
To match almost any character, the operator character
.CW .
is the class of all characters except newline.
Escaping into octal is possible although non-portable:
.P1 0
[\e40-\e176]
.P2
matches all printable characters in the ASCII character set, from octal
40 (blank) to octal 176 (tilde).
.PP
.I "Optional expressions" .
The operator
.CW ?
indicates
an optional element of an expression.
Thus
.P1 0
ab?c
.P2
matches either
.CW ac
or
.CW abc .
.PP
.I "Repeated expressions" .
Repetitions of classes are indicated by the operators
.CW *
and
.CW + .
.P1 0
a*
.P2
is any number of consecutive
.CW a
characters, including zero; while
.P1 0
a+
.P2
is one or more instances of
.CW a .
For example,
.P1 0
[a-z]+
.P2
is all strings of lower case letters.
And
.P1 0
[A-Za-z][A-Za-z0-9]*
.P2
indicates all alphanumeric strings with a leading
alphabetic character.
This is a typical expression for recognizing identifiers in
computer languages.
.PP
.I "Alternation and Grouping" .
The operator
.CW |
indicates alternation:
.P1 0
(ab|cd)
.P2
matches either
.CW ab
or
.CW cd .
Note that parentheses are used for grouping, although
they are
not necessary on the outside level;
.P1 0
ab|cd
.P2
would have sufficed.
Parentheses
can be used for more complex expressions:
.P1 0
(ab|cd+)?(ef)*
.P2
matches such strings as
.CW abefef ,
.CW efefef ,
.CW cdef ,
or
.CW cddd ;
but not
.CW abc ,
.CW abcd ,
or
.CW abcdef .
.PP
.I "Context sensitivity" .
\*L will recognize a small amount of surrounding
context.  The two simplest operators for this are
.CW ^
and
.CW $ .
If the first character of an expression is
.CW ^ ,
the expression will only be matched at the beginning
of a line (after a newline character, or at the beginning of
the input stream).
This can never conflict with the other meaning of
.CW ^ ,
complementation
of character classes, since that only applies within
the
.CW []
operators.
If the very last character is
.CW $ ,
the expression will only be matched at the end of a line (when
immediately followed by newline).
The latter operator is a special case of the
.CW /
operator character,
which indicates trailing context.
The expression
.P1 0
ab/cd
.P2
matches the string
.CW ab ,
but only if followed by
.CW cd .
Thus
.P1 0
ab$
.P2
is the same as
.P1 0
ab/\en
.P2
Left context is handled in \*l by
.I "start conditions"
as explained in section 10.  If a rule is only to be executed
when the \*l automaton interpreter is in start condition
.I x ,
the rule should be prefixed by
.P1 0
<x>
.P2
using the angle bracket operator characters.
If we considered ``being at the beginning of a line'' to be
start condition
.I ONE ,
then the
.CW ^
operator
would be equivalent to
.P1 0
<ONE>
.P2
Start conditions are explained more fully later.
.PP
.I "Repetitions and Definitions" .
The operators
.CW {}
specify
either repetitions (if they enclose numbers)
or
definition expansion (if they enclose a name).  For example
.P1 0
{digit}
.P2
looks for a predefined string named
.I digit
and inserts it
at that point in the expression.
The definitions are given in the first part of the \*l
input, before the rules.
In contrast,
.P1 0
a{1,5}
.P2
looks for 1 to 5 occurrences of
.CW a .
.PP
Finally, initial
.CW %
is special, being the separator
for \*l source segments.
.NH
\*L Actions.
.PP
When an expression written as above is matched, \*l
executes the corresponding action.  This section describes
some features of \*l which aid in writing actions.  Note
that there is a default action, which
consists of copying the input to the output.  This
is performed on all strings not otherwise matched.  Thus
the \*l user who wishes to absorb the entire input, without
producing any output, must provide rules to match everything.
When \*l is being used with \fIyacc\fP, this is the normal
situation.
One may consider that actions are what is done instead of
copying the input to the output; thus, in general,
a rule which merely copies can be omitted.
Also, a character combination
which is omitted from the rules
and which appears as input
is likely to be printed on the output, thus calling
attention to the gap in the rules.
.PP
One of the simplest things that can be done is to ignore
the input.   Specifying a C null statement,
.CW ;
as an action
causes this result.  A frequent rule is
.P1 0
[ \et\en]	;
.P2
which causes the three spacing characters (blank, tab, and newline)
to be ignored.
.PP
Another easy way to avoid writing actions is the action character
.CW | ,
which indicates that the action for this rule is the action
for the next rule.
The previous example could also have been written
.P1 0
" "		|
"\et"		|
"\en"		;
.P2
with the same result, although in different style.
The quotes around
.CW \en
and
.CW \et
are not required.
.PP
In more complex actions, the user
will
often want to know the actual text that matched some expression
like
.CW [a-z]+ .
\*L leaves this text in an external character
array named
.I yytext .
Thus, to print the name found,
a rule like
.P1 0
[a-z]+	printf("%s", yytext);
.P2
will print
the string in
.I yytext .
The C function
.I printf
accepts a format argument and data to be printed;
in this case, the format is ``print string'' (\f(CW%\fP indicating
data conversion, and
.CW s
indicating string type),
and the data are the characters
in
.I yytext .
So this just places
the matched string
on the output.
This action
is so common that
it may be written as
.CW ECHO :
.P1 0
[a-z]+	ECHO;
.P2
is the same as the above.
Since the default action is just to
print the characters found, one might ask why
give a rule, like this one, which merely specifies
the default action?
Such rules are often required
to avoid matching some other rule
which is not desired.  For example, if there is a rule
which matches
.I read
it will normally match the instances of
.I read
contained in
.I bread
or
.I readjust ;
to avoid
this,
a rule
of the form
.CW [a-z]+
is needed.
This is explained further below.
.PP
Sometimes it is more convenient to know the end of what
has been found; hence \*l also provides a count
.I yyleng
of the number of characters matched.
To count both the number
of words and the number of characters in words in the input, the user might write
.P1 0
[a-zA-Z]+	{words++; chars += yyleng;}
.P2
which accumulates in
.I chars
the number
of characters in the words recognized.
The last character in the string matched can
be accessed by
.P1 0
yytext[yyleng-1]
.P2
.PP
Occasionally, a \*l
action may decide that a rule has not recognized the correct
span of characters.
Two routines are provided to aid with this situation.
First,
.I yymore()
can be called to indicate that the next input expression recognized is to be
tacked on to the end of this input.  Normally,
the next input string would overwrite the current
entry in
.I yytext .
Second,
.I yyless(n)
may be called to indicate that not all the characters matched
by the currently successful expression are wanted right now.
The argument
.I n
indicates the number of characters in
.I yytext
to be retained.
Further characters previously matched
are
returned to the input.  This provides the same sort of
look~ahead offered by the
.CW /
operator,
but in a different form.
.PP
.I "Example" :
Consider a language which defines
a string as a set of characters between quotation
.CW \"
marks, and provides that
to include a
.CW \"
in a string it must be preceded by a
.CW  \e .
The regular expression which matches that is somewhat confusing,
so that it might be preferable to write
.P1 0
\e"[^"]*	{
	if (yytext[yyleng-1] == '\e\e'
	     yymore();
	else
	     ... normal user processing
	}
.P2
which will, when faced with a string such as
.CW \"abc\e"def" ,
first match
the five characters
.CW \"abc\e ;
then
the call to
.I yymore()
will
cause the next part of the string,
.CW \"def ,
to be tacked on the end.
Note that the final quote terminating the string should be picked
up in the code labeled ``normal processing''.
.PP
The function
.I yyless
might be used to reprocess
text in various circumstances.  Consider the C problem of distinguishing
the ambiguity of
.CW =-a .
Suppose it is desired to treat this as
.CW "=- a"
but print a message.  A rule might be
.P1 0
=-[a-zA-Z]	{
	printf("Operator (=-) ambiguous\en");
	yyless(yyleng-1);
	... action for =- ...
	}
.P2
which prints a message, returns the letter after the
operator to the input stream, and treats the operator as
.CW =- .
Alternatively it might be desired to treat this as
.CW "=  -a" .
To do this, just return the minus
sign as well as the letter to the input:
.P1 0
=-[a-zA-Z]	{
	printf("Operator (=-) ambiguous\en");
	yyless(yyleng-2);
	... action for = ...
	}
.P2
will perform the other interpretation.
Note that the expressions for the two cases might more easily
be written
.P1 0
=-/[A-Za-z]
.P2
in the first case and
.P1 0
=/-[A-Za-z]
.P2
in the second;
no backup would be required in the rule action.
It is not necessary to recognize the whole identifier
to observe the ambiguity.
The
possibility of
.CW =-3 ,
however, makes
.P1 0
=-/[^ \et\en]
.P2
a still better rule.
.PP
In addition to these routines, \*l also permits
access to the I/O routines
it uses.
They are:
.IP 1)
.I
input()
.R
which returns the next input character;
.IP 2)
.I
output(c)
.R
which writes the character
.I c
on the output; and
.IP 3)
.I
unput(c)
.R
pushes the character
.I c
back onto the input stream to be read later by
.I input() .
.LP
By default these routines are provided as macro definitions,
but the user can override them and supply private versions.
These routines
define the relationship between external files and
internal characters, and must all be retained
or modified consistently.
They may be redefined, to
cause input or output to be transmitted to or from strange
places, including other programs or internal memory;
but the character set used must be consistent in all routines;
a value of zero returned by
.I input
must mean end of file; and
the relationship between
.I unput
and
.I input
must be retained
or the \*l look~ahead will not work.
\*L does not look ahead at all if it does not have to,
but every rule ending in
.CW +
.CW *
.CW ?
.CW $
or containing
.CW /
implies look~ahead.
Look~ahead is also necessary to match an expression that is a prefix
of another expression.
See below for a discussion of the character set used by \*l.
The standard \*l library imposes
a 100 character limit on backup.
.PP
Another \*l library routine that the user will sometimes want
to redefine is
.I yywrap()
which is called whenever \*l reaches an end-of-file.
If
.I yywrap
returns a 1, \*l continues with the normal wrapup on end of input.
Sometimes, however, it is convenient to arrange for more
input to arrive
from a new source.
In this case, the user should provide
a
.I yywrap
which
arranges for new input and
returns 0.  This instructs \*l to continue processing.
The default
.I yywrap
always returns 1.
.PP
This routine is also a convenient place
to print tables, summaries, etc. at the end
of a program.  Note that it is not
possible to write a normal rule which recognizes
end-of-file; the only access to this condition is
through
.I yywrap .
In fact, unless a private version of
.I input()
is supplied
a file containing nulls
cannot be handled,
since a value of 0 returned by
.I input
is taken to be end-of-file.
........
.NH
Ambiguous Source Rules.
.PP
\*L can handle ambiguous specifications.
When more than one expression can match the
current input, \*l chooses as follows:
.IP 1)
The longest match is preferred.
.IP 2)
Among rules which matched the same number of characters,
the rule given first is preferred.
.LP
Thus, suppose the rules
.P1 0
integer	keyword action ...;
[a-z]+	identifier action ...;
.P2
to be given in that order.  If the input is
.I integers ,
it is taken as an identifier, because
.CW [a-z]+
matches 8 characters while
.CW integer
matches only 7.
If the input is
.I integer ,
both rules match 7 characters, and
the keyword rule is selected because it was given first.
Anything shorter (e.g. \fIint\fR\|) will
not match the expression
.I integer
and so the identifier interpretation is used.
.PP
The principle of preferring the longest
match makes rules containing
expressions like
.CW .*
dangerous.
For example,
.P1 0
\&'.*'
.P2
might seem a good way of recognizing
a string in single quotes.
But it is an invitation for the program to read far
ahead, looking for a distant
single quote.
Presented with the input
.P1 0
\&'first' quoted string here, 'second' here
.P2
the above expression will match
.P1 0
\&'first' quoted string here, 'second'
.P2
which is probably not what was wanted.
A better rule is of the form
.P1 0
\&'[^'\en]*'
.P2
which, on the above input, will stop
after
.I 'first' .
The consequences
of errors like this are mitigated by the fact
that the
.CW .
operator will not match newline.
Thus expressions like
.CW .*
stop on the
current line.
Don't try to defeat this with expressions like
.CW [.\en]+
or
equivalents;
the \*l generated program will try to read
the entire input file, causing
internal buffer overflows.
.PP
Note that \*l is normally partitioning
the input stream, not searching for all possible matches
of each expression.
This means that each character is accounted for
once and only once.
For example, suppose it is desired to
count occurrences of both
.CW she
and
.CW he
in an input text.
Some \*l rules to do this might be
.P1 0
she	s++;
he	h++;
\en	|
\&.	;
.P2
where the last two rules ignore everything besides
.CW he
and
.CW she .
Remember that
.CW .
does not include newline.
Since
.CW she
includes
.CW he ,
\*l will normally
.I not
recognize
the instances of
.CW he
included in
.CW she ,
since once it has passed a
.CW she
those characters are gone.
.PP
Sometimes the user would like to override this choice.  The action
.I REJECT
means ``go do the next alternative.''
It causes whatever rule was second choice after the current
rule to be executed.
The position of the input pointer is adjusted accordingly.
Suppose the user really wants to count the included instances of
.CW he :
.P1 0
she	{s++; REJECT;}
he	{h++; REJECT;}
\en	|
\&.	;
.P2
these rules are one way of changing the previous example
to do just that.
After counting each expression, it is rejected; whenever appropriate,
the other expression will then be counted.  In this example, of course,
the user could note that
.CW she
includes
.CW he
but not
vice versa, and omit the
.I REJECT
action on
.CW he ;
in other cases, however, it
would not be possible a priori to tell
which input characters
were in both classes.
.PP
Consider the two rules
.P1 0
a[bc]+	{ ... ; REJECT;}
a[cd]+	{ ... ; REJECT;}
.P2
If the input is
.CW ab ,
only the first rule matches,
and on
.CW ad
only the second matches.
The input string
.CW accb
matches the first rule for four characters
and then the second rule for three characters.
In contrast, the input
.CW accd
agrees with
the second rule for four characters and then the first
rule for three.
.PP
In general, REJECT is useful whenever
the purpose of \*l is not to partition the input
stream but to detect all examples of some items
in the input, and the instances of these items
may overlap or include each other.
Suppose a digram table of the input is desired;
normally the digrams overlap, that is the word
.CW the
is considered to contain
both
.CW th
and
.CW he .
Assuming a two-dimensional array named
.I digram
to be incremented, the appropriate
source is
.P1 0
%%
[a-z][a-z]	{digram[yytext[0]][yytext[1]]++;
		REJECT;};
\en	;
.P2
where the REJECT is necessary to pick up
a letter pair beginning at every character, rather than at every
other character.
.NH
\*L Source Definitions.
.PP
Remember the format of the \*l
source:
.P1 0
{definitions}
%%
{rules}
%%
{user routines}
.P2
So far only the rules have been described.  The user needs
additional options,
though, to define variables for use in his program and for use
by \*l.
These can go either in the definitions section
or in the rules section.
.PP
Remember that \*l is turning the rules into a program.
Any source not intercepted by \*l is copied
into the generated program.  There are three classes
of such things.
.IP 1)
Any line which is not part of a \*l rule or action
which begins with a blank or tab is copied into
the \*l generated program.
Such source input prior to the first
.CW %%
delimiter will be external
to any function in the code; if it appears immediately after the first
.CW %% ,
it appears in an appropriate place for declarations
in the function written by \*l which contains the actions.
This material must look like program fragments,
and should precede the first \*l rule.
.IP
As a side effect of the above, lines which begin with a blank
or tab, and which contain a comment,
are passed through to the generated program.
This can be used to include comments in either the \*l source or
the generated code.  The comments should follow the host
language convention.
.IP 2)
Anything included between lines containing
only
.CW %{
and
.CW %}
is
copied out as above.  The delimiters are discarded.
This format permits entering text like preprocessor statements that
must begin in column 1,
or copying lines that do not look like programs.
.IP 3)
Anything after the third
.CW %%
delimiter, regardless of formats, etc.,
is copied out after the \*l output.
.PP
Definitions intended for \*l are given
before the first
.CW %%
delimiter.  Any line in this section
not contained between
.CW %{
and
.CW %} ,
and beginning
in column 1, is assumed to define \*l substitution strings.
The format of such lines is
.P1 0
name translation
.P2
and it
causes the string given as a translation to
be associated with the name.
The name and translation
must be separated by at least one blank or tab, and the name must begin with a letter.
The translation can then be called out
by the {name} syntax in a rule.
Using {D} for the digits and {E} for an exponent field,
for example, might abbreviate rules to recognize numbers:
.P1 0
D	[0-9]
E	[DEde][-+]?{D}+
%%
{D}+	printf("integer");
{D}+"."{D}\(**({E})?	|
{D}\(**"."{D}+({E})?	|
{D}+{E}		printf("real");
.P2
Note the first two rules for real numbers;
both require a decimal point and contain
an optional exponent field,
but the first requires at least one digit before the
decimal point and the second requires at least one
digit after the decimal point.
To correctly handle the problem
posed by a Fortran expression such as
.CW 35.EQ.I ,
which does not contain a real number, a context-sensitive
rule such as
.P1 0
[0-9]+/"."EQ	printf("integer");
.P2
could be used in addition to the normal rule for integers.
.PP
The definitions
section may also contain other commands, including the
selection of a host language, a character set table,
a list of start conditions, or adjustments to the default
size of arrays within \*l itself for larger source programs.
These possibilities
are discussed below under ``Summary of Source Format,''
section 12.
.NH
Usage.
.PP
There are two steps in
compiling a \*l source program.
First, the \*l source must be turned into a generated program
in the host general purpose language.
Then this program must be compiled and loaded, usually with
a library of \*l subroutines.
The generated program
is on a file named
.CW lex.yy.c .
The I/O library is defined in terms of the C standard
library|reference(stdio).
.PP
The library is accessed by the loader flag
.CW -ll .
So an appropriate
set of commands is
.P1 0
lex source
cc lex.yy.c -ll
.P2
The resulting program is placed on the usual file
.CW a.out
for later execution.
To use \*l with \fIyacc\fP see below.
Although the default \*l I/O routines use the C standard library,
the \*l automata themselves do not do so;
if private versions of
.I input ,
.I output
and
.I unput
are given, the library can be avoided.
.NH
\*L and \fIyacc\fP.
.PP
If you want to use \*l with \fIyacc\fP, note that what \*l writes is a function
named
.I yylex ,
the name required by \fIyacc\fP for its analyzer.
Normally, the default main program on the \*l library
calls this routine, but if \fIyacc\fP is loaded, and its main
program is used, \fIyacc\fP will call
.I yylex .
In this case each \*l rule should end with
.P1 0
return(token);
.P2
where the appropriate token value is returned.
An easy way to get access
to \fIyacc\fP's names for tokens is to
compile the \*l output file as part of
the \fIyacc\fP output file by placing the line
.P1 0
#include "lex.yy.c"
.P2
in the last section of \fIyacc\fP input.
Supposing the grammar to be
named ``good'' and the lexical rules to be named ``better''
the
.UX
command sequence can just be:
.P1 0
yacc good
lex better
cc y.tab.c -ly -ll
.P2
The \fIyacc\fP library
.CW -ly ) (
should be loaded before the \*l library,
to obtain a main program which invokes the \fIyacc\fP parser.
The generations of \*l and \fIyacc\fP programs can be done in
either order.
.NH
Examples.
.PP
As a trivial problem, consider copying an input file while
adding 3 to every positive number divisible by 7.
Here is a suitable \*l source program
.P1 0
%%
	int k;
[0-9]+	{
	k = atoi(yytext);
	if (k%7 == 0)
	     printf("%d", k+3);
	else
	     printf("%d",k);
	}
.P2
to do just that.
The rule
.CW [0-9]+
recognizes strings of digits;
.I atoi
converts the digits to binary
and stores the result in
.I k .
The operator
.CW %
(remainder) is used to check whether
.I k
is divisible by 7; if it is,
it is incremented by 3 as it is written out.
It may be objected that this program will alter such
input items as
.I 49.63
or
.I X7 .
Furthermore, it increments the absolute value
of all negative numbers divisible by 7.
To avoid this, just add a few more rules after the active one,
as here:
.P1 0
%%
	int k;
-?[0-9]+	{
	k = atoi(yytext);
	printf("%d", k%7 == 0 ? k+3 : k);
	}
-?[0-9.]+	ECHO;
[A-Za-z][A-Za-z0-9]+	ECHO;
.P2
Numerical strings containing a
.CW .
or preceded by a letter will be picked up by
one of the last two rules, and not changed.
The
.I if-else
has been replaced by
a C conditional expression to save space;
the form
.CW a?b:c
means ``if
.CW a
then
.CW b
else
.CW c .
.PP
For an example of statistics gathering, here
is a program which histograms the lengths
of words, where a word is defined as a string of letters.
.P1 0
	int lengs[100];
%%
[a-z]+	lengs[yyleng]++;
\&.	|
\en	;
%%
.P3
yywrap()
{
int i;
printf("Length  No. words\en");
for(i=0; i<100; i++)
     if (lengs[i] > 0)
          printf("%5d%10d\en",i,lengs[i]);
return(1);
}
.P2
This program
accumulates the histogram, while producing no output.  At the end
of the input it prints the table.
The final statement
.CW return(1)
indicates that \*l is to perform wrapup.  If
.I yywrap
returns zero (false)
it implies that further input is available
and the program is
to continue reading and processing.
To provide a
.I yywrap
that never
returns true causes an infinite loop.
.PP
As a larger example,
here are some parts of a program written by N. L. Schryer
to convert double precision Fortran to single precision Fortran.
Because Fortran does not distinguish upper and lower case letters,
this routine begins by defining a set of classes including
both cases of each letter:
.P1 0
a	[aA]
b	[bB]
c	[cC]
\&...
z	[zZ]
.P2
An additional class recognizes white space:
.P1 0
W	[ \et]*
.P2
The first rule changes
``double precision'' to ``real'', or ``DOUBLE PRECISION'' to ``REAL''.
.P1 0
{d}{o}{u}{b}{l}{e}{W}\e
{p}{r}{e}{c}{i}{s}{i}{o}{n} {
     printf(yytext[0]=='d'? "real" : "REAL");
     }
.P2
Care is taken throughout this program to preserve the case
(upper or lower)
of the original program.
The conditional operator is used to
select the proper form of the keyword.
The next rule copies continuation card indications to
avoid confusing them with constants:
.P1 0
^"     "[^ 0]	ECHO;
.P2
In the regular expression, the quotes surround the
blanks.
It is interpreted as
``beginning of line, then five blanks, then
anything but blank or zero.'' 
Note the two different meanings of
.CW ^ .
There follow some rules to change double precision
constants to ordinary floating constants.
.P1 0
[0-9]+{W}{d}{W}[+-]?{W}[0-9]+     |
[0-9]+{W}"."{W}{d}{W}[+-]?{W}[0-9]+     |
"."{W}[0-9]+{W}{d}{W}[+-]?{W}[0-9]+     {
     /* convert constants */
     for(p=yytext; *p != 0; p++)
          {
          if (*p == 'd' || *p == 'D')
               *p =+ 'e'- 'd';
          ECHO;
          }
.P2
After the floating point constant is recognized, it is
scanned by the
.I for
loop
to find the letter
.CW d
or
.CW D .
The program then adds
.CW 'e'-'d' ,
which converts
it to the next letter of the alphabet.
The modified constant, now single-precision,
is written out again.
There follow a series of names which must be respelled to remove
their initial \fId\fR.
By using the
array
.I yytext
the same action suffices for all the names (only a sample of
a rather long list is given here).
.P1 0
{d}{s}{i}{n}	|
{d}{c}{o}{s}	|
{d}{s}{q}{r}{t}	|
{d}{a}{t}{a}{n}	|
\&...
{d}{f}{l}{o}{a}{t}  printf("%s",yytext+1);
.P2
Another list of names must have initial \fId\fR changed to initial \fIa\fR:
.P1 0
{d}{l}{o}{g}	|
{d}{l}{o}{g}10	|
{d}{m}{i}{n}1	|
{d}{m}{a}{x}1	{
	yytext[0] =+ 'a' - 'd';
	ECHO;
	}
.P2
And one routine
must have initial \fId\fR changed to initial \fIr\fR:
.P1 0
{d}1{m}{a}{c}{h}	{
		yytext[0] =+ 'r'  - 'd';
		ECHO;
		}
.P2
To avoid such names as \fIdsinx\fR being detected as instances
of \fIdsin\fR, some final rules pick up longer words as identifiers
and copy some surviving characters:
.P1 0
[A-Za-z][A-Za-z0-9]*	|
[0-9]+	|
\en	|
\&.	ECHO;
.P2
Note that this program is not complete; it
does not deal with the spacing problems in Fortran or
with the use of keywords as identifiers.
.NH
Left Context Sensitivity.
.PP
Sometimes
it is desirable to have several sets of lexical rules
to be applied at different times in the input.
For example, a compiler preprocessor might distinguish
preprocessor statements and analyze them differently
from ordinary statements.
This requires
sensitivity
to prior context, and there are several ways of handling
such problems.
The
.CW ^
operator, for example, is a prior context operator,
recognizing immediately preceding left context just as
.CW $
recognizes
immediately following right context.
Adjacent left context could be extended, to produce a facility similar to
that for adjacent right context, but it is unlikely
to be as useful, since often the relevant left context
appeared some time earlier, such as at the beginning of a line.
.PP
This section describes three means of dealing
with different environments: a simple use of flags,
when only a few rules change from one environment to another,
the use of
.I
start conditions
.R
on rules,
and the possibility of making multiple lexical analyzers all run
together.
In each case, there are rules which recognize the need to change the
environment in which the
following input text is analyzed, and set some parameter
to reflect the change.  This may be a flag explicitly tested by
the user's action code; such a flag is the simplest way of dealing
with the problem, since \*l is not involved at all.
It may be more convenient,
however,
to have \*l remember the flags as initial conditions on the rules.
Any rule may be associated with a start condition.  It will only
be recognized when \*l is in
that start condition.
The current start condition may be changed at any time.
Finally, if the sets of rules for the different environments
are very dissimilar,
clarity may be best achieved by writing several distinct lexical
analyzers, and switching from one to another as desired.
.PP
Consider the following problem: copy the input to the output,
changing the word \fImagic\fR to \fIfirst\fR on every line which began
with the letter \fIa\fR, changing \fImagic\fR to \fIsecond\fR on every line
which began with the letter \fIb\fR, and changing
\fImagic\fR to \fIthird\fR on every line which began
with the letter \fIc\fR.  All other words and all other lines
are left unchanged.
.PP
These rules are so simple that the easiest way
to do this job is with a flag:
.P1 0
	int flag;
%%
^a	{flag = 'a'; ECHO;}
^b	{flag = 'b'; ECHO;}
^c	{flag = 'c'; ECHO;}
\en	{flag =  0 ; ECHO;}
magic	{
	switch (flag)
	{
	case 'a': printf("first"); break;
	case 'b': printf("second"); break;
	case 'c': printf("third"); break;
	default: ECHO; break;
	}
	}
.P2
should be adequate.
.PP
To handle the same problem with start conditions, each
start condition must be introduced to \*l in the definitions section
with a line reading
.P1 0
%Start	name1 name2 ...
.P2
where the conditions may be named in any order.
The word \fIStart\fR may be abbreviated to \fIs\fR or \fIS\fR.
The conditions may be referenced at the
head of a rule with the
.CW <>
brackets:
.P1 0
<name1>expression
.P2
is a rule which is only recognized when \*l is in the
start condition \fIname1\fR.
To enter a start condition,
execute the action statement
.P1 0
BEGIN name1;
.P2
which changes the start condition to \fIname1\fR.
To resume the normal state,
.P1 0
BEGIN 0;
.P2
resets the initial condition
of the \*l automaton interpreter.
A rule may be active in several
start conditions:
.P1 0
<name1,name2,name3>
.P2
is a legal prefix.  Any rule not beginning with the
.CW <>
prefix operator is always active.
.PP
The same example as before can be written:
.P1 0
%START AA BB CC
%%
^a	{ECHO; BEGIN AA;}
^b	{ECHO; BEGIN BB;}
^c	{ECHO; BEGIN CC;}
\en	{ECHO; BEGIN 0;}
<AA>magic	printf("first");
<BB>magic	printf("second");
<CC>magic	printf("third");
.P2
where the logic is exactly the same as in the previous
method of handling the problem, but \*l does the work
rather than the user's code.
.NH
Character Set.
.PP
The programs generated by \*l handle
character I/O only through the routines
.I input ,
.I output ,
and
.I unput .
Thus the character representation
provided in these routines
is accepted by \*l and employed to return
values in
.I yytext .
For internal use
a character is represented as a small integer
which, if the standard library is used,
has a value equal to the integer value of the bit
pattern representing the character on the host computer.
Normally, the letter
.CW a
is represented as the same form as the character constant
.CW 'a' .
If this interpretation is changed, by providing I/O
routines which translate the characters,
\*l must be told about
it, by giving a translation table.
This table must be in the definitions section,
and must be bracketed by lines containing  only
.CW %T .
The table contains lines of the form
.P1 0
{integer} {character string}
.P2
which indicate the value associated with each character.
.KF
.P1 0
%T
 1	Aa
 2	Bb
\&...
26	Zz
27	\en
28	+
29	-
30	0
31	1
\&...
39	9
%T
.P2
.sp
.ce 1
Sample character table.
.KE
Thus the next example
maps the lower and upper case letters together into the integers 1 through 26,
newline into 27, + and - into 28 and 29, and the
digits into 30 through 39.
Note the escape for newline.
If a table is supplied, every character that is to appear either
in the rules or in any valid input must be included
in the table.
No character
may be assigned the number 0, and no character may be
assigned a bigger number than the size of the hardware character set.
.NH
Summary of Source Format.
.PP
The general form of a \*l source file is:
.P1
{definitions}
%%
{rules}
%%
{user subroutines}
.P2
The definitions section contains
a combination of
.IP 1)
Definitions, in the form ``name space translation''.
.IP 2)
Included code, in the form ``space code''.
.IP 3)
Included code, in the form
.P1
%{
code
%}
.P2
.ns
.IP 4)
Start conditions, given in the form
.P1
%S name1 name2 ...
.P2
.ns
.IP 5)
Character set tables, in the form
.P1
%T
number space character-string
\&...
%T
.P2
.ns
.IP 6)
Changes to internal array sizes, in the form
.SP .5
%\fIx\fP \fInnn
.SP .5
where \fInnn\fR is a decimal integer representing an array size
and \fIx\fR selects the parameter as follows:
.TS
center;
c c
cFCW l.
Letter	Parameter
p	positions
n	states
e	tree nodes
a	transitions
k	packed character classes
o	output array size
.TE
.LP
Lines in the rules section have the form ``expression  action''
where the action may be continued on succeeding
lines by using braces to delimit it.
.PP
Regular expressions in \*l use the following
operators:
.TS
center;
lFCW l.
x	the character "x"
"x"	an "x", even if x is an operator.
\ex	an "x", even if x is an operator.
[xy]	the character x or y.
[x-z]	the characters x, y or z.
[^x]	any character but x.
\&.	any character but newline.
^x	an x at the beginning of a line.
<y>x	an x when \*l is in start condition y.
x$	an x at the end of a line.
x?	an optional x.
x*	0,1,2, ... instances of x.
x+	1,2,3, ... instances of x.
x|y	an x or a y.
(x)	an x.
x/y	an x but only if followed by y.
{xx}	the translation of xx from the
	    definitions section.
x{m,n}	\fIm\fR through \fIn\fR occurrences of x
.TE
.NH
Caveats and Bugs.
.PP
There are pathological expressions which
produce exponential growth of the tables when
converted to deterministic machines;
fortunately, they are rare.
.PP
REJECT does not rescan the input; instead it remembers the results of the previous
scan.  This means that if a rule with trailing context is found, and
REJECT executed, the user
must not have used
.I unput
to change the characters forthcoming
from the input stream.
This is the only restriction on the user's ability to manipulate
the not-yet-processed input.
.NH
Acknowledgments.
.PP
As should
be obvious from the above, the outside of \*l
is patterned
on \fIyacc\fP and the inside on Aho's string matching routines.
Therefore, both S. C. Johnson and A. V. Aho
are really originators
of much of \*l,
as well as debuggers of it.
Many thanks are due to both.
.PP
The code of the current version of \*l was designed, written,
and debugged by Eric Schmidt.
.NH
References.
.LP
|reference_placement
