      LOGICAL FUNCTION ODESE(X,NX,T,DT,ERRPAR,ERPUTS,E)
C
C  STANDARD ERROR ROUTINE FOR ODES WITH THE OPTION FOR ERROR CONTROL
C  BASED ON EITHER THE LOCAL VALUE OR THE GLOBAL MAXIMUM OF EACH
C  COMPONENT.
C
C  THE OPTION FOR ERROR CONTROL ON AN ERROR PER UNIT-TIME-STEP OR
C  ERROR PER TIME-STEP BASIS IS ALSO PROVIDED.
C
C  INPUT
C
C    X      - X=X(T), THE APPROXIMATE SOLUTION FOR WHICH AN ERROR
C             CRITERION IS DESIRED.
C    NX     - THE LENGTH OF THE SOLUTION VECTOR X.
C    T      - CURRENT VALUE OF THE TIME VARIABLE.
C    DT     - CURRENT TIME-STEP.
C    ERRPAR - TWO PARAMETERS FOR USE IN DETERMINING THE DESIRED ERROR.
C    ERPUTS - IF ERPUTS=.TRUE., THEN THE ERROR IS TO BE
C             PROPORTIONAL TO ABS(DT). OTHERWISE IT WILL NOT.
C    E      - X(I) IS ACCURATE TO A REAL ABSOLUTE ERROR OF E(I),
C             I=1,...,NX, FOR THE SINGLE CURRENT TIME-STEP.
C
C  COMMON INPUT
C
C    IGMAX  - THE POINTER TO THE REAL VECTOR OF CURRENT MAXIMUM ABSOLUTE
C             VALUES ATTAINED BY EACH COMPONENT OF THE SOLUTION.
C             IGMAX=0 MEANS THIS VECTOR IS NOT USED AND HAS NOT BEEN
C             ALLOCATED.
C
C  OUTPUT
C
C    E      - THE REAL ERROR VECTOR. E(I) IS THE ABSOLUTE ERROR
C             TOLERABLE IN X(I), FOR I=1,...,NX.
C
C             LET V(I) = ABS(X(I)) IF IGMAX=0
C                           OTHERWISE
C                      = MAXIMUM(ABS(X(I)(T))) OVER ALL PREVIOUS TIME.
C                        THIS VALUE IS STORED IN THE REAL STACK
C                        POSITION RS(I+IGMAX-1).
C
C             AND EPS = 1 IF ERPUTS=.FALSE.
C                           OTHERWISE
C                     = ABS(DT),
C
C             THEN
C
C                     E(I) = EPS * (ERRPAR(1)*V(I) + ERRPAR(2)),
C
C             FOR I=1,...,NX.
C
C  FUNCTION VALUE
C
C    ODESE - .TRUE. IF EACH X(I) IS ACCURATE TO WITHIN AN
C             ABSOLUTE ERROR OF E(I), I=1,...,NX, OTHERWISE .FALSE. .
C
C  SCRATCH SPACE ALLOCATED - NONE.
C
C  ERROR STATES - NONE.
C
      COMMON /ODESM/IGMAX,IGMAXO
C
      REAL X(NX),T,DT
      REAL ERRPAR(2),E(NX)
      LOGICAL ERPUTS
C
      REAL DTPOW,TEMP
C
      COMMON /CSTAK/DS
      DOUBLE PRECISION DS(500)
      REAL RS(1000)
      EQUIVALENCE (DS(1),RS(1))
C
      DTPOW=1.0E0
      IF (ERPUTS) DTPOW=ABS(DT)
C
      ODESE=.TRUE.
      J=IGMAX
C
      DO 10 I=1,NX
C
         IF (IGMAX.GT.0) TEMP=RS(J)
         IF (IGMAX.EQ.0) TEMP=ABS((X(I)))
         TEMP=DTPOW*(ERRPAR(1)*TEMP+ERRPAR(2))
C
         IF (E(I).GT.TEMP) ODESE=.FALSE.
C
         E(I)=TEMP
C
 10      J=J+1
C
      RETURN
C
      END
