/*
	## buf.h ##
									*/

struct buf
	{
	int     b_flags;                /* flag				*/
	struct  buf *b_forw;            /* dev_tab lista elore		*/
	struct  buf *b_back;            /*    -  "  -	 hatra		*/
	struct  buf *av_forw;           /* szabad lista			*/
	struct  buf *av_back;           /*     ha nem BUSY		*/
	dev_t   b_dev;                  /* major+minor device 		*/
	int     b_wcount;               /* atvitel szamlalo		*/
	dword	b_xmem;			/* adatcim szegmens bazis	*/
	caddr_t b_addr;                 /* adatok cime 			*/
	blk_t   b_blkno;                /* block szam a device-on	*/
	char    b_error;                /* I/O hiba			*/
	word    b_resid;                /* hiba utani maradek adatok	*/
	};

struct devtab
	{
	char    d_active;               /* busy flag 			*/
	char    d_errcnt;               /* hiba szamlalo	 	*/
	struct  buf *b_forw;            /* elso buffer erre a dev-ra 	*/
	struct  buf *b_back;            /* utolso     -  "   -	 	*/
	struct  buf *d_actf;            /* I/O sor eleje		*/
	struct  buf *d_actl;            /* I/O sor vege 		*/
	};

#define B_WRITE     0   /* non-read pseudo-flag 			*/
#define B_READ     01   /* read when I/O occurs 			*/
#define B_DONE     02   /* transaction finished 			*/
#define B_ERROR    04   /* transaction aborted 				*/
#define B_BUSY    010   /* not on av_forw/back list 			*/
#define B_PHYS    020   /* Physical IO potentially using UNIBUS map 	*/
#define B_MAP     040   /* This block has the UNIBUS map allocated 	*/
#define B_WANTED 0100   /* issue wakeup when BUSY goes off 		*/
#define B_RELOC  0200   /* no longer used 				*/
#define B_ASYNC  0400   /* don't wait for I/O completion 		*/
#define B_DELWRI   01  	/* don't write till block leaves available list */


#define D_UMOUNT   010

#define D_WRITE    02
#define D_READ     00

#define TO_BUF   1      /* move from kerner area to buffer */
#define FROM_BUF 0      /* move from buffer to kerner area */

struct buf * alloc (dev_t);
void	     free  (dev_t,blk_t);

blk_t	     bmap(struct inode*,blk_t);

struct buf *getblk (dev_t,blk_t);
struct buf *bread  (dev_t,blk_t);
struct buf *breada (dev_t,blk_t,blk_t);
void	    bwrite (struct buf*);
void	    bdwrite(struct buf*);
void	    bawrite(struct buf*);
void	    brelse (struct buf*);
void	    iowait (struct buf*);
void	    iodone (struct buf*);
void	    geterror (struct buf*);
void 	    notavail(struct buf*);
void	    clrbuf (struct buf*);
void	    bflush (dev_t);
int	    swap (blk_t,gaddr_t,word,int);
void	    iomove (struct buf*,int,int,int);
void	    physio (int(),struct buf*,dev_t,int);

