/*
 * 	cp oldfile newfile
 *
 *	copy oldfile to newfile
 */

#include "..\..\include\sys\stat.h"

main(argc,argv)
char *argv[];
{
	static char buf[512];
	struct stat *sp1,*sp2;
	int fold, fnew, n;
	register char *p1, *p2, *bp;
	int mode;
	if(argc != 3) 
		{
		write(1, "Usage: cp oldfile newfile\n", 26);
		exit(1);
		}
	if((fold = open(argv[1], 0)) < 0) 
		{
		write(1, "Cannot open old file.\n", 22);
		exit(1);
		}

	sp1=(struct stat*)buf;
	sp2=(struct stat*)(buf+100);

	fstat(fold, sp1);

	mode = sp1->s_flags;
	/* is target a directory? */
	if (stat(argv[2], sp2)>=0 && (sp2->s_flags&S_TYPE)==S_DIREC)
		{
		p1 = argv[1];
		p2 = argv[2];
		bp = buf+200;
		while(*bp++ = *p2++);
		bp[-1] = '/';
		p2 = bp;
		while(*bp = *p1++)
			if(*bp++ == '/')
				bp = p2;
		argv[2] = buf+200;
		}
	if (stat(argv[2], sp2) >= 0) 
		{
		if (sp1->s_dev==sp2->s_dev &&
		    sp2->s_inumber==sp2->s_inumber) 
			{
			write(1, "Copying file to itself.\n", 24);
			exit(1);
			}
		}
	if ((fnew = creat(argv[2], mode)) < 0)
		{
		write(1, "Can't create new file.\n", 23);
		exit(1);
		}
	while(n = read(fold,  buf,  512)) {
	if(n < 0) 
		{
		write(1, "Read error\n", 11);
		exit(1);
		}
	else
		if(write(fnew, buf, n) != n)
			{
			write(1, "Write error.\n", 13);
			exit(1);
			}
		}
	exit(0);
	}
