
#ifndef _SCSI_H_
#define _SCSI_H_


struct scsi_write {
	unsigned long	tran_id;	/* transaction id */
	unsigned char	target;		/* SCSI id of traget device */
	unsigned char	flags;		/* flags for this transaction */
	char		cmd[12];	/* SCSI command */
	char		data[];		/* optional data */
};

struct scsi_read {
	unsigned long	tran_id;	/* transaction id */
	unsigned char	status;		/* scsi status byte */
	unsigned char	message;	/* scsi message byte */
	unsigned char	flags;		/* flags for this transction */
	unsigned char	c_type;		/* 1=td 2=us */
	unsigned short	c_reg1;		/* td=sa, us=csr */
	unsigned short	c_reg2;		/* td=mscp, us=per */
	unsigned char	sense[22];	/* extend sense data */
	char		data[];		/* any data */
};

/* flags for the transactions */

#define	SCSI_WR		(0x01)
#define SCSI_RD		(0x02)
#define SCSI_BRESET	(0x04)
#define SCSI_RESET	(0x08)
#define SCSI_SENSE	(0x10)
#define SCSI_CERR	(0x20)

#endif /* _SCSI_H_ */
