#include <sys/types.h>
#include <dirent.h>
#include <sys/dir.h>

#define	NULL 0
/* readdir:  read directory entries in sequence */

struct dirent *readdir(dp)
	DIR *dp;
{
	struct direct dirbuf;
	static struct dirent d;

	while (read(dp->fd, (char *) &dirbuf, sizeof(dirbuf)) == sizeof(dirbuf)) {
		if (dirbuf.d_ino == 0)		/* slot empty */
			continue;
		d.d_ino = dirbuf.d_ino;
		strncpy(d.d_name, dirbuf.d_name, NAME_MAX);
		d.d_name[NAME_MAX] = '\0'; /* ensure termination */
		d.d_namlen = strlen(d.d_name);
		return &d;
	}
	return NULL;
}
