
/*
 * $Log:	coredump.c,v $
 * Revision 1.1  86/03/11  10:07:05  root
 * Initial revision
 * 
 */

/* Copyright (c) 1982 Regents of the University of California */


/*
 * Deal with the core dump anachronism.
 */

#include "defs.h"
#include "coredump.h"
#include "machine.h"
#include "object.h"
#include "main.h"
#include <sys/param.h>
#include <sys/dir.h>
#ifdef notdef
#include <machine/psl.h>
#include <machine/pte.h>
#endif
#include <sys/seg.h>
#include <sys/ipm.h>
#include <sys/signal.h>
#include <sys/user.h>
#include <sys/reg.h>
#ifdef notdef
#include <sys/vm.h>
#include <machine/reg.h>
#endif
#include <a.out.h>

#ifndef public
#define coredump_readin(m, r, s) coredump_xreadin(&(m), r, &(s))
#endif public
#include "machine.h"
# define NEWTEXTOFF 0x20
# define BASE_DATA_SEGMENT (1L << 17)  /* data base in core */   

#ifndef vax
#define MAXSTKADDR USRSTACK		/* highest stack address */
#else
#define	 MAXSTKADDR	(0x03000000)	/* highest stack address */
#endif vax

typedef struct {
    Address begin;
    Address end;
    Address seekaddr;
} Map;

int stksiz;	
private Map datamap, stkmap;
private File objfile;
private struct exec hdr;

/*
 * Read the user area information from the core dump.
 */
int hiwater;

public coredump_xreadin(mask, reg, signo)
int *mask;
Word reg[];
int *signo;
{
char *usersp;

    register struct user *up;
#ifdef tws
    register struct sysframe *savreg;
#else tws
    register Word *savreg;
#endif tws
    union {
	struct user u;
	char dummy[ctob(USIZE)];
    } ustruct;

    objfile = fopen(objname, "r");
    if (objfile == nil) {
	fatal("can't read \"%s\"", objname);
    }
    get(objfile, hdr);
    up = &(ustruct.u);
    fread(up, ctob(USIZE), 1, corefile); /* CAUSES CORE TRACE ERRORS */

    /*
     * Core dump not from this object file?
     */


     if ((hdr.a_magic == ZMAGIC) && (up->u_exdata.ux_mag == ZMAGIC) &&
	(strcmp(objname,up->u_comm))){
	warning("core dump ignored");
	coredump = false;
	start(nil, nil, nil);
	return;
      }

#ifdef tws
    savreg = (struct sysframe *) ((int)ustruct.u.u_ar0 - (int)USRSTACK +
		(int)&ustruct);
    *mask = savreg->sf_sr;			/* ??? THIS MAY BE BOGUS ??? */
    reg[RD0] = savreg->sf_regs[RD0];
    reg[RD1] = savreg->sf_regs[RD1];
    reg[RD2] = savreg->sf_regs[RD2];
    reg[RD3] = savreg->sf_regs[RD3];
    reg[RD4] = savreg->sf_regs[RD4];
    reg[RD5] = savreg->sf_regs[RD5];
    reg[RD6] = savreg->sf_regs[RD6];
    reg[RD7] = savreg->sf_regs[RD7];
    reg[RA0] = savreg->sf_regs[RA0];
    reg[RA1] = savreg->sf_regs[RA1];
    reg[RA2] = savreg->sf_regs[RA2];
    reg[RA3] = savreg->sf_regs[RA3];
    reg[RA4] = savreg->sf_regs[RA4];
    reg[RA5] = savreg->sf_regs[RA5];
    /* reg[ARGP] = savreg->sf_regs[AP]; */	/* FP and AP same on 68000's */
    reg[FRP] = savreg->sf_regs[RA6];
    reg[STKP] = savreg->sf_usp;
    reg[PROGCTR] = savreg->sf_pc;
#else
#ifdef mc68000
    *((Address *)&ustruct.u.u_ar0) &= ctob(USIZE) - 1;
    savreg = (Word *)(((Address)&ustruct)+(Address)&ustruct.u.u_ar0[0]);
#else (vax)
    savreg = (Word *) &(ustruct.dummy[ctob(USIZE)]);
#endif mc680000
    *mask = savreg[PS];
    reg[0] = savreg[R0];
    reg[1] = savreg[R1];
    reg[2] = savreg[R2];
    reg[3] = savreg[R3];
    reg[4] = savreg[R4];
    reg[5] = savreg[R5];
    reg[6] = savreg[R6];
    reg[7] = savreg[R7];
    reg[8] = savreg[R8];
    reg[9] = savreg[R9];
    reg[10] = savreg[R10];
    reg[11] = savreg[R11];
# ifdef vax
    reg[ARGP] = savreg[AP];
# endif vax
# ifdef mc68000
    reg[12] = savreg[R12];
    reg[13] = savreg[R13];
# endif mc68000
    reg[FRP] = savreg[FP];
    reg[STKP] = savreg[SP];
    reg[PROGCTR] = savreg[PC];
#endif tws
    *signo = up->u_arg[0];
    datamap.seekaddr = ctob(USIZE);
    stksiz = ctob(up->u_ssize);

#ifdef OLD
    stkmap.begin = hiwater /*MAXSTKADDR*/ - ctob(up->u_ssize);
    stkmap.end = hiwater /*MAXSTKADDR*/;
#endif OLD

    /* setup stack for all bus and cpu versions */
    stkmap.begin = hiwater - (stksiz); 
    stkmap.end = hiwater;

    stkmap.seekaddr = datamap.seekaddr + ctob(up->u_dsize);
    switch (hdr.a_magic) {
	case OMAGIC:
	    datamap.begin = 0;
	    datamap.end = ctob(up->u_tsize) + ctob(up->u_dsize);
	    break;

	case NMAGIC:
	case ZMAGIC:
	    datamap.begin = 0x01000000;
	    datamap.begin = upround(hdr.a_text,BASE_DATA_SEGMENT);
	    datamap.end = datamap.begin + ctob(up->u_dsize);
# ifdef NOTDEF
	    datamap.end = datamap.begin + ctob(up->u_dsize);
# endif NOTDEF

 	    usersp= savreg[SP]; 
	    break;

	default:
	    fatal("bad magic number 0x%x", hdr.a_magic);
    }
}

public coredump_close()
{
    fclose(objfile);
}

public coredump_readtext(buff, addr, nbytes)
char *buff;
Address addr;
int nbytes;
{
    if (hdr.a_magic == OMAGIC) {
	coredump_readdata(buff, addr, nbytes);
    } else {
	fseek(objfile, N_TXTOFF(hdr) + addr, 0);
	fread(buff, nbytes, sizeof(Byte), objfile);
    }
}

public coredump_readdata(buff, addr, nbytes)
char *buff;
Address addr;
int nbytes;
{
    if (addr < datamap.begin) {
	if (hdr.a_magic == OMAGIC) {
	    error("data address 0x%x too low (lb = 0x%x)", addr, datamap.begin);
	} else {
	    coredump_readtext(buff, addr, nbytes);
	}
    } else if (addr > stkmap.end) {
	error("data address 0x%x too high (ub = 0x%x)", addr, stkmap.end);
    } else if (addr < stkmap.begin) {
	fseek(corefile, datamap.seekaddr + addr - datamap.begin, 0);
	fread(buff, nbytes, sizeof(Byte), corefile);
    } else {
	fseek(corefile, stkmap.seekaddr + addr - stkmap.begin, 0);
	fread(buff, nbytes, sizeof(Byte), corefile);
    }
}

long
upround(a,b)
register long a,b;
{
	register long w;

	w = (a / b) * b;
	if ((a != w) || ((w % a) == 0))
		 w += b;
	return(w);
}

