/*
 * coreid - retrieve command line arguments from a core file.
 */

#include <sys/types.h>
#include <sys/proc.h>
#include <sys/dir.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/signal.h>
#include <sys/seg.h>
#include <sys/ipm.h>
#include <sys/user.h>
#include <stdio.h>
#include <core.h>
#include <a.out.h>

main(argc, argv)
int	argc;
char	**argv;
{
	int		fd, nargs;
	register int	*ip;
	char		*sp, *ep, *core;
	struct user	u;
	extern char	*index();


	if (argc > 2) {
		fprintf (stderr, "Usage: coreid [corefile]\n");
		exit (1);
	}
	core = "core";
	if (argc == 2)
		core = argv[1];
	if ((fd = open (core, 0)) == NULL) {
		perror (core);
		exit (1);
	}

	/* read in core file header */
	read (fd, &u, sizeof u);

	/* read in stack segment */
	lseek (fd, ctob(USIZE) + ctob(u.u_dsize), 0L);
	if ((sp = (char *) malloc(ctob(u.u_ssize))) == NULL) {
		fprintf(stderr,
			"coreid: unable to malloc %d bytes\n",
			ctob(u.u_ssize));
		exit (1);
	}
	read(fd, sp, ctob(u.u_ssize));
	ep = sp + ctob(u.u_ssize) - sizeof (int);

	/* first read backwards through the environment and argument strings */
	ip = (int *) ep;
	ip--;
	while (*--ip)
		;

	/* now have pointer to start of the args */
	sp = (char *) (ip + 1);

	/* now find out how many args there are supposed to be */
	while (*--ip)
		;
	for (nargs = 0; nargs < *--ip; nargs++)
		;
	for (; sp <= ep && nargs-- > 0; sp += strlen(sp) + 1)
		if (index(sp, ' '))
			printf("'%s' ", sp);
		else
			printf("%s ", sp);
	printf ("\n");
}

