/*
 *
 *	UNIX debugger
 *
 */

# include <sys/reg.h>/**/
#include "defs.h"

extern	MAP	txtmap;

MSG		NOFORK;
MSG		ENDPCS;
MSG		BADWAIT;

CHAR		*lp;
ADDR		sigint;
ADDR		sigqit;

/* breakpoints */
BKPTR		bkpthead;

REGLIST		reglist[];

CHAR		lastc;

INT		fcor;
INT		fsym;
STRING		errflg;
extern int		errno;
INT		signo;
INT		sigcode;

L_INT		dot;
STRING		symfil;
INT		wtflag;
INT		pid;
L_INT		expv;
INT		adrflg;
L_INT		loopcnt;

# include <sgtty.h>
extern struct sgttyb adbtty,subtty;




/* service routines for sub process control */

getsig(sig)
{	return(expr(0) ? expv : sig);
}

ADDR userpc = 1;

runpcs(runmode,execsig)
{
	INT		rc;
	REG BKPTR	bkpt;
	IF adrflg THEN userpc=dot; FI
	printf("%s: running\n", symfil);

	WHILE --loopcnt>=0
	DO
#ifdef DEBUG
		printf("\ncontinue %x %d\n",userpc,execsig);
#endif
		IF runmode==SINGLE
		THEN delbp(); /* hardware handles single-stepping */
		ELSE /* continuing from a breakpoint is hard */
			IF bkpt=scanbkpt(userpc)
			THEN 
				execbkpt(bkpt,execsig); execsig=0;
			FI
			setbp();
		FI
		ioctl(0, TIOCSETP, &subtty);
		ptrace(runmode,pid,userpc,execsig);
		bpwait(); chkerr(); execsig=0; delbp(); readregs();

		IF (signo==0) ANDF (bkpt=scanbkpt(userpc))
		THEN /* stopped by BPT instruction */
#ifdef DEBUG
			printf("\n BPT code; '%s'%o'%o'%d",
				bkpt->comm,bkpt->comm[0],EOR,bkpt->flag);
#endif
			dot=bkpt->loc;
			IF bkpt->flag==BKPTEXEC
			ORF ((bkpt->flag=BKPTEXEC)
				ANDF bkpt->comm[0]!=EOR
				ANDF command(bkpt->comm,':')
				ANDF --bkpt->count)
			THEN execbkpt(bkpt,execsig); execsig=0; loopcnt++;
			ELSE bkpt->count=bkpt->initcnt; rc=1;
			FI
		ELSE execsig=signo; rc=0;
		FI
	OD
	return(rc);
}

#define BPOUT 0
#define BPIN 1
INT bpstate = BPOUT;

endpcs()
{
	REG BKPTR	bkptr;
	IF pid
	THEN ptrace(EXIT,pid,0,0); pid=0; userpc=1;
	     FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt
	     DO IF bkptr->flag
		THEN bkptr->flag=BKPTSET;
		FI
	     OD
	FI
	ioctl(0, TIOCGETP, &subtty);
	ioctl(0, TIOCSETP, &adbtty);
	bpstate=BPOUT;
}

#ifdef VFORK
nullsig()
{

}
#endif

setup()
{
	extern int errno;
	int rc;

	close(fsym); fsym = -1;
#ifndef VFORK
	IF (pid = fork()) == 0
#else
	IF (pid = vfork()) == 0
#endif
	THEN 
		rc = ptrace(SETTRC,0,0,0);
#ifdef VFORK
	     signal(SIGTRAP,nullsig);
#endif
	     signal(SIGINT,sigint); signal(SIGQUIT,sigqit);
	     doexec(); exit(0);
	ELIF pid == -1
	THEN error(NOFORK);
	ELSE
	     bpwait(); readregs(); lp[0]=EOR; lp[1]=0;
	     fsym=open(symfil,wtflag);
	     IF errflg
	     THEN printf("%s: cannot execute\n",symfil);
		  endpcs(); error(0);
	     FI
	FI
	bpstate=BPOUT;
}

execbkpt(bkptr,execsig)
BKPTR	bkptr;
{
#ifdef DEBUG
	printf("exbkpt: addr is %X, execsig is %X\n",bkptr->loc,execsig);
#endif
	delbp();
	ioctl(0, TIOCSETP, &subtty);
	ptrace(SINGLE,pid,bkptr->loc,execsig);
	bkptr->flag=BKPTSET;
	bpwait(); chkerr(); readregs();
}


doexec()
{
	STRING		argl[MAXARG];
	CHAR		args[LINSIZ];
	STRING		p, *ap, filnam;
	extern STRING environ;
	ap=argl; p=args;
	*ap++=symfil;
	REP	IF rdc()==EOR THEN break; FI
		*ap = p;
		/*
		 * First thing is to look for direction characters
		 * and get filename.  Do not use up the args for filenames.
		 * Then get rid of spaces before next args.
		 */
		IF lastc=='<'
		THEN	REP readchar(); PER lastc==SPC ORF lastc==TB DONE
			filnam = p;
			WHILE lastc!=EOR ANDF lastc!=SPC ANDF lastc!=TB ANDF lastc!='>'
				DO *p++=lastc; readchar(); OD
			*p = 0;
			close(0);
			IF open(filnam,0)<0
			THEN	printf("%s: cannot open\n",filnam); _exit(0);
			FI
			p = *ap;
		ELIF lastc=='>'
		THEN	REP readchar(); PER lastc==SPC ORF lastc==TB DONE
			filnam = p;
			WHILE lastc!=EOR ANDF lastc!=SPC ANDF lastc!=TB ANDF lastc!='<'
				DO *p++=lastc; readchar(); OD
			*p = '\0';
			close(1);
			IF creat(filnam,0666)<0
			THEN	printf("%s: cannot create\n",filnam); _exit(0);
			FI
			p = *ap;
		ELSE	
			WHILE lastc!=EOR ANDF lastc!=SPC ANDF lastc!=TB ANDF lastc!='>' ANDF lastc!='<'
				DO *p++=lastc; readchar(); OD
			*p++ = '\0';
	 		ap++;
		FI
	PER lastc!=EOR DONE
	*ap++=0;
#ifdef EXECT
	exect(symfil, argl, environ);
#else  EXECT
	execve(symfil, argl, environ);
#endif EXECT
	perror(symfil);
}

BKPTR	scanbkpt(adr)
ADDR adr;
{
	REG BKPTR	bkptr;

	FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt
	DO IF bkptr->flag ANDF bkptr->loc==adr
	   THEN break;
	   FI
	OD
	return(bkptr);
}

delbp()
{
	REG ADDR	a;
	REG BKPTR	bkptr;

	IF bpstate!=BPOUT
	THEN
		FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt
		DO	IF bkptr->flag
			THEN a=bkptr->loc;
				IF a < txtmap.e1 THEN
				ptrace(WIUSER,pid,a,
					(bkptr->ins&~0xFFFF)|(ptrace(RIUSER,pid,a,0)&0xFFFF));
				ELSE
				ptrace(WDUSER,pid,a,
					(bkptr->ins&~0xFFFF)|(ptrace(RDUSER,pid,a,0)&0xFFFF));
				FI
			FI
		OD
		bpstate=BPOUT;
	FI
}

setbp()
{
	REG ADDR		a;
	REG BKPTR	bkptr;

	IF bpstate!=BPIN
	THEN
		FOR bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt
		DO IF bkptr->flag
		   THEN a = bkptr->loc;
			IF a < txtmap.e1 THEN
				bkptr->ins = ptrace(RIUSER, pid, a, 0);
				ptrace(WIUSER, pid, a, BPT | (bkptr->ins&0xFFFF));
			ELSE
				bkptr->ins = ptrace(RDUSER, pid, a, 0);
				ptrace(WDUSER, pid, a, BPT | (bkptr->ins&0xFFFF));
			FI
/* 
'errno' is NOT reset on successful system calls.  this is misleading
when 'ptrace' works ok.  stub out for now.    -tab
			IF errno
			THEN prints("cannot set breakpoint: ");
			     psymoff(bkptr->loc,ISYM,"\n");
			FI
*/
		   FI
		OD
		bpstate=BPIN;
	FI
}

bpwait()
{
	REG ADDR w;
	ADDR stat;

	signal(SIGINT, 1);
	WHILE (w = wait(&stat))!=pid ANDF w != -1 DONE
	ioctl(0, TIOCGETP, &subtty);
	ioctl(0, TIOCSETP, &adbtty);
	signal(SIGINT,sigint);
	IF w == -1
	THEN pid=0;
	     errflg=BADWAIT;
	ELIF (stat & 0177) != 0177
	THEN sigcode = 0;
	     IF signo = stat&0177
	     THEN sigprint();
	     FI
	     IF stat&0200
	     THEN prints(" - core dumped");
		  close(fcor);
		  setcor();
	     FI
	     pid=0;
	     errflg=ENDPCS;
	ELSE signo = stat>>8;
/*
		abort("Don't know what to do?");
	     sigcode = ptrace(RUREGS, pid, &((struct user *)0)->u_code, 0);
*/
		sigcode = 1;	
	     IF signo!=SIGTRAP
	     THEN sigprint();
	     ELSE signo=0;
	     FI
	     flushbuf();
	FI
}

readregs()
{
	/*get REG values from pcs*/
	REG i;

/*
	abort("don't know what to do?");
*/
	u.u_ar0 = ptrace(RUREGS, pid, &((struct user *)0)->u_ar0, 0) & 
		((ctob(UPAGES)) -1);

	FOR i=RGLSTSZ; --i>=0; 
	DO 
	   *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[reglist[i].roffs]) =
		    ptrace(RUREGS, pid, (ADDR)&u.u_ar0[reglist[i].roffs], 0);
	OD
 	userpc= *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[PC]);
	read_fp_regs(); 
}

extern unsigned short fp_array[];
/*
 * read_fp_regs() -> Extract floating point data from user structure and
 *		     place in holding array.
 */
read_fp_regs()
{
	int i;
	char p_buf[100];
	unsigned int fp_offset;
	unsigned short *p;

	p = (unsigned short *)fp_array;/* array for 68881 register data */

/*	abort("don't know what to do?"); */
/*	fp_offset = (ADDR)&u.u_68881_regs-((ADDR)&u); /* base of 68881 data */

	for (i = (NUM_FP_BYTES/2); i >= 0; --i) 
		{
	 	*p = ptrace(RUREGS, pid,fp_offset,0);

#ifdef DEBUG
	 sprintf(p_buf,"*p=%x fp_offset=%x\n",(unsigned short)*p,fp_offset);
         printf("%s",p_buf);
 	 flushbuf();
#endif DEBUG

	 	fp_offset += sizeof(short);
	 	p++;
	 	}
}


