/*
 * Structure for stty and gtty system calls.
 */

struct sgttyb {
	char	sg_ispeed;		/* input speed */
	char	sg_ospeed;		/* output speed */
	char	sg_erase;		/* erase character */
	char	sg_kill;		/* kill character */
	int	sg_flags;		/* mode flags */
};

/*
 * List of special characters
 */
struct tchars {
	char	t_intrc;	/* interrupt */
	char	t_quitc;	/* quit */
	char	t_startc;	/* start output */
	char	t_stopc;	/* stop output */
	char	t_eofc;		/* end-of-file */
	char	t_brkc;		/* input delimiter (like nl) */
};

/*
 * Modes
 */
#define	TANDEM	01
#define	CBREAK	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define ANYP	0300
#define	NLDELAY	001400
#define	TBDELAY	006000
#define	XTABS	06000
#define	CRDELAY	030000
#define	VTDELAY	040000
#define BSDELAY 0100000
#define ALLDELAY 0177400

/*
 * Delay algorithms
 */
#define	CR0	0
#define	CR1	010000
#define	CR2	020000
#define	CR3	030000
#define	NL0	0
#define	NL1	000400
#define	NL2	001000
#define	NL3	001400
#define	TAB0	0
#define	TAB1	002000
#define	TAB2	004000
#define	FF0	0
#define	FF1	040000
#define	BS0	0
#define	BS1	0100000

/*
 * Speeds
 */
#define B0	0
#define B50	1
#define B75	2
#define B110	3
#define B134	4
#define B150	5
#define B200	6
#define B300	7
#define B600	8
#define B1200	9
#define	B1800	10
#define B2400	11
#define B4800	12
#define B9600	13
#define EXTA	14
#define EXTB	15

/*
 * tty ioctl commands
 */
#define	TIOCGDEV	(('t'<<8)|0)
#define	TIOCSDEV	(('t'<<8)|1)
#define	TIOCSETC	(('t'<<8)|2)
#define	TIOCGETC	(('t'<<8)|3)
#define	TIOCGETP	(('t'<<8)|4)
#define	TIOCSETP	(('t'<<8)|5)
#define	TIOCSPRGP	(('t'<<8)|6)
#define	TIOCGPRGP	(('t'<<8)|7)
#define	TIOCEXCL	(('t'<<8)|8)
#define	TIOCNXCL	(('t'<<8)|9)
#define	TIOCBRK		(('t'<<8)|10)
#define	TIOCFLUSH	(('t'<<8)|11)
#define	TIOCHPCL	(('t'<<8)|12)

#define	FIOCLEX		(('f'<<8)|0)
#define	FIONCLEX	(('f'<<8)|1)
#define	FIOPUSHLD	(('f'<<8)|2)
#define	FIOINSLD	(('f'<<8)|3)
#define	FIOPOPLD	(('f'<<8)|4)
#define	FIOLOOKLD	(('f'<<8)|5)
#define	FIOSNDFD	(('f'<<8)|6)
#define	FIORCVFD	(('f'<<8)|7)
#define	FIONREAD	(('f'<<8)|8)
#define	FIOACCEPT	(('f'<<8)|9)
#define	FIOREJECT	(('f'<<8)|10)

#define	MXLSTN		(('x'<<8)|1)
#define	MXNBLK		(('x'<<8)|2)
