/* scsi.h: scsi device protocol */

struct	scsi_wh	{			/* write information */
	unsigned long	trans_id;	/* transaction id */
	unsigned char	target;		/* scsi id of target device */
	unsigned char	flags;		/* flags for this transaction */
	unsigned char	cmd[10];	/* scsi command */
};


struct	scsi_rh	{			/* read information */
	unsigned long	trans_id;	/* transaction id */
	unsigned char	status;		/* scsi status byte */
	unsigned char	message;	/* scsi message byte */
	unsigned char	flags;		/* flags for this transaction */
	unsigned char	c_type;		/* 3 = wd3393 */
	unsigned char	c_req1;		/* reserved */
	unsigned char	c_req2;		/* reserved */
	unsigned char	sense[22];	/* extended sense data */
};

/*	values for flags */

#define	SCSI_WR		0001
#define	SCSI_RD		0002
#define	SCSI_BRESET	0004
#define	SCSI_RESET	0010
#define	SCSI_SENSE	0020
#define	SCSI_CERR	0040
