/* cdc.c:  Status device driver for CDC SCSI discs */
#include "sys/param.h"
#include "sys/inode.h"
#include "saio.h"

char	request[] = { 3, 0, 0, 0, 14, 0 };
char	data[14];
char	w[] = { 0xA, 0, 0, 0, 0, 0 };
char	r[] = { 8, 0, 0, 0, 0, 0, };

cdcopen()
{
	scsi(6, request, data, sizeof data, NULL);
}

cdcstrategy(io, func)		/* do io */
	struct iob *io;
{
	register char *cdb;
	register int n;

	cdb = func == WRITE ? w : r;
	cdb[4] = io->i_cc + 0777 >> 9;
	n = io->i_bn;
	cdb[1] = n >> 16 & 0xff;
	cdb[2] = n >> 8 & 0xff;
	cdb[3] = n & 0xff;
	cdb[5] = 0;
	scsi(io->i_unit, cdb, io->i_ma, io->i_cc, NULL);
	return io->i_cc;
}
