/* introl.c: Introl routines to do scsi. */


struct	iopb {
	char	task_id;
	char	ad_ctl;
	char	int_lvl;
	char	vec;
	char	dt_burst;
	char	dt_break;
	char	vme_dp[4];
	char	am;
	char	tc[3];
	char	ad_status;
	char	scsi_status;
	char	targ_id;
	char	no_arb;		/* disable arbitration scheme */
	char	cdb[12];	/* SCSI command block */
	char	reserved2[2];
};

struct	host	{
	struct	iopb *ip;
	long	t_id;
};

struct	introl	{
	struct	host	host[4];
	char	filler[478];
	long	ad_status;
};

/* notice that we use the REAL address here. */

#define	INTROL	((short *) 0xffff0000)
#define	SCSI_ADP_STATUS	(*(unsigned short *) (0xffff0000 + 512))

#define	setp(a, b)	{(a)[0] = (b) >> 24 & 0xff; \
			 (a)[1] = (b) >> 16 & 0xff; \
			 (a)[2] = (b) >> 8  & 0xff; \
			 (a)[3] = (b) & 0xff;}
#define	setc(a, b)	{(a)[0] = (b) >> 16 & 0xff; \
			 (a)[1] = (b) >> 8 & 0xff; \
			 (a)[2] = (b) & 0xff;}


struct	iopb	iopb;

scsi(target, cdb, addr, count, func)	/* do scsi */
	char *cdb;
	char *addr;
	int (*func)();
{
	register char *cp;

	while ((SCSI_ADP_STATUS & 0x80) == 0)
		;
	bcopy(cdb, iopb.cdb, 12);
	iopb.task_id = 1;
	iopb.ad_ctl = 0xd0;		/* 16-bit  */
	iopb.int_lvl = 0;		/* status driven */
	iopb.vec = 0;			/* no vector used */
	iopb.dt_burst = 125;
	iopb.dt_break = 125;
	setp(iopb.vme_dp, (int)addr);	/* set the address */
	iopb.am = 0x3d;			/* ????? */
	setc(iopb.tc, count);		/* set the transfer count */
	iopb.targ_id = target;		/* set the target device */
	iopb.no_arb = 0;
	iopb.ad_status = 0xaa;		/* arb. number to check for */
	*INTROL = (int)&iopb >> 16 & 0xffff;
	*(INTROL + 1) = (int)&iopb & 0xffff;
	while ((iopb.ad_status & 0xff) == 0xaa)
		;
	return iopb.ad_status << 8 | iopb.scsi_status;
}


bcopy(f, t, n)		/* copy bytes around */
	register char *f, *t;
{
	register int r;

	r = n;
	while (r--)
		*t++ = *f++;
}
