/* format.c:  format a introl/omti disc drive. */
#define NULL	0

char	xxx[2048] = "Mot boot code will NOT load things smaller than 2 blocks";
main()
{
	char line[512];
	int lu;

	printf("format: about to format a disc drive.\n");
	printf("Enter the logical unit:");
	gets(line);
	lu = atoi(line);
	printf("that is %d\n", lu);
	printf("Last chance to quit...");
	gets(line);
	format(lu);
	for (;;);
}

atoi(s)		/* do my own ascii to int */
	char *s;
{
	register char *cp;
	register int n;

	cp = s;
	while (*cp == ' ')
		cp++;
	n = 0;
	while (*cp && *cp >= '0' && *cp <= '9') {
		n *= 10;
		n += *cp++ - '0';
	}
	return n;
}

char	assign[] = { 0xc2, 0, 0, 0, 0, 0 };
char	unit_ready[] = { 0, 0, 0, 0, 0, 0 };
char	plist[] = { 0, 0, 0, 6, 0x4, 0xc7, 0, 0, 16, 0};
char	ftrack[] = { 6, 0, 'C', 0, 1, 0 };
char	sense[] = { 3, 0, 0, 0, 0, 0 };
char	sense_bytes[4];

format(lu)		/* format that disc */
{
	int r;
	long lba;

	unit_ready[1] |= lu << 5;
	scsi(0, unit_ready, NULL, 0, NULL);
	assign[1] |= lu << 5;
	scsi(0, assign, plist, sizeof plist, NULL);
	for (lba = 0; lba < 135800; lba += 17) {
		printf("\r%d         ", lba);
		ftrack[0] = 6;		/* format */
		ftrack[1] = (lba >> 16) & 0xff | (lu & 3) << 5;
		ftrack[2] = (lba >> 8 ) & 0xff;
		ftrack[3] = lba & 0xff;
		ftrack[4] = 1;
		ftrack[5] = 0;
		r = scsi(0, ftrack, NULL, 0, NULL);
		if (r & 3)
			get_status(lba, r, lu);
		ftrack[0] = 5;		/* check track */
		r = scsi(0, ftrack, NULL, 0, NULL);
		if (r & 3)
			get_status(lba, r, lu);
	}
	printf("done\n");
}


get_status(lba, r, lu)
{
	printf("lba %d, status 0x%x\n", lba, r);
	sense[1] = lu << 5;
	scsi(0, sense, sense_bytes, 4, NULL);

	printf("sense bytes 0x%x, lun %d, lba %x\n",
		sense_bytes[0], 
		sense_bytes[1] >> 5,
		(sense_bytes[1] & 0x1f << 16) +
		(sense_bytes[2] << 8) +
		sense_bytes[3]);
}
