#include <stdio.h>
#include <nlist.h>
#include <sys/param.h>
#include <sys/map.h>

struct	map	xcoremap[CMAPSIZ];
struct	map	xswapmap[SMAPSIZ];

struct	nlist	nl[] = {
	{ "_coremap" },
	{ "_swapmap" },
	{ NULL }
};

#define	COREMAP	0
#define	SWAPMAP 1

char	*objname = "/unix";
char	*corename = "/dev/kmem";

main(argc, argv)
	int argc;
	char *argv[];
{
	register size, maxsize;
	register struct map *p;
	int count;
	int mfd;

	if (argc == 3) {
		objname = argv[1];
		corename = argv[2];
	}
	nlist(objname, nl);
	if ((mfd = open(corename, 0)) == -1) {
		perror(corename);
		exit(1);
	}
	if (nl[COREMAP].n_type == 0) {
		fprintf(stderr, "Can't find the coremap\n");
		exit(1);
	}
	if (nl[SWAPMAP].n_type == 0) {
		fprintf(stderr, "Can't find swapmap\n");
		exit(1);
	}
	lseek(mfd, nl[COREMAP].n_value & ~0xc0000000, 0);
	read(mfd, xcoremap, sizeof xcoremap);
	lseek(mfd, nl[SWAPMAP].n_value & ~ 0xc0000000, 0);
	read(mfd, xswapmap, sizeof xswapmap);
#ifdef notdef
	printf("%8s %8s\n", "SIZE", "ADDRESS");
#endif
	size = maxsize = count = 0;
	for (p = xcoremap; p < &xcoremap[CMAPSIZ]; p++) {
		if (p->m_size) {
			size += p->m_size;
			if (p->m_size > maxsize)
				maxsize = p->m_size;
#ifdef notdef
			printf("%8d %5x\n", p->m_size, p->m_addr);
#endif
			count++;
		}
	}
	size = ctob(dtoc(size));
	maxsize = ctob(dtoc(maxsize));
	printf("core:%7dK free, %7dK contiguous, ", size / 1024, maxsize / 1024);
	printf("%d/%d\n", count, CMAPSIZ);
	size = maxsize = count = 0;
	for (p = xswapmap; p < &xswapmap[SMAPSIZ]; p++) {
		if (p->m_size) {
			size += p->m_size;
			if (p->m_size > maxsize)
				maxsize = p->m_size;
#ifdef notdef
			printf("%8d %8x\n", p->m_size, p->m_addr);
#endif
			count++;
		}
	}
	size = ctob(dtoc(size));
	maxsize = ctob(dtoc(maxsize));
	printf("swap:%7dK free, %7dK contiguous, ", size / 1024, maxsize / 1024);
	printf("%d/%d\n", count, SMAPSIZ);
	exit(0);
}
