static char *RCSid = "$Header: aspseudo.c,v 1.1 86/02/28 15:09:49 root Exp $";

/*
 * $Log:	aspseudo.c,v $
 * Revision 1.1  86/02/28  15:09:49  root
 * Initial revision
 * 
 */

/* Copyright (c) 1980 Regents of the University of California */
static	char sccsid[] = "@(#)aspseudo.c 4.3 8/16/80";
#include <stdio.h>
#include "as.h"

extern q39_ea(), ea_r9(), r9_ea(), imm_ea(), imm(), r0_r9(), ea_ea6();
extern ea(), ead(), qb0_r9(), r0(), r0d(), disp8(), disp16();
extern r0_disp16(), /*disp(),*/ r9_r0(), r0_imm(), nop();
extern q40(), q39_r0(), r9_ea(), ea_imm();
extern movs_ea(), ea_movs(), c_r(), r_c();

/*	1st operand	2nd operand	opcode	generator	*/
/*	===========	===========	======	=========	*/

readonly struct insfmt ADDB_FMT[] = {
	{ IMM3&~IMM,	DATA&ALT,	0x5000,	q39_ea,	},
	{ DATAB,	DREG,		0xD000,	ea_r9,	},
	{ DREG,		ALT&MEM,	0xD100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0x0600,	imm_ea,	},
};

readonly struct insfmt ADDW_FMT[] = {
	{ IMM3&~IMM,	ALT&~AREG,	0x5040,	q39_ea,	},
	{ ALLW,		DREG,		0xD040,	ea_r9,	},
	{ DREG,		ALT&MEM,	0xD140,	r9_ea,	},
	{ ALLSW,	AREG,		0xD0C0,	ea_r9,	},
	{ IMMW,		DATA&ALT,	0x0640,	imm_ea,	},
};

readonly struct insfmt ADDL_FMT[] = {
	{ IMM3&~IMM,	ALT,		0x5080,	q39_ea,	},
	{ ALLL,		DREG,		0xD080,	ea_r9,	},
	{ DREG,		ALT&MEM,	0xD180,	r9_ea,	},
	{ ALLL,		AREG,		0xD1C0,	ea_r9,	},
	{ IMML,		DATA&ALT,	0x0680,	imm_ea,	},
};

readonly struct insfmt ANDB_FMT[] = {
	{ DATAB,	DREG,		0xC000,	ea_r9,	},
	{ DREG,		ALT&MEM,	0xC100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0x0200,	imm_ea,	},
	{ IMMB,		CC,		0x023C,	imm,	},
};

readonly struct insfmt ANDW_FMT[] = {
	{ DATAW,	DREG,		0xC040,	ea_r9,	},
	{ DREG,		ALT&MEM,	0xC140,	r9_ea,	},
	{ IMMW,		DATA&ALT,	0x0240,	imm_ea,	},
	{ IMMW,		SR,		0x027C,	imm,	},
};

readonly struct insfmt ANDL_FMT[] = {
	{ DATAL,	DREG,		0xC080,	ea_r9,	},
	{ DREG,		ALT&MEM,	0xC180,	r9_ea,	},
	{ IMML,		DATA&ALT,	0x0280,	imm_ea,	},
};

readonly struct insfmt CMPB_FMT[] = {
	{ ALLB,		DREG,		0xB000,	ea_r9,	},
	{ IMMB,		DATA&ALT,	0x0C00,	imm_ea,	},
	{ INC,		INC,		0xB108,	r0_r9,	},
};

readonly struct insfmt CMPW_FMT[] = {
	{ ALLW,		DREG,		0xB040,	ea_r9,	},
	{ ALLSW,	AREG,		0xB0C0,	ea_r9,	},
	{ IMMW,		DATA&ALT,	0x0C40,	imm_ea,	},
	{ INC,		INC,		0xB148,	r0_r9,	},
};

readonly struct insfmt CMPL_FMT[] = {
	{ ALLL,		DREG,		0xB080,	ea_r9,	},
	{ ALLL,		AREG,		0xB1C0,	ea_r9,	},
	{ IMML,		DATA&ALT,	0x0C80,	imm_ea,	},
	{ INC,		INC,		0xB188,	r0_r9,	},
};

readonly struct insfmt EORB_FMT[] = {
	{ DREG,		DATA&ALT,	0xB100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0x0A00,	imm_ea,	},
	{ IMMB,		CC,		0x0A3C, imm,	},
};

readonly struct insfmt EORW_FMT[] = {
	{ DREG,		DATA&ALT,	0xB140,	r9_ea,	},
	{ IMMW,		DATA&ALT,	0x0A40,	imm_ea,	},
	{ IMMW,		SR,		0x0A7C, imm,	},
};

readonly struct insfmt EORL_FMT[] = {
	{ DREG,		DATA&ALT,	0xB180,	r9_ea,	},
	{ IMML,		DATA&ALT,	0x0A80,	imm_ea,	},
};

readonly struct insfmt MOVB_FMT[] = {
	{ ALLB,		DATA&ALT,	0x1000,	ea_ea6,	},
};

readonly struct insfmt MOVW_FMT[] = {
	{ ALLW,		ALT&~AREG,	0x3000,	ea_ea6,	},
	{ ALLSW,	AREG,		0x3040,	ea_r9,	},
	{ DATAW,	CC,		0x44C0,	ea,	},
	{ CC,		DATA&ALT,	0x42C0,	ead,	},
	{ DATAW,	SR,		0x46C0,	ea,	},
	{ SR,		DATA&ALT,	0x40C0,	ead,	},
};

readonly struct insfmt MOVL_FMT[] = {
	{ IMMSB&~IMM,	DREG,		0x7000,	qb0_r9,	},
	{ IMMSW&~IMM,	AREG,		0x3040,	ea_r9,	},
	{ ALLL,		ALT&~AREG,	0x2000,	ea_ea6,	},
	{ ALLL,		AREG,		0x2040,	ea_r9,	},
	{ USP,		AREG,		0x4E68,	r0d,	},
	{ AREG,		USP,		0x4E60,	r0,	},
	{ USP|VB|SFC|DFC, DREG|AREG,	0x4E7A,	c_r,	},
	{ DREG|AREG,	USP|VB|SFC|DFC,	0x4E7B,	r_c,	},
};

readonly struct insfmt ORB_FMT[] = {
	{ DATAB,	DREG,		0x8000,	ea_r9,	},
	{ DREG,		ALT&MEM,	0x8100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0x0000,	imm_ea,	},
	{ IMMB,		CC,		0x003C, imm,	},
};

readonly struct insfmt ORW_FMT[] = {
	{ DATAW,	DREG,		0x8040,	ea_r9,	},
	{ DREG,		ALT&MEM,	0x8140,	r9_ea,	},
	{ IMMW,		DATA&ALT,	0x0040,	imm_ea,	},
	{ IMMW,		SR,		0x007C, imm,	},
};

readonly struct insfmt ORL_FMT[] = {
	{ DATAL,	DREG,		0x8080,	ea_r9,	},
	{ DREG,		ALT&MEM,	0x8180,	r9_ea,	},
	{ IMML,		DATA&ALT,	0x0080,	imm_ea,	},
};

readonly struct insfmt SUBB_FMT[] = {
	{ IMM3&~IMM,	DATA&ALT,	0x5100,	q39_ea,	},
	{ DATAB,	DREG,		0x9000,	ea_r9,	},
	{ DREG,		ALT&MEM,	0x9100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0x0400,	imm_ea,	},
};

readonly struct insfmt SUBW_FMT[] = {
	{ IMM3&~IMM,	ALT&~AREG,	0x5140,	q39_ea,	},
	{ ALLW,		DREG,		0x9040,	ea_r9,	},
	{ DREG,		ALT&MEM,	0x9140,	r9_ea,	},
	{ ALLSW,	AREG,		0x90C0,	ea_r9,	},
	{ IMMW,		DATA&ALT,	0x0440,	imm_ea,	},
};

readonly struct insfmt SUBL_FMT[] = {
	{ IMM3&~IMM,	ALT,		0x5180,	q39_ea,	},
	{ ALLL,		DREG,		0x9080,	ea_r9,	},
	{ DREG,		ALT&MEM,	0x9180,	r9_ea,	},
	{ ALLL,		AREG,		0x91C0,	ea_r9,	},
	{ IMML,		DATA&ALT,	0x0480,	imm_ea,	},
};

readonly struct insfmt CLRB_FMT[] = {
	{ DATA&ALT,	0,		0x4200,	ea,	},
};

readonly struct insfmt CLRW_FMT[] = {
	{ DATA&ALT,	0,		0x4240,	ea,	},
};

readonly struct insfmt CLRL_FMT[] = {
	{ DATA&ALT,	0,		0x4280,	ea,	},
};

readonly struct insfmt NBCD_FMT[] = {
	{ DATA&ALT,	0,		0x4800,	ea,	},
};

readonly struct insfmt NEGB_FMT[] = {
	{ DATA&ALT,	0,		0x4400,	ea,	},
};

readonly struct insfmt NEGW_FMT[] = {
	{ DATA&ALT,	0,		0x4440,	ea,	},
};

readonly struct insfmt NEGL_FMT[] = {
	{ DATA&ALT,	0,		0x4480,	ea,	},
};

readonly struct insfmt NEGXB_FMT[] = {
	{ DATA&ALT,	0,		0x4000,	ea,	},
};

readonly struct insfmt NEGXW_FMT[] = {
	{ DATA&ALT,	0,		0x4040,	ea,	},
};

readonly struct insfmt NEGXL_FMT[] = {
	{ DATA&ALT,	0,		0x4080,	ea,	},
};

readonly struct insfmt NOTB_FMT[] = {
	{ DATA&ALT,	0,		0x4600,	ea,	},
};

readonly struct insfmt NOTW_FMT[] = {
	{ DATA&ALT,	0,		0x4640,	ea,	},
};

readonly struct insfmt NOTL_FMT[] = {
	{ DATA&ALT,	0,		0x4680,	ea,	},
};

readonly struct insfmt ST_FMT[] = {
	{ DATA&ALT,	0,		0x50C0,	ea,	},
};

readonly struct insfmt SF_FMT[] = {
	{ DATA&ALT,	0,		0x51C0,	ea,	},
};

readonly struct insfmt SHI_FMT[] = {
	{ DATA&ALT,	0,		0x52C0,	ea,	},
};

readonly struct insfmt SLS_FMT[] = {
	{ DATA&ALT,	0,		0x53C0,	ea,	},
};

readonly struct insfmt SCC_FMT[] = {
	{ DATA&ALT,	0,		0x54C0,	ea,	},
};

readonly struct insfmt SCS_FMT[] = {
	{ DATA&ALT,	0,		0x55C0,	ea,	},
};

readonly struct insfmt SNE_FMT[] = {
	{ DATA&ALT,	0,		0x56C0,	ea,	},
};

readonly struct insfmt SEQ_FMT[] = {
	{ DATA&ALT,	0,		0x57C0,	ea,	},
};

readonly struct insfmt SVC_FMT[] = {
	{ DATA&ALT,	0,		0x58C0,	ea,	},
};

readonly struct insfmt SVS_FMT[] = {
	{ DATA&ALT,	0,		0x59C0,	ea,	},
};

readonly struct insfmt SPL_FMT[] = {
	{ DATA&ALT,	0,		0x5AC0,	ea,	},
};

readonly struct insfmt SMI_FMT[] = {
	{ DATA&ALT,	0,		0x5BC0,	ea,	},
};

readonly struct insfmt SGE_FMT[] = {
	{ DATA&ALT,	0,		0x5CC0,	ea,	},
};

readonly struct insfmt SLT_FMT[] = {
	{ DATA&ALT,	0,		0x5DC0,	ea,	},
};

readonly struct insfmt SGT_FMT[] = {
	{ DATA&ALT,	0,		0x5EC0,	ea,	},
};

readonly struct insfmt SLE_FMT[] = {
	{ DATA&ALT,	0,		0x5FC0,	ea,	},
};

readonly struct insfmt TAS_FMT[] = {
	{ DATA&ALT,	0,		0x4AC0,	ea,	},
};

readonly struct insfmt TSTB_FMT[] = {
	{ DATA&ALT,	0,		0x4A00, ea,	},
};

readonly struct insfmt TSTW_FMT[] = {
	{ DATA&ALT,	0,		0x4A40, ea,	},
};

readonly struct insfmt TSTL_FMT[] = {
	{ DATA&ALT,	0,		0x4A80, ea,	},
};

readonly struct insfmt BRA_FMT[] = {
	{ ABS,		0,		0x6000,	disp16,	},
};

readonly struct insfmt BSR_FMT[] = {
	{ ABS,		0,		0x6100,	disp16,	},
};

readonly struct insfmt BHI_FMT[] = {
	{ ABS,		0,		0x6200,	disp16,	},
};

readonly struct insfmt BLS_FMT[] = {
	{ ABS,		0,		0x6300,	disp16,	},
};

readonly struct insfmt BCC_FMT[] = {
	{ ABS,		0,		0x6400,	disp16,	},
};

readonly struct insfmt BCS_FMT[] = {
	{ ABS,		0,		0x6500,	disp16,	},
};

readonly struct insfmt BNE_FMT[] = {
	{ ABS,		0,		0x6600,	disp16,	},
};

readonly struct insfmt BEQ_FMT[] = {
	{ ABS,		0,		0x6700,	disp16,	},
};

readonly struct insfmt BVC_FMT[] = {
	{ ABS,		0,		0x6800,	disp16,	},
};

readonly struct insfmt BVS_FMT[] = {
	{ ABS,		0,		0x6900,	disp16,	},
};

readonly struct insfmt BPL_FMT[] = {
	{ ABS,		0,		0x6A00,	disp16,	},
};

readonly struct insfmt BMI_FMT[] = {
	{ ABS,		0,		0x6B00,	disp16,	},
};

readonly struct insfmt BGE_FMT[] = {
	{ ABS,		0,		0x6C00,	disp16,	},
};

readonly struct insfmt BLT_FMT[] = {
	{ ABS,		0,		0x6D00,	disp16,	},
};

readonly struct insfmt BGT_FMT[] = {
	{ ABS,		0,		0x6E00,	disp16,	},
};

readonly struct insfmt BLE_FMT[] = {
	{ ABS,		0,		0x6F00,	disp16,	},
};

readonly struct insfmt BRAS_FMT[] = {
	{ ABS,		0,		0x6000,	disp8,	},
};

readonly struct insfmt BSRS_FMT[] = {
	{ ABS,		0,		0x6100,	disp8,	},
};

readonly struct insfmt BHIS_FMT[] = {
	{ ABS,		0,		0x6200,	disp8,	},
};

readonly struct insfmt BLSS_FMT[] = {
	{ ABS,		0,		0x6300,	disp8,	},
};

readonly struct insfmt BCCS_FMT[] = {
	{ ABS,		0,		0x6400,	disp8,	},
};

readonly struct insfmt BCSS_FMT[] = {
	{ ABS,		0,		0x6500,	disp8,	},
};

readonly struct insfmt BNES_FMT[] = {
	{ ABS,		0,		0x6600,	disp8,	},
};

readonly struct insfmt BEQS_FMT[] = {
	{ ABS,		0,		0x6700,	disp8,	},
};

readonly struct insfmt BVCS_FMT[] = {
	{ ABS,		0,		0x6800,	disp8,	},
};

readonly struct insfmt BVSS_FMT[] = {
	{ ABS,		0,		0x6900,	disp8,	},
};

readonly struct insfmt BPLS_FMT[] = {
	{ ABS,		0,		0x6A00,	disp8,	},
};

readonly struct insfmt BMIS_FMT[] = {
	{ ABS,		0,		0x6B00,	disp8,	},
};

readonly struct insfmt BGES_FMT[] = {
	{ ABS,		0,		0x6C00,	disp8,	},
};

readonly struct insfmt BLTS_FMT[] = {
	{ ABS,		0,		0x6D00,	disp8,	},
};

readonly struct insfmt BGTS_FMT[] = {
	{ ABS,		0,		0x6E00,	disp8,	},
};

readonly struct insfmt BLES_FMT[] = {
	{ ABS,		0,		0x6F00,	disp8,	},
};

readonly struct insfmt DBT_FMT[] = {
	{ DREG,		ABS,		0x50C8,	r0_disp16, },
};

readonly struct insfmt DBF_FMT[] = {
	{ DREG,		ABS,		0x51C8,	r0_disp16, },
};

readonly struct insfmt DBHI_FMT[] = {
	{ DREG,		ABS,		0x52C8,	r0_disp16, },
};

readonly struct insfmt DBLS_FMT[] = {
	{ DREG,		ABS,		0x53C8,	r0_disp16, },
};

readonly struct insfmt DBCC_FMT[] = {
	{ DREG,		ABS,		0x54C8,	r0_disp16, },
};

readonly struct insfmt DBCS_FMT[] = {
	{ DREG,		ABS,		0x55C8,	r0_disp16, },
};

readonly struct insfmt DBNE_FMT[] = {
	{ DREG,		ABS,		0x56C8,	r0_disp16, },
};

readonly struct insfmt DBEQ_FMT[] = {
	{ DREG,		ABS,		0x57C8,	r0_disp16, },
};

readonly struct insfmt DBVC_FMT[] = {
	{ DREG,		ABS,		0x58C8,	r0_disp16, },
};

readonly struct insfmt DBVS_FMT[] = {
	{ DREG,		ABS,		0x59C8,	r0_disp16, },
};

readonly struct insfmt DBPL_FMT[] = {
	{ DREG,		ABS,		0x5AC8,	r0_disp16, },
};

readonly struct insfmt DBMI_FMT[] = {
	{ DREG,		ABS,		0x5BC8,	r0_disp16, },
};

readonly struct insfmt DBGE_FMT[] = {
	{ DREG,		ABS,		0x5CC8,	r0_disp16, },
};

readonly struct insfmt DBLT_FMT[] = {
	{ DREG,		ABS,		0x5DC8,	r0_disp16, },
};

readonly struct insfmt DBGT_FMT[] = {
	{ DREG,		ABS,		0x5EC8,	r0_disp16, },
};

readonly struct insfmt DBLE_FMT[] = {
	{ DREG,		ABS,		0x5FC8,	r0_disp16, },
};

/* readonly struct insfmt JRA_FMT[] = {
/* 	{ ABS,		0,		0x6000,	disp,	},
/* };
/* 
/* readonly struct insfmt JBSR_FMT[] = {
/* 	{ ABS,		0,		0x6100,	disp,	},
/* };
/* 
/* readonly struct insfmt JHI_FMT[] = {
/* 	{ ABS,		0,		0x6200,	disp,	},
/* };
/* 
/* readonly struct insfmt JLS_FMT[] = {
/* 	{ ABS,		0,		0x6300,	disp,	},
/* };
/* 
/* readonly struct insfmt JCC_FMT[] = {
/* 	{ ABS,		0,		0x6400,	disp,	},
/* };
/* 
/* readonly struct insfmt JCS_FMT[] = {
/* 	{ ABS,		0,		0x6500,	disp,	},
/* };
/* 
/* readonly struct insfmt JNE_FMT[] = {
/* 	{ ABS,		0,		0x6600,	disp,	},
/* };
/* 
/* readonly struct insfmt JEQ_FMT[] = {
/* 	{ ABS,		0,		0x6700,	disp,	},
/* };
/* 
/* readonly struct insfmt JVC_FMT[] = {
/* 	{ ABS,		0,		0x6800,	disp,	},
/* };
/* 
/* readonly struct insfmt JVS_FMT[] = {
/* 	{ ABS,		0,		0x6900,	disp,	},
/* };
/* 
/* readonly struct insfmt JPL_FMT[] = {
/* 	{ ABS,		0,		0x6A00,	disp,	},
/* };
/* 
/* readonly struct insfmt JMI_FMT[] = {
/* 	{ ABS,		0,		0x6B00,	disp,	},
/* };
/* 
/* readonly struct insfmt JGE_FMT[] = {
/* 	{ ABS,		0,		0x6C00,	disp,	},
/* };
/* 
/* readonly struct insfmt JLT_FMT[] = {
/* 	{ ABS,		0,		0x6D00,	disp,	},
/* };
/* 
/* readonly struct insfmt JGT_FMT[] = {
/* 	{ ABS,		0,		0x6E00,	disp,	},
/* };
/* 
/* readonly struct insfmt JLE_FMT[] = {
/* 	{ ABS,		0,		0x6F00,	disp,	},
/* };
/* */

readonly struct insfmt ASLB_FMT[] = {
	{ DREG,		DREG,		0xE120,	r9_r0,	},
	{ IMM3,		DREG,		0xE100,	q39_r0,	},
};

readonly struct insfmt ASLW_FMT[] = {
	{ DREG,		DREG,		0xE160,	r9_r0,	},
	{ IMM3,		DREG,		0xE140,	q39_r0,	},
	{ IMM0,		MEM&ALT,	0xE1C0,	ead,	},
};

readonly struct insfmt ASLL_FMT[] = {
	{ DREG,		DREG,		0xE1A0,	r9_r0,	},
	{ IMM3,		DREG,		0xE180,	q39_r0,	},
};

readonly struct insfmt ASRB_FMT[] = {
	{ DREG,		DREG,		0xE020,	r9_r0,	},
	{ IMM3,		DREG,		0xE000,	q39_r0,	},
};

readonly struct insfmt ASRW_FMT[] = {
	{ DREG,		DREG,		0xE060,	r9_r0,	},
	{ IMM3,		DREG,		0xE040,	q39_r0,	},
	{ IMM0,		MEM&ALT,	0xE0C0,	ead,	},
};

readonly struct insfmt ASRL_FMT[] = {
	{ DREG,		DREG,		0xE0A0,	r9_r0,	},
	{ IMM3,		DREG,		0xE080,	q39_r0,	},
};

readonly struct insfmt LSLB_FMT[] = {
	{ DREG,		DREG,		0xE128,	r9_r0,	},
	{ IMM3,		DREG,		0xE108,	q39_r0,	},
};

readonly struct insfmt LSLW_FMT[] = {
	{ DREG,		DREG,		0xE168,	r9_r0,	},
	{ IMM3,		DREG,		0xE148,	q39_r0,	},
	{ IMM0,		MEM&ALT,	0xE3C0,	ead,	},
};

readonly struct insfmt LSLL_FMT[] = {
	{ DREG,		DREG,		0xE1A8,	r9_r0,	},
	{ IMM3,		DREG,		0xE188,	q39_r0,	},
};

readonly struct insfmt LSRB_FMT[] = {
	{ DREG,		DREG,		0xE028,	r9_r0,	},
	{ IMM3,		DREG,		0xE008,	q39_r0,	},
};

readonly struct insfmt LSRW_FMT[] = {
	{ DREG,		DREG,		0xE068,	r9_r0,	},
	{ IMM3,		DREG,		0xE048,	q39_r0,	},
	{ IMM0,		MEM&ALT,	0xE2C0,	ead,	},
};

readonly struct insfmt LSRL_FMT[] = {
	{ DREG,		DREG,		0xE0A8,	r9_r0,	},
	{ IMM3,		DREG,		0xE088,	q39_r0,	},
};

readonly struct insfmt ROLB_FMT[] = {
	{ DREG,		DREG,		0xE138,	r9_r0,	},
	{ IMM3,		DREG,		0xE118,	q39_r0,	},
};

readonly struct insfmt ROLW_FMT[] = {
	{ DREG,		DREG,		0xE178,	r9_r0,	},
	{ IMM3,		DREG,		0xE158,	q39_r0,	},
	{ IMM0,		MEM&ALT,	0xE7C0,	ead,	},
};

readonly struct insfmt ROLL_FMT[] = {
	{ DREG,		DREG,		0xE1B8,	r9_r0,	},
	{ IMM3,		DREG,		0xE198,	q39_r0,	},
};

readonly struct insfmt RORB_FMT[] = {
	{ DREG,		DREG,		0xE038,	r9_r0,	},
	{ IMM3,		DREG,		0xE018,	q39_r0,	},
};

readonly struct insfmt RORW_FMT[] = {
	{ DREG,		DREG,		0xE078,	r9_r0,	},
	{ IMM3,		DREG,		0xE058,	q39_r0,	},
	{ IMM0,		MEM&ALT,	0xE6C0,	ead,	},
};

readonly struct insfmt RORL_FMT[] = {
	{ DREG,		DREG,		0xE0B8,	r9_r0,	},
	{ IMM3,		DREG,		0xE098,	q39_r0,	},
};

readonly struct insfmt ROXLB_FMT[] = {
	{ DREG,		DREG,		0xE130,	r9_r0,	},
	{ IMM3,		DREG,		0xE110,	q39_r0,	},
};

readonly struct insfmt ROXLW_FMT[] = {
	{ DREG,		DREG,		0xE170,	r9_r0,	},
	{ IMM3,		DREG,		0xE150,	q39_r0,	},
	{ IMM0,		MEM&ALT,	0xE5C0,	ead,	},
};

readonly struct insfmt ROXLL_FMT[] = {
	{ DREG,		DREG,		0xE1B0,	r9_r0,	},
	{ IMM3,		DREG,		0xE190,	q39_r0,	},
};

readonly struct insfmt ROXRB_FMT[] = {
	{ DREG,		DREG,		0xE030,	r9_r0,	},
	{ IMM3,		DREG,		0xE010,	q39_r0,	},
};

readonly struct insfmt ROXRW_FMT[] = {
	{ DREG,		DREG,		0xE070,	r9_r0,	},
	{ IMM3,		DREG,		0xE050,	q39_r0,	},
	{ IMM0,		MEM&ALT,	0xE4C0,	ead,	},
};

readonly struct insfmt ROXRL_FMT[] = {
	{ DREG,		DREG,		0xE0B0,	r9_r0,	},
	{ IMM3,		DREG,		0xE090,	q39_r0,	},
};

readonly struct insfmt ABCD_FMT[] = {
	{ DREG,		DREG,		0xC100,	r0_r9,	},
	{ DEC,		DEC,		0xC108,	r0_r9,	},
};

readonly struct insfmt ADDQB_FMT[] = {
	{ IMM3,		DATA&ALT,	0x5000,	q39_ea,	},
};

readonly struct insfmt ADDQW_FMT[] = {
	{ IMM3,		ALT,		0x5040,	q39_ea,	},
};

readonly struct insfmt ADDQL_FMT[] = {
	{ IMM3,		ALT,		0x5080,	q39_ea,	},
};

readonly struct insfmt ADDXB_FMT[] = {
	{ DREG,		DREG,		0xD100,	r0_r9,	},
	{ DEC,		DEC,		0xD108,	r0_r9,	},
};

readonly struct insfmt ADDXW_FMT[] = {
	{ DREG,		DREG,		0xD140,	r0_r9,	},
	{ DEC,		DEC,		0xD148,	r0_r9,	},
};

readonly struct insfmt ADDXL_FMT[] = {
	{ DREG,		DREG,		0xD180,	r0_r9,	},
	{ DEC,		DEC,		0xD188,	r0_r9,	},
};

readonly struct insfmt BTST_FMT[] = {
	{ DREG,		DATA&~IMM,	0x0100,	r9_ea,	},
	{ IMB5,		DREG,		0x0800,	imm_ea,	},
	{ IMB3,		MEM&~IMM,	0x0800,	imm_ea,	},
};

readonly struct insfmt BCHG_FMT[] = {
	{ DREG,		DATA&ALT,	0x0140,	r9_ea,	},
	{ IMB5,		DREG,		0x0840,	imm_ea,	},
	{ IMB3,		MEM&ALT,	0x0840,	imm_ea,	},
};

readonly struct insfmt BCLR_FMT[] = {
	{ DREG,		DATA&ALT,	0x0180,	r9_ea,	},
	{ IMB5,		DREG,		0x0880,	imm_ea,	},
	{ IMB3,		MEM&ALT,	0x0880,	imm_ea,	},
};

readonly struct insfmt BSET_FMT[] = {
	{ DREG,		DATA&ALT,	0x01C0,	r9_ea,	},
	{ IMB5,		DREG,		0x08C0,	imm_ea,	},
	{ IMB3,		MEM&ALT,	0x08C0,	imm_ea,	},
};

readonly struct insfmt CMPMB_FMT[] = {
	{ INC,		INC,		0xB108,	r0_r9,	},
};

readonly struct insfmt CMPMW_FMT[] = {
	{ INC,		INC,		0xB148,	r0_r9,	},
};

readonly struct insfmt CMPML_FMT[] = {
	{ INC,		INC,		0xB188,	r0_r9,	},
};

readonly struct insfmt CHK_FMT[] = {
	{ DATAW,	DREG,		0x4180,	ea_r9,	},
};

readonly struct insfmt DIVS_FMT[] = {
	{ DATAW,	DREG,		0x81C0,	ea_r9,	},
};

readonly struct insfmt DIVU_FMT[] = {
	{ DATAW,	DREG,		0x80C0,	ea_r9,	},
};

readonly struct insfmt EXG_FMT[] = {
	{ DREG,		DREG,		0xC140,	r0_r9,	},
	{ AREG,		AREG,		0xC148,	r0_r9,	},
	{ AREG,		DREG,		0xC188,	r0_r9,	},
	{ DREG,		AREG,		0xC188,	r9_r0,	},
};

readonly struct insfmt EXTW_FMT[] = {
	{ DREG,		0,		0x4880,	r0,	},
};

readonly struct insfmt EXTL_FMT[] = {
	{ DREG,		0,		0x48C0,	r0,	},
};

readonly struct insfmt JMP_FMT[] = {
	{ CONT,		0,		0x4EC0,	ea,	},
};

readonly struct insfmt JSR_FMT[] = {
	{ CONT,		0,		0x4E80,	ea,	},
};

readonly struct insfmt LEA_FMT[] = {
	{ CONT,		AREG,		0x41C0,	ea_r9,	},
};

readonly struct insfmt LINK_FMT[] = {
	{ AREG,		IMMW,		0x4E50,	r0_imm,	},
};

readonly struct insfmt MOVMW_FMT[] = {
	{ IMMW,		(CONT&ALT)|DEC,	0x4880,	imm_ea,	},
	{ CONT|INC,	IMMW,		0x4C80,	ea_imm,	},
};

readonly struct insfmt MOVML_FMT[] = {
	{ IMMW,		(CONT&ALT)|DEC,	0x48C0,	imm_ea,	},
	{ CONT|INC,	IMMW,		0x4CC0,	ea_imm,	},
};

readonly struct insfmt MOVPW_FMT[] = {
	{ DREG,		DISP,		0x0188,	r9_r0,	},
	{ DISP,		DREG,		0x0108,	r0_r9,	},
};

readonly struct insfmt MOVPL_FMT[] = {
	{ DREG,		DISP,		0x01C8,	r9_r0,	},
	{ DISP,		DREG,		0x0148,	r0_r9,	},
};

readonly struct insfmt MOVQ_FMT[] = {
	{ IMMB,		DREG,		0x7000,	qb0_r9,	},
};

readonly struct insfmt MULS_FMT[] = {
	{ DATAW,	DREG,		0xC1C0,	ea_r9,	},
};

readonly struct insfmt MULU_FMT[] = {
	{ DATAW,	DREG,		0xC0C0,	ea_r9,	},
};

readonly struct insfmt NOP_FMT[] = {
	{ 0,		0,		0x4E71,	nop,	},
};

readonly struct insfmt PEA_FMT[] = {
	{ CONT,		0,		0x4840,	ea,	},
};

readonly struct insfmt RESET_FMT[] = {
	{ 0,		0,		0x4E70,	nop,	},
};

readonly struct insfmt RTE_FMT[] = {
	{ 0,		0,		0x4E73,	nop,	},
};

readonly struct insfmt RTD_FMT[] = {
	{ IMMW,		0,		0x4E74,	imm,	},
};

readonly struct insfmt RTS_FMT[] = {
	{ 0,		0,		0x4E75,	nop,	},
};

readonly struct insfmt RTR_FMT[] = {
	{ 0,		0,		0x4E77,	nop,	},
};

readonly struct insfmt SBCD_FMT[] = {
	{ DREG,		DREG,		0x8100,	r0_r9,	},
	{ DEC,		DEC,		0x8108,	r0_r9,	},
};

readonly struct insfmt STOP_FMT[] = {
	{ IMMW,		0,		0x4E72,	imm,	},
};

readonly struct insfmt SUBQB_FMT[] = {
	{ IMM3,		DATA&ALT,	0x5100,	q39_ea,	},
};

readonly struct insfmt SUBQW_FMT[] = {
	{ IMM3,		ALT,		0x5140,	q39_ea,	},
};

readonly struct insfmt SUBQL_FMT[] = {
	{ IMM3,		ALT,		0x5180,	q39_ea,	},
};

readonly struct insfmt SUBXB_FMT[] = {
	{ DREG,		DREG,		0x9100,	r0_r9,	},
	{ DEC,		DEC,		0x9108,	r0_r9,	},
};

readonly struct insfmt SUBXW_FMT[] = {
	{ DREG,		DREG,		0x9140,	r0_r9,	},
	{ DEC,		DEC,		0x9148,	r0_r9,	},
};

readonly struct insfmt SUBXL_FMT[] = {
	{ DREG,		DREG,		0x9180,	r0_r9,	},
	{ DEC,		DEC,		0x9188,	r0_r9,	},
};

readonly struct insfmt SWAP_FMT[] = {
	{ DREG,		0,		0x4840,	r0,	},
};

readonly struct insfmt TRAP_FMT[] = {
	{ IMM4,		0,		0x4E40,	q40,	},
};

readonly struct insfmt TRAPV_FMT[] = {
	{ 0,		0,		0x4E76,	nop,	},
};

readonly struct insfmt UNLK_FMT[] = {
	{ AREG,		0,		0x4E58,	r0,	},
};

readonly struct insfmt MOVSB_FMT[] = {
	{ DREG|AREG,	ALT&MEM,	0x0E00,	movs_ea,	},
	{ ALT&MEM,	DREG|AREG,	0x0E00,	ea_movs,	},
};

readonly struct insfmt MOVSW_FMT[] = {
	{ DREG|AREG,	ALT&MEM,	0x0E40,	movs_ea,	},
	{ ALT&MEM,	DREG|AREG,	0x0E40,	ea_movs,	},
};

readonly struct insfmt MOVSL_FMT[] = {
	{ DREG|AREG,	ALT&MEM,	0x0E80,	movs_ea,	},
	{ ALT&MEM,	DREG|AREG,	0x0E80,	ea_movs,	},
};


#define	OP(name, opcode, nargs, fmt, tag) \
	{ \
		name, opcode, nargs, ((sizeof fmt)/(sizeof fmt[0])), fmt, tag \
	}
#define	PSEUDO(name, type, tag) \
	{ \
		name, type, 0, 0, 0, \
		tag \
	}

readonly struct Instab instab[] = {
PSEUDO(".space",	0,	ISPACE),
PSEUDO(".fill",		0,	IFILL),
PSEUDO(".byte",		0,	IBYTE),
PSEUDO(".word",		0,	IWORD),
PSEUDO(".long",		0,	ILONG),
PSEUDO(".int",		0,	IINT),
PSEUDO(".quad",		0,	IQUAD),
PSEUDO(".data",		0,	IDATA),
PSEUDO(".globl",	0,	IGLOBAL),
PSEUDO(".set",		0,	ISET),
PSEUDO(".text",		0,	ITEXT),
PSEUDO(".comm",		0,	ICOMM),
PSEUDO(".lcomm",	0,	ILCOMM),
PSEUDO(".lsym",		0,	ILSYM),
PSEUDO(".align",	0,	IALIGN),
PSEUDO(".float",	0,	IFLOAT),
PSEUDO(".double",	0,	IDOUBLE),
PSEUDO(".org",		0,	IORG),
PSEUDO(".stab",		0,	ISTAB),
PSEUDO(".stabs",	0,	ISTABSTR),
PSEUDO(".stabn",	0,	ISTABNONE),
PSEUDO(".stabd",	0,	ISTABDOT),
PSEUDO(".ascii",	0,	IASCII),
PSEUDO(".asciz",	0,	IASCIZ),
PSEUDO(".file",		0,	IFILE),
PSEUDO(".line",		0,	ILINENO),
PSEUDO(".ABORT",	0,	IABORT),

PSEUDO("d0",		0,	REG),
PSEUDO("d1",		1,	REG),
PSEUDO("d2",		2,	REG),
PSEUDO("d3",		3,	REG),
PSEUDO("d4",		4,	REG),
PSEUDO("d5",		5,	REG),
PSEUDO("d6",		6,	REG),
PSEUDO("d7",		7,	REG),
PSEUDO("a0",		8,	REG),
PSEUDO("a1",		9,	REG),
PSEUDO("a2",		10,	REG),
PSEUDO("a3",		11,	REG),
PSEUDO("a4",		12,	REG),
PSEUDO("a5",		13,	REG),
PSEUDO("a6",		14,	REG),
PSEUDO("a7",		15,	REG),
PSEUDO("fp",		14,	REG),
PSEUDO("sp",		15,	REG),
PSEUDO("pc",		16,	REG),
PSEUDO("cc",		17,	REG),
PSEUDO("sr",		18,	REG),
PSEUDO("usp",		19,	REG),
PSEUDO("vb",		20,	REG),
PSEUDO("sfc",		21,	REG),
PSEUDO("dfc",		22,	REG),

#include "instrs"

0
};

#ifdef	DEBUG
readonly char *regstrs[] = {
	"d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7",
	"a0", "a1", "a2", "a3", "a4", "a5", "a6", "sp",
	"pc", "cc", "sr", "usp", "vb", "sfc", "dfc"
};

readonly struct Tok_Desc{
	int		tok_which;
	char		*tok_name;
} tok_desc[] = {
	FIRSTTOKEN,	"firsttoken",	/* 0 */
	ISPACE,		"ispace", 	/* 1 */
	IBYTE,		"ibyte", 	/* 2 */
	IWORD,		"iword", 	/* 3 */
	IINT,		"iint", 	/* 4 */
	ILONG,		"ilong", 	/* 5 */
	IDATA,		"idata", 	/* 6 */
	IGLOBAL,	"iglobal", 	/* 7 */
	ISET,		"iset", 	/* 8 */
	ITEXT,		"itext", 	/* 9 */
	ICOMM,		"icomm", 	/* 10 */
	ILCOMM,		"ilcomm", 	/* 11 */
	IFLOAT,		"ifloat", 	/* 12 */
	IDOUBLE,	"idouble", 	/* 13 */
	IORG,		"iorg", 	/* 14 */
	IASCII,		"iascii", 	/* 15 */
	IASCIZ,		"iasciz", 	/* 16 */
	ILSYM,		"ilsym", 	/* 17 */
	IFILE,		"ifile", 	/* 18 */
	ILINENO,	"ilineno", 	/* 19 */
	IABORT,		"iabort", 	/* 20 */
	ISTAB,		"istab", 	/* 23 */
	ISTABSTR,	"istabstr", 	/* 24 */
	ISTABNONE,	"istabnone", 	/* 25 */
	ISTABDOT,	"istabdot", 	/* 26 */
	IJXXX,		"ijxxx", 	/* 27 */
	IALIGN,		"ialign", 	/* 28 */
	INST0,		"inst0", 	/* 29 */
	INSTn,		"instn", 	/* 30 */
	BFINT,		"bfint",	/* 31 */
	PARSEEOF,	"parseeof",	/* 32 */
	ILINESKIP,	"ilineskip",	/* 33 */
	VOID,		"void",		/* 34 */
	SKIP,		"skip",		/* 35 */
	INT,		"int",		/* 36 */
	FLTNUM,		"fltnum",	/* 37 */
	NAME,		"name",		/* 38 */
	STRING,		"string",	/* 39 */
	QUAD,		"quad",		/* 40 */
	SIZESPEC,	"sizespec", 	/* 41 */
	REG,		"reg",		/* 42 */
	MUL,		"mul",		/* 43 */
	LITOP,		"litop",	/* 44 */
	LP,		"lp",		/* 45 */
	IND,		"ind",		/* 46 */
	NEEDSBUF,	"needsbuf",	/* 48 */	
	REGOP,		"regop",	/* 49 */
	NL,		"nl",		/* 50 */
	SCANEOF,	"scaneof",	/* 51 */
	BADCHAR,	"badchar",	/* 52 */
	SP,		"sp",		/* 53 */
	ALPH,		"alph",		/* 54 */
	DIG,		"dig",		/* 55 */
	SQ,		"sq",		/* 56 */
	DQ,		"dq",		/* 57 */
	BUCK,		"buck",		/* 58 */
	LSH,		"lsh",		/* 59 */
	RSH,		"rsh",		/* 60 */
	MINUS,		"minus",	/* 61 */
	SIZEQUOTE,	"sizequote",	/* 62 */
	XOR,		"xor",		/* 64 */
	DIV,		"div",		/* 65 */
	SEMI,		"semi",		/* 66 */
	COLON,		"colon",	/* 67 */
	PLUS,		"plus",		/* 68 */
	IOR,		"ior",		/* 69 */ 
	AND,		"and",		/* 70 */
	TILDE,		"tilde",	/* 71 */
	ORNOT,		"ornot",	/* 72 */
	CM,		"cm",		/* 73 */
	LB,		"lb",		/* 74 */
	RB,		"rb",		/* 75 */
	RP,		"rp",		/* 76 */
	ASSIGN,		"assign",	/* 77 */
	LASTTOKEN,	"lasttoken",	/* 80 */
	0,		(char *)0
};
#endif DEBUG
