/*****************************************************************************
 * notice.c: Demonstrate the Notice widget.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/ControlAre.h>
#include <Xol/OblongButt.h>
#include <Xol/Notice.h>

main(argc, argv)
  int   argc;
  char *argv[];
{
  Widget  toplevel, con, button, notice; 
  Widget  n_controlarea, n_textarea, confirm, cancel;
  void    button_callback(), confirm_callback();
  Arg     wargs[3];
  int     n;

  toplevel = OlInitialize(argv[0], "Notice", NULL, 0, &argc, argv);
  con = XtCreateManagedWidget("control", controlAreaWidgetClass, 
                              toplevel, NULL, 0);
  /*
   * Create the OblongButton widget.
   */
  button = XtCreateManagedWidget("Print", oblongButtonWidgetClass,
                               con, NULL, 0);
  /*
   * Create the notice widget
   * The notice widget emanates from the button widget.
   */
  n = 0;
  XtSetArg(wargs[n], XtNemanateWidget, button); n++;
  notice = XtCreatePopupShell("notice", noticeShellWidgetClass,
                              button, wargs, n);
  /*
   * Retrieve the XtNtextArea and XtNcontrolArea widgets.
   */
  n = 0;
  XtSetArg(wargs[n], XtNtextArea, &n_textarea); n++;
  XtSetArg(wargs[n], XtNcontrolArea, &n_controlarea); n++;
  XtGetValues(notice, wargs, n);
  /*
   * Set the message and create the buttons on the notice pop-up.
   */
  XtSetArg(wargs[0], XtNstring, "Print Message?");
  XtSetValues(n_textarea, wargs, 1);
  confirm = XtCreateManagedWidget("Confirm", oblongButtonWidgetClass,
                                  n_controlarea, NULL, 0);
  cancel = XtCreateManagedWidget("Cancel", oblongButtonWidgetClass,
                                 n_controlarea, NULL, 0);
  XtAddCallback(confirm, XtNselect, confirm_callback, NULL);
  XtAddCallback(button, XtNselect, button_callback, notice);

  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void 
button_callback(w, client_data, call_data)
  Widget     w;
  XtPointer  client_data, call_data;
{
  Widget notice = (Widget)client_data;

  XtPopup(notice, XtGrabExclusive);
}

void 
confirm_callback(w, client_data, call_data)
  Widget     w;
  XtPointer  client_data, call_data;
{
  printf("Message\n");
}
