
ICE(1)                                                     ICE(1)


NAME
       ice - image composition environment

SYNOPSIS
       ice [ -display display ] [ -w width ] [ -h height ] [ -dpi
       resolution ] [ ice_file ] [ -H ] [ -ps < ps_file ]

DESCRIPTION
       ice allows collections of PostScript and raster images  to
       be composed into a merged image which may be both interac-
       tively previewed and saved to a file. The program operates
       under  the  Sun  X11/NeWS  window system on both color and
       monochrome displays. (Monochrome displays will  of  course
       result in some limitations in functionality, but may still
       be quite useful in many instances.)

OPTIONS
       -display display
              Use the named X11 display device.

       -w width
              Specify the width in inches of the composite image.

       -h height
              Specify  the  height  in  inches  of  the composite
              image.

       -dpi resolution
              Specify the resolution in dots per inch of the com-
              posite image.

       ice_file
              Initialize  the  composite  image  and  all program
              defaults by reading the named ICE file  at  startup
              time.  (This file must have been created via one of
              the program's Dump options at some previous  time.)

       -H     Display help information.

       -ps    Initialize the composite image by reading an exter-
              nal PostScript document from stdin at startup time.
              The contents of stdin will be stored in a temporary
              file named 'StdInput' in either the current  direc-
              tory, or, if the environment variable ICETMPDIR has
              been set, in the directory $ICETMPDIR.

USAGE
       ice always displays its page window, which is used to show
       the  user's  composite  image. Other secondary windows are
       displayed from time to time, generally in response to var-
       ious user requests to modify some attribute of the compos-
       ite image or one of its components.  A  popup  menu  which
       provides  access to all of the program's functionality may
       be invoked by depressing the right mouse button while  the



                           28 June 1990                         1





ICE(1)                                                     ICE(1)


       cursor is positioned over the page window.

       There  are two basic classes of external graphical objects
       which may be imported into ice --  single-page  PostScript
       documents  and  Sun rasterfiles, both of which must reside
       in pre-existing files. ice  can  also  manipulate  several
       classes  of  internally created PostScript-based graphical
       objects, including text, vectors, curves, markers, rectan-
       gles,  polygons and axes. All of these external and inter-
       nal objects are maintained  on  a  single  list  which  is
       ordered by sequence number.

       Each object has its own sequence number, which is initial-
       ized to 0 but may be changed by  the  user  to  any  other
       integer  (including  negative  integers) at any time. When
       the composite image is rendered on the display  or  dumped
       to  a  file,  objects with higher sequence numbers will be
       drawn after, and therefore  overlay,  objects  with  lower
       sequence  numbers.  There  is no guarantee of the order in
       which objects with  identical  sequence  numbers  will  be
       drawn.

       Any  collection  of  these  individual  objects  (known as
       atomic objects) may be combined into  a  single  composite
       object,  thus  enabling various operations to be performed
       on the group as a whole. Composite objects may be  further
       grouped into larger composite objects.

       In  addition  to  the  aforementioned classes of graphical
       objects, there is a special class of  non-visible  objects
       known as path objects. This class is essentially an imple-
       mentation of the PostScript path concept, and is available
       for  the control of various aspects of the display of cer-
       tain visible objects.

       The following paragraphs describe the purpose of all  menu
       options.  Note that in many cases, operations which modify
       an existing object may be initiated either by referring to
       the  object's name as explicitly listed in the menu system
       or by selecting the object by  pointing  at  it  with  the
       mouse  and  clicking any mouse button. Object selection is
       made by choosing the object whose origin location is clos-
       est  to  the  location pointed to by the mouse. (Composite
       objects have no origin  location  of  their  own  and  are
       therefore  selected by selecting one of their atomic chil-
       dren.) Also note that most user-specifiable dimensions are
       in  points. (The point is a commonly used typographic unit
       of measurement equal to 1/72 of an inch.)

       Insert. This option invokes a pullright menu which  allows
       the user to insert various types of graphical objects into
       the composite image. In  general,  the  insertion  process
       involves  specifying  various  attributes  of  the  object
       within a temporary popup  window  and  then  locating  the



                           28 June 1990                         2





ICE(1)                                                     ICE(1)


       object  within  the  image.   The latter operation is per-
       formed in one of two ways depending upon the state of  the
       global  location  mode  (specifiable via the Attributes ->
       Page menu option). If cursor location is enabled, the user
       must  set the location by pointing and clicking the mouse.
       This is the default mode, and the details of this style of
       object  location are described below for each of the vari-
       ous  object  types.  If  text  location  is  enabled,  the
       instructions  for  object location in the following Insert
       -> [ object-type ] options should be ignored --  the  user
       will  be  prompted  to  enter as many coordinate values as
       necessary via the keyboard into a temporary popup  window.
       Certain  types  of  objects require the specification of a
       filename from which the object is retrieved. The user  may
       set  the  ICEDOCPATH  environment  variable  to  a  colon-
       separated list of directories which will be  searched  for
       such  files. If this environment variable is not set, only
       the current directory will be searched. All attributes  of
       new  objects are initialized to reasonable default values,
       but may be initialized otherwise  via  the  Attributes  ->
       Insert menu option as described below.

       Insert  -> PS Document. This option will load the contents
       of an  external  pre-existing  PostScript  file  into  the
       image.  A temporary popup window is displayed which allows
       the specification of a filename, horizontal  and  vertical
       scaling  factors,  rotation  (in  degrees counterclockwise
       from the horizontal), clipping path, a  dump  transparency
       key  (see  the  description  of  the Dump -> All -> Raster
       option below) and a sequence number. After the popup  win-
       dow  is  exited,  the user must fix the origin location of
       the document's  coordinate  system  within  the  composite
       image  by moving the mouse cursor to the appropriate posi-
       tion and then clicking any mouse button. It is  frequently
       desirable  to  set  the origin location of the document to
       the lower left corner of the composite image --  this  can
       be  easily  done by depressing either the <SHIFT> or <CON-
       TROL> key while clicking any mouse button irrespective  of
       the  position  of the mouse cursor. An external PostScript
       file is essentially opaque as far  as  ice  is  concerned,
       i.e.,  it  is rendered as an atomic entity -- ice makes no
       attempt to extract any kind of  graphical  structure  from
       the  contents  of  the file. It is therefore impossible to
       interactively manipulate  any  portion  of  such  external
       files.

       Insert  -> Raster. This option will load the contents of a
       1-, 8-, 24- or 32-bit Sun rasterfile  into  the  image.  A
       temporary popup window is displayed which allows the spec-
       ification of a filename, pixel replication factor,  orien-
       tation,  display  mode, and foreground and background col-
       ors. Pixel replication allows the raster to be  scaled  by
       any  integral multiple. (The default value of 1 will cause
       each pixel of the original raster  to  be  rendered  as  a



                           28 June 1990                         3





ICE(1)                                                     ICE(1)


       single  pixel  in  the composite image. A value of 2 would
       double the width and height of the original raster,  e.g.,
       each  pixel  of  the  original raster would be rendered as
       four pixels in the composite image.) Orientation is speci-
       fied  by  setting  the Raster Origin value to either Upper
       Left (the default), Lower Left (90o counterclockwise rota-
       tion),  Lower  Right  (180o  rotation) or Upper Right (90o
       clockwise rotation). Setting Display  Mode  to  Full  will
       cause  the raster to be fully loaded into memory and shown
       on the display, while setting it to Outline will result in
       the  display of a transparent rectangle which simply indi-
       cates the location and dimension of the raster. (Note that
       color rasters can be shown on a monochrome display only in
       outline mode, and that 24- and 32-bit rasters, when  shown
       on  a color display, will be rendered in 8-bit color using
       an internal histogram-based algorithm.)  If the raster  is
       a 1-bit (monochrome) raster, the foreground and background
       colors respectively corresponding to the 1 bits and 0 bits
       in the raster can be set to any combination of RGB primary
       intensities, which may range from 0 to 255.  (The  default
       settings are black foreground and white background.) After
       the popup window is exited, the user must fix the location
       of  the  raster  within  the composite image by moving the
       mouse cursor to the appropriate position and then clicking
       any  mouse  button.  Note  that  ice  is extremely memory-
       intensive, particularly when raster  objects  are  heavily
       used.  Performance can often be improved by loading raster
       objects in outline mode and switching to full draw mode to
       completely render them only when absolutely necessary.

       Insert  ->  Text. This option will create an internal text
       object which may be used to annotate the composite  image.
       A  temporary  popup  window  is displayed which allows the
       specification of numerous attributes of the  object.   The
       Name  of the object may be declared for purposes of future
       reference via ice's menu system. The Source of the  object
       may  be  set to either Interactive (which permits the user
       to enter a single line of text into  the  Text  value)  or
       File  (which  allows  for  the specification of a Filename
       from which a larger  amount  of  multi-line  text  can  be
       read).  The family and name of the font to be used in ren-
       dering the text may be selected from a domain of available
       fonts  which  is constructed by examining the user's FONT-
       PATH and OPENWINHOME environment variables as described in
       Sun's  OpenWindows documentation.  The text size and lead-
       ing may be specified in points. (The specified leading  is
       additional  rather than absolute, e.g., to create 10 on 12
       type, Size should be set to 10 and Lead should be  set  to
       2.  Reverse  leading  is possible via the specification of
       negative lead values.) Justification mode may  be  set  to
       Flush  Left, Flush Right, Center, Justify or Path. If path
       mode is used, the name of an existing  path  object  along
       which  the  text  will be drawn must be supplied, and Path
       Offset and Letterspace values in points may also be given.



                           28 June 1990                         4





ICE(1)                                                     ICE(1)


       Foreground  and  background  colors can be specified. (The
       background is Transparent by default, but may  be  set  to
       Opaque,  which  will result in the text being drawn upon a
       minimally bounding rectangular background of an  arbitrary
       color.   An  opaque  background  may not be used with text
       which is rendered in path mode.)  Horizontal and  vertical
       scaling  factors  may  be specified to create condensed or
       extended text. The Rotation value may be used  to  specify
       an arbitrary counterclockwise rotation in degrees from the
       horizontal. A clipping path, dump  transparency  key  (see
       the description of the Dump -> All -> Raster option below)
       and sequence number may also be specified. After the popup
       window  is  exited,  the user must fix the location of the
       text object within the composite image by moving the mouse
       cursor  to  the appropriate position and then clicking any
       mouse button (unless the text is being  rendered  in  path
       mode,  in  which  case  the location is meaningless). This
       location will vertically correspond to the baseline of the
       first  line of text. For flush left and justified text, it
       will horizontally correspond to the left edge of the text.
       For  flush  right text, it will horizontally correspond to
       the right edge of the text. For  centered  text,  it  will
       horizontally correspond to the center of the text.

       Insert -> Vector. This option will create an internal vec-
       tor object which may be used  to  annotate  the  composite
       image.  A temporary popup window is displayed which allows
       the specification of numerous attributes  of  the  object.
       The  Name  of  the  object may be declared for purposes of
       future reference via ice's menu system. The Width  of  the
       vector  may  be  specified  in  points. (A width of 0 will
       cause the vector to be exactly one pixel wide at any reso-
       lution.)  The Line Style may be either Solid or Dashed. If
       the vector is to be rendered  in  dashed  mode,  the  Dash
       Style  may  be  set to either Simple or Complex. If simple
       dashes are desired, the Dash Length and Gap Length may  be
       specified  in  points.  If complex dashes are desired, the
       Dash Pattern and Dash Offset may be specified  in  points.
       (The  dash  pattern  and  offset are used to construct the
       array and offset operands of the PostScript setdash opera-
       tor.  See  the  PostScript Language Reference Manual for a
       description of these parameters.) The  Cap  Style  of  the
       vector  may  be  set to Butt, Round or Square. One or more
       triangular-shaped pointers may be  affixed  to  either  or
       both  ends of the vector by setting the Pointers attribute
       appropriately. The tip of the pointer is  located  at  the
       end  of  the  vector,  while  its  other  two vertices are
       located at points which are equidistantly offset to either
       side of a point which lies further back on the vector away
       from the pointer tip. The exact location of these two ver-
       tices  is determined by the Pointer Width, which specifies
       the distance between them, and the Outside  Length,  which
       specifies  the  distance  between the tip and the point on
       the vector equidistant from the vertices. If  the  Pointer



                           28 June 1990                         5





ICE(1)                                                     ICE(1)


       Style  is  Open, the pointer will be rendered by drawing a
       line from each vertex to the tip.  If  it  is  Closed,  an
       additional  vertex  is created on the vector at a location
       whose distance from the tip is  specified  by  the  Inside
       Length.  All  four  vertices  are  then  connected and the
       resulting polygon is filled, resulting in a  solid  arrow-
       head  shape. An arbitrary foreground color, clipping path,
       dump transparency key (see the description of the Dump  ->
       All  ->  Raster option below) and sequence number may also
       be specified. After the popup window is exited,  the  user
       must  fix the location of the origin endpoint and terminus
       endpoint of the  vector  within  the  composite  image  by
       clicking  the  mouse  at the appropriate position for each
       endpoint.

       Insert -> Curve. This option will create an internal curve
       object  (a  B'zier  curve  of  the  type  created  by  the
       PostScript curveto operator) which may be used to annotate
       the composite image. A temporary popup window is displayed
       which allows the specification of numerous  attributes  of
       the  object.  The  Name  of the object may be declared for
       purposes of future reference via ice's  menu  system.  The
       Width of the curve may be specified in points. (A width of
       0 will cause the curve to be exactly one pixel wide at any
       resolution.) The Line Style may be either Solid or Dashed.
       If the curve is to be rendered in dashed  mode,  the  Dash
       Style  may  be  set to either Simple or Complex. If simple
       dashes are desired, the Dash Length and Gap Length may  be
       specified  in  points.  If complex dashes are desired, the
       Dash Pattern and Dash Offset may be specified  in  points.
       (The  dash  pattern  and  offset are used to construct the
       array and offset operands of the PostScript setdash opera-
       tor.  See  the  PostScript Language Reference Manual for a
       description of these parameters.) The  Cap  Style  of  the
       curve  may  be  set to Butt, Round or Square. An arbitrary
       foreground color, clipping  path,  dump  transparency  key
       (see  the  description of the Dump -> All -> Raster option
       below) and sequence number may also be  specified.   After
       the popup window is exited, the user must fix the location
       of the origin endpoint, the two control  points,  and  the
       terminus  endpoint of the curve within the composite image
       by clicking the mouse at the appropriate position for each
       of the four points.

       Insert  ->  Marker.  This  option  will create an internal
       marker object, i.e., a geometric symbol, which may be used
       to annotate the composite image.  A temporary popup window
       is displayed which allows the  specification  of  numerous
       attributes  of  the  object. The Name of the object may be
       declared for purposes of future reference via  ice's  menu
       system.  The Type of the marker may be set to Square, Tri-
       angle, Circle or Cross, and indicates the geometric  shape
       which the marker will take.  The Size of the marker may be
       set to specify the radius of the object  in  points.  Each



                           28 June 1990                         6





ICE(1)                                                     ICE(1)


       marker has a Boundary around its perimeter and an interior
       Fill, either of which may be set to Opaque or Transparent.
       (Interior  fill  does  not apply to cross markers.) If the
       marker boundary is opaque, it may be drawn with any  arbi-
       trary  Boundary  Width and Boundary Color. If the interior
       fill of the marker is opaque, it may  be  drawn  with  any
       arbitrary  Fill  Color.  Horizontal  and vertical scaling,
       rotation, clipping path, dump transparency  key  (see  the
       description of the Dump -> All -> Raster option below) and
       sequence number may also be  specified.  After  the  popup
       window  is  exited,  the user must fix the location of the
       center of the marker within the composite image by  click-
       ing the mouse at the appropriate position.

       Insert  ->  Rectangle. This option will create an internal
       rectangle object which may be used to annotate the compos-
       ite  image.  A  temporary  popup window is displayed which
       allows the specification of  numerous  attributes  of  the
       object.  The  Name  of the object may be declared for pur-
       poses of future reference  via  ice's  menu  system.  Each
       rectangle has a Boundary around its perimeter and an inte-
       rior Fill, either of which may be set to Opaque or  Trans-
       parent.  If  the  rectangle  boundary is opaque, it may be
       drawn with any arbitrary Boundary Width,  Line  Style  and
       Boundary  Color.  The  Line  Style  may be either Solid or
       Dashed. If the boundary is to be rendered in dashed  mode,
       the  Dash Style may be set to either Simple or Complex. If
       simple dashes are desired, the Dash Length and Gap  Length
       may be specified in points. If complex dashes are desired,
       the Dash Pattern and  Dash  Offset  may  be  specified  in
       points. (The dash pattern and offset are used to construct
       the array and offset operands of  the  PostScript  setdash
       operator. See the PostScript Language Reference Manual for
       a description of these parameters.) If the  interior  fill
       of the rectangle is opaque, it may be drawn with any arbi-
       trary Fill Color.  The  rectangle's  initial  Dimensioning
       Mode  may  be set to either Cursor or Text. If cursor mode
       is selected, then the size and rotation of  the  rectangle
       are  set  via the cursor just after the rectangle is posi-
       tioned as described below. If text mode is selected,  then
       the Width and Height in inches of the rectangle may be set
       to any non-negative values, and the  Rotation  in  degrees
       may be entered.  Clipping path, dump transparency key (see
       the description of the Dump -> All -> Raster option below)
       and  sequence  number  may  also  be specified.  After the
       popup window is exited, the user must fix the location  of
       the  origin  corner  of the rectangle within the composite
       image by clicking the mouse at the  appropriate  position.
       The  default rotation of 0 will cause the origin corner to
       be at the lower left of the rectangle.  If  cursor  dimen-
       sioning  mode has been selected, a second mouse click will
       determine an orthogonal coordinate system about the origin
       corner  at  an arbitrary rotation, and a third mouse click
       will fix the location of the rectangle corner opposite the



                           28 June 1990                         7





ICE(1)                                                     ICE(1)


       origin corner.  The width and height of the rectangle will
       then be derived  from  the  rotation  and  the  two  user-
       specified corners.

       Insert  ->  Polygon.  This  option will create an internal
       polygon object, i.e., a set  of  arbitrary  edge-connected
       vertices,  which  may  be  used  to annotate the composite
       image. A temporary popup window is displayed which  allows
       the  specification  of  numerous attributes of the object.
       The Name of the object may be  declared  for  purposes  of
       future  reference  via  ice's menu system. The Type of the
       polygon may be  set  to  Closed  or  Open,  and  indicates
       whether  or  not  the last vertex of the polygon should be
       connected to the first vertex. Each polygon has a Boundary
       around  its  perimeter  and, if it is a closed polygon, an
       interior Fill, either of which may be  set  to  Opaque  or
       Transparent.  If the polygon boundary is opaque, it may be
       drawn with  any  arbitrary  Boundary  Width  and  Boundary
       Color.  If  the interior fill of the polygon is opaque, it
       may be drawn with any arbitrary Fill Color. Horizontal and
       vertical  scaling,  rotation,  clipping  path, dump trans-
       parency key (see the description of the  Dump  ->  All  ->
       Raster option below) and sequence number may also be spec-
       ified. After the popup window is exited, the user must fix
       the  location  of the first and subsequent vertices of the
       polygon within the composite image by clicking  the  mouse
       at  the  appropriate  positions.  The polygon must have at
       least three vertices. Fixing a vertex location by clicking
       the  right mouse button indicates that the selected vertex
       will be the final vertex of the polygon.

       Insert -> Axis. This option will create an  internal  axis
       object  which may be used to annotate the composite image.
       A temporary popup window is  displayed  which  allows  the
       specification  of  numerous attributes of the object.  The
       Name of the object may be declared for purposes of  future
       reference  via  ice's menu system. The Origin and Terminus
       values of the axis may be specified, as well as the  Type,
       which  may  be  either Linear or Logarithmic. The terminus
       value must be greater than the origin value, and both val-
       ues must be greater than 0 if the axis is logarithmic. The
       axis will be displayed as a straight line from the  origin
       to the terminus with primary, secondary and tertiary ticks
       drawn perpendicularly to the line, and  with  a  numerical
       annotation displayed opposite each primary tick indicating
       the value  at  that  point  as  interpolated  between  the
       declared  origin  and terminus values. A primary tick will
       be drawn at the origin and terminus points and at  regular
       intervals  between  those  points. The number of secondary
       and/or tertiary ticks to be  shown  between  each  primary
       tick  may be specified by declaring the number of Subdivi-
       sions. Each subdivision will be marked by a tertiary tick,
       excepting the point midway between primary ticks (when the
       number of subdivisions is even), which will be marked by a



                           28 June 1990                         8





ICE(1)                                                     ICE(1)


       secondary  tick.  The  Axis Width of the primary axis line
       may be specified in points. (A width of 0 will  cause  the
       line  to be exactly one pixel wide at any resolution.) The
       Tick Location may be set to Standard, Alternate  or  None.
       Standard  tick  location  will cause the ticks to be drawn
       beneath a horizontal axis whose origin  is  to  the  left.
       Alternate  tick  location will cause the ticks to be drawn
       above such an axis, and no tick location will inhibit tick
       display.  The  height  in points of primary, secondary and
       tertiary ticks may be independently specified, with  nega-
       tive  values causing the ticks to be drawn on the opposite
       side of the axis. The Tick Width and Axis/Tick  Color  may
       also be set. Label Location, which may be set to Standard,
       Alternate or None, declares whether or not numeric  labels
       should be displayed at each primary tick mark and on which
       side of the axis they should be drawn. The font  and  font
       size  used  to display the labels may be set via the Label
       Font and Label Font Size items. The Label Orientation  may
       be used to declare the angle and direction with respect to
       the primary axis line at which  the  label  will  be  dis-
       played.  The Label Offset indicates the distance in points
       between the label and the tick (or primary axis  line,  if
       the  tick  and  label are being drawn on opposite sides of
       the axis line). The Label Color declares the color  to  be
       used  to  draw  the  labels.  A clipping path, dump trans-
       parency key (see the description of the  Dump  ->  All  ->
       Raster option below) and sequence number may also be spec-
       ified. After the popup window is exited, the user must fix
       the  location of the origin endpoint and terminus endpoint
       of the axis within the composite  image  by  clicking  the
       mouse at the appropriate position for each endpoint.

       Insert  ->  Path. This option will create an internal path
       object (consisting of a sequence of vertices connected  by
       line  segments) which may be used to control the rendering
       of other graphical objects. A temporary  popup  window  is
       displayed  which  allows  the  specification  of  numerous
       attributes of the object. The Name of the  object  may  be
       declared for purposes of future reference by other objects
       and by ice's menu system. The Source of the  path  may  be
       set  to  either Interactive or File. If the former is cho-
       sen, the user must select the vertices of the path  inter-
       actively  by  pointing  and  clicking  the mouse after the
       popup window is exited. If  File  input  is  selected,  XY
       coordinate  pairs  will  be  read from the ASCII text file
       specified by the Filename option, one pair per  each  line
       of  the  file. The coordinates will be interpreted as pix-
       els, points, inches or user coordinates depending  on  the
       current  program  display  units  setting. The Type of the
       path may be specified as either Open or  Closed.   If  the
       path is closed, its terminating vertex is connected to its
       initial vertex. While a path object is  not  a  renderable
       entity in and of itself, its location within the composite
       image can be shown by setting the Display option  to  Yes.



                           28 June 1990                         9





ICE(1)                                                     ICE(1)


       This  will  cause  the  segments comprising the path to be
       drawn in the page window (but not in any  raster  dump  of
       the  composite  image).  After the popup window is exited,
       if the source of the path has been defined to be  interac-
       tive  the user must fix the location of the first and sub-
       sequent vertices of the path within the composite image by
       clicking  the mouse at the appropriate positions. The path
       must have at least two vertices. Fixing a vertex  location
       by  clicking  the  right  mouse  button indicates that the
       selected vertex will be the final vertex of the path.

       Insert -> ICE. This option will allow the user to read  in
       a file containing ICE directives which has been previously
       saved with one of the program's Dump menu options. An  ICE
       file  will  generally  include  a  full description of the
       state of the program's page and default attributes and all
       or part of the graphical object and path lists at the time
       of the file's creation. A temporary popup  panel  provides
       for the specification of a filename and allows the user to
       either continue  to  work  within  the  current  page  and
       default attributes or to replace those attributes with the
       attributes  contained  within  the  file.  All   graphical
       objects  and  paths described by the file will be added to
       the existing object and path lists. If the current default
       attributes  are  to  be  used, the user can decide whether
       attributes of new objects described by the file which have
       been  set  to  a global value will (i) be deglobalized and
       preserve the values at which they were  originally  stored
       into   the  file,  or  (ii)  reference  the  global  value
       described by the current default attributes.  If  the  new
       default  attributes  are  to  be used, the user can decide
       whether attributes of existing objects which have been set
       to  a  global  value will (i) be deglobalized and preserve
       their current value, or (ii) reference  the  global  value
       described by the new default attributes.

       Delete.  This option invokes a pullright menu which allows
       the user to delete various types of graphical objects from
       the composite image.

       Delete  ->  Select.  This option will delete the graphical
       object selected by the next mouse click from the composite
       image.  If  the selected object is a composite object, all
       child objects contained within it will also be deleted.

       Delete -> PS Document -> [ filename ].  This  option  will
       delete the named external PostScript file from the compos-
       ite image.

       Delete -> Raster -> [ filename ]. This option will  delete
       the  named  external  Sun  rasterfile  from  the composite
       image.

       Delete -> Text -> [ objectname ]. This option will  delete



                           28 June 1990                        10





ICE(1)                                                     ICE(1)


       the named text object from the composite image.

       Delete  ->  Vector  ->  [  objectname  ]. This option will
       delete the named vector object from the composite image.

       Delete -> Curve -> [ objectname ]. This option will delete
       the named curve object from the composite image.

       Delete  ->  Marker  ->  [  objectname  ]. This option will
       delete the named marker object from the composite image.

       Delete -> Rectangle -> [ objectname ].  This  option  will
       delete  the  named  rectangle  object  from  the composite
       image.

       Delete -> Polygon -> [  objectname  ].  This  option  will
       delete  the named polygon object from the composite image.

       Delete -> Axis -> [ objectname ]. This option will  delete
       the named axis object from the composite image.

       Delete  ->  Composite  -> [ objectname ]. This option will
       delete the named composite object and  all  child  objects
       contained within it from the composite image.

       Delete  -> Path -> [ objectname ]. This option will delete
       the named path object from the composite image. The  dele-
       tion  of  a  path which is currently referenced by another
       object will not be permitted.

       Delete  ->  All.  This  option  will  delete  all  objects
       (including paths) from the composite image.

       Attributes.  This  option  invokes  a pullright menu which
       allows the user to change various attributes of  the  com-
       posite image or its component graphical objects.

       Attributes -> Page. Change overall composite image charac-
       teristics and control settings via a temporary popup panel
       which  is  displayed when this menu option is invoked. The
       dimensions and resolution of the composite image in inches
       and  dots  per  inch, respectively, may be specified here.
       Update Mode can be toggled between Automatic,  which  will
       cause  the  on-screen  image  to  be  regenerated whenever
       objects are loaded, unloaded, modified, etc., and  Manual,
       which inhibits all image regeneration except when specifi-
       cally requested by the user via the Redisplay menu option.
       The  Location  Mode  controls the manner in which the user
       specifies page coordinates for various operations such  as
       object insertion and translation. It may be set to Cursor,
       which causes coordinate specification to be  performed  by
       positioning  the  mouse cursor to the desired location and
       clicking a mouse button, or Text, which causes such speci-
       fication  to be done by typing the desired coordinates (in



                           28 June 1990                        11





ICE(1)                                                     ICE(1)


       terms of the current display units) into  a  popup  panel.
       If cursor mode is selected, operations which involve posi-
       tioning an object cause a set of crosshairs to  track  the
       location  of  the mouse cursor within the page window, and
       display the current cursor coordinates  immediately  adja-
       cent to the center of the crosshairs. This coordinate dis-
       play, which may obscure underlying  objects  in  the  page
       window,  can  be inhibited by setting the Location Display
       appropriately. The Display Units item, which may be set to
       Pixels,  Points,  Inches  or  User Defined, determines the
       format of the (x, y) coordinate values that are  displayed
       or  requested  whenever  such  operations  involving image
       location are performed. If User Defined is  selected,  the
       user  may  specify  independent  horizontal  and  vertical
       scales in user units  per  inch,  as  well  as  a  mapping
       between inches and user units for a single reference point
       within the image. The Clipping Path item may  be  used  to
       specify  a  global  clipping  path.  The  rendering of all
       PostScript objects, both external and  internal,  will  be
       confined to the interior of this path. (Raster objects are
       not clipped.) Note that individual objects may be  further
       clipped  to  whatever  clipping path has been specified in
       their particular attribute  panels.  Object  Origin  High-
       light,  when  enabled, will cause a small square marker to
       be drawn at the origin location of each object.  This  may
       be  useful  when  attempting to select a particular object
       with the mouse from a group of closely spaced  objects.  A
       Background  Color  may be specified (default white), which
       is used to  initialize  the  composite  image  before  any
       object rendering is performed.

       Attributes  ->  Default. Change various default attributes
       for component graphical  objects  via  a  temporary  popup
       panel which is displayed when this menu option is invoked.
       These attributes include font and font size (for text  and
       axis  objects),  line  width  (for  vector, curve and axis
       objects), foreground and background colors (for monochrome
       rasters  and text, vector, curve and axis objects), marker
       type and radius  (for  marker  objects),  boundary  width,
       boundary  color  and  fill  color  (for marker and polygon
       objects)  and  dump   transparency   key   (for   external
       PostScript  documents and all internal objects). A default
       attribute value will be used by any object whose  particu-
       lar value for that attribute has been set to Default.

       Attributes  ->  Insert.  This option may be used to affect
       the initialization of attributes for new  objects  created
       by  the  Insert  -> [ object-type ] menu options described
       above. When this option is  selected,  a  temporary  popup
       panel  is  displayed  which  allows  the  user  to declare
       whether New Object Attributes  should  be  initialized  to
       Default values or to the values specified in the Last Edit
       of any object of the same type (made via either an  Insert
       -> [ object-type ] or Attributes -> [ object-type ] edit).



                           28 June 1990                        12





ICE(1)                                                     ICE(1)


       Attributes -> Select. This option may be  used  to  modify
       attributes  of the atomic graphical object selected by the
       next mouse click.

       Attributes -> PS Document -> [ filename ]. This option may
       be used to modify the scaling, rotation, dump transparency
       key or sequence number of  any  external  PostScript  file
       which has been previously loaded.

       Attributes  ->  Raster -> [ filename ]. This option may be
       used to modify the pixel replication, orientation, display
       mode  or  sequence  number  of any external Sun rasterfile
       which has been previously loaded. If the rasterfile  is  a
       1-bit  file, the foreground and background colors may also
       be modified. (Due to certain window system resource  limi-
       tations  and  implementation details, certain combinations
       of foreground and background  values  may  result  in  the
       respective  on-screen  rendering  of  foreground and back-
       ground as black and white.)

       Attributes -> Text -> [ objectname ]. This option  may  be
       used to modify the various attributes of a previously cre-
       ated text object such as font, size, scaling,  color,  the
       text itself, etc.

       Attributes -> Vector -> [ objectname ]. This option may be
       used to modify the various attributes of a previously cre-
       ated  vector object such as width, line style, dash style,
       cap style, color, etc. The origin and  terminus  endpoints
       of  the  vector  may  be moved by clicking the appropriate
       command button in  the  displayed  popup  panel  and  then
       clicking  the  mouse  at  the  desired position within the
       image.

       Attributes -> Curve -> [ objectname ]. This option may  be
       used to modify the various attributes of a previously cre-
       ated curve object such as width, line style,  dash  style,
       cap  style,  color, etc. The origin and terminus endpoints
       and the two control points of the curve may  be  moved  by
       clicking  the  appropriate command button in the displayed
       popup panel and then clicking the  mouse  at  the  desired
       position within the image.

       Attributes -> Marker -> [ objectname ]. This option may be
       used to modify the various attributes of a previously cre-
       ated  marker object such as geometric type, size, boundary
       and fill characteristics, scaling, rotation, etc.

       Attributes -> Rectangle -> [ objectname ]. This option may
       be  used  to modify the various attributes of a previously
       created rectangle object such as boundary and fill charac-
       teristics, rotation, etc.

       Attributes  ->  Polygon -> [ objectname ]. This option may



                           28 June 1990                        13





ICE(1)                                                     ICE(1)


       be used to modify the various attributes of  a  previously
       created  polygon  object such as boundary and fill charac-
       teristics, scaling, rotation, etc.

       Attributes -> Axis -> [ objectname ]. This option  may  be
       used to modify the various attributes of a previously cre-
       ated axis object such as origin and terminus values,  tick
       and  label  characteristics,  etc. The origin and terminus
       endpoints of the axis may be moved by clicking the  appro-
       priate  command  button  in  the displayed popup panel and
       then clicking the mouse at the desired position within the
       image.

       Attributes  ->  Path -> [ objectname ]. This option may be
       used to modify the closure and  display  attributes  of  a
       previously created path object.

       Translate.  This  option  invokes  a  pullright menu which
       allows the user to change the location of component graph-
       ical  objects  within  the composite image.  The manner in
       which this is done is dependent upon the  global  location
       mode.  If cursor location is enabled, an object is reposi-
       tioned by moving the mouse cursor to the appropriate loca-
       tion  and  clicking  any mouse button. If text location is
       enabled, the user will be prompted to enter the new object
       origin coordinates via the keyboard into a temporary popup
       window.

       Translate -> Select. Change the location of the  graphical
       object  selected  by the next mouse click. After selecting
       the object, the user may reposition it as described above.
       If  the  selected object is a composite object, the refer-
       ence location displayed at the center of the crosshairs in
       the  page window (or in the location popup window) will be
       that of the atomic member of that composite  whose  origin
       is  closest  to  the point at which the mouse was clicked,
       and all atomic objects contained within the composite will
       be translated relative to the reference location.

       Translate -> PS Document -> [ filename ]. Change the loca-
       tion of an external  PostScript  file  within  the  image.
       After  selecting  this option, the user may reposition the
       object.

       Translate -> Raster -> [ filename ]. Change  the  location
       of a raster within the image. After selecting this option,
       the user may reposition the object.

       Translate -> Text -> [ objectname ]. Change  the  location
       of  a  text  object within the image. After selecting this
       option, the user may reposition the object.

       Translate -> Vector -> [ objectname ]. Change the location
       of  a vector object within the image. After selecting this



                           28 June 1990                        14





ICE(1)                                                     ICE(1)


       option, the user may reposition the object.

       Translate -> Curve -> [ objectname ]. Change the  location
       of  a  curve object within the image. After selecting this
       option, the user may reposition the object.

       Translate -> Marker -> [ objectname ]. Change the location
       of  a marker object within the image. After selecting this
       option, the user may reposition the object.

       Translate -> Rectangle -> [ objectname ]. Change the loca-
       tion of a rectangle object within the image. After select-
       ing this option, the user may reposition the object.

       Translate -> Polygon -> [ objectname ]. Change  the  loca-
       tion of a polygon object within the image. After selecting
       this option, the user may reposition the object.

       Translate -> Axis -> [ objectname ]. Change  the  location
       of  an  axis object within the image. After selecting this
       option, the user may reposition the object.

       Translate -> Composite -> [ objectname ]. Change the loca-
       tion of a composite object within the image. After select-
       ing this option, the user may reposition the  object.  The
       reference   location   displayed  at  the  center  of  the
       crosshairs in the page window (or in  the  location  popup
       window)  will  be that of the first atomic object inserted
       into that composite. All atomic objects  contained  within
       the composite will be translated relative to the reference
       location.

       Translate -> Path -> [ objectname ]. Change  the  location
       of  a  path  object within the image. After selecting this
       option, the user may reposition the object.

       Copy. This option invokes a pullright  menu  which  allows
       the user to create a copy of an existing graphical object.
       The user will be prompted for the name of the new  object.
       (An  arbitrary  name will be selected if no name is speci-
       fied.) The new object must then be positioned in the  same
       manner  employed  by  the  Insert and Translate options as
       described above.

       Copy -> Select. This option will copy the graphical object
       selected  by  the next mouse click. If the selected object
       is a composite object, all child objects contained  within
       it will also be copied.

       Copy -> PS Document -> [ filename ]. This option will copy
       the object corresponding to the named external  PostScript
       file.

       Copy  -> Raster -> [ filename ]. This option will copy the



                           28 June 1990                        15





ICE(1)                                                     ICE(1)


       object corresponding to the named external Sun rasterfile.
       Note  that unlike the raster insertion process, the raster
       will be fully loaded before the location procedure is ini-
       tiated,  so  there  may  be a significant delay before the
       positioning bounding box is displayed.

       Copy -> Text -> [ objectname ]. This option will copy  the
       named text object.

       Copy  ->  Vector  -> [ objectname ]. This option will copy
       the named vector object.

       Copy -> Curve -> [ objectname ]. This option will copy the
       named curve object.

       Copy  ->  Marker  -> [ objectname ]. This option will copy
       the named marker object.

       Copy -> Rectangle -> [ objectname ]. This option will copy
       the named rectangle object.

       Copy  ->  Polygon -> [ objectname ]. This option will copy
       the named polygon object.

       Copy -> Axis -> [ objectname ]. This option will copy  the
       named axis object.

       Copy -> Composite -> [ objectname ]. This option will copy
       the named composite object and all child objects contained
       within it.

       Composite. This option invokes a pullright menu which pro-
       vides access to several types of operations affecting com-
       posite objects.

       Composite  ->  Bind.  Bind a collection of existing atomic
       and/or composite objects into a new  composite  object.  A
       popup  panel  allows  the specification of the name of the
       new composite. After the popup panel is exited, the exist-
       ing objects which are to be bound together may be selected
       either by clicking the left or middle mouse  button  while
       the  cursor is positioned over them, or by using the right
       mouse button to invoke a menu which allows  the  selection
       of  objects  by  name. The selection process may be termi-
       nated either by selecting the last object to  be  included
       with  the  left  or  middle  mouse button while either the
       <SHIFT> or <CONTROL> key is depressed, or by selecting the
       Done  option  from  the  menu that is invoked by the right
       mouse button.

       Composite -> Attributes. This option invokes  a  pullright
       menu  that allows the user to change the scaling and rota-
       tion of an existing composite object as a whole via a tem-
       porary popup panel. The Scale of the object may be changed



                           28 June 1990                        16





ICE(1)                                                     ICE(1)


       by setting it to any non-zero positive number.  This  will
       cause all atomic objects belonging to the affected compos-
       ite to be resized and repositioned, using the page  origin
       at  the  lower left corner as a reference point. Note that
       scaling will not affect the internal attributes  of  child
       objects  (such  as font size, line width, etc.) unless the
       Internal Scale option is  set  to  Yes  and  the  internal
       attributes  do  not reference a global value. An arbitrary
       counterclockwise Rotation about the page origin  may  also
       be specified.

       Composite  -> Attributes -> Select. Change the scaling and
       rotation of the composite  object  selected  by  the  next
       mouse click.

       Composite  ->  Attributes  ->  [  objectname ]. Change the
       scaling and rotation of the named composite object.

       Composite -> Unbind. This option invokes a pullright  menu
       that  allows  the  user  to  unbind  an existing composite
       object  and  remove  all  association  between  its  child
       objects.

       Composite -> Unbind -> Select. Unbind the composite object
       selected by the next mouse click.

       Composite -> Unbind -> [ objectname ].  Unbind  the  named
       composite object.

       Composite  ->  Add.  This  option invokes a pullright menu
       that allows the user to add one or more new atomic or com-
       posite  children  to an existing composite object. See the
       Composite -> Bind option above for a  description  of  how
       the new child objects may be selected.

       Composite  -> Add -> Select. Add one or more new atomic or
       composite  children  to  the  existing  composite   object
       selected by the next mouse click.

       Composite  ->  Add  -> [ objectname ]. Add one or more new
       atomic or composite children to the existing named compos-
       ite object.

       Composite  -> Remove. This option invokes a pullright menu
       that allows the user to remove one or more  child  objects
       from   an  existing  composite  object.   The  association
       between the child  object  and  the  composite  object  is
       destroyed, but the child object itself is not deleted. See
       the Composite -> Bind option above for  a  description  of
       how the child objects to be removed may be selected.

       Composite  ->  Remove  -> Select. Remove one or more child
       objects from the existing composite object selected by the
       next mouse click.



                           28 June 1990                        17





ICE(1)                                                     ICE(1)


       Composite  -> Remove -> [ objectname ]. Remove one or more
       child objects from the existing named composite object.

       Colormap. The program uses one colormap for all PostScript
       images  and  1-bit  rasterfiles, and one colormap for each
       color rasterfile. Only one colormap may be active  at  any
       one  time,  meaning  that many of the objects will be dis-
       played with false colors. This option invokes a  pullright
       menu  which allows the user to activate either the default
       colormap or the colormap associated  with  any  particular
       color rasterfile which has been previously loaded.

       Colormap -> Default. Activate the default colormap to cor-
       rectly view all PostScript objects and 1-bit  rasterfiles.

       Colormap -> [ filename ]. Activate the colormap associated
       with a particular color rasterfile to correctly view  that
       raster.

       Dump.  This  option  invokes a pullright menu which allows
       the user to dump either the entirety or an arbitrary  por-
       tion of the composite image to a disk file in a variety of
       formats. An ICE format file will generally contain a  full
       description of the current page and default attributes and
       a hierarchical description of the appropriate atomic, com-
       posite and path objects. Such a file can be read back into
       the program at any  time  (via  the  Insert  ->  ICE  menu
       option) to provide a full or partial reconstruction of the
       present program environment,  object  list  and  composite
       image.  A  PostScript  format  file  will consist of fully
       self-contained PostScript descriptions of the  appropriate
       graphical  and  path objects (except rasters) suitable for
       output on any standard  PostScript  display  device.  Note
       that  (i)  ICE  directives  are  written  in  the  form of
       PostScript comments, and (ii) all input  lines  which  are
       not  ICE  directives are ignored by the Insert -> ICE menu
       option, so that it is possible to write a file  containing
       both  ICE  directives and PostScript output and have it be
       both re-readable by ice and intelligible to any PostScript
       output  device.  (PostScript-only output generated by this
       option can of course be read back into ice  as  an  opaque
       external PostScript document, but all distinctions between
       separate graphical objects will be irretrievably lost.)  A
       raster format file will be a Sun rasterfile version of the
       currently displayed composite image.

       Dump -> All. This option invokes a  pullright  menu  which
       allows  the  user  to dump the entire composite image to a
       disk file.

       Dump -> All -> ICE/PostScript. Dump the composite image to
       a  file in ICE and/or PostScript format. A temporary popup
       window prompts for the name of the file to be created  and
       the format of its contents.



                           28 June 1990                        18





ICE(1)                                                     ICE(1)


       Dump  ->  All -> Raster. Dump the composite image to a Sun
       rasterfile.  A temporary popup window prompts for the name
       of  the  file  to be created.  If the composite image con-
       tains no raster objects, the output file will  be  of  the
       same  depth  as  the display on which the program is being
       run, i.e., 1 bit deep for monochrome displays and  8  bits
       deep  for  color  displays.   If  the image does contain a
       raster, the output file will be made 32 bits deep to avoid
       potential  conflicts  between  raster  object colormaps as
       well as the colormap used by the  server  to  perform  all
       PostScript  rendering.  Note that while raster objects are
       always dumped in full color, PostScript objects  can  only
       be  rendered  in  monochrome  by  the  NeWS  server  on  a
       monochrome display, and hence will be dumped in monochrome
       as  well  as previewed in monochrome! The user should also
       be aware that image dumps are very time-consuming, partic-
       ularly   when  both  PostScript  and  raster  objects  are
       involved. This problem can be minimized by using identical
       or  adjacent  sequence  numbers  and identical dump trans-
       parency keys for as many PostScript objects  as  possible.
       The  following  discussion, which applies only to the cre-
       ation of 32-bit output files, supplies further information
       on the process of dumping a composite image which contains
       both PostScript and raster objects, and explains how  dump
       transparency  keying  affects  both  the appearance of the
       final output raster as well as the efficiency  with  which
       it can be generated.  As mentioned above, ice maintains an
       ordered internal list of the graphical objects which  make
       up  the  composite  image. This list, which determines the
       order in which the objects are rendered, is  ordered  pri-
       marily  by  object  sequence  number  (from  low to high).
       Within each sublist made  up  of  objects  with  identical
       sequence  numbers,  there  is a secondary ordering by dump
       transparency key. (Raster objects have no such key and are
       placed  at  the  end  of  each  sublist.)  For  PostScript
       objects, the dump  transparency  key  represents  a  color
       which  is  considered to be transparent when a raster dump
       is performed, and which allows any underlying  color  from
       either the page background or a previously rendered object
       to pass through. A 32-bit raster dump is done as  follows.
       (1)  Dump memory for the output raster is created and ini-
       tialized to the  background  color  defined  in  the  page
       attributes  window.  (2) The object list is traversed from
       low sequence number to high sequence number. (2-a) When  a
       PostScript object is encountered, (2-a.1) a maximal set of
       PostScript objects contiguous within the object list  with
       dump  transparency  keys  identical to that of the encoun-
       tered object is constructed, (2-a.2) a scratch image  mem-
       ory  is  initialized  to  the dump transparency key of the
       objects in the set, (2-a.3) all objects  in  the  set  are
       drawn  into the scratch image memory in the order in which
       they appear on the object list, and (2-a.4) each pixel  in
       the  scratch  image  memory  which  is not set to the dump
       transparency key is copied into  the  dump  memory.  (2-b)



                           28 June 1990                        19





ICE(1)                                                     ICE(1)


       When  a raster object is encountered, it is drawn directly
       into the dump memory at the highest possible  bit  resolu-
       tion.  (For  instance,  if  the  original  rasterfile is a
       24-bit file, the original 24-bit colors  will  be  dumped,
       not the approximated 8-bit colors which are used to render
       the on-screen image on an 8-bit color display. If the file
       is a 1-bit file, the 24-bit foreground and background col-
       ors specified in the raster attributes panel will be  used
       in  the  output  image.  Even on a monochrome display, all
       raster objects are dumped in full color.) Finally, (3) the
       dump memory is copied to the output file and then freed.

       Dump -> Select. Dump the object selected by the next mouse
       click into a file in ICE and/or PostScript format. A  tem-
       porary popup window prompts for the name of the file to be
       created and the format of its contents.  If  the  selected
       object  is  a  composite  object, all of its child objects
       will be dumped as well.

       Dump -> PS Document -> [  objectname  ].  Dump  the  named
       external  PostScript  object  into  a  file  in ICE and/or
       PostScript format. A temporary popup  window  prompts  for
       the  name  of the file to be created and the format of its
       contents.

       Dump -> Raster -> [ objectname ]. Dump the named  external
       raster object into a file in ICE format. A temporary popup
       window prompts for the name of the  file  to  be  created.
       (ice  does not currently dump raster objects in PostScript
       format.)

       Dump -> Text -> [ objectname ]. Dump the named text object
       into  a  file in ICE and/or PostScript format. A temporary
       popup window prompts for the name of the file to  be  cre-
       ated and the format of its contents.

       Dump  ->  Vector  -> [ objectname ]. Dump the named vector
       object into a file in ICE and/or PostScript format. A tem-
       porary popup window prompts for the name of the file to be
       created and the format of its contents.

       Dump -> Curve -> [ objectname  ].  Dump  the  named  curve
       object into a file in ICE and/or PostScript format. A tem-
       porary popup window prompts for the name of the file to be
       created and the format of its contents.

       Dump  ->  Marker  -> [ objectname ]. Dump the named marker
       object into a file in ICE and/or PostScript format. A tem-
       porary popup window prompts for the name of the file to be
       created and the format of its contents.

       Dump -> Rectangle -> [ objectname ]. Dump the named  rect-
       angle  object into a file in ICE and/or PostScript format.
       A temporary popup window prompts for the name of the  file



                           28 June 1990                        20





ICE(1)                                                     ICE(1)


       to be created and the format of its contents.

       Dump  -> Polygon -> [ objectname ]. Dump the named polygon
       object into a file in ICE and/or PostScript format. A tem-
       porary popup window prompts for the name of the file to be
       created and the format of its contents.

       Dump -> Axis -> [ objectname ]. Dump the named axis object
       into  a  file in ICE and/or PostScript format. A temporary
       popup window prompts for the name of the file to  be  cre-
       ated and the format of its contents.

       Dump  ->  Composite -> [ objectname ]. Dump the named com-
       posite object and all of its children into a file  in  ICE
       and/or PostScript format. A temporary popup window prompts
       for the name of the file to be created and the  format  of
       its contents.

       Dump -> Path -> [ objectname ]. Dump the named path object
       into a file in ICE and/or PostScript format.  A  temporary
       popup  window  prompts for the name of the file to be cre-
       ated and the format of its contents. Note that the current
       page  and default attributes are not dumped by this option
       as they have no effect upon paths.

       Redisplay. Force a complete regeneration of the  on-screen
       composite image display.

       Exit. Exit the program.

ENVIRONMENT
       A  number  of environment variables may be used to control
       the operation of the program.

       NEWSSERVER
              This value is used to specify the  NeWS  server  to
              which the program should connect. Its use is manda-
              tory unless the program has been invoked  with  the
              -display  option, in which case it will be ignored.
              In most  cases  it  is  automatically  set  by  the
              X11/NeWS server startup sequence.

       OPENWINHOME
              This value is used to determine the location of the
              OpenWindows fonts.  The use of  either  OPENWINHOME
              or FONTPATH is mandatory.

       FONTPATH
              This  value  is  used  to  override the OPENWINHOME
              variable with regard to the location of  the  Open-
              Windows  fonts.  The  use  of either OPENWINHOME or
              FONTPATH is mandatory.





                           28 June 1990                        21





ICE(1)                                                     ICE(1)


       ICEDOCPATH
              This colon-separated list of  directories  will  be
              searched  any  time  the  user  requests  that some
              external file (e.g., PostScript file or Sun raster-
              file)  be  read. If it is not set, only the current
              directory will be searched.  A valid example  would
              be .:$HOME/psfiles:$HOME/rasters.

       ICETMPDIR
              This  directory will be used to store the temporary
              file created by using the -ps option. If it is  not
              set, the current directory will be used.

X DEFAULTS
       The  following  X11  defaults  may  be used to control the
       operation of the program.

       LXTInternalBorderWidth
              Set the internal border width of all top-level win-
              dows.  This  is  advisable when running the program
              under the OpenWindows 2.0 olwm(1) window manager on
              a monochrome system. (Default is 0.)

       Geometry
              Set  the  initial size of the top-level window con-
              taining the page display.  (Default is 600x600.)

       Font   Set the font to be used for all menus and  interac-
              tive panels. (Default is 8x13.)

       BorderWidth
              Set  the  border width to be used for all top-level
              windows. Note that this value  is  ignored  by  the
              OpenWindows  2.0 version of the olwm(1) window man-
              ager. (Default is 2.)

       Foreground
              Set the foreground color to be used  for  all  top-
              level windows. (Default is black.)

       Background
              Set  the  background  color to be used for all top-
              level windows. (Default is white.)

       Border Set the border color to be used for  all  top-level
              windows. (Default is black.)

SEE ALSO
       rasterfile(5)

BUGS
       The  handling  of text objects is rather primitive, and is
       intended to support simple annotations rather than  large-
       scale  typesetting.  In  particular,  the  handling of tab



                           28 June 1990                        22





ICE(1)                                                     ICE(1)


       characters and justified text is extremely naive.

       Raster objects are not included in PostScript dumps.

       Since all on-screen PostScript rendering is  performed  by
       the  underlying NeWS server, ice inherits any bugs present
       in Sun's PostScript rasterizer.

       Reliance on features of both the X11 and NeWS window  sys-
       tems  cause  this program to be not easily portable to any
       window system other than Sun's OpenWindows V2.

AUTHOR
       Roger Davis, June 1990.











































                           28 June 1990                        23


