/*****************************************************************************
 * scrollbar.c: Demonstrate the Scrollbar widget.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/ControlAre.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>

main(argc, argv)
  int argc;
  char *argv[];
{
  void    scrollbar_callback(), button_callback();
  Boolean verbose = FALSE;
  Widget  toplevel, con, menu_pane, scrollbar, button;
  int     n;
  Arg     wargs[2];


  toplevel = OlInitialize(argv[0], "Scrollbar", NULL, 0, 
                          &argc, argv);
  con = XtCreateManagedWidget("control", controlAreaWidgetClass,
                              toplevel, NULL, 0);
  /*
   * Create the scrollbar widget.
   */
  scrollbar = XtCreateManagedWidget("scrollbar", 
                                    scrollbarWidgetClass,
                                    con, NULL, 0);
  XtAddCallback(scrollbar, XtNsliderMoved, scrollbar_callback, 
                &verbose);
  /*
   * Get the MenuPane widget
   */
  n = 0;
  XtSetArg(wargs[n], XtNmenuPane, &menu_pane); n++;
  XtGetValues(scrollbar, wargs, n);
  /*
   * Add a button to the MenuPane and set a mnemonic
   */
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "Verify"); n++;
  XtSetArg(wargs[n], XtNmnemonic, 'V'); n++;
  button = XtCreateManagedWidget("button", oblongButtonWidgetClass,
                                 menu_pane, wargs, n);
  XtAddCallback(button, XtNselect, button_callback, &verbose);

  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void
scrollbar_callback(w, client_data, call_data)
  Widget w;
  XtPointer client_data, call_data;
{
  OlScrollbarVerify *sbv = (OlScrollbarVerify *)call_data;
  Boolean *verbose = (Boolean *)client_data;

  if(*verbose)
    printf("%s %3d, %s %d, %s %d, %s %d, %s %d, %s %4d,\n",
           "new_location", sbv->new_location,
           "new_page",     sbv->new_page,
           "ok",           sbv->ok,
           "slidermin",    sbv->slidermin,
           "slidermax",    sbv->slidermax,
           "delta",        sbv->delta);
}

void
button_callback(w, client_data, call_data)
  Widget w;
  XtPointer client_data, call_data;
{
  Boolean *verbose = (Boolean *)client_data;

  if(*verbose)
    *verbose = FALSE;
  else
    *verbose = TRUE;
}
