.\" $Id: calentool.man,v 2.3 1994/08/19 20:05:01 billr Exp $
.\"    Note: change the following string defs to match your system
.\" string to select the Courier or other constant width font:
.ds cW \\fC
.\" .ds cW \\f(CW
.\"
.\" calentool - day/week/month/year-at-a-glance calendar for XView/Open Look
.\" 
.\" Copyright 1988, 1989, 1991 by Tektronix, Inc. - All Rights Reserved.
.\" 
.\" Permission to use, copy, modify, and distribute this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Tektronix, Inc. not be used in
.\" advertising or publicity pertaining to distribution of the software
.\" without specific, written prior permission.
.\" 
.\" TEKTRONIX INCORPORATED MAKES NO REPRESENTATIONS ABOUT THE
.\" SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS"
.\" WITHOUT EXPRESS OR IMPLIED WARRANTY.  TEKTRONIX INCORPORATED
.\" DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO
.\" EVENT SHALL TEKTRONIX INCORPORATED BE LIABLE FOR ANY SPECIAL,
.\" INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
.\" LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
.\" OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Author: Bill Randle, Tektronix, Inc. <billr@saab.cna.tek.com>
.\" 
.TH CALENTOOL 1 "19 August 1994"
.ds Ps P\s-2OST\s+2S\s-2CRIPT\s+2\*R
.SH NAME
calentool - day/week/month/year-at-a-glance calendar for XView/Open Look
(the Hacker's Almanac)
.SH SYNOPSIS
.B calentool
[
.B \-b
]
[
.B \-B
]
[
.B \-d
.I date
]
[
.B \-f
.I apptsfile
]
[
.B \-h
[
.IR A | a | c | i | l | j | s
]]
[
.B \-H
[
.IR A | a | c | i | l | j | s
]]
[
.B \-I
{
.IR d | w | m | y
}]
[
.B \-i
]
[
.B \-l
[
.IR 0 | 1
]]
[{
.B \-m
|
.B \-M
}
.I userid
]
[
.B \-o
]
[{
.B \-p
|
.B \-P
}{
.IR d | w | W | m
}]
[
.B \-r
]
[
.B \-t
]
[
.B \-u
.I int
]
[
.B \-w
]
[
.B \-z
]
[
.B \-5
]
[
.B \-6
]
[
[
.B \-7
]
[
.B \-12
]
[
.B \-24
]
[
.B \-D
.I style
]
[
.B \-e
]
[
.B \-E
]
[
.B \-T
.I printdev
]
[
.B \-s
.I starthour
]
[
.B \-S
.I stophour
]
[
.B \-N
.I int
]
[
.B \-x
.I int
]
[
.I xview options
]
.SH DESCRIPTION
.I Calentool
is a day/week/month/year-at-a-glance tool.  It is a
window-based calendar; the only time you should have to type is
when entering the text for an appointment.
.I Calentool
provides for both one-time and recurring appointments, as well as notes
(appointments or reminders with no associated time).  A period of advance
warning can be specified.  A visual warning (and optional auditory bell)
are produced at the approach of a scheduled appointment.
.LP
By employing appropriate options, this tool can be used to send reminders
of appointments by
.IR mail (1),
and to examine colleagues appointment schedules.  Daily, weekly and
monthly schedules
can be sent to a \*(Ps printer.  Outdated appointments can be sent
automatically to an archival file.  An extensive set of files containing
commemorative dates is included, as well as a library of routines which
computes the dates of various holidays which do not fall on fixed days
of the Gregorian calendar (including religious holidays and astronomical
events).  Lunar and solar almanacs are also included.
.LP
Although to take full advantage of
.I calentool
you should be operating within the X11 or XNeWs environment, the
.BR \-m ,
.BR \-M ,
.BR \-p ,
.BR \-P ,
and
.B \-T
options allow the Hacker's Almanac to be employed even from ordinary terminals.
The accompanying utilities
.IR cal2ct (1L),
.IR month2ct (1L),
and
.IR mt2ct (1L),
transform appointment files in
.IR calendar (1),
.IR month (1L),
and
.IR monthtool (1L)
formats to
.I calentool
format.
.LP
Instructions appear in the section DETAILED INSTRUCTIONS, which follows the
OPTIONS section.
.SH OPTIONS
.I Calentool
accepts standard
.I xview
command line options at the end of the command line. As well as the X11
options -fg, -bg, and -geometry.  In addition, most options are also settable
in the .Xdefaults file.
.TP 15
.B \-b
When an appointment is pending, a bell character (along with the appointment
message) is sent to the console; only one reminder is sent for each
appointment.  Also, place a copy of the appointment text in the file
.IR $HOME/.msgfile .
The text in this file is displayed by the screen lock program
.IR xnlock (1L);
notifying passers-by of the user's current activity.
.TP
.B \-B
Similar to
.B \-b
except that the
.I calentool
window is opened instead of writing to the console.  If both features are
desired, both options may be specified.
.TP
.BI \-d \ date
Open the calendar at the day
.IR date ,
which may take on several formats:
.RS
.TP
day of current week:
Tue, Th, fr, MONDAY
.TP
numeric dates:
DD (day DD of current month, for example 27 for the 27th of this month)
.br
MO/DD (day DD of month MO, for example 11/12 for November 12)
.br
MO/DD/YY (day DD of month MO, year YY, for example 9/1/88 for 1 September 1988).
(If the
.B \-e
or
.B \-E
options are used, the date format is DD/MO and DD/MO/YY. If the -D2 option is
used, the date format is MO-DD and YY-MM-DD.)
.TP
relative dates:
+n (n days from now, for example +1 for tomorrow)
.br
-n (n days ago, for example -1 for yesterday)
.RE
.TP
.BI \-D \ style
Set the date formatting style.  The default (-D 0) specifys typical U.S. usage,
with dates formatted as MM/DD/YY.  Style 1 is the typical (?) European usage,
with dates formatted as DD/MM/YY.  Style 2 is the ISO standard (?) format,
also used in Sweden, with dates formatted as YY-MM-DD.  This option overrides
the -E option.
.TP
.B \-e
Set European (ISO) week display format (Monday through Sunday).  When 7 day
week display is set, the display shows the days Monday through Sunday,
rather than Sunday through Saturday.  This also affects the month
and year displays.  With this option the weeks are numbered according
to ISO standard.
.TP
.B \-E
Set all European style options.  Currently, this includes:
.BR \-24 ,
.B \-D 2
and
.BR \-e .
.TP
.BI \-f \ apptsfile
Use
.I apptsfile
as the appointments file.  This is useful for seeing if
other people on the net are free to attend a meeting.
If everyone exports his appointments file (in a NFS environment) then
people can plan appointments more effectively.
.IP
File integrity can NOT be assured when this option is in use;
if two people try to write to the same appointments file at the same time, the
result could be tragic.  Only the person whose schedule is
described by a particular appointments file should have write permission for
that file.
.TP
.BI \-h " char"
Compute and display holidays which do not fall on set dates of the Gregorian
calendar.  Notes appear in the day and week displays, and marks appear in
the month and year displays.  This option is followed by a single character
which indicates which set of holidays is to be computed (the option can be
invoked multiple times on the command line).  The character codes for
supported date sets are:
.RS
.TP
.B A
Use all available date sets.  When this option is chosen, the time required
to produce a new display increases.  It becomes long for the month display
and extremely long for the year display.
.TP
.B a
Astronomical events (solstices and equinoxes).
.TP
.B c
Christian religious holidays.  These dates may be inaccurate for years
prior to the advent of the Gregorian calendar in 1582.
.TP
.B i
Islamic religious holidays.  There are different conventions used by Muslim
countries to determine the dates in the Islamic calendar; the dates computed
here may differ by 1-2 days from the locally determined date.
.TP
.B l
Lunar calendar (Chinese/Oriental) holidays (not yet implemented).
.TP
.B j
Jewish religious holidays.  These may not be accurate for years after 2000.
Also note that until recent centuries, the Jewish calendar was regulated (like
the modern Islamic calendar) by sightings of the crescent Moon, so that
dates for previous years must be interpreted with caution.
.TP
.B s
US Secular holidays.
.RE
.TP
.BI \-H " char"
Identical to the
.B \-h
option, except that computed dates are displayed only in the day and week
displays; the month and year displays are not marked for these dates.
.TP
.BI \-I " char"
Set the intial display state when the tool is first started.
The
.I d, w, m, y
modifiers start the tool displaying the current day, week, month or year,
respectively.
.TP
.B \-i
Include all outdated appointments files (files named
.IR .appointments.yy ,
where
.I yy
represents the last two digits of the appointment's year).
.TP
.BI \-l " int"
Set limit check for appointments.  If
.I int
is 0 or missing, then only the appointment time slots are checked when
determining whether to show a "no appointments" icon or a standard icon.
When
.I int
is 1, the notes are also included in the check.
.TP
.BI \-m " userid"
.PD 0
.TP
.BI \-M " userid"
.PD
Send mail listing todays appointments to the user specified by
.I userid
and exit.
.B \-m
shows all notes, while
.B \-M
does not show notes not marked for display in the month/year displays.
This feature is useful when calentool is run from
.IR cron (1),
to send yourself mail about today's appointments.  No mail is
sent about today's appointments, if there are none.
The
.B \-p
and
.B \-P
options may be used with these options to mail yourself a whole weeks
worth of appointments, e.g.:
.I
calentool -Pw -m billr.
By default, the output generated by the -[mM] command is
in ASCII.  By using the
.B \-T
option, a different output format (e.g. \*(Ps) may be chosen.  Month
output is in \*(Ps only.
.TP
.BI \-N " int"
Set the number of noteslots displayed to
.I int
slots.  This is useful if you increase the number of timeslots used
and want to keep the overall display size down.
.TP
.B \-o
Save outdated appointments to an outdated
appointments file (e.g., a file named
.IR .appointments.yy ,
where
.I yy
represents the last two digits of the appointments year).
An appointment is considered outdated at the beginning of the next
year or, if the
.BI \-x n
option is specified,
.I n
days after the appointment.
.TP
.BI \-p " char"
.PD 0
.TP
.BI \-P " char"
.PD
Print today's appointments and exit.  This is useful for reviewing
appointments from an ordinary terminal or
.IR shelltool "(1)."
The
.I d, w, W, m
modifiers select a printout of the current day, week, week or month,
respectively.  The
.I w
option prints a weeks worth starting at the beginning of the current week.
.I W
prints a weeks worth starting at the current day.
.B \-p
shows all notes, while
.B \-P
does not show notes not marked for display in the month/year displays.
No printout is provided of the current day's appointments, if there
are none.
By default, the output generated by the -[pP] command is
in ASCII, except for month printouts where the default is \*(Ps.
By using the
.B \-T
option, a different output format (e.g. \*(Ps) may be chosen.  Month
output is in \*(Ps only.
.TP
.B \-r
Open the calendar tool in read-only mode.
Appointments can be edited, but no changes will be saved.
The tool's banner strip will contain the string "[Read Only]".
This is particularly useful for inspecting other users' appointment files
with the
.B -f
option.
.TP
.BI \-s " starthour"
Set the start hour for the day and week displays to
.I starthour
hour (0 to 23).
.TP
.BI \-S " stophour"
Set the stop (end) hour for the day and week displays to
.I stophour
hour (1 to 24).  The end hour must be greater than the start hour.
If the start stop span is large, you should change the default font
to a smaller size font.  This can be done with the
.B \-Wt
SunView window option or by setting it explicity in the defaults file
(see below).
.TP
.B \-t
Display the current time below the
.I calentool
icon (no further need for
.IR clocktool (1)).
.TP
.BI \-T " device"
Use
.I device
as the output format for printing or mailing appointments.  The default
is ASCII.  The only currently supported option for
.I device
is
.B ps
or
.B psc
which specifies \*(Ps output instead.
.TP
.BI \-u " int"
Update the time at the interval of
.I int
seconds.
.TP
.B \-w
Display the "Working!" message in the control panel during
lengthy operations.  The cursor also changes to an hourglass.
.TP
.BI \-x " int"
Expire (delete) appointment file entries if they are older than
.I int
days old.  If
.B \-o
is set, entries are moved from
the appointments file to the outdated appointments file.
Appointments in #include files and read only appointments are not
expired.  To expire included appointments,
.I calentool
must be run on the included file directly.
.TP
.B \-z
Convert appointments file used by earlier (pre 2.0) versions of
.I calentool
to the format used by the current version.  This option should be invoked only
once, the first time an old format file is read by
.IR calentool .
.TP
.B \-5
Display only five days (Monday through Friday) in the week display.  This is
useful if the installer has set the default display format to 6 or 7 days.
.TP
.B \-6
Display six days (Monday through Saturday) in the week display.  This is
useful if the installer has set the default display format to 5 or 7 days.
.TP
.B \-7
Display all seven days in the week display.  This is useful if the installer
has set the default value to 5 or 6 days.
Sunday through Saturday is the standard format.  Using the
.B \-e
or
.B \-E
options displays a Monday through Sunday format.
The 7-day display is wider than the 5-day
display, allowing longer messages to be displayed on the day page.
.TP
.B \-12
Display time in a 12-hour AM/PM format whenever practical.  This is useful
if the installer has set the default time format to 24-hour time.
.TP
.B \-24
Display time in a 24-hour format.  This is useful
if the installer has set the default time format to 12-hour time.
.LP
.SH "DETAILED INSTRUCTIONS"
.LP
Help is available for most buttons, message items, panels and the main window
by moving the cursor over the desired item and pushing the
.B Help
button (or its mapped equivalent).
.SS "Examining the calendar"
When first opened, the tool displays the appointments for a single day (today
if the
.B \-d
option has not been employed).  The day page for today is patterned.
Each appointment or reminder is shown at its start time in reverse video.
If the appointment lasts longer than 30 minutes an arrow is drawn from
the starting timeslot to the end of the appointment.
If advance warning of future appointments has been requested, a popup
display appears.  The day display containing a future appointment may be
displayed if the future appointment is selected with the
.I mouse-LB
(SELECT).
The reminder popup may be removed permanently (during this
.I calentool
session) by selecting the
.B Dismiss
option; if the
.B Keep
option is selected, the reminder window will reappear each time the current
day page is displayed.
.LP
If there are multiple appointments sharing a time slot, a
.B More
button appears to the right of the time slot.  This may be toggled repeatedly
to view each appointment in turn.  Any arrows for hidden appointments
are drawn as
.I dashed
lines to show all scheduled time at a glance.  As the
.B More
button is toggled, the arrows change state such that the new active
appointment has arrows drawn as solid lines and the previous appointment's
arrows (if any) are now dashed.
If appointment text is too wide for the
day page, scroll buttons appear to the right of the text and may be used to
view the text in its entirety.  When first displayed, all text is left
justified.
.SS "The control panel"
The control subwindow contains various control buttons and todays date and
time.  View the current week, month, or year by employing
the
.I mouse-LB
(SELECT) to select the
.BR Week ,
.BR Month ,
or
.B Year
panel buttons.  Pushing the
.I mouse-RB
(MENU) in the
.BR Day ,
.BR Week ,
.BR Month ,
or
.BR Year
panel buttons activates pull-down menus with appropriate selections (certain
of the selections may be inactivated due to the current display mode).  The
.B Today
panel button redisplays today's day page.  In each of the four display modes,
the
.B Previous
and
.B Next
panel buttons move backward or forward one day, week, month or year, as
appropriate (maintaining the current display mode).  There are also pull-down
menus associated with these buttons, produced by selecting the
.I mouse-RB
(MENU) (again, certain options may be inactivated according to the current display
mode).  The
.B Current
button displays the current day, week, month or year, depending upon the current
display mode.  A pull-down menu associated with the
.B Current
button allows selection of the current day, week, month, or year displays, or
direct entry of a specific date for which a day page is to be displayed.
The
.B Done
button closes the frame to an icon.  A pull-down menu associated with
the
.B Done
button allows selection of either closing the frame or exiting the tool.
.SS "Week, month and year displays"
In the week display, the initial part of each appointment message is visible.
If there are overlapping appointments/notes, a
.B More
button appears at the bottom of the day column, which prints a message
reminding the user to select the day display to be able to view all of the
appointments/notes.
The day strip for today, if present, is patterned.
Move the cursor over any day of the week and select the
.I mouse-LB
(SELECT) to view the indicated day display.
.LP
In the month display, a triangular hatch-mark in the
upper right-hand corner of a day indicates an appointment.
The day box for today, if present, is patterned.
Move the cursor over any day of the month and select the
.I mouse-LB
(SELECT) to view the indicated day display.  Position the cursor
over the arrow to the left of a week and select the
.I mouse-LB
(SELECT) to view the indicated week.
.LP
In the year display, a reverse-video date indicates an appointment.
Today's date, if present, is patterned.
Move the cursor over a particular month and select the
.I mouse-LB
(SELECT) to select the indicated month display.
.LP
The pulldown menu actuated within the top control bar of the window
by selecting the
.I mouse-RB
(MENU) allows the tool to be closed, moved, terminated, etc.
.SS "Lunar and Solar data"
Selection of the Sun or Moon icons in the day display reveals
information about rising and setting times, lunar phases, local
time, sidereal time, etc.  An abbreviated solar data display is shown
if the day currently being displayed is not today.
.SS "Iconic warning of an appointment"
When
.I calentool
is in iconic form, the icon is inverted to a reverse video representation
prior to a scheduled appointment and remains inverted
for the duration of the appointment.  The amount of advance warning given
is set by the
.B appointment properties
menu, with a default of 10 minutes.
.LP
When there are no appointments or notes remaining for the current day,
an alternate icon with an empty page is displayed instead of the
standard or reverse video icons.
For all icons, today's month and day of month are displayed at the
bottom of the icon's calendar page.
.SS "Entering appointments"
Appointments can only be entered in the day display.  The day display presents
a number of labeled time slots (generally 30 minute intervals) as well as a
.I notes
section at the end of the day page, to enter reminders not associated with a
specific time.  To enter an appointment, position the cursor over the required
time slot and press the
.I mouse-LB
(SELECT).
The slot is toggled to reverse video.  Leaving the cursor positioned in the
slot, type in the appropriate descriptive text.  If the text exceeds the size of the
window, scroll buttons will appear to the right.  Typing new text into the
time slot automatically right-justifies the text already present, so that the
new text is appended.  To indicate the duration of any appointment, click the
.I mouse-MB
(ADJUST)
in the initial time slot (any existing duration arrow will be deleted);
a vertical indicator arrow appears and follows the cursor.  Drag the cursor
to the location of the final time slot and release the button.
The SunView/XView L6 and L8 keys (COPY/PASTE or PUT/GET) may also be
used to paste the text from the shelf to an active appointment slot
or from an appointment slot to the shelf.  When inserting a string
in calentool using PASTE, the slot must be active first (i.e. the
.I mouse-LB
(SELECT) must have been pressed first).
.SS "Changing an appointment"
Selecting the
.I mouse-RB
(MENU)
in the highlighted time slot produces a popup menu with the options
.BR properties ,
.BR cut ,
.BR paste ,
.BR copy ,
.BR delete ,
and
.BR undelete .
To delete the current appointment, storing it in a temporary buffer,
select the
.B cut
option.  To copy the text of an appointment into the buffer without deleting
it, select
.BR copy ,
To place the text of a buffer-stored appointment into a time slot, click the
.I mouse-RB
(MENU) in the new time slot, and then select the
.B paste
option.
.LP
To delete the current appointment, select the
.B delete
option.  If the appointment in question is recurring, a special subwindow
appears which allows the user to delete (or move) every occurrence or
just today's occurrence.  If the latter is selected, the
.B undelete
option is activated, which allows today's occurrence to be reinstated.
.SS "Appointment properties"
An appointment may be further modified by selecting the
.B properties
option or pushing the Props key.
This causes a properties subwindow to appear, in which the user
may specify that the appointment is to be repeated every day, for selected
weeks of the month (first through fifth, last or every Monday thru
Friday), every month, and/or every year.  Alternatively,
the appointment may be repeated at a specified interval of days.  The user can
also specify a period of days prior to the appointment for which an
advance warning will be printed; how many times this appointment will be repeated;
and how many minutes ahead of the scheduled time the user should be
reminded about an appointment (default is 10 minutes).
For example, one could specify that a meeting is to occur
on the first and third Tuesday of the month, in perpetuity, by selecting
the repeat options
.BR "Selected Week" ,
.BR "Every Month" ,
and
.BR "Every Year" ,
as well as the selected week indicators
.B 1st
and
.BR 3rd .
After selecting the appointment options, the user can select either
.B Apply
or
.B Reset
to close the options subwindow.
.SS "Entering notes"
Entering notes is similar to entering appointments, except that no duration
arrows can be appended, and the modify panel allows the user to indicate
whether or not the note is to be used to mark the month and year displays,
or to be printed (or mailed) when the
.B \-P
(or
.BR \-M )
option is invoked.
.SS "Printing appointments"
The
.B Print
button prints a copy of the day, week, month or year display.  Pressing the
.I mouse-RB
(MENU)
over this button produces a popup menu which allows either a raster image or
a \*(Ps version of the current display to be printed.  A third option allows
modification of the default print command.  The default print command is taken from
the first provided by the following sources: the 
X Resource data base, the
.I PRINTER
environment variable, and the
.I PRINT_CMD
value provided by the system manager at the time of installation.
The printer output can also be sent to a file instead of directly to
the printer.
.SS "Saving outdated appointments"
Appointments are recorded in a file named
.IR .appointments .
If the
.B \-o
option is in effect, at the end of a year all appointments for the
past year are copied into a special file with a name
.I <appts_file>.yy
(where
.I yy
contains the final two digits of the past year).  These appointments are then
deleted from the current appointments file.  If the
.B \-x
and
.B \-o
options are in effect, expired appointments are also copied to the outdated
file, rather than being purged.
.SS "Examining other appointment files"
The
.B File
button displays a window in which an alternate
.I .appointments
file can be specified.  This is useful for maintaining multiple appointment
books or for examining colleagues' calendars.  The file can be made
read-only or read-write according to the toggle option, and a file name can
be typed into the window.  The
.B Apply
button
initiates reading of the currently displayed file, while
the
.B Original
button restores the original file name that calentool was invoke with.
The
.B Reset
button undoes any filename changes that have been made prior to
selecting
.BR Apply .
The
.B Save
button updates the current appointments file with any changes made that
have not yet been logged.
.SH "FILE FORMAT"
Using an included file (see below) is the one instance where manual editing
of the
.I .appointments
file is still required (although one could use the window-based aids of
.I calentool
to build such a file, by means of the
.B \-f
option, the include command must still be edited into the primary
appointment file).  The appointments file contains four types of lines:
.br
.nf
	\*(cW# CalenTool V2.2 - DO NOT REMOVE THIS LINE
	#include "file"
	# <comment string>
	YY MO DD HH MI AA [II] <WW> +RR %AA # \fImessage\fR
.fi
.SS Header line
The first line in an
.I appointments
file identifies the version of
.I calentool
in use.  This line should never be removed.
.SS Included appointment files
A
.B non-editable
appointments file (for example, one containing site specific holidays) can
be included.  Three formats are possbile for specifying such a file:
.br
	#include "/pathname/file"
.br
or
.br
	#include "file"
.br
or
.br
	#include <file>
.br
In the second case, the file will be prepended with the pathname used for the
appointments file.  In the last case, the included file is assumed to reside
in a system-wide library directory specified at the time of installation
(see your system administrator).  The #
.B must
start in column 1 of the appointments file.  The first line of an included file
must also have a header line.  Included files may not include other files.
.SS Comment line
A
.I #
in column one (not followed by the string "include") indicates a comment;
the rest of the line is ignored.
.SS Appointment/Note entries
All fields are separated by at least one space character.
.RS
.SS Mandatory entries
The
.I YY
field is the year (00-99), the
.I MO
field is the month (1-12) and
.I DD
is the day (1-31).  The
.I DD
field can also contain a two-character alphabetic string describing
a day of the week: Su, Mo, Tu, We, Th, Fr, Sa or MF (Monday thru Friday).
This feature is used in conjunction with wildcards (see below), and the
.I [II]
field, which must appear within square brackets, and which can contain the
digits 1-5 and the letter L, separated by commas, to indicate the first
through fifth (or last) monthly occurrence of the specified day of the week.
.I HH
and
.I MI
are the starting hour (00-23) and
minutes (00 or 30).
The
.I AA
field is the number of arrow bars (additional 30 minute
time slots) required.
.SS Notes
A
.I HH
value of 99 indicates a note, rather than an appointment,
with
.I MI
designating whether presence of the note is to be shown (marked) in the month and year
panels (00 indicates that it is to be marked, 99 indicates that it should not
be marked).
.SS Wildcards for recurring appointments/notes
A double asterisk (**) can be used in place of the year, month and/or day
fields to indicate every year, month or day.
.SS Optional entries
The
.I [II]
field appears within square brackets, and (if the DD field contains a
numerical value) is taken to be an interval in days between recurring
appointments.  The
.I <WW>
field appears within broken brackets, and indicates the number of
days of advance warning required.  The
.I +RR
field is preceded by a plus sign, and indicates the repetition count
for a given appointment.  The
.I %AA
field is preceded by a percent sign, and indicates the number of minutes
in advance of an appointment the user should be reminded.  If this field
does not exist, the default value of 10 minutes is used.
.SS Appointment text
If a # character appears in front of the text, it indicates that a recurring
appointment has been suppressed for that day.  A leading '\\' character
is prepended to a text entry that starts with special characters to
prevent the text from being misinterpreted as appointment options.
.SS Example entries
A meeting that occurs weekly at 0900 and lasts for 1 hour, starting on
April 1st, would be represented as:
.br
.nf
	\*(cW88 04 01 09 00 01 [7]        Weekly status meeting\fP
.fi
Several other examples:
.nf
	\*(cW** 04 01 99 99 00            April Fool's Day
	** ** Tu 10 30 00 [1,3]      Meeting on 1st and 3rd Tues. of Month
	** ** 01 99 00 00 <1>        First day of every month, one day warning
	88 05 ** 99 99 00            On vacation for entire month of May 1988
	89 11 06 99 00 00 +4         SigFishing Conference
	** ** MF 17 00 00            Daily backups\fP
.fi
.RE
.SH "SUPPLIED SPECIAL DATES FILES"
.I Calentool
is supplied with a number of system-wide special dates files which may be
included in a user's
.I .appointments
file:
.RS
.TP 15
ancient
Events celebrated in ancient times
.TP
can_holiday
Major Canadian holidays (holidays from work)
.TP
celtic
Holidays/events of interest to Celts
.TP
computing
Events in the history of computing
.TP
events
Historical events (major and minor)
.TP
gdead
Dates concerning the rock group Grateful Dead
.TP
hawaii
Historical events pertaining to Hawaii
.TP
literature
Historical events pertaining to literature, newspapers and comics
.TP
lives
Biographical dates of note (births, deaths, weddings)
.TP
lotr
Special dates for fans of Tolkien's
.I Lord of the Rings
.TP
movies
Historical events pertaining to motion pictures
.TP
music
Historical events pertaining to the music world (both popular and traditional)
.TP
radio
Historical events pertaining to radio
.TP
sfo
Historical events pertaining to San Francisco, CA and the surrounding area
.TP
space
Dates of note in the history of the exploration of outer space
.TP
sports
Dates concerning sports.
.TP
television
Dates concerning television programs and history of tv.
.TP
usa_holiday
Major US holidays (holidays from work)
.TP
usa_other
Minor US/Canadian holidays
.TP
usa_states
US holidays specific to selected states
.TP
witchcraft
Dates of interest to witches and warlocks
.TP
world
Holidays from countries other than the US/Canada
.RE
.SH "ENVIRONMENT VARIABLES, INITIALIZATION FILES, AND COMPILATION OPTIONS"
.LP
By default, the
.I .appointments
file employed by
.I calentool
resides
in the users' home directory.  Alternatively, the environment variable
CALENTOOL_DIR can be set to the full pathname of a directory where the
.I .appointments
file resides.
.I Calentool
must have write permission in the directory to be used.
.LP
Compile time options allow modification of the start and ending year for the
year pull-down menu, and various parameters defining the display.
.SH FILES
.TP 30
$HOME/.appointments
default appointments file
.TP
$HOME/.Xdefaults	
defaults initialization file
.TP
/tmp/appts*
default temporary appointments file, while active
.TP
$HOME/.msgfile
message file (containing current appointment) for
.IR xnlock (1L)
program
.TP
/usr/openwin/lib/calentool
default directory containing special date inclusion files
.TP
/usr/tmp/calentool.ps
default file used when \*(Ps printer File Only output is selected
.TP
/usr/tmp/calentool.ras
file used when raster printer File Only output is selected
.TP
Ct.Xdefaults
example resource entries
.SH "SEE ALSO"
cal(1), cal2ct(1L), calencheck(1L), calendar(1), clocktool(1), cron(8),
mail(1), month(1L), monthtool(1L), month2ct(1L), mt2ct(1L),
xnlock(1L), xview(1)
.SH REFERENCES
An excellent compendium which describes basic terminology of time measurement,
methods of astronomical computation, and the convoluted history of calendars:
.IP ""
The Nautical Almanac Offices of the United Kingdom and the United States of
America, \fIExplanatory Supplement to the Astronomical Ephemeris and the
American Ephemeris and Nautical Almanac\fP, Her Majesty's Stationery Office,
London, 1961 (reprinted with amendments, 1977).
.LP
The best single source for practical computations of solar and lunar data: 
.IP ""
Jean Meeus, \fIAstronomical Formulae for Calculators\fP, \fIMonografieen
over Astronomie en Astrofysica\fP, Volkssterrenwacht Urania V.Z.W.,
Mattheessensstraat 62, B 2540 Hove, Belgium, Vereniging voor Sterrenkunde
V.Z.W., Ringlaan 3, B 1180 Brussel, Belgium, Vol. 4, Derde Druk, October 1980.
.LP
Other helpful references for astronomical computations:
.IP ""
Eric Burgess, \fICelestial BASIC\fP, Revised Edition, Sybex, 1985 (cookbook
oriented, many algorithms hard to dig out of turgid BASIC).
.IP ""
Pierre Bretagnon and Jean-Louis Simon, \fIPlanetary Programs and Tables
from -4000 to +2800\fP, Willmann-Bell, 1986 (for utmost accuracy in
planetary computations).
.LP
A non-scholarly work with easily implemented algorithms for computation of
Christian and Jewish holidays and (an approximation to) the Islamic New Year:
.IP ""
Wolfgang Alexander Schocken, \fIThe calculated confusion of calendars;
puzzles in Christian, Jewish and Moslem calendars\fP, 1st Ed., Vantage Press,
New York, 1976.
.LP
Useful tables and additional information about the Islamic calendar:
.IP ""
G. S. P. Freeman-Grenville, \fIThe Muslim and Christian Calendars\fP,
Oxford University Press, London, 1963.
.IP ""
F. R. Unat, \fIHicri Tarihleri\fP, Turktarih Kurumu Basimevi, Ankara, 1959 (Turkish).
.IP ""
U. V. Tsybulsky, \fICalendar of Middle Eastern Countries\fP, Nauka
Publishing House, Moscow, 1979 (English).
.LP
Information (regrettably, not at all current) about Japanese holidays:
.IP ""
W. H. Erskine, \fIJapanese Festival and Calendar Lore\fP,
Kyo Bun Kwan, Tokyo, 1933.
.SH "CALLING ALL HACKERS"
Please help extend the special dates files and date computation library
(only carefully verified dates and algorithms, please!).  In particular, it
would be splendid if someone would expand the range of astronomical
computations, which currently include only the equinoxes and solstices;
one could add dates/times of the major meteor showers, planetary risings and
settings, etc.  Perhaps a sailing buff could build in high/low tide estimations.
The lunar calendar date computation library remains to be completed.
There are many other historical and contemporary calendrical systems we have
overlooked (Egyptian, Armenian, Babylonian, Greek, Julian, Indian, and Russian,
as well as ecclesiatical calendars such as the Alexandrian).  The present dates
library provides useful calendrical computations not currently exploited by
.IR calentool ,
such as determining the number of days, or weekdays, or Mondays
between two dates.  Perhaps a third icon could be placed next to those for
the solar and lunar almanacs, which would open a calendrical computation window.
It would be very useful if someone would write a
.IR curses (3X)
based front-end for
.I calentool
format date files for those not using
.IR suntools (1).
An efficient way of doing this might be to merge
.I calentool
with the excellent
.IR Dates (1L)
program of Dain Samples (samples@dougfir.berkeley.edu).
.LP
An SunView version of
.I calentool
is also available.
.LP
Mail suggestions, corrections, and additions for the Hacker's Almanac to
Bill Randle (billr@saab.CNA.TEK.COM).
.SH BUGS
Without a doubt, but hopefully pretty minor.
.SH CAUTIONS
Note that the dates computed here are for the Gregorian calendar, which
was a modification of the Julian calendar first introduced in 1582.
Countries have adapted this system as recently as 1927 (Turkey), and in
some countries it is used as a civil calendar in co-existence with a separate
indigenous calendar system.  Apply caution in using computed dates for
non-recent years and non-European countries.
.SH AUTHORS
The original suntools version of
.I calentool
was contributed to the Sun User Group tape (17 April 1987) by
Philip Heller (Sun Microsystems, heller%terrapin@sun.COM).  Sun Microsystems
owns this program, but has no interest in maintaining it.
.LP
Extensive corrections and additions have been executed by
Bill Randle (Tektronix, Inc., billr@saab.CNA.TEK.COM); it is likely that
Phil Heller would recognize little of the current program!
R. P. C. Rodgers (rodgers@maxwell.mmwb.ucsf.edu, School of Pharmacy,
University of California, San Francisco) performed extensive beta
testing, made numerous design suggestions, and contributed the holiday
computation library, icons, manual pages, and special dates files for later
SunView versions.  The initial
set of special dates files were modified from earlier net postings contributed
by Rich Kulawiec (rsk@boulder.Colorado.EDU) and
Dick Wexelblat (...decvax!ittvax!wxlvax!rlw), assisted by the following
contributors known only by their network addresses:
(ittvax!decvax!harpo!eagle!mhuxl!ihnp4!ihuxw!pector),
(ittvax!bunker!dick),
(decvax!sii!mem),
(ittvax!decvax!bellcore!yquem!psl),
(seismo!rochester!rocksvax!sunybcs!colonel),
and
(decvax!seismo!rochester!ritcv!ccieng5!ccieng6!wla),
in addition to others whose identifications have been lost (speak up!).
More dates were obtained from "Today in History" by Robert Heckendorn
at Hewlett-Packard in Fort Collins, Colorado (robert@fc.hp.com) for
which the conversion to calentool format was done by Larry W. Virden
(lwv27%cas.BITNET@CUNYVM.CUNY.Edu).
.LP
We thank Dr. Omar Afzal of Cornell University (Chairman of the Committee
for Crescent Observation) for his help in implementing the Islamic date
computations.
The lunar computations were adapted from a network posting of John Walker
of Autodeck, Inc. (Sausalito, CA, sun!acad!kelvin), the solar computations
were adapted from a network posting of Marc T. Kaufman (Los Altos, CA),
the raster to \*(Ps conversion was adapted from a network posting
by Glenn Boysko of Case Western Reserve University and the pcal code
for printing the pretty month calendar was adapted from a network
posting by Ken Keirnan of Pacific Bell.
.LP
Paul Blumstein (Citicorp/TTI, paulb@harley.tti.COM),
Mark Feblowitz (GTE Laboratories, mdf0%shemesh@gte.COM), 
Dennis Calkins (Teradata Corp., tdat!dc1@suntzu.sun.com),
Hakan Kallberg (Simulina AB, hk@simulina.se),
Baron O.A. Grey (UCLA, baron@lanai.cs.ucla.edu),
Matt Landau (BBN Laboratories, mlandau@bbn.COM),
David St. Pierre (Pacific Bell, david@pbsaint.PacBell.COM),
Casey Leedom (Lawrence Livermore Laboratories, casey@lll-crg.llnl.GOV),
and Alfred Correira (UniSQL, Inc. alfred@unisql.uucp)
also provided useful suggestions, patches and feedback on previous releases,
as did many others.
.LP
Additional special thanks for the XView port go to
Randy Thomas (rjt@sedist.cray.COM) who did
the first XView port of calentool 2.1 and has greatly assisted in
debugging the current version, Swen Thuemmler (swen@uni-paderborn.de)
who did an independent
port of 2.1 from Randy's, Doug Eldred (eldred@hare.udev.cdc.COM)
who helped me out with some
X and XView questions along with valuable early testing, and many, many
others who have assisted with valuable alpha and beta testing of the XView port.
.\" end of man page
