.TH pan l "July 2, 1991"
.SH NAME
pan \- Post A Note Open Look program
.SH SYNTAX
\fBpan\fP [args...]
.SH DESCRIPTION
The \fBpan\fP program keeps track of multiple text notes.  Each note
has its own window and associated attributes.  The position, size, and
visibility of each note is maintained across invocations along with the
note text.
.LP
A note may be in one of three states: Visible, Hidden, or Veiled.
A visible note has a window mapped to the display.  A hidden note is not
mapped to the display.  A veiled note is a note which has been dismissed
via the window manager's window menu.  It is not mapped, but the permanent
state is still "Visible".  This feature allows a note to be unmapped, but
made visible automatically upon the next invocation of \fBpan\fP.  A veiled
note may be exposed just like a hidden note.
.LP
The \fBpan\fP program accepts all standard Open Look command line arguments.
.LP
In addition, \fBpan\fP accepts the following command line arguments:
.LP
\fB-d<directory>\fP
.RS
Set the initial pan directory.  This overrides the X resource
\fBinitialDirectory\fP.
.RE
.LP
All notes are automatically saved to disk when the pointer moves outside
of the note window, or upon loss of the keyboard focus.  Note that saving
to disk is only done if changes have been made.
.LP
The \fBpan\fP program has one base window from which many functions may be
accessed.  Each note consists of a separate window which may or may not be
mapped to the display.  The base window has the following buttons:
.LP
\fBNew Note\fP
.RS
Clicking on this button with mouse button 1 causes a new blank note to
be created and made visible.  This new note is created in the default folder.
.LP
Clicking on this button and holding with mouse button 3 will bring up a menu
of folders in which a new note may be created.
.RE
.LP
\fBHide Notes\fP
.RS
Clicking on this button causes all visible notes to be unmapped from the 
display.
.RE
.LP
\fBExpose Notes\fP
.RS
This button has a menu attached to it.  Clicking with mouse button 1
selects the default action.  Pressing mouse button 3 brings up
a menu.  The menu items are:
.LP
\fBAll\fP
.RS
Expose (make visible) all notes.  This option can be limited in scope via the
\fBwindowMax\fP X resource.  This is the default action.
.RE
.LP
\fB<Folders>\fP
.RS
An additional entry for each folder is displayed.  By moving the pointer right,
a menu of all hidden notes in that folder is displayed.  The first entry is
the item "All".  Selecting this will expose all notes in the folder.  This
action is also limited by the \fBwindowMax\fP X resource. The
remaining items are individual notes within the folder.
.RE
.RE
.LP
\fBAction\fP
.RS
This button has a menu attached to it.  Clicking with mouse button 1
selects the default action.  Pressing mouse button 3 brings up
a menu.  The menu items are:
.LP
\fBCreate Folder...\fP
.RS
Selecting this menu item brings up another window that allows a folder
name to be entered.  When this is done, \fBpan\fP will create a new
folder.  This is the default menu item.  This may be changed with the
\fBactionDefault\fP X resource.
.RE
.LP
\fBMove Note...\fP
.RS
This menu item will bring up a window with 3 lists.  The first list is the
folder \fBfrom\fP which to move notes.  The second list is the folder
\fBto\fP which notes will be moved.  The third list is the list of notes
in the source folder.  Select the appropriate source and destination folders,
then select the note or notes to be moved and click on the "Apply" button.  The
selected notes will be moved to the destination folder.
.RE
.LP
\fBPrint Note\fP
.RS
This menu item will bring up a menu of all folders, similar to the \fBExpose\fP
menu.  
Sliding the pointer to the right while holding
mouse button 3 down reveals a list of all notes in the selected folder.
Highlight the one
to be printed and release the mouse button to cause the note to be printed.
.RE
.LP
\fBDestroy Folder...\fP
.RS
This menu item will pop up a window with a list of all available folders.
Selecting a folder and then clicking the "Apply" button will cause all
notes in that folder to be destroyed.  The folder itself will then be
destroyed.  \fIThis is an extremely destructive function and should be
used with great care.\fP
.RE
.LP
\fBQuit\fB
.RS
Cause \fBpan\fP to exit.
.RE
.RE
.LP
\fBSearch:\fP
.RS
This is a text entry field.  It can be used to enter a regular expression.
Upon pressing the \fIreturn\fP key, \fBpan\fP will search for a note with
a title matching the RE and expose it if there is a single match.  If more
than one note matches, a list window will be displayed allowing multiple
selections of notes to expose.
.RE
.LP
In addition, there is an abbreviated menu button to the right of the
\fBSearch:\fP text entry field.  Using the X resource \fBsearchMenu\fP,
a list of regular expressions may be specified from which to build a
menu.  This allows shortcut exposures without typing in the text entry
field.  Using this menu does not destroy the contents of the text entry
field.  The default menu has only 1 regular expression: '.'.
.SH NOTE WINDOWS
Each note window contains the following items:
.LP
\fBTitle\fP
.RS
This is a scrolling text entry item.  A note title may be entered here.  \fBThe
title does not become active until the return key is pressed.\fP
.RE
.LP
\fBHide\fP
.RS
Clicking on this button will cause this note to be hidden.
.RE
.LP
\fBAction\fP
.RS
This is a menu button.  Clicking on it with mouse button 1 will cause the
default menu item to be selected.  Clicking on it with mouse button 3 will
display a menu with the following items:
.LP
\fBPrint\fP
.RS
This item will cause the note to be printed.
.RE
.LP
\fBWidth <n>\fP
.RS
This item will cause the note's width to expand so the text subwindow can
accommodate at least \fB<n>\fP characters before wrapping.  See the X
resource \fBsetWidth\fP for a more detailed explanation.
.RE
.LP
\fBDestroy\fP
.RS
This menu item will cause this note to be destroyed.  There is
no way to recover a note after this action is taken.
.RE
.RE
.SH RESOURCES
The \fBpan\fP program will query the X server for resource information.
The following items of information are examined by \fBpan\fP:
.LP
\fBpan.initialDirectory (string)\fP
.RS
This resource may be defined with a directory name.  \fBPan\fP will read
this directory for notes upon startup instead of reading the default directory.
Note that the \fB-d\fP command line argument can override this.
.LP
The current default directory is "$HOME/.pan".  It will be created 
automatically by \fBpan\fP if necessary.  Note that a directory other than the
default will \fBnot\fP be automatically created.
.RE
.LP
\fBpan.printCommand (string)\fP
.RS
This resource may be defined to be a command that will cause a note to
be printed.
.LP
The current default command is "/usr/ucb/lpr $FILE".  Another command, including
flags may be substituted.  Two special variables are available:  $FILE, and 
$NOTETITLE.  The first will contain the full path and file name of the note
selected to be printed.  The second will contain the full title of the note
selected to be printed.  If a postscript printer is available, a nicely
formatted printout may be obtained by using 'mp -o -s "$NOTETITLE" $FILE | lpr'.
Don't include the single quotes in the .Xdefaults file.  I use them for
emphasis only.
.RE
.LP
\fBpan.confirmDestroy (boolean)\fP
.RS
This resource controls whether \fBpan\fP will display a confirmation notice
when the destroy button on a note is selected.
.LP
The default value is False.
.RE
.LP
\fBpan.noticeBeep (boolean)\fP
.RS
This resource controls whether notices displayed by \fBpan\fP will be 
accompanied by an audible beep.
.LP
The current default is True.
.RE
.LP
\fBpan.iconTransparent (boolean)\fP
.RS
This resource controls whether or not the icons used by \fBpan\fP have
a transparent background.  It is retained for backwards compatibility.
Icon masks are now used, so this attribute currently has no effect.
.LP
The default value is False.
.RE
.LP
\fBpan.folderOrder (string)\fP
.RS
This is a string resource.  It consists of a comma separated list of folder
names.  This resource allows the order in which folders appear in the menus
to be specified.  Any folders not explicitly mentioned are added to the
end of the list in the order in which they are encountered when reading
the directory.
.LP
The default value is "Miscellaneous".
.RE
.LP
\fBpan.defaultSearch (string)\fP
.RS
This resource allows the specification of a default search string to appear
in the "Search:" field in the base window.
.LP
The default value is "".
.RE
.LP
\fBpan.folderInTitle (boolean)\fP
.RS
This resource specifies whether or not to display a note's folder name along
with the note title in the window manager's title bar.
.LP
The default is False.
.RE
.LP
\fBpan.textFont (string)\fP
.RS
This resource allows the specification of an alternate font to be used in
the text subwindow.  I highly recommend using a fixed with font in this
resource if the \fBWidth\fP menu item on a note is to be used.  I have found
that a good font is "8x13".  (Quotes for emphasis only.)
.LP
The default font if this resource is not set is chosen by the XView toolkit,
and depends upon the -scale option.
.RE
.LP
\fBpan.windowMax (integer)\fP
.RS
This resource limits the number of windows that may be exposed as the result
of a single expose action.  If the number would be exceeded, and the expose
action is interactive, a confirmation notice is posted before \fBpan\fP
will continue the operation.  If the operation is from the pan control
language, \fBwindowMax\fP notes are exposed, then the action is halted
silently.
.LP
Use a value of -1 to disable this feature.  A value of 0 will cause
confirmation to occur for every expose action.  Any other value will allow
that many notes to be exposed before confirmation is requested.
.LP
The default value is 20.
.RE
.LP
\fBpan.actionDefault (string)\fP
.RS
This resource allows the default menu item on the \fBAction\fP menu button
on the main \fBpan\fP window to be chosen.  This option is case sensitive
and the value must be spelled exactly as seen in the menu including the
periods.
.LP
The default value is "Create Folder...". (Quotes for emphasis only.)
.RE
.LP
\fBpan.menuTextLength (integer)\fP
.RS
This option specifies the maximum number of characters of the note titles that
will appear in the \fBExpose Notes\fP and \fBPrint Note\fP menus.  This allows
for more or less of a title to be displayed in a menu.  Note that by default
the font used in menus is proportional.  Because of this, \fBpan\fP will 
calculate the pixel width of a string of \fBmenuTextLength\fP characters from
the average character width, then build a specific menu item adding or
subtracting characters to get as close to the calculated value as possible.
This allows some titles to squeeze in a few extra characters, and generally
makes the menu items line up better.
.LP
The default value is 20.
.RE
.LP
\fBpan.setWidth (integer)\fP
.RS
This resource specifies the character width that a note window will be set
to when the note's \fBWidth <n>\fP menu item is chosen.  Note that this
works best if a fixed width font has been specified with \fBtextFont\fP.  The
default text subwindow font size is reported inaccurately by XView, 
(especially when -scale is used), making it difficult to accurately calculate
a proper window size.  Even with a fixed width font, the window size is only
approximate because XView provides no way that I can find to determine the
scrollbar width, or the window border widths.  See \fBtopMargin\fP for a
more detailed explanation of window border settings.
.RE
.LP
\fBpan.logging (boolean)\fP
.RS
This resource is used to prevent \fBpan\fP from creating a log file during
command execution.  See the section on \fBControl Language\fP for more
information.
.LP
The default is True.
.RE
.LP
\fBpan.topMargin (integer)\fP
.br
\fBpan.bottomMargin (integer)\fP
.br
\fBpan.leftMargin (integer)\fP
.br
\fBpan.rightMargin (integer)\fP
.RS
These resources are used to indicate the pixel widths of the window manager's
frame that is placed around pan windows.  The defaults are set to reasonable
values for \fBolwm\fP and \fBolvwm\fP.  If another window manager is used,
set these resources to appropriate values.  Failure to do this can cause
\fBpan\fP to incorrectly calculate window sizes and widget positions.
.RE
.LP
\fBpan.checkInterval (integer)\fP
.RS
This resource is used to control how often the control language file is
checked for new commands.  The value should be specified in seconds.
.LP
The default value is 60 seconds.
.RE
.LP
\fBpan.searchMenu (string)\fP
.RS
This resource may be used to specify a list of note titles that will be
used to build the shortcut search menu.  The items must be space or comma
separated, and both single and double quotes are supported in case a title
contains whitespace.
.LP
The default value is ".".
.RE
.LP
\fBpan.noteWidth (integer)\fP
.br
\fBpan.noteHeight (integer)\fP
.br
.RS
These resources are used to indicate a preferred width and height for a newly
created note.  By default, \fBpan\fP tries to create a note as small as
possible, while making sure that all buttons and text items are visible.  This
may be overridden by specifying \fBboth\fP resources.  If only one is 
specified, it is ignored.  The values for both are specified in terms of
pixels.  Note that if these resources are used, \fBpan\fP will not be
able to adjust automatically to the use of the -scale option.
.LP
The default value for both is -1 which means \fBpan\fP will determine the
appropriate size based on the scale and the fonts requested.
.RE
.LP
.SH CONTROL LANGUAGE
New to \fBPan V3.0\fP is a command line interface and general control
language.  Most of the features available in \fBpan\fP through the
windowing interface can now be used from the command line via a
program called \fBpancmd\fP.  See the manual entry for \fBpancmd\fP
for more information on how to use the command.  This section describes
the actual control language since it is part of the \fBpan\fP program.
.LP
The following actions are supported by the control language:
.LP
.RS
o Note Creation
.br
o Note Exposure
.br
o Note Hiding
.br
o Note Veiling
.br
o Note Printing
.br
o Note Movement Between Folders
.br
o Folder Creation
.br
o Pan Process Exit
.LP
.RE
Note that no destructive commands have been implemented.  The following is
a list of the commands and their syntax.  The convention I use in describing
the syntax is to surround optional arguments with "[]", and to indicate
user required parameters with "<>".
.LP
When specifying a parameter for a command, if whitespace must be embedded,
single or double quote marks may be used around the parameter.
.LP
\fBNote Creation\fP
.RS
newnote [folder <folder>] [title <title>] [size <width> <height>]
.br
	[location <x> <y>] [hidden|visible|veiled] [file <name>]
.LP
This command causes \fBpan\fP to create a new note.  All parameters are
optional.  If no parameters are specified, the default action is to create
a note as if the "New Note" button had bee clicked on with mouse button 1.
.LP
The folder and title options may be used to specify the note's folder and
title respectively.  The size and location options will control the note's
size and location respectively.  The parameters for these options are to
be specified in pixels.  By default, a new note is visible, but any of the
three states may be specified for the note.  The optional file parameter
specifies a full path name of a file from which the contents of the note
are to be loaded.
.LP
Example:
.LP
.RS
newnote title Termcap size 500 200 location 10 10 visible
.br
	file /etc/termcap
.RE
.RE
.LP
\fBNote Exposure\fP
.RS
expose title <title RE> [windowmax <max # to expose>]
.LP
This command causes \fBpan\fP to expose all notes (up to the X resource
\fBpan.windowMax\fP) with titles that match the given regular expression.
If the windowmax parameter is given, it temporarily overrides the maximum
set in the X resource database.
.LP
Example:
.LP
.RS
expose title "Phone Numbers"
.RE
.RE
.LP
\fBNote Hiding\fP
.RS
hide title <title RE>
.LP
This command will cause all notes with titles matching the given regular
expression to be hidden.
.LP
Example:
.LP
.RS
hide title "To Do List"
.RE
.RE
.LP
\fBNote Veiling\fP
.RS
veil title <title RE>
.LP
This command will cause all notes with titles matching the given regular
expression to be veiled.
.LP
Example:
.LP
.RS
veil title "Meeting Tomorrow"
.RE
.RE
.LP
\fBNote Printing\fP
.RS
print folder <folder> title <title RE>
.LP
This command will cause all notes within the specified folder that have
titles matching the given regular expression to be queued for printing.
In order to not overload the computer, \fBpan\fP will start only one
print command (specified by the X resource \fBpan.printCommand\fP) at a time.
When the print process exits, the next matching note will be queued.  This
queuing process is done asynchronously in the background so that the \fBpan\fP
process can still respond to other commands and user interaction.
.LP
Example:
.LP
.RS
print folder Reference title .
.RE
.RE
.LP
\fBNote Movement Between Folders\fP
.RS
move source <folder> title <title RE> destination <folder>
.LP
This command will move notes between folders.  All notes with titles matching
the given regular expression in the source folder are moved to the destination
folder.
.LP
Example:
.LP
.RS
move source Miscellaneous title "[Xx] [Ww]indow" destination X_Notes
.RE
.RE
.LP
\fBFolder Creation\fP
.RS
newfolder folder <name>
.LP
This command will create a new folder.  The folder name may not contain
whitespace or slash characters.
.LP
Example:
.LP
.RS
newfolder folder X_Notes
.RE
.RE
.LP
\fBPan Process Exit\fP
.RS
quit
.LP
This command causes the currently running \fBpan\fP command to exit.
.RE
.LP
.SH NOTES
The \fBpan\fP program will accept drag and drop files from the Open Look
file manager.
For this feature to work, the file icon must be dropped directly into the text
subwindow of the note.  Dropping the icon anywhere else will not have
any effect.
.LP
A late addition to this version of \fBpan\fP is the ability to drag a note
to another application.  The drag and drop target (the small square in the
upper, right-hand corner of the note windows) may be used for this purpose.
.LP
If the note file directories are examined, occasionally files with names
ending in a "%" character will be seen.  These files are created automatically
by the Open Look text subwindow package, and are simply old versions of the
note files being edited.
.SH WINDOW CLASS
\fBPan\fP supports three different window classes for use with window manager
properties such as minimal decor.  The first is "PanMain".  This is the class
for the main window.  The second is "PanNote".  This is the class for all
notes.  The third is "Pan" (assuming the executable name is not changed).
This is used for all pop up windows, such as the create folder window.
.SH FILES
Default note directory:
.RS
$HOME/.pan
.RE
.LP
Note files:
.RS
Note_%d_%d
.br
Note_%d_%d.info
.LP
where the "%d" instances are replaced by unique id numbers.
.RE
.SH FILE FORMAT
The "Note_%d_%d" file is a plain ASCII file containing the note text.  Lines
are delimited by the newline character.
.LP
The "Note_%d_%d.info" file is a plain ASCII file currently containing 3 lines.
.LP
The first line contains 4 whitespace separated numbers followed by a
text word.  The 4 numbers describe the note window's start x, start y,
width, and height.  The text word is either "VISIBLE" or "HIDDEN" describing
whether the note is mapped to the display by default or not.
.LP
The second line of the file contains the note title.
.LP
The third line is an ASCII representation of the decimal number returned 
by time(3) describing the note's creation date and time.
.LP
An example might be:
.nf

4	424	349	206	HIDDEN
Note title
664129826

.fi
.SH BUGS
Occasionally, when a new note is created, the focus is initially in the text
sub-window instead of in the title panel item.  This appears to be a problem
with XView.
.LP
Under OW3.0, if PgUp/PgDn is pressed when at the top/bottom of the file,
the window beeps as many times as
there are lines visible.  This also appears to be a problem with XView.
I have been told that there might be a patch from Sun for this problem,
but I haven't tried to verify it.
.LP
The text sub-window package in xview creates files ending with a "%" character
and doesn't delete them.  Periodically it is a good idea to remove them by
hand to recover disk space.  If you accidentally destroy a note that had
text in it, you \fImight\fP be able to recover the text by looking through the
files ending with a "%" character.
.SH ACKNOWLEDGEMENTS
My thanks to the many people who submitted bug reports and requests for
enhancements.  I have tried to incorporate as many of the ideas I received
as possible into version 3.0 of \fBPan\fP.  I'm not listing specific names
here because I didn't keep track of the people, just the requests.  Sorry.
Next time I'll keep the names too.
.LP
If you don't find your enhancement request in this release, don't despair!
I was unable to include everything I wanted to because of the demands of
my real job.  If you don't see it, and you still want it, feel free to
request the feature again.
.SH AUTHOR
Jeffrey Bailey
