/*****************************************************************************
 * rectbutton.c: Demonstrate the RectButton widget.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/ControlAre.h>
#include <Xol/RectButton.h>

main(argc, argv)
  int     argc;
  char   *argv[];
{
  Widget  toplevel, con, button;
  int n;
  Arg wargs[2];
  void quit_callback(), button_callback();

  toplevel = OlInitialize(argv[0], "Rectbutton", NULL, 0, 
                          &argc, argv);
  con = XtCreateManagedWidget("con", controlAreaWidgetClass, 
                              toplevel, NULL, 0);
  /*
   * Create RectButton widget and add callbacks.
   */
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "NOT Set"); n++;
  button = XtCreateManagedWidget("button",  rectButtonWidgetClass,
                                 con, wargs, n);
  XtAddCallback(button, XtNselect, button_callback, NULL);
  XtAddCallback(button, XtNunselect, button_callback, NULL);

  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void 
button_callback(w, client_data, call_data)
  Widget     w;
  XtPointer  client_data, call_data;
{
  Arg arg[1];
  char label[8];
  Boolean set;

  XtSetArg(arg[0], XtNset, &set);
  XtGetValues(w, arg, 1);
  sprintf(label, "%s", set ? "Set" : "NOT Set");
  XtSetArg(arg[0], XtNlabel, label);
  XtSetValues(w, arg, 1);
}
