.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkBgnBun.man,v 2.1 1994/04/21 00:29:17 kuma Exp $ NEC;
.TH "RKBGNBUN" "3"
.SH "NAME"
\f4RkBgnBun\f1 / \f4RkwBgnBun\f1 \- convert the reading of a specified length to kanji
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkBgnBun(cxnum, yomi, maxyomi, mode)
int cxnum;
unsigned char *yomi;
int maxyomi;
int mode;
int RkwBgnBun(cxnum, yomi, maxyomi, mode)
int cxnum;
wchar_t *yomi;
int maxyomi;
int mode;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkBgnBun\f1 converts the reading \f2yomi\f1 with a length of \f2maxyomi\f1 bytes to kanji.  The reading kana must be adjusted on character boundaries in the EUC code.  The context enters the conversion mode, with both the current clause and the current clause set to \f40\f1.
.P
\f2RkwBgnBun\f1 is the similar function to \f2RkBgnBun\f1, but it takes wchar_t argument as \f2yomi\f1.  \f2maxyomi\f1 represents the length of \f2yomi\f1 by characters instead  of bytes.
.P
\f2mode\f1 represents the code conversion candidate to be added to each clause.  It is expressed in a bit field width, which can be set to one of the following with \f4RK_XFERBITS\f1:
.P
.RS
.IP "\f4RK_XFER\f1" 20n
Hiragana
.IP "\f4RK_HFER\f1"
Single-width character
.IP "\f4RK_KFER\f1"
Katakana
.IP "\f4RK_ZFER\f1"
Double-width character
.RE
.P
If the number of candidates available for the current clause is N, candidates are added through code conversion by reading the candidates in sequence, from candidate N to candidate N + 1, and so on, starting with the lowest-order bit field.  Candidate addition ends when the corresponding bit field equals \f40\f1.
.P
.RS
.nf
.ta 7.2c
mode	Candidate
RK_XFER	(KANJI) (HIRAGANA)
(RK_XFER << RK_XFERBITS) | RK_KFER	(KANJI) (KATAKANA) (HIRAGANA)
(RK_KFER << RK_XFERBITS) | RK_XFER	(KANJI) (HIRAGANA) (KATAKANA)
.ta
.fi
.RE
.P
The context enters the conversion mode, from \f2RkBgnBun\f1 to \f2RkEndBun(3)\f1.  Conversion modes cannot be nested.
.SH "RETURN VALUE"
This function returns the number of clauses derived from conversion, or returns \f4-1\f1 if the conversion fails.
.SH "SEE ALSO"
.na
\f4RkEndBun\f1(3)
.ad
