.TH AnswerGarden 1 "Release 6" "X Version 11"
.SH NAME
Answer Garden - organizational memory program
.SH SYNOPSIS
.ta 8n
\fBAnswerGarden G\fP [-\fItoolkitoption\fP ...] 
.SH DESCRIPTION
The
.I AnswerGarden
(AG) program combines elements of an information database and of a
communication system in order to create an organizational memory.  As
well, it provides the facilities to grow and correct that
organizational memory.

In AnswerGarden, users browse through an information database to find
the answer to their question.  If the answer is not there, they can
pop up a mailer and ask their question.  The system send the question
to the appropriate human expert.  The expert answers the question
(via normal email), and if the question is a commonly asked one,
can put the new question and answer in the information database,
thus growing it.

AnswerGarden is an application in the Answer Garden Substrate, which
can be used to build other organizational memory applications.

.SH OPTIONS
.I AnswerGarden
accepts all of the standard X Toolkit command line options.
.SH X DEFAULTS
This program uses the 
.I Athena Widget Set
as well as several new widget classes.  It understands all of the core resource names and classes as well as:
.PP
.TP 8
.B directory (\fPclass\fB Directory)
Specifies the location of the information database.
.TP 8
.B mailerType (\fPclass\fB MailerType)
Specifies the mail program to be used for embedded electronic mail.  Current
values are \fImh\fP and \fIbinmail\fP.  (Capitalization doesn't matter.)
The default is mh.
.TP 8
.B editMode (\fPclass\fB EditMode)
Specifies whether users can edit the nodes or not.  Values are True and False.
.TP 8
.B nStacks (\fPclass\fB NStacks)
Specifies how many stacks of nodes to have on the screen.  This mechanism
allows the user to have the nodes placed automatically in stacks of
windows.  The default is 0,
or interactive placement of windows.  See the app-defaults file for more
information on how to set up stacks.
.TP 8
.B useMail (\fPclass\fB UseMail)
Specifies whether the user is allowed to send messages from Answer Garden.
Default is True.
.TP 8
.B organization (\fPclass\fB Organization)
Specifies the name of the user's or author's organization.  Used in
locating the correct expert.
.TP 8
.B mailName (\fPclass\fB MailName)
Specifies the user's name for the mail system's use.
.TP 8
.B mailMachineName (\fPclass\fB MailMachineName)
Specifies the machine at which the user receives his mail.
.TP 8
.B domainName (\fPclass\fB DomainName)
Specifies the domain part of the machine name for machines that do not
return this value in their gethostname call.
.TP 8
.B globalExpertList (\fPclass\fB GlobalExpertList)
Specifies the default backup expert or list of experts for questions and
other communications.  Used in locating the correct expert.
.TP 8
.B localExpertList (\fPclass\fB LocalExpertList)
Specifies the default expert or list of experts for questions.  Used
in locating the correct expert.
.TP 8
.B useLocalExpert (\fPclass\fB UseLocalExpert)
Specifies whether to use the local expert list as the first line of people
to answer questions.  Default is False.
.TP 8
.B nodeExpert (\fPclass\fB NodeExpert)
Specifies the default node expert for editing purposes.
.TP 8
.B startupNode (\fPclass\fB StartupNode)
Specifies the information node to bring up as the initial node.  The default
is a node named Control. Used to customize applications or write
new applications.
.TP 8
.B rootGrapher (\fPclass\fB RootGrapher)
Specifies the information node to bring up from the initial node.  The default
is a node named RootGrapher.  Used to customize applications or write
new applications.
.TP 8
.B root (\fPclass\fB Root)
Specifies the information node to bring from the initial node.  The default
is a node named Root.  Used to customize applications or write
new applications.
.TP 8
.B numberGeneralButtons (\fPclass\fB NumberGeneralButtons)
Specifies the number of buttons on each node.  By setting this number to
be larger than the default of 3, an application writer can add buttons to
each and every (or just some) nodes.  New buttons may be bound to callbacks
through the dynamic binding mechanism.  See the app-defaults file for
an example.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.

.SH FILES
/usr/lib/X11/app-defaults/AGS - specifies required resources
.SH "SEE ALSO"

For more information, see Mark S. Ackerman and Thomas W. Malone,
"Answer Garden: A Tool for Growing Organizational Memory",
.I Proceedings of the ACM Conference on 
.I Office Information Systems (COIS) 1990,
pp. 31-39, as well as Mark S. Ackerman, "Augmenting the Organizational
Memory: A Field Study of Answer Garden",
.I Proceedings of the ACM Conference on Computer-Supported 
.I Cooperative Work (CSCW)
.I 1994
(forthcoming).

.SH BUGS
If the user opens a node, and then either iconifies it or lowers it,
and then attempts to re-open it, 
.I Answer Garden	
will not raise the window properly under some window managers.

.I gcc 
reports bogus compile errors.
.SH COPYRIGHT
Copyright 1994, Regents of the University of California.
.SH AUTHORS
Mark Ackerman ("Ack") (University of California, Irvine)

