/*-------------------------------------------------------------*/
/*  File: dialog.c 
 *
 *  Demonstrates the use of ControlArea and TextField widgets
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/Caption.h>
#include <Xol/TextField.h>
#include <Xol/OblongButt.h>
#include <Xol/ControlAre.h>

/* Labels for the Captions */
static char* fields[] = { "Directory:", "File:" };

/* Callback */
static void text_verify();
static void do_save();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, cap, tf, b;
    int i;

/* Create the ControlArea widget */    
    w = XtVaCreateManagedWidget("Control1",
                      controlAreaWidgetClass, parent,
                      XtNlayoutType,       OL_FIXEDCOLS,
                      XtNmeasure,          1,
                      XtNalignCaptions,    True,
                      XtNtraversalManager, True,
                      XtNcenter,           True,
                      XtNsameSize,         OL_NONE,
                      NULL);

/* Add the Textfield widgets */
    for(i = 0; i < XtNumber(fields); i++)
    {
        cap = XtVaCreateManagedWidget("caption",
                    captionWidgetClass, w,
                    XtNlabel,       fields[i],
                    NULL);

        tf = XtVaCreateManagedWidget("textfield",
                    textFieldWidgetClass, cap,
                    XtNwidth,       150,
                    XtNtraversalOn, True,
                    NULL);

        XtAddCallback(tf, XtNverification, text_verify,
                      (XtPointer)fields[i]);
    }
    
    b = XtVaCreateManagedWidget("saveButton",
                oblongButtonWidgetClass, w,
                XtNlabel,      "Save",
                NULL);

/* Add callback for the Save button */
    XtAddCallback(b, XtNselect, do_save, NULL);

    return w;
}
/*-------------------------------------------------------------*/
static void text_verify(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    OlTextFieldVerifyPointer p_verify = 
                        (OlTextFieldVerifyPointer)call_data;
    
    printf("Field %s currently has: %s\n", (char*) client_data,
           p_verify->string);
}
/*-------------------------------------------------------------*/
static void do_save(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
/* Do whatever "Save" is supposed to do. This example exits
 * when the user presses the Save button.
 */
     XCloseDisplay(XtDisplay(w));
     exit(0);
}

